/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.doubleFile;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookFileChangeListenerKt;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFileSystem;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.pom.core.impl.PomModelImpl;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Deprecated(message="Don't use it directly, use functions from JupyterFileExtensions.kt instead")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookFileEditorChangePropagator;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "<init>", "()V", "beforeAllDocumentsSaving", "", "beforeAnyDocumentSaving", "document", "Lcom/intellij/openapi/editor/Document;", "explicit", "", "isFileOrOriginModified", "notebookVirtualFileSystem", "Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "file", "Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile;", "propagateChangesFromJsonDocument", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "sourceDocument", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "jsonDocument", "writeFile", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookFileEditorChangePropagator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookFileEditorChangePropagator.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookFileEditorChangePropagator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,145:1\n24#2:146\n24#2:147\n19#3:148\n*S KotlinDebug\n*F\n+ 1 NotebookFileEditorChangePropagator.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookFileEditorChangePropagator\n*L\n56#1:146\n142#1:147\n123#1:148\n*E\n"})
public final class NotebookFileEditorChangePropagator
implements FileDocumentManagerListener {
    public void beforeAllDocumentsSaving() {
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        NotebookVirtualFileSystem notebookVirtualFileSystem = NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem();
        for (NotebookVirtualFile file : notebookVirtualFileSystem.getFileCache$intellij_jupyter_core().values()) {
            Document document;
            Intrinsics.checkNotNull((Object)((Object)file));
            if (!this.isFileOrOriginModified(notebookVirtualFileSystem, fileDocumentManager2, file) || (document = fileDocumentManager2.getCachedDocument((VirtualFile)file)) == null) continue;
            this.writeFile(fileDocumentManager2, file, (DocumentEx)document);
        }
    }

    public void beforeAnyDocumentSaving(@NotNull Document document, boolean explicit) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        if (!(fileDocumentManager2 instanceof FileDocumentManagerImpl)) {
            NotebookFileEditorChangePropagator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookFileEditorChangePropagator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Expected to get FileDocumentManagerImpl, but got " + fileDocumentManager2);
            return;
        }
        VirtualFile virtualFile = ((FileDocumentManagerImpl)fileDocumentManager2).getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (!file.isValid()) {
            return;
        }
        VirtualFile virtualFile2 = file;
        if (virtualFile2 instanceof NotebookVirtualFile) {
            if (this.isFileOrOriginModified(NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem(), fileDocumentManager2, (NotebookVirtualFile)file)) {
                this.writeFile(fileDocumentManager2, (NotebookVirtualFile)file, (DocumentEx)document);
            }
        } else if (virtualFile2 instanceof VirtualFileWithId) {
            NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)((Object)NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem().getFileCache$intellij_jupyter_core().get(((VirtualFileWithId)file).getId()));
            if (notebookVirtualFile == null) {
                return;
            }
            NotebookVirtualFile notebookFile = notebookVirtualFile;
            if (!Intrinsics.areEqual((Object)notebookFile.getOriginFile(), (Object)file)) {
                return;
            }
            Document document2 = ((FileDocumentManagerImpl)fileDocumentManager2).getDocument((VirtualFile)notebookFile);
            if (document2 == null) {
                return;
            }
            Document notebookDocument = document2;
            ((FileDocumentManagerImpl)fileDocumentManager2).saveDocument(notebookDocument, explicit);
        } else {
            return;
        }
    }

    private final boolean isFileOrOriginModified(NotebookVirtualFileSystem notebookVirtualFileSystem, FileDocumentManager fileDocumentManager, NotebookVirtualFile file) {
        return notebookVirtualFileSystem.isModified$intellij_jupyter_core(file) || fileDocumentManager.isFileModified(file.getOriginFile()) && !(file.getOriginFile() instanceof JupyterRemoteVirtualFile);
    }

    private final void propagateChangesFromJsonDocument(BackedNotebookVirtualFile notebookVirtualFile, DocumentEx sourceDocument, Document jsonDocument) {
        VirtualFile file = notebookVirtualFile.getOriginFile();
        Project project = ProjectLocator.Companion.getInstance().guessProjectForFile(file);
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = jsonDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        JupyterNotebookBase updatedNotebook = JupyterFileUtils.INSTANCE.readNotebook(string);
        NotebookFileChangeListenerKt.propagateChange(file, notebookVirtualFile, sourceDocument, project2, updatedNotebook);
    }

    private final void writeFile(FileDocumentManager fileDocumentManager, NotebookVirtualFile notebookVirtualFile, DocumentEx document) {
        try {
            WriteAction.run(() -> NotebookFileEditorChangePropagator.writeFile$lambda$2(notebookVirtualFile, fileDocumentManager, this, document));
        }
        catch (Exception ex) {
            NotebookFileEditorChangePropagator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookFileEditorChangePropagator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
        }
    }

    private static final void writeFile$lambda$2$lambda$1(NotebookVirtualFile $notebookVirtualFile, DocumentEx $document) {
        $notebookVirtualFile.flush();
        $document.setModificationStamp($notebookVirtualFile.getModificationStamp());
    }

    private static final void writeFile$lambda$2(NotebookVirtualFile $notebookVirtualFile, FileDocumentManager $fileDocumentManager, NotebookFileEditorChangePropagator this$0, DocumentEx $document) {
        DocumentEx documentEx;
        if (!$notebookVirtualFile.isValid()) {
            return;
        }
        if (!$fileDocumentManager.isFileModified($notebookVirtualFile.getOriginFile())) {
            documentEx = null;
        } else if ($notebookVirtualFile.getOriginFile() instanceof JupyterRemoteVirtualFile) {
            documentEx = null;
        } else {
            Document $this$asSafely$iv = $fileDocumentManager.getDocument($notebookVirtualFile.getOriginFile());
            boolean $i$f$asSafely = false;
            Document document = $this$asSafely$iv;
            if (!(document instanceof DocumentEx)) {
                document = null;
            }
            DocumentEx documentEx2 = (DocumentEx)document;
            if (documentEx2 != null) {
                DocumentEx documentEx3;
                DocumentEx jsonDocument = documentEx3 = documentEx2;
                boolean bl = false;
                this$0.propagateChangesFromJsonDocument(BackedNotebookVirtualFile.Companion.create($notebookVirtualFile), $document, (Document)jsonDocument);
                documentEx = documentEx3;
            } else {
                documentEx = null;
            }
        }
        DocumentEx updatedOriginDocument = documentEx;
        PomModelImpl.guardPsiModificationsIn(() -> NotebookFileEditorChangePropagator.writeFile$lambda$2$lambda$1($notebookVirtualFile, $document));
        if (updatedOriginDocument != null) {
            updatedOriginDocument.setModificationStamp($notebookVirtualFile.getOriginFile().getModificationStamp());
        }
    }
}

