/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.interact.DragFeedback;
import org.jetbrains.letsPlot.core.interact.DrawRectFeedback;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.MouseDragInteraction;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathData;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;", "Lorg/jetbrains/letsPlot/core/interact/DragFeedback;", "centerStart", "", "onCompleted", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "(ZLkotlin/jvm/functions/Function1;)V", "dragRectSvg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "selectionSvg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathElement;", "selector", "Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "drawSelection", "geomBounds", "selection", "isAcceptable", "start", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "BoxSelector", "HorizontalBandSelector", "Selector", "UnknownSelector", "VerticalBandSelector", "plot-base"})
public final class DrawRectFeedback
implements DragFeedback {
    private final boolean centerStart;
    @NotNull
    private final Function1<DoubleRectangle, Unit> onCompleted;
    @NotNull
    private Selector selector;
    @NotNull
    private final SvgRectElement dragRectSvg;
    @NotNull
    private final SvgPathElement selectionSvg;

    /*
     * WARNING - void declaration
     */
    public DrawRectFeedback(boolean centerStart, @NotNull Function1<? super DoubleRectangle, Unit> onCompleted) {
        void $this$selectionSvg_u24lambda_u241;
        SvgGraphicsElement $this$dragRectSvg_u24lambda_u240;
        SvgGraphicsElement svgGraphicsElement;
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        this.centerStart = centerStart;
        this.onCompleted = onCompleted;
        this.selector = new UnknownSelector();
        SvgRectElement svgRectElement = svgGraphicsElement = new SvgRectElement();
        DrawRectFeedback drawRectFeedback = this;
        boolean bl = false;
        $this$dragRectSvg_u24lambda_u240.strokeColor().set(Color.Companion.getBLACK());
        $this$dragRectSvg_u24lambda_u240.fillColor().set(Color.Companion.getTRANSPARENT());
        $this$dragRectSvg_u24lambda_u240.strokeWidth().set(1.5);
        $this$dragRectSvg_u24lambda_u240.strokeDashArray().set("5,5");
        $this$dragRectSvg_u24lambda_u240.x().set(0.0);
        $this$dragRectSvg_u24lambda_u240.y().set(0.0);
        $this$dragRectSvg_u24lambda_u240.width().set(0.0);
        $this$dragRectSvg_u24lambda_u240.height().set(0.0);
        drawRectFeedback.dragRectSvg = svgGraphicsElement;
        $this$dragRectSvg_u24lambda_u240 = svgGraphicsElement = new SvgPathElement();
        drawRectFeedback = this;
        boolean bl2 = false;
        $this$selectionSvg_u24lambda_u241.fillColor().set(Color.Companion.getLIGHT_GRAY());
        $this$selectionSvg_u24lambda_u241.opacity().set(0.5);
        $this$selectionSvg_u24lambda_u241.fillRule().set(SvgPathElement.FillRule.EVEN_ODD);
        drawRectFeedback.selectionSvg = svgGraphicsElement;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawSelection(DoubleRectangle geomBounds, DoubleRectangle selection, boolean isAcceptable) {
        SvgGraphicsElement svgGraphicsElement = this.dragRectSvg;
        SvgRectElement $this$drawSelection_u24lambda_u242 = svgGraphicsElement;
        boolean bl = false;
        $this$drawSelection_u24lambda_u242.visibility().set(SvgGraphicsElement.Visibility.VISIBLE);
        $this$drawSelection_u24lambda_u242.x().set(selection.getLeft());
        $this$drawSelection_u24lambda_u242.y().set(selection.getTop());
        $this$drawSelection_u24lambda_u242.width().set(selection.getWidth());
        $this$drawSelection_u24lambda_u242.height().set(selection.getHeight());
        if (isAcceptable) {
            void $this$drawSelection_u24lambda_u244_u24lambda_u243;
            SvgPathDataBuilder svgPathDataBuilder;
            SvgGraphicsElement $this$drawSelection_u24lambda_u244 = svgGraphicsElement = this.selectionSvg;
            boolean bl2 = false;
            $this$drawSelection_u24lambda_u244.visibility().set(SvgGraphicsElement.Visibility.VISIBLE);
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            Property<SvgPathData> property2 = ((SvgPathElement)$this$drawSelection_u24lambda_u244).d();
            boolean bl3 = false;
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, geomBounds.getLeft(), geomBounds.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, geomBounds.getRight(), geomBounds.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, geomBounds.getRight(), geomBounds.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, geomBounds.getLeft(), geomBounds.getBottom(), false, 4, null);
            $this$drawSelection_u24lambda_u244_u24lambda_u243.closePath();
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, selection.getLeft(), selection.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, selection.getRight(), selection.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, selection.getRight(), selection.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$drawSelection_u24lambda_u244_u24lambda_u243, selection.getLeft(), selection.getBottom(), false, 4, null);
            $this$drawSelection_u24lambda_u244_u24lambda_u243.closePath();
            property2.set(svgPathDataBuilder.build());
        } else {
            this.selectionSvg.visibility().set(SvgGraphicsElement.Visibility.HIDDEN);
        }
    }

    @Override
    @NotNull
    public Disposable start(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        SvgNode decorationsLayer = ctx2.getDecorationsLayer();
        MouseDragInteraction interaction = new MouseDragInteraction(ctx2);
        interaction.loop((Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(decorationsLayer, this){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction mouseDragInteraction) {
                Intrinsics.checkNotNullParameter((Object)mouseDragInteraction, (String)"<name for destructuring parameter 0>");
                InteractionTarget target = mouseDragInteraction.component1();
                DoubleVector dragFrom = mouseDragInteraction.component2();
                DoubleVector dragTo = mouseDragInteraction.component3();
                this.$decorationsLayer.children().add(DrawRectFeedback.access$getDragRectSvg$p(this.this$0));
                this.$decorationsLayer.children().add(DrawRectFeedback.access$getSelectionSvg$p(this.this$0));
                DoubleRectangle selection = DrawRectFeedback.access$getSelector$p(this.this$0).getSelection(dragFrom, dragTo, target);
                DrawRectFeedback.access$drawSelection(this.this$0, target.getGeomBounds(), selection, DrawRectFeedback.access$getSelector$p(this.this$0).isAcceptable(selection));
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(this){
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction mouseDragInteraction) {
                Intrinsics.checkNotNullParameter((Object)mouseDragInteraction, (String)"<name for destructuring parameter 0>");
                InteractionTarget target = mouseDragInteraction.component1();
                DoubleVector dragFrom = mouseDragInteraction.component2();
                DoubleVector dragTo = mouseDragInteraction.component3();
                DoubleRectangle selection = DrawRectFeedback.access$getSelector$p(this.this$0).getSelection(dragFrom, dragTo, target);
                DrawRectFeedback.access$drawSelection(this.this$0, target.getGeomBounds(), selection, DrawRectFeedback.access$getSelector$p(this.this$0).isAcceptable(selection));
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(decorationsLayer, this){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getDragRectSvg$p(this.this$0));
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getSelectionSvg$p(this.this$0));
                InteractionTarget target = it.component1();
                DoubleVector dragFrom = it.component2();
                DoubleVector dragTo = it.component3();
                it.reset();
                DoubleRectangle selection = DrawRectFeedback.access$getSelector$p(this.this$0).getSelection(dragFrom, dragTo, target);
                if (DrawRectFeedback.access$getSelector$p(this.this$0).isAcceptable(selection)) {
                    DoubleRectangle dataBounds = target.applyViewport(selection);
                    DrawRectFeedback.access$getOnCompleted$p(this.this$0).invoke((Object)dataBounds);
                }
                DrawRectFeedback.access$setSelector$p(this.this$0, this.this$0.new UnknownSelector());
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)start.4.INSTANCE));
        return new Disposable(decorationsLayer, this, interaction){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            final /* synthetic */ MouseDragInteraction $interaction;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                this.$interaction = $interaction;
            }

            public void dispose() {
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getDragRectSvg$p(this.this$0));
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getSelectionSvg$p(this.this$0));
                this.$interaction.dispose();
            }
        };
    }

    public static final /* synthetic */ SvgRectElement access$getDragRectSvg$p(DrawRectFeedback $this) {
        return $this.dragRectSvg;
    }

    public static final /* synthetic */ SvgPathElement access$getSelectionSvg$p(DrawRectFeedback $this) {
        return $this.selectionSvg;
    }

    public static final /* synthetic */ Selector access$getSelector$p(DrawRectFeedback $this) {
        return $this.selector;
    }

    public static final /* synthetic */ void access$drawSelection(DrawRectFeedback $this, DoubleRectangle geomBounds, DoubleRectangle selection, boolean isAcceptable) {
        $this.drawSelection(geomBounds, selection, isAcceptable);
    }

    public static final /* synthetic */ Function1 access$getOnCompleted$p(DrawRectFeedback $this) {
        return $this.onCompleted;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$BoxSelector;", "Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "(Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;)V", "getSelection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "to", "target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "isAcceptable", "", "selection", "plot-base"})
    private final class BoxSelector
    extends Selector {
        @Override
        @NotNull
        public DoubleRectangle getSelection(@NotNull DoubleVector from2, @NotNull DoubleVector to, @NotNull InteractionTarget target) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (DrawRectFeedback.this.centerStart) {
                DoubleVector doubleVector;
                double height;
                double width2;
                DoubleVector drag = to.subtract(from2);
                double ratio = target.getGeomBounds().getWidth() / target.getGeomBounds().getHeight();
                if (ratio > 1.0) {
                    width2 = Math.abs(drag.getY()) * ratio;
                    height = width2 / ratio;
                    doubleVector = new DoubleVector(width2, height);
                } else {
                    width2 = Math.abs(drag.getX());
                    height = width2 / ratio;
                    doubleVector = new DoubleVector(width2, height);
                }
                DoubleVector size2 = doubleVector;
                return new DoubleRectangle(from2.subtract(size2), size2.mul(2.0));
            }
            DoubleVector to2 = this.limitToGeomBounds(to, target);
            return DoubleRectangle.Companion.span(from2, to2);
        }

        @Override
        public boolean isAcceptable(@NotNull DoubleRectangle selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return selection.getWidth() > 15.0 || selection.getHeight() > 15.0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$HorizontalBandSelector;", "Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "(Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;)V", "getSelection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "to", "target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "isAcceptable", "", "selection", "plot-base"})
    private final class HorizontalBandSelector
    extends Selector {
        @Override
        @NotNull
        public DoubleRectangle getSelection(@NotNull DoubleVector from2, @NotNull DoubleVector to, @NotNull InteractionTarget target) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (DrawRectFeedback.this.centerStart) {
                double length = Math.abs(to.subtract(from2).getY());
                DoubleRectangle.Companion companion = DoubleRectangle.Companion;
                double d = target.getGeomBounds().getLeft();
                double d2 = target.getGeomBounds().getRight();
                double d3 = from2.getY() - length;
                double d4 = from2.getY() + length;
                return companion.LTRB(d, d3, d2, d4);
            }
            DoubleVector to2 = this.limitToGeomBounds(to, target);
            return DoubleRectangle.Companion.hvRange(target.getGeomBounds().xRange(), new DoubleSpan(from2.getY(), to2.getY()));
        }

        @Override
        public boolean isAcceptable(@NotNull DoubleRectangle selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return selection.getHeight() > 15.0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\"\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H&J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "", "()V", "getSelection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "to", "target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "isAcceptable", "", "selection", "limitToGeomBounds", "Companion", "plot-base"})
    private static abstract class Selector {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final double MIN_SIZE = 15.0;

        @NotNull
        public final DoubleVector limitToGeomBounds(@NotNull DoubleVector to, @NotNull InteractionTarget target) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new DoubleVector(RangesKt.coerceIn((double)to.getX(), (double)target.getGeomBounds().getLeft(), (double)target.getGeomBounds().getRight()), RangesKt.coerceIn((double)to.getY(), (double)target.getGeomBounds().getTop(), (double)target.getGeomBounds().getBottom()));
        }

        @NotNull
        public abstract DoubleRectangle getSelection(@NotNull DoubleVector var1, @NotNull DoubleVector var2, @NotNull InteractionTarget var3);

        public abstract boolean isAcceptable(@NotNull DoubleRectangle var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector$Companion;", "", "()V", "MIN_SIZE", "", "plot-base"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$UnknownSelector;", "Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "(Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;)V", "getSelection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "to", "target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "isAcceptable", "", "selection", "plot-base"})
    private final class UnknownSelector
    extends Selector {
        @Override
        @NotNull
        public DoubleRectangle getSelection(@NotNull DoubleVector from2, @NotNull DoubleVector to, @NotNull InteractionTarget target) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            DoubleVector drag = to.subtract(from2);
            if (drag.length() > 20.0) {
                DrawRectFeedback.this.selector = Math.abs(drag.getX()) < 7.0 ? (Selector)new HorizontalBandSelector() : (Math.abs(drag.getY()) < 7.0 ? (Selector)new VerticalBandSelector() : (Selector)new BoxSelector());
            }
            return DoubleRectangle.Companion.span(from2, to);
        }

        @Override
        public boolean isAcceptable(@NotNull DoubleRectangle selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$VerticalBandSelector;", "Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Selector;", "(Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;)V", "getSelection", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "from", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "to", "target", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "isAcceptable", "", "selection", "plot-base"})
    private final class VerticalBandSelector
    extends Selector {
        @Override
        @NotNull
        public DoubleRectangle getSelection(@NotNull DoubleVector from2, @NotNull DoubleVector to, @NotNull InteractionTarget target) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (DrawRectFeedback.this.centerStart) {
                double length = Math.abs(to.subtract(from2).getX());
                DoubleRectangle.Companion companion = DoubleRectangle.Companion;
                double d = from2.getX() - length;
                double d2 = from2.getX() + length;
                double d3 = target.getGeomBounds().getTop();
                double d4 = target.getGeomBounds().getBottom();
                return companion.LTRB(d, d3, d2, d4);
            }
            DoubleVector to2 = this.limitToGeomBounds(to, target);
            return DoubleRectangle.Companion.hvRange(new DoubleSpan(from2.getX(), to2.getX()), target.getGeomBounds().yRange());
        }

        @Override
        public boolean isAcceptable(@NotNull DoubleRectangle selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return selection.getWidth() > 15.0;
        }
    }
}

