/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sisu.inject.MildValues;

final class MildConcurrentValues<K, V>
extends MildValues<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Reference<V>> concurrentMap;

    MildConcurrentValues(ConcurrentMap<K, Reference<V>> map2, boolean soft) {
        super(map2, soft);
        this.concurrentMap = map2;
    }

    @Override
    public V putIfAbsent(K key2, V value) {
        Reference<V> oldRef;
        this.compact();
        Reference<V> ref2 = this.mildValue(key2, value);
        while ((oldRef = this.concurrentMap.putIfAbsent(key2, ref2)) != null) {
            V oldValue = oldRef.get();
            if (null != oldValue) {
                return oldValue;
            }
            this.concurrentMap.remove(key2, oldRef);
        }
        return null;
    }

    @Override
    public V replace(K key2, V value) {
        this.compact();
        Reference<V> ref2 = this.concurrentMap.replace(key2, this.mildValue(key2, value));
        return null != ref2 ? (V)ref2.get() : null;
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        this.compact();
        return this.concurrentMap.replace(key2, MildConcurrentValues.tempValue(oldValue), this.mildValue(key2, newValue));
    }

    @Override
    public boolean remove(Object key2, Object value) {
        this.compact();
        return this.concurrentMap.remove(key2, MildConcurrentValues.tempValue(value));
    }

    @Override
    void compact() {
        Reference ref2;
        while ((ref2 = this.queue.poll()) != null) {
            this.concurrentMap.remove(((MildValues.InverseMapping)((Object)ref2)).key(), ref2);
        }
    }
}

