/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.graph;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Exclusion;

public final class Dependency {
    private final Artifact artifact;
    private final String scope;
    private final Boolean optional;
    private final Set<Exclusion> exclusions;

    public Dependency(Artifact artifact, String scope2) {
        this(artifact, scope2, false);
    }

    public Dependency(Artifact artifact, String scope2, Boolean optional) {
        this(artifact, scope2, optional, null);
    }

    public Dependency(Artifact artifact, String scope2, Boolean optional, Collection<Exclusion> exclusions) {
        this(artifact, scope2, Exclusions.copy(exclusions), optional);
    }

    private Dependency(Artifact artifact, String scope2, Set<Exclusion> exclusions, Boolean optional) {
        this.artifact = Objects.requireNonNull(artifact, "artifact cannot be null");
        this.scope = scope2 != null ? scope2 : "";
        this.optional = optional;
        this.exclusions = exclusions;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dependency setArtifact(Artifact artifact) {
        if (this.artifact.equals(artifact)) {
            return this;
        }
        return new Dependency(artifact, this.scope, this.exclusions, this.optional);
    }

    public String getScope() {
        return this.scope;
    }

    public Dependency setScope(String scope2) {
        if (this.scope.equals(scope2) || scope2 == null && this.scope.isEmpty()) {
            return this;
        }
        return new Dependency(this.artifact, scope2, this.exclusions, this.optional);
    }

    public boolean isOptional() {
        return Boolean.TRUE.equals(this.optional);
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public Dependency setOptional(Boolean optional) {
        if (Objects.equals(this.optional, optional)) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, this.exclusions, optional);
    }

    public Collection<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public Dependency setExclusions(Collection<Exclusion> exclusions) {
        if (this.hasEquivalentExclusions(exclusions)) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, this.optional, exclusions);
    }

    private boolean hasEquivalentExclusions(Collection<Exclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return this.exclusions.isEmpty();
        }
        if (exclusions instanceof Set) {
            return this.exclusions.equals(exclusions);
        }
        return exclusions.size() >= this.exclusions.size() && this.exclusions.containsAll(exclusions) && exclusions.containsAll(this.exclusions);
    }

    public String toString() {
        return this.getArtifact() + " (" + this.getScope() + (this.isOptional() ? "?" : "") + ")";
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        Dependency that = (Dependency)obj2;
        return Objects.equals(this.artifact, that.artifact) && Objects.equals(this.scope, that.scope) && Objects.equals(this.optional, that.optional) && Objects.equals(this.exclusions, that.exclusions);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.artifact.hashCode();
        hash = hash * 31 + this.scope.hashCode();
        hash = hash * 31 + (this.optional != null ? this.optional.hashCode() : 0);
        hash = hash * 31 + this.exclusions.size();
        return hash;
    }

    private static class Exclusions
    extends AbstractSet<Exclusion> {
        private final Exclusion[] exclusions;

        public static Set<Exclusion> copy(Collection<Exclusion> exclusions) {
            if (exclusions == null || exclusions.isEmpty()) {
                return Collections.emptySet();
            }
            return new Exclusions(exclusions);
        }

        private Exclusions(Collection<Exclusion> exclusions) {
            if (exclusions.size() > 1 && !(exclusions instanceof Set)) {
                exclusions = new LinkedHashSet<Exclusion>(exclusions);
            }
            this.exclusions = exclusions.toArray(new Exclusion[0]);
        }

        @Override
        public Iterator<Exclusion> iterator() {
            return new Iterator<Exclusion>(){
                private int cursor = 0;

                @Override
                public boolean hasNext() {
                    return this.cursor < exclusions.length;
                }

                @Override
                public Exclusion next() {
                    try {
                        Exclusion exclusion = exclusions[this.cursor];
                        ++this.cursor;
                        return exclusion;
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.exclusions.length;
        }
    }
}

