/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenXpp3ReaderEx {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public MavenXpp3ReaderEx() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public MavenXpp3ReaderEx(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser2, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser2.getName().equals(tagName) && !parser2.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser2, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser2, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser2, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser2, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser2.getName() + "'", parser2, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser2.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser2, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser2, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser2) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser2);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser2) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser2, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser2, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser2, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser2, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser2, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser2, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser2, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser2) throws IOException, XmlPullParserException {
        int eventType = parser2.next();
        if (eventType == 4) {
            eventType = parser2.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser2, null);
        }
        return eventType;
    }

    public Model read(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        Model model = null;
        int eventType = parser2.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"project".equals(parser2.getName())) {
                    throw new XmlPullParserException("Expected root element 'project' but found '" + parser2.getName() + "'", parser2, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'project'", parser2, null);
                }
                model = this.parseModel(parser2, strict, source);
                model.setModelEncoding(parser2.getInputEncoding());
                parsed = true;
            }
            eventType = parser2.next();
        }
        if (parsed) {
            return model;
        }
        throw new XmlPullParserException("Expected root element 'project' but found no element at all: invalid XML document", parser2, null);
    }

    public Model read(Reader reader, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        MXParser parser2 = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser2.setInput(reader);
        return this.read(parser2, strict, source);
    }

    public Model read(InputStream in, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        return this.read(new XmlStreamReader(in), strict, source);
    }

    private Activation parseActivation(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Activation activation = new Activation();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        activation.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "activeByDefault", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activation.setLocation("activeByDefault", _location);
                activation.setActiveByDefault(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "activeByDefault"), "activeByDefault", parser2, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "jdk", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activation.setLocation("jdk", _location);
                activation.setJdk(this.interpolatedTrimmed(parser2.nextText(), "jdk"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "os", null, parsed)) {
                activation.setOs(this.parseActivationOS(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "property", null, parsed)) {
                activation.setProperty(this.parseActivationProperty(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "file", null, parsed)) {
                activation.setFile(this.parseActivationFile(parser2, strict, source));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activation;
    }

    private ActivationFile parseActivationFile(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationFile activationFile = new ActivationFile();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        activationFile.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "missing", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationFile.setLocation("missing", _location);
                activationFile.setMissing(this.interpolatedTrimmed(parser2.nextText(), "missing"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "exists", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationFile.setLocation("exists", _location);
                activationFile.setExists(this.interpolatedTrimmed(parser2.nextText(), "exists"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationFile;
    }

    private ActivationOS parseActivationOS(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationOS activationOS = new ActivationOS();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        activationOS.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationOS.setLocation("name", _location);
                activationOS.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "family", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationOS.setLocation("family", _location);
                activationOS.setFamily(this.interpolatedTrimmed(parser2.nextText(), "family"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "arch", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationOS.setLocation("arch", _location);
                activationOS.setArch(this.interpolatedTrimmed(parser2.nextText(), "arch"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationOS.setLocation("version", _location);
                activationOS.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationOS;
    }

    private ActivationProperty parseActivationProperty(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ActivationProperty activationProperty = new ActivationProperty();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        activationProperty.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationProperty.setLocation("name", _location);
                activationProperty.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "value", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                activationProperty.setLocation("value", _location);
                activationProperty.setValue(this.interpolatedTrimmed(parser2.nextText(), "value"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return activationProperty;
    }

    private Build parseBuild(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Build build = new Build();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        build.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "sourceDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("sourceDirectory", _location);
                build.setSourceDirectory(this.interpolatedTrimmed(parser2.nextText(), "sourceDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scriptSourceDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("scriptSourceDirectory", _location);
                build.setScriptSourceDirectory(this.interpolatedTrimmed(parser2.nextText(), "scriptSourceDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testSourceDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("testSourceDirectory", _location);
                build.setTestSourceDirectory(this.interpolatedTrimmed(parser2.nextText(), "testSourceDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "outputDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("outputDirectory", _location);
                build.setOutputDirectory(this.interpolatedTrimmed(parser2.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testOutputDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("testOutputDirectory", _location);
                build.setTestOutputDirectory(this.interpolatedTrimmed(parser2.nextText(), "testOutputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "extensions", null, parsed)) {
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                while (parser2.nextTag() == 2) {
                    if ("extension".equals(parser2.getName())) {
                        extensions.add(this.parseExtension(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                build.setExtensions(extensions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "defaultGoal", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("defaultGoal", _location);
                build.setDefaultGoal(this.interpolatedTrimmed(parser2.nextText(), "defaultGoal"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                while (parser2.nextTag() == 2) {
                    if ("resource".equals(parser2.getName())) {
                        resources.add(this.parseResource(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                build.setResources(resources);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                while (parser2.nextTag() == 2) {
                    if ("testResource".equals(parser2.getName())) {
                        testResources.add(this.parseResource(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                build.setTestResources(testResources);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("directory", _location);
                build.setDirectory(this.interpolatedTrimmed(parser2.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "finalName", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("finalName", _location);
                build.setFinalName(this.interpolatedTrimmed(parser2.nextText(), "finalName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                build.setLocation("filters", _locations);
                while (parser2.nextTag() == 2) {
                    if ("filter".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(filters.size(), _location);
                        filters.add(this.interpolatedTrimmed(parser2.nextText(), "filters"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                build.setFilters(filters);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                build.setPluginManagement(this.parsePluginManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                build.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return build;
    }

    private BuildBase parseBuildBase(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        BuildBase buildBase = new BuildBase();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        buildBase.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "defaultGoal", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                buildBase.setLocation("defaultGoal", _location);
                buildBase.setDefaultGoal(this.interpolatedTrimmed(parser2.nextText(), "defaultGoal"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "resources", null, parsed)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                while (parser2.nextTag() == 2) {
                    if ("resource".equals(parser2.getName())) {
                        resources.add(this.parseResource(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                buildBase.setResources(resources);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "testResources", null, parsed)) {
                ArrayList<Resource> testResources = new ArrayList<Resource>();
                while (parser2.nextTag() == 2) {
                    if ("testResource".equals(parser2.getName())) {
                        testResources.add(this.parseResource(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                buildBase.setTestResources(testResources);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                buildBase.setLocation("directory", _location);
                buildBase.setDirectory(this.interpolatedTrimmed(parser2.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "finalName", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                buildBase.setLocation("finalName", _location);
                buildBase.setFinalName(this.interpolatedTrimmed(parser2.nextText(), "finalName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filters", null, parsed)) {
                ArrayList<String> filters = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                buildBase.setLocation("filters", _locations);
                while (parser2.nextTag() == 2) {
                    if ("filter".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(filters.size(), _location);
                        filters.add(this.interpolatedTrimmed(parser2.nextText(), "filters"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                buildBase.setFilters(filters);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                buildBase.setPluginManagement(this.parsePluginManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                buildBase.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return buildBase;
    }

    private CiManagement parseCiManagement(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        CiManagement ciManagement = new CiManagement();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        ciManagement.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "system", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                ciManagement.setLocation("system", _location);
                ciManagement.setSystem(this.interpolatedTrimmed(parser2.nextText(), "system"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                ciManagement.setLocation("url", _location);
                ciManagement.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "notifiers", null, parsed)) {
                ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
                while (parser2.nextTag() == 2) {
                    if ("notifier".equals(parser2.getName())) {
                        notifiers.add(this.parseNotifier(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                ciManagement.setNotifiers(notifiers);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return ciManagement;
    }

    private ConfigurationContainer parseConfigurationContainer(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ConfigurationContainer configurationContainer = new ConfigurationContainer();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        configurationContainer.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                configurationContainer.setLocation("inherited", _location);
                configurationContainer.setInherited(this.interpolatedTrimmed(parser2.nextText(), "inherited"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                configurationContainer.setLocation("configuration", _location);
                configurationContainer.setConfiguration(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return configurationContainer;
    }

    private Contributor parseContributor(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Contributor contributor = new Contributor();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        contributor.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("name", _location);
                contributor.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "email", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("email", _location);
                contributor.setEmail(this.interpolatedTrimmed(parser2.nextText(), "email"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("url", _location);
                contributor.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("organization", _location);
                contributor.setOrganization(this.interpolatedTrimmed(parser2.nextText(), "organization"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organizationUrl", "organisationUrl", parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("organizationUrl", _location);
                contributor.setOrganizationUrl(this.interpolatedTrimmed(parser2.nextText(), "organizationUrl"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("roles", _locations);
                while (parser2.nextTag() == 2) {
                    if ("role".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(roles.size(), _location);
                        roles.add(this.interpolatedTrimmed(parser2.nextText(), "roles"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                contributor.setRoles(roles);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "timezone", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("timezone", _location);
                contributor.setTimezone(this.interpolatedTrimmed(parser2.nextText(), "timezone"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                contributor.setLocation("properties", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    contributor.addProperty(key2, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return contributor;
    }

    private Dependency parseDependency(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Dependency dependency = new Dependency();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        dependency.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("groupId", _location);
                dependency.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("artifactId", _location);
                dependency.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("version", _location);
                dependency.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "type", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("type", _location);
                dependency.setType(this.interpolatedTrimmed(parser2.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "classifier", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("classifier", _location);
                dependency.setClassifier(this.interpolatedTrimmed(parser2.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scope", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("scope", _location);
                dependency.setScope(this.interpolatedTrimmed(parser2.nextText(), "scope"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "systemPath", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("systemPath", _location);
                dependency.setSystemPath(this.interpolatedTrimmed(parser2.nextText(), "systemPath"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "exclusions", null, parsed)) {
                ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
                while (parser2.nextTag() == 2) {
                    if ("exclusion".equals(parser2.getName())) {
                        exclusions.add(this.parseExclusion(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                dependency.setExclusions(exclusions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "optional", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                dependency.setLocation("optional", _location);
                dependency.setOptional(this.interpolatedTrimmed(parser2.nextText(), "optional"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return dependency;
    }

    private DependencyManagement parseDependencyManagement(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DependencyManagement dependencyManagement = new DependencyManagement();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        dependencyManagement.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                dependencyManagement.setDependencies(dependencies);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return dependencyManagement;
    }

    private DeploymentRepository parseDeploymentRepository(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DeploymentRepository deploymentRepository = new DeploymentRepository();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        deploymentRepository.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "uniqueVersion", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                deploymentRepository.setLocation("uniqueVersion", _location);
                deploymentRepository.setUniqueVersion(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "uniqueVersion"), "uniqueVersion", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "releases", null, parsed)) {
                deploymentRepository.setReleases(this.parseRepositoryPolicy(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshots", null, parsed)) {
                deploymentRepository.setSnapshots(this.parseRepositoryPolicy(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                deploymentRepository.setLocation("id", _location);
                deploymentRepository.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                deploymentRepository.setLocation("name", _location);
                deploymentRepository.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                deploymentRepository.setLocation("url", _location);
                deploymentRepository.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                deploymentRepository.setLocation("layout", _location);
                deploymentRepository.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return deploymentRepository;
    }

    private Developer parseDeveloper(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Developer developer = new Developer();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        developer.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("id", _location);
                developer.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("name", _location);
                developer.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "email", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("email", _location);
                developer.setEmail(this.interpolatedTrimmed(parser2.nextText(), "email"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("url", _location);
                developer.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("organization", _location);
                developer.setOrganization(this.interpolatedTrimmed(parser2.nextText(), "organization"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organizationUrl", "organisationUrl", parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("organizationUrl", _location);
                developer.setOrganizationUrl(this.interpolatedTrimmed(parser2.nextText(), "organizationUrl"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "roles", null, parsed)) {
                ArrayList<String> roles = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("roles", _locations);
                while (parser2.nextTag() == 2) {
                    if ("role".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(roles.size(), _location);
                        roles.add(this.interpolatedTrimmed(parser2.nextText(), "roles"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                developer.setRoles(roles);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "timezone", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("timezone", _location);
                developer.setTimezone(this.interpolatedTrimmed(parser2.nextText(), "timezone"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                developer.setLocation("properties", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    developer.addProperty(key2, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return developer;
    }

    private DistributionManagement parseDistributionManagement(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        DistributionManagement distributionManagement = new DistributionManagement();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        distributionManagement.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "repository", null, parsed)) {
                distributionManagement.setRepository(this.parseDeploymentRepository(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshotRepository", null, parsed)) {
                distributionManagement.setSnapshotRepository(this.parseDeploymentRepository(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "site", null, parsed)) {
                distributionManagement.setSite(this.parseSite(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "downloadUrl", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                distributionManagement.setLocation("downloadUrl", _location);
                distributionManagement.setDownloadUrl(this.interpolatedTrimmed(parser2.nextText(), "downloadUrl"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "relocation", null, parsed)) {
                distributionManagement.setRelocation(this.parseRelocation(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "status", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                distributionManagement.setLocation("status", _location);
                distributionManagement.setStatus(this.interpolatedTrimmed(parser2.nextText(), "status"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return distributionManagement;
    }

    private Exclusion parseExclusion(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Exclusion exclusion = new Exclusion();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        exclusion.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                exclusion.setLocation("groupId", _location);
                exclusion.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                exclusion.setLocation("artifactId", _location);
                exclusion.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return exclusion;
    }

    private Extension parseExtension(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Extension extension = new Extension();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        extension.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                extension.setLocation("groupId", _location);
                extension.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                extension.setLocation("artifactId", _location);
                extension.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                extension.setLocation("version", _location);
                extension.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return extension;
    }

    private FileSet parseFileSet(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        FileSet fileSet = new FileSet();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        fileSet.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                fileSet.setLocation("directory", _location);
                fileSet.setDirectory(this.interpolatedTrimmed(parser2.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                fileSet.setLocation("includes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser2.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                fileSet.setIncludes(includes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                fileSet.setLocation("excludes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser2.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                fileSet.setExcludes(excludes);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return fileSet;
    }

    private IssueManagement parseIssueManagement(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        IssueManagement issueManagement = new IssueManagement();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        issueManagement.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "system", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                issueManagement.setLocation("system", _location);
                issueManagement.setSystem(this.interpolatedTrimmed(parser2.nextText(), "system"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                issueManagement.setLocation("url", _location);
                issueManagement.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return issueManagement;
    }

    private License parseLicense(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        License license = new License();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        license.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                license.setLocation("name", _location);
                license.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                license.setLocation("url", _location);
                license.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distribution", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                license.setLocation("distribution", _location);
                license.setDistribution(this.interpolatedTrimmed(parser2.nextText(), "distribution"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "comments", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                license.setLocation("comments", _location);
                license.setComments(this.interpolatedTrimmed(parser2.nextText(), "comments"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return license;
    }

    private MailingList parseMailingList(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        MailingList mailingList = new MailingList();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        mailingList.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("name", _location);
                mailingList.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "subscribe", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("subscribe", _location);
                mailingList.setSubscribe(this.interpolatedTrimmed(parser2.nextText(), "subscribe"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "unsubscribe", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("unsubscribe", _location);
                mailingList.setUnsubscribe(this.interpolatedTrimmed(parser2.nextText(), "unsubscribe"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "post", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("post", _location);
                mailingList.setPost(this.interpolatedTrimmed(parser2.nextText(), "post"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "archive", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("archive", _location);
                mailingList.setArchive(this.interpolatedTrimmed(parser2.nextText(), "archive"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "otherArchives", null, parsed)) {
                ArrayList<String> otherArchives = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                mailingList.setLocation("otherArchives", _locations);
                while (parser2.nextTag() == 2) {
                    if ("otherArchive".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(otherArchives.size(), _location);
                        otherArchives.add(this.interpolatedTrimmed(parser2.nextText(), "otherArchives"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                mailingList.setOtherArchives(otherArchives);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return mailingList;
    }

    private Model parseModel(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Model model = new Model();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        model.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0 || "xmlns".equals(name2)) continue;
            if ("child.project.url.inherit.append.path".equals(name2)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("childProjectUrlInheritAppendPath", _location);
                model.setChildProjectUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.project.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "modelVersion", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("modelVersion", _location);
                model.setModelVersion(this.interpolatedTrimmed(parser2.nextText(), "modelVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "parent", null, parsed)) {
                model.setParent(this.parseParent(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("groupId", _location);
                model.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("artifactId", _location);
                model.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("version", _location);
                model.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "packaging", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("packaging", _location);
                model.setPackaging(this.interpolatedTrimmed(parser2.nextText(), "packaging"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("name", _location);
                model.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "description", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("description", _location);
                model.setDescription(this.interpolatedTrimmed(parser2.nextText(), "description"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("url", _location);
                model.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inceptionYear", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("inceptionYear", _location);
                model.setInceptionYear(this.interpolatedTrimmed(parser2.nextText(), "inceptionYear"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "organization", "organisation", parsed)) {
                model.setOrganization(this.parseOrganization(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "licenses", null, parsed)) {
                ArrayList<License> licenses = new ArrayList<License>();
                while (parser2.nextTag() == 2) {
                    if ("license".equals(parser2.getName())) {
                        licenses.add(this.parseLicense(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setLicenses(licenses);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "developers", null, parsed)) {
                ArrayList<Developer> developers = new ArrayList<Developer>();
                while (parser2.nextTag() == 2) {
                    if ("developer".equals(parser2.getName())) {
                        developers.add(this.parseDeveloper(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setDevelopers(developers);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "contributors", null, parsed)) {
                ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                while (parser2.nextTag() == 2) {
                    if ("contributor".equals(parser2.getName())) {
                        contributors.add(this.parseContributor(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setContributors(contributors);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "mailingLists", null, parsed)) {
                ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                while (parser2.nextTag() == 2) {
                    if ("mailingList".equals(parser2.getName())) {
                        mailingLists.add(this.parseMailingList(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setMailingLists(mailingLists);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "prerequisites", null, parsed)) {
                model.setPrerequisites(this.parsePrerequisites(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("modules", _locations);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser2.nextText(), "modules"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setModules(modules);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "scm", null, parsed)) {
                model.setScm(this.parseScm(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "issueManagement", null, parsed)) {
                model.setIssueManagement(this.parseIssueManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "ciManagement", null, parsed)) {
                model.setCiManagement(this.parseCiManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                model.setDistributionManagement(this.parseDistributionManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("properties", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    model.addProperty(key2, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                model.setDependencyManagement(this.parseDependencyManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setDependencies(dependencies);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setRepositories(repositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setPluginRepositories(pluginRepositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "build", null, parsed)) {
                model.setBuild(this.parseBuild(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                model.setLocation("reports", _location);
                model.setReports(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                model.setReporting(this.parseReporting(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "profiles", null, parsed)) {
                ArrayList<Profile> profiles = new ArrayList<Profile>();
                while (parser2.nextTag() == 2) {
                    if ("profile".equals(parser2.getName())) {
                        profiles.add(this.parseProfile(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                model.setProfiles(profiles);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return model;
    }

    private ModelBase parseModelBase(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ModelBase modelBase = new ModelBase();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        modelBase.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                modelBase.setLocation("modules", _locations);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser2.nextText(), "modules"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                modelBase.setModules(modules);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                modelBase.setDistributionManagement(this.parseDistributionManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                modelBase.setLocation("properties", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    modelBase.addProperty(key2, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                modelBase.setDependencyManagement(this.parseDependencyManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                modelBase.setDependencies(dependencies);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                modelBase.setRepositories(repositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                modelBase.setPluginRepositories(pluginRepositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                modelBase.setLocation("reports", _location);
                modelBase.setReports(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                modelBase.setReporting(this.parseReporting(parser2, strict, source));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return modelBase;
    }

    private Notifier parseNotifier(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Notifier notifier = new Notifier();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        notifier.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "type", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("type", _location);
                notifier.setType(this.interpolatedTrimmed(parser2.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnError", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("sendOnError", _location);
                notifier.setSendOnError(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "sendOnError"), "sendOnError", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnFailure", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("sendOnFailure", _location);
                notifier.setSendOnFailure(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "sendOnFailure"), "sendOnFailure", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnSuccess", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("sendOnSuccess", _location);
                notifier.setSendOnSuccess(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "sendOnSuccess"), "sendOnSuccess", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "sendOnWarning", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("sendOnWarning", _location);
                notifier.setSendOnWarning(this.getBooleanValue(this.interpolatedTrimmed(parser2.nextText(), "sendOnWarning"), "sendOnWarning", parser2, "true"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "address", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("address", _location);
                notifier.setAddress(this.interpolatedTrimmed(parser2.nextText(), "address"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                notifier.setLocation("configuration", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    notifier.addConfiguration(key2, value);
                }
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return notifier;
    }

    private Organization parseOrganization(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Organization organization = new Organization();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        organization.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                organization.setLocation("name", _location);
                organization.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                organization.setLocation("url", _location);
                organization.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return organization;
    }

    private Parent parseParent(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Parent parent = new Parent();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        parent.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                parent.setLocation("groupId", _location);
                parent.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                parent.setLocation("artifactId", _location);
                parent.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                parent.setLocation("version", _location);
                parent.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "relativePath", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                parent.setLocation("relativePath", _location);
                parent.setRelativePath(this.interpolatedTrimmed(parser2.nextText(), "relativePath"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return parent;
    }

    private PatternSet parsePatternSet(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PatternSet patternSet = new PatternSet();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        patternSet.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                patternSet.setLocation("includes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser2.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                patternSet.setIncludes(includes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                patternSet.setLocation("excludes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser2.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                patternSet.setExcludes(excludes);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return patternSet;
    }

    private Plugin parsePlugin(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Plugin plugin = new Plugin();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        plugin.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("groupId", _location);
                plugin.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("artifactId", _location);
                plugin.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("version", _location);
                plugin.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "extensions", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("extensions", _location);
                plugin.setExtensions(this.interpolatedTrimmed(parser2.nextText(), "extensions"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "executions", null, parsed)) {
                ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
                while (parser2.nextTag() == 2) {
                    if ("execution".equals(parser2.getName())) {
                        executions.add(this.parsePluginExecution(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                plugin.setExecutions(executions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                plugin.setDependencies(dependencies);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "goals", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("goals", _location);
                plugin.setGoals(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("inherited", _location);
                plugin.setInherited(this.interpolatedTrimmed(parser2.nextText(), "inherited"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                plugin.setLocation("configuration", _location);
                plugin.setConfiguration(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return plugin;
    }

    private PluginConfiguration parsePluginConfiguration(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        pluginConfiguration.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "pluginManagement", null, parsed)) {
                pluginConfiguration.setPluginManagement(this.parsePluginManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                pluginConfiguration.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginContainer pluginContainer = new PluginContainer();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        pluginContainer.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                pluginContainer.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginContainer;
    }

    private PluginExecution parsePluginExecution(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginExecution pluginExecution = new PluginExecution();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        pluginExecution.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                pluginExecution.setLocation("id", _location);
                pluginExecution.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "phase", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                pluginExecution.setLocation("phase", _location);
                pluginExecution.setPhase(this.interpolatedTrimmed(parser2.nextText(), "phase"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                pluginExecution.setLocation("goals", _locations);
                while (parser2.nextTag() == 2) {
                    if ("goal".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(goals.size(), _location);
                        goals.add(this.interpolatedTrimmed(parser2.nextText(), "goals"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                pluginExecution.setGoals(goals);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                pluginExecution.setLocation("inherited", _location);
                pluginExecution.setInherited(this.interpolatedTrimmed(parser2.nextText(), "inherited"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                pluginExecution.setLocation("configuration", _location);
                pluginExecution.setConfiguration(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginExecution;
    }

    private PluginManagement parsePluginManagement(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        PluginManagement pluginManagement = new PluginManagement();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        pluginManagement.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<Plugin> plugins = new ArrayList<Plugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parsePlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                pluginManagement.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return pluginManagement;
    }

    private Prerequisites parsePrerequisites(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Prerequisites prerequisites = new Prerequisites();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        prerequisites.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "maven", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                prerequisites.setLocation("maven", _location);
                prerequisites.setMaven(this.interpolatedTrimmed(parser2.nextText(), "maven"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return prerequisites;
    }

    private Profile parseProfile(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Profile profile = new Profile();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        profile.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                profile.setLocation("id", _location);
                profile.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "activation", null, parsed)) {
                profile.setActivation(this.parseActivation(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "build", null, parsed)) {
                profile.setBuild(this.parseBuildBase(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "modules", null, parsed)) {
                ArrayList<String> modules = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                profile.setLocation("modules", _locations);
                while (parser2.nextTag() == 2) {
                    if ("module".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(modules.size(), _location);
                        modules.add(this.interpolatedTrimmed(parser2.nextText(), "modules"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                profile.setModules(modules);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "distributionManagement", null, parsed)) {
                profile.setDistributionManagement(this.parseDistributionManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "properties", null, parsed)) {
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                profile.setLocation("properties", _locations);
                while (parser2.nextTag() == 2) {
                    String key2 = parser2.getName();
                    _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                    _locations.setLocation(key2, _location);
                    String value = parser2.nextText().trim();
                    profile.addProperty(key2, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencyManagement", null, parsed)) {
                profile.setDependencyManagement(this.parseDependencyManagement(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "dependencies", null, parsed)) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                while (parser2.nextTag() == 2) {
                    if ("dependency".equals(parser2.getName())) {
                        dependencies.add(this.parseDependency(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                profile.setDependencies(dependencies);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "repositories", null, parsed)) {
                ArrayList<Repository> repositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("repository".equals(parser2.getName())) {
                        repositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                profile.setRepositories(repositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "pluginRepositories", null, parsed)) {
                ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
                while (parser2.nextTag() == 2) {
                    if ("pluginRepository".equals(parser2.getName())) {
                        pluginRepositories.add(this.parseRepository(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                profile.setPluginRepositories(pluginRepositories);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                profile.setLocation("reports", _location);
                profile.setReports(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reporting", null, parsed)) {
                profile.setReporting(this.parseReporting(parser2, strict, source));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return profile;
    }

    private Relocation parseRelocation(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Relocation relocation = new Relocation();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        relocation.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                relocation.setLocation("groupId", _location);
                relocation.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                relocation.setLocation("artifactId", _location);
                relocation.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                relocation.setLocation("version", _location);
                relocation.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "message", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                relocation.setLocation("message", _location);
                relocation.setMessage(this.interpolatedTrimmed(parser2.nextText(), "message"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return relocation;
    }

    private ReportPlugin parseReportPlugin(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ReportPlugin reportPlugin = new ReportPlugin();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        reportPlugin.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "groupId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportPlugin.setLocation("groupId", _location);
                reportPlugin.setGroupId(this.interpolatedTrimmed(parser2.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "artifactId", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportPlugin.setLocation("artifactId", _location);
                reportPlugin.setArtifactId(this.interpolatedTrimmed(parser2.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "version", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportPlugin.setLocation("version", _location);
                reportPlugin.setVersion(this.interpolatedTrimmed(parser2.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reportSets", null, parsed)) {
                ArrayList<ReportSet> reportSets = new ArrayList<ReportSet>();
                while (parser2.nextTag() == 2) {
                    if ("reportSet".equals(parser2.getName())) {
                        reportSets.add(this.parseReportSet(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                reportPlugin.setReportSets(reportSets);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportPlugin.setLocation("inherited", _location);
                reportPlugin.setInherited(this.interpolatedTrimmed(parser2.nextText(), "inherited"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportPlugin.setLocation("configuration", _location);
                reportPlugin.setConfiguration(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reportPlugin;
    }

    private ReportSet parseReportSet(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        ReportSet reportSet = new ReportSet();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        reportSet.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportSet.setLocation("id", _location);
                reportSet.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "reports", null, parsed)) {
                ArrayList<String> reports = new ArrayList<String>();
                InputLocation _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportSet.setLocation("reports", _locations);
                while (parser2.nextTag() == 2) {
                    if ("report".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(reports.size(), _location);
                        reports.add(this.interpolatedTrimmed(parser2.nextText(), "reports"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                reportSet.setReports(reports);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "inherited", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportSet.setLocation("inherited", _location);
                reportSet.setInherited(this.interpolatedTrimmed(parser2.nextText(), "inherited"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "configuration", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reportSet.setLocation("configuration", _location);
                reportSet.setConfiguration(Xpp3DomBuilder.build(parser2, true, (Xpp3DomBuilder.InputLocationBuilder)new Xpp3DomBuilderInputLocationBuilder(_location)));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reportSet;
    }

    private Reporting parseReporting(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Reporting reporting = new Reporting();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        reporting.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "excludeDefaults", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reporting.setLocation("excludeDefaults", _location);
                reporting.setExcludeDefaults(this.interpolatedTrimmed(parser2.nextText(), "excludeDefaults"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "outputDirectory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                reporting.setLocation("outputDirectory", _location);
                reporting.setOutputDirectory(this.interpolatedTrimmed(parser2.nextText(), "outputDirectory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "plugins", null, parsed)) {
                ArrayList<ReportPlugin> plugins = new ArrayList<ReportPlugin>();
                while (parser2.nextTag() == 2) {
                    if ("plugin".equals(parser2.getName())) {
                        plugins.add(this.parseReportPlugin(parser2, strict, source));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                reporting.setPlugins(plugins);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return reporting;
    }

    private Repository parseRepository(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Repository repository = new Repository();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        repository.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "releases", null, parsed)) {
                repository.setReleases(this.parseRepositoryPolicy(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "snapshots", null, parsed)) {
                repository.setSnapshots(this.parseRepositoryPolicy(parser2, strict, source));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repository.setLocation("id", _location);
                repository.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repository.setLocation("name", _location);
                repository.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repository.setLocation("url", _location);
                repository.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repository.setLocation("layout", _location);
                repository.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repository;
    }

    private RepositoryBase parseRepositoryBase(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryBase repositoryBase = new RepositoryBase();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        repositoryBase.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryBase.setLocation("id", _location);
                repositoryBase.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryBase.setLocation("name", _location);
                repositoryBase.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryBase.setLocation("url", _location);
                repositoryBase.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "layout", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryBase.setLocation("layout", _location);
                repositoryBase.setLayout(this.interpolatedTrimmed(parser2.nextText(), "layout"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryBase;
    }

    private RepositoryPolicy parseRepositoryPolicy(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        repositoryPolicy.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "enabled", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryPolicy.setLocation("enabled", _location);
                repositoryPolicy.setEnabled(this.interpolatedTrimmed(parser2.nextText(), "enabled"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "updatePolicy", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryPolicy.setLocation("updatePolicy", _location);
                repositoryPolicy.setUpdatePolicy(this.interpolatedTrimmed(parser2.nextText(), "updatePolicy"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "checksumPolicy", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                repositoryPolicy.setLocation("checksumPolicy", _location);
                repositoryPolicy.setChecksumPolicy(this.interpolatedTrimmed(parser2.nextText(), "checksumPolicy"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return repositoryPolicy;
    }

    private Resource parseResource(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Resource resource = new Resource();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        resource.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            InputLocation _locations;
            if (this.checkFieldWithDuplicate(parser2, "targetPath", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                resource.setLocation("targetPath", _location);
                resource.setTargetPath(this.interpolatedTrimmed(parser2.nextText(), "targetPath"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "filtering", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                resource.setLocation("filtering", _location);
                resource.setFiltering(this.interpolatedTrimmed(parser2.nextText(), "filtering"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "directory", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                resource.setLocation("directory", _location);
                resource.setDirectory(this.interpolatedTrimmed(parser2.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                resource.setLocation("includes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("include".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(includes.size(), _location);
                        includes.add(this.interpolatedTrimmed(parser2.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                resource.setIncludes(includes);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                _locations = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                resource.setLocation("excludes", _locations);
                while (parser2.nextTag() == 2) {
                    if ("exclude".equals(parser2.getName())) {
                        _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                        _locations.setLocation(excludes.size(), _location);
                        excludes.add(this.interpolatedTrimmed(parser2.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser2, strict);
                }
                resource.setExcludes(excludes);
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return resource;
    }

    private Scm parseScm(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Scm scm = new Scm();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        scm.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            if ("child.scm.connection.inherit.append.path".equals(name2)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("childScmConnectionInheritAppendPath", _location);
                scm.setChildScmConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.connection.inherit.append.path"));
                continue;
            }
            if ("child.scm.developerConnection.inherit.append.path".equals(name2)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("childScmDeveloperConnectionInheritAppendPath", _location);
                scm.setChildScmDeveloperConnectionInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.developerConnection.inherit.append.path"));
                continue;
            }
            if ("child.scm.url.inherit.append.path".equals(name2)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("childScmUrlInheritAppendPath", _location);
                scm.setChildScmUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.scm.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "connection", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("connection", _location);
                scm.setConnection(this.interpolatedTrimmed(parser2.nextText(), "connection"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "developerConnection", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("developerConnection", _location);
                scm.setDeveloperConnection(this.interpolatedTrimmed(parser2.nextText(), "developerConnection"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "tag", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("tag", _location);
                scm.setTag(this.interpolatedTrimmed(parser2.nextText(), "tag"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                scm.setLocation("url", _location);
                scm.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return scm;
    }

    private Site parseSite(XmlPullParser parser2, boolean strict, InputSource source) throws IOException, XmlPullParserException {
        String tagName = parser2.getName();
        Site site = new Site();
        InputLocation _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
        site.setLocation("", _location);
        for (int i2 = parser2.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name2 = parser2.getAttributeName(i2);
            String value = parser2.getAttributeValue(i2);
            if (name2.indexOf(58) >= 0) continue;
            if ("child.site.url.inherit.append.path".equals(name2)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                site.setLocation("childSiteUrlInheritAppendPath", _location);
                site.setChildSiteUrlInheritAppendPath(this.interpolatedTrimmed(value, "child.site.url.inherit.append.path"));
                continue;
            }
            this.checkUnknownAttribute(parser2, name2, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser2.nextTag() : this.nextTag(parser2)) == 2) {
            if (this.checkFieldWithDuplicate(parser2, "id", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                site.setLocation("id", _location);
                site.setId(this.interpolatedTrimmed(parser2.nextText(), "id"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "name", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                site.setLocation("name", _location);
                site.setName(this.interpolatedTrimmed(parser2.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser2, "url", null, parsed)) {
                _location = new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), source);
                site.setLocation("url", _location);
                site.setUrl(this.interpolatedTrimmed(parser2.nextText(), "url"));
                continue;
            }
            this.checkUnknownElement(parser2, strict);
        }
        return site;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }

    private static class Xpp3DomBuilderInputLocationBuilder
    implements Xpp3DomBuilder.InputLocationBuilder {
        private final InputLocation rootLocation;

        public Xpp3DomBuilderInputLocationBuilder(InputLocation rootLocation) {
            this.rootLocation = rootLocation;
        }

        @Override
        public Object toInputLocation(XmlPullParser parser2) {
            return new InputLocation(parser2.getLineNumber(), parser2.getColumnNumber(), this.rootLocation.getSource());
        }
    }
}

