/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.exasol.ExaDialect;
import com.intellij.sql.dialects.exasol.ExaTypes;
import com.intellij.sql.dialects.exasol._ExaLexer;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlTokens;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ExaLexer
extends SqlLexer {
    private static final Set<IElementType> ALLOWED_RESERVED_KW = Set.of(ExaTypes.EXA_RETURNS, ExaTypes.EXA_EMITS, ExaTypes.EXA_TABLE, ExaTypes.EXA_ORDER, ExaTypes.EXA_BY, ExaTypes.EXA_AS, ExaTypes.EXA_ASC, ExaTypes.EXA_DESC, ExaTypes.EXA_FIRST, ExaTypes.EXA_LAST, ExaTypes.EXA_ARRAY, ExaTypes.EXA_BIGINT, ExaTypes.EXA_BOOL, ExaTypes.EXA_BOOLEAN, ExaTypes.EXA_CHAR, ExaTypes.EXA_CHARACTER, ExaTypes.EXA_CLOB, ExaTypes.EXA_DATE, ExaTypes.EXA_DAY, ExaTypes.EXA_DEC, ExaTypes.EXA_DECIMAL, ExaTypes.EXA_DOUBLE, ExaTypes.EXA_FLOAT, ExaTypes.EXA_GEOMETRY, ExaTypes.EXA_HOUR, ExaTypes.EXA_INT, ExaTypes.EXA_INTEGER, ExaTypes.EXA_INTERVAL, ExaTypes.EXA_LARGE, ExaTypes.EXA_MINUTE, ExaTypes.EXA_MONTH, ExaTypes.EXA_NCHAR, ExaTypes.EXA_NUMBER, ExaTypes.EXA_NUMERIC, ExaTypes.EXA_NVARCHAR, ExaTypes.EXA_NVARCHAR2, ExaTypes.EXA_OBJECT, ExaTypes.EXA_REAL, ExaTypes.EXA_SECOND, ExaTypes.EXA_SHORTINT, ExaTypes.EXA_SMALLINT, ExaTypes.EXA_TIMESTAMP, ExaTypes.EXA_TINYINT, ExaTypes.EXA_TO, ExaTypes.EXA_VARCHAR, ExaTypes.EXA_VARCHAR2, ExaTypes.EXA_YEAR);
    private static final Set<IElementType> LOOKAHEAD_BREAKERS_KW = Set.of(SqlCommonTokens.SQL_SEMICOLON, SqlCommonTokens.SQL_OP_DIV);
    protected boolean myScriptState = false;

    public ExaLexer() {
        super(ExaDialect.INSTANCE, (FlexLexer)new _ExaLexer());
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            ExaLexer.$$$reportNull$$$0(0);
        }
        boolean bl = this.myScriptState = initialState < 0;
        if (this.myScriptState) {
            initialState = -initialState - 1;
        }
        super.start(buffer, startOffset, endOffset, initialState);
    }

    protected void addToken(IElementType type) {
        super.addToken(type);
        this.updateScriptState(type);
    }

    public int getState() {
        return this.myScriptState ? -super.getState() - 1 : super.getState();
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            ExaLexer.$$$reportNull$$$0(1);
        }
        if (!this.lookAheadRangeOperator(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    @Override
    protected void lookSqlKeyword(Lexer baseLexer) {
        IElementType type = this.getSqlTokenType(baseLexer);
        if (this.myScriptState && type == ExaTypes.EXA_AS) {
            this.advanceAs(baseLexer, type);
            while (SqlTokens.WS_TOKENS.contains(baseLexer.getTokenType())) {
                this.advanceLexer(baseLexer);
            }
            this.createScriptToken(baseLexer);
            return;
        }
        this.advanceAs(baseLexer, type);
    }

    private void updateScriptState(IElementType type) {
        if (!this.myScriptState) {
            if (type == ExaTypes.EXA_SCRIPT) {
                this.myScriptState = true;
            }
            return;
        }
        if (!ExaDialect.INSTANCE.isReservedKeyword(type)) {
            this.myScriptState = type == null || !LOOKAHEAD_BREAKERS_KW.contains(type);
            return;
        }
        if (type != null && ALLOWED_RESERVED_KW.contains(type)) {
            return;
        }
        this.myScriptState = false;
    }

    private void createScriptToken(Lexer baseLexer) {
        int start2 = baseLexer.getTokenStart();
        int term = ExaLexer.findScriptTerminator(baseLexer.getBufferSequence(), start2, baseLexer.getBufferEnd());
        if (term == start2) {
            return;
        }
        this.addToken(term, this.getScriptTokenType());
        baseLexer.start(baseLexer.getBufferSequence(), term, baseLexer.getBufferEnd(), baseLexer.getState());
    }

    protected IElementType getScriptTokenType() {
        return SqlTokens.SQL_RAW_INPUT;
    }

    public void advance() {
        if (this.myScriptState && this.getTokenType() == ExaTypes.EXA_AS) {
            this.myScriptState = false;
        }
        super.advance();
    }

    private static int findScriptTerminator(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            ExaLexer.$$$reportNull$$$0(2);
        }
        int i2;
        while ((i2 = StringUtil.indexOf((CharSequence)text2, (char)'/', (int)start2, (int)end)) != -1) {
            int prev2;
            int pi = i2 - 1;
            int n = prev2 = pi < start2 ? 13 : (int)text2.charAt(pi);
            if (pi < start2) {
                pi = i2;
            }
            if (prev2 == 10 && pi > start2 && text2.charAt(pi - 1) == '\r') {
                --pi;
            }
            if (prev2 == 10 || prev2 == 13) {
                int next;
                int ni;
                for (ni = i2 + 1; ni < end && text2.charAt(ni) == ' '; ++ni) {
                }
                int n2 = next = ni < end ? (int)text2.charAt(ni) : 13;
                if (next == 10 || next == 13) {
                    return pi;
                }
            }
            start2 = i2 + 1;
        }
        return end;
    }

    public static boolean isValidRawToken(@NotNull CharSequence text2) {
        if (text2 == null) {
            ExaLexer.$$$reportNull$$$0(3);
        }
        if (text2.length() == 0) {
            return false;
        }
        if (Character.isWhitespace(text2.charAt(0))) {
            return false;
        }
        return !Pattern.compile("(?:^|[\\n\\r])/(?:$|[\\n\\r])").matcher(text2).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/exasol/ExaLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findScriptTerminator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRawToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

