/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ItemRemovable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class StringRowTableModel
extends AbstractTableModel
implements ItemRemovable,
EditableModel {
    private final List<String[]> myRows;
    private final String[] myColumnHeaders;
    private final boolean myMutable;

    public StringRowTableModel(String @NotNull [] columnHeaders, boolean mutable) {
        if (columnHeaders == null) {
            StringRowTableModel.$$$reportNull$$$0(0);
        }
        this.myRows = new ArrayList<String[]>();
        this.myColumnHeaders = columnHeaders;
        this.myMutable = mutable;
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnHeaders.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myRows.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int column2) {
        return this.myColumnHeaders[column2];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value = StringUtil.notNullize((String)String.valueOf(aValue));
        if (rowIndex >= this.myRows.size()) {
            if (value.trim().length() == 0) {
                return;
            }
            this.addNewRow(null);
        } else if (value.trim().length() == 0 && this.getRowCount() != 0 && rowIndex != this.getRowCount() - 1 && this.isRowEmpty(rowIndex, columnIndex)) {
            this.myRows.remove(rowIndex);
            this.fireTableDataChanged();
            return;
        }
        this.myRows.get((int)rowIndex)[columnIndex] = value;
        this.fireTableDataChanged();
    }

    private boolean isRowEmpty(int rowIndex, int exceptColumn) {
        boolean rowEmpty = true;
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            rowEmpty &= i2 == exceptColumn || this.myRows.get(rowIndex)[i2].trim().length() == 0;
        }
        return rowEmpty;
    }

    public void setRows(@NotNull List<String[]> rows) {
        if (rows == null) {
            StringRowTableModel.$$$reportNull$$$0(1);
        }
        this.myRows.clear();
        this.myRows.addAll(rows);
        this.fireTableDataChanged();
    }

    public void addNewRow(String[] row) {
        if (this.getRowCount() > 0 && this.isRowEmpty(this.getRowCount() - 1, -1)) {
            return;
        }
        if (row == null || row.length < this.getColumnCount()) {
            int start2 = row == null ? 0 : row.length;
            row = row == null ? new String[this.getColumnCount()] : Arrays.copyOf(row, this.getColumnCount());
            for (int i2 = start2; i2 < this.getColumnCount(); ++i2) {
                row[i2] = "";
            }
        }
        this.myRows.add(row);
        this.fireTableRowsInserted(this.myRows.size() - 1, this.myRows.size() - 1);
    }

    public void clear() {
        this.myRows.clear();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column2) {
        return this.myMutable && column2 < this.getColumnCount() && row < this.getRowCount();
    }

    public void addRow() {
        this.addNewRow(null);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myRows, oldIndex, newIndex);
        this.fireTableDataChanged();
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return this.myMutable;
    }

    public void removeRow(int idx) {
        if (idx >= this.myRows.size()) {
            return;
        }
        this.myRows.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    @NotNull
    public List<String[]> getRows() {
        List<String[]> list = Collections.unmodifiableList(this.myRows);
        if (list == null) {
            StringRowTableModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/StringRowTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/StringRowTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRows";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

