/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.editors.DataGridEditorUtil;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseEditorUtil
extends DataGridEditorUtil {
    private DatabaseEditorUtil() {
    }

    public static int computeLength(@NotNull Iterable<Pair<String, TextAttributesKey>> iterable) {
        if (iterable == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(0);
        }
        int length = 0;
        for (Pair<String, TextAttributesKey> pair : iterable) {
            length += ((String)pair.first).length();
        }
        return length;
    }

    public static void padText(@NotNull ColoredFragmentsBuilder builder, int maxLength, int length) {
        if (builder == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(1);
        }
        for (int i2 = 0; i2 < maxLength - length + 1; ++i2) {
            builder.append(" ");
        }
    }

    public static boolean isTableFile(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(2);
        }
        return DatabaseEditorHelper.isDataFile(file) && DbImplUtilCore.isDataTable(DbImplUtil.getKind(file));
    }

    public static boolean isFamilyFile(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(3);
        }
        return file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)file).getFamily() != null;
    }

    public static <T> ListTableModel<T> createTableModel(final @NotNull ObjectEditorModel model, final @NotNull EditorModelHelper<T> helper, final boolean canExchange) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(5);
        }
        return new ListTableModel<T>(new ColumnInfo[0]){

            public void addRow() {
                Object row = helper.createRow();
                if (row == null) {
                    return;
                }
                this.addRow(row);
                model.commit();
            }

            public void removeRow(int idx) {
                if (!helper.removeRow(this.getItem(idx), idx)) {
                    return;
                }
                super.removeRow(idx);
                model.commit();
            }

            public boolean canExchangeRows(int oldIndex, int newIndex) {
                return canExchange;
            }

            public void exchangeRows(int idx1, int idx2) {
                if (idx1 == idx2) {
                    return;
                }
                if (!helper.exchangeRows(this.getItem(idx1), idx1, this.getItem(idx2), idx2)) {
                    return;
                }
                super.exchangeRows(idx1, idx2);
                model.commit();
            }
        };
    }

    public static <Ed extends DatabaseEditorBaseEx, Das extends DeObject> void cleanupEditors(@NotNull ListTableModel<Ed> model, @NotNull Iterable<? extends Das> objects, @NotNull Function<Das, ? extends Ed> fac) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(6);
        }
        if (objects == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(7);
        }
        if (fac == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(8);
        }
        HashMap<DeObject, DatabaseEditorBaseEx> editors2 = new HashMap<DeObject, DatabaseEditorBaseEx>();
        ArrayList<DatabaseEditorBaseEx> newItems = new ArrayList<DatabaseEditorBaseEx>();
        for (DatabaseEditorBaseEx editor2 : model.getItems()) {
            editors2.put(editor2.getKeyObject(), editor2);
        }
        for (DeObject column2 : objects) {
            DatabaseEditorBaseEx editor3 = (DatabaseEditorBaseEx)editors2.get(column2);
            if (editor3 == null) {
                editor3 = (DatabaseEditorBaseEx)fac.fun((Object)column2);
            }
            editors2.remove(column2);
            newItems.add(editor3);
        }
        for (DatabaseEditorBaseEx editor2 : editors2.values()) {
            Disposer.dispose((Disposable)editor2);
        }
        if (model.getItems().equals(newItems)) {
            return;
        }
        model.setItems(newItems);
    }

    public static void setTableDecoratorMinSize(@NotNull JComponent component, @NotNull JTable table) {
        if (component == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(9);
        }
        if (table == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(10);
        }
    }

    @NotNull
    public static <T extends DataGridEditorUtil.EmbeddableEditor> DbListTableWithEditor<T> createTableWithEditor(@NotNull ListTableModel<T> model, @NotNull DatabaseEditorBase editor2, @Nullable ActionGroup contextMenu) {
        if (model == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(12);
        }
        return new DbListTableWithEditor<T>(model, editor2, contextMenu);
    }

    @NotNull
    public static ShutSplitter createHideableSplitter(@NlsContexts.Label @NotNull String separatorText, @Nullable JComponent first2, @Nullable JComponent second, @Nullable String key2, float defProport) {
        if (separatorText == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(13);
        }
        ShutSplitter splitter = new ShutSplitter(separatorText, key2, defProport);
        if (first2 != null && first2.getPreferredSize().height > JBUI.scale((int)100)) {
            first2.setMinimumSize((Dimension)JBUI.size((int)100));
        }
        splitter.setFirstComponent(first2);
        splitter.setSecondComponent(second);
        ShutSplitter shutSplitter = splitter;
        if (shutSplitter == null) {
            DatabaseEditorUtil.$$$reportNull$$$0(14);
        }
        return shutSplitter;
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T startItemEditing(@Nullable DeObject object, JBListTable table, ListTableModel<T> model) {
        int index = DatabaseEditorUtil.findObjectIndex(object, model);
        if (index == -1) {
            return null;
        }
        TableUtil.selectRows((JTable)table.getTable(), (int[])new int[]{index});
        TableUtil.editCellAt((JTable)table.getTable(), (int)index, (int)0);
        TableUtil.scrollSelectionToVisible((JTable)table.getTable());
        return (T)((DatabaseEditorBaseEx)model.getItem(index));
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T getEditedItem(JBListTable table, ListTableModel<T> model) {
        int index = table.getTable().getEditingRow();
        if (index == -1) {
            return null;
        }
        return (T)((DatabaseEditorBaseEx)model.getItem(index));
    }

    public static <T extends DatabaseEditorBaseEx> int findObjectIndex(@Nullable DeObject object, ListTableModel<T> model) {
        int index = 0;
        for (DatabaseEditorBaseEx ed : model.getItems()) {
            if (ed.getKeyObject() == object) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fac";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideableSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeLength";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "padText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTableFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFamilyFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTableModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cleanupEditors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTableDecoratorMinSize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTableWithEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHideableSplitter";
                break;
            }
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }

    public static class ColoredFragmentsBuilder {
        private JBIterable<Pair<String, TextAttributesKey>> myResult = JBIterable.empty();
        private final StringBuilder myBuffer = new StringBuilder();

        public ColoredFragmentsBuilder append(@NotNull String frag) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(0);
            }
            return this.append(frag, null);
        }

        public ColoredFragmentsBuilder appendRef(@NotNull String frag, boolean good) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(1);
            }
            return this.append(frag, good ? null : CodeInsightColors.WARNINGS_ATTRIBUTES);
        }

        public ColoredFragmentsBuilder append(@NotNull String frag, @Nullable TextAttributesKey attrs) {
            if (frag == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(2);
            }
            if (attrs == null) {
                this.myBuffer.append(frag);
            } else {
                this.finish();
                this.myResult = this.myResult.append((Object)Pair.create((Object)frag, (Object)attrs));
            }
            return this;
        }

        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> build() {
            this.finish();
            JBIterable<Pair<String, TextAttributesKey>> jBIterable = this.myResult;
            if (jBIterable == null) {
                ColoredFragmentsBuilder.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private void finish() {
            if (this.myBuffer.length() == 0) {
                return;
            }
            this.myResult = this.myResult.append((Object)Pair.create((Object)this.myBuffer.toString(), null));
            this.myBuffer.setLength(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendRef";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class EditorModelHelper<T> {
        @Nullable
        public T createRow() {
            return null;
        }

        public boolean removeRow(T item, int idx) {
            return false;
        }

        public boolean exchangeRows(T item0, int idx0, T item1, int idx1) {
            return false;
        }
    }

    public static class DbListTableWithEditor<T extends DataGridEditorUtil.EmbeddableEditor>
    extends DbListTable<T> {
        private boolean myEditable = true;

        public DbListTableWithEditor(ListTableModel<T> model, DatabaseEditorBase editor2, @Nullable ActionGroup contextMenu) {
            super(model, editor2, contextMenu);
        }

        private boolean isSelecting() {
            return this.myMouseEvent != null && ((this.myMouseEvent.getModifiers() & 2) != 0 || (this.myMouseEvent.getModifiers() & 1) != 0 || (this.myMouseEvent.getModifiers() & 8) != 0 || (this.myMouseEvent.getModifiers() & 4) != 0 || this.isNotDoubleClick());
        }

        private boolean isNotDoubleClick() {
            return (this.myMouseEvent.getID() == 500 || this.myMouseEvent.getID() == 502 || this.myMouseEvent.getID() == 501) && this.myMouseEvent.getClickCount() < 2;
        }

        @Override
        protected JBTableRowEditor getRowEditor(final int row) {
            if (this.isSelecting()) {
                return null;
            }
            DataGridEditorUtil.EmbeddableEditor editor2 = (DataGridEditorUtil.EmbeddableEditor)this.getEditor(row);
            if (!this.myEditable || !editor2.canDoAnything()) {
                return null;
            }
            return new DataGridEditorUtil.JBTableRowEditorWrapper<T>(editor2){

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column2) {
                            return myInternalTable.getValueAt(row, column2);
                        }
                    };
                }

                public JComponent[] getFocusableComponents() {
                    return (JComponent[])Arrays.stream(super.getFocusableComponents()).filter(Component::isEnabled).toArray(JComponent[]::new);
                }
            };
        }

        public void setEditable(boolean editable) {
            this.myEditable = editable;
        }
    }

    public static class FlagUpdater
    implements AnActionButtonUpdater {
        private boolean myEnabled = true;

        public FlagUpdater(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                FlagUpdater.$$$reportNull$$$0(0);
            }
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseEditorUtil$FlagUpdater", "isEnabled"));
        }
    }

    public static class DbListTable<T extends DataGridEditorUtil.RowStringProvider>
    extends JBListTable {
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        public DbListTable(@NotNull ListTableModel<T> model, final @NotNull DatabaseEditorBase editor2, @Nullable ActionGroup contextMenu) {
            if (model == null) {
                DbListTable.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                DbListTable.$$$reportNull$$$0(1);
            }
            super((JBTable)new TableView<T>(model){}, (Disposable)editor2);
            this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(editor2.getContext().getProject(), (Language)editor2.getContext().getSqlDialect(), editor2){

                protected String getText(JTable table, int row) {
                    return "";
                }

                private Iterable<Pair<String, TextAttributesKey>> getText(int row) {
                    return this.getEditor(row).getRowText();
                }

                @Nullable
                protected TextAttributes getTextAttributes(JTable table, int row) {
                    return this.getEditor(row).isObjectValid() ? null : this.getColorScheme(table).getAttributes(HighlighterColors.BAD_CHARACTER);
                }

                protected void customizeEditor(@NotNull EditorEx textEditor, JTable table, Object value, boolean selected, int row, int column2) {
                    if (textEditor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    VirtualFile file = FileDocumentManager.getInstance().getFile((Document)textEditor.getDocument());
                    SqlLanguageDialect dialect = editor2.getContext().getSqlDialect();
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)editor2.getContext().getProject(), (VirtualFile)file);
                    EditorColorsScheme scheme = textEditor.getColorsScheme();
                    textEditor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, scheme));
                    textEditor.getMarkupModel().removeAllHighlighters();
                    StringBuilder text2 = new StringBuilder(" ");
                    Iterable<Pair<String, TextAttributesKey>> fragments2 = this.getText(row);
                    IntArrayList ranges = new IntArrayList();
                    ranges.add(text2.length());
                    for (Pair<String, TextAttributesKey> pair : fragments2) {
                        text2.append((String)pair.first);
                        ranges.add(text2.length());
                    }
                    textEditor.getDocument().setText((CharSequence)text2);
                    ((EditorImpl)textEditor).resetSizes();
                    textEditor.getHighlighter().setText((CharSequence)text2);
                    int i2 = 0;
                    for (Pair<String, TextAttributesKey> pair : fragments2) {
                        if (pair.second != null) {
                            textEditor.getMarkupModel().addRangeHighlighter((TextAttributesKey)pair.second, ranges.getInt(i2), ranges.getInt(i2 + 1), 4000, HighlighterTargetArea.EXACT_RANGE);
                        }
                        ++i2;
                    }
                    textEditor.getMarkupModel().addRangeHighlighter(0, textEditor.getDocument().getTextLength(), 4000, this.getTextAttributes(table, row), HighlighterTargetArea.EXACT_RANGE);
                    ((EditorImpl)textEditor).setPaintSelection(selected);
                    SelectionModel selectionModel = textEditor.getSelectionModel();
                    selectionModel.setSelection(0, selected ? textEditor.getDocument().getTextLength() : 0);
                }

                @NotNull
                protected EditorTextFieldCellRenderer.RendererComponent createRendererComponent(@Nullable Project project, @Nullable Language language, boolean inheritFontFromLaF) {
                    return new EditorTextFieldCellRenderer.SimpleRendererComponent(project, language, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable$2", "customizeEditor"));
                }
            };
            JBTable table = this.getTable();
            table.setShowGrid(false);
            table.setCellSelectionEnabled(true);
            table.getSelectionModel().setSelectionMode(2);
            if (contextMenu != null) {
                PopupHandler.installPopupMenu((JComponent)table, (ActionGroup)contextMenu, (String)"DatabaseSignatureEditorPopup");
            }
            table.setSurrendersFocusOnKeystroke(true);
            table.getSelectionModel().setSelectionInterval(0, 0);
            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            table.setVisibleRowCount(4);
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected T getEditor(int row) {
            return (T)((DataGridEditorUtil.RowStringProvider)((TableView)this.myInternalTable).getTableViewModel().getItems().get(row));
        }

        protected JBTableRowEditor getRowEditor(int row) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

