/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.database.util.DbUiUtilCore;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.ComponentWithEmptyText;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public abstract class DbTextEditorBase<E extends BasicElement, S extends DbModelState>
extends DbVisualEditorBase<E, S> {
    private final DbTextModelState.DbTextStateAccessor<S> myTextAccessor;
    protected boolean myInconsistent;

    public DbTextEditorBase(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model, @NotNull DbTextModelState.DbTextStateAccessor<S> textAccessor) {
        if (controller == null) {
            DbTextEditorBase.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbTextEditorBase.$$$reportNull$$$0(1);
        }
        if (textAccessor == null) {
            DbTextEditorBase.$$$reportNull$$$0(2);
        }
        super(controller, model);
        this.myTextAccessor = textAccessor;
    }

    @Override
    protected void applyImpl() {
        Object state = this.getState();
        try {
            this.myTextAccessor.setText(state, this.getText());
            if (this.myInconsistent && !this.isEmpty()) {
                this.myInconsistent = false;
                DbTextEditorBase.markInconsistent(this.getComponent(), false);
            }
            state.setInconsistent(this.myInconsistent);
            DbUiUtilCore.setError(this.getComponent(), null);
        }
        catch (Throwable th) {
            DbUiUtilCore.setError(this.getComponent(), th.getMessage());
        }
    }

    @Override
    protected void resetImpl() {
        Object state = this.getState();
        boolean inconsistent = state.isInconsistent();
        DbTextEditorBase.markInconsistent(this.getComponent(), inconsistent);
        this.setText(this.myTextAccessor.getText(state));
        this.myInconsistent = inconsistent;
    }

    @NotNull
    protected abstract String getText();

    protected abstract void setText(@NotNull String var1);

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbTextEditorBase.$$$reportNull$$$0(3);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.getText().isEmpty();
    }

    static void markInconsistent(JComponent comp, boolean inconsistent) {
        String text2;
        String string = text2 = inconsistent ? DatabaseBundle.message("status.text.different.values", new Object[0]) : "";
        if (comp instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)comp).getEmptyText().setText(text2);
        } else if (comp instanceof EditorTextField) {
            ((EditorTextField)comp).setPlaceholder((CharSequence)text2);
        }
    }

    public static void doNotHideEmptyTextOnFocus(@NotNull JTextField field) {
        if (field == null) {
            DbTextEditorBase.$$$reportNull$$$0(4);
        }
        field.putClientProperty("StatusVisibleFunction", x -> x.getText().isEmpty());
    }

    public static void doNotHideEmptyTextOnFocus(@NotNull EditorTextField field) {
        if (field == null) {
            DbTextEditorBase.$$$reportNull$$$0(5);
        }
        field.setShowPlaceholderWhenFocused(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAccessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbTextEditorBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbTextEditorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doNotHideEmptyTextOnFocus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

