/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.pgpass;

import com.intellij.database.dialects.postgresbase.pgpass.PgPassEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "", "entries", "", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassEntry;", "stamp", "", "<init>", "(Ljava/util/List;J)V", "getEntries", "()Ljava/util/List;", "getStamp", "()J", "entry", "host", "", "port", "database", "user", "Companion", "intellij.database.dialects.postgresbase"})
public final class PgPassFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PgPassEntry> entries;
    private final long stamp;
    @NotNull
    private static final Logger logger;

    public PgPassFile(@NotNull List<PgPassEntry> entries, long stamp) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
        this.stamp = stamp;
    }

    @NotNull
    public final List<PgPassEntry> getEntries() {
        return this.entries;
    }

    public final long getStamp() {
        return this.stamp;
    }

    @Nullable
    public final PgPassEntry entry(@NotNull String host, @NotNull String port, @NotNull String database, @NotNull String user) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            if (logger.isDebugEnabled()) {
                logger.debug("lookup `" + host + ":" + port + ":" + database + ":" + user + "` among .pgpass " + this.entries.size() + " entries");
            }
            Iterable iterable = this.entries;
            for (Object t : iterable) {
                boolean bl;
                PgPassEntry it = (PgPassEntry)t;
                boolean bl2 = false;
                boolean res2 = bl = it.matches(host, port, database, user);
                boolean bl3 = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("check " + it + " = " + res2);
                }
                if (!bl) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Logger logger2 = Logger.getInstance(PgPassFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parse", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "file", "Ljava/io/File;", "splitLine", "", "", "line", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgPassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgPassFile.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion\n+ 2 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n284#2,5:72\n1#3:77\n1#3:78\n*S KotlinDebug\n*F\n+ 1 PgPassFile.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion\n*L\n24#1:72,5\n24#1:77\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PgPassFile parse(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            File $this$useLines_u24default$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines_u24default$iv;
            int n = 8192;
            Object object2 = object;
            object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                object2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)lines, arg_0 -> Companion.parse$lambda$2$lambda$1(file, arg_0)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            long l = file.lastModified();
            Object object3 = object2;
            return new PgPassFile((List<PgPassEntry>)object3, l);
        }

        private final List<String> splitLine(String line) {
            CharIterator cur = StringsKt.iterator((CharSequence)line);
            ArrayList res2 = new ArrayList();
            StringBuilder buffer = new StringBuilder();
            while (cur.hasNext()) {
                char c2 = cur.nextChar();
                switch (c2) {
                    case '\\': {
                        if (cur.hasNext()) {
                            buffer.append(cur.nextChar());
                        }
                        StringBuilder stringBuilder = Unit.INSTANCE;
                        break;
                    }
                    case ':': {
                        ((Collection)res2).add(buffer.toString());
                        StringBuilder stringBuilder = StringsKt.clear((StringBuilder)buffer);
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = buffer.append(c2);
                    }
                }
            }
            ((Collection)res2).add(buffer.toString());
            return res2;
        }

        private static final String parse$lambda$2$lambda$1$asPattern(String $this$parse_u24lambda_u242_u24lambda_u241_u24asPattern) {
            String string;
            String it = string = $this$parse_u24lambda_u242_u24lambda_u241_u24asPattern;
            boolean bl = false;
            return !Intrinsics.areEqual((Object)it, (Object)"*") ? string : null;
        }

        private static final PgPassEntry parse$lambda$2$lambda$1(File $file, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                return null;
            }
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return null;
            }
            List<String> info2 = Companion.splitLine(line);
            if (info2.size() != 5) {
                logger.warn("Unable to parse pgpass file entry `" + $file.getPath() + "` line `" + line + "`");
                return null;
            }
            return new PgPassEntry(com.intellij.database.dialects.postgresbase.pgpass.PgPassFile$Companion.parse$lambda$2$lambda$1$asPattern(info2.get(0)), com.intellij.database.dialects.postgresbase.pgpass.PgPassFile$Companion.parse$lambda$2$lambda$1$asPattern(info2.get(1)), com.intellij.database.dialects.postgresbase.pgpass.PgPassFile$Companion.parse$lambda$2$lambda$1$asPattern(info2.get(2)), com.intellij.database.dialects.postgresbase.pgpass.PgPassFile$Companion.parse$lambda$2$lambda$1$asPattern(info2.get(3)), info2.get(4));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

