/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.mssql.AbstractTsqlDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.psi.MssqlAlterDatabaseStatement;
import com.intellij.sql.dialects.mssql.psi.MssqlFileGroupDefinition;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlAlterInstructionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsDialect
extends AbstractTsqlDialect
implements DatabaseDialect {
    private final Dbms myDbms;

    public MsDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.MsTypeHelper());
        this.myDbms = dbms;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "SQL Server";
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        if (qualifier == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject(qualifier);
        DasObject catalog = DasUtil.getCatalogObject(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName(schema), needQualify ? catalog : null, needQualify ? DasUtil.getName(catalog) : null, null, null);
        if (ddlBuilder == null) {
            MsDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MsDialect.$$$reportNull$$$0(6);
        }
        if (this.myDbms.in(Dbms.AZURE_LIKE)) {
            return null;
        }
        return super.sqlSetSearchPath(path);
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MsDialect.$$$reportNull$$$0(7);
        }
        return dialect instanceof MsDialect;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(8);
        }
        if (element instanceof MssqlAlterDatabaseStatement) {
            for (PsiElement child : SqlImplUtil.sqlChildren(element)) {
                IElementType elementType;
                if (!(PsiUtilCore.getElementType((PsiElement)child) == SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE ? (elementType = PsiUtilCore.getElementType((PsiElement)child.getFirstChild())) == MsTypes.MSSQL_ONLINE || elementType == MsTypes.MSSQL_OFFLINE : child instanceof SqlAlterInstructionImpl && SqlImplUtil.sqlChildren(child).find(e -> e instanceof MssqlFileGroupDefinition || PsiUtilCore.getElementType((PsiElement)e) == MsTypes.MSSQL_FILEGROUP) != null)) continue;
                return true;
            }
        }
        if (element instanceof SqlCallStatement) {
            String name2;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)element, SqlFunctionCallExpression.class);
            SqlReferenceExpression referenceExpression = callExpression != null ? callExpression.getNameElement() : null;
            String string = name2 = referenceExpression != null ? referenceExpression.getName() : null;
            if ("sp_addlinkedserver".equals(name2) || "sp_dropserver".equals(name2)) {
                return true;
            }
        }
        return super.triggersIntrospection(element);
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection2) throws Exception {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(9);
        }
        if (connection2 == null) {
            MsDialect.$$$reportNull$$$0(10);
        }
        Map<String, Object> map2 = DbImplUtilCore.resultRowAsMap(connection2, String.format("EXEC sp_spaceused '%s'", DbImplUtilCore.escapeStr(QNameUtil.getQualifiedName(element))), "rows", "rows");
        if (map2 == null) {
            MsDialect.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (connection2 == null) {
            MsDialect.$$$reportNull$$$0(12);
        }
        List<String> list = DbImplUtilCore.executeAndGetResult(connection2, "SELECT [name] FROM sys.databases d WHERE d.database_id > 4", DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            MsDialect.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static boolean isMsSql2008(@Nullable Version version) {
        return version == null || version.isOrGreater(10, 50);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 13: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 11, 13 -> new IllegalStateException(string);
        };
    }
}

