/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.plan;

import com.intellij.database.dialects.db2.plan.Db2RawPlanData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Db2BuilderState {
    public final Db2RawPlanData shared;
    public final Stream prevStream;

    Db2BuilderState(Db2RawPlanData shared, @Nullable Stream prevStream) {
        this.shared = shared;
        this.prevStream = prevStream;
    }

    public List<ObjectId> nextObjectsIds() {
        ArrayList<ObjectId> res2 = new ArrayList<ObjectId>();
        List<Stream> streams = this.shared.streamsByTargetId.get(this.getCurrentNodeId());
        if (streams != null) {
            for (Stream stream : streams) {
                if (stream.sourceId.objectId == null) continue;
                res2.add(stream.sourceId.objectId);
            }
        }
        return res2;
    }

    public List<Obj> nextObjects() {
        return ContainerUtil.mapNotNull(this.nextObjectsIds(), id -> this.shared.objectById.get(id));
    }

    @Nullable
    public NodeId getCurrentNodeId() {
        if (this.prevStream == null) {
            return new NodeId(1);
        }
        return this.prevStream.sourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Db2BuilderState state = (Db2BuilderState)o;
        return Objects.equals(this.shared, state.shared) && Objects.equals(this.prevStream, state.prevStream);
    }

    public int hashCode() {
        return Objects.hash(this.shared, this.prevStream);
    }

    public static class Stream {
        public final int id;
        public final int predId;
        public final BigDecimal numRows;
        public final NodeId sourceId;
        public final NodeId targetId;

        public Stream(int id, BigDecimal numRows, int predId, NodeId sourceId, NodeId targetId) {
            this.id = id;
            this.numRows = numRows;
            this.predId = predId;
            this.sourceId = sourceId;
            this.targetId = targetId;
        }
    }

    public static class NodeId {
        public final Integer operatorId;
        public final ObjectId objectId;

        public NodeId(@NotNull Integer operatorId) {
            if (operatorId == null) {
                NodeId.$$$reportNull$$$0(0);
            }
            this.operatorId = operatorId;
            this.objectId = null;
        }

        public NodeId(@NotNull ObjectId objectId) {
            if (objectId == null) {
                NodeId.$$$reportNull$$$0(1);
            }
            this.operatorId = null;
            this.objectId = objectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeId id = (NodeId)o;
            if (!Objects.equals(this.operatorId, id.operatorId)) {
                return false;
            }
            return Objects.equals(this.objectId, id.objectId);
        }

        public int hashCode() {
            int result2 = this.operatorId != null ? this.operatorId.hashCode() : 0;
            result2 = 31 * result2 + (this.objectId != null ? this.objectId.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operatorId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "objectId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/db2/plan/Db2BuilderState$NodeId";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ObjectId {
        public final String schema;
        public final String name;

        public ObjectId(String schema, String name2) {
            this.schema = schema;
            this.name = name2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectId id = (ObjectId)o;
            if (!Objects.equals(this.schema, id.schema)) {
                return false;
            }
            return Objects.equals(this.name, id.name);
        }

        public int hashCode() {
            int result2 = this.schema != null ? this.schema.hashCode() : 0;
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            return result2;
        }

        public String toString() {
            if (this.schema == null) {
                return StringUtil.notNullize((String)this.name);
            }
            return this.schema + "." + StringUtil.notNullize((String)this.name);
        }
    }

    public static class Obj {
        public final ObjectId id;
        public final String type;

        public Obj(ObjectId id, String type) {
            this.id = id;
            this.type = type;
        }
    }

    public static class Operator {
        public final int id;
        public final String type;
        public final double totalCost;
        public final double ioCost;
        public final double cpuCost;
        public final double firstRowCost;

        public Operator(int id, String type, double totalCost, double ioCost, double cpuCost, double firstRowCost) {
            this.id = id;
            this.type = type;
            this.totalCost = totalCost;
            this.ioCost = ioCost;
            this.cpuCost = cpuCost;
            this.firstRowCost = firstRowCost;
        }
    }
}

