/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.HeadlessException;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BigQueryErrorHandler
extends BaseDatabaseErrorHandler {
    private final Pattern myErrorOffsetPattern = Pattern.compile("Message: Syntax error:.*at \\[(\\d+):(\\d+)]");

    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        if (original == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(1);
        }
        if (original instanceof SQLException && cause instanceof RuntimeException && !(cause instanceof HeadlessException)) {
            return new BigQueryTableNotExistErrorInfo(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource, original, cause);
        if (errorInfo == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(2);
        }
        return errorInfo;
    }

    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        Matcher matcher;
        if (project == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(3);
        }
        if (errorInfo == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(4);
        }
        if (queryText == null) {
            BigQueryErrorHandler.$$$reportNull$$$0(5);
        }
        if (!(matcher = this.myErrorOffsetPattern.matcher(errorInfo.getMessage())).find()) {
            return -1;
        }
        int line = StringUtil.parseInt((String)matcher.group(1), (int)0) - 1;
        int column2 = StringUtil.parseInt((String)matcher.group(2), (int)0) - 1;
        if (line == -1 || column2 == -1) {
            return -1;
        }
        return StringUtil.lineColToOffset((CharSequence)queryText, (int)line, (int)column2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/bigquery/BigQueryErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/bigquery/BigQueryErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class BigQueryTableNotExistErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        BigQueryTableNotExistErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                BigQueryTableNotExistErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                BigQueryTableNotExistErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                BigQueryTableNotExistErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                BigQueryTableNotExistErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/bigquery/BigQueryErrorHandler$BigQueryTableNotExistErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

