/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.plan;

import com.intellij.database.diagram.plan.QueryPlanEdge;
import com.intellij.database.diagram.plan.QueryPlanNode;
import com.intellij.database.plan.PlanModel;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QueryPlanDataModel
extends DiagramDataModel<PlanModel.GenericNode> {
    @Nullable
    private final PlanModel myModel;
    private final Collection<DiagramNode<PlanModel.GenericNode>> myNodes = new HashSet<DiagramNode<PlanModel.GenericNode>>();
    private final Collection<DiagramEdge<PlanModel.GenericNode>> myEdges = new HashSet<DiagramEdge<PlanModel.GenericNode>>();

    public QueryPlanDataModel(Project project, PlanModel.GenericNode node, DiagramProvider<PlanModel.GenericNode> provider) {
        super(project, provider);
        this.myModel = node == null ? null : node.getModel();
    }

    @NotNull
    public Collection<DiagramNode<PlanModel.GenericNode>> getNodes() {
        Collection<DiagramNode<PlanModel.GenericNode>> collection = this.myNodes;
        if (collection == null) {
            QueryPlanDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<PlanModel.GenericNode>> getEdges() {
        Collection<DiagramEdge<PlanModel.GenericNode>> collection = this.myEdges;
        if (collection == null) {
            QueryPlanDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<PlanModel.GenericNode> node) {
        if (node == null) {
            QueryPlanDataModel.$$$reportNull$$$0(2);
        }
        PlanModel.GenericNode element = (PlanModel.GenericNode)node.getIdentifyingElement();
        String string = element.getFullTitle();
        if (string == null) {
            QueryPlanDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<PlanModel.GenericNode> addElement(PlanModel.GenericNode element) {
        return null;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = NEVER_CHANGED;
        if (modificationTracker == null) {
            QueryPlanDataModel.$$$reportNull$$$0(4);
        }
        return modificationTracker;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    public synchronized void updateDataModel() {
        if (this.myModel == null) {
            return;
        }
        HashMap<PlanModel.GenericNode, QueryPlanNode> index = new HashMap<PlanModel.GenericNode, QueryPlanNode>();
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)new JBTreeTraverser(n -> this.newChildNodes(n.getIdentifyingElement())).withRoots(this.newChildNodes(this.myModel.getRoot()))).biOrderDfsTraversal().typedIterator();
        while (it.advance()) {
            QueryPlanNode cur = (QueryPlanNode)((Object)it.current());
            PlanModel.GenericNode n2 = cur.getIdentifyingElement();
            PlanModel.GenericNode closed = PlanModel.RefNode.closeReference(n2);
            if (!it.isDescending()) {
                if (closed != n2) continue;
                this.myNodes.add((DiagramNode<PlanModel.GenericNode>)cur);
                continue;
            }
            QueryPlanNode parent = (QueryPlanNode)((Object)it.parent());
            index.put(n2, cur);
            if (closed != n2) {
                cur = Objects.requireNonNull((QueryPlanNode)((Object)index.get(closed)));
            }
            if (parent == null) continue;
            this.myEdges.add(QueryPlanDataModel.newEdge(cur, parent));
        }
    }

    private static DiagramEdge<PlanModel.GenericNode> newEdge(QueryPlanNode node, QueryPlanNode parent) {
        Double maxCoast = null;
        Double minCoast = null;
        for (PlanModel.GenericNode child : parent.getIdentifyingElement().getChildren()) {
            Double c2 = PlanModel.RefNode.closeReference(child).getTotalCost();
            if (c2 == null) continue;
            if (minCoast == null || minCoast > c2) {
                minCoast = c2;
            }
            if (maxCoast != null && !(maxCoast < c2)) continue;
            maxCoast = c2;
        }
        if (minCoast == null) {
            minCoast = 0.0;
        }
        if (maxCoast == null) {
            maxCoast = 0.0;
        }
        double d = maxCoast - minCoast;
        Double c3 = node.getIdentifyingElement().getTotalCost();
        int w = d < 0.1 || c3 == null ? 1 : 1 + (int)Math.round((c3 - minCoast) * 20.0 / d);
        return new QueryPlanEdge((DiagramNode<PlanModel.GenericNode>)parent, (DiagramNode<PlanModel.GenericNode>)node, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter.Builder().setName("REFERENCES").setLineType(DiagramLineType.SOLID).setWidth(w).setTargetArrow(DiagramRelationshipInfo.DELTA).create());
    }

    @NotNull
    private JBIterable<QueryPlanNode> newChildNodes(@NotNull PlanModel.GenericNode n) {
        if (n == null) {
            QueryPlanDataModel.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])n.getChildren()).transform(this::newNode);
        if (jBIterable == null) {
            QueryPlanDataModel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    private QueryPlanNode newNode(@NotNull PlanModel.GenericNode n) {
        if (n == null) {
            QueryPlanDataModel.$$$reportNull$$$0(7);
        }
        return new QueryPlanNode(n, (DiagramProvider<PlanModel.GenericNode>)this.getProvider());
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/plan/QueryPlanDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/plan/QueryPlanDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newChildNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newChildNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

