/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.AbstractDataSourceType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportSettings {
    private static final Logger LOG = Logger.getInstance(ImportSettings.class);
    private static final String IMPORT_MODALITY = "import_modality_state";
    private static final String ERROR_DIRECTORY = "import_error_directory";
    private static final String WRITE_ERRORS = "import_write_errors";
    private static final String INSERT_AS_NULL = "insert_as_null";
    private static final String SCHEMA_MAPPING = "import_schema_mapping";

    public static void store(@NotNull ImportInfo info2) {
        String errorRecordsPath;
        boolean hasPath;
        if (info2 == null) {
            ImportSettings.$$$reportNull$$$0(0);
        }
        PropertiesComponent props = PropertiesComponent.getInstance();
        ImportType type = info2.getType();
        Dbms dbms = info2.getContext().getDbms();
        DbDataSource dataSource = info2.getContext().getDataSource();
        Version version = dataSource == null ? null : dataSource.getVersion();
        ImportManager manager = ImportManager.of(dbms, version);
        if (type.tableExists() && manager.isSupportFastMode()) {
            props.setValue(IMPORT_MODALITY, String.valueOf(info2.shouldLockTable()));
        }
        boolean bl = hasPath = (errorRecordsPath = info2.getErrorTaskInfo().getErrorRecordsPath()) != null;
        if (hasPath) {
            props.setValue(ERROR_DIRECTORY, ImportSettings.getErrorDirectory(errorRecordsPath));
        }
        props.setValue(WRITE_ERRORS, hasPath);
        props.setValue(INSERT_AS_NULL, info2.isInsertAsNull());
        ImportSourceType inputType = info2.getInputType();
        if (inputType instanceof AbstractDataSourceType) {
            ImportSettings.saveTargetSchema(info2, (AbstractDataSourceType)inputType);
        }
    }

    private static void saveTargetSchema(@NotNull ImportInfo info2, @NotNull AbstractDataSourceType inputType) {
        if (info2 == null) {
            ImportSettings.$$$reportNull$$$0(1);
        }
        if (inputType == null) {
            ImportSettings.$$$reportNull$$$0(2);
        }
        Project project = info2.getContext().getProject();
        PropertiesComponent props = PropertiesComponent.getInstance((Project)project);
        ObjectPath sourcePath = SearchPath.getCurrent(inputType.getSearchPath());
        DbNamespace namespace = ((ImportEditorContext)info2.getContext()).getNamespace();
        ObjectPath targetPath = ObjectPaths.of(namespace);
        if (sourcePath == null || targetPath == null) {
            return;
        }
        ImportSchemaMapping mapping = ImportSettings.deserialize(props.getValue(SCHEMA_MAPPING));
        if (mapping == null) {
            mapping = new ImportSchemaMapping();
        }
        String sourceDataSourceId = inputType.myProducerLocalDataSource.getUniqueId();
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        mapping.mapping.removeIf(m -> ImportSettings.sourceEquals(m, sourceDataSourceId, sourcePath.serialize()) || storage.getDataSourceById(m.sourceDataSourceId) == null);
        mapping.mapping = ImportSettings.trimStart(mapping.mapping, 20, 10);
        mapping.mapping.add(new ImportSchemaMapping.ImportSchemaMappingItem(sourceDataSourceId, sourcePath.serialize(), namespace.getDataSource().getUniqueId(), targetPath.serialize()));
        props.setValue(SCHEMA_MAPPING, ImportSettings.serialize(mapping));
    }

    private static <T> List<T> trimStart(@NotNull List<T> list, int limit, int newSize) {
        if (list == null) {
            ImportSettings.$$$reportNull$$$0(3);
        }
        return list.size() <= limit ? list : list.subList(list.size() - newSize, list.size());
    }

    private static boolean sourceEquals(@NotNull ImportSchemaMapping.ImportSchemaMappingItem m, @Nullable String sourceDataSourceId, @Nullable String sourcePath) {
        if (m == null) {
            ImportSettings.$$$reportNull$$$0(4);
        }
        return m.sourceDataSourceId.equals(sourceDataSourceId) && m.sourcePath.equals(sourcePath);
    }

    @Nullable
    private static ImportSchemaMapping deserialize(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return (ImportSchemaMapping)XmlSerializer.deserialize((Element)JDOMUtil.load((CharSequence)value), ImportSchemaMapping.class);
        }
        catch (XmlSerializationException | IOException | JDOMException e) {
            LOG.error(e);
            return null;
        }
    }

    @NotNull
    private static String serialize(@NotNull ImportSchemaMapping mapping) {
        if (mapping == null) {
            ImportSettings.$$$reportNull$$$0(5);
        }
        String string = JDOMUtil.write((Element)XmlSerializer.serialize((Object)mapping));
        if (string == null) {
            ImportSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static Pair<LocalDataSource, ObjectPath> getTarget(@NotNull DasDataSource dataSource, @Nullable ObjectPath sourcePath, @NotNull Project project) {
        if (dataSource == null) {
            ImportSettings.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ImportSettings.$$$reportNull$$$0(8);
        }
        if (sourcePath == null) {
            return null;
        }
        ImportSchemaMapping mapping = ImportSettings.deserialize(PropertiesComponent.getInstance((Project)project).getValue(SCHEMA_MAPPING));
        if (mapping == null) {
            return null;
        }
        String sourcePathSerialized = sourcePath.serialize();
        ImportSchemaMapping.ImportSchemaMappingItem item = (ImportSchemaMapping.ImportSchemaMappingItem)ContainerUtil.find(mapping.mapping, m -> ImportSettings.sourceEquals(m, dataSource.getUniqueId(), sourcePathSerialized));
        LocalDataSource localDataSource = item == null ? null : DataSourceStorage.getProjectStorage(project).getDataSourceById(item.targetDataSourceId);
        ObjectPath targetPath = localDataSource == null ? null : ObjectPath.deserialize(item.targetPath);
        return localDataSource == null || targetPath == null ? null : new Pair((Object)localDataSource, (Object)targetPath);
    }

    @NotNull
    public static String getErrorDirectory(@NotNull String errorPath) {
        Path path;
        if (errorPath == null) {
            ImportSettings.$$$reportNull$$$0(9);
        }
        Path dir = Files.isDirectory(path = Paths.get(errorPath, new String[0]), new LinkOption[0]) ? path : path.getParent();
        String string = dir == null ? SystemProperties.getUserHome() : dir.toAbsolutePath().toString();
        if (string == null) {
            ImportSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean getImportModality() {
        return ImportSettings.get(IMPORT_MODALITY);
    }

    public static boolean getWriteErrors() {
        return ImportSettings.get(WRITE_ERRORS, true);
    }

    public static boolean getInsertAsNull() {
        return ImportSettings.get(INSERT_AS_NULL);
    }

    @Nullable
    public static String getErrorDirectory() {
        String value = PropertiesComponent.getInstance().getValue(ERROR_DIRECTORY);
        return value == null || value.equals("/") ? null : value;
    }

    private static boolean get(@NotNull String key2) {
        if (key2 == null) {
            ImportSettings.$$$reportNull$$$0(11);
        }
        return ImportSettings.get(key2, false);
    }

    private static boolean get(@NotNull String key2, boolean defaultValue) {
        String value;
        if (key2 == null) {
            ImportSettings.$$$reportNull$$$0(12);
        }
        return (value = PropertiesComponent.getInstance().getValue(key2)) == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTargetSchema";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sourceEquals";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }

    @Tag(value="schema-mapping")
    public static final class ImportSchemaMapping {
        private static final int MAX_SIZE = 20;
        @Tag(value="databases")
        public List<ImportSchemaMappingItem> mapping = new ArrayList<ImportSchemaMappingItem>();

        @Tag(value="schema-mapping-item")
        public static final class ImportSchemaMappingItem {
            @Tag(value="source-data-source-id")
            String sourceDataSourceId;
            @Tag(value="source-path")
            String sourcePath;
            @Tag(value="target-data-source-id")
            String targetDataSourceId;
            @Tag(value="target-path")
            String targetPath;

            ImportSchemaMappingItem() {
            }

            private ImportSchemaMappingItem(@NotNull String sourceDataSourceId, @NotNull String sourcePath, @NotNull String targetDataSourceId, @NotNull String targetPath) {
                if (sourceDataSourceId == null) {
                    ImportSchemaMappingItem.$$$reportNull$$$0(0);
                }
                if (sourcePath == null) {
                    ImportSchemaMappingItem.$$$reportNull$$$0(1);
                }
                if (targetDataSourceId == null) {
                    ImportSchemaMappingItem.$$$reportNull$$$0(2);
                }
                if (targetPath == null) {
                    ImportSchemaMappingItem.$$$reportNull$$$0(3);
                }
                this.sourceDataSourceId = sourceDataSourceId;
                this.sourcePath = sourcePath;
                this.targetDataSourceId = targetDataSourceId;
                this.targetPath = targetPath;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceDataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourcePath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetDataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetPath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dbimport/ImportSettings$ImportSchemaMapping$ImportSchemaMappingItem";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

