/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class DataSourceStorageIgnoredFiles
implements IgnoredFileProvider {
    @NlsSafe
    public static final @NlsContexts.DetailedDescription String DESCRIPTION = "Datasource local storage ignored files";

    DataSourceStorageIgnoredFiles() {
    }

    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        if (project == null) {
            DataSourceStorageIgnoredFiles.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            DataSourceStorageIgnoredFiles.$$$reportNull$$$0(1);
        }
        String storageDir = DataSourceStorage.getStorageDir(project);
        return ProjectKt.isEqualToProjectFileStorePath((Project)project, (Path)Paths.get(filePath.getPath(), new String[0]), (String)"dataSources.local.xml") || storageDir != null && FileUtil.isAncestor((String)storageDir, (String)filePath.getPath(), (boolean)false);
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        if (project == null) {
            DataSourceStorageIgnoredFiles.$$$reportNull$$$0(2);
        }
        LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
        String storageDir = DataSourceStorage.getStorageDir(project);
        if (storageDir != null) {
            ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)storageDir, (Project)project));
        }
        if (ProjectKt.isDirectoryBased((Project)project)) {
            Path dataSourcesLocalIgnore = ProjectKt.getStateStore((Project)project).getStorageManager().expandMacro("dataSources.local.xml");
            ignored.add(IgnoredBeanFactory.ignoreFile((String)FileUtil.toSystemIndependentName((String)dataSourcesLocalIgnore.toString()), (Project)project));
        }
        Set set = ContainerUtil.unmodifiableOrEmptySet(ignored);
        if (set == null) {
            DataSourceStorageIgnoredFiles.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        return DESCRIPTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceStorageIgnoredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceStorageIgnoredFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredFiles";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

