/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CliConfiguration {
    @NotNull
    public Map<String, String> getInfoMap();

    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> var1);

    @NotNull
    public String getValidationCommand();

    @NotNull
    public String getPartOfValidationOut();

    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> var1, @NotNull String var2);

    @NotNull
    public String getCommand(@NotNull String var1, @NotNull Parameters var2);

    @NlsSafe
    @NotNull
    public String getName();

    @NotNull
    public List<CliComponent> createComponents(@NotNull CliModel var1);

    @NotNull
    public String getPropertyKey();

    @NotNull
    public CliParameterSearcher getFileParameterSearcher();

    @NotNull
    public LexemeIndicators getPasswordIndicators();

    @NotNull
    public LexemeIndicators getUsernameIndicators();

    @NotNull
    public LexemeIndicators getHostIndicators();

    @NotNull
    public LexemeIndicators getPortIndicators();

    @Nullable
    public LexemeIndicators getSslCaIndicators();

    @Nullable
    public LexemeIndicators getSslCertIndicators();

    @Nullable
    public LexemeIndicators getSslKeyIndicators();

    @NotNull
    public String getHelpCommand();

    @Nullable
    public String getDefaultSearchPath();

    @NotNull
    public CliDialogValidator getValidator();

    @NotNull
    public List<String> getParameterizableArguments();

    @NotNull
    public CliBuilder getCliBuilder(@NotNull Project var1);

    @NotNull
    public CliParameterProcessor getParameterProcessor();

    @NotNull
    public Operation getOperation();

    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer();

    @Nullable
    public CliSubstitutor getSubstitutor();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Operation {
        DUMP{

            @Override
            @NotNull
            String getTaskTitle() {
                String string = DatabaseBundle.message("progress.title.dumping", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NlsContexts.ProgressText
            public String getStartText(String name2, String dsName) {
                return DatabaseBundle.message("progress.text.dumping.with", name2, dsName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$1", "getTaskTitle"));
            }
        }
        ,
        RESTORE{

            @Override
            @NotNull
            String getTaskTitle() {
                String string = DatabaseBundle.message("progress.title.restoring", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NlsContexts.ProgressText
            public String getStartText(String name2, String dsName) {
                return DatabaseBundle.message("progress.text.restoring.with", name2, dsName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$2", "getTaskTitle"));
            }
        };


        @NlsContexts.ProgressTitle
        @NotNull
        abstract String getTaskTitle();

        @NlsContexts.ProgressText
        @NotNull
        abstract String getStartText(String var1, String var2);
    }

    public static interface CliParameterSearcher {
        @Nullable
        public String search(@NotNull String var1, @NotNull List<String> var2);

        @Nullable
        public TextRange searchRange(@NotNull String var1, @NotNull List<String> var2);
    }

    public static interface CliNotificationManager {
        public void start(@NotNull ProgressIndicator var1, @NotNull DasDataSource var2);

        public void update(@NotNull ProgressIndicator var1, @NotNull DataAuditors.PrintingAdapter var2, @NlsContexts.ProgressDetails @NotNull String var3, @NotNull Key var4);

        public void finished(@NotNull String var1, @NotNull DataAuditors.PrintingAdapter var2, boolean var3);
    }

    public static interface CliParameterProcessor {
        @NotNull
        public String process(@NotNull CliLexeme var1, @NotNull String var2);
    }

    public static interface CliBuilder {
        @NotNull
        public Pair<GeneralCommandLine, String> build(@NotNull CliBuilderContext var1);

        @NotNull
        public CliNotificationManager getNotificationManager();

        public void primeProcess(@NotNull OSProcessHandler var1, @NotNull GeneralCommandLine var2, @NotNull CliBuilderContext var3);
    }

    public record CliBuilderContext(@NotNull LocalDataSource dataSource, @NotNull List<String> parameterizable, @NotNull String command, @Nullable String password, @NotNull CliRunTarget runTarget, @Nullable WSLDistribution wslDistribution) {
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final List<String> parameterizable;
        @NotNull
        private final String command;
        @NotNull
        private final CliRunTarget runTarget;

        public CliBuilderContext(@NotNull LocalDataSource dataSource, @NotNull List<String> parameterizable, @NotNull String command, @Nullable String password, @NotNull CliRunTarget runTarget, @Nullable WSLDistribution wslDistribution) {
            if (dataSource == null) {
                CliBuilderContext.$$$reportNull$$$0(0);
            }
            if (parameterizable == null) {
                CliBuilderContext.$$$reportNull$$$0(1);
            }
            if (command == null) {
                CliBuilderContext.$$$reportNull$$$0(2);
            }
            if (runTarget == null) {
                CliBuilderContext.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public CliBuilderContext copy(@NotNull String command) {
            if (command == null) {
                CliBuilderContext.$$$reportNull$$$0(4);
            }
            return new CliBuilderContext(this.dataSource(), this.parameterizable(), command, this.password(), this.runTarget, this.wslDistribution());
        }

        @NotNull
        public LocalDataSource dataSource() {
            LocalDataSource localDataSource = this.dataSource;
            if (localDataSource == null) {
                CliBuilderContext.$$$reportNull$$$0(5);
            }
            return localDataSource;
        }

        @NotNull
        public List<String> parameterizable() {
            List<String> list = this.parameterizable;
            if (list == null) {
                CliBuilderContext.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        public String command() {
            String string = this.command;
            if (string == null) {
                CliBuilderContext.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public CliRunTarget runTarget() {
            CliRunTarget cliRunTarget = this.runTarget;
            if (cliRunTarget == null) {
                CliBuilderContext.$$$reportNull$$$0(8);
            }
            return cliRunTarget;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runTarget";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfiguration$CliBuilderContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfiguration$CliBuilderContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dataSource";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parameterizable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "command";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class Parameters {
        public String username;
        public String host;
        public String port;
        public String sslCa;
        public String sslCert;
        public String sslKey;

        public Parameters(@Nullable String username, @Nullable String host, @Nullable String port, @Nullable String sslCa, @Nullable String sslCert, @Nullable String sslKey) {
            this.username = username;
            this.host = host;
            this.port = port;
            this.sslCa = sslCa;
            this.sslCert = sslCert;
            this.sslKey = sslKey;
        }

        @NotNull
        public Parameters withHost(@NotNull String host) {
            if (host == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            this.host = host;
            Parameters parameters = this;
            if (parameters == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            return parameters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfiguration$Parameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfiguration$Parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withHost";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface CliSubstitutor {
        @NotNull
        public String substitute(@NotNull CliBuilderContext var1);

        @NotNull
        @NlsContexts.DetailedDescription
        public String getDocumentation();

        @NotNull
        public Collection<String> getDefaultPatterns();
    }
}

