/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.openapi.util.text.StringUtil;
import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.io.Reader;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvReader {
    private long myCharacters;
    private long myLine;
    private long myLineCharacters;
    private int myLocalCount;
    private final CyclicBuffer myBuffer;

    public CsvReader(@NotNull Reader reader) {
        if (reader == null) {
            CsvReader.$$$reportNull$$$0(0);
        }
        this.myBuffer = new CyclicBuffer(reader, 0xA00000);
    }

    public long getLine() {
        return this.myLine;
    }

    public long getCharacters() {
        return this.myCharacters;
    }

    public long getLineCharacters() {
        return this.myLineCharacters;
    }

    public boolean read(@NotNull String value) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(1);
        }
        return this.read(value, false);
    }

    public boolean read(@NotNull String value, boolean eofIsOk) throws IOException {
        int count;
        if (value == null) {
            CsvReader.$$$reportNull$$$0(2);
        }
        if ((count = this.matchInner(0, value, eofIsOk)) == -1) {
            return false;
        }
        this.updateCountersFromString(value, count);
        this.myBuffer.moveHead(count);
        return true;
    }

    private void updateCountersFromString(@NotNull String value, int charCnt) {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(3);
        }
        this.myCharacters += (long)charCnt;
        int e = value.length();
        for (int i = 0; i < e; ++i) {
            if (value.charAt(i) == '\n') {
                ++this.myLine;
                this.myLineCharacters = 0L;
                continue;
            }
            ++this.myLineCharacters;
        }
    }

    public boolean lookAhead(@NotNull String value) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(4);
        }
        return this.matchAhead(value, false) != -1;
    }

    public int matchAhead(@NotNull RunAutomaton automaton, int enlargeGap) throws IOException {
        if (automaton == null) {
            CsvReader.$$$reportNull$$$0(5);
        }
        int state = automaton.getInitialState();
        this.myLocalCount = 0;
        int lastOk = -1;
        while (this.myLocalCount < 0x500000 && (lastOk == -1 || this.myLocalCount - lastOk < enlargeGap)) {
            this.myBuffer.ensureAvailable(this.myLocalCount + 2);
            int c = this.getCharNormalized(this.myLocalCount, 1);
            state = automaton.step(state, c == -1 ? (char)'\u0000' : (char)c);
            if (state == -1) {
                return lastOk;
            }
            if (automaton.isAccept(state)) {
                lastOk = this.myLocalCount;
                continue;
            }
            if (c != -1) continue;
            return lastOk;
        }
        return lastOk;
    }

    private int getCharNormalized(int idx, int dir) {
        int ac;
        int c = this.myBuffer.charAhead(idx);
        if (c == -1) {
            return -1;
        }
        ++this.myLocalCount;
        int n = c == 10 ? 13 : (ac = c == 13 ? 10 : 0);
        if (ac != 0 && (dir > 0 || idx > 0)) {
            c = this.myBuffer.charAhead(idx + dir);
            if (c == ac) {
                ++this.myLocalCount;
            }
            c = 10;
        }
        return c;
    }

    public int matchAhead(@NotNull String value, boolean eofIsOk) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(6);
        }
        return this.matchAhead(0, value, eofIsOk);
    }

    public int matchAhead(int start, @NotNull String value, boolean eofIsOk) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(7);
        }
        if (value.length() == 0) {
            return -1;
        }
        return this.matchInner(start, value, eofIsOk);
    }

    private int matchInner(int start, @NotNull String value, boolean eofIsOk) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(8);
        }
        if (value.length() == 0) {
            return -1;
        }
        this.myBuffer.ensureAvailable(start + value.length() * 2);
        this.myLocalCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            int c = this.getCharNormalized(start + this.myLocalCount, 1);
            if (c == -1) {
                return eofIsOk ? this.myLocalCount : -1;
            }
            if (value.charAt(i) == c) continue;
            return -1;
        }
        return this.myLocalCount;
    }

    public int matchBackward(int start, @NotNull String value) throws IOException {
        if (value == null) {
            CsvReader.$$$reportNull$$$0(9);
        }
        if (value.length() == 0 || value.length() > start) {
            return -1;
        }
        this.myBuffer.ensureAvailable(start + 1);
        this.myLocalCount = 0;
        for (int i = value.length() - 1; i >= 0; --i) {
            if (this.myLocalCount > start) {
                return -1;
            }
            int c = this.getCharNormalized(start - this.myLocalCount - 1, -1);
            if (c != -1 && value.charAt(i) == c) continue;
            return -1;
        }
        return this.myLocalCount;
    }

    public int matchBackward(int start, @NotNull RunAutomaton automaton, int maxCount) throws IOException {
        if (automaton == null) {
            CsvReader.$$$reportNull$$$0(10);
        }
        this.myBuffer.ensureAvailable(start + 1);
        int state = automaton.getInitialState();
        this.myLocalCount = 0;
        int lastOk = -1;
        if (this.myBuffer.charAhead(start) == -1) {
            state = automaton.step(state, '\u0000');
            if (start == -1) {
                return -1;
            }
            if (automaton.isAccept(state)) {
                lastOk = 0;
            }
        }
        while (this.myLocalCount < start && this.myLocalCount < maxCount) {
            int c = this.getCharNormalized(start - this.myLocalCount - 1, -1);
            if (c == 0) {
                return -1;
            }
            if ((state = automaton.step(state, (char)c)) == -1) {
                return lastOk;
            }
            if (automaton.isAccept(state)) {
                lastOk = this.myLocalCount;
                continue;
            }
            if (c != -1) continue;
            return lastOk;
        }
        return lastOk;
    }

    public boolean isReady() throws IOException {
        this.myBuffer.ensureAvailable(1);
        int c = this.myBuffer.charAhead(0);
        return c != -1;
    }

    @Nullable
    public String readString(int count) throws IOException {
        int c;
        this.myBuffer.ensureAvailable(count * 2);
        StringBuilder sb = new StringBuilder(count);
        this.myLocalCount = 0;
        while (this.myLocalCount < count && (c = this.getCharNormalized(this.myLocalCount, 1)) != -1) {
            sb.append((char)c);
        }
        if (sb.isEmpty()) {
            return null;
        }
        this.myBuffer.moveHead(this.myLocalCount);
        String result = sb.toString();
        this.updateCountersFromString(result, this.myLocalCount);
        return result;
    }

    @Nullable
    public String readAhead(int count) throws IOException {
        if (count == 0) {
            return null;
        }
        this.myBuffer.ensureAvailable(count);
        String result = this.myBuffer.subStringAhead(0, Math.min(count, this.myBuffer.getAvailable()));
        return StringUtil.convertLineSeparators((String)result);
    }

    public void close() throws IOException {
        this.myBuffer.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "automaton";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/CsvReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountersFromString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "matchAhead";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "matchInner";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "matchBackward";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CyclicBuffer {
        private final Reader myReader;
        private final char[] myBuffer;
        private int myHead;
        private int myAvailable;
        private boolean myEof;

        private CyclicBuffer(@NotNull Reader reader, int bufLen) {
            if (reader == null) {
                CyclicBuffer.$$$reportNull$$$0(0);
            }
            this.myHead = 0;
            this.myAvailable = 0;
            this.myEof = false;
            this.myReader = reader;
            this.myBuffer = new char[bufLen];
        }

        private void moveHead(int n) {
            int n2 = Math.min(n, this.myAvailable);
            this.myHead = this.cyc(this.myHead + n2);
            this.myAvailable -= n2;
        }

        private int charAhead(int i) {
            if (i < this.myAvailable) {
                return this.myBuffer[this.cyc(this.myHead + i)];
            }
            if (this.myEof) {
                return -1;
            }
            throw new BufferUnderflowException();
        }

        private int cyc(int n) {
            return (this.myBuffer.length + n) % this.myBuffer.length;
        }

        private void ensureAvailable(int required) throws IOException {
            if (this.myEof) {
                return;
            }
            if (this.myAvailable >= required) {
                return;
            }
            int toRead = required - this.myAvailable;
            this.readMore(toRead, Math.max(toRead, (this.myBuffer.length - this.myAvailable) * 3 / 4));
        }

        private void readMore(int amount, int recommended) throws IOException {
            if (recommended + this.myAvailable >= this.myBuffer.length) {
                throw new BufferOverflowException();
            }
            int cnt = 0;
            while (!this.myEof && (cnt += this.readMore(recommended - cnt)) < amount) {
            }
        }

        private int readMore(int amount) throws IOException {
            int strand;
            int tail = this.cyc(this.myHead + this.myAvailable);
            int read = this.myReader.read(this.myBuffer, tail, strand = Math.min(amount, this.myBuffer.length - tail));
            if (read == -1) {
                this.myEof = true;
                return 0;
            }
            this.myAvailable += read;
            if (read == strand && strand < amount) {
                return read + this.readMore(amount - strand);
            }
            return read;
        }

        public String subStringAhead(int from, int len) {
            if (from + len > this.myAvailable) {
                throw new BufferUnderflowException();
            }
            int h = this.cyc(this.myHead + from);
            if (h + len <= this.myBuffer.length) {
                return new String(this.myBuffer, h, len);
            }
            char[] chars = new char[len];
            int len1 = this.myBuffer.length - h;
            System.arraycopy(this.myBuffer, h, chars, 0, len1);
            System.arraycopy(this.myBuffer, 0, chars, len1, len - len1);
            return new String(chars);
        }

        public int getAvailable() {
            return this.myAvailable;
        }

        public void close() throws IOException {
            this.myReader.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/CsvReader$CyclicBuffer", "<init>"));
        }
    }
}

