/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public class InlinedProfileBuilder {
    private static final int BRANCH_PROFILE_STATE_BITS = 1;
    private static final int CONDITION_PROFILE_STATE_BITS = 2;
    protected InlineSupport.StateField stateField;
    protected int stateFieldOffset;
    protected int stateFieldLength;
    protected int totalUsedBits;
    private final boolean uncached;

    public InlinedProfileBuilder(InlineSupport.StateField stateField) {
        this(stateField, 0, 32);
    }

    public InlinedProfileBuilder(InlineSupport.StateField stateField, int offset, int length2) {
        this.stateField = stateField;
        this.stateFieldOffset = offset;
        this.stateFieldLength = length2;
        this.uncached = false;
    }

    public InlinedProfileBuilder() {
        this.uncached = true;
    }

    protected final void maybeAdvanceStateField(int bits) {
        if (this.stateFieldOffset + bits > this.stateFieldLength) {
            this.advanceStateField(bits);
        }
    }

    protected void advanceStateField(int bits) {
    }

    public final InlineSupport.StateField stateFieldForBits(int bits) {
        this.maybeAdvanceStateField(bits);
        InlineSupport.StateField subField = this.stateField.subUpdater(this.stateFieldOffset, bits);
        this.stateFieldOffset += bits;
        this.totalUsedBits += bits;
        return subField;
    }

    public final InlinedConditionProfile conditionProfile() {
        if (this.isUncached()) {
            return InlinedConditionProfile.getUncached();
        }
        return InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.stateFieldForBits(2)));
    }

    public final InlinedBranchProfile branchProfile() {
        if (this.isUncached()) {
            return InlinedBranchProfile.getUncached();
        }
        return InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.stateFieldForBits(1)));
    }

    protected final boolean isUncached() {
        return this.uncached;
    }
}

