/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNode;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToRegExpNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNode;
import com.oracle.truffle.js.nodes.intl.InitializeCollatorNode;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.InlinedProfileBag;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StringBuilderProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;

public final class StringPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new StringPrototypeBuiltins();
    public static final JSBuiltinsContainer EXTENSION_BUILTINS = new StringPrototypeExtensionBuiltins();

    protected StringPrototypeBuiltins() {
        super(JSString.PROTOTYPE_NAME, StringPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringPrototype builtinEnum) {
        switch (builtinEnum) {
            case charAt: {
                return StringPrototypeBuiltinsFactory.JSStringCharAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case charCodeAt: {
                return StringPrototypeBuiltinsFactory.JSStringCharCodeAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case concat: {
                return StringPrototypeBuiltinsFactory.JSStringConcatNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case indexOf: {
                return StringPrototypeBuiltinsFactory.JSStringIndexOfNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case lastIndexOf: {
                return StringPrototypeBuiltinsFactory.JSStringLastIndexOfNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).varArgs().createArgumentNodes(context));
            }
            case localeCompare: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringLocaleCompareIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringLocaleCompareNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case match: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringMatchNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringMatchES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case replace: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringReplaceNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringReplaceES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case replaceAll: {
                return StringPrototypeBuiltinsFactory.JSStringReplaceAllNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case search: {
                if (context.getEcmaScriptVersion() >= 6) {
                    return StringPrototypeBuiltinsFactory.JSStringSearchNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringSearchES5NodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case slice: {
                return StringPrototypeBuiltinsFactory.JSStringSliceNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case split: {
                return StringPrototypeBuiltinsFactory.JSStringSplitNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case substr: {
                return StringPrototypeBuiltinsFactory.JSStringSubstrNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case substring: {
                return StringPrototypeBuiltinsFactory.JSStringSubstringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case toLowerCase: {
                return StringPrototypeBuiltinsFactory.JSStringToLowerCaseNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toLocaleLowerCase: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringToLocaleLowerCaseIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringToLowerCaseNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toUpperCase: {
                return StringPrototypeBuiltinsFactory.JSStringToUpperCaseNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toLocaleUpperCase: {
                if (context.isOptionIntl402()) {
                    return StringPrototypeBuiltinsFactory.JSStringToLocaleUpperCaseIntlNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
                }
                return StringPrototypeBuiltinsFactory.JSStringToUpperCaseNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case toString: {
                return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case trim: {
                return StringPrototypeBuiltinsFactory.JSStringTrimNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case startsWith: {
                return StringPrototypeBuiltinsFactory.JSStringStartsWithNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case endsWith: {
                return StringPrototypeBuiltinsFactory.JSStringEndsWithNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case includes: {
                return StringPrototypeBuiltinsFactory.JSStringIncludesNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case repeat: {
                return StringPrototypeBuiltinsFactory.JSStringRepeatNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case codePointAt: {
                return StringPrototypeBuiltinsFactory.JSStringCodePointAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case _iterator: {
                return StringPrototypeBuiltinsFactory.CreateStringIteratorNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case normalize: {
                return StringPrototypeBuiltinsFactory.JSStringNormalizeNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case matchAll: {
                return StringPrototypeBuiltinsFactory.JSStringMatchNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case padStart: {
                return StringPrototypeBuiltinsFactory.JSStringPadNodeGen.create(context, builtin, true, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case padEnd: {
                return StringPrototypeBuiltinsFactory.JSStringPadNodeGen.create(context, builtin, false, StringPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case anchor: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.A, Strings.NAME);
            }
            case big: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.BIG, Strings.EMPTY_STRING);
            }
            case blink: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.BLINK, Strings.EMPTY_STRING);
            }
            case bold: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.B, Strings.EMPTY_STRING);
            }
            case fixed: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.TT, Strings.EMPTY_STRING);
            }
            case fontcolor: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.FONT, Strings.COLOR);
            }
            case fontsize: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.FONT, Strings.SIZE);
            }
            case italics: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.I, Strings.EMPTY_STRING);
            }
            case link: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.A, Strings.HREF);
            }
            case small: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.SMALL, Strings.EMPTY_STRING);
            }
            case strike: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.STRIKE, Strings.EMPTY_STRING);
            }
            case sub: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.SUB, Strings.EMPTY_STRING);
            }
            case sup: {
                return StringPrototypeBuiltins.createHTMLNode(context, builtin, Strings.SUP, Strings.EMPTY_STRING);
            }
            case at: {
                return StringPrototypeBuiltinsFactory.JSStringAtNodeGen.create(context, builtin, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    static CreateHTMLNode createHTMLNode(JSContext context, JSBuiltin builtin, TruffleString tag, TruffleString attribute) {
        return StringPrototypeBuiltinsFactory.CreateHTMLNodeGen.create(context, builtin, tag, attribute, StringPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
    }

    public static enum StringPrototype implements BuiltinEnum<StringPrototype>
    {
        charAt(1),
        charCodeAt(1),
        concat(1),
        indexOf(1),
        lastIndexOf(1),
        localeCompare(1),
        match(1),
        replace(2),
        search(1),
        slice(2),
        split(2),
        substring(2),
        toLowerCase(0),
        toLocaleLowerCase(0),
        toUpperCase(0),
        toLocaleUpperCase(0),
        toString(0),
        valueOf(0),
        trim(0),
        substr(2),
        anchor(1),
        big(0),
        blink(0),
        bold(0),
        fixed(0),
        fontcolor(1),
        fontsize(1),
        italics(0),
        link(1),
        small(0),
        strike(0),
        sub(0),
        sup(0),
        startsWith(1),
        endsWith(1),
        includes(1),
        repeat(1),
        codePointAt(1),
        _iterator(0),
        normalize(0),
        padStart(1),
        padEnd(1),
        matchAll(1),
        replaceAll(2),
        at(1);

        private final int length;

        private StringPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isAnnexB() {
            return EnumSet.range(substr, sup).contains(this);
        }

        @Override
        public int getECMAScriptVersion() {
            if (EnumSet.range(startsWith, normalize).contains(this)) {
                return 6;
            }
            if (EnumSet.range(padStart, padEnd).contains(this)) {
                return 8;
            }
            if (matchAll == this) {
                return 11;
            }
            if (replaceAll == this) {
                return 12;
            }
            if (at == this) {
                return 13;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }

        @Override
        public Object getKey() {
            return this == _iterator ? Symbol.SYMBOL_ITERATOR : BuiltinEnum.super.getKey();
        }
    }

    public static abstract class JSStringCharAtNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();

        public JSStringCharAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString stringCharAt(TruffleString thisObj, int pos, @Cached.Shared @Cached InlinedConditionProfile indexOutOfBounds) {
            if (indexOutOfBounds.profile(this, pos < 0 || pos >= Strings.length(thisObj))) {
                return Strings.EMPTY_STRING;
            }
            return Strings.substring(this.getContext(), this.substringNode, thisObj, pos, 1);
        }

        @Specialization
        protected TruffleString charAt(Object thisObj, Object index, @Cached.Shared @Cached InlinedConditionProfile indexOutOfBounds) {
            this.requireObjectCoercible(thisObj);
            return this.stringCharAt(this.toString(thisObj), this.toIntegerAsInt(index), indexOutOfBounds);
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringCharAtNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringCharAtNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected TruffleString charAt(Object thisObj, Object indexObj, @Cached.Shared @Cached InlinedConditionProfile indexOutOfBounds) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                return this.executeWithArguments(JSArguments.getThisObject(arguments), JSArguments.getUserArgument(arguments, 0));
            }
        }
    }

    public static abstract class JSStringCharCodeAtNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        private final ConditionProfile indexOutOfBounds = ConditionProfile.create();

        public JSStringCharCodeAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static boolean posInBounds(TruffleString thisStr, int pos) {
            return pos >= 0 && pos < Strings.length(thisStr);
        }

        @Specialization(guards={"posInBounds(thisStr, pos)"})
        protected int charCodeAtInBounds(TruffleString thisStr, int pos) {
            return this.charAt(thisStr, pos);
        }

        @Specialization(guards={"!posInBounds(thisStr, pos)"})
        protected double charCodeAtOutOfBounds(TruffleString thisStr, int pos) {
            return Double.NaN;
        }

        @Specialization(replaces={"charCodeAtInBounds", "charCodeAtOutOfBounds"})
        protected Object charCodeAtGeneric(Object thisObj, Object indexObj, @Cached JSToNumberNode toNumberNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString s = this.toString(thisObj);
            Number index = toNumberNode.executeNumber(indexObj);
            long lIndex = JSRuntime.toInteger(index);
            if (this.indexOutOfBounds.profile(0L > lIndex || lIndex >= (long)Strings.length(s))) {
                return Double.NaN;
            }
            return (int)this.charAt(s, (int)lIndex);
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringCharCodeAtNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringCharCodeAtNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected Object charCodeAtGeneric(Object thisObj, Object indexObj, @Cached JSToNumberNode toNumberNode) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                return this.executeWithArguments(JSArguments.getThisObject(arguments), JSArguments.getUserArgument(arguments, 0));
            }
        }
    }

    public static abstract class JSStringConcatNode
    extends JSStringOperation {
        private final StringBuilderProfile stringBuilderProfile;

        public JSStringConcatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.stringBuilderProfile = StringBuilderProfile.create(context.getStringLengthLimit());
        }

        @Specialization
        protected Object concat(Object thisObj, Object[] args, @Cached JSToStringNode toString2Node, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode sbToStringNode) {
            this.requireObjectCoercible(thisObj);
            TruffleStringBuilder sb = this.stringBuilderProfile.newStringBuilder();
            this.stringBuilderProfile.append(appendStringNode, sb, this.toString(thisObj));
            for (Object o : args) {
                this.stringBuilderProfile.append(appendStringNode, sb, toString2Node.executeString(o));
                TruffleSafepoint.poll(this);
            }
            return StringBuilderProfile.toString(sbToStringNode, sb);
        }
    }

    public static abstract class JSStringIndexOfNode
    extends JSStringOperation {
        private final ConditionProfile hasPos = ConditionProfile.create();

        public JSStringIndexOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected int indexOfStringUndefined(TruffleString thisStr, TruffleString searchStr, Object position, @Cached @Cached.Shared(value="indexOfStringNode") TruffleString.ByteIndexOfStringNode indexOfStringNode) {
            return Strings.indexOf(indexOfStringNode, thisStr, searchStr);
        }

        @Specialization
        protected int indexOfStringInt(TruffleString thisStr, TruffleString searchStr, int position, @Cached @Cached.Shared(value="indexOfStringNode") TruffleString.ByteIndexOfStringNode indexOfStringNode) {
            return this.indexOfIntl(thisStr, searchStr, position, indexOfStringNode);
        }

        @Specialization(guards={"!isStringString(thisObj, searchObj) || !isUndefined(position)"}, replaces={"indexOfStringInt"})
        protected int indexOfGeneric(Object thisObj, Object searchObj, Object position, @Cached JSToStringNode toString2Node, @Cached @Cached.Shared(value="indexOfStringNode") TruffleString.ByteIndexOfStringNode indexOfStringNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            TruffleString searchStr = toString2Node.executeString(searchObj);
            return this.indexOfIntl(thisStr, searchStr, position, indexOfStringNode);
        }

        private int indexOfIntl(TruffleString thisStr, TruffleString searchStr, Object position, TruffleString.ByteIndexOfStringNode indexOfStringNode) {
            int startPos = this.hasPos.profile(position != Undefined.instance) ? Math.min(this.toIntegerAsInt(position), Strings.length(thisStr)) : 0;
            return Strings.indexOf(indexOfStringNode, thisStr, searchStr, startPos);
        }
    }

    public static abstract class JSStringLastIndexOfNode
    extends JSStringOperation {
        public JSStringLastIndexOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected int lastIndexOfString(TruffleString thisObj, TruffleString searchString, Object position, @Cached @Cached.Shared(value="lastIndexOfNode") TruffleString.LastByteIndexOfStringNode lastIndexOfNode) {
            return Strings.lastIndexOf(lastIndexOfNode, thisObj, searchString, Strings.length(thisObj));
        }

        @Specialization
        protected int lastIndexOfString(TruffleString thisObj, TruffleString searchString, int position, @Cached @Cached.Shared(value="lastIndexOfNode") TruffleString.LastByteIndexOfStringNode lastIndexOfNode) {
            int len = Strings.length(thisObj);
            int pos = JSStringLastIndexOfNode.within(position, 0, len);
            return Strings.lastIndexOf(lastIndexOfNode, thisObj, searchString, pos);
        }

        @Specialization(guards={"!isStringString(thisObj, searchString) || !isUndefined(position)"})
        protected int lastIndexOf(Object thisObj, Object searchString, Object position, @Cached JSToStringNode toString2Node, @Cached JSToNumberNode toNumberNode, @Cached InlinedConditionProfile posNaN, @Cached @Cached.Shared(value="lastIndexOfNode") TruffleString.LastByteIndexOfStringNode lastIndexOfNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            TruffleString searchStr = toString2Node.executeString(searchString);
            Number numPos = toNumberNode.executeNumber(position);
            int lastPos = Strings.length(thisStr);
            double dVal = JSRuntime.doubleValue(numPos);
            int pos = posNaN.profile(this, Double.isNaN(dVal)) ? lastPos : JSStringLastIndexOfNode.within((int)dVal, 0, lastPos);
            return Strings.lastIndexOf(lastIndexOfNode, thisStr, searchStr, pos);
        }
    }

    public static abstract class JSStringLocaleCompareIntlNode
    extends JSStringOperation {
        @Node.Child
        InitializeCollatorNode initCollatorNode;

        public JSStringLocaleCompareIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.initCollatorNode = InitializeCollatorNode.createInitalizeCollatorNode(context);
        }

        @CompilerDirectives.TruffleBoundary
        private JSDynamicObject createCollator(Object locales, Object options) {
            JSCollatorObject collatorObj = JSCollator.create(this.getContext(), this.getRealm());
            this.initCollatorNode.executeInit(collatorObj, locales, options);
            return collatorObj;
        }

        @Specialization
        protected int localeCompare(Object thisObj, Object thatObj, Object locales, Object options, @Cached JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            TruffleString thatStr = toString2Node.executeString(thatObj);
            JSDynamicObject collator = this.createCollator(locales, options);
            return JSCollator.compare(collator, Strings.toJavaString(thisStr), Strings.toJavaString(thatStr));
        }
    }

    public static abstract class JSStringLocaleCompareNode
    extends JSStringOperation {
        private static Collator collator;

        public JSStringLocaleCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        private static Collator getCollator() {
            if (collator == null) {
                collator = Collator.getInstance(Locale.ROOT);
                collator.setStrength(2);
                collator.setDecomposition(2);
            }
            return collator;
        }

        @Specialization
        protected int localeCompare(Object thisObj, Object thatObj, @Cached JSToStringNode toString2Node) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            TruffleString thatStr = toString2Node.executeString(thatObj);
            return JSStringLocaleCompareNode.doLocaleCompare(thisStr, thatStr);
        }

        @CompilerDirectives.TruffleBoundary
        private static int doLocaleCompare(TruffleString thisStr, TruffleString thatStr) {
            return JSStringLocaleCompareNode.getCollator().compare(Strings.toJavaString(thisStr), Strings.toJavaString(thatStr));
        }
    }

    public static abstract class JSStringMatchNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private CompileRegexNode compileRegexNode;
        @Node.Child
        private CreateRegExpNode createRegExpNode;
        @Node.Child
        private IsRegExpNode isRegExpNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;
        @Node.Child
        private TruffleString.ByteIndexOfCodePointNode stringIndexOfNode;
        private final boolean matchAll;

        protected JSStringMatchNode(JSContext context, JSBuiltin builtin, boolean matchAll) {
            super(context, builtin);
            this.matchAll = matchAll;
        }

        @Specialization
        protected Object match(Object thisObj, Object regex, @Cached InlinedBranchProfile errorBranch) {
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(regex != Undefined.instance && regex != Null.instance)) {
                Object matcher;
                if (this.matchAll && this.getIsRegExpNode().executeBoolean(regex)) {
                    Object flags = this.getFlags(regex);
                    this.requireObjectCoercible(flags);
                    if (this.indexOf(this.toString(flags), 103) == -1) {
                        errorBranch.enter(this);
                        throw Errors.createTypeError("Regular expression passed to matchAll() is missing 'g' flag.");
                    }
                }
                if (this.callSpecialProfile.profile((matcher = this.getMethod(regex, this.matchSymbol())) != Undefined.instance)) {
                    return this.call(matcher, regex, new Object[]{thisObj});
                }
            }
            return this.builtinMatch(thisObj, regex);
        }

        private Symbol matchSymbol() {
            return this.matchAll ? Symbol.SYMBOL_MATCH_ALL : Symbol.SYMBOL_MATCH;
        }

        private Object builtinMatch(Object thisObj, Object regex) {
            TruffleString thisStr = this.toString(thisObj);
            Object cRe = this.getCompileRegexNode().compile(regex == Undefined.instance ? Strings.EMPTY_STRING : this.toString(regex), this.matchAll ? Strings.G : Strings.EMPTY_STRING);
            JSRegExpObject regExp = this.getCreateRegExpNode().createRegExp(cRe);
            return this.invoke(regExp, this.matchSymbol(), thisStr);
        }

        private CompileRegexNode getCompileRegexNode() {
            if (this.compileRegexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileRegexNode = this.insert(CompileRegexNode.create(this.getContext()));
            }
            return this.compileRegexNode;
        }

        private CreateRegExpNode getCreateRegExpNode() {
            if (this.createRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createRegExpNode = this.insert(CreateRegExpNode.create(this.getContext()));
            }
            return this.createRegExpNode;
        }

        private IsRegExpNode getIsRegExpNode() {
            if (this.isRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isRegExpNode = this.insert(IsRegExpNode.create(this.getContext()));
            }
            return this.isRegExpNode;
        }

        private Object getFlags(Object regexp) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = this.insert(PropertyGetNode.create(JSRegExp.FLAGS, this.getContext()));
            }
            return this.getFlagsNode.getValue(regexp);
        }

        private int indexOf(TruffleString a, int codepoint) {
            if (this.stringIndexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringIndexOfNode = this.insert(TruffleString.ByteIndexOfCodePointNode.create());
            }
            return Strings.indexOf(this.stringIndexOfNode, a, codepoint);
        }
    }

    public static abstract class JSStringMatchES5Node
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private PropertySetNode setLastIndexNode;

        public JSStringMatchES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        private void setLastIndex(JSDynamicObject regExp, int value2) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = this.insert(PropertySetNode.create(JSRegExp.LAST_INDEX, false, this.getContext(), true));
            }
            this.setLastIndexNode.setValue(regExp, value2);
        }

        @Specialization
        protected JSDynamicObject matchRegExpNotGlobal(Object thisObj, Object searchObj, @Cached(value="create(getContext())") JSToRegExpNode toRegExpNode, @Cached(value="create(getContext())") RegExpPrototypeBuiltins.JSRegExpExecES5Node regExpExecNode, @Cached InlinedCountingConditionProfile isMatch, @Cached InlinedCountingConditionProfile isGlobalRegExp, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd, @Cached TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getGlobalFlag) {
            this.requireObjectCoercible(thisObj);
            if (isGlobalRegExp.profile(this, JSRegExp.isJSRegExp(searchObj) && this.isGlobal(JSRegExp.getCompiledRegex((JSRegExpObject)searchObj), getGlobalFlag))) {
                TruffleString thisStr = this.toString(thisObj);
                return this.matchAll((JSRegExpObject)searchObj, thisStr, this, isMatch, substringNode, readIsMatch, getStart, getEnd);
            }
            return this.matchNotRegExpIntl(thisObj, searchObj, toRegExpNode, regExpExecNode);
        }

        private boolean isGlobal(Object compiledRegex, TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getGlobalFlag) {
            return getGlobalFlag.execute(this, compiledRegex, "global");
        }

        private JSDynamicObject matchNotRegExpIntl(Object thisObj, Object searchObj, JSToRegExpNode toRegExpNode, RegExpPrototypeBuiltins.JSRegExpExecES5Node regExpExecNode) {
            TruffleString thisStr = this.toString(thisObj);
            JSRegExpObject regExp = toRegExpNode.execute(searchObj);
            return regExpExecNode.execute(regExp, thisStr);
        }

        private JSDynamicObject matchAll(JSDynamicObject regExp, TruffleString input, Node node, InlinedCountingConditionProfile isMatch, @Cached TruffleString.SubstringByteIndexNode substringNode, TRegexUtil.InteropReadBooleanMemberNode readIsMatch, TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart, TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd) {
            this.setLastIndex(regExp, 0);
            Object result2 = this.matchIgnoreLastIndex(regExp, input, 0);
            if (isMatch.profile(this, !TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch))) {
                return Null.instance;
            }
            ArrayList matches = new ArrayList();
            int lastIndex = 0;
            while (TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch)) {
                Boundaries.listAdd(matches, TRegexUtil.TRegexMaterializeResult.materializeGroup(this.getContext(), result2, 0, input, node, substringNode, getStart, getEnd));
                int thisIndex = TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, 0, node, getEnd);
                lastIndex = thisIndex + (thisIndex == lastIndex ? 1 : 0);
                result2 = this.matchIgnoreLastIndex(regExp, input, lastIndex);
            }
            return JSArray.createConstant(this.getContext(), this.getRealm(), Boundaries.listToArray(matches));
        }
    }

    public static abstract class JSStringReplaceNode
    extends JSStringReplaceBaseNode {
        @Node.Child
        private TruffleString.ByteIndexOfStringNode stringIndexOfNode;

        public JSStringReplaceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"stringEquals(equalsNode, cachedReplaceValue, replaceValue)"}, limit="1")
        protected Object replaceStringCached(TruffleString thisObj, TruffleString searchValue, TruffleString replaceValue, @Bind(value="this") Node node, @Cached(value="replaceValue") TruffleString cachedReplaceValue, @Cached(value="parseReplaceValue(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValue, @Cached TruffleString.EqualNode equalsNode, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            this.requireObjectCoercible(thisObj);
            return this.builtinReplaceString(searchValue, cachedReplaceValue, thisObj, cachedParsedReplaceValue, dollarProfile, node);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(Object thisObj, TruffleString searchValue, TruffleString replaceValue, @Bind(value="this") Node node, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            this.requireObjectCoercible(thisObj);
            return this.builtinReplaceString(searchValue, replaceValue, thisObj, null, dollarProfile, node);
        }

        @Specialization(guards={"!isStringString(searchValue, replaceValue)"})
        protected Object replaceGeneric(Object thisObj, Object searchValue, Object replaceValue, @Bind(value="this") Node node, @Cached JSToStringNode toString2Node, @Cached JSToStringNode toString3Node, @Cached IsCallableNode isCallableNode, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            Object replacer;
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(searchValue != Undefined.instance && searchValue != Null.instance) && this.callSpecialProfile.profile((replacer = this.getMethod(searchValue, Symbol.SYMBOL_REPLACE)) != Undefined.instance)) {
                return this.call(replacer, searchValue, new Object[]{thisObj, replaceValue});
            }
            return this.builtinReplace(searchValue, replaceValue, thisObj, toString2Node, toString3Node, isCallableNode, dollarProfile, node);
        }

        private Object builtinReplace(Object searchValue, Object replParam, Object o, JSToStringNode toString2Node, JSToStringNode toString3Node, IsCallableNode isCallableNode, InlinedBranchProfile dollarProfile, Node node) {
            int pos;
            TruffleString input = this.toString(o);
            TruffleString searchString = toString2Node.executeString(searchValue);
            boolean functionalReplace = isCallableNode.executeBoolean(replParam);
            TruffleString replaceString = null;
            if (!this.functionalReplaceProfile.profile(functionalReplace)) {
                replaceString = toString3Node.executeString(replParam);
            }
            if (this.replaceNecessaryProfile.profile((pos = this.indexOf(input, searchString)) < 0)) {
                return input;
            }
            TruffleStringBuilder sb = Strings.builderCreate();
            this.append(sb, input, 0, pos);
            if (this.functionalReplaceProfile.profile(functionalReplace)) {
                Object replValue = this.functionReplaceCall(replParam, Undefined.instance, new Object[]{searchString, pos, input});
                this.append(sb, toString3Node.executeString(replValue));
            } else {
                JSStringReplaceNode.appendSubstitution(sb, input, replaceString, searchString, pos, this, node, dollarProfile);
            }
            this.append(sb, input, pos + Strings.length(searchString), Strings.length(input));
            return this.builderToString(sb);
        }

        private Object builtinReplaceString(TruffleString searchString, TruffleString replaceString, Object o, ReplaceStringParser.Token[] parsedReplaceParam, InlinedBranchProfile dollarProfile, Node node) {
            TruffleString input = this.toString(o);
            int pos = this.indexOf(input, searchString);
            if (this.replaceNecessaryProfile.profile(pos < 0)) {
                return input;
            }
            TruffleStringBuilder sb = Strings.builderCreate();
            this.append(sb, input, 0, pos);
            if (parsedReplaceParam == null) {
                JSStringReplaceNode.appendSubstitution(sb, input, replaceString, searchString, pos, this, node, dollarProfile);
            } else {
                ReplaceStringParser.processParsed(parsedReplaceParam, new JSStringReplaceBaseNode.ReplaceStringConsumer(sb, input, replaceString, searchString, pos), this);
            }
            this.append(sb, input, pos + Strings.length(searchString), Strings.length(input));
            return this.builderToString(sb);
        }

        private int indexOf(TruffleString s1, TruffleString s2) {
            if (this.stringIndexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringIndexOfNode = this.insert(TruffleString.ByteIndexOfStringNode.create());
            }
            return Strings.indexOf(this.stringIndexOfNode, s1, s2);
        }
    }

    public static abstract class JSStringReplaceES5Node
    extends JSStringReplaceBaseNode {
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private StringReplacer stringReplacerNode;
        @Node.Child
        private FunctionReplacer functionReplacerNode;
        @Node.Child
        private TruffleString.ByteIndexOfStringNode stringIndexOfNode;
        @Node.Child
        TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();
        @Node.Child
        TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        TRegexUtil.InvokeGetGroupBoundariesMethodNode getEnd = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        public JSStringReplaceES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            assert (context.getEcmaScriptVersion() < 6);
        }

        @Specialization
        protected Object replace(Object thisObj, Object searchValue, Object replaceValue, @Bind(value="this") Node node, @Cached JSToStringNode toString2Node, @Cached JSToStringNode toString3Node, @Cached InlinedCountingConditionProfile ifIsMatch, @Cached InlinedConditionProfile isRegExp, @Cached InlinedCountingConditionProfile isFnRepl, @Cached(inline=true) TRegexUtil.InteropReadIntMemberNode readGroupCount, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getGlobalFlag) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (Strings.length(thisStr) > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            if (isRegExp.profile(node, JSRegExp.isJSRegExp(searchValue))) {
                JSRegExpObject searchRegExp = (JSRegExpObject)searchValue;
                Object tRegexCompiledRegex = JSRegExp.getCompiledRegex(searchRegExp);
                int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(tRegexCompiledRegex, node, readGroupCount);
                if (isFnRepl.profile(node, JSFunction.isJSFunction(replaceValue))) {
                    JSDynamicObject replaceFunc = (JSDynamicObject)replaceValue;
                    if (JSStringReplaceES5Node.isGlobal(tRegexCompiledRegex, node, getGlobalFlag)) {
                        return this.replaceAll(searchRegExp, thisStr, groupCount, this.getFunctionReplacerNode(), replaceFunc, tRegexCompiledRegex, node, ifIsMatch, readIsMatch);
                    }
                    return this.replaceFirst(thisStr, searchRegExp, groupCount, this.getFunctionReplacerNode(), replaceFunc, tRegexCompiledRegex, node, ifIsMatch, readIsMatch);
                }
                TruffleString replaceStr = toString3Node.executeString(replaceValue);
                if (JSStringReplaceES5Node.isGlobal(tRegexCompiledRegex, node, getGlobalFlag)) {
                    return this.replaceAll(searchRegExp, thisStr, groupCount, this.getStringReplacerNode(), replaceStr, tRegexCompiledRegex, node, ifIsMatch, readIsMatch);
                }
                return this.replaceFirst(thisStr, searchRegExp, groupCount, this.getStringReplacerNode(), replaceStr, tRegexCompiledRegex, node, ifIsMatch, readIsMatch);
            }
            TruffleString searchStr = toString2Node.executeString(searchValue);
            if (isFnRepl.profile(node, JSFunction.isJSFunction(replaceValue))) {
                return this.replaceFirst(thisStr, searchStr, this.getFunctionReplacerNode(), (JSDynamicObject)replaceValue, null, node, ifIsMatch);
            }
            TruffleString replaceStr = toString3Node.executeString(replaceValue);
            return this.replaceFirst(thisStr, searchStr, this.getStringReplacerNode(), replaceStr, null, node, ifIsMatch);
        }

        private static boolean isGlobal(Object tRegexCompiledRegex, Node node, TRegexUtil.TRegexCompiledRegexSingleFlagAccessorNode getGlobalFlag) {
            return getGlobalFlag.execute(node, tRegexCompiledRegex, "global");
        }

        private void setLastIndex(JSDynamicObject regExp, int value2) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = this.insert(PropertySetNode.create(JSRegExp.LAST_INDEX, false, this.getContext(), true));
            }
            this.setLastIndexNode.setValueInt(regExp, value2);
        }

        private StringReplacer getStringReplacerNode() {
            if (this.stringReplacerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringReplacerNode = this.insert(StringReplacer.create(this));
            }
            return this.stringReplacerNode;
        }

        private FunctionReplacer getFunctionReplacerNode() {
            if (this.functionReplacerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.functionReplacerNode = this.insert(FunctionReplacer.create(this));
            }
            return this.functionReplacerNode;
        }

        private int indexOf(TruffleString s1, TruffleString s2) {
            if (this.stringIndexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringIndexOfNode = this.insert(TruffleString.ByteIndexOfStringNode.create());
            }
            return Strings.indexOf(this.stringIndexOfNode, s1, s2);
        }

        private <T> Object replaceFirst(TruffleString thisStr, TruffleString searchStr, Replacer<T> replacer, T replaceValue, Object tRegexCompiledRegex, Node node, InlinedCountingConditionProfile ifIsMatch) {
            int start2 = this.indexOf(thisStr, searchStr);
            if (ifIsMatch.profile(node, start2 < 0)) {
                return thisStr;
            }
            int end = start2 + Strings.length(searchStr);
            TruffleStringBuilder sb = Strings.builderCreate();
            this.append(sb, thisStr, 0, start2);
            replacer.appendReplacementString(sb, thisStr, searchStr, start2, replaceValue, this, tRegexCompiledRegex);
            this.append(sb, thisStr, end, Strings.length(thisStr));
            return this.builderToString(sb);
        }

        private <T> TruffleString replaceFirst(TruffleString thisStr, JSRegExpObject regExp, int groupCount, Replacer<T> replacer, T replaceValue, Object tRegexCompiledRegex, Node node, InlinedCountingConditionProfile ifIsMatch, TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            Object result2 = this.match(regExp, thisStr);
            if (ifIsMatch.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch))) {
                return thisStr;
            }
            return this.replace(thisStr, result2, groupCount, replacer, replaceValue, tRegexCompiledRegex, node);
        }

        protected final Object match(JSRegExpObject regExp, TruffleString input) {
            assert (this.getContext().getEcmaScriptVersion() <= 5);
            return this.getRegExpNode().execute(regExp, input);
        }

        private <T> TruffleString replace(TruffleString thisStr, Object result2, int groupCount, Replacer<T> replacer, T replaceValue, Object tRegexCompiledRegex, Node node) {
            TruffleStringBuilder sb = Strings.builderCreate();
            int matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, 0, node, this.getStart);
            int matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, 0, node, this.getEnd);
            this.append(sb, thisStr, 0, matchStart);
            replacer.appendReplacementRegex(sb, thisStr, result2, groupCount, replaceValue, this, tRegexCompiledRegex, matchStart, matchEnd);
            this.append(sb, thisStr, matchEnd, Strings.length(thisStr));
            return this.builderToString(sb);
        }

        private <T> TruffleString replaceAll(JSDynamicObject regExp, TruffleString input, int groupCount, Replacer<T> replacer, T replaceValue, Object tRegexCompiledRegex, Node node, InlinedCountingConditionProfile ifIsMatch, TRegexUtil.InteropReadBooleanMemberNode readIsMatch) {
            this.setLastIndex(regExp, 0);
            Object result2 = this.matchIgnoreLastIndex(regExp, input, 0);
            if (ifIsMatch.profile(node, !TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch))) {
                return input;
            }
            TruffleStringBuilder sb = Strings.builderCreate();
            int thisIndex = 0;
            int lastIndex = 0;
            while (TRegexUtil.TRegexResultAccessor.isMatch(result2, node, readIsMatch)) {
                int matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, 0, node, this.getStart);
                int matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, 0, node, this.getEnd);
                this.append(sb, input, thisIndex, matchStart);
                replacer.appendReplacementRegex(sb, input, result2, groupCount, replaceValue, this, tRegexCompiledRegex, matchStart, matchEnd);
                if (Strings.builderLength(sb) > this.getContext().getStringLengthLimit()) {
                    CompilerDirectives.transferToInterpreter();
                    throw Errors.createRangeErrorInvalidStringLength();
                }
                thisIndex = matchEnd;
                if (thisIndex == Strings.length(input) && matchEnd - matchStart == 0) break;
                lastIndex = thisIndex + (thisIndex == lastIndex ? 1 : 0);
                result2 = this.matchIgnoreLastIndex(regExp, input, lastIndex);
            }
            this.append(sb, input, thisIndex, Strings.length(input));
            return this.builderToString(sb);
        }

        protected static final class FunctionReplacer
        extends Replacer<JSDynamicObject> {
            @Node.Child
            private JSFunctionCallNode functionCallNode = JSFunctionCallNode.createCall();
            @Node.Child
            private JSToStringNode toStringNode = JSToStringNode.create();

            private FunctionReplacer(JSStringReplaceES5Node parent) {
                super(parent);
            }

            public static FunctionReplacer create(JSStringReplaceES5Node parent) {
                return new FunctionReplacer(parent);
            }

            @Override
            void appendReplacementRegex(TruffleStringBuilder sb, TruffleString input, Object result2, int groupCount, JSDynamicObject replaceFunc, JSStringReplaceES5Node parent, Object tRegexCompiledRegex, int matchStart, int matchEnd) {
                parent.append(sb, this.callReplaceValueFunc(parent.getContext(), result2, input, groupCount, replaceFunc, matchStart));
            }

            @Override
            void appendReplacementString(TruffleStringBuilder sb, TruffleString input, TruffleString matchedString, int pos, JSDynamicObject replaceFunc, JSStringReplaceES5Node parent, Object tRegexCompiledRegex) {
                Object[] arguments = FunctionReplacer.createArguments(new Object[]{matchedString}, pos, input, replaceFunc);
                Object replaceValue = this.functionCallNode.executeCall(arguments);
                TruffleString replaceStr = this.toStringNode.executeString(replaceValue);
                parent.append(sb, replaceStr);
            }

            private TruffleString callReplaceValueFunc(JSContext context, Object result2, TruffleString input, int groupCount, JSDynamicObject replaceFunc, int matchStart) {
                Object[] matches = TRegexUtil.TRegexMaterializeResult.materializeFull(context, result2, groupCount, input, this.parentNode, this.parentNode.substringNode, this.parentNode.getStart, this.parentNode.getEnd);
                Object[] arguments = FunctionReplacer.createArguments(matches, matchStart, input, replaceFunc);
                Object replaceValue = this.functionCallNode.executeCall(arguments);
                return this.toStringNode.executeString(replaceValue);
            }

            private static Object[] createArguments(Object[] matches, int matchIndex, Object input, JSDynamicObject replaceFunc) {
                JSDynamicObject target = Undefined.instance;
                Object[] arguments = JSArguments.createInitial(target, replaceFunc, matches.length + 2);
                JSArguments.setUserArguments(arguments, 0, matches);
                JSArguments.setUserArgument(arguments, matches.length, matchIndex);
                JSArguments.setUserArgument(arguments, matches.length + 1, input);
                return arguments;
            }
        }

        private static abstract class Replacer<T>
        extends JavaScriptBaseNode {
            final JSStringReplaceES5Node parentNode;

            protected Replacer(JSStringReplaceES5Node parent) {
                this.parentNode = parent;
            }

            abstract void appendReplacementRegex(TruffleStringBuilder var1, TruffleString var2, Object var3, int var4, T var5, JSStringReplaceES5Node var6, Object var7, int var8, int var9);

            abstract void appendReplacementString(TruffleStringBuilder var1, TruffleString var2, TruffleString var3, int var4, T var5, JSStringReplaceES5Node var6, Object var7);
        }

        protected static final class StringReplacer
        extends Replacer<TruffleString>
        implements RegExpPrototypeBuiltins.ReplaceStringConsumerTRegex.ParentNode {
            private final ConditionProfile emptyReplace = ConditionProfile.create();
            private final BranchProfile invalidGroupNumberProfile = BranchProfile.create();

            private StringReplacer(JSStringReplaceES5Node parent) {
                super(parent);
            }

            public static StringReplacer create(JSStringReplaceES5Node parent) {
                return new StringReplacer(parent);
            }

            @Override
            void appendReplacementRegex(TruffleStringBuilder sb, TruffleString input, Object result2, int groupCount, TruffleString replaceStr, JSStringReplaceES5Node parent, Object tRegexCompiledRegex, int matchStart, int matchEnd) {
                if (this.emptyReplace.profile(!Strings.isEmpty(replaceStr))) {
                    ReplaceStringParser.process(parent.getContext(), replaceStr, groupCount, false, new RegExpPrototypeBuiltins.ReplaceStringConsumerTRegex(sb, input, replaceStr, matchStart, matchEnd, result2, tRegexCompiledRegex, groupCount), this, null, InlinedBranchProfile.getUncached());
                }
            }

            @Override
            void appendReplacementString(TruffleStringBuilder sb, TruffleString input, TruffleString matchedString, int pos, TruffleString replaceValue, JSStringReplaceES5Node parent, Object tRegexCompiledRegex) {
                JSStringReplaceNode.appendSubstitution(sb, input, replaceValue, matchedString, pos, parent, null, InlinedBranchProfile.getUncached());
            }

            @Override
            public void append(TruffleStringBuilder sb, TruffleString s) {
                this.parentNode.append(sb, s);
            }

            @Override
            public void append(TruffleStringBuilder sb, TruffleString s, int fromIndex, int toIndex) {
                this.parentNode.append(sb, s, fromIndex, toIndex);
            }

            @Override
            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetStartNode() {
                return this.parentNode.getStart;
            }

            @Override
            public TRegexUtil.InvokeGetGroupBoundariesMethodNode getGetEndNode() {
                return this.parentNode.getEnd;
            }

            @Override
            public BranchProfile getInvalidGroupNumberProfile() {
                return this.invalidGroupNumberProfile;
            }
        }
    }

    public static abstract class JSStringReplaceAllNode
    extends JSStringReplaceBaseNode {
        @Node.Child
        private IsRegExpNode isRegExpNode;
        @Node.Child
        private PropertyGetNode getFlagsNode;

        public JSStringReplaceAllNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"stringEquals(equalsNode, cachedReplaceValue, replaceValue)"}, limit="1")
        protected Object replaceStringCached(Object thisObj, TruffleString searchValue, TruffleString replaceValue, @Cached(value="replaceValue") TruffleString cachedReplaceValue, @Cached(value="parseReplaceValue(replaceValue)", dimensions=1) ReplaceStringParser.Token[] cachedParsedReplaceValue, @Bind(value="this") Node node, @Cached TruffleString.EqualNode equalsNode, @Cached @Cached.Shared(value="indexOfString") TruffleString.ByteIndexOfStringNode stringIndexOfStringNode, @Cached @Cached.Shared(value="isSearchValueEmpty") InlinedConditionProfile isSearchValueEmpty, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            this.requireObjectCoercible(thisObj);
            return this.performReplaceAll(searchValue, cachedReplaceValue, thisObj, cachedParsedReplaceValue, node, stringIndexOfStringNode, isSearchValueEmpty, dollarProfile);
        }

        @Specialization(replaces={"replaceStringCached"})
        protected Object replaceString(Object thisObj, TruffleString searchValue, TruffleString replaceValue, @Cached @Cached.Shared(value="indexOfString") TruffleString.ByteIndexOfStringNode stringIndexOfStringNode, @Cached @Cached.Shared(value="isSearchValueEmpty") InlinedConditionProfile isSearchValueEmpty, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            this.requireObjectCoercible(thisObj);
            return this.performReplaceAll(searchValue, replaceValue, thisObj, null, this, stringIndexOfStringNode, isSearchValueEmpty, dollarProfile);
        }

        protected Object performReplaceAll(TruffleString searchValue, TruffleString replaceValue, Object thisObj, ReplaceStringParser.Token[] parsedReplaceParam, Node node, TruffleString.ByteIndexOfStringNode stringIndexOfStringNode, InlinedConditionProfile isSearchValueEmpty, InlinedBranchProfile dollarProfile) {
            TruffleString thisStr = this.toString(thisObj);
            if (isSearchValueEmpty.profile(node, Strings.isEmpty(searchValue))) {
                int len = Strings.length(thisStr);
                TruffleStringBuilder sb = Strings.builderCreate((len + 1) * Strings.length(replaceValue) + len);
                this.append(sb, replaceValue);
                for (int i = 0; i < len; ++i) {
                    this.appendLen(sb, thisStr, i, 1);
                    this.append(sb, replaceValue);
                }
                return this.builderToString(sb);
            }
            TruffleStringBuilder sb = Strings.builderCreate();
            int position = 0;
            while (position < Strings.length(thisStr)) {
                int nextPosition = Strings.indexOf(stringIndexOfStringNode, thisStr, searchValue, position);
                this.builtinReplaceString(searchValue, replaceValue, thisStr, parsedReplaceParam, position, nextPosition, sb, node, dollarProfile);
                if (nextPosition < 0) break;
                position = nextPosition + Strings.length(searchValue);
            }
            return this.builderToString(sb);
        }

        @Specialization(guards={"!isStringString(searchValue, replaceValue)"})
        protected Object replaceGeneric(Object thisObj, Object searchValue, Object replaceValue, @Bind(value="this") Node node, @Cached @Cached.Exclusive InlinedBranchProfile errorBranch, @Cached JSToStringNode toString2Node, @Cached JSToStringNode toString3Node, @Cached IsCallableNode isCallableNode, @Cached @Cached.Exclusive InlinedConditionProfile isRegExp, @Cached TruffleString.ByteIndexOfCodePointNode stringIndexOfNode, @Cached @Cached.Shared(value="indexOfString") TruffleString.ByteIndexOfStringNode stringIndexOfStringNode, @Cached @Cached.Shared(value="isSearchValueEmpty") InlinedConditionProfile isSearchValueEmpty, @Cached @Cached.Shared(value="dollar") InlinedBranchProfile dollarProfile) {
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(searchValue != Undefined.instance && searchValue != Null.instance)) {
                Object replacer;
                if (isRegExp.profile(node, this.getIsRegExpNode().executeBoolean(searchValue))) {
                    Object flags = this.getFlags(searchValue);
                    this.requireObjectCoercible(flags);
                    TruffleString flagsStr = this.toString(flags);
                    if (Strings.indexOf(stringIndexOfNode, flagsStr, 103) == -1) {
                        errorBranch.enter(node);
                        throw Errors.createTypeError("Only global regexps allowed");
                    }
                }
                if (this.callSpecialProfile.profile((replacer = this.getMethod(searchValue, Symbol.SYMBOL_REPLACE)) != Undefined.instance)) {
                    return this.call(replacer, searchValue, new Object[]{thisObj, replaceValue});
                }
            }
            return this.performReplaceAllGeneric(searchValue, replaceValue, thisObj, node, toString2Node, toString3Node, isCallableNode, stringIndexOfStringNode, isSearchValueEmpty, dollarProfile);
        }

        protected Object performReplaceAllGeneric(Object searchValue, Object replParam, Object thisObj, Node node, JSToStringNode toString2Node, JSToStringNode toString3Node, IsCallableNode isCallableNode, TruffleString.ByteIndexOfStringNode stringIndexOfStringNode, InlinedConditionProfile isSearchValueEmpty, InlinedBranchProfile dollarProfile) {
            int position;
            TruffleString thisStr = this.toString(thisObj);
            TruffleString searchString = toString2Node.executeString(searchValue);
            TruffleStringBuilder sb = Strings.builderCreate();
            boolean functionalReplace = isCallableNode.executeBoolean(replParam);
            Object replaceValue = this.functionalReplaceProfile.profile(functionalReplace) ? replParam : toString3Node.executeString(replParam);
            if (isSearchValueEmpty.profile(node, Strings.isEmpty(searchString))) {
                for (position = 0; position <= Strings.length(thisStr); ++position) {
                    this.builtinReplace(searchString, functionalReplace, replaceValue, thisStr, position, position, sb, node, toString3Node, dollarProfile);
                    if (position >= Strings.length(thisStr)) continue;
                    this.appendLen(sb, thisStr, position, 1);
                }
                return this.builderToString(sb);
            }
            while (position < Strings.length(thisStr)) {
                int nextPosition = Strings.indexOf(stringIndexOfStringNode, thisStr, searchString, position);
                this.builtinReplace(searchString, functionalReplace, replaceValue, thisStr, position, nextPosition, sb, node, toString3Node, dollarProfile);
                if (nextPosition < 0) break;
                position = nextPosition + Strings.length(searchString);
            }
            return this.builderToString(sb);
        }

        private void builtinReplace(TruffleString searchString, boolean functionalReplace, Object replParam, TruffleString input, int lastPosition, int curPosition, TruffleStringBuilder sb, Node node, JSToStringNode toString3Node, InlinedBranchProfile dollarProfile) {
            if (this.replaceNecessaryProfile.profile(curPosition < 0)) {
                this.append(sb, input, lastPosition, Strings.length(input));
                return;
            }
            this.append(sb, input, lastPosition, curPosition);
            if (this.functionalReplaceProfile.profile(functionalReplace)) {
                Object replValue = this.functionReplaceCall(replParam, Undefined.instance, new Object[]{searchString, curPosition, input});
                this.append(sb, toString3Node.executeString(replValue));
            } else {
                JSStringReplaceAllNode.appendSubstitution(sb, input, (TruffleString)replParam, searchString, curPosition, this, node, dollarProfile);
            }
        }

        private void builtinReplaceString(TruffleString searchString, TruffleString replaceString, TruffleString input, ReplaceStringParser.Token[] parsedReplaceParam, int lastPosition, int curPosition, TruffleStringBuilder sb, Node node, InlinedBranchProfile dollarProfile) {
            if (this.replaceNecessaryProfile.profile(curPosition < 0)) {
                this.append(sb, input, lastPosition, Strings.length(input));
                return;
            }
            this.append(sb, input, lastPosition, curPosition);
            if (parsedReplaceParam == null) {
                JSStringReplaceAllNode.appendSubstitution(sb, input, replaceString, searchString, curPosition, this, node, dollarProfile);
            } else {
                ReplaceStringParser.processParsed(parsedReplaceParam, new JSStringReplaceBaseNode.ReplaceStringConsumer(sb, input, replaceString, searchString, curPosition), this);
            }
        }

        private IsRegExpNode getIsRegExpNode() {
            if (this.isRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isRegExpNode = this.insert(IsRegExpNode.create(this.getContext()));
            }
            return this.isRegExpNode;
        }

        private Object getFlags(Object regexp) {
            if (this.getFlagsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFlagsNode = this.insert(PropertyGetNode.create(JSRegExp.FLAGS, this.getContext()));
            }
            return this.getFlagsNode.getValue(regexp);
        }
    }

    public static abstract class JSStringSearchNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private CompileRegexNode compileRegexNode;
        @Node.Child
        private CreateRegExpNode createRegExpNode;

        public JSStringSearchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object search(Object thisObj, Object regex) {
            Object searcher;
            assert (this.getContext().getEcmaScriptVersion() >= 6);
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(regex != Undefined.instance && regex != Null.instance) && this.callSpecialProfile.profile((searcher = this.getMethod(regex, Symbol.SYMBOL_SEARCH)) != Undefined.instance)) {
                return this.call(searcher, regex, new Object[]{thisObj});
            }
            return this.builtinSearch(thisObj, regex);
        }

        private Object builtinSearch(Object thisObj, Object regex) {
            TruffleString thisStr = this.toString(thisObj);
            Object cRe = this.getCompileRegexNode().compile(regex == Undefined.instance ? Strings.EMPTY_STRING : this.toString(regex));
            JSRegExpObject regExp = this.getCreateRegExpNode().createRegExp(cRe);
            return this.invoke(regExp, Symbol.SYMBOL_SEARCH, thisStr);
        }

        private CompileRegexNode getCompileRegexNode() {
            if (this.compileRegexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.compileRegexNode = this.insert(CompileRegexNode.create(this.getContext()));
            }
            return this.compileRegexNode;
        }

        private CreateRegExpNode getCreateRegExpNode() {
            if (this.createRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createRegExpNode = this.insert(CreateRegExpNode.create(this.getContext()));
            }
            return this.createRegExpNode;
        }
    }

    public static abstract class JSStringSearchES5Node
    extends JSStringOperationWithRegExpArgument {
        public JSStringSearchES5Node(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int search(Object thisObj, Object[] args, @Cached(value="create(getContext())") JSToRegExpNode toRegExpNode, @Cached(inline=true) TRegexUtil.InteropReadBooleanMemberNode readIsMatch, @Cached(inline=true) TRegexUtil.InvokeGetGroupBoundariesMethodNode getStart) {
            assert (this.getContext().getEcmaScriptVersion() < 6);
            Object searchObj = JSRuntime.getArgOrUndefined(args, 0);
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            JSRegExpObject regExp = toRegExpNode.execute(searchObj);
            Object result2 = this.matchIgnoreLastIndex(regExp, thisStr, 0);
            if (TRegexUtil.TRegexResultAccessor.isMatch(result2, this, readIsMatch)) {
                return TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, 0, this, getStart);
            }
            return -1;
        }
    }

    public static abstract class JSStringSliceNode
    extends JSStringOperation {
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();

        public JSStringSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object sliceStringIntInt(TruffleString thisObj, int start2, int end, @Cached @Cached.Shared(value="offsetProfile1") InlinedConditionProfile offsetProfile1, @Cached @Cached.Shared(value="offsetProfile2") InlinedConditionProfile offsetProfile2, @Cached @Cached.Shared(value="canReturnEmpty") InlinedConditionProfile canReturnEmpty) {
            int len = Strings.length(thisObj);
            int istart = JSRuntime.getOffset(start2, len, (Node)this, offsetProfile1);
            int iend = JSRuntime.getOffset(end, len, (Node)this, offsetProfile2);
            if (canReturnEmpty.profile(this, iend > istart)) {
                return Strings.substring(this.getContext(), this.substringNode, thisObj, istart, iend - istart);
            }
            return Strings.EMPTY_STRING;
        }

        @Specialization(guards={"!isString(thisObj)"}, replaces={"sliceStringIntInt"})
        protected Object sliceObjectIntInt(Object thisObj, int start2, int end, @Cached @Cached.Shared(value="offsetProfile1") InlinedConditionProfile offsetProfile1, @Cached @Cached.Shared(value="offsetProfile2") InlinedConditionProfile offsetProfile2, @Cached @Cached.Shared(value="canReturnEmpty") InlinedConditionProfile canReturnEmpty) {
            this.requireObjectCoercible(thisObj);
            return this.sliceStringIntInt(this.toString(thisObj), start2, end, offsetProfile1, offsetProfile2, canReturnEmpty);
        }

        @Specialization(guards={"isUndefined(end)"})
        protected Object sliceStringIntUndefined(TruffleString str, int start2, Object end, @Cached @Cached.Shared(value="offsetProfile1") InlinedConditionProfile offsetProfile1, @Cached @Cached.Shared(value="canReturnEmpty") InlinedConditionProfile canReturnEmpty) {
            int istart;
            int len = Strings.length(str);
            if (canReturnEmpty.profile(this, len > (istart = JSRuntime.getOffset(start2, len, (Node)this, offsetProfile1)))) {
                return Strings.substring(this.getContext(), this.substringNode, str, istart, len - istart);
            }
            return Strings.EMPTY_STRING;
        }

        @Specialization(replaces={"sliceStringIntInt", "sliceObjectIntInt", "sliceStringIntUndefined"})
        protected Object sliceGeneric(Object thisObj, Object start2, Object end, @Cached @Cached.Exclusive InlinedConditionProfile isUndefined, @Cached @Cached.Shared(value="canReturnEmpty") InlinedConditionProfile canReturnEmpty, @Cached @Cached.Shared(value="offsetProfile1") InlinedConditionProfile offsetProfile1, @Cached @Cached.Shared(value="offsetProfile2") InlinedConditionProfile offsetProfile2) {
            this.requireObjectCoercible(thisObj);
            TruffleString s = this.toString(thisObj);
            long len = Strings.length(s);
            long istart = JSRuntime.getOffset((long)this.toIntegerAsInt(start2), len, (Node)this, offsetProfile1);
            long iend = isUndefined.profile(this, end == Undefined.instance) ? len : JSRuntime.getOffset((long)this.toIntegerAsInt(end), len, (Node)this, offsetProfile2);
            if (canReturnEmpty.profile(this, iend > istart)) {
                int begin2 = (int)istart;
                return Strings.substring(this.getContext(), this.substringNode, s, begin2, (int)iend - begin2);
            }
            return Strings.EMPTY_STRING;
        }
    }

    public static abstract class JSStringSplitNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        private JSToUInt32Node toUInt32Node;
        @Node.Child
        private JSToStringNode toString2Node;
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode;
        @Node.Child
        private TruffleString.ByteIndexOfStringNode stringIndexOfNode;
        @Node.Child
        private TRegexUtil.InteropReadBooleanMemberNode readIsMatch = TRegexUtil.InteropReadBooleanMemberNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        private static final Splitter<Void> NOP_SPLITTER = (input, limit, separator, groupCount, parent, profiles) -> new Object[]{input};
        private static final Splitter<TruffleString> STRING_SPLITTER = new StringSplitter();
        private static final Splitter<JSRegExpObject> REGEXP_SPLITTER = new RegExpSplitter();

        public JSStringSplitNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private int toUInt32(Object target) {
            if (this.toUInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt32Node = this.insert(JSToUInt32Node.create());
            }
            return (int)Math.min(Integer.MAX_VALUE, JSRuntime.toInteger(this.toUInt32Node.executeNumber(target)));
        }

        private TruffleString toString2(Object obj) {
            if (this.toString2Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toString2Node = this.insert(JSToStringNode.create());
            }
            return this.toString2Node.executeString(obj);
        }

        private TruffleString substring(TruffleString a, int fromIndex) {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = this.insert(TruffleString.SubstringByteIndexNode.create());
            }
            return Strings.substring(this.getContext(), this.substringNode, a, fromIndex);
        }

        private TruffleString substring(TruffleString a, int fromIndex, int length2) {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = this.insert(TruffleString.SubstringByteIndexNode.create());
            }
            return Strings.substring(this.getContext(), this.substringNode, a, fromIndex, length2);
        }

        private int indexOf(TruffleString s1, TruffleString s2, int fromIndex) {
            if (this.stringIndexOfNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringIndexOfNode = this.insert(TruffleString.ByteIndexOfStringNode.create());
            }
            return Strings.indexOf(this.stringIndexOfNode, s1, s2, fromIndex);
        }

        @Idempotent
        protected final boolean isES6OrNewer() {
            return this.getContext().getEcmaScriptVersion() >= 6;
        }

        @Specialization(guards={"!isES6OrNewer()"})
        protected Object splitES5(Object thisObj, Object separator, Object limitObj, @Cached @Cached.Exclusive InlinedBranchProfile isUndefinedBranch, @Cached @Cached.Exclusive InlinedBranchProfile isRegexpBranch, @Cached @Cached.Exclusive InlinedBranchProfile isStringBranch, @Cached @Cached.Shared(value="splitProfiles") SplitProfiles profiles, @Cached(inline=true) TRegexUtil.InteropReadIntMemberNode readGroupCount) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            int limit = this.getLimit(limitObj);
            if (separator == Undefined.instance) {
                isUndefinedBranch.enter(this);
                return this.split(thisStr, limit, NOP_SPLITTER, null, 1, profiles);
            }
            if (JSRegExp.isJSRegExp(separator)) {
                isRegexpBranch.enter(this);
                JSRegExpObject regExp = (JSRegExpObject)separator;
                int groupCount = TRegexUtil.TRegexCompiledRegexAccessor.groupCount(JSRegExp.getCompiledRegex(regExp), this, readGroupCount);
                return this.split(thisStr, limit, REGEXP_SPLITTER, regExp, groupCount, profiles);
            }
            isStringBranch.enter(this);
            TruffleString separatorStr = this.toString2(separator);
            return this.split(thisStr, limit, STRING_SPLITTER, separatorStr, 1, profiles);
        }

        protected boolean isFastPath(Object thisObj, Object separator, Object limit) {
            return Strings.isTString(thisObj) && Strings.isTString(separator) && limit == Undefined.instance;
        }

        @Specialization(guards={"isES6OrNewer()", "isUndefined(limit)"})
        protected Object splitES6StrStrUndefined(TruffleString thisStr, TruffleString sepStr, JSDynamicObject limit, @Cached @Cached.Shared(value="splitProfiles") SplitProfiles profiles) {
            return this.split(thisStr, Integer.MAX_VALUE, STRING_SPLITTER, sepStr, 1, profiles);
        }

        @Specialization(guards={"isES6OrNewer()", "!isFastPath(thisObj, separator, limit)"})
        protected Object splitES6Generic(Object thisObj, Object separator, Object limit, @Cached @Cached.Shared(value="splitProfiles") SplitProfiles profiles) {
            Object splitter;
            this.requireObjectCoercible(thisObj);
            if (this.isSpecialProfile.profile(separator != Undefined.instance && separator != Null.instance) && this.callSpecialProfile.profile((splitter = this.getMethod(separator, Symbol.SYMBOL_SPLIT)) != Undefined.instance)) {
                return this.call(splitter, separator, new Object[]{thisObj, limit});
            }
            return this.builtinSplit(thisObj, separator, limit, profiles);
        }

        private Object builtinSplit(Object thisObj, Object separator, Object limit, SplitProfiles profiles) {
            TruffleString thisStr = this.toString(thisObj);
            int lim = this.getLimit(limit);
            TruffleString sepStr = this.toString2(separator);
            if (separator == Undefined.instance) {
                return this.split(thisStr, lim, NOP_SPLITTER, null, 1, profiles);
            }
            return this.split(thisStr, lim, STRING_SPLITTER, sepStr, 1, profiles);
        }

        private int getLimit(Object limit) {
            return limit == Undefined.instance ? Integer.MAX_VALUE : this.toUInt32(limit);
        }

        private <T> JSDynamicObject split(TruffleString thisStr, int limit, Splitter<T> splitter, T separator, int groupCount, SplitProfiles profiles) {
            JSRealm realm = this.getRealm();
            if (profiles.zeroLimit.profile(this, limit == 0)) {
                return JSArray.createEmptyZeroLength(this.getContext(), realm);
            }
            Object[] splits = splitter.split(thisStr, limit, separator, groupCount, this, profiles);
            return JSArray.createConstant(this.getContext(), realm, splits);
        }

        private static interface Splitter<T> {
            public Object[] split(TruffleString var1, int var2, T var3, int var4, JSStringSplitNode var5, SplitProfiles var6);
        }

        protected static final class SplitProfiles
        implements InlinedProfileBag {
            public final InlinedConditionProfile emptyInput;
            public final InlinedConditionProfile emptySeparator;
            public final InlinedConditionProfile zeroLimit;
            public final InlinedBranchProfile growBranch;
            public final InlinedCountingConditionProfile matchProfile;
            public static final int REQUIRED_BITS = 7;

            @NeverDefault
            public static SplitProfiles inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=7), @InlineSupport.RequiredField(value=InlineSupport.IntField.class), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget inlineTarget) {
                try (InlinedProfileBag.Builder b = new InlinedProfileBag.Builder(inlineTarget, 7);){
                    SplitProfiles splitProfiles = new SplitProfiles(b);
                    return splitProfiles;
                }
            }

            protected SplitProfiles(InlinedProfileBag.Builder b) {
                this.emptyInput = b.conditionProfile();
                this.emptySeparator = b.conditionProfile();
                this.zeroLimit = b.conditionProfile();
                this.growBranch = b.branchProfile();
                this.matchProfile = b.countingConditionProfile();
            }
        }

        private static final class StringSplitter
        implements Splitter<TruffleString> {
            private StringSplitter() {
            }

            @Override
            public Object[] split(TruffleString input, int limit, TruffleString separator, int groupCount, JSStringSplitNode parent, SplitProfiles profiles) {
                if (profiles.emptySeparator.profile(parent, Strings.isEmpty(separator))) {
                    return StringSplitter.individualCharSplit(input, limit, parent);
                }
                return StringSplitter.regularSplit(input, limit, separator, parent, profiles);
            }

            private static Object[] regularSplit(TruffleString input, int limit, TruffleString separator, JSStringSplitNode parent, SplitProfiles profiles) {
                int end = parent.indexOf(input, separator, 0);
                if (profiles.matchProfile.profile(parent, end == -1)) {
                    return new Object[]{input};
                }
                return StringSplitter.regularSplitIntl(input, limit, separator, end, parent, profiles);
            }

            private static Object[] regularSplitIntl(TruffleString input, int limit, TruffleString separator, int endParam, JSStringSplitNode parent, SplitProfiles profiles) {
                SimpleArrayList<TruffleString> splits = SimpleArrayList.create(limit);
                int start2 = 0;
                int end = endParam;
                while (end != -1) {
                    splits.add(parent.substring(input, start2, end - start2), parent, profiles.growBranch);
                    if (splits.size() == limit) {
                        return splits.toArray();
                    }
                    start2 = end + Strings.length(separator);
                    end = parent.indexOf(input, separator, start2);
                }
                splits.add(parent.substring(input, start2), parent, profiles.growBranch);
                return splits.toArray();
            }

            private static Object[] individualCharSplit(TruffleString input, int limit, JSStringSplitNode parent) {
                int len = Math.min(Strings.length(input), limit);
                Object[] array = new Object[len];
                for (int i = 0; i < len; ++i) {
                    array[i] = parent.substring(input, i, 1);
                }
                return array;
            }
        }

        private static final class RegExpSplitter
        implements Splitter<JSRegExpObject> {
            private static final Object[] EMPTY_SPLITS = new Object[0];
            private static final Object[] SINGLE_ZERO_LENGTH_SPLIT = new Object[]{Strings.EMPTY_STRING};

            private RegExpSplitter() {
            }

            @Override
            public Object[] split(TruffleString input, int limit, JSRegExpObject regExp, int groupCount, JSStringSplitNode parent, SplitProfiles profiles) {
                if (profiles.emptyInput.profile(parent, Strings.isEmpty(input))) {
                    return RegExpSplitter.splitEmptyString(regExp, parent, profiles);
                }
                return RegExpSplitter.splitNonEmptyString(input, limit, regExp, groupCount, parent, profiles);
            }

            private static Object[] splitEmptyString(JSRegExpObject regExp, JSStringSplitNode parent, SplitProfiles profiles) {
                Object result2 = parent.matchIgnoreLastIndex(regExp, Strings.EMPTY_STRING, 0);
                return profiles.matchProfile.profile(parent, TRegexUtil.TRegexResultAccessor.isMatch(result2, parent, parent.readIsMatch)) ? EMPTY_SPLITS : SINGLE_ZERO_LENGTH_SPLIT;
            }

            private static Object[] splitNonEmptyString(TruffleString input, int limit, JSRegExpObject regExp, int groupCount, JSStringSplitNode parent, SplitProfiles profiles) {
                Object result2 = parent.matchIgnoreLastIndex(regExp, input, 0);
                if (profiles.matchProfile.profile(parent, !TRegexUtil.TRegexResultAccessor.isMatch(result2, parent, parent.readIsMatch))) {
                    return new Object[]{input};
                }
                SimpleArrayList<Object> splits = new SimpleArrayList<Object>();
                int start2 = 0;
                while (TRegexUtil.TRegexResultAccessor.isMatch(result2, parent, parent.readIsMatch)) {
                    int matchStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, 0, parent, parent.getStartNode);
                    int matchEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, 0, parent, parent.getEndNode);
                    if (matchEnd - matchStart == 0 && matchStart == start2) {
                        if (matchStart == Strings.length(input) - 1) break;
                        result2 = parent.matchIgnoreLastIndex(regExp, input, start2 + 1);
                        continue;
                    }
                    TruffleString split = parent.substring(input, start2, matchStart - start2);
                    splits.add(split, parent, profiles.growBranch);
                    int count = Math.min(groupCount - 1, limit - splits.size());
                    for (int i = 1; i <= count; ++i) {
                        int groupStart = TRegexUtil.TRegexResultAccessor.captureGroupStart(result2, i, parent, parent.getStartNode);
                        if (groupStart == -1) {
                            splits.add(Undefined.instance, parent, profiles.growBranch);
                            continue;
                        }
                        int groupEnd = TRegexUtil.TRegexResultAccessor.captureGroupEnd(result2, i, parent, parent.getEndNode);
                        splits.add(parent.substring(input, groupStart, groupEnd - groupStart), parent, profiles.growBranch);
                    }
                    if (splits.size() == limit) {
                        return splits.toArray();
                    }
                    start2 = matchEnd + (matchEnd == start2 ? 1 : 0);
                    result2 = parent.matchIgnoreLastIndex(regExp, input, start2);
                }
                splits.add(parent.substring(input, start2), parent, profiles.growBranch);
                return splits.toArray();
            }
        }
    }

    public static abstract class JSStringSubstrNode
    extends JSStringOperation {
        public JSStringSubstrNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object substrInt(TruffleString thisStr, int start2, int length2, @Cached @Cached.Shared(value="substring") TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared(value="startNegativeBranch") InlinedBranchProfile startNegativeBranch, @Cached @Cached.Shared(value="finalLenEmptyBranch") InlinedBranchProfile finalLenEmptyBranch) {
            return this.substrIntl(thisStr, start2, length2, substringNode, startNegativeBranch, finalLenEmptyBranch);
        }

        @Specialization(guards={"isUndefined(length)"})
        protected Object substrLenUndef(TruffleString thisStr, int start2, Object length2, @Cached @Cached.Shared(value="substring") TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared(value="startNegativeBranch") InlinedBranchProfile startNegativeBranch, @Cached @Cached.Shared(value="finalLenEmptyBranch") InlinedBranchProfile finalLenEmptyBranch) {
            return this.substrIntl(thisStr, start2, Strings.length(thisStr), substringNode, startNegativeBranch, finalLenEmptyBranch);
        }

        @Specialization
        protected Object substrGeneric(Object thisObj, Object start2, Object length2, @Cached @Cached.Shared(value="substring") TruffleString.SubstringByteIndexNode substringNode, @Cached @Cached.Shared(value="startNegativeBranch") InlinedBranchProfile startNegativeBranch, @Cached @Cached.Shared(value="finalLenEmptyBranch") InlinedBranchProfile finalLenEmptyBranch) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            int startInt = this.toIntegerAsInt(start2);
            int len = length2 == Undefined.instance ? Strings.length(thisStr) : this.toIntegerAsInt(length2);
            return this.substrIntl(thisStr, startInt, len, substringNode, startNegativeBranch, finalLenEmptyBranch);
        }

        private Object substrIntl(TruffleString thisStr, int start2, int length2, TruffleString.SubstringByteIndexNode substringNode, InlinedBranchProfile startNegativeBranch, InlinedBranchProfile finalLenEmptyBranch) {
            int finalLen;
            int startInt = start2;
            if (startInt < 0) {
                startNegativeBranch.enter(this);
                startInt = Math.max(startInt + Strings.length(thisStr), 0);
            }
            if ((finalLen = JSStringSubstrNode.within(length2, 0, Math.max(0, Strings.length(thisStr) - startInt))) <= 0) {
                finalLenEmptyBranch.enter(this);
                return Strings.EMPTY_STRING;
            }
            return Strings.substring(this.getContext(), substringNode, thisStr, startInt, startInt + finalLen - startInt);
        }
    }

    public static abstract class JSStringSubstringNode
    extends JSStringOperation
    implements JSBuiltinNode.Inlineable {
        private final ConditionProfile startLowerEnd = ConditionProfile.create();
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();

        public JSStringSubstringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString substring(TruffleString thisStr, int start2, int end) {
            int len = Strings.length(thisStr);
            int finalStart = JSStringSubstringNode.within(start2, 0, len);
            int finalEnd = JSStringSubstringNode.within(end, 0, len);
            return this.substringIntl(thisStr, finalStart, finalEnd);
        }

        @Specialization(guards={"isUndefined(end)"})
        protected TruffleString substringStart(TruffleString thisStr, int start2, Object end) {
            int len = Strings.length(thisStr);
            int finalStart = JSStringSubstringNode.within(start2, 0, len);
            int finalEnd = len;
            return this.substringIntl(thisStr, finalStart, finalEnd);
        }

        private TruffleString substringIntl(TruffleString thisStr, int start2, int end) {
            int length2;
            int fromIndex;
            if (this.startLowerEnd.profile(start2 <= end)) {
                fromIndex = start2;
                length2 = end - start2;
            } else {
                fromIndex = end;
                length2 = start2 - end;
            }
            return Strings.substring(this.getContext(), this.substringNode, thisStr, fromIndex, length2);
        }

        @Specialization(replaces={"substring", "substringStart"})
        protected TruffleString substringGeneric(Object thisObj, Object start2, Object end, @Cached JSToNumberNode toNumberNode, @Cached JSToNumberNode toNumber2Node, @Cached InlinedConditionProfile startUndefined, @Cached InlinedConditionProfile endUndefined) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            int len = Strings.length(thisStr);
            int intStart = startUndefined.profile(this, start2 == Undefined.instance) ? 0 : JSStringSubstringNode.withinNumber(toNumberNode.executeNumber(start2), 0, len);
            int intEnd = endUndefined.profile(this, end == Undefined.instance) ? len : JSStringSubstringNode.withinNumber(toNumber2Node.executeNumber(end), 0, len);
            return this.substringIntl(thisStr, intStart, intEnd);
        }

        @Override
        public Inlined createInlined() {
            return StringPrototypeBuiltinsFactory.JSStringSubstringNodeGen.InlinedNodeGen.create(this.getContext(), this.getBuiltin(), this.getArguments());
        }

        public static abstract class Inlined
        extends JSStringSubstringNode
        implements JSBuiltinNode.Inlined {
            public Inlined(JSContext context, JSBuiltin builtin) {
                super(context, builtin);
            }

            @Override
            @Specialization
            protected TruffleString substringGeneric(Object thisObj, Object start2, Object end, @Cached JSToNumberNode toNumberNode, @Cached JSToNumberNode toNumber2Node, @Cached InlinedConditionProfile startUndefined, @Cached InlinedConditionProfile endUndefined) {
                throw this.rewriteToCall();
            }

            protected abstract Object executeWithArguments(Object var1, Object var2, Object var3);

            @Override
            public Object callInlined(Object[] arguments) {
                if (JSArguments.getUserArgumentCount(arguments) < 1) {
                    throw this.rewriteToCall();
                }
                Object thisObj = JSArguments.getThisObject(arguments);
                Object start2 = JSArguments.getUserArgument(arguments, 0);
                JSDynamicObject end = JSArguments.getUserArgumentCount(arguments) >= 2 ? JSArguments.getUserArgument(arguments, 1) : Undefined.instance;
                return this.executeWithArguments(thisObj, start2, end);
            }
        }
    }

    public static abstract class JSStringToLowerCaseNode
    extends JSStringOperation {
        private final boolean locale;

        public JSStringToLowerCaseNode(JSContext context, JSBuiltin builtin, boolean locale) {
            super(context, builtin);
            this.locale = locale;
        }

        @Specialization
        protected Object toLowerCaseString(TruffleString thisStr) {
            return this.toLowerCaseIntl(thisStr);
        }

        @Specialization(guards={"!isString(thisObj)"})
        protected Object toLowerCase(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            return this.toLowerCaseIntl(thisStr);
        }

        private Object toLowerCaseIntl(TruffleString str) {
            return Strings.toLowerCase(str, this.locale ? this.getContext().getLocale() : Locale.US);
        }
    }

    public static abstract class JSStringToLocaleLowerCaseIntlNode
    extends JSStringToLocaleXCaseIntl {
        public JSStringToLocaleLowerCaseIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected TruffleString toXCase(String thisStr, String[] locales) {
            return IntlUtil.toLowerCase(this.getContext(), thisStr, locales);
        }
    }

    public static abstract class JSStringToUpperCaseNode
    extends JSStringOperation {
        private final boolean locale;

        public JSStringToUpperCaseNode(JSContext context, JSBuiltin builtin, boolean locale) {
            super(context, builtin);
            this.locale = locale;
        }

        @Specialization
        protected Object toUpperCaseString(TruffleString thisStr) {
            return this.toUpperCaseIntl(thisStr);
        }

        @Specialization(guards={"!isString(thisObj)"})
        protected Object toUpperCaseGeneric(Object thisObj) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            return this.toUpperCaseIntl(thisStr);
        }

        private Object toUpperCaseIntl(TruffleString str) {
            return Strings.toUpperCase(str, this.locale ? this.getContext().getLocale() : Locale.US);
        }
    }

    public static abstract class JSStringToLocaleUpperCaseIntlNode
    extends JSStringToLocaleXCaseIntl {
        public JSStringToLocaleUpperCaseIntlNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Override
        protected TruffleString toXCase(String thisStr, String[] locales) {
            return IntlUtil.toUpperCase(this.getContext(), thisStr, locales);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSStringToStringNode
    extends JSBuiltinNode {
        public JSStringToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public static JSStringToStringNode createStringToString(JSContext context) {
            return StringPrototypeBuiltinsFactory.JSStringToStringNodeGen.create(context, null, null);
        }

        @Specialization
        protected TruffleString toStringTString(TruffleString thisStr) {
            return thisStr;
        }

        @Specialization(guards={"isJSString(thisStr)"})
        protected TruffleString toStringString(JSDynamicObject thisStr) {
            return JSString.getString(thisStr);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected TruffleString toStringForeignObject(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            if (interop.isString(thisObj)) {
                return Strings.interopAsTruffleString(thisObj, interop, switchEncoding);
            }
            return this.toStringOther(thisObj);
        }

        @Fallback
        protected TruffleString toStringOther(Object thisObj) {
            throw Errors.createTypeError("string object expected");
        }
    }

    public static abstract class JSStringTrimNode
    extends JSStringOperation {
        public JSStringTrimNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object trimString(TruffleString thisStr, @Cached.Shared(value="trimWhitespace") @Cached JSTrimWhitespaceNode trimWhitespaceNode) {
            return trimWhitespaceNode.executeString(thisStr);
        }

        @Specialization(guards={"!isString(thisObj)"})
        protected Object trimObject(Object thisObj, @Cached.Shared(value="trimWhitespace") @Cached JSTrimWhitespaceNode trimWhitespaceNode) {
            this.requireObjectCoercible(thisObj);
            return trimWhitespaceNode.executeString(this.toString(thisObj));
        }
    }

    public static abstract class JSStringStartsWithNode
    extends JSStringOperation {
        private final BranchProfile noStringBranch = BranchProfile.create();

        public JSStringStartsWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean startsWithString(TruffleString thisObj, TruffleString searchStr, JSDynamicObject position, @Cached @Cached.Shared(value="regionEqualsNode") TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
            if (Strings.length(searchStr) <= 0) {
                return true;
            }
            if (Strings.length(thisObj) < Strings.length(searchStr)) {
                return false;
            }
            return Strings.startsWith(regionEqualsNode, thisObj, searchStr);
        }

        @Specialization(guards={"!isStringString(thisObj, searchString) || !isUndefined(position)"})
        protected boolean startsWithGeneric(Object thisObj, Object searchString, Object position, @Cached JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode, @Cached @Cached.Shared(value="regionEqualsNode") TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                this.noStringBranch.enter();
                throw Errors.createTypeError("First argument to String.prototype.startsWith must not be a regular expression");
            }
            TruffleString searchStr = toString2Node.executeString(searchString);
            int fromIndex = this.toIntegerAsInt(position);
            if (Strings.length(searchStr) <= 0) {
                return true;
            }
            return Strings.startsWith(regionEqualsNode, thisStr, searchStr, Math.max(0, fromIndex));
        }
    }

    public static abstract class JSStringEndsWithNode
    extends JSStringOperation {
        private final BranchProfile noStringBranch = BranchProfile.create();

        public JSStringEndsWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean endsWithStringUndefined(TruffleString thisStr, TruffleString searchStr, Object position, @Cached @Cached.Shared(value="regionEqualsNode") TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
            int fromIndex = Strings.length(thisStr);
            if (Strings.length(searchStr) <= 0) {
                return true;
            }
            if (fromIndex >= Strings.length(thisStr)) {
                fromIndex = Strings.length(thisStr);
            } else if (fromIndex < 0) {
                return false;
            }
            return JSStringEndsWithNode.endsWithIntl(regionEqualsNode, thisStr, searchStr, fromIndex);
        }

        @Specialization(guards={"!isStringString(thisObj, searchString) || !isUndefined(position)"})
        protected boolean endsWithGeneric(Object thisObj, Object searchString, Object position, @Cached JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode, @Cached @Cached.Shared(value="regionEqualsNode") TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                this.noStringBranch.enter();
                throw Errors.createTypeError("First argument to String.prototype.endsWith must not be a regular expression");
            }
            TruffleString searchStr = toString2Node.executeString(searchString);
            int fromIndex = this.toIntegerAsInt(position);
            if (Strings.length(searchStr) <= 0) {
                return true;
            }
            if (fromIndex >= Strings.length(thisStr) || position == Undefined.instance) {
                fromIndex = Strings.length(thisStr);
            } else if (fromIndex < 0) {
                return false;
            }
            return JSStringEndsWithNode.endsWithIntl(regionEqualsNode, thisStr, searchStr, fromIndex);
        }

        private static boolean endsWithIntl(TruffleString.RegionEqualByteIndexNode regionEqualsNode, TruffleString thisStr, TruffleString searchStr, int fromIndex) {
            int searchStrLength = Strings.length(searchStr);
            int offset1 = fromIndex - searchStrLength;
            return offset1 >= 0 && Strings.regionEquals(regionEqualsNode, thisStr, offset1, searchStr, 0, searchStrLength);
        }
    }

    public static abstract class JSStringIncludesNode
    extends JSStringOperation {
        public JSStringIncludesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isUndefined(position)"})
        protected boolean includesString(TruffleString thisStr, TruffleString searchStr, Object position, @Cached @Cached.Shared(value="indexOfStringNode") TruffleString.ByteIndexOfStringNode indexOfStringNode) {
            return Strings.indexOf(indexOfStringNode, thisStr, searchStr) != -1;
        }

        @Specialization(guards={"!isStringString(thisObj, searchString) || !isUndefined(position)"})
        protected boolean includesGeneric(Object thisObj, Object searchString, Object position, @Cached JSToStringNode toString2Node, @Cached(value="create(getContext())") IsRegExpNode isRegExpNode, @Cached @Cached.Shared(value="indexOfStringNode") TruffleString.ByteIndexOfStringNode indexOfStringNode, @Cached InlinedBranchProfile errorBranch) {
            int fromIndex;
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (isRegExpNode.executeBoolean(searchString)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("First argument to String.prototype.includes must not be a regular expression");
            }
            TruffleString searchStr = toString2Node.executeString(searchString);
            return Strings.indexOf(indexOfStringNode, thisStr, searchStr, fromIndex = this.toIntegerAsInt(position)) != -1;
        }
    }

    public static abstract class JSStringRepeatNode
    extends JSStringOperation {
        public JSStringRepeatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object repeat(Object thisObj, Object count, @Cached JSToNumberNode toNumberNode, @Cached TruffleString.RepeatNode repeatNode, @Cached InlinedBranchProfile errorBranch) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            Number repeatCountN = toNumberNode.executeNumber(count);
            long repeatCount = JSRuntime.toInteger(repeatCountN);
            if (repeatCount < 0L || repeatCountN instanceof Double && Double.isInfinite(repeatCountN.doubleValue())) {
                errorBranch.enter(this);
                throw Errors.createRangeError("illegal repeat count");
            }
            if (repeatCount == 1L) {
                return thisStr;
            }
            if (repeatCount == 0L || Strings.length(thisStr) == 0) {
                return Strings.EMPTY_STRING;
            }
            int repeatCountInt = (int)repeatCount;
            if ((long)repeatCountInt != repeatCount || repeatCount * (long)Strings.length(thisStr) > (long)this.getContext().getStringLengthLimit()) {
                errorBranch.enter(this);
                throw Errors.createRangeErrorInvalidStringLength();
            }
            return repeatNode.execute(thisStr, repeatCountInt, TruffleString.Encoding.UTF_16);
        }
    }

    public static abstract class JSStringCodePointAtNode
    extends JSStringOperation {
        public JSStringCodePointAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object codePointAt(Object thisObj, Object position, @Cached TruffleString.CodePointAtByteIndexNode codePointAtRawNode, @Cached InlinedBranchProfile undefinedBranch, @Cached InlinedBranchProfile needSecondBranch, @Cached InlinedBranchProfile needCalculationBranch) {
            boolean isEnd;
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            int pos = this.toIntegerAsInt(position);
            if (pos < 0 || Strings.length(thisStr) <= pos) {
                undefinedBranch.enter(this);
                return Undefined.instance;
            }
            int first = Strings.codePointAt(codePointAtRawNode, thisStr, pos);
            boolean bl = isEnd = pos + 1 == Strings.length(thisStr);
            if (isEnd || first < 55296 || first > 56319) {
                return first;
            }
            needSecondBranch.enter(this);
            int second = Strings.codePointAt(codePointAtRawNode, thisStr, pos + 1);
            if (second < 56320 || second > 57343) {
                return first;
            }
            needCalculationBranch.enter(this);
            return (first - 55296) * 1024 + (second - 56320) + 65536;
        }
    }

    public static abstract class CreateStringIteratorNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;

        public CreateStringIteratorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSString.ITERATED_STRING_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSString.STRING_ITERATOR_NEXT_INDEX_ID, context);
        }

        @Specialization
        protected JSDynamicObject doString(TruffleString thisObj) {
            JSObject iterator = this.createObjectNode.execute(this.getRealm().getStringIteratorPrototype());
            this.setIteratedObjectNode.setValue(iterator, thisObj);
            this.setNextIndexNode.setValueInt(iterator, 0);
            return iterator;
        }

        @Specialization(guards={"!isString(thisObj)"})
        protected JSDynamicObject doCoerce(Object thisObj, @Cached RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached JSToStringNode toStringNode) {
            return this.doString(toStringNode.executeString(requireObjectCoercibleNode.execute(thisObj)));
        }
    }

    public static abstract class JSStringNormalizeNode
    extends JSStringOperation {
        public JSStringNormalizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString normalize(Object thisObj, Object form, @Cached TruffleString.EqualNode stringEqualsNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            Normalizer.Form useForm = null;
            if (form == Undefined.instance) {
                useForm = Normalizer.Form.NFC;
            } else {
                TruffleString formStr = this.toString(form);
                if (Strings.equals(stringEqualsNode, formStr, Strings.NFC)) {
                    useForm = Normalizer.Form.NFC;
                } else if (Strings.equals(stringEqualsNode, formStr, Strings.NFD)) {
                    useForm = Normalizer.Form.NFD;
                } else if (Strings.equals(stringEqualsNode, formStr, Strings.NFKC)) {
                    useForm = Normalizer.Form.NFKC;
                } else if (Strings.equals(stringEqualsNode, formStr, Strings.NFKD)) {
                    useForm = Normalizer.Form.NFKD;
                } else {
                    throw Errors.createRangeError("The normalization form should be one of NFC, NFD, NFKC, NFKD.");
                }
            }
            return Strings.fromJavaString(fromJavaStringNode, JSStringNormalizeNode.doNormalize(Strings.toJavaString(toJavaStringNode, thisStr), useForm));
        }

        @CompilerDirectives.TruffleBoundary
        private static String doNormalize(String thisStr, Normalizer.Form form) {
            return Normalizer.normalize(thisStr, form);
        }
    }

    public static abstract class JSStringPadNode
    extends JSStringOperation {
        private final boolean atStart;

        public JSStringPadNode(JSContext context, JSBuiltin builtin, boolean atStart) {
            super(context, builtin);
            this.atStart = atStart;
        }

        @Specialization
        protected Object pad(Object thisObj, Object[] args, @Cached JSToStringNode toString2Node, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendSubstringByteIndexNode appendSubStringNode, @Cached TruffleStringBuilder.ToStringNode builderToStringNode) {
            TruffleString fillStr;
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (args.length == 0) {
                return thisStr;
            }
            int len = this.toIntegerAsInt(args[0]);
            if (len <= Strings.length(thisStr)) {
                return thisStr;
            }
            if (args.length <= 1 || args[1] == Undefined.instance) {
                fillStr = Strings.SPACE;
            } else {
                fillStr = toString2Node.executeString(args[1]);
                if (Strings.isEmpty(fillStr)) {
                    return thisStr;
                }
            }
            if (len > this.getContext().getStringLengthLimit()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorInvalidStringLength();
            }
            assert (!Strings.isEmpty(fillStr));
            int pos = len - Strings.length(thisStr);
            int fillLen = Strings.length(fillStr);
            TruffleStringBuilder sb = Strings.builderCreate(len);
            if (!this.atStart) {
                Strings.builderAppend(appendStringNode, sb, thisStr);
            }
            while (pos >= fillLen) {
                Strings.builderAppend(appendStringNode, sb, fillStr);
                pos -= fillLen;
            }
            if (pos > 0) {
                Strings.builderAppend(appendSubStringNode, sb, fillStr, 0, pos);
            }
            if (this.atStart) {
                Strings.builderAppend(appendStringNode, sb, thisStr);
            }
            return Strings.builderToString(builderToStringNode, sb);
        }
    }

    static abstract class CreateHTMLNode
    extends JSBuiltinNode {
        private final TruffleString tag;
        private final TruffleString attribute;
        private final boolean emptyAttr;

        CreateHTMLNode(JSContext context, JSBuiltin builtin, TruffleString tag, TruffleString attribute) {
            super(context, builtin);
            this.tag = tag;
            this.attribute = attribute;
            this.emptyAttr = Strings.isEmpty(attribute);
        }

        @Specialization
        protected Object createHTML(Object thisObj, Object value2, @Cached RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached JSToStringNode toStringNode) {
            TruffleString string = toStringNode.executeString(requireObjectCoercibleNode.execute(thisObj));
            if (!this.emptyAttr) {
                TruffleString attrVal = toStringNode.executeString(value2);
                return this.wrapInTagWithAttribute(string, attrVal);
            }
            return this.wrapInTag(string);
        }

        @CompilerDirectives.TruffleBoundary
        private Object wrapInTag(TruffleString string) {
            return Strings.concatAll(Strings.ANGLE_BRACKET_OPEN, this.tag, Strings.ANGLE_BRACKET_CLOSE, string, Strings.ANGLE_BRACKET_OPEN_SLASH, this.tag, Strings.ANGLE_BRACKET_CLOSE);
        }

        @CompilerDirectives.TruffleBoundary
        private Object wrapInTagWithAttribute(TruffleString string, TruffleString attrVal) {
            TruffleString escapedVal = Strings.replace(attrVal, Strings.DOUBLE_QUOTE, Strings.HTML_QUOT);
            return Strings.concatAll(Strings.ANGLE_BRACKET_OPEN, this.tag, Strings.SPACE, this.attribute, Strings.EQUALS_DOUBLE_QUOTE, escapedVal, Strings.DOUBLE_QUOTE, Strings.ANGLE_BRACKET_CLOSE, string, Strings.ANGLE_BRACKET_OPEN_SLASH, this.tag, Strings.ANGLE_BRACKET_CLOSE);
        }
    }

    public static abstract class JSStringAtNode
    extends JSStringOperation {
        public JSStringAtNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object at(Object thisObj, Object index, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            int k;
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            int relativeIndex = this.toIntegerAsInt(index);
            int n = k = relativeIndex >= 0 ? relativeIndex : Strings.length(thisStr) + relativeIndex;
            if (k < 0 || k >= Strings.length(thisStr)) {
                return Undefined.instance;
            }
            return Strings.substring(this.getContext(), substringNode, thisStr, k, 1);
        }
    }

    public static final class StringPrototypeExtensionBuiltins
    extends JSBuiltinsContainer.SwitchEnum<StringExtensionBuiltins> {
        protected StringPrototypeExtensionBuiltins() {
            super(JSString.CLASS_NAME_EXTENSIONS, StringExtensionBuiltins.class);
        }

        @Override
        protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringExtensionBuiltins builtinEnum) {
            switch (builtinEnum) {
                case trimStart: {
                    return StringPrototypeBuiltinsFactory.JSStringTrimLeftNodeGen.create(context, builtin, StringPrototypeExtensionBuiltins.args().withThis().createArgumentNodes(context));
                }
                case trimEnd: {
                    return StringPrototypeBuiltinsFactory.JSStringTrimRightNodeGen.create(context, builtin, StringPrototypeExtensionBuiltins.args().withThis().createArgumentNodes(context));
                }
            }
            return null;
        }

        public static enum StringExtensionBuiltins implements BuiltinEnum<StringExtensionBuiltins>
        {
            trimStart(0),
            trimEnd(0);

            private final int length;

            private StringExtensionBuiltins(int length2) {
                this.length = length2;
            }

            @Override
            public int getLength() {
                return this.length;
            }
        }
    }

    public static class CreateRegExpStringIteratorNode
    extends JavaScriptBaseNode {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setIteratingRegExpNode;
        @Node.Child
        private PropertySetNode setIteratedStringNode;
        @Node.Child
        private PropertySetNode setGlobalNode;
        @Node.Child
        private PropertySetNode setUnicodeNode;
        @Node.Child
        private PropertySetNode setDoneNode;

        public CreateRegExpStringIteratorNode(JSContext context) {
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratingRegExpNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_ITERATING_REGEXP_ID, context);
            this.setIteratedStringNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_ITERATED_STRING_ID, context);
            this.setGlobalNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_GLOBAL_ID, context);
            this.setUnicodeNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_UNICODE_ID, context);
            this.setDoneNode = PropertySetNode.createSetHidden(JSString.REGEXP_ITERATOR_DONE_ID, context);
        }

        public JSDynamicObject createIterator(Object regex, Object string, Boolean global, Boolean fullUnicode) {
            JSDynamicObject regExpStringIteratorPrototype = this.getRealm().getRegExpStringIteratorPrototype();
            JSObject iterator = this.createObjectNode.execute(regExpStringIteratorPrototype);
            this.setIteratingRegExpNode.setValue(iterator, regex);
            this.setIteratedStringNode.setValue(iterator, string);
            this.setGlobalNode.setValueBoolean(iterator, global);
            this.setUnicodeNode.setValueBoolean(iterator, fullUnicode);
            this.setDoneNode.setValueBoolean(iterator, false);
            return iterator;
        }
    }

    public static abstract class JSStringTrimRightNode
    extends JSStringOperation {
        private final ConditionProfile lengthExceeded = ConditionProfile.create();

        public JSStringTrimRightNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object trimRight(Object thisObj, @Cached TruffleString.ReadCharUTF16Node readRawNode, @Cached TruffleString.SubstringByteIndexNode substringNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString string = this.toString(thisObj);
            int lastIdx = JSRuntime.lastNonWhitespaceIndex(string, true, readRawNode);
            if (this.lengthExceeded.profile(lastIdx >= Strings.length(string))) {
                return string;
            }
            return Strings.substring(this.getContext(), substringNode, string, 0, lastIdx + 1);
        }
    }

    public static abstract class JSStringTrimLeftNode
    extends JSStringOperation {
        private final ConditionProfile lengthExceeded = ConditionProfile.create();
        private final ConditionProfile lengthZero = ConditionProfile.create();

        public JSStringTrimLeftNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object trimLeft(Object thisObj, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached TruffleString.ReadCharUTF16Node readRawNode) {
            this.requireObjectCoercible(thisObj);
            TruffleString string = this.toString(thisObj);
            int firstIdx = JSRuntime.firstNonWhitespaceIndex(string, true, readRawNode);
            if (this.lengthZero.profile(firstIdx == 0)) {
                return string;
            }
            if (this.lengthExceeded.profile(firstIdx >= Strings.length(string))) {
                return Strings.EMPTY_STRING;
            }
            return Strings.substring(this.getContext(), substringNode, string, firstIdx);
        }
    }

    public static abstract class JSStringToLocaleXCaseIntl
    extends JSStringOperation {
        @Node.Child
        JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;

        public JSStringToLocaleXCaseIntl(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        }

        @Specialization
        protected Object toDesiredCase(Object thisObj, Object locale) {
            this.requireObjectCoercible(thisObj);
            TruffleString thisStr = this.toString(thisObj);
            if (thisStr == null || Strings.isEmpty(thisStr)) {
                return thisStr;
            }
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(locale);
            return this.toXCase(Strings.toJavaString(thisStr), locales);
        }

        protected TruffleString toXCase(String thisStr, String[] locales) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class JSStringReplaceBaseNode
    extends JSStringOperationWithRegExpArgument {
        @Node.Child
        protected JSFunctionCallNode functionReplaceCallNode;
        protected final ConditionProfile functionalReplaceProfile = ConditionProfile.create();
        protected final ConditionProfile replaceNecessaryProfile = ConditionProfile.create();
        @Node.Child
        protected TruffleStringBuilder.ToStringNode builderToStringNode = TruffleStringBuilder.ToStringNode.create();
        @Node.Child
        protected TruffleStringBuilder.AppendStringNode appendStringNode = TruffleStringBuilder.AppendStringNode.create();
        @Node.Child
        protected TruffleStringBuilder.AppendSubstringByteIndexNode appendSubStringNode = TruffleStringBuilder.AppendSubstringByteIndexNode.create();

        public JSStringReplaceBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected ReplaceStringParser.Token[] parseReplaceValue(TruffleString replaceValue) {
            return ReplaceStringParser.parse(this.getContext(), replaceValue, 0, false);
        }

        protected static void appendSubstitution(TruffleStringBuilder sb, TruffleString input, TruffleString replaceStr, TruffleString searchStr, int pos, JSStringReplaceBaseNode node, Node profileNode, InlinedBranchProfile dollarProfile) {
            ReplaceStringParser.process(node.getContext(), replaceStr, 0, false, new ReplaceStringConsumer(sb, input, replaceStr, searchStr, pos), node, profileNode, dollarProfile);
        }

        protected final Object functionReplaceCall(Object splitter, Object separator, Object[] args) {
            if (this.functionReplaceCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.functionReplaceCallNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.functionReplaceCallNode.executeCall(JSArguments.create(separator, splitter, args));
        }

        void append(TruffleStringBuilder sb, TruffleString s) {
            Strings.builderAppend(this.appendStringNode, sb, s);
        }

        void append(TruffleStringBuilder sb, TruffleString s, int fromIndex, int toIndex) {
            Strings.builderAppend(this.appendSubStringNode, sb, s, fromIndex, toIndex);
        }

        void appendLen(TruffleStringBuilder sb, TruffleString s, int fromIndex, int length2) {
            Strings.builderAppendLen(this.appendSubStringNode, sb, s, fromIndex, length2);
        }

        TruffleString builderToString(TruffleStringBuilder sb) {
            return Strings.builderToString(this.builderToStringNode, sb);
        }

        protected static final class ReplaceStringConsumer
        implements ReplaceStringParser.Consumer<JSStringReplaceBaseNode, TruffleStringBuilder> {
            private final TruffleStringBuilder sb;
            private final TruffleString input;
            private final TruffleString searchStr;
            private final TruffleString replaceStr;
            private final int matchedPos;

            private ReplaceStringConsumer(TruffleStringBuilder sb, TruffleString input, TruffleString replaceStr, TruffleString searchStr, int matchedPos) {
                this.sb = sb;
                this.input = input;
                this.replaceStr = replaceStr;
                this.searchStr = searchStr;
                this.matchedPos = matchedPos;
            }

            @Override
            public void literal(JSStringReplaceBaseNode node, int start2, int end) {
                node.append(this.sb, this.replaceStr, start2, end);
            }

            @Override
            public void match(JSStringReplaceBaseNode node) {
                node.append(this.sb, this.searchStr);
            }

            @Override
            public void matchHead(JSStringReplaceBaseNode node) {
                node.append(this.sb, this.input, 0, this.matchedPos);
            }

            @Override
            public void matchTail(JSStringReplaceBaseNode node) {
                node.append(this.sb, this.input, this.matchedPos + Strings.length(this.searchStr), Strings.length(this.input));
            }

            @Override
            public void captureGroup(JSStringReplaceBaseNode node, int groupNumber, int literalStart, int literalEnd) {
                throw Errors.shouldNotReachHere();
            }

            @Override
            public void namedCaptureGroup(JSStringReplaceBaseNode node, TruffleString groupName) {
                throw Errors.shouldNotReachHere();
            }

            @Override
            public TruffleStringBuilder getResult() {
                return this.sb;
            }
        }
    }

    public static abstract class JSStringOperationWithRegExpArgument
    extends JSStringOperation {
        @Node.Child
        protected JSRegExpExecIntlNode regExpNode;
        @Node.Child
        protected JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode regExpIgnoreLastIndexNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private PropertyGetNode getSymbolNode;
        @Node.Child
        private GetMethodNode getMethodNode;
        protected final ConditionProfile isSpecialProfile = ConditionProfile.create();
        protected final ConditionProfile callSpecialProfile = ConditionProfile.create();

        public JSStringOperationWithRegExpArgument(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected final Object matchIgnoreLastIndex(JSDynamicObject regExp, TruffleString input, int fromIndex) {
            assert (this.getContext().getEcmaScriptVersion() <= 5);
            return this.getRegExpIgnoreLastIndexNode().execute(regExp, input, fromIndex);
        }

        protected JSRegExpExecIntlNode getRegExpNode() {
            if (this.regExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regExpNode = this.insert(JSRegExpExecIntlNode.create(this.getContext()));
            }
            return this.regExpNode;
        }

        protected JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode getRegExpIgnoreLastIndexNode() {
            if (this.regExpIgnoreLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regExpIgnoreLastIndexNode = this.insert(JSRegExpExecIntlNode.JSRegExpExecIntlIgnoreLastIndexNode.create(this.getContext(), true));
            }
            return this.regExpIgnoreLastIndexNode;
        }

        protected final Object call(Object function, Object target, Object[] args) {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callNode.executeCall(JSArguments.create(target, function, args));
        }

        protected final Object invoke(JSDynamicObject regExp, Symbol symbol, TruffleString thisStr) {
            assert (JSRuntime.isPropertyKey(symbol));
            if (this.getSymbolNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSymbolNode = this.insert(PropertyGetNode.create(symbol, false, this.getContext()));
            }
            Object func = this.getSymbolNode.getValue(regExp);
            return this.call(func, regExp, new Object[]{thisStr});
        }

        protected final Object getMethod(Object target, Object key) {
            if (this.getMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMethodNode = this.insert(GetMethodNode.create(this.getContext(), key));
            }
            return this.getMethodNode.executeWithTarget(target);
        }
    }

    static abstract class JSStringOperation
    extends JSBuiltinNode {
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode;
        @Node.Child
        private JSToStringNode toStringNode;
        @Node.Child
        private JSToIntegerAsIntNode toIntegerNode;
        @Node.Child
        private TruffleString.ReadCharUTF16Node stringReadNode;

        JSStringOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static int within(int value2, int min, int max) {
            assert (min <= max);
            if (value2 >= max) {
                return max;
            }
            if (value2 <= min) {
                return min;
            }
            return value2;
        }

        protected static int withinNumber(Number value2, int min, int max) {
            assert (min <= max);
            double dValue = JSRuntime.doubleValue(value2);
            if (Double.isInfinite(dValue)) {
                return dValue < 0.0 ? min : max;
            }
            long lValue = JSRuntime.intValue(value2);
            if (lValue >= (long)max) {
                return max;
            }
            if (lValue <= (long)min) {
                return min;
            }
            return (int)lValue;
        }

        protected final void requireObjectCoercible(Object target) {
            if (this.requireObjectCoercibleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.requireObjectCoercibleNode = this.insert(RequireObjectCoercibleNode.create());
            }
            this.requireObjectCoercibleNode.executeVoid(target);
        }

        protected TruffleString toString(Object target) {
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStringNode = this.insert(JSToStringNode.create());
            }
            return this.toStringNode.executeString(target);
        }

        protected char charAt(TruffleString s, int i) {
            if (this.stringReadNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.stringReadNode = this.insert(TruffleString.ReadCharUTF16Node.create());
            }
            return Strings.charAt(this.stringReadNode, s, i);
        }

        protected int toIntegerAsInt(Object target) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = this.insert(JSToIntegerAsIntNode.create());
            }
            return this.toIntegerNode.executeInt(target);
        }
    }
}

