/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class EmptyStatementBodyJSInspection
extends JavaScriptInspection {
    public boolean m_reportEmptyBlocks = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        if (args[0] instanceof JSIfStatement) {
            String string = InspectionJSBundle.message("statement.has.empty.branch.error.string", new Object[0]);
            if (string == null) {
                EmptyStatementBodyJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("statement.has.empty.body.error.string", new Object[0]);
        if (string == null) {
            EmptyStatementBodyJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_reportEmptyBlocks", (String)InspectionJSBundle.message("include.statement.bodies.that.are.empty.code.blocks.parameter", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            EmptyStatementBodyJSInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/confusing/EmptyStatementBodyJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        @Override
        public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSDoWhileStatement(statement);
            JSStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (!this.isEmpty(body2)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSWhileStatement(statement);
            JSStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (!this.isEmpty(body2)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(2);
            }
            super.visitJSForStatement(statement);
            JSStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (!this.isEmpty(body2)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitJSForInStatement(@NotNull JSForInStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSForInStatement(statement);
            JSStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (!this.isEmpty(body2)) {
                return;
            }
            this.registerStatementError(statement, statement);
        }

        @Override
        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            if (statement == null) {
                EmptyStatementVisitor.$$$reportNull$$$0(4);
            }
            super.visitJSIfStatement(statement);
            JSStatement thenBranch = (JSStatement)statement.getThenBranch();
            if (thenBranch != null && this.isEmpty(thenBranch)) {
                this.registerStatementError(statement, statement);
                return;
            }
            JSStatement elseBranch = (JSStatement)statement.getElseBranch();
            if (elseBranch != null && this.isEmpty(elseBranch)) {
                this.registerStatementError(statement, statement);
            }
        }

        private boolean isEmpty(JSElement body2) {
            if (body2 instanceof JSEmptyStatement) {
                return true;
            }
            if (EmptyStatementBodyJSInspection.this.m_reportEmptyBlocks && body2 instanceof JSBlockStatement) {
                JSBlockStatement block = (JSBlockStatement)body2;
                JSSourceElement[] statements = block.getStatementListItems();
                return statements.length == 0;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/sixrr/inspectjs/confusing/EmptyStatementBodyJSInspection$EmptyStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDoWhileStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIfStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

