/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.JSCompilingVisitor;
import com.intellij.structuralsearch.JSExprTypePredicate;
import com.intellij.structuralsearch.JSMatchingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new CompiledPattern(){

            public String @NotNull [] getTypedVarPrefixes() {
                String[] stringArray = new String[]{JSStructuralSearchProfile.TYPED_VAR_PREFIX};
                if (stringArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return stringArray;
            }

            public boolean isTypedVar(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(1);
                }
                return str.startsWith(JSStructuralSearchProfile.TYPED_VAR_PREFIX);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/JSStructuralSearchProfile$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypedVarPrefixes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/JSStructuralSearchProfile$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isTypedVar";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (element instanceof JSExpressionStatement) {
            String string = StringUtil.trimEnd((String)element.getText(), (char)';');
            if (string == null) {
                JSStructuralSearchProfile.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.getTypedVarString(element);
        if (string == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void compile(PsiElement @NotNull [] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        new JSCompilingVisitor(globalVisitor).compile(elements);
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return new JSMatchingVisitor(globalVisitor);
    }

    public boolean isMatchNode(@NotNull PsiElement element) {
        if (element == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        if (!(element instanceof LeafElement)) {
            return true;
        }
        IElementType type = ((LeafElement)element).getElementType();
        return type != JSTokenTypes.COMMA && type != JSTokenTypes.SEMICOLON && type != JSTokenTypes.RBRACE;
    }

    static boolean canBePatternVariable(PsiElement element) {
        ASTNode node;
        PsiElement child = element.getFirstChild();
        if (child == null) {
            return true;
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSParameter) && (node = child.getNode()) != null) {
            return node.getElementType() == JSTokenTypes.IDENTIFIER && child.getNextSibling() == null;
        }
        return false;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        return language instanceof JSLanguageDialect;
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element != null && element.getNode().getElementType() == JSTokenTypes.IDENTIFIER;
    }

    @NotNull
    public List<MatchPredicate> getCustomPredicates(@NotNull MatchVariableConstraint constraint, @NotNull String name, @NotNull MatchOptions options) {
        if (constraint == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (options == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        SmartList result2 = new SmartList();
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getExpressionTypes())) {
            JSExprTypePredicate predicate = new JSExprTypePredicate(constraint.getExpressionTypes(), constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch());
            result2.add(constraint.isInvertExprType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    public boolean isApplicableConstraint(@NotNull String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        if (constraintName == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (constraintName.equals("TYPE")) {
            PsiElement parent;
            return variableNode != null && ((parent = variableNode.getParent()) instanceof JSExpression || parent instanceof JSFunction || parent instanceof JSVariable);
        }
        return super.isApplicableConstraint(constraintName, variableNode, completePattern, target);
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaScriptCodeContextType.class;
    }

    public void checkSearchPattern(@NotNull CompiledPattern pattern) {
        if (pattern == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    public void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options) {
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        if (options == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        MatchOptions matchOptions = options.getMatchOptions();
        LanguageFileType fileType = matchOptions.getFileType();
        Language dialect = matchOptions.getDialect();
        assert (fileType != null);
        assert (dialect != null);
        boolean searchIsExpression = this.isProbableExpression(matchOptions.getSearchPattern(), fileType, dialect, project);
        boolean replacementIsExpression = this.isProbableExpression(options.getReplacement(), fileType, dialect, project);
        boolean targetFound = false;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (!constraint.isPartOfSearchResults()) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replacementIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message((String)"replacement.template.is.not.expression.error.message", (Object[])new Object[0]) : SSRBundle.message((String)"search.template.is.not.expression.error.message", (Object[])new Object[0]));
        }
    }

    private boolean isProbableExpression(@NotNull String pattern, @NotNull LanguageFileType fileType, @NotNull Language dialect, @NotNull Project project) {
        PsiElement[] searchElements;
        if (pattern == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(17);
        }
        if (dialect == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(18);
        }
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(19);
        }
        if ((searchElements = this.createPatternTree(pattern, PatternTreeContext.Block, fileType, dialect, null, project, false)).length != 1) {
            return false;
        }
        PsiElement element = searchElements[0];
        if (!(element instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement lastChild = element.getLastChild();
        return !(lastChild instanceof LeafPsiElement) || ((LeafPsiElement)lastChild).getElementType() != JSTokenTypes.SEMICOLON;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(20);
        }
        if (replaceOptions == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(21);
        }
        return new DocumentBasedReplaceHandler(project);
    }

    public Configuration @NotNull [] getPredefinedTemplates() {
        String general = "JavaScript/General";
        String suspicious = "JavaScript/Suspicious";
        Configuration[] configurationArray = new Configuration[]{PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.anonymous.functions", new Object[0]), (String)"anonymous functions", (String)"var '_name = function('_parameter*) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.functions", new Object[0]), (String)"functions", (String)"function '_name('_parameter*) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.variables", new Object[0]), (String)"variables", (String)"var '_name+ = '_initializer?;", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.function.calls", new Object[0]), (String)"function calls", (String)"'_qualifier?.'_name('_argument*)", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.while.loops", new Object[0]), (String)"while loops", (String)"while ('_condition) {\n  '_statement*;\n}", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.constants", new Object[0]), (String)"constants", (String)"const '_name;", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.classes", new Object[0]), (String)"Classes", (String)"class '_name {}", (String)"JavaScript/General", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.empty.functions", new Object[0]), (String)"empty functions", (String)"function '_name('_parameter*) {}", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.console.log.calls", new Object[0]), (String)"console.log() calls", (String)"console.log('_argument*)", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.with.statements", new Object[0]), (String)"with statements", (String)"with ('_expression) {\n  '_statement*;\n}", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.var.statements", new Object[0]), (String)"var statements", (String)"var '_x+:[script( \"import com.intellij.lang.javascript.psi.JSVarStatement\ndef statement = (JSVarStatement)x.parent\nstatement.varKeyword == JSVarStatement.VarKeyword.VAR\" )];", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.functions.with.boolean.parameters", new Object[0]), (String)"functions with boolean parameters", (String)"function '_name('_before*, '_parameter:[exprtype( Boolean )], '_after*) {\n  '_statement*;\n}", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE), PredefinedConfigurationUtil.createLegacyConfiguration((String)JavaScriptBundle.message("structural.search.comparison.to.self", new Object[0]), (String)"comparison to self", (String)"'_expression === '_expression", (String)"JavaScript/Suspicious", (LanguageFileType)JavaScriptFileType.INSTANCE)};
        if (configurationArray == null) {
            JSStructuralSearchProfile.$$$reportNull$$$0(22);
        }
        return configurationArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 11, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JSStructuralSearchProfile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPredicates";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMatchNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPredicates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConstraint";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkSearchPattern";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isProbableExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 11, 22 -> new IllegalStateException(string);
        };
    }

    static class ValidatingVisitor
    extends JSRecursiveWalkingElementVisitor {
        ValidatingVisitor() {
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                ValidatingVisitor.$$$reportNull$$$0(0);
            }
            super.visitErrorElement(element);
            String errorDescription = element.getErrorDescription();
            throw new MalformedPatternException(errorDescription);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/JSStructuralSearchProfile$ValidatingVisitor", "visitErrorElement"));
        }
    }
}

