/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u0017\u0018\u0000 F2\u00020\u0001:\u0003DEFB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0004J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001aH\u0007J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0003J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0002J4\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0004J\u0018\u0010/\u001a\u00020*2\u0006\u0010'\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0004J\u0018\u00102\u001a\u00020*2\u0006\u0010'\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0004J6\u00103\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003050#\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003050#042\f\u00106\u001a\b\u0012\u0004\u0012\u00020\n07H\u0002J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\n072\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0003J\u000e\u0010:\u001a\u00020;2\u0006\u0010'\u001a\u00020\nJ\u000e\u0010<\u001a\u00020;2\u0006\u0010'\u001a\u00020\nJ\"\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020.0?H\u0002J0\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020.0?2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0002J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020\n072\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n07H\u0004J\b\u0010C\u001a\u00020;H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceDefaultCacheData;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "myUpdateFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "getMyUpdateFiles", "()Ljava/util/Map;", "myOpenedFilesByEvent", "", "getMyOpenedFilesByEvent", "()Ljava/util/Set;", "myExternalConfigs", "myVfsChangedFiles", "updateCacheAndGetServiceObject", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "input", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "refreshAndGetCloseEditorCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$ServiceObjectWithCacheUpdate;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "getConfigForFile", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "virtualFile", "refreshAndGetOpenEditorCommand", "getUpdateFilesServiceObject", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptLanguageServiceUpdateCommand;", "getConfigsForReload", "", "filesToOpen", "createOpenCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptOpenEditorCommand;", "file", "info", "text", "", "projectFileName", "", "timestamp", "", "getPreprocessedDocumentText", "document", "Lcom/intellij/openapi/editor/Document;", "getDocumentText", "getAndUpdateExternalConfigsCommand", "Lkotlin/Pair;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCommandWithArguments;", "actualExternalConfigs", "", "getNonStandardConfigsForFiles", "files", "removeVfsFile", "", "addVfsFile", "getFilesToOpen", "currentChangedFiles", "", "getFilesToChange", "getFilesToClose", "currentFiles", "dispose", "ServiceObjectWithCacheUpdate", "LastUpdateInfo", "Companion", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptLanguageServiceCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptLanguageServiceCache.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,495:1\n10072#2:496\n10494#2,2:497\n10496#2,3:503\n126#3:499\n153#3,3:500\n216#3,2:507\n1#4:506\n1#4:521\n1863#5,2:509\n1611#5,9:511\n1863#5:520\n1864#5:522\n1620#5:523\n865#5,2:524\n865#5,2:526\n*S KotlinDebug\n*F\n+ 1 TypeScriptLanguageServiceCache.kt\ncom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache\n*L\n77#1:496\n77#1:497,2\n77#1:503,3\n81#1:499\n81#1:500,3\n229#1:507,2\n336#1:521\n289#1:509,2\n336#1:511,9\n336#1:520\n336#1:522\n336#1:523\n393#1:524,2\n423#1:526,2\n*E\n"})
public class TypeScriptLanguageServiceCache
extends JSLanguageServiceDefaultCacheData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VirtualFile, LastUpdateInfo> myUpdateFiles;
    @NotNull
    private final Set<VirtualFile> myOpenedFilesByEvent;
    @NotNull
    private final Set<VirtualFile> myExternalConfigs;
    @NotNull
    private final Set<VirtualFile> myVfsChangedFiles;

    public TypeScriptLanguageServiceCache(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myUpdateFiles = new ConcurrentHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.myOpenedFilesByEvent = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.myExternalConfigs = set2;
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.myVfsChangedFiles = set3;
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    protected final Map<VirtualFile, LastUpdateInfo> getMyUpdateFiles() {
        return this.myUpdateFiles;
    }

    @NotNull
    protected final Set<VirtualFile> getMyOpenedFilesByEvent() {
        return this.myOpenedFilesByEvent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JSLanguageServiceCommand jSLanguageServiceCommand = input;
        if (jSLanguageServiceCommand instanceof TypeScriptLanguageServiceUpdateCommand) {
            object = TypeScriptLanguageServiceCache.computeInNonBlockingReadAction(() -> TypeScriptLanguageServiceCache.updateCacheAndGetServiceObject$lambda$0(this, input));
        } else if (jSLanguageServiceCommand instanceof TypeScriptCompositeCommand) {
            TypeScriptCompositeRequest typeScriptCompositeRequest;
            List list;
            void $this$flatMapTo$iv$iv;
            List $this$flatMap$iv;
            JSLanguageServiceCommand[] jSLanguageServiceCommandArray = ((TypeScriptCompositeCommand)input).getNestedCommands();
            Intrinsics.checkNotNullExpressionValue((Object)jSLanguageServiceCommandArray, (String)"getNestedCommands(...)");
            Object[] objectArray = jSLanguageServiceCommandArray;
            boolean $i$f$flatMap = false;
            void var6_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                List list2;
                JSLanguageServiceCommand command = (JSLanguageServiceCommand)element$iv$iv;
                boolean bl = false;
                JSLanguageServiceObject serviceObject = this.updateCacheAndGetServiceObject(command);
                if (serviceObject == null) {
                    list2 = CollectionsKt.emptyList();
                } else if (serviceObject instanceof TypeScriptCommandSetRequest) {
                    void $this$mapTo$iv$iv;
                    LinkedHashMap<JSLanguageServiceObject, JSLanguageServiceCommand> linkedHashMap = ((TypeScriptCommandSetRequest)serviceObject).nestedRequests;
                    Intrinsics.checkNotNullExpressionValue(linkedHashMap, (String)"nestedRequests");
                    Map $this$map$iv = linkedHashMap;
                    boolean $i$f$map = false;
                    Map map2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        JSLanguageServiceObject nestedServiceObject = (JSLanguageServiceObject)entry.getKey();
                        JSLanguageServiceCommand nestedCommand = (JSLanguageServiceCommand)entry.getValue();
                        Intrinsics.checkNotNull((Object)nestedCommand);
                        Intrinsics.checkNotNull((Object)nestedServiceObject);
                        collection.add(new JSLanguageServiceRequest(nestedCommand, nestedServiceObject, -1L, -1));
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = CollectionsKt.listOf((Object)new JSLanguageServiceRequest(command, serviceObject, -1L, -1));
                }
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List it = $this$flatMap$iv = (List)destination$iv$iv;
            boolean bl = false;
            List list3 = list = !((Collection)it).isEmpty() ? $this$flatMap$iv : null;
            if (list != null) {
                it = list;
                boolean bl3 = false;
                typeScriptCompositeRequest = new TypeScriptCompositeRequest(it);
            } else {
                typeScriptCompositeRequest = null;
            }
            object = typeScriptCompositeRequest;
        } else {
            VirtualFile file;
            JSLanguageServiceSimpleCommand jSLanguageServiceSimpleCommand;
            object = jSLanguageServiceCommand instanceof JSLanguageServiceSimpleCommand ? ((jSLanguageServiceSimpleCommand = (JSLanguageServiceSimpleCommand)input) instanceof TypeScriptOpenEditorCommand ? TypeScriptLanguageServiceCache.computeInNonBlockingReadAction(() -> TypeScriptLanguageServiceCache.updateCacheAndGetServiceObject$lambda$5(this, input)) : (jSLanguageServiceSimpleCommand instanceof TypeScriptCloseEditorCommand ? TypeScriptLanguageServiceCache.computeInNonBlockingReadAction(() -> TypeScriptLanguageServiceCache.updateCacheAndGetServiceObject$lambda$6(this, input)) : (jSLanguageServiceSimpleCommand instanceof TypeScriptReloadFileCommand ? (this.myOpenedFilesByEvent.contains(file = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file) ? null : ((TypeScriptReloadFileCommand)input).toSerializableObject()) : ((JSLanguageServiceSimpleCommand)input).toSerializableObject()))) : null;
        }
        return object;
    }

    @RequiresReadLock
    @NotNull
    public final ServiceObjectWithCacheUpdate refreshAndGetCloseEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile fileToClose = virtualFile;
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$7(this, fileToClose));
        if (!this.myUpdateFiles.containsKey(fileToClose)) {
            return new ServiceObjectWithCacheUpdate(null, (List<? extends Runnable>)cacheUpdates);
        }
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$8(this, fileToClose));
        TypeScriptConfig config = this.getConfigForFile(fileToClose);
        if (TypeScriptConfigUtil.isNonStandardName(config)) {
            TypeScriptConfig typeScriptConfig = config;
            Intrinsics.checkNotNull((Object)typeScriptConfig);
            if (this.myExternalConfigs.contains(typeScriptConfig.getConfigFile())) {
                VirtualFile virtualFile2 = config.getConfigFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getConfigFile(...)");
                VirtualFile configFile = virtualFile2;
                String name = JSLanguageServiceUtil.normalizeNameAndPath(configFile);
                if (name != null) {
                    HashSet openOrUpdatedFiles = new HashSet();
                    openOrUpdatedFiles.addAll(this.myUpdateFiles.keySet());
                    openOrUpdatedFiles.addAll(this.myOpenedFilesByEvent);
                    openOrUpdatedFiles.remove(fileToClose);
                    Set<VirtualFile> configs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
                    if (!configs.contains(configFile)) {
                        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetCloseEditorCommand$lambda$9(this, configFile));
                        Object[] objectArray = new TypeScriptCommandWithArguments[]{new TypeScriptCloseExternalProjectRequest(name), input};
                        TypeScriptCommandSetRequest object = new TypeScriptCommandSetRequest(CollectionsKt.listOf((Object[])objectArray));
                        return new ServiceObjectWithCacheUpdate(object, (List<? extends Runnable>)cacheUpdates);
                    }
                }
            }
        }
        return new ServiceObjectWithCacheUpdate(((TypeScriptCloseEditorCommand)input).toSerializableObject(), (List<? extends Runnable>)cacheUpdates);
    }

    @Nullable
    protected final TypeScriptConfig getConfigForFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return TypeScriptConfigUtil.getConfigForFile(this.myProject, virtualFile);
    }

    @RequiresReadLock
    @NotNull
    public final ServiceObjectWithCacheUpdate refreshAndGetOpenEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        TypeScriptOpenEditorCommand command = (TypeScriptOpenEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$10(this, file));
        if (this.myUpdateFiles.containsKey(file)) {
            return new ServiceObjectWithCacheUpdate(null, (List<? extends Runnable>)cacheUpdates);
        }
        String path2 = JSLanguageServiceUtil.normalizeNameAndPath(file);
        LastUpdateInfo info = new LastUpdateInfo(path2, command.getTimestamp(), command.getContentLength(), command.getLineCount(), command.getLastLineStartOffset());
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$11(this, file, info));
        TypeScriptConfig config = this.getConfigForFile(file);
        SmartList commands = new SmartList();
        if (this.myVfsChangedFiles.contains(file) || command.getContentLength() == 0L && System.currentTimeMillis() - file.getTimeStamp() < 2500L) {
            commands.add((Object)TypeScriptLanguageServiceCache.Companion.createReloadCommand(config));
            cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$12(this, file));
        }
        if (TypeScriptConfigUtil.isNonStandardName(config)) {
            TypeScriptConfig typeScriptConfig = config;
            Intrinsics.checkNotNull((Object)typeScriptConfig);
            VirtualFile virtualFile2 = typeScriptConfig.getConfigFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getConfigFile(...)");
            VirtualFile configFile = virtualFile2;
            String name = JSLanguageServiceUtil.normalizeNameAndPath(configFile);
            if (name != null) {
                ((TypeScriptFileWithConfigArgs)command.arguments).projectFileName = LocalFilePath.Companion.create(name);
                if (!this.myExternalConfigs.contains(config.getConfigFile())) {
                    cacheUpdates.add(() -> TypeScriptLanguageServiceCache.refreshAndGetOpenEditorCommand$lambda$13(this, configFile));
                    commands.add((Object)new TypeScriptOpenExternalProjectRequest(name));
                }
            }
        }
        commands.add((Object)input);
        return new ServiceObjectWithCacheUpdate(TypeScriptCommandSetRequest.createSet((List)commands), (List<? extends Runnable>)cacheUpdates);
    }

    @RequiresReadLock
    private final ServiceObjectWithCacheUpdate getUpdateFilesServiceObject(TypeScriptLanguageServiceUpdateCommand command) {
        Map<VirtualFile, Long> map2 = command.myChangedFilesToTimeStamp;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"myChangedFilesToTimeStamp");
        Map<VirtualFile, Long> currentChangedFiles = map2;
        Map<VirtualFile, Document> map3 = command.myUnsavedFilesContent;
        Intrinsics.checkNotNullExpressionValue(map3, (String)"myUnsavedFilesContent");
        Map<VirtualFile, Document> unsavedContents = map3;
        Set<VirtualFile> currentFiles = currentChangedFiles.keySet();
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentFiles);
        ArrayList<Runnable> cacheUpdates = new ArrayList<Runnable>();
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = new HashMap();
        List toOpen = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)filesToOpen), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$14(filesToClose, unsavedContents, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$15(unsavedContents, currentChangedFiles, this, toUpdateCache, arg_0)));
        ArrayList<TypeScriptCloseEditorCommand> toCloseByRename = new ArrayList<TypeScriptCloseEditorCommand>();
        ArrayList<TypeScriptOpenEditorCommand> toOpenByRename = new ArrayList<TypeScriptOpenEditorCommand>();
        Collection filesToCloseByRename = new HashSet();
        Collection configsToReload = new HashSet();
        Collection filesToOpenByRename = new HashSet();
        Map<VirtualFile, LastUpdateInfo> $this$forEach$iv = this.myUpdateFiles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, LastUpdateInfo>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, LastUpdateInfo> element$iv;
            Map.Entry<VirtualFile, LastUpdateInfo> entry = element$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = entry.getKey();
            LastUpdateInfo storedInfo = entry.getValue();
            Object object = CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$19$lambda$16);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            Map fileNameCache = (Map)object;
            String newPath = fileNameCache.computeIfAbsent(file, arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$19$lambda$18(TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$19$lambda$17, arg_0));
            String oldPath = storedInfo.getMyLastPath();
            if (newPath == null || Intrinsics.areEqual((Object)newPath, (Object)oldPath)) continue;
            toCloseByRename.add(TypeScriptLanguageServiceCache.Companion.createCloseCommand(file, oldPath));
            filesToCloseByRename.add(file);
            if (filesToOpen.contains(file) || filesToClose.contains(file)) continue;
            LastUpdateInfo updateInfo = (LastUpdateInfo)toUpdateCache.get(file);
            LastUpdateInfo lastUpdateInfo = updateInfo;
            if (lastUpdateInfo == null) {
                lastUpdateInfo = storedInfo;
            }
            LastUpdateInfo info = new LastUpdateInfo(lastUpdateInfo, newPath);
            Document document = unsavedContents.get(file);
            CharSequence text = document == null ? null : this.getPreprocessedDocumentText(file, document);
            TypeScriptConfig config = this.getConfigForFile(file);
            String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(config);
            toOpenByRename.add(this.createOpenCommand(file, info, text, projectFileName, info.getMyTimestamp()));
            ((Map)toUpdateCache).put(file, info);
            filesToOpenByRename.add(file);
            if (config == null) continue;
            configsToReload.add(config);
        }
        List toChange = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)changedFiles), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$20(filesToClose, filesToOpenByRename, arg_0)), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$21(this, unsavedContents, currentChangedFiles, toUpdateCache, arg_0)));
        Collection toClose = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)filesToClose), arg_0 -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$22(filesToCloseByRename, arg_0)), TypeScriptLanguageServiceCache::getUpdateFilesServiceObject$lambda$23));
        HashMap<VirtualFile, LastUpdateInfo> newUpdateFiles = new HashMap<VirtualFile, LastUpdateInfo>(this.myUpdateFiles);
        Iterable $this$forEach$iv2 = filesToClose;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            newUpdateFiles.remove(it);
        }
        newUpdateFiles.putAll(toUpdateCache);
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$25(this, newUpdateFiles));
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty() && toCloseByRename.isEmpty() && toOpenByRename.isEmpty()) {
            return new ServiceObjectWithCacheUpdate(null, (List<? extends Runnable>)cacheUpdates);
        }
        HashSet openOrUpdatedFiles = new HashSet(this.myOpenedFilesByEvent);
        openOrUpdatedFiles.addAll(newUpdateFiles.keySet());
        Set<VirtualFile> actualExternalConfigs = this.getNonStandardConfigsForFiles(openOrUpdatedFiles);
        Iterator iterator2 = this.getAndUpdateExternalConfigsCommand(actualExternalConfigs);
        Collection openExternal = (Collection)iterator2.component1();
        Collection closeExternal = (Collection)iterator2.component2();
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$26(this, actualExternalConfigs));
        ArrayList result2 = new ArrayList();
        configsToReload.addAll(this.getConfigsForReload(filesToOpen));
        cacheUpdates.add(() -> TypeScriptLanguageServiceCache.getUpdateFilesServiceObject$lambda$27(this, filesToOpen));
        TypeScriptLanguageServiceCache.Companion.addReloadCommands(configsToReload, result2);
        result2.addAll(openExternal);
        result2.addAll(toCloseByRename);
        result2.addAll(toOpen);
        result2.addAll(toOpenByRename);
        result2.addAll(toChange);
        result2.addAll(toClose);
        result2.addAll(closeExternal);
        return new ServiceObjectWithCacheUpdate(new TypeScriptCommandSetRequest(result2), (List<? extends Runnable>)cacheUpdates);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<TypeScriptConfig> getConfigsForReload(Collection<? extends VirtualFile> filesToOpen) {
        void $this$mapNotNullTo$iv$iv;
        HashSet vfsFiles = new HashSet(this.myVfsChangedFiles);
        Iterable $this$mapNotNull$iv = filesToOpen;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TypeScriptConfig it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile file = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((vfsFiles.contains(file) ? this.getConfigForFile(file) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected final TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file, @NotNull LastUpdateInfo info, @Nullable CharSequence text, @Nullable String projectFileName, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new TypeScriptOpenEditorCommand(file, timestamp, info.getMyContentLength(), info.getMyLineCount(), info.getMyLastLineStartOffset(), text, projectFileName);
    }

    @NotNull
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence text = this.getDocumentText(file, document);
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text, file);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"convertLineSeparatorsToFileOriginal(...)");
        return charSequence;
    }

    @NotNull
    protected final CharSequence getDocumentText(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        return charSequence;
    }

    private final Pair<Collection<TypeScriptCommandWithArguments<?>>, Collection<TypeScriptCommandWithArguments<?>>> getAndUpdateExternalConfigsCommand(Set<? extends VirtualFile> actualExternalConfigs) {
        Set toClose = new HashSet(this.myExternalConfigs);
        toClose.removeAll((Collection)actualExternalConfigs);
        Set toOpen = new HashSet(actualExternalConfigs);
        toOpen.removeAll((Collection)this.myExternalConfigs);
        return new Pair((Object)TypeScriptLanguageServiceCache.Companion.convertToCommands(toOpen, TypeScriptLanguageServiceCache::getAndUpdateExternalConfigsCommand$lambda$29), (Object)TypeScriptLanguageServiceCache.Companion.convertToCommands(toClose, TypeScriptLanguageServiceCache::getAndUpdateExternalConfigsCommand$lambda$30));
    }

    @RequiresReadLock
    private final Set<VirtualFile> getNonStandardConfigsForFiles(Collection<? extends VirtualFile> files) {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)files), arg_0 -> TypeScriptLanguageServiceCache.getNonStandardConfigsForFiles$lambda$31(this, arg_0)), TypeScriptLanguageServiceCache::getNonStandardConfigsForFiles$lambda$32), TypeScriptLanguageServiceCache::getNonStandardConfigsForFiles$lambda$33));
    }

    public final void removeVfsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myVfsChangedFiles.remove(file);
    }

    public final void addVfsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myVfsChangedFiles.add(file);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> getFilesToOpen(Map<VirtualFile, Long> currentChangedFiles) {
        void var3_3;
        void $this$filterTo$iv;
        Iterable iterable = currentChangedFiles.keySet();
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(!this.myUpdateFiles.containsKey(it))) continue;
            destination$iv.add(element$iv);
        }
        return var3_3;
    }

    private final Collection<VirtualFile> getFilesToChange(Map<VirtualFile, Long> currentChangedFiles, Collection<? extends VirtualFile> filesToOpen) {
        ArrayList<VirtualFile> realChangedFiles = new ArrayList<VirtualFile>();
        for (Map.Entry<VirtualFile, Long> entry : currentChangedFiles.entrySet()) {
            VirtualFile file = entry.getKey();
            long modified = ((Number)entry.getValue()).longValue();
            if (filesToOpen.contains(file)) continue;
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Incorrect cache");
                continue;
            }
            long timeStamp = lastUpdateInfo.getMyTimestamp();
            if (modified >= 0L && timeStamp != -1L && modified == timeStamp) continue;
            realChangedFiles.add(file);
        }
        return realChangedFiles;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<VirtualFile> getFilesToClose(@NotNull Set<? extends VirtualFile> currentFiles) {
        void var3_3;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(currentFiles, (String)"currentFiles");
        Iterable iterable = this.myUpdateFiles.keySet();
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(!currentFiles.contains(it) && !this.myOpenedFilesByEvent.contains(it))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var3_3;
    }

    @Override
    public void dispose() {
        this.clear();
        this.myExternalConfigs.clear();
        this.myOpenedFilesByEvent.clear();
        this.myUpdateFiles.clear();
    }

    private static final ServiceObjectWithCacheUpdate updateCacheAndGetServiceObject$lambda$0(TypeScriptLanguageServiceCache this$0, JSLanguageServiceCommand $input) {
        return this$0.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)$input);
    }

    private static final ServiceObjectWithCacheUpdate updateCacheAndGetServiceObject$lambda$5(TypeScriptLanguageServiceCache this$0, JSLanguageServiceCommand $input) {
        return this$0.refreshAndGetOpenEditorCommand((JSLanguageServiceSimpleCommand)$input);
    }

    private static final ServiceObjectWithCacheUpdate updateCacheAndGetServiceObject$lambda$6(TypeScriptLanguageServiceCache this$0, JSLanguageServiceCommand $input) {
        return this$0.refreshAndGetCloseEditorCommand((JSLanguageServiceSimpleCommand)$input);
    }

    private static final void refreshAndGetCloseEditorCommand$lambda$7(TypeScriptLanguageServiceCache this$0, VirtualFile $fileToClose) {
        this$0.myOpenedFilesByEvent.remove($fileToClose);
    }

    private static final void refreshAndGetCloseEditorCommand$lambda$8(TypeScriptLanguageServiceCache this$0, VirtualFile $fileToClose) {
        this$0.myUpdateFiles.remove($fileToClose);
    }

    private static final void refreshAndGetCloseEditorCommand$lambda$9(TypeScriptLanguageServiceCache this$0, VirtualFile $configFile) {
        this$0.myExternalConfigs.remove($configFile);
    }

    private static final void refreshAndGetOpenEditorCommand$lambda$10(TypeScriptLanguageServiceCache this$0, VirtualFile $file) {
        this$0.myOpenedFilesByEvent.add($file);
    }

    private static final void refreshAndGetOpenEditorCommand$lambda$11(TypeScriptLanguageServiceCache this$0, VirtualFile $file, LastUpdateInfo $info) {
        this$0.myUpdateFiles.put($file, $info);
    }

    private static final void refreshAndGetOpenEditorCommand$lambda$12(TypeScriptLanguageServiceCache this$0, VirtualFile $file) {
        this$0.myVfsChangedFiles.remove($file);
    }

    private static final void refreshAndGetOpenEditorCommand$lambda$13(TypeScriptLanguageServiceCache this$0, VirtualFile $configFile) {
        this$0.myExternalConfigs.add($configFile);
    }

    private static final boolean getUpdateFilesServiceObject$lambda$14(Set $filesToClose, Map $unsavedContents, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$filesToClose.contains(it) && $unsavedContents.containsKey(it);
    }

    private static final TypeScriptOpenEditorCommand getUpdateFilesServiceObject$lambda$15(Map $unsavedContents, Map $currentChangedFiles, TypeScriptLanguageServiceCache this$0, HashMap $toUpdateCache, VirtualFile el) {
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        Object v = $unsavedContents.get(el);
        Intrinsics.checkNotNull(v);
        Document document = (Document)v;
        Long timestampObject = (Long)$currentChangedFiles.get(el);
        CharSequence text = this$0.getPreprocessedDocumentText(el, document);
        Long l = timestampObject;
        long timestamp = l != null ? l : -1L;
        LastUpdateInfo value = TypeScriptLanguageServiceCache.Companion.createLastUpdateInfo(el, text, timestamp);
        ((Map)$toUpdateCache).put(el, value);
        PsiFile psiFile = file = PsiManager.getInstance((Project)this$0.myProject).findFile(el);
        String projectFileName = psiFile != null ? TypeScriptConfigUtil.getNonStandardProjectFileName(psiFile) : null;
        return this$0.createOpenCommand(el, value, text, projectFileName, timestamp);
    }

    private static final CachedValueProvider.Result getUpdateFilesServiceObject$lambda$19$lambda$16() {
        Object[] objectArray = new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS};
        return CachedValueProvider.Result.create((Object)CollectionFactory.createConcurrentWeakMap(), (Object[])objectArray);
    }

    private static final String getUpdateFilesServiceObject$lambda$19$lambda$17(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JSLanguageServiceUtil.normalizeNameAndPath(it);
    }

    private static final String getUpdateFilesServiceObject$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean getUpdateFilesServiceObject$lambda$20(Set $filesToClose, Collection $filesToOpenByRename, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$filesToClose.contains(it) && !$filesToOpenByRename.contains(it);
    }

    private static final TypeScriptChangeCommand getUpdateFilesServiceObject$lambda$21(TypeScriptLanguageServiceCache this$0, Map $unsavedContents, Map $currentChangedFiles, HashMap $toUpdateCache, VirtualFile el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        LastUpdateInfo lastUpdateInfo = this$0.myUpdateFiles.get(el);
        Intrinsics.checkNotNull((Object)lastUpdateInfo);
        LastUpdateInfo info = lastUpdateInfo;
        Object v = $unsavedContents.get(el);
        Intrinsics.checkNotNull(v);
        Document document = (Document)v;
        CharSequence text = this$0.getPreprocessedDocumentText(el, document);
        Object v2 = $currentChangedFiles.get(el);
        Intrinsics.checkNotNull(v2);
        long newTimestamp = ((Number)v2).longValue();
        LastUpdateInfo value = TypeScriptLanguageServiceCache.Companion.createLastUpdateInfo(el, text, newTimestamp);
        ((Map)$toUpdateCache).put(el, value);
        TypeScriptChangeRequestArgs typeScriptChangeRequestArgs = TypeScriptChangeRequestArgs.build(el, text, info.getMyContentLength(), info.getMyLineCount(), info.getMyLastLineStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptChangeRequestArgs, (String)"build(...)");
        TypeScriptChangeRequestArgs req = typeScriptChangeRequestArgs;
        return new TypeScriptChangeCommand(req);
    }

    private static final boolean getUpdateFilesServiceObject$lambda$22(Collection $filesToCloseByRename, VirtualFile el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        return !$filesToCloseByRename.contains(el);
    }

    private static final TypeScriptCloseEditorCommand getUpdateFilesServiceObject$lambda$23(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String filePath = JSLanguageServiceUtil.normalizeNameAndPath(it);
        return TypeScriptLanguageServiceCache.Companion.createCloseCommand(it, filePath);
    }

    private static final void getUpdateFilesServiceObject$lambda$25(TypeScriptLanguageServiceCache this$0, HashMap $newUpdateFiles) {
        this$0.myUpdateFiles.clear();
        this$0.myUpdateFiles.putAll($newUpdateFiles);
    }

    private static final void getUpdateFilesServiceObject$lambda$26(TypeScriptLanguageServiceCache this$0, Set $actualExternalConfigs) {
        this$0.myExternalConfigs.clear();
        this$0.myExternalConfigs.addAll($actualExternalConfigs);
    }

    private static final void getUpdateFilesServiceObject$lambda$27(TypeScriptLanguageServiceCache this$0, Collection $filesToOpen) {
        this$0.myVfsChangedFiles.removeAll(CollectionsKt.intersect((Iterable)$filesToOpen, (Iterable)this$0.myVfsChangedFiles));
    }

    private static final TypeScriptCommandWithArguments getAndUpdateExternalConfigsCommand$lambda$29(String projectFileName) {
        Intrinsics.checkNotNullParameter((Object)projectFileName, (String)"projectFileName");
        return new TypeScriptOpenExternalProjectRequest(projectFileName);
    }

    private static final TypeScriptCommandWithArguments getAndUpdateExternalConfigsCommand$lambda$30(String projectFileName) {
        Intrinsics.checkNotNullParameter((Object)projectFileName, (String)"projectFileName");
        return new TypeScriptCloseExternalProjectRequest(projectFileName);
    }

    private static final TypeScriptConfig getNonStandardConfigsForFiles$lambda$31(TypeScriptLanguageServiceCache this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getConfigForFile(it);
    }

    private static final boolean getNonStandardConfigsForFiles$lambda$32(TypeScriptConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeScriptConfigUtil.isNonStandardName(it);
    }

    private static final VirtualFile getNonStandardConfigsForFiles$lambda$33(TypeScriptConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getConfigFile();
    }

    @JvmStatic
    @Nullable
    protected static final JSLanguageServiceObject computeInNonBlockingReadAction(@NotNull Supplier<ServiceObjectWithCacheUpdate> action) {
        return Companion.computeInNonBlockingReadAction(action);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0005J(\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100 H\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010!H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$Companion;", "", "<init>", "()V", "computeInNonBlockingReadAction", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "action", "Ljava/util/function/Supplier;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$ServiceObjectWithCacheUpdate;", "addReloadCommands", "", "configsToReload", "", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "result", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCommandWithArguments;", "createReloadCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptReloadProjectsCommand;", "config", "createLastUpdateInfo", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "el", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "newTimestamp", "", "convertToCommands", "", "toOpen", "factory", "Lkotlin/Function1;", "", "createCloseCommand", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCloseEditorCommand;", "path", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        protected final JSLanguageServiceObject computeInNonBlockingReadAction(@NotNull Supplier<ServiceObjectWithCacheUpdate> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            try {
                ServiceObjectWithCacheUpdate update2 = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(action);
                if (update2 == null) {
                    return null;
                }
                return update2.executeUpdates();
            }
            catch (ProcessCanceledException e) {
                return null;
            }
        }

        private final void addReloadCommands(Collection<? extends TypeScriptConfig> configsToReload, List<TypeScriptCommandWithArguments<?>> result2) {
            for (TypeScriptConfig typeScriptConfig : configsToReload) {
                result2.add(this.createReloadCommand(typeScriptConfig));
            }
        }

        private final TypeScriptReloadProjectsCommand createReloadCommand(TypeScriptConfig config) {
            TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
            TypeScriptConfig typeScriptConfig = config;
            args.projectFileName = typeScriptConfig != null ? LocalFilePath.Companion.create(TypeScriptConfigUtil.getConfigProjectFileName(typeScriptConfig)) : null;
            return new TypeScriptReloadProjectsCommand(args);
        }

        private final LastUpdateInfo createLastUpdateInfo(VirtualFile el, CharSequence text, long newTimestamp) {
            int lineCount = TypeScriptServerServiceImpl.Companion.getLineCountForText(text);
            int lastLineStartOffset = TypeScriptServerServiceImpl.Companion.getLastLineStartOffsetFromText(text, lineCount);
            int newContentLength = text.length();
            String path2 = JSLanguageServiceUtil.normalizeNameAndPath(el);
            return new LastUpdateInfo(path2, newTimestamp, newContentLength, lineCount, lastLineStartOffset);
        }

        private final Set<TypeScriptCommandWithArguments<?>> convertToCommands(Set<? extends VirtualFile> toOpen, Function1<? super String, ? extends TypeScriptCommandWithArguments<?>> factory) {
            return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)toOpen), Companion::convertToCommands$lambda$0), arg_0 -> Companion.convertToCommands$lambda$1(factory, arg_0)));
        }

        private final TypeScriptCloseEditorCommand createCloseCommand(VirtualFile el, String path2) {
            TypeScriptFileObject object = new TypeScriptFileObject();
            object.file = LocalFilePath.Companion.create(path2);
            return new TypeScriptCloseEditorCommand(object, el);
        }

        private static final String convertToCommands$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return JSLanguageServiceUtil.normalizeNameAndPath(it);
        }

        private static final TypeScriptCommandWithArguments convertToCommands$lambda$1(Function1 $factory, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (TypeScriptCommandWithArguments)$factory.invoke((Object)it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B3\b\u0010\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0005\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;", "", "toCopy", "newPath", "", "<init>", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo;Ljava/lang/String;)V", "path", "timestamp", "", "contentLength", "lineCount", "", "lastLineStartOffset", "(Ljava/lang/String;JJII)V", "myTimestamp", "getMyTimestamp", "()J", "myContentLength", "getMyContentLength", "myLineCount", "getMyLineCount", "()I", "myLastLineStartOffset", "getMyLastLineStartOffset", "myLastPath", "getMyLastPath", "()Ljava/lang/String;", "intellij.javascript.impl"})
    public static final class LastUpdateInfo {
        private final long myTimestamp;
        private final long myContentLength;
        private final int myLineCount;
        private final int myLastLineStartOffset;
        @Nullable
        private final String myLastPath;

        public final long getMyTimestamp() {
            return this.myTimestamp;
        }

        public final long getMyContentLength() {
            return this.myContentLength;
        }

        public final int getMyLineCount() {
            return this.myLineCount;
        }

        public final int getMyLastLineStartOffset() {
            return this.myLastLineStartOffset;
        }

        @Nullable
        public final String getMyLastPath() {
            return this.myLastPath;
        }

        public LastUpdateInfo(@NotNull LastUpdateInfo toCopy, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)toCopy, (String)"toCopy");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            this.myTimestamp = toCopy.myTimestamp;
            this.myContentLength = toCopy.myContentLength;
            this.myLineCount = toCopy.myLineCount;
            this.myLastLineStartOffset = toCopy.myLastLineStartOffset;
            this.myLastPath = newPath;
        }

        public LastUpdateInfo(@Nullable String path2, long timestamp, long contentLength, int lineCount, int lastLineStartOffset) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
            this.myLastPath = path2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$ServiceObjectWithCacheUpdate;", "", "myObject", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "myUpdates", "", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;Ljava/util/List;)V", "executeUpdates", "intellij.javascript.impl"})
    public static final class ServiceObjectWithCacheUpdate {
        @Nullable
        private final JSLanguageServiceObject myObject;
        @NotNull
        private final List<Runnable> myUpdates;

        public ServiceObjectWithCacheUpdate(@Nullable JSLanguageServiceObject myObject, @NotNull List<? extends Runnable> myUpdates) {
            Intrinsics.checkNotNullParameter(myUpdates, (String)"myUpdates");
            this.myObject = myObject;
            this.myUpdates = myUpdates;
        }

        @Nullable
        public final JSLanguageServiceObject executeUpdates() {
            for (Runnable update2 : this.myUpdates) {
                update2.run();
            }
            return this.myObject;
        }
    }
}

