/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class MarkerPsiElementPointer {
    private final PsiFile containingFile;
    private final RangeMarker marker;
    private final Class contextClass;

    public MarkerPsiElementPointer(@NotNull PsiElement context2) {
        if (context2 == null) {
            MarkerPsiElementPointer.$$$reportNull$$$0(0);
        }
        this.containingFile = context2.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)context2.getProject()).getDocument(this.containingFile);
        this.marker = document.createRangeMarker(context2.getTextRange());
        this.contextClass = context2.getClass();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement elementAt;
        PsiElement parent;
        assert (this.containingFile.isValid());
        int offset = this.marker.getStartOffset();
        if (offset >= this.containingFile.getTextLength()) {
            offset = this.containingFile.getTextLength() - 1;
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)(elementAt = this.containingFile.getViewProvider().findElementAt(offset)), (Class)this.contextClass, (boolean)false)) == null) {
            throw new IllegalStateException("lost parent of type " + this.contextClass + " at offset " + offset);
        }
        PsiElement psiElement = parent;
        if (psiElement == null) {
            MarkerPsiElementPointer.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/MarkerPsiElementPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/MarkerPsiElementPointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

