/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSConvertToClassProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassDataProcessor;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemToClassConvertor {
    public final Comparator<PsiElement> COMPARATOR;
    @NotNull
    private final JSItemToClassDataProcessor myDataConvertor;
    private JSFunction myLastAdded;
    private ES6Class myClazz;
    private JSFunction myConstructor;

    public JSItemToClassConvertor(@NotNull JSItemToClassDataProcessor dataConvertor) {
        if (dataConvertor == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(0);
        }
        this.myDataConvertor = dataConvertor;
        this.COMPARATOR = (o1, o2) -> {
            if (this.myDataConvertor.getFilePlace().containsKey(o1)) {
                o1 = this.myDataConvertor.getFilePlace().get(o1);
            }
            if (this.myDataConvertor.getFilePlace().containsKey(o2)) {
                o2 = this.myDataConvertor.getFilePlace().get(o2);
            }
            if (o1 == null || o2 == null) {
                return -1;
            }
            if (o1.getContainingFile().isPhysical() && o2.getContainingFile().isPhysical() && !o1.getContainingFile().equals(o2.getContainingFile())) {
                return o1.getContainingFile().getVirtualFile().getUrl().compareTo(o2.getContainingFile().getVirtualFile().getUrl());
            }
            return Integer.compare(o1.getTextRange().getStartOffset(), o2.getTextRange().getStartOffset());
        };
    }

    @NotNull
    public List<UsageInfo> process(List<PsiElement> selectedUsages) {
        this.myDataConvertor.convertToStaticDeclarationsAndSuperCalls();
        List<UsageInfo> list = this.generate(selectedUsages);
        if (list == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<UsageInfo> generate(List<PsiElement> selectedUsages) {
        this.myDataConvertor.extractFunctionDeclarationsFromConstructorBlock();
        this.myDataConvertor.filterDuplicatesAndNotSelected(selectedUsages);
        this.createClassWithConstructor(this.myDataConvertor.getConstructorFunction().getFunction());
        for (JSAssignmentExpression declaration : this.orderDeclarations(this.myDataConvertor.getMemberDeclarations().values())) {
            this.addDefinition(declaration, false);
        }
        Map<String, Pair<JSFunction, JSFunction>> declarations = this.myDataConvertor.getMemberPropertyDeclarations();
        ArrayList<JSFunction> gettersSetters = new ArrayList<JSFunction>();
        for (Pair<JSFunction, JSFunction> pair : declarations.values()) {
            if (pair.getFirst() != null) {
                gettersSetters.add((JSFunction)pair.getFirst());
            }
            if (pair.getSecond() == null) continue;
            gettersSetters.add((JSFunction)pair.getSecond());
        }
        for (Iterator<JSAssignmentExpression> function : this.orderDeclarations(gettersSetters)) {
            this.addGetterSetter((PsiElement)function);
        }
        Map<String, JSObjectLiteralExpression> memberProps = this.myDataConvertor.getMemberProps();
        for (String string : this.sortPropertiesKeys(memberProps)) {
            this.addProperty(string, memberProps.get(string), false);
        }
        for (JSAssignmentExpression jSAssignmentExpression : this.orderDeclarations(this.myDataConvertor.getStaticDeclarations().values())) {
            if (jSAssignmentExpression.getDefinitionExpression() != null && jSAssignmentExpression.getDefinitionExpression().getInitializer() instanceof JSFunction) {
                this.addDefinition(jSAssignmentExpression, true);
                continue;
            }
            this.myDataConvertor.getConversionResults().notConvertedStatic(new UsageInfo((PsiElement)jSAssignmentExpression));
        }
        Map<String, JSObjectLiteralExpression> staticProps = this.myDataConvertor.getStaticProps();
        for (String key : this.sortPropertiesKeys(staticProps)) {
            this.addProperty(key, staticProps.get(key), true);
        }
        this.removeOld();
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>(this.myDataConvertor.getConversionResults().getNotConvertedUsages());
        Map<String, JSItemToClassDataProcessor> convertors = this.myDataConvertor.getChildConvertors();
        Map children = ContainerUtil.map2Map(convertors.keySet(), s -> Pair.create((Object)s, (Object)new JSItemToClassConvertor((JSItemToClassDataProcessor)convertors.get(s))));
        for (String key : this.sortChildConvertors(children)) {
            JSItemToClassConvertor convertor = (JSItemToClassConvertor)children.get(key);
            arrayList.addAll(convertor.generate(selectedUsages));
            convertor.myDataConvertor.getParentAssignment().getDefinitionExpression().getInitializer().replace(convertor.getClazz());
        }
        ArrayList<UsageInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(2);
        }
        return arrayList2;
    }

    private void removeOld() {
        for (JSExpression expression : this.myDataConvertor.getRemoveOld()) {
            JSConvertToClassProcessor.removeExpression(null, expression);
        }
    }

    private List<String> sortChildConvertors(@NotNull Map<String, JSItemToClassConvertor> convertors) {
        if (convertors == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(3);
        }
        ArrayList<String> list = new ArrayList<String>(convertors.keySet());
        list.sort((o1, o2) -> {
            JSItemToClassConvertor convertor1 = (JSItemToClassConvertor)convertors.get(o1);
            JSItemToClassConvertor convertor2 = (JSItemToClassConvertor)convertors.get(o2);
            assert (convertor1 != null);
            assert (convertor2 != null);
            return this.COMPARATOR.compare(convertor1.myDataConvertor.getConstructorFunction().getFunction(), convertor2.myDataConvertor.getConstructorFunction().getFunction());
        });
        return list;
    }

    private List<String> sortPropertiesKeys(@NotNull Map<String, JSObjectLiteralExpression> map2) {
        if (map2 == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(4);
        }
        ArrayList<String> list = new ArrayList<String>(map2.keySet());
        list.sort((o1, o2) -> {
            JSObjectLiteralExpression el1 = (JSObjectLiteralExpression)map2.get(o1);
            JSObjectLiteralExpression el2 = (JSObjectLiteralExpression)map2.get(o2);
            assert (el1 != null);
            assert (el2 != null);
            return this.COMPARATOR.compare((PsiElement)el1, (PsiElement)el2);
        });
        return list;
    }

    private void addProperty(String key, @NotNull JSObjectLiteralExpression value, boolean isStatic) {
        Pair<FunctionInfo, FunctionInfo> pair;
        if (value == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(5);
        }
        if ((pair = JSItemToClassConvertor.getGetSet(value)) == null) {
            Boolean writable = JSItemToClassConvertor.getBooleanValue(value.findProperty("writable"));
            JSProperty valueProperty = value.findProperty("value");
            String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myClazz).FIELD_PREFIX + key;
            String getterBlockText = new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myClazz, innerName).setQualifier("this").generate();
            JSFunction getter = JSFunctionsRefactoringUtil.createAccessorInClassFromText(this.myClazz, JSGetterSetterGenerationMode.Getter, key, isStatic, getterBlockText, false);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter(getter, this.myLastAdded);
            if (!Boolean.FALSE.equals(writable)) {
                String setterBlockText = new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myClazz, innerName).setter().setQualifier("this").generate();
                JSFunction setter = JSFunctionsRefactoringUtil.createAccessorInClassFromText(this.myClazz, JSGetterSetterGenerationMode.Setter, key, isStatic, setterBlockText, true);
                this.myLastAdded = (JSFunction)this.myClazz.addAfter(setter, this.myLastAdded);
            }
            if (valueProperty != null && valueProperty.getValue() != null) {
                JSItemToClassConvertor.addPropertyAssignment(this.myConstructor, innerName, valueProperty.getValue().getText());
            }
        } else {
            if (pair.getFirst() != null) {
                JSFunction getter = JSFunctionsRefactoringUtil.createGetter((PsiElement)value, ((FunctionInfo)pair.getFirst()).getFunction(), key, isStatic);
                this.addDefinition(getter, ((FunctionInfo)pair.getFirst()).getComment());
            }
            if (pair.getSecond() != null) {
                JSFunction setter = JSFunctionsRefactoringUtil.createSetter((PsiElement)value, ((FunctionInfo)pair.getSecond()).getFunction(), key, isStatic);
                this.addDefinition(setter, ((FunctionInfo)pair.getSecond()).getComment());
            }
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)value, JSCallExpression.class);
        if (call != null) {
            JSConvertToClassProcessor.removeExpression(key, call);
        }
    }

    private static PsiElement addLastStatementToConstructor(@NotNull PsiElement constructor, @NotNull PsiElement newElement) {
        JSBlockStatement constructorBlock;
        if (constructor == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(6);
        }
        if (newElement == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(7);
        }
        if ((constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)constructor, JSBlockStatement.class)) != null) {
            JSSourceElement[] elements = (JSSourceElement[])PsiTreeUtil.getChildrenOfType((PsiElement)constructorBlock, JSSourceElement.class);
            Object anchor = elements != null && elements.length > 0 ? elements[elements.length - 1] : constructorBlock.getFirstChild();
            return constructorBlock.addAfter(newElement, (PsiElement)anchor);
        }
        return null;
    }

    static PsiElement addPropertyAssignment(@NotNull PsiElement constructor, @NotNull String innerName, @NotNull String valueText) {
        JSStatement statement;
        JSExpressionStatement createdStatement;
        if (constructor == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(8);
        }
        if (innerName == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(9);
        }
        if (valueText == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(10);
        }
        if ((createdStatement = (JSExpressionStatement)JSItemToClassConvertor.addLastStatementToConstructor(constructor, (PsiElement)(statement = JSPsiElementFactory.createJSStatement("this." + innerName + "=" + valueText + ";", constructor)))) == null) {
            return null;
        }
        JSExpression expression = createdStatement.getExpression();
        assert (expression instanceof JSAssignmentExpression && ((JSAssignmentExpression)expression).getDefinitionExpression() != null);
        return ((JSAssignmentExpression)expression).getDefinitionExpression();
    }

    private void addDefinition(JSFunction getter, PsiComment comment) {
        this.myLastAdded = (JSFunction)this.myClazz.addAfter(getter, this.myLastAdded);
        JSDocumentationUtils.moveJSDoc(comment, this.myLastAdded);
    }

    private static Boolean getBooleanValue(@Nullable JSProperty property) {
        if (property != null && property.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)property.getValue()).isBooleanLiteral()) {
            return (Boolean)((JSLiteralExpression)property.getValue()).getValue();
        }
        return null;
    }

    private static JSFunction getFunctionValue(@Nullable JSProperty property) {
        if (property instanceof JSFunctionProperty) {
            return (JSFunction)((Object)property);
        }
        return property != null && property.getValue() instanceof JSFunction ? (JSFunction)((Object)property.getValue()) : null;
    }

    @Nullable
    private static Pair<FunctionInfo, FunctionInfo> getGetSet(JSObjectLiteralExpression object) {
        JSProperty[] properties = object.getProperties();
        JSFunction get = null;
        JSFunction set = null;
        PsiComment getComment = null;
        PsiComment setComment = null;
        for (JSProperty property : properties) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)property);
            if ("get".equals(property.getName())) {
                get = JSItemToClassConvertor.getFunctionValue(property);
                getComment = docComment;
                continue;
            }
            if ("set".equals(property.getName())) {
                set = JSItemToClassConvertor.getFunctionValue(property);
                setComment = docComment;
                continue;
            }
            return null;
        }
        if (get == null && set == null) {
            return null;
        }
        return Pair.create((Object)(get == null ? null : new FunctionInfo(get, getComment)), (Object)(set == null ? null : new FunctionInfo(set, setComment)));
    }

    private <T extends JSElement> List<T> orderDeclarations(Collection<T> set) {
        ArrayList<T> result2 = new ArrayList<T>(set);
        result2.sort(this.COMPARATOR);
        return result2;
    }

    private void createClassWithConstructor(@NotNull JSFunction function) {
        if (function == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(11);
        }
        Project project = function.getProject();
        String extendsClause = this.myDataConvertor.createExtendsClause();
        if (this.myDataConvertor.getParentAssignment() != null) {
            JSVarStatement statement = JSPsiElementFactory.createJSStatement("var a = class" + extendsClause + "{};", function, JSVarStatement.class);
            JSExpression initializer = statement.getVariables()[0].getInitializer();
            assert (initializer instanceof ES6Class);
            this.myClazz = (ES6Class)((Object)initializer);
        } else {
            String exported = function.isExported() ? "export " : "";
            JSElement dummy = JSChangeUtil.createJSContentFromText(project, exported + "class " + this.myDataConvertor.getConstructorFunction().getFunctionName() + extendsClause + "{}", JavaScriptSupportLoader.ECMA_SCRIPT_6);
            assert (dummy.getFirstChild() instanceof ES6Class);
            this.myClazz = (ES6Class)dummy.getFirstChild();
        }
        String constructorTemplateText = JSClassUtils.createConstructorSignatureForClass(this.myClazz, true) + "() {}";
        this.myConstructor = (JSFunction)JSChangeUtil.createClassMemberFromText(project, constructorTemplateText, JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
        assert (this.myConstructor.getParameterList() != null);
        if (function.getParameterList() != null) {
            JSFunctionsRefactoringUtil.copyParameters(function, this.myConstructor);
        }
        JSFunctionsRefactoringUtil.copyFunctionBody(function, this.myConstructor);
        ASTNode possibleAnchor = this.myClazz.getNode().findChildByType(JSTokenTypes.LBRACE);
        assert (possibleAnchor != null);
        this.myLastAdded = this.myConstructor = (JSFunction)this.myClazz.addAfter(this.myConstructor, possibleAnchor.getPsi());
        JSItemToClassConvertor.moveJSDoc(function, this.myConstructor, true);
    }

    private void addDefinition(JSAssignmentExpression assignment, boolean isStatic) {
        Project project = assignment.getProject();
        JSExpression expression = assignment.getDefinitionExpression().getExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return;
        }
        String newName = ((JSReferenceExpression)expression).getReferenceName();
        JSExpression initializer = assignment.getDefinitionExpression().getInitializer();
        if (initializer instanceof JSFunctionExpression) {
            JSFunction method = (JSFunction)JSChangeUtil.createClassMemberFromText(project, (isStatic ? "static " : "") + newName + "() {}", JavaScriptSupportLoader.ECMA_SCRIPT_6).getPsi(JSFunction.class);
            JSParameterList parameters = ((JSFunctionExpression)initializer).getParameterList();
            if (parameters != null) {
                JSFunctionsRefactoringUtil.copyParameters((JSFunctionExpression)initializer, method);
            }
            JSFunctionsRefactoringUtil.copyFunctionBody((JSFunction)((Object)initializer), method);
            this.myLastAdded = (JSFunction)this.myClazz.addAfter(method, this.myLastAdded);
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), this.myLastAdded, false);
        } else {
            JSExpressionStatement statement = JSPsiElementFactory.createJSStatement("this." + newName + "=1;", (PsiElement)assignment, JSExpressionStatement.class);
            assert (statement.getExpression() instanceof JSAssignmentExpression);
            JSAssignmentExpression newAssignment = (JSAssignmentExpression)statement.getExpression();
            newAssignment.getDefinitionExpression().getInitializer().replace(initializer.copy());
            statement = (JSExpressionStatement)JSItemToClassConvertor.addLastStatementToConstructor(this.myConstructor, (PsiElement)statement);
            JSItemToClassConvertor.moveJSDoc(assignment.getParent(), statement, false);
        }
        JSItemToClassConvertor.deleteMovedDeclaration((PsiElement)assignment);
    }

    private void addGetterSetter(@NotNull PsiElement method) {
        if (method == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(12);
        }
        this.myLastAdded = (JSFunction)this.myClazz.addAfter(method, this.myLastAdded);
        JSItemToClassConvertor.moveJSDoc(method, this.myLastAdded, false);
    }

    static void moveJSDoc(@NotNull PsiElement oldElement, @NotNull JSElement newElement, boolean onlyJSDoc) {
        if (oldElement == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(13);
        }
        if (newElement == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(14);
        }
        if (!onlyJSDoc) {
            JSSourceElement sourceElement = JSItemToClassConvertor.getSourceElement(oldElement);
            JSSourceElement newSourceElement = JSItemToClassConvertor.getSourceElement((PsiElement)newElement);
            if (sourceElement != null && newSourceElement != null) {
                CommentsMover mover = new CommentsMover(sourceElement);
                Set<JSSourceElement> set = Set.of(newSourceElement);
                mover.move(set, set);
                return;
            }
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(oldElement);
        if (!onlyJSDoc || docComment instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)newElement);
        }
    }

    private static JSSourceElement getSourceElement(@NotNull PsiElement oldElement) {
        if (oldElement == null) {
            JSItemToClassConvertor.$$$reportNull$$$0(15);
        }
        return oldElement instanceof JSSourceElement ? (JSSourceElement)oldElement : (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)oldElement, JSSourceElement.class);
    }

    static PsiElement deleteMovedDeclaration(PsiElement assignment) {
        PsiElement parent = assignment.getParent();
        if (parent instanceof JSStatement) {
            parent.getParent().deleteChildRange(parent, parent);
            return parent.getParent();
        }
        parent.deleteChildRange(assignment, assignment);
        return parent;
    }

    public ES6Class getClazz() {
        return this.myClazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataConvertor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSItemToClassConvertor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sortChildConvertors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortPropertiesKeys";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLastStatementToConstructor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyAssignment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createClassWithConstructor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGetterSetter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveJSDoc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class FunctionInfo {
        private final JSFunction myFunction;
        private final PsiComment myComment;

        FunctionInfo(JSFunction function, PsiComment comment) {
            this.myFunction = function;
            this.myComment = comment;
        }

        public JSFunction getFunction() {
            return this.myFunction;
        }

        public PsiComment getComment() {
            return this.myComment;
        }
    }
}

