/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.text.CharacterIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTemplateLiteralJSTypeImpl
extends JSTypeBaseImpl
implements JSTemplateLiteralType,
JSEvaluableType {
    private static final Logger LOG = Logger.getInstance(TypeScriptTemplateLiteralJSTypeImpl.class);
    public static final List<String> EMPTY_TEXTS = List.of("", "");
    @NotNull
    private final List<String> myTexts;
    @NotNull
    private final List<JSType> myTypes;
    private final boolean myAllowWidening;

    @NotNull
    public static JSType createType(@NotNull List<String> texts, @NotNull List<JSType> types, boolean allowWidening, @NotNull JSTypeSource source) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(2);
        }
        return TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types, allowWidening, source, false);
    }

    @NotNull
    private static JSType createType(@NotNull List<String> texts, @NotNull List<JSType> types, boolean allowWidening, @NotNull JSTypeSource source, boolean strict) {
        JSType primitive;
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(5);
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("createType", texts, types, source);
        }
        if ((primitive = TypeScriptTemplateLiteralJSTypeImpl.replaceWithPrimitiveIfPossible(texts, types, allowWidening, source)) != null) {
            JSType jSType = primitive;
            if (jSType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        texts = TypeScriptTemplateLiteralJSTypeImpl.normalizeTexts(texts, types);
        boolean couldBeEffectivelyInlined = false;
        for (JSType type : types) {
            if (type instanceof TypeScriptNeverType) {
                TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
                if (typeScriptNeverType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(7);
                }
                return typeScriptNeverType;
            }
            if (!(type instanceof JSPrimitiveLiteralType) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSTemplateLiteralType)) continue;
            couldBeEffectivelyInlined = true;
        }
        if (couldBeEffectivelyInlined) {
            return TypeScriptTemplateLiteralJSTypeImpl.createInlinedTemplateLiteral(texts, types, allowWidening, source, strict);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(texts, types, allowWidening, source);
    }

    @NotNull
    private static List<String> normalizeTexts(@NotNull List<String> texts, @NotNull List<JSType> types) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(8);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(9);
        }
        if (texts.size() == types.size() && !texts.isEmpty()) {
            if (texts.size() == 1 && texts.get(0).isEmpty()) {
                List<String> list = EMPTY_TEXTS;
                if (list == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(10);
                }
                return list;
            }
            ArrayList<String> newTexts = new ArrayList<String>(texts.size() + 1);
            newTexts.addAll(texts);
            newTexts.add("");
            ArrayList<String> arrayList = newTexts;
            if (arrayList == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        List<String> list = texts;
        if (list == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static boolean checkTypeInvariant(@NotNull List<String> texts, @NotNull List<JSType> types, @NotNull JSTypeSource source) {
        boolean isConsistent;
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(14);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(15);
        }
        boolean bl = isConsistent = texts.size() - 1 == types.size() && !types.isEmpty();
        if (!isConsistent && LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("invariant violated", texts, types, source);
        }
        return isConsistent;
    }

    private static void traceTemplateTypeOperation(@NotNull String tag, @NotNull List<String> texts, @NotNull List<JSType> types, @NotNull JSTypeSource source) {
        if (tag == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(18);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(19);
        }
        if (!LOG.isTraceEnabled()) {
            return;
        }
        PsiElement element = source.getSourceElement();
        if (element != null && element.isValid()) {
            String sourceText = element.getText();
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            String path2 = file != null ? file.getPath() : "null";
            String textsString = StringUtil.join(texts, t -> StringUtil.wrapWithDoubleQuote((String)t), (String)", ");
            LOG.trace(String.format("%s: texts=[%s], types=%s, sourceElement=%s, path=%s", tag, textsString, types, sourceText, path2));
        }
    }

    @Nullable
    private static JSType replaceWithPrimitiveIfPossible(@NotNull List<String> texts, @NotNull List<JSType> types, boolean allowWidening, @NotNull JSTypeSource source) {
        JSType type;
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(20);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(21);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (texts.isEmpty()) {
            return new JSStringLiteralTypeImpl("", allowWidening, source);
        }
        if (types.isEmpty()) {
            return new JSStringLiteralTypeImpl((String)ContainerUtil.getFirstItem(texts, (Object)""), allowWidening, source);
        }
        if (texts.size() <= 2 && ContainerUtil.all(texts, text -> text.isEmpty()) && types.size() == 1 && (type = types.get(0)) instanceof JSStringType && !(type instanceof JSPrimitiveLiteralType)) {
            return type;
        }
        return null;
    }

    private TypeScriptTemplateLiteralJSTypeImpl(@NotNull List<String> texts, @NotNull List<JSType> types, boolean allowWidening, @NotNull JSTypeSource source) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(24);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(25);
        }
        super(source);
        this.myTexts = texts;
        this.myTypes = types;
        this.myAllowWidening = allowWidening;
    }

    TypeScriptTemplateLiteralJSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(26);
        }
        if (inputStream == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(27);
        }
        super(source);
        this.myTexts = JSTypeSerializer.STRING_LIST.read(source, inputStream);
        this.myTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(28);
        }
        super.serialize(outputStream);
        JSTypeSerializer.STRING_LIST.write(this.myTexts, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myTypes, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public JSType widen(boolean allowResolve) {
        JSTypeBaseImpl jSTypeBaseImpl = this.allowWidening() ? JSNamedTypeFactory.createStringPrimitiveType(this.getSource()) : this;
        if (jSTypeBaseImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(29);
        }
        return jSTypeBaseImpl;
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSType copyWithAllowWidening(boolean allowWidening) {
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public List<String> getTexts() {
        List<String> list = this.myTexts;
        if (list == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Override
    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list = this.myTypes;
        if (list == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        List types;
        if (childTransform == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(32);
        }
        if (newSource == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(33);
        }
        return ContainerUtil.equalsIdentity(this.myTypes, (List)(types = ContainerUtil.map(this.myTypes, type -> JSTypeUtils.transformTypeHierarchySafe(type, childTransform)))) ? this : TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, types, this.myAllowWidening, newSource);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(34);
        }
        return new TypeScriptTemplateLiteralJSTypeImpl(this.myTexts, this.myTypes, this.myAllowWidening, source);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(35);
        }
        TypeScriptTemplateLiteralJSTypeImpl literalType = (TypeScriptTemplateLiteralJSTypeImpl)type;
        if (this.myTypes.size() != literalType.getTypes().size() || this.myTexts.size() != literalType.getTexts().size()) {
            return false;
        }
        if (!JSTypeCastUtil.areListsEquivalent(this.myTypes, literalType.getTypes(), context2, allowResolve)) {
            return false;
        }
        return this.myTexts.equals(literalType.getTexts());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(36);
        }
        if (builder2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(37);
        }
        builder2.append("`");
        builder2.append((String)ContainerUtil.getFirstItem(this.myTexts, (Object)""));
        for (int i = 0; i < this.myTypes.size(); ++i) {
            builder2.append("${");
            JSType type = this.myTypes.get(i);
            builder2.append(type, format);
            builder2.append("}");
            String text = (String)ContainerUtil.getOrElse(this.myTexts, (int)(i + 1), (Object)"");
            builder2.append(text);
        }
        builder2.append("`");
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        JSType substitute;
        if (context2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(38);
        }
        if (!TypeScriptTemplateLiteralJSTypeImpl.checkTypeInvariant(this.getTexts(), this.getTypes(), this.getSource())) {
            return JSNamedTypeFactory.createStringPrimitiveType(this.getSource());
        }
        if (ContainerUtil.all(this.myTypes, TypeScriptTemplateLiteralJSTypeImpl::isPlaceholderOrGenericParameterType)) {
            return this;
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("substitute", this.myTexts, this.myTypes, this.getSource());
        }
        return (substitute = this.substituteConstituentTypes(context2)) instanceof JSTemplateLiteralType ? TypeScriptTemplateLiteralJSTypeImpl.distributeTemplateLiteralType((JSTemplateLiteralType)substitute) : substitute;
    }

    private static boolean isPlaceholderOrGenericParameterType(@NotNull JSType t) {
        if (t == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(39);
        }
        return TypeScriptTypeRelations.isPatternLiteralPlaceholderType(t) || t instanceof JSGenericParameterType;
    }

    @NotNull
    private JSType substituteConstituentTypes(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(40);
        }
        ArrayList<JSType> substitutedTypes = null;
        boolean substituted = false;
        Iterator<JSType> iterator = this.myTypes.iterator();
        while (iterator.hasNext()) {
            JSType type;
            JSType newType = type = iterator.next();
            if (!(type instanceof JSPrimitiveType)) {
                newType = context2.substituteNested(newType);
            }
            if (newType == null) {
                JSAnyType jSAnyType = JSAnyType.get(this.getSource());
                if (jSAnyType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(41);
                }
                return jSAnyType;
            }
            if (newType instanceof TypeScriptNeverType) {
                JSType jSType = newType;
                if (jSType == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(42);
                }
                return jSType;
            }
            if (type != (newType = TypeScriptTemplateLiteralJSTypeImpl.substituteConstituentType(newType))) {
                substituted = true;
            }
            if (substitutedTypes == null) {
                substitutedTypes = new ArrayList<JSType>(this.myTypes.size());
            }
            substitutedTypes.add(newType);
        }
        JSType jSType = substituted ? TypeScriptTemplateLiteralJSTypeImpl.createType(this.myTexts, substitutedTypes, this.myAllowWidening, this.getSource(), true) : this;
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(43);
        }
        return jSType;
    }

    @NotNull
    private static JSType substituteConstituentType(@NotNull JSType newType) {
        if (newType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(44);
        }
        return TypeScriptTemplateLiteralJSTypeImpl.booleanTypeAsUnion(newType);
    }

    @NotNull
    public static JSType booleanTypeAsUnion(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(45);
        }
        if (type instanceof JSBooleanType && !(type instanceof JSPrimitiveLiteralType)) {
            type = TypeScriptTypeRelations.getAsUnionIfBooleanOrEnum(type);
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @NotNull
    private static JSType createInlinedTemplateLiteral(@NotNull List<String> texts, @NotNull List<JSType> types, boolean allowWidening, @NotNull JSTypeSource source, boolean strict) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(47);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(48);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(49);
        }
        SmartList newTexts = new SmartList();
        SmartList newTypes = new SmartList();
        StringBuilder text = new StringBuilder();
        text.append((String)ContainerUtil.getFirstItem(texts, (Object)""));
        if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(texts, types, (List<String>)newTexts, (List<JSType>)newTypes, text, strict)) {
            JSStringType jSStringType = JSNamedTypeFactory.createStringPrimitiveType(source);
            if (jSStringType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(50);
            }
            return jSStringType;
        }
        if (newTypes.isEmpty()) {
            return new JSStringLiteralTypeImpl(text.toString(), allowWidening, source);
        }
        newTexts.add(text.toString());
        return new TypeScriptTemplateLiteralJSTypeImpl((List<String>)newTexts, (List<JSType>)newTypes, allowWidening, source);
    }

    @NotNull
    private static JSType distributeTemplateLiteralType(@NotNull JSTemplateLiteralType type) {
        boolean distribute;
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(51);
        }
        List<JSType> types = type.getTypes();
        JSTypeSource source = type.getSource();
        int estimatedSize = TypeScriptTypeRelations.computeCrossProductUnionSize(types);
        if (estimatedSize < 0 || estimatedSize >= 100000) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(52);
            }
            return jSAnyType;
        }
        if (estimatedSize == 0) {
            TypeScriptNeverType typeScriptNeverType = JSNamedTypeFactory.createNeverType(source);
            if (typeScriptNeverType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(53);
            }
            return typeScriptNeverType;
        }
        boolean bl = distribute = ContainerUtil.findInstance(types, JSUnionType.class) != null;
        if (!distribute) {
            JSTemplateLiteralType jSTemplateLiteralType = type;
            if (jSTemplateLiteralType == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(54);
            }
            return jSTemplateLiteralType;
        }
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("distribute", type.getTexts(), types, source);
        }
        ArrayList<JSType> constituents = new ArrayList<JSType>(estimatedSize);
        TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents(constituents, new ArrayDeque<JSType>(types.size()), 0, type.getTexts(), types, type.allowWidening(), source);
        JSCompositeTypeImpl compositeType = new JSCompositeTypeImpl(source, Collections.unmodifiableList(constituents));
        Set kinds = compositeType.getResolvedOptimized();
        if (kinds != null) {
            kinds.addAll(EnumSet.allOf(JSUnionOrIntersectionType.OptimizedKind.class));
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = compositeType;
        if (jSCompositeTypeImpl == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(55);
        }
        return jSCompositeTypeImpl;
    }

    private static void distributeTypeLiteralConstituents(@NotNull Collection<JSType> constituents, @NotNull Deque<JSType> current, int idx, @NotNull List<String> sourceTexts, @NotNull List<JSType> sourceTypes, boolean allowWidening, @NotNull JSTypeSource source) {
        if (constituents == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(56);
        }
        if (current == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(57);
        }
        if (sourceTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(58);
        }
        if (sourceTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(59);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(60);
        }
        ProgressManager.checkCanceled();
        if (idx == sourceTypes.size()) {
            constituents.add(TypeScriptTemplateLiteralJSTypeImpl.createType(sourceTexts, new ArrayList<JSType>(current), allowWidening, source));
            return;
        }
        JSType type = sourceTypes.get(idx);
        if (type instanceof JSUnionType) {
            List<JSType> childConstituents = ((JSUnionType)type).getTypes();
            for (JSType constituent : childConstituents) {
                current.addLast(constituent);
                TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents(constituents, current, idx + 1, sourceTexts, sourceTypes, allowWidening, source);
                current.removeLast();
            }
        } else {
            current.addLast(type);
            TypeScriptTemplateLiteralJSTypeImpl.distributeTypeLiteralConstituents(constituents, current, idx + 1, sourceTexts, sourceTypes, allowWidening, source);
            current.removeLast();
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myTexts, this.myTypes);
    }

    private static boolean addSpans(@NotNull List<String> texts, @NotNull List<JSType> types, @NotNull List<String> newTexts, @NotNull List<JSType> newTypes, @NotNull StringBuilder text, boolean strict) {
        if (texts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(61);
        }
        if (types == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(62);
        }
        if (newTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(63);
        }
        if (newTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(64);
        }
        if (text == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(65);
        }
        for (int i = 0; i < types.size(); ++i) {
            JSType type = types.get(i);
            String nextFragment = (String)ContainerUtil.getOrElse(texts, (int)(i + 1), (Object)"");
            if (type instanceof JSPrimitiveLiteralType || type instanceof JSNullType || type instanceof JSUndefinedType) {
                text.append(TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(type));
                text.append(nextFragment);
                continue;
            }
            if (type instanceof JSTemplateLiteralType) {
                JSTemplateLiteralType literalType = (JSTemplateLiteralType)type;
                text.append((String)ContainerUtil.getFirstItem(literalType.getTexts(), (Object)""));
                if (!TypeScriptTemplateLiteralJSTypeImpl.addSpans(literalType.getTexts(), literalType.getTypes(), newTexts, newTypes, text, strict)) {
                    return false;
                }
                text.append(nextFragment);
                continue;
            }
            if (!strict || TypeScriptTypeRelations.isGenericIndexType(type) || TypeScriptTypeRelations.isPatternLiteralPlaceholderType(type)) {
                newTypes.add(type);
                newTexts.add(text.toString());
                text.setLength(0);
                text.append(nextFragment);
                continue;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static String getTemplateStringForType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(66);
        }
        if (type instanceof JSBooleanLiteralTypeImpl || type instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSPrimitiveLiteralType)type).getValueAsString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(67);
            }
            return string;
        }
        if (type instanceof JSBigIntLiteralTypeImpl) {
            String string = ((JSBigIntLiteralTypeImpl)type).getLiteral().toString();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(68);
            }
            return string;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            String string = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(69);
            }
            return string;
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(70);
            }
            return string;
        }
        return "";
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(71);
        }
        for (JSType type : this.getTypes()) {
            type.accept(visitor);
        }
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(72);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(73);
        }
        if (elementType instanceof JSUnionType) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if (elementType instanceof TypeScriptTemplateLiteralJSTypeImpl && TypeScriptTemplateLiteralJSTypeImpl.templateLiteralTypesDefinitelyUnrelated((TypeScriptTemplateLiteralJSTypeImpl)elementType, this)) {
            return false;
        }
        boolean isProcessingGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        if (isProcessingGenerics) {
            return this.inferAndApplyGenerics(elementType, processingContext);
        }
        List<JSType> inferred = this.inferTypesFromTemplateLiteralType(elementType);
        return TypeScriptTypeRelations.everyType(inferred, this.myTypes, (source, target) -> TypeScriptTemplateLiteralJSTypeImpl.isValidTypeForTemplateLiteralPlaceholder(source, target, processingContext));
    }

    private static boolean templateLiteralTypesDefinitelyUnrelated(@NotNull TypeScriptTemplateLiteralJSTypeImpl source, @NotNull TypeScriptTemplateLiteralJSTypeImpl target) {
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(74);
        }
        if (target == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(75);
        }
        List<String> sourceTexts = source.getTexts();
        List<String> targetTexts = target.getTexts();
        String sourceStart = (String)ContainerUtil.getFirstItem(sourceTexts);
        String targetStart = (String)ContainerUtil.getFirstItem(targetTexts);
        String sourceEnd = (String)ContainerUtil.getLastItem(sourceTexts);
        String targetEnd = (String)ContainerUtil.getLastItem(targetTexts);
        if (sourceStart == null || targetStart == null || sourceEnd == null || targetEnd == null) {
            return true;
        }
        int startLen = Math.min(sourceStart.length(), targetStart.length());
        int endLen = Math.min(sourceEnd.length(), targetEnd.length());
        return !sourceStart.substring(0, startLen).equals(targetStart.substring(0, startLen)) || !sourceEnd.substring(sourceEnd.length() - endLen).equals(targetEnd.substring(targetEnd.length() - endLen));
    }

    private boolean inferAndApplyGenerics(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        List<JSType> inferredTypes;
        if (elementType == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(76);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(77);
        }
        boolean isInferred = !(inferredTypes = this.inferTypesFromTemplateLiteralType(elementType)).isEmpty();
        JSGenericMappings genericMappings = JSGenericTypesEvaluator.getGenericMappings(processingContext);
        assert (genericMappings != null);
        MultiMap<JSTypeGenericId, JSType> mapping = genericMappings.getMapping();
        TypeScriptNeverType defaultType = JSNamedTypeFactory.createNeverType(this.getSource());
        for (int i = 0; i < this.myTypes.size(); ++i) {
            JSGenericParameterImpl parameterType = (JSGenericParameterImpl)ObjectUtils.tryCast((Object)this.myTypes.get(i), JSGenericParameterImpl.class);
            if (parameterType == null || !parameterType.isApplying()) continue;
            JSType inferredType = (JSType)ContainerUtil.getOrElse(inferredTypes, (int)i, (Object)defaultType);
            if (inferredType instanceof TypeScriptNeverType) {
                isInferred = false;
            }
            mapping.putValue((Object)parameterType.getGenericId(), (Object)inferredType);
        }
        return isInferred;
    }

    private static boolean isValidTypeForTemplateLiteralPlaceholder(@NotNull JSType source, @NotNull JSType target, @NotNull ProcessingContext processingContext) {
        JSType constraint;
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(78);
        }
        if (target == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(79);
        }
        if (processingContext == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(80);
        }
        if ((constraint = TypeScriptTypeRelations.getBaseConstraintOfType(target, target.getSourceElement())) != null) {
            target = constraint;
        }
        if (source == target || target instanceof JSAnyType || target instanceof JSStringType && !(target instanceof JSStringLiteralTypeImpl)) {
            return true;
        }
        if (source instanceof JSStringLiteralTypeImpl && TypeScriptTemplateLiteralJSTypeImpl.isPlaceholderType(target)) {
            String literal = TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(source);
            return target instanceof JSNumberType && TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal) || target instanceof JSBigIntType && TypeScriptTemplateLiteralJSTypeImpl.isValidNumberString(literal + "n") || target instanceof JSBooleanType && (literal.equals("true") || literal.equals("false")) || target instanceof JSUndefinedType && literal.equals("undefined") || target instanceof JSNullType && literal.equals("null");
        }
        if (source instanceof JSTemplateLiteralType) {
            List<String> texts = ((JSTemplateLiteralType)source).getTexts();
            List<JSType> types = ((JSTemplateLiteralType)source).getTypes();
            return texts.size() == 2 && texts.get(0).isEmpty() && texts.get(1).isEmpty() && target.isDirectlyAssignableType((JSType)ContainerUtil.getFirstItem(types), processingContext);
        }
        return target.isDirectlyAssignableType(source, processingContext);
    }

    private static boolean isPlaceholderType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(81);
        }
        return type instanceof JSNumberType || type instanceof JSBigIntType || type instanceof JSBooleanType || type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    @NotNull
    private List<JSType> inferTypesFromTemplateLiteralType(@NotNull JSType source) {
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(82);
        }
        if (source instanceof JSStringLiteralTypeImpl) {
            return this.inferFromLiteralPartsToTemplateLiteral(Collections.singletonList(TypeScriptTemplateLiteralJSTypeImpl.getTemplateStringForType(source)), Collections.emptyList(), source.getSource());
        }
        if (source instanceof JSTemplateLiteralType) {
            List<JSType> sourceTypes;
            List<String> sourceTexts = ((JSTemplateLiteralType)source).getTexts();
            if (!TypeScriptTemplateLiteralJSTypeImpl.checkTypeInvariant(sourceTexts, sourceTypes = ((JSTemplateLiteralType)source).getTypes(), source.getSource())) {
                List<JSType> list = Collections.emptyList();
                if (list == null) {
                    TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(83);
                }
                return list;
            }
            return this.getTexts().equals(sourceTexts) ? ContainerUtil.map(sourceTypes, TypeScriptTemplateLiteralJSTypeImpl::getStringLikeTypeForType) : this.inferFromLiteralPartsToTemplateLiteral(sourceTexts, sourceTypes, source.getSource());
        }
        List<JSType> list = Collections.emptyList();
        if (list == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(84);
        }
        return list;
    }

    @NotNull
    private static JSType getStringLikeTypeForType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(85);
        }
        return type instanceof JSAnyType || type instanceof TypeScriptNeverType || TypeScriptTypeRelations.isStringLike(type) ? type : TypeScriptTemplateLiteralJSTypeImpl.createType(EMPTY_TEXTS, Collections.singletonList(type), false, type.getSource());
    }

    @NotNull
    private List<JSType> inferFromLiteralPartsToTemplateLiteral(@NotNull List<String> sourceTexts, @NotNull List<JSType> sourceTypes, @NotNull JSTypeSource source) {
        List<JSType> targetTypes;
        if (sourceTexts == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(86);
        }
        if (sourceTypes == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(87);
        }
        if (source == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(88);
        }
        if (sourceTexts.isEmpty()) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(89);
            }
            return list;
        }
        List<String> targetTexts = this.getTexts();
        if (!TypeScriptTemplateLiteralJSTypeImpl.checkTypeInvariant(targetTexts, targetTypes = this.getTypes(), source)) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(90);
            }
            return list;
        }
        int lastSourceIndex = sourceTexts.size() - 1;
        String sourceStartText = sourceTexts.get(0);
        String sourceEndText = sourceTexts.get(lastSourceIndex);
        int lastTargetIndex = targetTexts.size() - 1;
        String targetStartText = targetTexts.get(0);
        String targetEndText = targetTexts.get(lastTargetIndex);
        if (lastSourceIndex == 0 && sourceStartText.length() < targetStartText.length() + targetEndText.length() || !sourceStartText.startsWith(targetStartText) || !sourceEndText.endsWith(targetEndText)) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(91);
            }
            return list;
        }
        String remainingEndText = sourceEndText.substring(0, sourceEndText.length() - targetEndText.length());
        if (LOG.isTraceEnabled()) {
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("infer:source", sourceTexts, sourceTypes, source);
            TypeScriptTemplateLiteralJSTypeImpl.traceTemplateTypeOperation("infer:target", targetTexts, targetTypes, this.getSource());
        }
        InferenceState state = new InferenceState(0, targetStartText.length(), sourceTexts, sourceTypes, remainingEndText, lastSourceIndex, this.getSource());
        for (int i = 1; i < lastTargetIndex; ++i) {
            String delimiter = targetTexts.get(i);
            if (delimiter.length() > 0) {
                int s = state.mySeg;
                int p = state.myPos;
                while ((p = state.getSourceText(s).indexOf(delimiter, p)) < 0) {
                    if (++s == sourceTexts.size()) {
                        List<JSType> list = Collections.emptyList();
                        if (list == null) {
                            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(92);
                        }
                        return list;
                    }
                    p = 0;
                }
                state.addMatch(s, p);
                state.myPos += delimiter.length();
                continue;
            }
            if (state.myPos < state.getSourceText(state.mySeg).length()) {
                state.addMatch(state.mySeg, state.myPos + 1);
                continue;
            }
            if (state.mySeg < lastSourceIndex) {
                state.addMatch(state.mySeg + 1, 0);
                continue;
            }
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(93);
            }
            return list;
        }
        state.addMatch(lastSourceIndex, state.getSourceText(lastSourceIndex).length());
        List<JSType> list = state.myMatches;
        if (list == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(94);
        }
        return list;
    }

    private static boolean isValidNumberString(@NotNull String literal) {
        if (literal == null) {
            TypeScriptTemplateLiteralJSTypeImpl.$$$reportNull$$$0(95);
        }
        JSFlexAdapter flexAdapter = new JSFlexAdapter(DialectOptionHolder.TS);
        flexAdapter.start(literal);
        if (flexAdapter.getTokenType() == JSTokenTypes.MINUS) {
            flexAdapter.advance();
        }
        if (flexAdapter.getTokenType() != JSTokenTypes.NUMERIC_LITERAL) {
            return false;
        }
        flexAdapter.advance();
        return flexAdapter.getTokenType() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 11, 12, 29, 30, 31, 41, 42, 43, 46, 50, 52, 53, 54, 55, 67, 68, 69, 70, 83, 84, 89, 90, 91, 92, 93, 94 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 48: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 5: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 34: 
            case 49: 
            case 60: 
            case 74: 
            case 78: 
            case 82: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 35: 
            case 45: 
            case 51: 
            case 66: 
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constituents";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 58: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTexts";
                break;
            }
            case 59: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypes";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTexts";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypes";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 73: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTexts";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "widen";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteConstituentTypes";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "booleanTypeAsUnion";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlinedTemplateLiteral";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeTemplateLiteralType";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateStringForType";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypesFromTemplateLiteralType";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "inferFromLiteralPartsToTemplateLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 29: 
            case 30: 
            case 31: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTexts";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeInvariant";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "traceTemplateTypeOperation";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithPrimitiveIfPossible";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceholderOrGenericParameterType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "substituteConstituentTypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "substituteConstituentType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "booleanTypeAsUnion";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createInlinedTemplateLiteral";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "distributeTemplateLiteralType";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "distributeTypeLiteralConstituents";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addSpans";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateStringForType";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "templateLiteralTypesDefinitelyUnrelated";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "inferAndApplyGenerics";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isValidTypeForTemplateLiteralPlaceholder";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceholderType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "inferTypesFromTemplateLiteralType";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getStringLikeTypeForType";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "inferFromLiteralPartsToTemplateLiteral";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isValidNumberString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 11, 12, 29, 30, 31, 41, 42, 43, 46, 50, 52, 53, 54, 55, 67, 68, 69, 70, 83, 84, 89, 90, 91, 92, 93, 94 -> new IllegalStateException(string);
        };
    }

    private static final class InferenceState {
        private final List<JSType> myMatches = new ArrayList<JSType>();
        private final List<String> mySourceTexts;
        private final List<JSType> mySourceTypes;
        private final String myRemainingEndText;
        private final int myLastSourceIndex;
        private final JSTypeSource mySource;
        private int mySeg;
        private int myPos;

        InferenceState(int seg, int pos, List<String> sourceTexts, List<JSType> sourceTypes, String remainingEndText, int lastSourceIndex, JSTypeSource source) {
            this.mySeg = seg;
            this.myPos = pos;
            this.mySourceTexts = sourceTexts;
            this.mySourceTypes = sourceTypes;
            this.myRemainingEndText = remainingEndText;
            this.myLastSourceIndex = lastSourceIndex;
            this.mySource = source;
        }

        @NotNull
        private String getSourceText(int index) {
            String string = index < this.myLastSourceIndex ? this.mySourceTexts.get(index) : this.myRemainingEndText;
            if (string == null) {
                InferenceState.$$$reportNull$$$0(0);
            }
            return string;
        }

        private void addMatch(int s, int p) {
            JSType matchType;
            if (s == this.mySeg) {
                matchType = new JSStringLiteralTypeImpl(this.getSourceText(s).substring(this.myPos, p), false, this.mySource);
            } else {
                ArrayList<String> texts = new ArrayList<String>();
                texts.add(this.mySourceTexts.get(this.mySeg).substring(this.myPos));
                texts.addAll(this.mySourceTexts.subList(this.mySeg + 1, s));
                texts.add(this.getSourceText(s).substring(0, p));
                ArrayList<JSType> types = new ArrayList<JSType>(this.mySourceTypes.subList(this.mySeg, s));
                matchType = TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types, false, this.mySource);
            }
            this.myMatches.add(matchType);
            this.mySeg = s;
            this.myPos = p;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTemplateLiteralJSTypeImpl$InferenceState", "getSourceText"));
        }
    }
}

