/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumSetStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionWithLazyType;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitElementStructureImpl
implements JSImplicitElementStructure {
    protected static final BooleanStructureElement NAMESPACE_EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    protected static final EnumSetStructureElement<JSImplicitElement.Property> PROPERTIES_FLAG = new EnumSetStructureElement<JSImplicitElement.Property>(JSImplicitElement.Property.class);
    protected static final EnumStructureElement<JSImplicitElement.Type> TYPE_FLAG = new EnumStructureElement<JSImplicitElement.Type>(JSImplicitElement.Type.class);
    protected static final EnumStructureElement<JSAttributeList.AccessType> ACCESS_TYPE_FLAG = new EnumStructureElement<JSAttributeList.AccessType>(JSAttributeList.AccessType.class);
    protected static final BooleanStructureElement DEPRECATED_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_TYPE_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_USER_STRING_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_USER_STRING_DATA_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_CLASS_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_OPTIONAL_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement HAS_JSDOC_FLAG = new BooleanStructureElement();
    protected static final BooleanStructureElement IS_IMPLICIT_FUNCTION_WITH_LAZY_TYPE = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(NAMESPACE_EXPLICITLY_DECLARED_FLAG, PROPERTIES_FLAG, TYPE_FLAG, ACCESS_TYPE_FLAG, DEPRECATED_FLAG, HAS_TYPE_STRING_FLAG, HAS_USER_STRING_FLAG, HAS_USER_STRING_DATA_FLAG, IS_CLASS_FLAG, IS_OPTIONAL_FLAG, IS_INTERFACE_FLAG, HAS_JSDOC_FLAG, IS_IMPLICIT_FUNCTION_WITH_LAZY_TYPE);
    protected final int myFlags;
    @NotNull
    protected final String myName;
    @NotNull
    protected final JSStubElementTypeHolder myNamespaceHolder;
    @Nullable
    protected final JSStubElementTypeHolder myTypeHolder;
    @Nullable
    private final String myUserString;
    @Nullable
    private final String myUserStringData;

    public JSImplicitElementStructureImpl(@NotNull JSImplicitElementImpl.Builder builder2) {
        PsiElement provider;
        if (builder2 == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(0);
        }
        this.myName = builder2.myName;
        this.myNamespaceHolder = new JSStubElementTypeHolder(builder2.mySerializedNamespace);
        String serializedType = builder2.mySerializedType;
        this.myTypeHolder = serializedType != null ? new JSStubElementTypeHolder(serializedType) : null;
        this.myUserString = builder2.myUserString;
        this.myUserStringData = builder2.myUserStringData;
        int flags = builder2.myFlags;
        JSImplicitElement.Type type = JSImplicitElementStructureImpl.readFlag(TYPE_FLAG, flags);
        if (type.providesNamespace()) {
            flags = JSImplicitElementStructureImpl.writeFlag(flags, type == JSImplicitElement.Type.Interface ? IS_INTERFACE_FLAG : IS_CLASS_FLAG, true);
        }
        if ((provider = builder2.myProvider) != null && builder2.myAllowAstAccess) {
            JSDocComment ownDocComment;
            boolean isRealElementMirror = !(provider instanceof PsiComment);
            PsiElement docComment = JSDocumentationUtils.findCommentForImplicitElement(provider);
            if (!((EnumSet)((Object)JSImplicitElementStructureImpl.readFlag(PROPERTIES_FLAG, flags = JSImplicitElementStructureImpl.writeFlag(flags, HAS_JSDOC_FLAG, isRealElementMirror && docComment != null)))).contains((Object)JSImplicitElement.Property.MinorImportance) && (ownDocComment = JSDocumentationUtils.findOwnDocCommentForImplicitElement(provider)) != null && ownDocComment.hasDeprecatedTag()) {
                flags = JSImplicitElementStructureImpl.writeFlag(flags, DEPRECATED_FLAG, true);
            }
        }
        this.myFlags = flags = JSImplicitElementStructureImpl.writeFlag(flags, IS_OPTIONAL_FLAG, builder2.myOptional);
        assert (this.getType() == JSImplicitElement.Type.Function == (this instanceof JSImplicitFunctionStructureImpl || this instanceof JSImplicitFunctionWithLazyType.JSImplicitFunctionWithLazyTypeStructure));
    }

    protected JSImplicitElementStructureImpl(int flags, @NotNull String name, @NotNull JSStubElementTypeHolder namespace, @Nullable JSStubElementTypeHolder jsType, @Nullable String userString, @Nullable String userStringData) {
        if (name == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(2);
        }
        this.myFlags = flags;
        this.myName = name;
        this.myNamespaceHolder = namespace;
        this.myTypeHolder = jsType;
        this.myUserString = userString;
        this.myUserStringData = userStringData;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        return this.getJSNamespace().getQualifiedName();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String prefix = this.getNamespace() != null ? this.getNamespace().getQualifiedName() + "." : "";
        String string = prefix + this.myName;
        if (string == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(NAMESPACE_EXPLICITLY_DECLARED_FLAG);
    }

    @Override
    @Nullable
    public String getUserString() {
        return this.myUserString;
    }

    @Override
    @Nullable
    public String getUserStringData() {
        return this.myUserStringData;
    }

    protected final <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return JSImplicitElementStructureImpl.readFlag(structureElement, this.myFlags);
    }

    protected static <T> T readFlag(FlagsStructureElement<T> structureElement, int flags) {
        return IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, structureElement, flags);
    }

    @Contract(pure=true)
    protected static <T> int writeFlag(int currentFlags, FlagsStructureElement<T> structureElement, T value) {
        return IntFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, structureElement, value, currentFlags);
    }

    @Override
    public void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(5);
        }
        IOUtil.writeUTF((DataOutput)dataStream, (String)this.myName);
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myFlags);
        JSStubElementTypeHolder.serialize(this.myNamespaceHolder, dataStream);
        if (this.readFlag(HAS_TYPE_STRING_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(Objects.requireNonNull(this.myTypeHolder), dataStream);
        }
        if (this.myUserString != null) {
            assert (this.readFlag(HAS_USER_STRING_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myUserString);
        }
        if (this.myUserStringData != null) {
            assert (this.readFlag(HAS_USER_STRING_DATA_FLAG).booleanValue());
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myUserStringData);
        }
    }

    @NotNull
    public static JSImplicitElementStructureImpl deserialize(DataInput dataStream) throws IOException {
        String name = IOUtil.readUTF((DataInput)dataStream);
        int flags = DataInputOutputUtil.readINT((DataInput)dataStream);
        JSStubElementTypeHolder namespaceHolder = JSStubElementTypeHolder.fromDataStream(dataStream);
        boolean hasType = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_STRING_FLAG, flags);
        JSStubElementTypeHolder jsType = hasType ? JSStubElementTypeHolder.fromDataStream(dataStream) : null;
        boolean hasUserString = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_USER_STRING_FLAG, flags);
        String userString = hasUserString ? IOUtil.readUTF((DataInput)dataStream) : null;
        boolean hasUserStringData = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_USER_STRING_DATA_FLAG, flags);
        String userStringData = hasUserStringData ? IOUtil.readUTF((DataInput)dataStream) : null;
        JSImplicitElement.Type type = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TYPE_FLAG, flags);
        if (!type.isFunction()) {
            return new JSImplicitElementStructureImpl(flags, name, namespaceHolder, jsType, userString, userStringData);
        }
        boolean isImplicitFunctionWithLazyType = IntFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, IS_IMPLICIT_FUNCTION_WITH_LAZY_TYPE, flags);
        if (isImplicitFunctionWithLazyType) {
            return new JSImplicitFunctionWithLazyType.JSImplicitFunctionWithLazyTypeStructure(flags, name, namespaceHolder, jsType, userString, userStringData);
        }
        List<JSImplicitParameterStructure> parameters = JSImplicitFunctionStructureImpl.deserializeParameters(dataStream);
        return new JSImplicitFunctionStructureImpl(flags, name, namespaceHolder, jsType, userString, userStringData, parameters);
    }

    @Override
    @NotNull
    public JSImplicitElement.Type getType() {
        JSImplicitElement.Type type = this.readFlag(TYPE_FLAG);
        if (type == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(6);
        }
        return type;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(7);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = this.readFlag(ACCESS_TYPE_FLAG);
        if (accessType == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(8);
        }
        return accessType;
    }

    @Override
    public boolean hasMinorImportance() {
        return ((EnumSet)((Object)this.readFlag(PROPERTIES_FLAG))).contains((Object)JSImplicitElement.Property.MinorImportance);
    }

    @Override
    public boolean isDeprecated() {
        return this.readFlag(DEPRECATED_FLAG);
    }

    public boolean isOptional() {
        return this.readFlag(IS_OPTIONAL_FLAG);
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        return this.myTypeHolder != null ? this.myTypeHolder.getSerializedTypeString() : null;
    }

    public boolean isConst() {
        return ((EnumSet)((Object)this.readFlag(PROPERTIES_FLAG))).contains((Object)JSImplicitElement.Property.Constant);
    }

    @NotNull
    public JSImplicitElementImpl.Builder toBuilder() {
        JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(this.myName, null);
        this.fillBuilder(builder2);
        JSImplicitElementImpl.Builder builder3 = builder2;
        if (builder3 == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(9);
        }
        return builder3;
    }

    protected void fillBuilder(@NotNull JSImplicitElementImpl.Builder builder2) {
        if (builder2 == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(10);
        }
        builder2.setName(this.myName).setFlags(this.myFlags).setPossiblyUnregisteredUserString(this.myUserString);
        builder2.mySerializedNamespace = this.myNamespaceHolder.getSerializedTypeString();
        builder2.mySerializedType = this.myTypeHolder != null ? this.myTypeHolder.getSerializedTypeString() : null;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = this.readFlag(IS_INTERFACE_FLAG) != false ? JSElementBase.ClassOrInterface.INTERFACE : (this.readFlag(IS_CLASS_FLAG) != false ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(11);
        }
        return classOrInterface;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)this.myNamespaceHolder.getTypeOrFromSerialized().copyWithStrict(this.isNamespaceExplicitlyDeclared());
        if (jSNamespace == null) {
            JSImplicitElementStructureImpl.$$$reportNull$$$0(12);
        }
        return jSNamespace;
    }

    @Override
    public boolean hasJSDoc() {
        return this.readFlag(HAS_JSDOC_FLAG);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSImplicitElementStructureImpl structure = (JSImplicitElementStructureImpl)o;
        if (this.myFlags != structure.myFlags) {
            return false;
        }
        if (!this.myName.equals(structure.myName)) {
            return false;
        }
        if (!Objects.equals(this.myNamespaceHolder, structure.myNamespaceHolder)) {
            return false;
        }
        if (!Objects.equals(this.myTypeHolder, structure.myTypeHolder)) {
            return false;
        }
        if (!Objects.equals(this.myUserString, structure.myUserString)) {
            return false;
        }
        return Objects.equals(this.myUserStringData, structure.myUserStringData);
    }

    public int hashCode() {
        int result2 = this.myFlags;
        result2 = 31 * result2 + this.myName.hashCode();
        result2 = 31 * result2 + this.myNamespaceHolder.hashCode();
        result2 = 31 * result2 + (this.myTypeHolder != null ? this.myTypeHolder.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserString != null ? this.myUserString.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserStringData != null ? this.myUserStringData.hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public JSIndexableImplicitElement toImplicitElement(@Nullable PsiElement provider) {
        return new JSImplicitElementImpl(this, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitElementStructureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }
}

