/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    protected static final Logger LOG = Logger.getInstance(ExpressionParser.class);
    protected static final Key<IElementType> DESTRUCTURING_VAR_TYPE = Key.create((String)"within.destructuring.expression");
    protected static final Key<Boolean> ALLOW_PIPE_TOPICS = Key.create((String)"allow.pipe.topics");
    protected static final Key<Boolean> HAS_PIPE_TOPICS = Key.create((String)"has.pipe.topics");
    protected static final Key<Boolean> PROHIBIT_TOKEN_REMAPPING = Key.create((String)"no.token.remapping");
    private static final JSModifiersStructure FUNCTION_PROPERTY_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.MULT));
    private int myNestedObjectLiterals = 0;

    protected ExpressionParser(T parser2) {
        super(parser2);
    }

    public boolean parsePrimaryExpression() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.THIS_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            return true;
        }
        if (firstToken == JSTokenTypes.SUPER_KEYWORD) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.SUPER_EXPRESSION);
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD && this.isJSorTS()) {
            PsiBuilder.Marker classMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            modifierList.done(((FunctionParser)this.myJavaScriptParser.getFunctionParser()).getAttributeListElementType());
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseClassNoMarker(classMarker, true, true);
            return true;
        }
        if (this.isIdentifierToken(firstToken) || firstToken == JSTokenTypes.ANY_IDENTIFIER) {
            PsiBuilder.Marker start = this.builder.mark();
            IElementType elementType = StringUtil.equalsIgnoreCase((CharSequence)"jbIdentifier6b52cc4b", (CharSequence)this.getTokenCharSequence()) ? JSElementTypes.OUTER_LANGUAGE_ELEMENT_EXPRESSION : this.getNameReferenceElementType();
            this.myJavaScriptParser.buildTokenElement(elementType);
            if (this.proceedWithNamespaceReference(start, true)) {
                start.precede().done(this.getNameReferenceElementType());
            }
            return true;
        }
        if (firstToken == JSTokenTypes.NUMERIC_LITERAL || firstToken == JSTokenTypes.STRING_LITERAL || firstToken == JSTokenTypes.REGEXP_LITERAL || firstToken == JSTokenTypes.NULL_KEYWORD || firstToken == JSTokenTypes.UNDEFINED_KEYWORD || firstToken == JSTokenTypes.FALSE_KEYWORD || firstToken == JSTokenTypes.TRUE_KEYWORD) {
            String errorMessage = this.validateLiteral();
            this.myJavaScriptParser.buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }
        if (firstToken == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            return true;
        }
        if (firstToken == JSTokenTypes.LBRACKET) {
            this.parseArrayLiteralExpression(true, false);
            return true;
        }
        if (firstToken == JSTokenTypes.LBRACE) {
            this.parseObjectLiteralExpression(false);
            return true;
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
            return true;
        }
        if (JSTokenTypes.ACCESS_MODIFIERS.contains(firstToken)) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                this.builder.advanceLexer();
                if (this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.advanceLexer();
                }
            } else {
                marker.drop();
                return false;
            }
            marker.done(this.getNameReferenceElementType());
            return true;
        }
        if (this.myJavaScriptParser.getXmlParser().isXmlTagStart(firstToken)) {
            this.myJavaScriptParser.getXmlParser().parseTag((Stack<String>)new Stack());
            return true;
        }
        if (firstToken == JSTokenTypes.AT) {
            PsiBuilder.Marker attrReferenceStartMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseES7Decorators();
            modifierList.done(((FunctionParser)this.myJavaScriptParser.getFunctionParser()).getAttributeListElementType());
            if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseClassNoMarker(attrReferenceStartMarker, true, true);
            } else {
                attrReferenceStartMarker.drop();
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.class", new Object[0]));
            }
            return true;
        }
        if (firstToken == JSTokenTypes.INT_KEYWORD || firstToken == JSTokenTypes.UINT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(this.getNameReferenceElementType());
            return true;
        }
        if (firstToken == JSTokenTypes.BACKQUOTE) {
            return this.parseStringTemplate();
        }
        return false;
    }

    private void parseYieldExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.YIELD_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!ExpressionParser.hasLineTerminatorBefore(this.builder)) {
            if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                this.builder.advanceLexer();
            }
            this.parseAssignmentExpression(true);
        }
        marker.done(JSElementTypes.YIELD_EXPRESSION);
    }

    protected boolean parseStringTemplate() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BACKQUOTE);
        boolean parsedSomething = false;
        PsiBuilder.Marker stringTemplate = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                stringTemplate.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
                return parsedSomething;
            }
            if (this.builder.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                    this.builder.advanceLexer();
                    this.parseExpression();
                    ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                this.builder.advanceLexer();
            }
            parsedSomething = true;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.BACKQUOTE, "javascript.parser.message.missing.back.quote");
        stringTemplate.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
        return true;
    }

    @Nullable
    @NlsContexts.ParsingError
    public String validateLiteral() {
        IElementType ttype = this.builder.getTokenType();
        if (ttype == JSTokenTypes.STRING_LITERAL) {
            CharSequence ttext = this.getTokenCharSequence();
            assert (ttext != null);
            return ExpressionParser.validateLiteralText(ttext);
        }
        return null;
    }

    @NlsContexts.ParsingError
    protected static String validateLiteralText(CharSequence text) {
        if (ExpressionParser.lastSymbolEscaped(text) || StringUtil.startsWith((CharSequence)text, (CharSequence)"\"") && (!StringUtil.endsWith((CharSequence)text, (CharSequence)"\"") || text.length() == 1) || StringUtil.startsWith((CharSequence)text, (CharSequence)"'") && (!StringUtil.endsWith((CharSequence)text, (CharSequence)"'") || text.length() == 1)) {
            return JavaScriptParserBundle.message("javascript.parser.message.unclosed.string.literal", new Object[0]);
        }
        return null;
    }

    private static boolean lastSymbolEscaped(CharSequence text) {
        boolean escapes = false;
        boolean escaped = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escapes) {
                escapes = false;
                escaped = true;
                continue;
            }
            if (c == '\\') {
                escapes = true;
            }
            escaped = false;
        }
        return escapes || escaped;
    }

    protected void parseDestructuringProperty() {
        IElementType nameToken = this.builder.getTokenType();
        PsiBuilder.Marker property = this.builder.mark();
        if (this.isIdentifierToken(nameToken) && this.builder.lookAhead(1) != JSTokenTypes.COLON) {
            this.parseDestructuringElement();
            property.done(JSStubElementTypes.DESTRUCTURING_SHORTHANDED_PROPERTY);
            return;
        }
        if (!this.parsePropertyName()) {
            this.builder.advanceLexer();
            property.done(JSStubElementTypes.DESTRUCTURING_PROPERTY);
            return;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        IElementType valueFirstToken = this.builder.getTokenType();
        if (valueFirstToken == JSTokenTypes.LBRACE || valueFirstToken == JSTokenTypes.LBRACKET || this.isIdentifierToken(valueFirstToken)) {
            this.parseDestructuringElement();
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.lbrace.or.lbracket", new Object[0]));
        }
        property.done(JSStubElementTypes.DESTRUCTURING_PROPERTY);
    }

    public void parseDestructuringElement(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        if (varType == null) {
            ExpressionParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        IElementType elementType = this.parseDestructuringElementNoMarker(varType, parseType, isOuterParameterElement);
        marker.done(elementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IElementType parseDestructuringElementNoMarker(@NotNull IElementType varType, boolean parseType, boolean isOuterParameterElement) {
        if (varType == null) {
            ExpressionParser.$$$reportNull$$$0(1);
        }
        IElementType savedDestructuringVarType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
        try {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)varType);
            IElementType iElementType = this.parseDestructuringElementNoMarker(parseType, isOuterParameterElement);
            return iElementType;
        }
        finally {
            this.builder.putUserData(DESTRUCTURING_VAR_TYPE, (Object)savedDestructuringVarType);
        }
    }

    protected void parseDestructuringArrayElement() {
        this.parseDestructuringElement();
    }

    private void parseDestructuringElement() {
        PsiBuilder.Marker marker = this.builder.mark();
        marker.done(this.parseDestructuringElementNoMarker(false, false));
    }

    protected IElementType parseDestructuringElementNoMarker(boolean parseType, boolean isOuterParameterElement) {
        JSStubElementType elementType;
        IElementType firstToken = this.builder.getTokenType();
        boolean isSingleNameBinding = false;
        if (this.isIdentifierToken(firstToken)) {
            isSingleNameBinding = true;
            this.builder.advanceLexer();
        } else if (JSTokenTypes.LBRACE == firstToken) {
            this.parseObjectLiteralExpression(true);
        } else if (JSTokenTypes.LBRACKET == firstToken) {
            this.parseArrayLiteralExpression(true, true);
        } else {
            this.builder.advanceLexer();
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
        }
        if (isOuterParameterElement) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterOptionalMark();
        }
        if (parseType) {
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
        }
        if (isSingleNameBinding) {
            elementType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (elementType != null);
        } else {
            elementType = isOuterParameterElement ? JSStubElementTypes.DESTRUCTURING_PARAMETER : JSStubElementTypes.DESTRUCTURING_ELEMENT;
        }
        return elementType;
    }

    protected void parseObjectLiteralExpression(boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACE);
        ++this.myNestedObjectLiterals;
        if (this.myNestedObjectLiterals > MAX_TREE_DEPTH) {
            this.builder.advanceLexer();
            return;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        IElementType elementType = this.builder.getTokenType();
        while (elementType != JSTokenTypes.RBRACE && elementType != null) {
            if (elementType == JSTokenTypes.LPAR && this.isECMAL4()) {
                this.parseProperty();
            } else {
                if (!this.isPropertyStart(elementType)) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier.string.literal.or.numeric.literal", new Object[0]));
                    break;
                }
                if (isDestructuring) {
                    this.parseDestructuringProperty();
                } else {
                    this.parseProperty();
                }
            }
            while (this.myNestedObjectLiterals > MAX_TREE_DEPTH && this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                --this.myNestedObjectLiterals;
                this.builder.advanceLexer();
            }
            boolean wasCommaBefore = false;
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) break;
            if (elementType == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                wasCommaBefore = true;
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma", new Object[0]));
                if (elementType == JSTokenTypes.SEMICOLON) {
                    this.builder.advanceLexer();
                    wasCommaBefore = true;
                }
            }
            elementType = this.builder.getTokenType();
            if (elementType == JSTokenTypes.RBRACE) {
                if (wasCommaBefore) break;
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.property.expected", new Object[0]));
                continue;
            }
            if (this.isPropertyStart(elementType)) continue;
            break;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
        expr.done(isDestructuring ? JSStubElementTypes.DESTRUCTURING_OBJECT : JSStubElementTypes.OBJECT_LITERAL_EXPRESSION);
        --this.myNestedObjectLiterals;
    }

    protected boolean isPropertyStart(IElementType elementType) {
        return this.isPropertyNameStart(elementType) || elementType == JSTokenTypes.DOT || elementType == JSTokenTypes.DOT_DOT || elementType == JSTokenTypes.DOT_DOT_DOT;
    }

    public boolean isPropertyNameStart(IElementType elementType) {
        return JSKeywordSets.PROPERTY_NAMES.contains(elementType) || elementType == JSTokenTypes.LBRACKET;
    }

    public boolean parsePropertyName() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LBRACKET) {
            PsiBuilder.Marker computedPropertyMarker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
            computedPropertyMarker.done((IElementType)ES6StubElementTypes.COMPUTED_NAME);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            this.advancePropertyName(tokenType);
            return true;
        }
        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
        return false;
    }

    public void advancePropertyName(@Nullable IElementType tokenType) {
        if (!JSKeywordSets.NON_IDENTIFIER_PROPERTY_NAMES.contains(tokenType)) {
            this.advanceIdentifier(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    private void advanceIdentifier(@Nullable IElementType currentTokenType) {
        if (this.builder.getUserData(PROHIBIT_TOKEN_REMAPPING) != Boolean.TRUE && currentTokenType != JSTokenTypes.IDENTIFIER && currentTokenType != JSTokenTypes.PRIVATE_IDENTIFIER) {
            this.builder.remapCurrentToken(JSTokenTypes.IDENTIFIER);
        }
        this.builder.advanceLexer();
    }

    protected final void parseProperty() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (!this.parsePropertyNoMarker(mark)) {
            mark.drop();
        }
    }

    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        IElementType firstToken = this.builder.getTokenType();
        IElementType secondToken = this.builder.lookAhead(1);
        if (firstToken == JSTokenTypes.LBRACKET) {
            boolean lexerAdvanced = this.parsePropertyName();
            assert (lexerAdvanced) : "must be advanced after LBRACKET";
            if (this.builder.getTokenType() == JSTokenTypes.LPAR || this.builder.getTokenType() == JSTokenTypes.LT) {
                this.parseFunctionPropertyNoMarker(property, true);
            } else {
                this.parsePropertyInitializer(false);
                property.done((IElementType)ES6StubElementTypes.ES6_PROPERTY);
            }
            return true;
        }
        if (this.parseFunctionPropertyNoMarker(property, false)) {
            return true;
        }
        if (this.myJavaScriptParser.isIdentifierName(firstToken) && (secondToken == JSTokenTypes.COMMA || secondToken == JSTokenTypes.RBRACE || this.canBeIncompleteProperty(firstToken, secondToken))) {
            PsiBuilder.Marker ref2 = this.builder.mark();
            this.builder.advanceLexer();
            ref2.done(this.getNameReferenceElementType());
            property.done((IElementType)ES6StubElementTypes.ES6_PROPERTY);
            return true;
        }
        if (this.myJavaScriptParser.isIdentifierName(firstToken) && secondToken == JSTokenTypes.EQ) {
            PsiBuilder.Marker ref3 = this.builder.mark();
            this.builder.advanceLexer();
            ref3.done(this.getNameReferenceElementType());
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            property.done((IElementType)ES6StubElementTypes.ASSIGNMENT_PROPERTY);
            return true;
        }
        if (firstToken == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            this.parseAssignmentExpression(true);
            property.done(JSStubElementTypes.SPREAD_EXPRESSION);
            return true;
        }
        if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            String errorMessage = this.validateLiteral();
            this.advancePropertyName(firstToken);
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.property.name", new Object[0]));
            this.builder.advanceLexer();
        }
        this.parsePropertyInitializer(JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken));
        property.done(JSStubElementTypes.PROPERTY);
        property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    protected boolean canBeIncompleteProperty(@Nullable IElementType firstToken, @Nullable IElementType secondToken) {
        if (!ExpressionParser.hasLineTerminatorAfter(this.builder)) {
            return false;
        }
        return this.isPropertyNameStart(firstToken) && secondToken != JSTokenTypes.COLON && secondToken != JSTokenTypes.EQ;
    }

    protected void parsePropertyInitializer(boolean couldHaveComma) {
        if (!ExpressionParser.checkMatches(this.builder, JSTokenTypes.COLON, couldHaveComma ? "javascript.parser.message.expected.colon.or.comma" : "javascript.parser.message.expected.colon") && ExpressionParser.hasLineTerminatorBefore(this.builder)) {
            return;
        }
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    protected boolean isFunctionPropertyStart(@NotNull PsiBuilder builder2) {
        IElementType firstToken;
        if (builder2 == null) {
            ExpressionParser.$$$reportNull$$$0(2);
        }
        return JSKeywordSets.PROPERTY_NAMES.contains(firstToken = builder2.getTokenType()) && builder2.lookAhead(1) == JSTokenTypes.LPAR || firstToken == JSTokenTypes.LBRACKET;
    }

    protected boolean parseFunctionPropertyNoMarker(PsiBuilder.Marker property, boolean skipName) {
        boolean lexerAdvanced = false;
        EnumSet<JSModifiersStructure.JSModifiersParseResult> modifiers = EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class);
        if (!skipName) {
            modifiers = this.myJavaScriptParser.parseModifiers(FUNCTION_PROPERTY_MODIFIERS, true, this::isFunctionPropertyStart);
            lexerAdvanced = modifiers.contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            if (!lexerAdvanced && !this.isFunctionPropertyStart(this.builder)) {
                IElementType tokenType = this.builder.getTokenType();
                if ((tokenType == JSTokenTypes.ASYNC_KEYWORD || tokenType == JSTokenTypes.GET_KEYWORD || tokenType == JSTokenTypes.SET_KEYWORD || tokenType == JSTokenTypes.MULT) && JSKeywordSets.PROPERTY_NAMES.contains(this.builder.lookAhead(1))) {
                    ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpressionAttributeList();
                } else {
                    return false;
                }
            }
            lexerAdvanced |= this.parsePropertyName();
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> savedContext = JSParsingContextUtil.saveAndUpdateParsingContext(modifiers, this.builder);
        JSParsingContextUtil.restoreParsingContext(savedContext, this.builder);
        if (!(lexerAdvanced |= ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseParameterListAndBody(property, this.getFunctionPropertyElementType()))) {
            this.builder.advanceLexer();
        }
        return true;
    }

    protected IElementType getFunctionPropertyElementType() {
        return JSStubElementTypes.FUNCTION_PROPERTY;
    }

    private void parseArrayLiteralExpression(boolean allowSkippingLeadingElements, boolean isDestructuring) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected) {
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                if (!allowSkippingLeadingElements) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    PsiBuilder.Marker emptyMark = this.builder.mark();
                    emptyMark.done((IElementType)JSStubElementTypes.EMPTY_EXPRESSION);
                    this.builder.advanceLexer();
                }
            }
            commaExpected = false;
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) continue;
            if (isDestructuring) {
                this.parseDestructuringArrayElement();
            } else if (!this.parseArrayElement()) break;
            commaExpected = true;
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
        marker.done(isDestructuring ? JSStubElementTypes.DESTRUCTURING_ARRAY : JSElementTypes.ARRAY_LITERAL_EXPRESSION);
    }

    protected boolean parseArrayElement() {
        if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    public void parseParenthesizedExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker expr = this.builder.mark();
        this.builder.advanceLexer();
        if (!this.parseExpressionOptional(true)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
    }

    public boolean parseLeftHandSideExpression(Set<ParseLeftHandSideExpressionOptions> options) {
        IElementType tokenType;
        boolean isNew;
        PsiBuilder.Marker expr = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.SHARP && this.builder.getUserData(ALLOW_PIPE_TOPICS) == Boolean.TRUE) {
            this.builder.advanceLexer();
            expr.done((IElementType)JSStubElementTypes.EMPTY_EXPRESSION);
            expr = expr.precede();
            isNew = false;
            this.builder.putUserData(HAS_PIPE_TOPICS, (Object)true);
        } else if (type == JSTokenTypes.NEW_KEYWORD) {
            isNew = this.parseNewExpression();
        } else if (type == JSTokenTypes.COLON_COLON && this.shouldParseBindExpressions()) {
            this.builder.advanceLexer();
            this.parseLeftHandSideExpression(EnumSet.of(ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION));
            expr.done(ES6ElementTypes.BIND_EXPRESSION);
            expr = expr.precede();
            isNew = false;
        } else if (type == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.LPAR) {
            this.parseImportCall(expr);
            expr = expr.precede();
            isNew = false;
        } else if (type == JSTokenTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.DOT && this.builder.lookAhead(2) == JSTokenTypes.IDENTIFIER) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (!StringUtil.equals((CharSequence)"meta", (CharSequence)this.getTokenCharSequence())) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.meta", new Object[0]));
            }
            this.builder.advanceLexer();
            expr.done(ES6ElementTypes.META_PROPERTY);
            expr = expr.precede();
            isNew = false;
        } else {
            isNew = false;
            if (this.parseSpecialReference()) {
                expr.done(this.getNameReferenceElementType());
                expr = expr.precede();
            } else if (!this.parsePrimaryExpression()) {
                expr.drop();
                return false;
            }
        }
        IElementType requestedArgumentListType = null;
        while (true) {
            tokenType = this.builder.getTokenType();
            boolean parsedSuccessfully = true;
            IElementType safeAccessOperator = this.getSafeAccessOperator();
            if (this.isReferenceQualifierSeparator(tokenType)) {
                IElementType separatorType = tokenType;
                this.builder.advanceLexer();
                boolean hasAt = false;
                if (this.builder.getTokenType() == JSTokenTypes.AT) {
                    hasAt = true;
                    if (this.parseSpecialReference()) {
                        expr.done(this.getNameReferenceElementType());
                        expr = expr.precede();
                        continue;
                    }
                    this.builder.advanceLexer();
                }
                if ((tokenType = this.builder.getTokenType()) == JSTokenTypes.LBRACKET && hasAt && this.myJavaScriptParser.getDialect().hasE4XStandard()) continue;
                if (tokenType == JSTokenTypes.LPAR && this.myJavaScriptParser.getDialect().hasE4XStandard()) {
                    requestedArgumentListType = JSElementTypes.E4X_FILTER_QUERY_ARGUMENT_LIST;
                    continue;
                }
                if (tokenType == JSTokenTypes.ANY_IDENTIFIER || this.myJavaScriptParser.isIdentifierName(tokenType)) {
                    PsiBuilder.Marker identifier = this.builder.mark();
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                        identifier.done(this.getNameReferenceElementType());
                        this.proceedWithNamespaceReference(identifier.precede(), true);
                    } else {
                        identifier.drop();
                    }
                } else {
                    if (separatorType != null && separatorType == safeAccessOperator && (this.isParenAfterReferenceSeparator(tokenType) || tokenType == JSTokenTypes.LBRACKET)) continue;
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                }
                expr.done(this.getNameReferenceElementType());
                expr = expr.precede();
            } else if (!options.contains((Object)ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER) && tokenType == JSTokenTypes.LBRACKET) {
                this.builder.advanceLexer();
                this.parseExpression();
                ExpressionParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket");
                expr.done(JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
                expr = expr.precede();
            } else if (!options.contains((Object)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION) && tokenType == JSTokenTypes.LPAR) {
                if (requestedArgumentListType == null) {
                    this.parseArgumentList();
                } else {
                    PsiBuilder.Marker requestedArgumentListMarker = this.builder.mark();
                    this.parseArgumentListNoMarker();
                    requestedArgumentListMarker.done(requestedArgumentListType);
                }
                expr.done(isNew ? this.getNewExpressionElementType() : JSStubElementTypes.CALL_EXPRESSION);
                expr = expr.precede();
                isNew = false;
            } else if (tokenType == JSTokenTypes.BACKQUOTE) {
                this.parseStringTemplate();
                expr.done(ES6ElementTypes.TAGGED_TEMPLATE_EXPRESSION);
                expr = expr.precede();
            } else if (tokenType == JSTokenTypes.COLON_COLON && !options.contains((Object)ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION) && this.shouldParseBindExpressions()) {
                if (isNew) {
                    expr.done(this.getNewExpressionElementType());
                    expr = expr.precede();
                    isNew = false;
                }
                this.builder.advanceLexer();
                if (!this.parseLeftHandSideExpression(EnumSet.of(ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION))) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
                expr.done(ES6ElementTypes.BIND_EXPRESSION);
                expr = expr.precede();
            } else {
                Ref ref2 = Ref.create((Object)expr);
                parsedSuccessfully = this.parseDialectSpecificMemberExpressionPart((Ref<PsiBuilder.Marker>)ref2, options.contains((Object)ParseLeftHandSideExpressionOptions.IS_IN_EXTENDS_OR_IMPLEMENTS_LIST));
                if (parsedSuccessfully) {
                    expr = (PsiBuilder.Marker)ref2.get();
                }
            }
            if (!parsedSuccessfully) break;
        }
        if (isNew) {
            if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.dot", new Object[0]));
            }
            expr.done(this.getNewExpressionElementType());
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseSpecialReference() {
        return false;
    }

    protected boolean isParenAfterReferenceSeparator(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR;
    }

    public void parseImportCall(PsiBuilder.Marker expr) {
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.parseAssignmentExpression(false);
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RPAR) {
                this.parseAssignmentExpression(false);
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        expr.done((IElementType)ES6StubElementTypes.IMPORT_CALL);
    }

    @Nullable
    protected IElementType getSafeAccessOperator() {
        return null;
    }

    protected boolean shouldParseBindExpressions() {
        return !this.myJavaScriptParser.getDialect().hasFeature(JSLanguageFeature.REFERENCE_NAMESPACE);
    }

    private boolean hasE4XNamespaceQualifiers() {
        DialectOptionHolder dialect = this.myJavaScriptParser.getDialect();
        return dialect.hasFeature(JSLanguageFeature.E4X) && !dialect.hasFeature(JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON && this.hasE4XNamespaceQualifiers() || tokenType == JSTokenTypes.DOT_DOT && this.hasE4XNamespaceQualifiers();
    }

    protected IElementType getNewExpressionElementType() {
        return JSStubElementTypes.NEW_EXPRESSION;
    }

    protected IElementType getNameReferenceElementType() {
        return JSElementTypes.REFERENCE_EXPRESSION;
    }

    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        return false;
    }

    public boolean proceedWithNamespaceReference(PsiBuilder.Marker identifier, boolean expressionContext) {
        if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON && this.hasE4XNamespaceQualifiers()) {
            this.builder.advanceLexer();
            identifier.done(JSElementTypes.E4X_NAMESPACE_REFERENCE);
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType != JSTokenTypes.ANY_IDENTIFIER && !this.isIdentifierToken(tokenType)) {
                if (!expressionContext || tokenType != JSTokenTypes.LBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
                }
            } else {
                this.builder.advanceLexer();
            }
            return true;
        }
        identifier.drop();
        return false;
    }

    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression();
            marker.done(this.getNewExpressionElementType());
            return false;
        }
        this.builder.advanceLexer();
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.LT && this.isECMAL4()) {
            ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).parseECMA4GenericSignature();
            if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                this.parseArrayLiteralExpression(false, false);
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbracket", new Object[0]));
            }
            return true;
        }
        if (!this.parseLeftHandSideExpression(EnumSet.of(ParseLeftHandSideExpressionOptions.ONLY_MEMBER_EXPRESSION))) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                break;
            }
            this.builder.advanceLexer();
        }
        return true;
    }

    public void parseArgumentList() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        PsiBuilder.Marker arglist = this.builder.mark();
        this.parseArgumentListNoMarker();
        arglist.done(JSElementTypes.ARGUMENT_LIST);
    }

    protected void parseArgumentListNoMarker() {
        this.builder.advanceLexer();
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma.or.rparen", new Object[0]));
                break;
            }
            if (this.parseArgument()) continue;
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected boolean parseArgument() {
        return this.parseAssignmentExpression(true);
    }

    public void parseExpression() {
        if (!this.parseExpressionOptional()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public boolean parseAssignmentExpression(boolean allowIn) {
        if (this.builder.getTokenType() == JSTokenTypes.YIELD_KEYWORD && (JSParsingContextUtil.isGeneratorContext(this.builder) || ExpressionParser.isDefinitelyYieldExpression(this.builder.lookAhead(1)))) {
            this.parseYieldExpression();
            return true;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker definitionExpr = this.builder.mark();
        if (!this.parseConditionalExpression(allowIn)) {
            definitionExpr.drop();
            expr.drop();
            return false;
        }
        if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(this.builder.getTokenType())) {
            definitionExpr.done(JSStubElementTypes.DEFINITION_EXPRESSION);
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
        } else {
            definitionExpr.drop();
            expr.drop();
        }
        return true;
    }

    private static boolean isDefinitelyYieldExpression(IElementType tokenType) {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType) || JSTokenTypes.LITERALS.contains(tokenType) || tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.LBRACKET;
    }

    protected boolean parseConditionalExpression(boolean allowIn) {
        IElementType nextTokenType;
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseBinaryExpression(allowIn)) {
            if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            } else {
                expr.drop();
                return false;
            }
        }
        if ((nextTokenType = this.builder.getTokenType()) == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            ExpressionParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.CONDITIONAL_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    protected boolean parseBinaryExpression(boolean allowIn) {
        IElementType elementType;
        int priority;
        PsiBuilder.Marker currentMarker = this.builder.mark();
        if (!this.parseExponentialExpression()) {
            currentMarker.drop();
            return false;
        }
        if (this.getCurrentBinarySignPriority(allowIn, false) < 0) {
            currentMarker.drop();
            return true;
        }
        int depth = 0;
        ArrayDeque<MarkerData> markers = new ArrayDeque<MarkerData>();
        boolean tempStop = false;
        while ((priority = this.getCurrentBinarySignPriority(allowIn, false)) >= 0) {
            BinaryParsingState parsingState;
            boolean depthExceeded;
            IElementType type = this.builder.getTokenType();
            elementType = this.getBinaryExpressionElementType(type);
            boolean bl = depthExceeded = depth >= MAX_TREE_DEPTH;
            if (!(depthExceeded || markers.isEmpty() || ((MarkerData)markers.peek()).getPriority() < priority && !tempStop)) {
                int lastPriority;
                currentMarker.drop();
                PsiBuilder.Marker lastPoppedMarker = null;
                while (!markers.isEmpty() && ((MarkerData)markers.peek()).getPriority() > priority) {
                    MarkerData markerData = (MarkerData)markers.pop();
                    lastPoppedMarker = markerData.getMarker();
                    lastPoppedMarker.done(markerData.getElementType());
                }
                int n = lastPriority = markers.isEmpty() ? -1 : ((MarkerData)markers.peek()).getPriority();
                if (lastPriority == priority || tempStop && !markers.isEmpty()) {
                    MarkerData markerData = (MarkerData)markers.pop();
                    PsiBuilder.Marker lastMarker = markerData.getMarker();
                    lastMarker.done(markerData.getElementType());
                    PsiBuilder.Marker precede = lastMarker.precede();
                    markers.push(new MarkerData(priority, precede, elementType));
                } else {
                    assert (lastPriority < priority);
                    assert (lastPoppedMarker != null);
                    PsiBuilder.Marker precede = lastPoppedMarker.precede();
                    markers.push(new MarkerData(priority, precede, elementType));
                }
            } else if (!depthExceeded) {
                markers.push(new MarkerData(priority, currentMarker, elementType));
            }
            tempStop = false;
            this.getCurrentBinarySignPriority(allowIn, true);
            if (!depthExceeded) {
                currentMarker = this.builder.mark();
            }
            if (type == JSTokenTypes.PIPE) {
                this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)true);
                this.builder.putUserData(HAS_PIPE_TOPICS, (Object)false);
            }
            if ((parsingState = this.parseBinaryRightHandSide(type)) == BinaryParsingState.FAIL || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            if (parsingState == BinaryParsingState.STOP || parsingState == BinaryParsingState.FAIL_AND_STOP) {
                tempStop = true;
            }
            ++depth;
        }
        currentMarker.drop();
        while (!markers.isEmpty()) {
            MarkerData markerData = (MarkerData)markers.pop();
            elementType = markerData.getElementType();
            markerData.getMarker().done(elementType);
            if (elementType != JSElementTypes.PIPE_EXPRESSION) continue;
            this.builder.putUserData(ALLOW_PIPE_TOPICS, (Object)false);
        }
        return true;
    }

    private boolean parseExponentialExpression() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = this.parseUnaryExpression();
        if (this.builder.getTokenType() == JSTokenTypes.MULTMULT) {
            this.builder.advanceLexer();
            result2 = this.parseExponentialExpression();
            marker.done(JSElementTypes.BINARY_EXPRESSION);
        } else {
            marker.drop();
        }
        return result2;
    }

    protected IElementType getBinaryExpressionElementType(IElementType signType) {
        if (signType == JSTokenTypes.PIPE) {
            return JSElementTypes.PIPE_EXPRESSION;
        }
        return JSElementTypes.BINARY_EXPRESSION;
    }

    protected BinaryParsingState parseBinaryRightHandSide(IElementType type) {
        return this.parseExponentialExpression() ? BinaryParsingState.OK : BinaryParsingState.FAIL;
    }

    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int result2 = -1;
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.OROR || tokenType == JSTokenTypes.QUEST_QUEST) {
            result2 = 0;
        } else if (tokenType == JSTokenTypes.ANDAND) {
            result2 = 1;
        } else if (tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.PIPE) {
            result2 = 2;
        } else if (tokenType == JSTokenTypes.XOR) {
            result2 = 3;
        } else if (tokenType == JSTokenTypes.AND) {
            result2 = 4;
        } else if (JSTokenTypes.EQUALITY_OPERATIONS.contains(tokenType)) {
            result2 = 5;
        } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(tokenType) && (allowIn || this.builder.getTokenType() != JSTokenTypes.IN_KEYWORD)) {
            result2 = 6;
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(tokenType)) {
            result2 = 7;
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(tokenType)) {
            result2 = 8;
        } else if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(tokenType)) {
            result2 = 9;
        }
        if (advance && result2 >= 0) {
            this.builder.advanceLexer();
        }
        return result2;
    }

    protected boolean parseUnaryExpression() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSTokenTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            expr.done(JSElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parsePostfixExpression();
    }

    protected boolean parsePostfixExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseLeftHandSideExpression(EnumSet.noneOf(ParseLeftHandSideExpressionOptions.class))) {
            expr.drop();
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(tokenType != JSTokenTypes.PLUSPLUS && tokenType != JSTokenTypes.MINUSMINUS || ExpressionParser.hasLineTerminatorBefore(this.builder))) {
            this.builder.advanceLexer();
            expr.done(JSElementTypes.POSTFIX_EXPRESSION);
        } else {
            expr.drop();
        }
        return true;
    }

    public boolean parseExpressionOptional() {
        return this.parseExpressionOptional(true);
    }

    public boolean parseExpressionOptional(boolean allowIn) {
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.parseAssignmentExpression(allowIn)) {
            expr.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD) {
            expr.done(JSStubElementTypes.DEFINITION_EXPRESSION);
            return true;
        }
        int nestingLevel = 0;
        while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(allowIn)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            }
            if (nestingLevel < MAX_TREE_DEPTH) {
                expr.done(JSElementTypes.COMMA_EXPRESSION);
                expr = expr.precede();
            }
            ++nestingLevel;
        }
        expr.drop();
        return true;
    }

    public void parseSimpleExpression() {
        if (!this.parseUnaryExpression()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    public void parseScriptExpression() {
        this.parseScriptExpression(true);
    }

    public void parseScriptExpression(boolean isEmbeddedToken) {
        PsiBuilder.Marker root = this.builder.mark();
        ExpressionParser.checkMatches(this.builder, JSTokenTypes.XML_LBRACE, "javascript.parser.message.expected.lbrace");
        DialectOptionHolder dialect = this.myJavaScriptParser.getDialect();
        if (dialect == DialectOptionHolder.ECMA_4) {
            this.parseExpression();
        } else {
            this.parseArgument();
        }
        if (isEmbeddedToken) {
            ExpressionParser.checkMatches(this.builder, JSTokenTypes.XML_RBRACE, "javascript.parser.message.expected.rbrace");
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
        } else if (!ExpressionParser.checkMatches(this.builder, JSTokenTypes.XML_RBRACE, "javascript.parser.message.expected.rbrace")) {
            while (!this.builder.eof()) {
                IElementType tokenType = this.builder.getTokenType();
                this.builder.advanceLexer();
                if (tokenType != JSTokenTypes.XML_RBRACE) continue;
                break;
            }
        }
        root.done(JSStubElementTypes.EMBEDDED_EXPRESSION);
    }

    public void parseTypeInEmbeddedTypeContext() {
        PsiBuilder.Marker root = this.builder.mark();
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).parseType();
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        root.done(JSStubElementTypes.EMBEDDED_EXPRESSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/parsing/ExpressionParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDestructuringElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDestructuringElementNoMarker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionPropertyStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ParseLeftHandSideExpressionOptions {
        ONLY_MEMBER_EXPRESSION,
        DISALLOW_INDEXER,
        IS_IN_EXTENDS_OR_IMPLEMENTS_LIST;

    }

    private static final class MarkerData {
        private final int myPriority;
        private final PsiBuilder.Marker myMarker;
        private final IElementType myElementType;

        public int getPriority() {
            return this.myPriority;
        }

        public PsiBuilder.Marker getMarker() {
            return this.myMarker;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        MarkerData(int priority, PsiBuilder.Marker marker, IElementType elementType) {
            this.myPriority = priority;
            this.myMarker = marker;
            this.myElementType = elementType;
        }
    }

    protected static enum BinaryParsingState {
        FAIL,
        OK,
        STOP,
        FAIL_AND_STOP;

    }
}

