/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSSimpleFileReferenceRootsProviderKt;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJC\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/MonorepoPackageReferenceContributor;", "Lcom/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor;", "<init>", "()V", "getAllReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedRefText", "", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;)[Lcom/intellij/psi/PsiReference;", "buildReferences", "substitutions", "", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/psi/PsiElement;ILcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/psi/PsiReference;", "isApplicable", "", "intellij.javascript.impl"})
public final class MonorepoPackageReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)unquotedRefText, (String)"unquotedRefText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(host.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)yarnPnpManager, (String)"getInstance(...)");
        YarnPnpManager pnpManager = yarnPnpManager;
        if (!pnpManager.hasPnpFiles()) {
            return new PsiReference[0];
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)host);
        if (virtualFile == null) {
            return new PsiReference[0];
        }
        VirtualFile requestor = virtualFile;
        String string = NodeModuleSearchUtil.extractDependencyName(unquotedRefText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
        String dependencyName = string;
        Project project = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        YarnPnpDependency dependency = JSSimpleFileReferenceRootsProviderKt.findYarnPnpDependency(project, requestor, dependencyName, pnpManager, true);
        if (dependency == null || !dependency.isWorkspaceLocation()) {
            return new PsiReference[0];
        }
        char[] cArray = new char[]{'/'};
        if (StringsKt.endsWith$default((String)StringsKt.trimEnd((String)dependency.getLocation(), (char[])cArray), (String)dependencyName, (boolean)false, (int)2, null)) {
            return new PsiReference[0];
        }
        VirtualFile virtualFile2 = dependency.resolveLocation();
        if (virtualFile2 == null) {
            return new PsiReference[0];
        }
        VirtualFile packageRoot = virtualFile2;
        VirtualFile virtualFile3 = packageRoot.getParent();
        if (virtualFile3 == null) {
            return new PsiReference[0];
        }
        VirtualFile packageRootParentDir = virtualFile3;
        String string2 = packageRoot.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String fileSystemPath = string2;
        Object[] objectArray = new JSModulePathSubstitutionImpl[]{new JSModulePathSubstitutionImpl(dependencyName, fileSystemPath), new JSModulePathSubstitutionImpl(dependencyName + "/*", fileSystemPath + "/*")};
        List substitutions = CollectionsKt.listOf((Object[])objectArray);
        return this.buildReferences(unquotedRefText, substitutions, host, offset, packageRootParentDir);
    }

    private final PsiReference[] buildReferences(String unquotedRefText, List<? extends JSModulePathSubstitution> substitutions, PsiElement host, int offset, VirtualFile moduleRoot) {
        JSDefaultFileReferenceContext context2 = new JSDefaultFileReferenceContext(unquotedRefText, host, moduleRoot, substitutions){
            final /* synthetic */ VirtualFile $moduleRoot;
            final /* synthetic */ List<JSModulePathSubstitution> $substitutions;
            {
                this.$moduleRoot = $moduleRoot;
                this.$substitutions = $substitutions;
                super($unquotedRefText, $host, null);
            }

            public List<VirtualFile> getDefaultRoots(Project project, String moduleName, VirtualFile contextFile) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
                return CollectionsKt.emptyList();
            }

            public Collection<VirtualFile> getMappingRoots() {
                return CollectionsKt.listOf((Object)this.$moduleRoot);
            }

            public JSModulePathMappings<JSModulePathSubstitution> pathsMappings() {
                return JSModulePathMappings.Companion.build((Collection)this.$substitutions);
            }
        };
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(unquotedRefText, context2, host, offset).getAllReferences();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
        return (PsiReference[])fileReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return true;
    }
}

