/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptASTFactory;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptParserDefinition
extends ASTFactory
implements ParserDefinition {
    private static final JavascriptASTFactory ourAstFactory = new JavascriptASTFactory();

    @NotNull
    public Lexer createLexer(Project project) {
        return new JSFlexAdapter(DialectOptionHolder.JS_WITH_JSX);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        JSFileElementType jSFileElementType = JSFileElementTypes.FILE;
        if (jSFileElementType == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(0);
        }
        return jSFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSTokenTypes.COMMENTS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavascriptParserDefinition.this.createJSParser(builder2).parseJS(root);
                ASTNode aSTNode = builder2.getTreeBuilt();
                if (aSTNode == null) {
                    1.$$$reportNull$$$0(2);
                }
                return aSTNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parse";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "parse";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public JavaScriptParser<?, ?, ?, ?> createJSParser(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(4);
        }
        return new JSXParser(JavaScriptSupportLoader.ECMA_SCRIPT_6, builder2);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(5);
        }
        return new JSFileImpl(viewProvider, this.getFileNodeType().getLanguage());
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == JSTokenTypes.XML_LBRACE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(8);
            }
            return spaceRequirements;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        if (spaceRequirements == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(9);
        }
        return spaceRequirements;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Object element;
        IElementType type;
        if (node == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(10);
        }
        if (JSElementTypes.XML_LITERAL_EXPRESSION == (type = node.getElementType())) {
            if (!(node instanceof PsiElement)) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            PsiElement psiElement = (PsiElement)node;
            if (psiElement == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(11);
            }
            return psiElement;
        }
        if (type instanceof PsiGenerator && (element = ((PsiGenerator)type).construct(node)) != null) {
            Object t = element;
            if (t == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(12);
            }
            return t;
        }
        if (type == JSTokenTypes.DOC_COMMENT) {
            return new JSDocCommentImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    @Nullable
    public CompositeElement createComposite(@NotNull IElementType type) {
        if (type == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(13);
        }
        if (type == JSElementTypes.XML_TEXT || type == JSElementTypes.XML_ATTRIBUTE_VALUE) {
            return ourAstFactory.createComposite(type);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 10, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJSParser";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 10, 13 -> new IllegalArgumentException(string);
        };
    }
}

