/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.impl.JSimportUtilKt;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMembersFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ClassMemberCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final String GET_PREFIX = "$get$_";
    private static final String SET_PREFIX = "$set$_";
    public static final NotNullLazyValue<Icon> IMPLEMENTATION = NotNullLazyValue.atomicLazy(() -> ES6ClassMemberCompletionProvider.getImplCompletionIcon(true));
    public static final NotNullLazyValue<Icon> OVERRIDE = NotNullLazyValue.atomicLazy(() -> ES6ClassMemberCompletionProvider.getImplCompletionIcon(false));

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        HashSet<String> existingMembers;
        PsiElement parent;
        PsiElement typeMember;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((typeMember = ES6ClassMemberCompletionProvider.findTypeMember(parent = parameters.getPosition().getParent())) == null) {
            return;
        }
        JSClass containingClass = JSUtils.getMemberContainingClass(typeMember);
        if (containingClass == null || containingClass instanceof TypeScriptEnum) {
            return;
        }
        boolean isTypeScript = DialectDetector.isTypeScript(containingClass);
        Set<JSAttributeList.ModifierType> modifiers = ES6ClassMemberCompletionProvider.getModifiers(parameters);
        boolean withOverride = modifiers.contains((Object)JSAttributeList.ModifierType.OVERRIDE);
        JSAttributeList.AccessType explicitAccessType = (JSAttributeList.AccessType)((Object)ObjectUtils.coalesce((Object)((Object)ES6ClassMemberCompletionProvider.getExplicitAccessType(parameters)), (Object)((Object)(withOverride ? JSAttributeList.AccessType.PUBLIC : null))));
        if (explicitAccessType == JSAttributeList.AccessType.PRIVATE) {
            return;
        }
        HashSet<String> hashSet = existingMembers = typeMember instanceof JSFunction ? null : new HashSet<String>();
        if (!(typeMember instanceof JSFunction)) {
            PsiElement originalField = CompletionUtil.getOriginalOrSelf((PsiElement)typeMember);
            for (JSElement jSElement : containingClass.getMembers()) {
                String name = jSElement.getName();
                if (name == null || jSElement == originalField) continue;
                existingMembers.add(ES6ClassMemberCompletionProvider.prefixName(jSElement, name));
            }
        }
        String nameToCheck = typeMember instanceof JSFunction ? ((JSFunction)typeMember).getName() : null;
        HashSet<Object> forCompletion = new HashSet<Object>();
        HashMap hashMap = new HashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> {
            if (aClass.isEquivalentTo(containingClass) || fromImplements && withOverride) {
                return true;
            }
            for (JSFunction jSFunction : aClass.getFunctions()) {
                if (jSFunction.isConstructor() || ES6ClassMemberCompletionProvider.isPrivate(jSFunction) || explicitAccessType != null && jSFunction.getAccessType() != explicitAccessType || nameToCheck != null && !nameToCheck.equals(jSFunction.getName())) continue;
                ES6ClassMemberCompletionProvider.addIfValid(existingMembers, forCompletion, jSFunction);
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            if (!isTypeScript || nameToCheck != null) {
                return true;
            }
            for (JSQualifiedNamedElement jSQualifiedNamedElement : aClass.getFields()) {
                if (ES6ClassMemberCompletionProvider.isPrivate((JSAttributeListOwner)((Object)jSQualifiedNamedElement)) || explicitAccessType != null && jSQualifiedNamedElement.getAccessType() != explicitAccessType) continue;
                ES6ClassMemberCompletionProvider.addIfValid(existingMembers, forCompletion, jSQualifiedNamedElement);
            }
            return true;
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        Map infos = withOverride || explicitAccessType != null && explicitAccessType != JSAttributeList.AccessType.PUBLIC ? Map.of() : TypeScriptUtil.getMemberInfos(containingClass, true);
        for (TypeScriptMemberInfo info : infos.keySet()) {
            Object element;
            if (info.getKind() != TypeScriptMemberInfo.Kind.UNIMPLEMENTED || (element = info.getElement()).getName() == null) continue;
            forCompletion.add(element);
        }
        boolean useOverridesCompletion = JSApplicationSettings.getInstance().isUseOverridesCompletion();
        JSTypeSubstitutor substitutor = null;
        for (JSTypeSubstitutor value : hashMap.values()) {
            if (substitutor == null) {
                substitutor = value;
                continue;
            }
            substitutor = JSTypeSubstitutorImpl.combine(substitutor, value);
        }
        JSTypeSubstitutor finalSubstitutor = substitutor;
        boolean isCompetingParameters = parent instanceof JSParameter;
        forCompletion.forEach(el -> result2.consume(ES6ClassMemberCompletionProvider.createLookupElement(el, containingClass, useOverridesCompletion, new JSLookupContext(parent, finalSubstitutor), parameters, isCompetingParameters && el instanceof JSFunction)));
    }

    @Nullable
    private static PsiElement findTypeMember(@Nullable PsiElement parent) {
        PsiElement grand;
        if (parent instanceof JSField) {
            return parent;
        }
        if (parent instanceof JSParameter && (grand = parent.getParent()) instanceof JSParameterList) {
            JSParameterListElement[] allParams = ((JSParameterList)grand).getParameters();
            if (allParams.length != 1 || allParams[0] != parent) {
                return null;
            }
            return (PsiElement)ObjectUtils.tryCast((Object)grand.getParent(), JSFunction.class);
        }
        return null;
    }

    private static String prefixName(JSElement o, String name) {
        if (o instanceof JSFunction) {
            if (((JSFunction)o).isGetProperty()) {
                name = GET_PREFIX + (String)name;
            }
            if (((JSFunction)o).isSetProperty()) {
                name = SET_PREFIX + (String)name;
            }
        }
        return name;
    }

    private static void addIfValid(@Nullable HashSet<String> existingMembers, HashSet<JSElement> forCompletion, JSQualifiedNamedElement function) {
        JSContext jsContext;
        String name = function.getName();
        if (name != null && (existingMembers == null || existingMembers.add(ES6ClassMemberCompletionProvider.prefixName(function, name))) && (jsContext = function.getJSContext()) != JSContext.STATIC) {
            forCompletion.add(function);
        }
    }

    private static boolean isPrivate(JSAttributeListOwner function) {
        JSAttributeList attributeList = function.getAttributeList();
        return attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    private static LookupElement createLookupElement(@NotNull JSElement function, @NotNull JSClass containingClass, boolean useOverridesCompletion, @NotNull JSLookupContext context2, @NotNull CompletionParameters parameters, boolean paramsOnly) {
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(6);
        }
        String name = function.getName();
        assert (name != null);
        LookupElementBuilder element = LookupElementBuilder.create((Object)function, (String)name).withLookupString(function.getName());
        if (!useOverridesCompletion) {
            return element;
        }
        JSLookupElementRenderer renderer = ES6ClassMemberCompletionProvider.getRenderer((PsiElement)function, containingClass, context2, name, false, paramsOnly);
        return element.withRenderer((LookupElementRenderer)renderer).withExpensiveRenderer(renderer.getExpensiveRenderer()).withInsertHandler(ES6ClassMemberCompletionProvider.createInsertHandler((PsiElement)function, containingClass, name, parameters, paramsOnly));
    }

    @NotNull
    static JSLookupElementRenderer getRenderer(@NotNull PsiElement function, @Nullable JSClass containingClass, @NotNull JSLookupContext context2, @NotNull String name, boolean partial, boolean paramsOnly) {
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(8);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(9);
        }
        String nameTail = null;
        Object nameHead = "";
        if (function instanceof JSFunction && !paramsOnly) {
            nameTail = "{...}";
            if (((JSFunction)function).isGetProperty()) {
                nameHead = (String)nameHead + "get ";
            }
            if (((JSFunction)function).isSetProperty()) {
                nameHead = (String)nameHead + "set ";
            }
        }
        Icon icon = paramsOnly ? JSLookupUtilImpl.IconHolder.ourParamParamIcon : ES6ClassMemberCompletionProvider.getIcon(function, containingClass);
        return new JSLookupElementRenderer((String)nameHead + name, JSLookupPriority.SMART_PRIORITY, partial, icon, nameTail, context2, paramsOnly);
    }

    @Nullable
    private static Icon getIcon(@NotNull PsiElement psiElement, @Nullable PsiElement classOfInsertionContext) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(10);
        }
        boolean implemented = false;
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && sourceClass.isInterface()) {
            implemented = true;
        }
        return implemented ? (Icon)IMPLEMENTATION.getValue() : (Icon)OVERRIDE.getValue();
    }

    @NotNull
    private static Icon getImplCompletionIcon(boolean implemented) {
        Icon icon = implemented ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
        Icon empty2 = JSLookupUtilImpl.getEmptyIcon();
        Icon icon2 = IconUtil.toSize((Icon)icon, (int)empty2.getIconWidth(), (int)empty2.getIconHeight());
        if (icon2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    @NotNull
    private static Set<JSAttributeList.ModifierType> getModifiers(@NotNull CompletionParameters parameters) {
        JSAttributeList list;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(12);
        }
        if ((list = ES6ClassMemberCompletionProvider.getFieldAttributeList(parameters)) == null) {
            Set<JSAttributeList.ModifierType> set = Collections.emptySet();
            if (set == null) {
                ES6ClassMemberCompletionProvider.$$$reportNull$$$0(13);
            }
            return set;
        }
        EnumSet<JSAttributeList.ModifierType> modifiers = EnumSet.noneOf(JSAttributeList.ModifierType.class);
        for (JSAttributeList.ModifierType value : JSAttributeList.ModifierType.values()) {
            if (!list.hasModifier(value)) continue;
            modifiers.add(value);
        }
        EnumSet<JSAttributeList.ModifierType> enumSet = modifiers;
        if (enumSet == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(14);
        }
        return enumSet;
    }

    @Nullable
    public static JSAttributeList getFieldAttributeList(@NotNull CompletionParameters parameters) {
        PsiElement position;
        JSField field;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(15);
        }
        if ((field = (JSField)ObjectUtils.tryCast((Object)(position = parameters.getPosition()).getParent(), JSField.class)) == null) {
            return null;
        }
        JSAttributeList list = field.getAttributeList();
        return list;
    }

    @Nullable
    private static JSAttributeList.AccessType getExplicitAccessType(@NotNull CompletionParameters parameters) {
        JSAttributeList list;
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(16);
        }
        return (list = ES6ClassMemberCompletionProvider.getFieldAttributeList(parameters)) == null ? null : list.getExplicitAccessType();
    }

    static InsertHandler<LookupElement> createInsertHandler(final @NotNull PsiElement psiElement, @NotNull PsiElement classOfInsertionContext, @NotNull String name, @NotNull CompletionParameters parameters, boolean paramsOnly) {
        JSClass sourceClass;
        if (psiElement == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(17);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(18);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(20);
        }
        if (!(psiElement instanceof JSFunction)) {
            return (context2, item) -> {};
        }
        if (classOfInsertionContext instanceof JSClass && (sourceClass = JSResolveUtil.getClassOfContext(psiElement)) != null && !sourceClass.isInterface()) {
            final Set<JSAttributeList.ModifierType> existingModifiers = ES6ClassMemberCompletionProvider.getModifiers(parameters);
            final JSAttributeList.AccessType accessType = ES6ClassMemberCompletionProvider.getExplicitAccessType(parameters);
            return (context2, item) -> {
                OverrideMethodsFix fix = new OverrideMethodsFix((JSClass)classOfInsertionContext){

                    @Override
                    public Set<JSQualifiedNamedElement> getElementsToProcess() {
                        return Set.of((JSFunction)psiElement);
                    }

                    @Override
                    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSQualifiedNamedElement qElement) {
                        super.adjustAttributeList(attributeListWrapper, qElement);
                        for (JSAttributeList.ModifierType modifier : existingModifiers) {
                            attributeListWrapper.overrideModifier(modifier, false);
                        }
                        if (accessType != null) {
                            attributeListWrapper.removeAccessModifier();
                        }
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((JSFunction)psiElement, name, context2, fix, classOfInsertionContext, paramsOnly);
            };
        }
        if (psiElement instanceof TypeScriptFunction) {
            return (ctx, item) -> {
                TypeScriptImplementMembersFix fix = new TypeScriptImplementMembersFix(classOfInsertionContext, false){

                    @Override
                    public Set<TypeScriptFunction> getElementsToProcess() {
                        return Set.of((TypeScriptFunction)psiElement);
                    }
                };
                ES6ClassMemberCompletionProvider.insertFunctionText((TypeScriptFunction)psiElement, name, ctx, fix, classOfInsertionContext, paramsOnly);
            };
        }
        return (ctx, item) -> {
            String bodyText = ImplementJSDocMethodsFix.formatFunction(classOfInsertionContext, psiElement.getProject(), new JSMethodToImplement((JSFunction)psiElement, false, ""));
            ES6ClassMemberCompletionProvider.insertFunctionText(name, ctx, bodyText, classOfInsertionContext);
        };
    }

    private static <T extends JSElement> void insertFunctionText(@NotNull T function, @NotNull String name, @NotNull InsertionContext context2, @NotNull BaseCreateMembersFix<T> fix, @NotNull PsiElement classOfInsertionContext, boolean paramsOnly) {
        String functionText;
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(21);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(23);
        }
        if (fix == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(24);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(25);
        }
        if ((functionText = (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)context2.getFile(), () -> fix.buildFunctionText(function, null))) != null) {
            if (paramsOnly) {
                ES6ClassMemberCompletionProvider.insertParametersText(function, name, context2, functionText);
            } else {
                ES6ClassMemberCompletionProvider.insertFunctionText(name, context2, functionText, classOfInsertionContext);
            }
        }
    }

    private static <T extends JSElement> void insertParametersText(@NotNull T function, @NotNull String name, @NotNull InsertionContext context2, String functionText) {
        int lBrace;
        if (function == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(26);
        }
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(27);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(28);
        }
        if ((lBrace = functionText.indexOf(123)) == -1) {
            return;
        }
        String signature = functionText.substring(0, lBrace);
        int lPar = signature.indexOf(40);
        int rPar = signature.lastIndexOf(41);
        if (lPar == -1 || rPar == -1) {
            return;
        }
        Document document = context2.getDocument();
        int offset = context2.getStartOffset();
        document.replaceString(offset, offset + name.length(), (CharSequence)"");
        String listText = signature.substring(lPar + 1, rPar);
        document.insertString(offset, (CharSequence)listText);
        FormatFixer.create(function.getContainingFile(), new TextRange(offset, offset + listText.length()), context2.getDocument(), FormatFixer.Mode.Reformat).fixFormat();
    }

    private static void insertFunctionText(@NotNull String name, @NotNull InsertionContext context2, @NotNull String functionText, @NotNull PsiElement classOfInsertionContext) {
        int indexOfName;
        if (name == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(29);
        }
        if (context2 == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(30);
        }
        if (functionText == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(31);
        }
        if (classOfInsertionContext == null) {
            ES6ClassMemberCompletionProvider.$$$reportNull$$$0(32);
        }
        String prefix = (indexOfName = functionText.indexOf(name + "(")) > 0 ? functionText.substring(0, indexOfName) : "";
        String restText = functionText.substring(prefix.length() + name.length());
        int startOffset = context2.getEditor().getCaretModel().getOffset();
        Document document = context2.getDocument();
        document.insertString(startOffset, (CharSequence)restText);
        if (!prefix.isEmpty()) {
            String toInsert = classOfInsertionContext instanceof JSObjectLiteralExpression ? StringUtil.trimStart((String)prefix, (String)"public ") : prefix;
            document.insertString(context2.getStartOffset(), (CharSequence)toInsert);
            startOffset = context2.getStartOffset();
        }
        context2.commitDocument();
        TextRange finalRange = new TextRange(startOffset, startOffset + restText.length() + prefix.length() + (prefix.isEmpty() ? 0 : name.length()));
        FormatFixer.create(context2.getFile(), finalRange, document, FormatFixer.Mode.Reformat).fixFormat();
        JSFunction func = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(startOffset), JSFunction.class);
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)func, JSBlockStatement.class);
        if (block != null) {
            JSSourceElement[] statements = block.getStatementListItems();
            if (statements.length == 1) {
                JSSourceElement statement = statements[0];
                TextRange range = statement.getTextRange();
                context2.getEditor().getCaretModel().moveToOffset(range.getStartOffset());
                context2.getEditor().getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            } else {
                context2.getEditor().getCaretModel().moveToOffset(block.getFirstChild().getTextOffset() + 1);
            }
        }
        JSimportUtilKt.applyUnambiguousImportsAsync(context2.getProject(), finalRange, context2.getDocument(), context2.getEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 23: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 7: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 9: 
            case 19: 
            case 22: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
                break;
            }
            case 18: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOfInsertionContext";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6ClassMemberCompletionProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplCompletionIcon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModifiers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAttributeList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitAccessType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createInsertHandler";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "insertFunctionText";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "insertParametersText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

