/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.insight;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.javascript.testing.JSTestRunnerManager;
import com.intellij.javascript.testing.insight.SelectInTestTreeAction;
import com.intellij.javascript.testing.runConfiguration.JSTestLocation;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/testing/insight/JSTestRunLineMarkersProvider;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "<init>", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "location", "Lcom/intellij/javascript/testing/runConfiguration/JSTestLocation;", "configurationFactories", "", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getAdditionalActions", "getIcon", "Ljavax/swing/Icon;", "elementPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSTestRunLineMarkersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTestRunLineMarkersProvider.kt\ncom/intellij/javascript/testing/insight/JSTestRunLineMarkersProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n1619#2:75\n1863#2:76\n1864#2:78\n1620#2:79\n1#3:77\n37#4,2:80\n*S KotlinDebug\n*F\n+ 1 JSTestRunLineMarkersProvider.kt\ncom/intellij/javascript/testing/insight/JSTestRunLineMarkersProvider\n*L\n33#1:75\n33#1:76\n33#1:78\n33#1:79\n33#1:77\n43#1:80,2\n*E\n"})
public final class JSTestRunLineMarkersProvider
extends RunLineMarkerContributor {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof LeafPsiElement) || !((LeafPsiElement)element).isValid()) {
            return null;
        }
        Object object = ((LeafPsiElement)element).getContainingFile();
        JSFile jSFile = object instanceof JSFile ? (JSFile)object : null;
        if (jSFile == null) {
            return null;
        }
        JSFile containingFile = jSFile;
        if (!containingFile.isTestFile()) {
            return null;
        }
        Set<JsTestRunConfigurationProducer<?>> set = JSTestRunnerManager.getInstance().findProducers(containingFile);
        Intrinsics.checkNotNullExpressionValue(set, (String)"findProducers(...)");
        object = set;
        Collection collection = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            ConfigurationFactory it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            JsTestRunConfigurationProducer it = (JsTestRunConfigurationProducer)((Object)element$iv);
            boolean bl2 = false;
            if (it.getConfigurationFactory() == null) continue;
            boolean bl3 = false;
            collection.add(it$iv);
        }
        HashSet configurationFactories = (HashSet)collection;
        if (configurationFactories.isEmpty()) {
            return null;
        }
        for (AbstractTestFileStructureBuilder abstractTestFileStructureBuilder : JsTestFileIndexingHandler.getFileStructureBuildersForFile(containingFile)) {
            Object t = abstractTestFileStructureBuilder.fetchCachedTestFileStructure(containingFile);
            if (t == null || (t = ((AbstractTestFileStructure)t).findTestElementPath(element)) == null) continue;
            Object testElementPath = t;
            List<AnAction> actions = this.createActions(JSTestLocation.Companion.fromTestElementPath((JsTestElementPath)testElementPath), configurationFactories);
            Collection $this$toTypedArray$iv = actions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new RunLineMarkerContributor.Info(this.getIcon((JsTestElementPath)testElementPath), thisCollection$iv.toArray(new AnAction[0]), RunLineMarkerContributor.RUN_TEST_TOOLTIP_PROVIDER);
        }
        return null;
    }

    private final List<AnAction> createActions(JSTestLocation location, Set<? extends ConfigurationFactory> configurationFactories) {
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)ExecutorAction.Companion.getActionList$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null), (Iterable)CollectionsKt.listOf((Object)((Object)new SelectInTestTreeAction(location, configurationFactories)))), (Iterable)this.getAdditionalActions());
    }

    private final List<AnAction> getAdditionalActions() {
        AnAction anAction = ActionManager.getInstance().getAction("JSTestRunLineMarkersAdditionalActionGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup additionalActionGroup = (ActionGroup)anAction;
        AnAction[] anActionArray = additionalActionGroup.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildren(...)");
        return ArraysKt.toList((Object[])anActionArray);
    }

    private final Icon getIcon(JsTestElementPath elementPath) {
        Icon icon;
        TestStateInfo.Magnitude magnitude;
        TestStateStorage instance = TestStateStorage.getInstance((Project)elementPath.getTestElement().getProject());
        TestStateStorage.Record state = instance.getState(JSTestFailedLineManager.locationUrl(elementPath, false));
        if (state == null) {
            state = instance.getState(JSTestFailedLineManager.locationUrl(elementPath, true));
        }
        TestStateStorage.Record record = state;
        TestStateInfo.Magnitude magnitude2 = magnitude = record != null ? TestIconMapper.getMagnitude((int)record.magnitude) : null;
        switch (magnitude2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[magnitude2.ordinal()]) {
            case 1: 
            case 2: {
                Icon icon2 = AllIcons.RunConfigurations.TestState.Red2;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Red2");
                break;
            }
            case 3: 
            case 4: {
                Icon icon3 = AllIcons.RunConfigurations.TestState.Green2;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Green2");
                break;
            }
            case 5: 
            case 6: {
                Icon icon4 = AllIcons.RunConfigurations.TestState.Yellow2;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Yellow2");
                break;
            }
            default: {
                if (elementPath.getTestName() == null) {
                    Icon icon5 = AllIcons.RunConfigurations.TestState.Run_run;
                    icon = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Run_run");
                    break;
                }
                Icon icon6 = AllIcons.RunConfigurations.TestState.Run;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"Run");
            }
        }
        return icon;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStateInfo.Magnitude.values().length];
            try {
                nArray[TestStateInfo.Magnitude.ERROR_INDEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStateInfo.Magnitude.FAILED_INDEX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStateInfo.Magnitude.PASSED_INDEX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStateInfo.Magnitude.COMPLETE_INDEX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStateInfo.Magnitude.SKIPPED_INDEX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStateInfo.Magnitude.IGNORED_INDEX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

