/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NpmInstallQuickFix;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.codeInsight.OpenInstalledPackageQuickFix;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchResponse;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatcher;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageJsonMismatchedDependencyInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance(PackageJsonMismatchedDependencyInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(1);
        }
        return new JsonElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                JsonFile packageJson;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((packageJson = PackageJsonUtil.asPackageJsonFile(file)) != null) {
                    PackageJsonMismatchedDependencyInspection.annotate(packageJson, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection$1", "visitFile"));
            }
        };
    }

    private static void annotate(@NotNull JsonFile file, @NotNull ProblemsHolder holder) {
        List<PackageVersionRangeMatchResponse> mismatches;
        if (file == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(3);
        }
        VirtualFile packageJson = file.getVirtualFile();
        Project project = file.getProject();
        if (packageJson == null || !JSLibraryUtil.isInProjectAndOutsideOfLibraryRoots(project, packageJson)) {
            return;
        }
        List<JsonProperty> properties = PackageJsonUtil.getDependencies(file, PackageJsonUtil.PROD_DEV_DEPENDENCIES);
        if (properties.isEmpty()) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        MultiMap map2 = MultiMap.create();
        for (JsonProperty property : properties) {
            JsonStringLiteral nameLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getNameElement(), JsonStringLiteral.class);
            JsonStringLiteral versionLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
            if (nameLiteral == null || versionLiteral == null) continue;
            String packageName = property.getName();
            InstalledPackageVersion pkgVersion = finder.findInstalledPackage(packageName);
            if (pkgVersion == null) {
                holder.registerProblem((PsiElement)versionLiteral, PackageJsonMismatchedDependencyInspection.getTextRange((JsonValue)versionLiteral), JavaScriptBundle.message("inspection.message.package.installed", StringUtil.wrapWithDoubleQuote((String)packageName)), new LocalQuickFix[]{new NpmInstallQuickFix(project, packageJson)});
                continue;
            }
            String text = versionLiteral.getText();
            if (!StringUtil.isQuotedString((String)text)) continue;
            String versionRange = StringUtil.unquoteString((String)text);
            if (versionRange.isEmpty()) {
                holder.registerProblem((PsiElement)versionLiteral, JavaScriptBundle.message("inspection.message.package.version.specified", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                continue;
            }
            if (pkgVersion.getVersion() == null) continue;
            String version2 = pkgVersion.getVersion().getRawVersion();
            map2.putValue((Object)new PackageVersionRangeMatchRequest(packageName, versionRange, version2, packageJson), (Object)new DependencyDeclaration(versionLiteral, pkgVersion));
        }
        if (map2.keySet().isEmpty()) {
            return;
        }
        try {
            mismatches = PackageVersionRangeMatcher.findMismatches(project, new ArrayList<PackageVersionRangeMatchRequest>(map2.keySet()));
        }
        catch (NodeInterpreterUtil.InvalidNodeInterpreter e) {
            LOG.info("Invalid node interpreter:" + e.getMessage());
            return;
        }
        catch (ExecutionException e) {
            LOG.info("Cannot match", (Throwable)e);
            return;
        }
        for (PackageVersionRangeMatchResponse mismatch : mismatches) {
            PackageVersionRangeMatchRequest request2 = mismatch.getRequest();
            Collection declarations = map2.get((Object)request2);
            if (declarations.isEmpty()) {
                LOG.warn("No package declarations by " + request2);
                continue;
            }
            for (DependencyDeclaration declaration : declarations) {
                ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                fixes.add(new NpmInstallQuickFix(project, packageJson));
                if (holder.isOnTheFly()) {
                    fixes.add(new OpenInstalledPackageQuickFix(declaration.myInstalledPackageVersion.getPackageDir(), request2.getPackageName()));
                }
                holder.registerProblem((PsiElement)declaration.myVersion, PackageJsonMismatchedDependencyInspection.getTextRange((JsonValue)declaration.myVersion), JavaScriptBundle.message("inspection.message.installed.version.doesn.t.match.version.range", StringUtil.wrapWithDoubleQuote((String)(request2.getPackageName() + "@" + request2.getVersion())), StringUtil.wrapWithDoubleQuote((String)request2.getVersionRange())), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    @NotNull
    public static TextRange getTextRange(@NotNull JsonValue element) {
        if (element == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(4);
        }
        TextRange range = element.getTextRange();
        if (element instanceof JsonStringLiteral && range.getLength() > 2 && StringUtil.isQuotedString((String)element.getText())) {
            return new TextRange(1, range.getLength() - 1);
        }
        TextRange textRange = TextRange.create((int)0, (int)range.getLength());
        if (textRange == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class DependencyDeclaration {
        public final JsonStringLiteral myVersion;
        public final InstalledPackageVersion myInstalledPackageVersion;

        DependencyDeclaration(@NotNull JsonStringLiteral version2, @NotNull InstalledPackageVersion installedPackageVersion) {
            if (version2 == null) {
                DependencyDeclaration.$$$reportNull$$$0(0);
            }
            if (installedPackageVersion == null) {
                DependencyDeclaration.$$$reportNull$$$0(1);
            }
            this.myVersion = version2;
            this.myInstalledPackageVersion = installedPackageVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "installedPackageVersion";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection$DependencyDeclaration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

