/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.javascript.nodejs.library.node_modules.DebugLog;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesLibraryStat;
import com.intellij.javascript.nodejs.library.node_modules.TotalStat;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0002H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a8\u0006\u0015\u00b2\u0006\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u008a\u0084\u0002"}, d2={"sumIfDefined", "", "", "addIfDefined", "a", "b", "updateStat", "", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;", "libraryStat", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesLibraryStat;", "logStat", "directoryManager", "toJson", "", "totalStat", "Lcom/intellij/javascript/nodejs/library/node_modules/TotalStat;", "project", "Lcom/intellij/openapi/project/Project;", "createGson", "Lcom/google/gson/Gson;", "intellij.javascript.impl", "rootParent", "Lcom/intellij/openapi/vfs/VirtualFile;"})
@SourceDebugExtension(value={"SMAP\nnodeModulesStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nodeModulesStat.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesStatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n2669#2,7:99\n774#2:106\n865#2,2:107\n1611#2,9:109\n1863#2:118\n1864#2:120\n1620#2:121\n1#3:119\n*S KotlinDebug\n*F\n+ 1 nodeModulesStat.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesStatKt\n*L\n49#1:99,7\n62#1:106\n62#1:107,2\n65#1:109,9\n65#1:118\n65#1:120\n65#1:121\n65#1:119\n*E\n"})
public final class NodeModulesStatKt {
    /*
     * WARNING - void declaration
     */
    private static final int sumIfDefined(List<Integer> $this$sumIfDefined) {
        if ($this$sumIfDefined.isEmpty()) {
            return 0;
        }
        Iterable $this$reduce$iv = $this$sumIfDefined;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void value;
            int n = ((Number)iterator$iv.next()).intValue();
            int acc = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            accumulator$iv = NodeModulesStatKt.addIfDefined(acc, (int)value);
        }
        return ((Number)accumulator$iv).intValue();
    }

    private static final int addIfDefined(int a, int b) {
        return a != -1 && b != -1 ? a + b : -1;
    }

    public static final void updateStat(@NotNull NodeModulesDirectoryManager $this$updateStat, @NotNull NodeModulesLibraryStat libraryStat) {
        Intrinsics.checkNotNullParameter((Object)$this$updateStat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)libraryStat, (String)"libraryStat");
        NodeModulesLibraryStat prevLibraryStat = $this$updateStat.myLibraryStatByDirMap.put(libraryStat.getNodeModulesDir(), libraryStat);
        if (prevLibraryStat == null || !Intrinsics.areEqual((Object)prevLibraryStat, (Object)NodeModulesLibraryStat.copy$default(libraryStat, null, 0, 0, 0, 0, 0, prevLibraryStat.getCalculationDurationNano(), 63, null))) {
            NodeModulesStatKt.logStat($this$updateStat);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void logStat(NodeModulesDirectoryManager directoryManager) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        List<VirtualFile> list = directoryManager.getNodeModulesDirs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodeModulesDirs(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!directoryManager.isForApplicationSourceCode(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nodeModulesDirs = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = nodeModulesDirs;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NodeModulesLibraryStat it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (directoryManager.myLibraryStatByDirMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List stats = (List)destination$iv$iv2;
        if (nodeModulesDirs.size() != stats.size()) {
            return;
        }
        TotalStat totalStat = new TotalStat(stats);
        Project project = directoryManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        NodeModulesDirectoryManager.LOG.info("Contributed " + NodeModulesStatKt.toJson(totalStat, project));
    }

    private static final String toJson(TotalStat totalStat, Project project) {
        String string;
        String json = NodeModulesStatKt.createGson(project).toJson((Object)totalStat);
        if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
            Intrinsics.checkNotNull((Object)json);
            string = json;
        } else {
            Intrinsics.checkNotNull((Object)json);
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)json, (String)"\"", (String)"", (boolean)false, (int)4, null), (String)",", (String)", ", (boolean)false, (int)4, null);
        }
        return string;
    }

    @NotNull
    public static final Gson createGson(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Lazy rootParent$delegate = LazyKt.lazy(() -> NodeModulesStatKt.createGson$lambda$3(project));
        GsonBuilder builder2 = new GsonBuilder().registerTypeHierarchyAdapter(VirtualFile.class, (Object)new JsonSerializer<VirtualFile>((Lazy<? extends VirtualFile>)rootParent$delegate){
            final /* synthetic */ Lazy<VirtualFile> $rootParent$delegate;
            {
                this.$rootParent$delegate = $rootParent$delegate;
            }

            public JsonElement serialize(VirtualFile src, Type typeOfSrc, JsonSerializationContext context2) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
                        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        object = NodeModulesStatKt.access$createGson$lambda$4(this.$rootParent$delegate);
                        if (object == null) break block2;
                        VirtualFile it = object;
                        boolean bl = false;
                        String string = VfsUtil.getRelativePath((VirtualFile)src, (VirtualFile)it);
                        object = string;
                        if (string != null) break block3;
                    }
                    String string = src.getPath();
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                }
                Object path2 = object;
                JsonElement jsonElement = context2.serialize(path2);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"serialize(...)");
                return jsonElement;
            }
        });
        if (!NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
            builder2 = builder2.addSerializationExclusionStrategy(new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes f) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                        Collection collection = f.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAnnotations(...)");
                        Iterable $this$any$iv = collection;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Annotation it = (Annotation)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof DebugLog)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            });
        }
        Gson gson = builder2.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        return gson;
    }

    private static final VirtualFile createGson$lambda$3(Project $project) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$project);
        return virtualFile != null ? virtualFile.getParent() : null;
    }

    private static final VirtualFile createGson$lambda$4(Lazy<? extends VirtualFile> $rootParent$delegate) {
        Lazy<? extends VirtualFile> lazy = $rootParent$delegate;
        return (VirtualFile)lazy.getValue();
    }

    public static final /* synthetic */ int access$sumIfDefined(List $receiver) {
        return NodeModulesStatKt.sumIfDefined($receiver);
    }

    public static final /* synthetic */ int access$addIfDefined(int a, int b) {
        return NodeModulesStatKt.addIfDefined(a, b);
    }

    public static final /* synthetic */ VirtualFile access$createGson$lambda$4(Lazy $rootParent$delegate) {
        return NodeModulesStatKt.createGson$lambda$4((Lazy<? extends VirtualFile>)$rootParent$delegate);
    }
}

