/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.database.DataGridBundle;
import com.intellij.database.loaders.DataLoader;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.impl.ScriptedTableFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptedTableFileEditorProvider
extends WeighedFileEditorProvider {
    public static final String PROVIDER_ID = "scripted-data-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(1);
        }
        return DataLoaderManager.DataFileType.INSTANCE.hasScriptLoader(file);
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public ScriptedTableFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(3);
        }
        boolean tableFirstOnlyFormats = OpenDetectedTables.getOpenDetectedTablesSetting() == OpenDetectedTables.TABLE_FIRST_FORMATS;
        DataLoader loader = DataLoaderManager.getInstance().findDataLoader(file, tableFirstOnlyFormats);
        if (loader == null && tableFirstOnlyFormats) {
            loader = DataLoaderManager.getInstance().findDataLoader(file, false);
        }
        if (loader == null) {
            throw new AssertionError((Object)("No loader for " + file.getName()));
        }
        return new ScriptedTableFileEditor(project, file, loader);
    }

    @NotNull
    public String getEditorTypeId() {
        return PROVIDER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(4);
        }
        return fileEditorPolicy;
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull DataLoader loader) {
        FileEditorManagerEx fileEditorManagerEx;
        EditorWindow editorWindow;
        EditorComposite composite;
        if (project == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (loader == null) {
            ScriptedTableFileEditorProvider.$$$reportNull$$$0(7);
        }
        EditorComposite editorComposite = composite = (editorWindow = (fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project)).getSplitters().getCurrentWindow()) == null ? null : editorWindow.getComposite(file);
        if (composite == null && editorWindow != null) {
            fileEditorManagerEx.openFile(file, editorWindow, new FileEditorOpenOptions());
            composite = editorWindow.getComposite(file);
        }
        if (composite != null) {
            ScriptedTableFileEditor tableEditor = (ScriptedTableFileEditor)((Object)ContainerUtil.findInstance((Iterable)composite.getAllEditors(), ScriptedTableFileEditor.class));
            if (tableEditor == null) {
                ScriptedTableFileEditorProvider provider = ScriptedTableFileEditorProvider.getProvider();
                composite.addEditor((FileEditor)new ScriptedTableFileEditor(project, file, loader), (FileEditorProvider)Objects.requireNonNull(provider));
            }
            fileEditorManagerEx.setSelectedEditor(file, PROVIDER_ID);
        }
    }

    @Nullable
    public static ScriptedTableFileEditorProvider getProvider() {
        return (ScriptedTableFileEditorProvider)FileEditorProviderManager.getInstance().getProvider(PROVIDER_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OpenDetectedTables {
        ALL{

            public String toString() {
                return DataGridBundle.message((String)"advanced.setting.database.import.open.detected.tables.all", (Object[])new Object[0]);
            }
        }
        ,
        TABLE_FIRST_FORMATS{

            public String toString() {
                return DataGridBundle.message((String)"advanced.setting.database.import.open.detected.tables.table.first.formats", (Object[])new Object[0]);
            }
        }
        ,
        NONE{

            public String toString() {
                return DataGridBundle.message((String)"advanced.setting.database.import.open.detected.tables.none", (Object[])new Object[0]);
            }
        };

        public static final String ID = "database.import.open.detected.tables";

        public static void overrideDefaultOpenOption(@NotNull OpenDetectedTables openOption) {
            AdvancedSettingBean setting;
            if (openOption == null) {
                OpenDetectedTables.$$$reportNull$$$0(0);
            }
            if ((setting = (AdvancedSettingBean)AdvancedSettingBean.EP_NAME.findByIdOrFromInstance(ID, b -> b.id)) != null) {
                setting.defaultValue = openOption.name();
            }
        }

        @NotNull
        public static OpenDetectedTables getOpenDetectedTablesSetting() {
            OpenDetectedTables openDetectedTables = (OpenDetectedTables)AdvancedSettings.getEnum((String)ID, OpenDetectedTables.class);
            if (openDetectedTables == null) {
                OpenDetectedTables.$$$reportNull$$$0(1);
            }
            return openDetectedTables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openOption";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpenDetectedTablesSetting";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "overrideDefaultOpenOption";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

