/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010!\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "base", "", "maxExactRecordsInBucket", "", "baseLog", "durations", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Key;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Value;", "addInspectionFinishedEvent", "", "duration", "", "problemsCount", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "logDurations", "getSummary", "", "inspectionId", "toBucket", "Lkotlin/Pair;", "fromBucket", "bucket", "Companion", "Key", "Value", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionDurationsAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionDurationsAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n1863#2:116\n1863#2,2:117\n1864#2:119\n216#3,2:120\n*S KotlinDebug\n*F\n+ 1 InspectionDurationsAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService\n*L\n62#1:116\n73#1:117,2\n62#1:119\n90#1:120,2\n*E\n"})
public final class InspectionDurationsAggregatorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final double base;
    private final int maxExactRecordsInBucket;
    private final double baseLog;
    @NotNull
    private final ConcurrentHashMap<Key, Value> durations;

    public InspectionDurationsAggregatorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = System.getProperty("qodana.inspections.duration.bucket.base", "1.3");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.base = Double.parseDouble(string);
        String string2 = System.getProperty("qodana.inspections.duration.bucket.exact.records", "1");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        this.maxExactRecordsInBucket = Integer.parseInt(string2);
        this.baseLog = Math.log(this.base);
        this.durations = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addInspectionFinishedEvent(long duration, int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind) {
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind == InspectListener.InspectionKind.LOCAL_PRIORITY) {
            return;
        }
        Pair<Long, Long> pair = this.toBucket(duration);
        long lowerBound = ((Number)pair.component1()).longValue();
        long upperBound = ((Number)pair.component2()).longValue();
        String string = tool.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        Key key = new Key(string, kind, lowerBound, upperBound);
        Function2 function2 = (arg_0, arg_1) -> InspectionDurationsAggregatorService.addInspectionFinishedEvent$lambda$0(problemsCount, tool, duration, this, arg_0, arg_1);
        this.durations.compute(key, new BiFunction(function2){
            private final /* synthetic */ Function2 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0, Object p1) {
                return this.function.invoke(p0, p1);
            }
        });
    }

    public final void logDurations() {
        Set<Map.Entry<Key, Value>> set = this.durations.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            Key key = (Key)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Value value2 = (Value)v;
            if (value2.getFilesCount() > this.maxExactRecordsInBucket) {
                InspectionEventsCollector.logInspectionDuration(key.getLowerBound(), key.getUpperBound(), value2.getProblemsCount(), value2.getFilesCount(), value2.getTool(), key.getKind(), this.project);
                continue;
            }
            Iterable $this$forEach$iv2 = value2.getExactValues();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair = (Pair)element$iv2;
                boolean bl2 = false;
                long duration = ((Number)pair.component1()).longValue();
                int problemsCount = ((Number)pair.component2()).intValue();
                InspectionEventsCollector.logInspectionDuration(duration, duration, problemsCount, 1, value2.getTool(), key.getKind(), this.project);
            }
        }
    }

    @TestOnly
    @NotNull
    public final String getSummary(@NotNull String inspectionId) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        int files2 = 0;
        int problems2 = 0;
        Map $this$forEach$iv = this.durations;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Key k = (Key)entry.getKey();
            Value v = (Value)entry.getValue();
            if (!Intrinsics.areEqual((Object)k.getInspectionId(), (Object)inspectionId)) continue;
            files2 += v.getFilesCount();
            problems2 += v.getProblemsCount();
        }
        return "files: " + files2 + ", problems: " + problems2;
    }

    private final Pair<Long, Long> toBucket(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException();
        }
        if (duration == 0L) {
            return TuplesKt.to((Object)0L, (Object)1L);
        }
        int fairBucket = (int)Math.floor(Math.log(duration + 1L) / this.baseLog);
        long fairLowerBound = ((Number)this.fromBucket(fairBucket).getFirst()).longValue();
        int bucket = fairLowerBound > duration ? fairBucket - 1 : fairBucket;
        return this.fromBucket(bucket);
    }

    private final Pair<Long, Long> fromBucket(int bucket) {
        long lowerBound = (long)Math.ceil(Math.pow(this.base, bucket) - 1.0);
        long upperBound = (long)Math.ceil(Math.pow(this.base, bucket + 1) - 1.0);
        return TuplesKt.to((Object)lowerBound, (Object)upperBound);
    }

    private static final Value addInspectionFinishedEvent$lambda$0(int $problemsCount, InspectionToolWrapper $tool, long $duration, InspectionDurationsAggregatorService this$0, Key key, Value v) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
        if (v == null) {
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)$duration, (Object)$problemsCount)};
            Value value3 = new Value($problemsCount, 1, $tool, CollectionsKt.mutableListOf((Object[])objectArray));
            value2 = value3;
        } else {
            v.setProblemsCount(v.getProblemsCount() + $problemsCount);
            v.setFilesCount(v.getFilesCount() + 1);
            if (v.getFilesCount() <= this$0.maxExactRecordsInBucket) {
                v.getExactValues().add((Pair<Long, Integer>)TuplesKt.to((Object)$duration, (Object)$problemsCount));
            }
            value2 = v;
        }
        return value2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionDurationsAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionDurationsAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n72#2:116\n*S KotlinDebug\n*F\n+ 1 InspectionDurationsAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Companion\n*L\n24#1:116\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstance(@NotNull Project project, @NotNull Continuation<? super InspectionDurationsAggregatorService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(InspectionDurationsAggregatorService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Key;", "", "inspectionId", "", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "lowerBound", "", "upperBound", "<init>", "(Ljava/lang/String;Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;JJ)V", "getInspectionId", "()Ljava/lang/String;", "getKind", "()Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "getLowerBound", "()J", "getUpperBound", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.qodana"})
    private static final class Key {
        @NotNull
        private final String inspectionId;
        @NotNull
        private final InspectListener.InspectionKind kind;
        private final long lowerBound;
        private final long upperBound;

        public Key(@NotNull String inspectionId, @NotNull InspectListener.InspectionKind kind, long lowerBound, long upperBound) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.inspectionId = inspectionId;
            this.kind = kind;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        @NotNull
        public final String getInspectionId() {
            return this.inspectionId;
        }

        @NotNull
        public final InspectListener.InspectionKind getKind() {
            return this.kind;
        }

        public final long getLowerBound() {
            return this.lowerBound;
        }

        public final long getUpperBound() {
            return this.upperBound;
        }

        @NotNull
        public final String component1() {
            return this.inspectionId;
        }

        @NotNull
        public final InspectListener.InspectionKind component2() {
            return this.kind;
        }

        public final long component3() {
            return this.lowerBound;
        }

        public final long component4() {
            return this.upperBound;
        }

        @NotNull
        public final Key copy(@NotNull String inspectionId, @NotNull InspectListener.InspectionKind kind, long lowerBound, long upperBound) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return new Key(inspectionId, kind, lowerBound, upperBound);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, InspectListener.InspectionKind inspectionKind, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.inspectionId;
            }
            if ((n & 2) != 0) {
                inspectionKind = key.kind;
            }
            if ((n & 4) != 0) {
                l = key.lowerBound;
            }
            if ((n & 8) != 0) {
                l2 = key.upperBound;
            }
            return key.copy(string, inspectionKind, l, l2);
        }

        @NotNull
        public String toString() {
            return "Key(inspectionId=" + this.inspectionId + ", kind=" + this.kind + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ")";
        }

        public int hashCode() {
            int result2 = this.inspectionId.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lowerBound);
            result2 = result2 * 31 + Long.hashCode(this.upperBound);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.inspectionId, (Object)key.inspectionId)) {
                return false;
            }
            if (this.kind != key.kind) {
                return false;
            }
            if (this.lowerBound != key.lowerBound) {
                return false;
            }
            return this.upperBound == key.upperBound;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u0019\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionDurationsAggregatorService$Value;", "", "problemsCount", "", "filesCount", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "exactValues", "", "Lkotlin/Pair;", "", "<init>", "(IILcom/intellij/codeInspection/ex/InspectionToolWrapper;Ljava/util/List;)V", "getProblemsCount", "()I", "setProblemsCount", "(I)V", "getFilesCount", "setFilesCount", "getTool", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "getExactValues", "()Ljava/util/List;", "intellij.qodana"})
    private static final class Value {
        private int problemsCount;
        private int filesCount;
        @NotNull
        private final InspectionToolWrapper<?, ?> tool;
        @NotNull
        private final List<Pair<Long, Integer>> exactValues;

        public Value(int problemsCount, int filesCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull List<Pair<Long, Integer>> exactValues) {
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            Intrinsics.checkNotNullParameter(exactValues, (String)"exactValues");
            this.problemsCount = problemsCount;
            this.filesCount = filesCount;
            this.tool = tool;
            this.exactValues = exactValues;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        public final void setProblemsCount(int n) {
            this.problemsCount = n;
        }

        public final int getFilesCount() {
            return this.filesCount;
        }

        public final void setFilesCount(int n) {
            this.filesCount = n;
        }

        @NotNull
        public final InspectionToolWrapper<?, ?> getTool() {
            return this.tool;
        }

        @NotNull
        public final List<Pair<Long, Integer>> getExactValues() {
            return this.exactValues;
        }
    }
}

