/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaMessageReporter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/QodanaProgressIndicator;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorWithDelayedPresentation;", "messageReporter", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaMessageReporter;)V", "myLastPercent", "", "setText", "", "text", "", "setDelayInMillis", "delayInMillis", "intellij.qodana"})
public final class QodanaProgressIndicator
extends ProgressIndicatorBase
implements ProgressIndicatorWithDelayedPresentation {
    @NotNull
    private final QodanaMessageReporter messageReporter;
    private int myLastPercent;

    public QodanaProgressIndicator(@NotNull QodanaMessageReporter messageReporter) {
        Intrinsics.checkNotNullParameter((Object)messageReporter, (String)"messageReporter");
        this.messageReporter = messageReporter;
        this.myLastPercent = -1;
        this.setText("");
    }

    public void setText(@Nullable String text2) {
        if (text2 == null) {
            return;
        }
        int percent = (int)(this.getFraction() * (double)100);
        if (QodanaKt.isInteractiveOutput() || !this.isIndeterminate() && this.getFraction() > 0.0 && this.myLastPercent != percent) {
            Pair<String, String> pair = QodanaKt.splitProgressText(text2);
            String prefix = (String)pair.component1();
            String file = (String)pair.component2();
            String msg = QodanaKt.isInteractiveOutput() && file != null ? prefix + " " + percent + "% [" + file + "]" : prefix + " " + percent + "%";
            this.messageReporter.reportMessage(2, msg);
        }
        this.myLastPercent = percent;
    }

    public void setDelayInMillis(int delayInMillis) {
    }
}

