/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.context;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.extend.ContentFunction;
import com.openhtmltopdf.css.parser.FSFunction;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.CounterFunction;
import com.openhtmltopdf.layout.InlineBoxing;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.RenderingContext;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ContentFunctionFactory {
    private final List<ContentFunction> _functions = new ArrayList<ContentFunction>();

    public ContentFunctionFactory() {
        this._functions.add(new PageCounterFunction());
        this._functions.add(new PagesCounterFunction());
        this._functions.add(new TargetCounterFunction());
        this._functions.add(new TargetTextFunction());
        this._functions.add(new LeaderFunction());
        this._functions.add(new FsIfCutOffFunction());
    }

    public ContentFunction lookupFunction(LayoutContext c, FSFunction function) {
        return this._functions.stream().filter(f -> f.canHandle(c, function)).findFirst().orElse(null);
    }

    public void registerFunction(ContentFunction function) {
        this._functions.add(function);
    }

    private static class LeaderFunction
    implements ContentFunction {
        private LeaderFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            void var11_20;
            InlineLayoutBox iB = text2.getParent();
            LineBox lineBox = iB.getLineBox();
            boolean dynamic = false;
            boolean dynamic2 = false;
            Box wrapperBox = iB.getParent();
            List<Object> children2 = null;
            children2 = wrapperBox instanceof InlineLayoutBox ? ((InlineLayoutBox)wrapperBox).getInlineChildren() : wrapperBox.getChildren();
            for (Object object : children2) {
                if (object == iB) {
                    dynamic = true;
                    continue;
                }
                if (!(object instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)object).lookForDynamicFunctions(c);
            }
            if (dynamic) {
                for (Box box : lineBox.getChildren()) {
                    if (wrapperBox == box) {
                        dynamic2 = true;
                        continue;
                    }
                    if (!dynamic2 || !(box instanceof InlineLayoutBox)) continue;
                    ((InlineLayoutBox)box).lookForDynamicFunctions(c);
                }
            }
            if (dynamic) {
                int totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c, lineBox, 0);
                lineBox.setContentWidth(totalLineWidth);
            }
            PropertyValue param = function.getParameters().get(0);
            String string = param.getStringValue();
            if (param.getPrimitiveType() == 21) {
                if (string.equals("dotted")) {
                    String string2 = ". ";
                } else if (string.equals("solid")) {
                    String string3 = "_";
                } else if (string.equals("space")) {
                    String string4 = " ";
                }
            }
            StringBuilder tmp = new StringBuilder(100 * var11_20.length());
            for (int i = 0; i < 100; ++i) {
                tmp.append((String)var11_20);
            }
            float valueWidth = (float)c.getTextRenderer().getWidth(c.getFontContext(), iB.getStyle().getFSFont(c), tmp.toString()) / 100.0f;
            int spaceWidth = c.getTextRenderer().getWidth(c.getFontContext(), iB.getStyle().getFSFont(c), " ");
            int leaderWidth = iB.getContainingBlockWidth() - iB.getLineBox().getWidth() + text2.getWidth();
            int count = (int)((float)(leaderWidth - 2 * spaceWidth) / valueWidth);
            StringBuilder buf = new StringBuilder(count * var11_20.length() + 2);
            buf.append(' ');
            for (int i = 0; i < count; ++i) {
                buf.append((String)var11_20);
            }
            buf.append(' ');
            String leaderString = buf.toString();
            int leaderStringWidth = c.getTextRenderer().getWidth(c.getFontContext(), iB.getStyle().getFSFont(c), leaderString);
            iB.setMarginLeft(c, leaderWidth - leaderStringWidth);
            return leaderString;
        }

        @Override
        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return " . ";
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            List<PropertyValue> parameters;
            if (c.isPrint() && function.getName().equals("leader") && (parameters = function.getParameters()).size() == 1) {
                PropertyValue param = parameters.get(0);
                return param.getPrimitiveType() == 19 || param.getPrimitiveType() == 21 && (param.getStringValue().equals("dotted") || param.getStringValue().equals("solid") || param.getStringValue().equals("space"));
            }
            return false;
        }
    }

    private static class TargetTextFunction
    implements ContentFunction {
        private TargetTextFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            String anchor;
            Box target;
            Element hrefElement = text2.getParent().getElement() == null ? text2.getParent().getParent().getElement() : text2.getParent().getElement();
            String uri = hrefElement.getAttribute("href");
            if (uri != null && uri.startsWith("#") && (target = c.getBoxById(anchor = uri.substring(1))) != null) {
                StringBuilder strBuilder = new StringBuilder();
                target.collectText(c, strBuilder);
                return strBuilder.toString();
            }
            return "";
        }

        @Override
        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return "ABCABC";
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            List<PropertyValue> parameters;
            if (c.isPrint() && function.getName().equals("target-text") && (parameters = function.getParameters()).size() == 1) {
                FSFunction f = parameters.get(0).getFunction();
                return f != null && f.getParameters().size() == 1 && f.getParameters().get(0).getStringValue().equals("href");
            }
            return false;
        }
    }

    private static class TargetCounterFunction
    implements ContentFunction {
        private TargetCounterFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            String anchor;
            Box target;
            Element hrefElement = text2.getParent().getElement() == null ? text2.getParent().getParent().getElement() : text2.getParent().getElement();
            String uri = hrefElement.getAttribute("href");
            if (uri != null && uri.startsWith("#") && (target = c.getBoxById(anchor = uri.substring(1))) != null) {
                int pageNo = c.getRootLayer().getRelativePageNo(c, target.getAbsY());
                return CounterFunction.createCounterText(IdentValue.DECIMAL, pageNo + 1);
            }
            return "";
        }

        @Override
        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return "999";
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            List<PropertyValue> parameters;
            if (c.isPrint() && function.getName().equals("target-counter") && ((parameters = function.getParameters()).size() == 2 || parameters.size() == 3)) {
                FSFunction f = parameters.get(0).getFunction();
                if (f == null || f.getParameters().size() != 1 || f.getParameters().get(0).getPrimitiveType() != 21 || !f.getParameters().get(0).getStringValue().equals("href")) {
                    return false;
                }
                PropertyValue param = parameters.get(1);
                return param.getPrimitiveType() == 21 && param.getStringValue().equals("page");
            }
            return false;
        }
    }

    private static class PagesCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PagesCounterFunction() {
        }

        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            int value2 = c.getRootLayer().getRelativePageCount(c);
            return CounterFunction.createCounterText(this.getListStyleType(function), value2);
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            return c.isPrint() && this.isCounter(function, "pages");
        }
    }

    private static class PageCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PageCounterFunction() {
        }

        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            int value2 = c.getRootLayer().getRelativePageNo(c) + 1;
            return CounterFunction.createCounterText(this.getListStyleType(function), value2);
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            return c.isPrint() && this.isCounter(function, "page");
        }
    }

    private static abstract class PageNumberFunction
    implements ContentFunction {
        private PageNumberFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        @Override
        public String getLayoutReplacementText() {
            return "999";
        }

        protected IdentValue getListStyleType(FSFunction function) {
            PropertyValue pValue;
            IdentValue iValue;
            IdentValue result2 = IdentValue.DECIMAL;
            List<PropertyValue> parameters = function.getParameters();
            if (parameters.size() == 2 && (iValue = IdentValue.valueOf((pValue = parameters.get(1)).getStringValue())) != null) {
                result2 = iValue;
            }
            return result2;
        }

        protected boolean isCounter(FSFunction function, String counterName) {
            List<PropertyValue> parameters;
            if (function.getName().equals("counter") && ((parameters = function.getParameters()).size() == 1 || parameters.size() == 2)) {
                PropertyValue param = parameters.get(0);
                if (param.getPrimitiveType() != 21 || !param.getStringValue().equals(counterName)) {
                    return false;
                }
                if (parameters.size() == 2) {
                    param = parameters.get(1);
                    return param.getPrimitiveType() == 21;
                }
                return true;
            }
            return false;
        }
    }

    private static class FsIfCutOffFunction
    implements ContentFunction {
        private FsIfCutOffFunction() {
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        @Override
        public String calculate(RenderingContext c, FSFunction function, InlineText text2) {
            return c.getShadowPageNumber() >= 0 ? function.getParameters().get(0).getStringValue() : "";
        }

        @Override
        public String getLayoutReplacementText() {
            return "cont";
        }

        @Override
        public boolean canHandle(LayoutContext c, FSFunction function) {
            return function.getName().equals("-fs-if-cut-off") && function.getParameters().size() == 1 && function.getParameters().get(0).getPrimitiveType() == 19;
        }
    }
}

