% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build}
\alias{build}
\title{Build package}
\usage{
build(path = ".", dest_path = NULL, binary = FALSE,
  vignettes = TRUE, manual = FALSE, args = NULL, quiet = FALSE,
  needs_compilation = pkg_has_src(path), compile_attributes = FALSE,
  register_routines = FALSE)
}
\arguments{
\item{path}{Path to a package, or within a package.}

\item{dest_path}{path in which to produce package.  If \code{NULL}, defaults to
the parent directory of the package.}

\item{binary}{Produce a binary (\code{--binary}) or source (
\code{--no-manual --no-resave-data}) version of the package.}

\item{vignettes, manual}{For source packages: if \code{FALSE}, don't build PDF
vignettes (\code{--no-build-vignettes}) or manual (\code{--no-manual}).}

\item{args}{An optional character vector of additional command
line arguments to be passed to \code{R CMD build} if \code{binary = FALSE},
or \code{R CMD install} if \code{binary = TRUE}.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{needs_compilation}{Usually only needed if the packages has
C/C++/Fortran code. By default this is autodetected.}

\item{compile_attributes}{if \code{TRUE} and the package uses Rcpp, call
\code{\link[Rcpp:compileAttributes]{Rcpp::compileAttributes()}} before building the package. It is ignored
if package does not need compilation.}

\item{register_routines}{if \code{TRUE} and the package does not use Rcpp, call
register routines with
\code{tools::package_native_routine_registration_skeleton()} before building
the package. It is ignored if package does not need compilation.}
}
\value{
a string giving the location (including file name) of the built
package
}
\description{
Building converts a package source directory into a single bundled file.
If \code{binary = FALSE} this creates a \code{tar.gz} package that can
be installed on any platform, provided they have a full development
environment (although packages without source code can typically be
installed out of the box). If \code{binary = TRUE}, the package will have
a platform specific extension (e.g. \code{.zip} for windows), and will
only be installable on the current platform, but no development
environment is needed.
}
