/****************************************************************************
**
** Copyright (C) 2014 BogDan Vatra <bogdan@kde.org>
** Contact: https://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QANDROIDEVENTDISPATCHER_H
#define QANDROIDEVENTDISPATCHER_H

#include <QtCore/QMutex>
#include <QtCore/QSemaphore>
#include <QtGui/private/qunixeventdispatcher_qpa_p.h>

class QAndroidEventDispatcher : public QUnixEventDispatcherQPA
{
    Q_OBJECT
public:
    explicit QAndroidEventDispatcher(QObject *parent = nullptr);
    ~QAndroidEventDispatcher();
    void start();
    void stop();

    void goingToStop(bool stop);

protected:
    bool processEvents(QEventLoop::ProcessEventsFlags flags) override;

private:
    QAtomicInt m_stopRequest;
    QAtomicInt m_goingToStop;
    QSemaphore m_semaphore;
};

class QAndroidEventDispatcherStopper
{
public:
    static QAndroidEventDispatcherStopper *instance();
    static bool stopped() {return !instance()->m_started.loadRelaxed(); }
    void startAll();
    void stopAll();
    void addEventDispatcher(QAndroidEventDispatcher *dispatcher);
    void removeEventDispatcher(QAndroidEventDispatcher *dispatcher);
    void goingToStop(bool stop);

private:
    QMutex m_mutex;
    QAtomicInt m_started = 1;
    QList<QAndroidEventDispatcher *> m_dispatchers;
};


#endif // QANDROIDEVENTDISPATCHER_H
