#!/usr/bin/env python
# Licensed under a 3-clause BSD style license - see LICENSE.rst
"""
Tests for pyvo.dal.scs
"""
from __future__ import (
    absolute_import, division, print_function, unicode_literals)

from functools import partial
import re

import pytest

from pyvo.dal.scs import search, SCSService

from astropy.utils.data import get_pkg_data_contents

get_pkg_data_contents = partial(
    get_pkg_data_contents, package=__package__, encoding='binary')

scs_re = re.compile('http://example.com/scs.*')


@pytest.fixture()
def scs(mocker):
    def callback(request, context):
        return get_pkg_data_contents('data/scs/result.xml')

    with mocker.register_uri(
        'GET', scs_re, content=callback
    ) as matcher:
        yield matcher


@pytest.mark.usefixtures('scs')
@pytest.mark.filterwarnings("ignore::astropy.io.votable.exceptions.W06")
def test_search():
    results = search('http://example.com/scs', (78, 2), 0.5)

    assert len(results) == 1273


class TestSCSService(object):
    def test_init(self):
        service = SCSService('http://example.com/scs')

        assert service.baseurl == 'http://example.com/scs'

    @pytest.mark.usefixtures('scs')
    @pytest.mark.filterwarnings("ignore::astropy.io.votable.exceptions.W06")
    def test_search(self):
        service = SCSService('http://example.com/scs')

        results = service.search((78, 2), 0.5)

        assert len(results) == 1273
