/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAttachmentNameCollectionDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/AttachmentNameCollectionXml.h"

using namespace Caf;

void AttachmentNameCollectionXml::add(
	const SmartPtrCAttachmentNameCollectionDoc attachmentNameCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AttachmentNameCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(attachmentNameCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<std::string> nameVal =
			attachmentNameCollectionDoc->getName();
		CAF_CM_VALIDATE_STL(nameVal);

		if (! nameVal.empty()) {
			for (TConstIterator<std::deque<std::string> > nameIter(nameVal);
				nameIter; nameIter++) {
				const SmartPtrCXmlElement nameXml =
					thisXml->createAndAddElement("attachmentName");
				nameXml->addAttribute("name", *nameIter);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCAttachmentNameCollectionDoc AttachmentNameCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AttachmentNameCollectionXml", "parse");

	SmartPtrCAttachmentNameCollectionDoc attachmentNameCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection nameChildrenXml =
			thisXml->findRequiredChildren("attachmentName");

		std::deque<std::string> nameVal;
		if (! nameChildrenXml.IsNull() && ! nameChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> nameXmlIter(*nameChildrenXml);
				nameXmlIter; nameXmlIter++) {
				const SmartPtrCXmlElement nameXml = nameXmlIter->second;
				const std::string name = nameXml->findRequiredAttribute("name");
				nameVal.push_back(name);
			}
		}

		attachmentNameCollectionDoc.CreateInstance();
		attachmentNameCollectionDoc->initialize(
			nameVal);
	}
	CAF_CM_EXIT;

	return attachmentNameCollectionDoc;
}

