// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepBuilderAPI_NurbsConvert_HeaderFile
#define _BRepBuilderAPI_NurbsConvert_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <BRepBuilderAPI_ModifyShape.hxx>
#include <Standard_Boolean.hxx>
class TopoDS_Shape;


//! Conversion of the complete geometry of a shape
//! (all 3D analytical representation of surfaces and curves)
//! into NURBS geometry (execpt for Planes). For example,
//! all curves supporting edges of the basis shape are converted
//! into BSpline curves, and all surfaces supporting its faces are
//! converted into BSpline surfaces.
class BRepBuilderAPI_NurbsConvert  : public BRepBuilderAPI_ModifyShape
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs a framework for converting the geometry of a
  //! shape into NURBS geometry. Use the function Perform
  //! to define the shape to convert.
  Standard_EXPORT BRepBuilderAPI_NurbsConvert();
  
  //! Builds a new shape by converting the geometry of the
  //! shape S into NURBS geometry. Specifically, all curves
  //! supporting edges of S are converted into BSpline
  //! curves, and all surfaces supporting its faces are
  //! converted into BSpline surfaces.
  //! Use the function Shape to access the new shape.
  //! Note: the constructed framework can be reused to
  //! convert other shapes. You specify these with the
  //! function Perform.
  Standard_EXPORT BRepBuilderAPI_NurbsConvert(const TopoDS_Shape& S, const Standard_Boolean Copy = Standard_False);
  
  //! Builds a new shape by converting the geometry of the
  //! shape S into NURBS geometry.
  //! Specifically, all curves supporting edges of S are
  //! converted into BSpline curves, and all surfaces
  //! supporting its faces are converted into BSpline surfaces.
  //! Use the function Shape to access the new shape.
  //! Note: this framework can be reused to convert other
  //! shapes: you specify them by calling the function Perform again.
  Standard_EXPORT   void Perform (const TopoDS_Shape& S, const Standard_Boolean Copy = Standard_False) ;




protected:





private:





};







#endif // _BRepBuilderAPI_NurbsConvert_HeaderFile
