//
// X509Certificate2Test.cs - NUnit Test Cases for 
//	System.Security.Cryptography.X509Certificates.X509Certificate2
//
// Authors:
//	Gert Driesen  <drieseng@users.sourceforge.net>
//	Sebastien Pouliot  <sebastien@ximian.com>
//
// Copyright (C) 2006-2007 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//


using System;
using System.IO;
using System.Threading;
using System.Globalization;
using System.Security;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using System.Text;

using NUnit.Framework;

namespace MonoTests.System.Security.Cryptography.X509Certificates {
	[TestFixture]
	public class X509Certificate2Test {
		public static byte[] cert_1 = { 0x30,0x82,0x01,0xFF,0x30,0x82,0x01,0x6C,0x02,0x05,0x02,0x72,0x00,0x06,0xE8,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x02,0x05,0x00,0x30,0x5F,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x20,0x30,0x1E,0x06,0x03,0x55,0x04,0x0A,0x13,0x17,0x52,0x53,0x41,0x20,0x44,0x61,0x74,0x61,0x20,0x53,0x65,0x63,0x75,0x72,0x69,0x74,0x79,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x31,0x2E,0x30,0x2C,0x06,0x03,0x55,0x04,0x0B,0x13,0x25,0x53,0x65,0x63,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,
			0x65,0x72,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x41,0x75,0x74,0x68,0x6F,0x72,0x69,0x74,0x79,0x30,0x1E,0x17,0x0D,0x39,0x36,0x30,0x33,0x31,0x32,0x31,0x38,0x33,0x38,0x34,0x37,0x5A,0x17,0x0D,0x39,0x37,0x30,0x33,0x31,0x32,0x31,0x38,0x33,0x38,0x34,0x36,0x5A,0x30,0x61,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x08,0x13,0x0A,0x43,0x61,0x6C,0x69,0x66,0x6F,0x72,0x6E,0x69,0x61,0x31,0x14,0x30,0x12,0x06,0x03,
			0x55,0x04,0x0A,0x13,0x0B,0x43,0x6F,0x6D,0x6D,0x65,0x72,0x63,0x65,0x4E,0x65,0x74,0x31,0x27,0x30,0x25,0x06,0x03,0x55,0x04,0x0B,0x13,0x1E,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x41,0x75,0x74,0x68,0x6F,0x72,0x69,0x74,0x79,0x30,0x70,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x5F,0x00,0x30,0x5C,0x02,0x55,0x2D,0x58,0xE9,0xBF,0xF0,0x31,0xCD,0x79,0x06,0x50,0x5A,0xD5,0x9E,0x0E,0x2C,0xE6,0xC2,0xF7,0xF9,
			0xD2,0xCE,0x55,0x64,0x85,0xB1,0x90,0x9A,0x92,0xB3,0x36,0xC1,0xBC,0xEA,0xC8,0x23,0xB7,0xAB,0x3A,0xA7,0x64,0x63,0x77,0x5F,0x84,0x22,0x8E,0xE5,0xB6,0x45,0xDD,0x46,0xAE,0x0A,0xDD,0x00,0xC2,0x1F,0xBA,0xD9,0xAD,0xC0,0x75,0x62,0xF8,0x95,0x82,0xA2,0x80,0xB1,0x82,0x69,0xFA,0xE1,0xAF,0x7F,0xBC,0x7D,0xE2,0x7C,0x76,0xD5,0xBC,0x2A,0x80,0xFB,0x02,0x03,0x01,0x00,0x01,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x02,0x05,0x00,0x03,0x7E,0x00,0x54,0x20,0x67,0x12,0xBB,0x66,0x14,0xC3,0x26,0x6B,0x7F,
			0xDA,0x4A,0x25,0x4D,0x8B,0xE0,0xFD,0x1E,0x53,0x6D,0xAC,0xA2,0xD0,0x89,0xB8,0x2E,0x90,0xA0,0x27,0x43,0xA4,0xEE,0x4A,0x26,0x86,0x40,0xFF,0xB8,0x72,0x8D,0x1E,0xE7,0xB7,0x77,0xDC,0x7D,0xD8,0x3F,0x3A,0x6E,0x55,0x10,0xA6,0x1D,0xB5,0x58,0xF2,0xF9,0x0F,0x2E,0xB4,0x10,0x55,0x48,0xDC,0x13,0x5F,0x0D,0x08,0x26,0x88,0xC9,0xAF,0x66,0xF2,0x2C,0x9C,0x6F,0x3D,0xC3,0x2B,0x69,0x28,0x89,0x40,0x6F,0x8F,0x35,0x3B,0x9E,0xF6,0x8E,0xF1,0x11,0x17,0xFB,0x0C,0x98,0x95,0xA1,0xC2,0xBA,0x89,0x48,0xEB,0xB4,0x06,0x6A,0x22,0x54,
			0xD7,0xBA,0x18,0x3A,0x48,0xA6,0xCB,0xC2,0xFD,0x20,0x57,0xBC,0x63,0x1C };

		public static byte[] cert_2 = { 0x30,0x82,0x01,0xDF,0x30,0x82,0x01,0x48,0x02,0x01,0x00,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x30,0x39,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x0D,0x30,0x0B,0x06,0x03,0x55,0x04,0x0A,0x14,0x04,0x41,0x54,0x26,0x54,0x31,0x1B,0x30,0x19,0x06,0x03,0x55,0x04,0x0B,0x14,0x12,0x44,0x69,0x72,0x65,0x63,0x74,0x6F,0x72,0x79,0x20,0x53,0x65,0x72,0x76,0x69,0x63,0x65,0x73,0x30,0x1E,0x17,0x0D,0x39,0x36,0x30,0x31,0x31,0x38,0x32,0x31,0x30,0x33,0x35,0x32,
			0x5A,0x17,0x0D,0x30,0x31,0x30,0x31,0x31,0x36,0x32,0x31,0x30,0x33,0x35,0x32,0x5A,0x30,0x39,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x0D,0x30,0x0B,0x06,0x03,0x55,0x04,0x0A,0x14,0x04,0x41,0x54,0x26,0x54,0x31,0x1B,0x30,0x19,0x06,0x03,0x55,0x04,0x0B,0x14,0x12,0x44,0x69,0x72,0x65,0x63,0x74,0x6F,0x72,0x79,0x20,0x53,0x65,0x72,0x76,0x69,0x63,0x65,0x73,0x30,0x81,0x9D,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8B,0x00,0x30,0x81,0x87,
			0x02,0x81,0x81,0x00,0x87,0x64,0x72,0x89,0x0B,0x20,0x8F,0x87,0x27,0xAC,0xC6,0x22,0xFE,0x00,0x40,0x69,0x48,0xAF,0xC6,0x86,0xCD,0x23,0x33,0xE3,0x11,0xC5,0x31,0x1A,0x1F,0x7E,0x9E,0x92,0x13,0xB6,0xA2,0xAC,0xE3,0xB0,0x1F,0x2A,0x07,0x6C,0xB6,0xD4,0xDE,0x4B,0xFA,0xF1,0xA2,0xA0,0x7D,0xCE,0x4B,0xBE,0xBE,0x26,0x48,0x09,0x8C,0x85,0x11,0xDE,0xCB,0x22,0xE7,0xC2,0xEE,0x44,0x51,0xFE,0x67,0xD5,0x5B,0x5A,0xE0,0x16,0x37,0x54,0x04,0xB8,0x3B,0x32,0x12,0x94,0x83,0x9E,0xB1,0x4D,0x80,0x6C,0xA4,0xA9,0x76,0xAC,0xB8,0xA4,
			0x97,0xF7,0xAB,0x0B,0x6C,0xA5,0x43,0xBA,0x6E,0x4F,0xC5,0x4E,0x00,0x30,0x16,0x3C,0x3F,0x99,0x14,0xDA,0xA2,0x20,0x08,0x8B,0xBA,0xED,0x76,0xAC,0x97,0x00,0xD5,0x6D,0x02,0x01,0x0F,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x03,0x81,0x81,0x00,0x38,0x50,0x1D,0x0A,0xD3,0x1B,0xBB,0xA2,0x9F,0x6C,0x8D,0x10,0xAA,0x42,0x1B,0x05,0x8D,0xE4,0x25,0xAB,0xFB,0x55,0xAE,0x6D,0xBA,0x53,0x67,0x15,0x07,0x9A,0xEC,0x55,0x9F,0x72,0x89,0x5F,0x24,0xB0,0xDB,0xCA,0x64,0xBD,0x64,0xAA,0xC2,0x8C,
			0xD9,0x3D,0xA2,0x45,0xB7,0xC6,0x92,0x71,0x51,0xEF,0xED,0xE1,0x51,0x54,0x97,0x56,0x35,0xA1,0xCE,0xE4,0x44,0xC4,0x47,0x66,0xFF,0x91,0xDA,0x88,0x9C,0x23,0xC2,0xB3,0xD4,0x62,0x4A,0xBC,0x94,0x55,0x9C,0x80,0x8E,0xB3,0xDD,0x4F,0x1A,0xED,0x12,0x5A,0xB5,0x2E,0xBC,0xF8,0x4B,0xCE,0xC6,0xD4,0x70,0xB3,0xB3,0x22,0xF8,0x5E,0x5C,0x36,0x7A,0xA6,0xB8,0x39,0x73,0x46,0x43,0x5C,0x9B,0x9A,0xBD,0x1E,0x7E,0xA7,0x04,0xCF,0x25,0x36 };

		public static byte[] cert_3 = { 0x30,0x82,0x03,0x4E,0x30,0x82,0x02,0xB7,0xA0,0x03,0x02,0x01,0x02,0x02,0x20,0x03,0x53,0xD7,0x8B,0xDB,0x3E,0x16,0x15,0x80,0x55,0xC4,0x05,0x40,0x02,0x73,0x4D,0x0C,0x20,0xF8,0x0D,0x88,0x00,0x5F,0x65,0x7A,0xAC,0xBA,0x86,0xBD,0x1C,0xD7,0xE4,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x49,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x43,0x43,0x41,0x20,0x2D,0x20,0x55,0x6E,0x69,0x71,0x75,0x65,0x20,
			0x49,0x44,0x31,0x20,0x30,0x1E,0x06,0x03,0x55,0x04,0x03,0x13,0x17,0x42,0x72,0x61,0x6E,0x64,0x20,0x4E,0x61,0x6D,0x65,0x3A,0x50,0x72,0x6F,0x64,0x75,0x63,0x74,0x20,0x54,0x79,0x70,0x65,0x30,0x1E,0x17,0x0D,0x39,0x36,0x30,0x38,0x30,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x39,0x36,0x30,0x38,0x33,0x31,0x32,0x33,0x35,0x39,0x35,0x39,0x5A,0x30,0x6E,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x10,0x30,0x0E,0x06,0x03,0x55,0x04,0x0A,0x13,0x07,0x42,0x72,0x61,0x6E,0x64,0x49,
			0x44,0x31,0x26,0x30,0x24,0x06,0x03,0x55,0x04,0x0B,0x13,0x1D,0x49,0x73,0x73,0x75,0x69,0x6E,0x67,0x20,0x46,0x69,0x6E,0x61,0x6E,0x63,0x69,0x61,0x6C,0x20,0x49,0x6E,0x73,0x74,0x69,0x74,0x75,0x74,0x69,0x6F,0x6E,0x31,0x25,0x30,0x23,0x06,0x03,0x55,0x04,0x03,0x13,0x1C,0x30,0x2B,0x57,0x4B,0x4A,0x78,0x2B,0x77,0x59,0x45,0x5A,0x61,0x62,0x53,0x53,0x50,0x56,0x58,0x39,0x6B,0x4C,0x73,0x6E,0x78,0x39,0x32,0x73,0x3D,0x30,0x5C,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x4B,0x00,
			0x30,0x48,0x02,0x41,0x00,0xAC,0xC4,0x0E,0x05,0x25,0xBC,0xEA,0xEF,0x0C,0x22,0x7F,0xC4,0x0C,0x4A,0x69,0x31,0x00,0xF9,0x3F,0xE9,0xE1,0x6C,0x54,0x97,0x77,0x4E,0x18,0xC6,0x4A,0x95,0xE0,0xD4,0x58,0x29,0x5C,0x17,0x5D,0x1D,0x1E,0x56,0xBC,0x49,0x3D,0xE0,0xF9,0x9F,0xBB,0x01,0xF9,0x86,0xB6,0xA6,0x95,0xDD,0xE1,0x04,0x32,0x01,0x52,0x4E,0x8F,0x86,0x30,0xF7,0x02,0x03,0x01,0x00,0x01,0xA3,0x82,0x01,0x44,0x30,0x82,0x01,0x40,0x30,0x5C,0x06,0x03,0x55,0x1D,0x23,0x04,0x55,0x30,0x53,0x81,0x4B,0x84,0x49,0x31,0x0B,0x30,
			0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x43,0x43,0x41,0x20,0x2D,0x20,0x55,0x6E,0x69,0x71,0x75,0x65,0x20,0x49,0x44,0x31,0x20,0x30,0x1E,0x06,0x03,0x55,0x04,0x03,0x13,0x17,0x42,0x72,0x61,0x6E,0x64,0x20,0x4E,0x61,0x6D,0x65,0x3A,0x50,0x72,0x6F,0x64,0x75,0x63,0x74,0x20,0x54,0x79,0x70,0x65,0x82,0x04,0x32,0x06,0xAC,0x10,0x30,0x0E,0x06,0x03,0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x07,0x80,0x30,0x2E,0x06,0x03,0x55,0x1D,0x10,0x01,
			0x01,0xFF,0x04,0x24,0x30,0x22,0x80,0x0F,0x31,0x39,0x39,0x36,0x30,0x38,0x30,0x37,0x30,0x37,0x34,0x39,0x30,0x30,0x5A,0x81,0x0F,0x31,0x39,0x39,0x36,0x30,0x39,0x30,0x37,0x30,0x37,0x34,0x39,0x30,0x30,0x5A,0x30,0x18,0x06,0x03,0x55,0x1D,0x20,0x04,0x11,0x30,0x0F,0x30,0x0D,0x06,0x0B,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x01,0x07,0x01,0x01,0x30,0x0C,0x06,0x03,0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x02,0x30,0x00,0x30,0x14,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x02,0x03,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,
			0x07,0x80,0x30,0x62,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x02,0x07,0x01,0x01,0xFF,0x04,0x52,0x30,0x50,0x04,0x14,0x33,0x39,0x38,0x32,0x33,0x39,0x38,0x37,0x32,0x33,0x37,0x38,0x39,0x31,0x33,0x34,0x39,0x37,0x38,0x32,0x30,0x09,0x06,0x05,0x2B,0x0D,0x03,0x02,0x1A,0x05,0x00,0x16,0x0F,0x74,0x65,0x72,0x73,0x65,0x20,0x73,0x74,0x61,0x74,0x65,0x6D,0x65,0x6E,0x74,0x1D,0x00,0x16,0x1A,0x67,0x65,0x74,0x73,0x65,0x74,0x2D,0x63,0x65,0x6E,0x74,0x65,0x72,0x40,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,
			0x6F,0x6D,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x81,0x81,0x00,0x1D,0x6C,0x90,0xF2,0x02,0x10,0xD5,0xA0,0x7B,0xEB,0x07,0x14,0x1D,0xAE,0x2C,0xD5,0xB1,0x4C,0x23,0x30,0xB2,0x31,0x7F,0x96,0x3C,0xD1,0x41,0x11,0xEA,0x08,0x0D,0x80,0x5F,0x46,0x66,0x9D,0x0A,0xF2,0x91,0xE8,0x7C,0xCE,0xC0,0xAD,0xE6,0x96,0x19,0x9C,0x26,0xC3,0x4E,0xEB,0x6F,0xF4,0x4A,0x69,0x4C,0xFE,0x4C,0x76,0xB3,0x51,0xCA,0x44,0x03,0xFC,0xD4,0xF4,0xF9,0x32,0x2A,0xAE,0x03,0x1B,0x5F,0xA6,0xBF,0x16,0x61,
			0xA0,0x07,0x86,0x85,0xA7,0xD6,0x0D,0xEF,0x88,0x9B,0x2A,0xBA,0xB8,0xD4,0x5C,0x94,0x7C,0x63,0xE1,0xE0,0x69,0xEB,0x3D,0x2F,0xC1,0x71,0x56,0x47,0x55,0x4B,0xB8,0xFD,0xCD,0xD6,0xC7,0x6F,0xA7,0x47,0xE9,0x43,0x91,0x2E,0xCF,0x93,0xA4,0x05,0x18,0xC5,0x98 };

		public static byte[] cert_4 = { 0x30,0x82,0x02,0x29,0x30,0x82,0x01,0x96,0x02,0x05,0x02,0x41,0x00,0x00,0x01,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x02,0x05,0x00,0x30,0x5F,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x20,0x30,0x1E,0x06,0x03,0x55,0x04,0x0A,0x13,0x17,0x52,0x53,0x41,0x20,0x44,0x61,0x74,0x61,0x20,0x53,0x65,0x63,0x75,0x72,0x69,0x74,0x79,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x31,0x2E,0x30,0x2C,0x06,0x03,0x55,0x04,0x0B,0x13,0x25,0x53,0x65,0x63,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,
			0x65,0x72,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x41,0x75,0x74,0x68,0x6F,0x72,0x69,0x74,0x79,0x30,0x1E,0x17,0x0D,0x39,0x34,0x31,0x31,0x30,0x39,0x32,0x33,0x35,0x34,0x31,0x37,0x5A,0x17,0x0D,0x39,0x39,0x31,0x32,0x33,0x31,0x32,0x33,0x35,0x34,0x31,0x37,0x5A,0x30,0x5F,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x20,0x30,0x1E,0x06,0x03,0x55,0x04,0x0A,0x13,0x17,0x52,0x53,0x41,0x20,0x44,0x61,0x74,0x61,0x20,0x53,0x65,0x63,0x75,0x72,0x69,0x74,
			0x79,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x31,0x2E,0x30,0x2C,0x06,0x03,0x55,0x04,0x0B,0x13,0x25,0x53,0x65,0x63,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x41,0x75,0x74,0x68,0x6F,0x72,0x69,0x74,0x79,0x30,0x81,0x9B,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x89,0x00,0x30,0x81,0x85,0x02,0x7E,0x00,0x92,0xCE,0x7A,0xC1,0xAE,0x83,0x3E,0x5A,0xAA,0x89,0x83,0x57,0xAC,0x25,0x01,0x76,0x0C,
			0xAD,0xAE,0x8E,0x2C,0x37,0xCE,0xEB,0x35,0x78,0x64,0x54,0x03,0xE5,0x84,0x40,0x51,0xC9,0xBF,0x8F,0x08,0xE2,0x8A,0x82,0x08,0xD2,0x16,0x86,0x37,0x55,0xE9,0xB1,0x21,0x02,0xAD,0x76,0x68,0x81,0x9A,0x05,0xA2,0x4B,0xC9,0x4B,0x25,0x66,0x22,0x56,0x6C,0x88,0x07,0x8F,0xF7,0x81,0x59,0x6D,0x84,0x07,0x65,0x70,0x13,0x71,0x76,0x3E,0x9B,0x77,0x4C,0xE3,0x50,0x89,0x56,0x98,0x48,0xB9,0x1D,0xA7,0x29,0x1A,0x13,0x2E,0x4A,0x11,0x59,0x9C,0x1E,0x15,0xD5,0x49,0x54,0x2C,0x73,0x3A,0x69,0x82,0xB1,0x97,0x39,0x9C,0x6D,0x70,0x67,
			0x48,0xE5,0xDD,0x2D,0xD6,0xC8,0x1E,0x7B,0x02,0x03,0x01,0x00,0x01,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x02,0x05,0x00,0x03,0x7E,0x00,0x88,0xD1,0xD1,0x79,0x21,0xCE,0xE2,0x8B,0xE8,0xF8,0xC1,0x7D,0x34,0x53,0x3F,0x61,0x83,0xD9,0xB6,0x0B,0x38,0x17,0xB6,0xE8,0xBE,0x21,0x8D,0x8F,0x00,0xB8,0x8B,0x53,0x7E,0x44,0x67,0x1E,0x22,0xBD,0x97,0x27,0xE0,0x9C,0x85,0xCC,0x4A,0xF6,0x85,0x3B,0xB2,0xE2,0xBE,0x92,0xD3,0xE5,0x0D,0xE9,0xAF,0x5C,0x0E,0x0C,0x46,0x95,0xFF,0xA1,0x1C,0x5E,0x3E,0xE8,0x36,
			0x58,0x7A,0x73,0xA6,0x0A,0xF8,0x22,0x11,0x6B,0xC3,0x09,0x38,0x7E,0x26,0xBB,0x73,0xEF,0x00,0xBD,0x02,0xA4,0xF3,0x14,0x0D,0x30,0x3F,0x61,0x70,0x7B,0x20,0xFE,0x32,0xA3,0x9F,0xB3,0xF4,0x67,0x52,0xDC,0xB4,0xEE,0x84,0x8C,0x96,0x36,0x20,0xDE,0x81,0x08,0x83,0x71,0x21,0x8A,0x0F,0x9E,0xA9 };

		public static byte[] cert_5 = { 0x30,0x82,0x06,0x2F,0x30,0x82,0x05,0x17,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x6A,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x20,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x11,0x30,0x0F,0x06,0x03,0x55,0x04,0x0A,0x13,0x08,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,0x74,0x30,0x1E,0x17,0x0D,0x39,0x37,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x30,0x34,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x30,0x20,0x31,0x0B,
			0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x11,0x30,0x0F,0x06,0x03,0x55,0x04,0x0A,0x13,0x08,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,0x74,0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xD4,0xDC,0x3E,0xBA,0xE1,0x94,0xF7,0xBE,0xCD,0xED,0x21,0x77,0xCF,0xDA,0x88,0x58,0x51,0x0E,0x8F,0xF4,0xDA,0x00,0x14,0x1E,0x0D,0xA7,0xAD,0xB6,0x96,0x5A,0xC6,0xD3,0xEC,0x25,0xED,0xD8,0x43,
			0x0B,0x6E,0x7F,0x3F,0x9E,0x1E,0x74,0xA0,0x1E,0x97,0x76,0x30,0xCA,0x6F,0x0A,0x63,0xC0,0xA3,0x31,0x40,0x25,0x80,0xB8,0xBD,0x28,0xEB,0x7D,0x75,0x0B,0x4E,0x41,0x34,0xC4,0x20,0x00,0xC2,0xCB,0xF4,0x9A,0x20,0x00,0x58,0xD9,0xF4,0x40,0x13,0x18,0x77,0x0C,0xB5,0x04,0xDE,0xB7,0xB6,0x43,0x8B,0xA4,0xCC,0x36,0x76,0x79,0xC5,0x0B,0x17,0xCB,0x7E,0x88,0xA1,0x33,0xB0,0xD3,0x34,0x27,0xBF,0x3B,0x61,0xDA,0xC5,0x20,0xEB,0xF9,0x94,0x9A,0x8B,0x79,0xB2,0xA8,0x8E,0xCB,0xC1,0xD9,0x94,0x4A,0x99,0x66,0x50,0x55,0xB2,0x83,0x28,
			0x7D,0x22,0x3D,0xEC,0xDC,0xA3,0xE8,0x39,0xDB,0x83,0x54,0xC9,0x89,0xA9,0xDF,0x59,0x52,0x9F,0x7A,0xEF,0x7C,0x11,0x62,0x52,0xEC,0xE6,0x67,0xBA,0x3D,0xEA,0xAB,0x47,0xDB,0xE4,0xF4,0x1F,0x73,0xC3,0x3D,0xEC,0x7E,0x84,0x7D,0x2F,0x29,0xFE,0x6C,0x17,0x3F,0x75,0x6D,0x56,0x6E,0xC0,0x4E,0xB5,0xBF,0x2A,0x20,0x8A,0xE4,0x57,0xAE,0xC0,0x2E,0x68,0xC9,0x09,0xCF,0x85,0x77,0x0A,0xEF,0x3A,0x37,0xCB,0x60,0x4C,0x45,0x73,0x7F,0x90,0x3E,0x86,0x1D,0xFA,0xC3,0xFC,0x50,0x8A,0xB2,0xC5,0x8A,0x34,0xF0,0xF2,0x43,0xEE,0x3C,0x56,
			0xBA,0x24,0xE9,0xE0,0xA5,0x87,0x1E,0x7C,0x30,0x33,0x77,0xFD,0x5D,0xE0,0x57,0x0D,0x6C,0x19,0x39,0x02,0x03,0x01,0x00,0x01,0xA3,0x82,0x03,0x72,0x30,0x82,0x03,0x6E,0x30,0x12,0x06,0x03,0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x03,0x30,0x82,0x02,0xC9,0x06,0x03,0x55,0x1D,0x20,0x01,0x01,0xFF,0x04,0x82,0x02,0xBD,0x30,0x82,0x02,0xB9,0x30,0x82,0x02,0xB5,0x06,0x04,0x67,0x2A,0x05,0x00,0x30,0x82,0x02,0xAB,0x30,0x82,0x02,0xA7,0x06,0x04,0x67,0x2A,0x07,0x06,0x30,0x82,0x02,0x9D,
			0x30,0x82,0x02,0x99,0x1A,0x82,0x02,0x95,0x54,0x68,0x69,0x73,0x20,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x61,0x6E,0x64,0x20,0x61,0x6E,0x79,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x61,0x75,0x74,0x68,0x65,0x6E,0x74,0x69,0x63,0x61,0x74,0x65,0x64,0x20,0x64,0x69,0x72,0x65,0x63,0x74,0x6C,0x79,0x20,0x6F,0x72,0x20,0x69,0x6E,0x64,0x69,0x72,0x65,0x63,0x74,0x6C,0x79,0x20,0x62,0x79,0x20,0x74,0x68,0x69,0x73,0x20,0x63,
			0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x2C,0x20,0x6D,0x61,0x79,0x20,0x6F,0x6E,0x6C,0x79,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x74,0x6F,0x20,0x65,0x6E,0x61,0x62,0x6C,0x65,0x20,0x22,0x53,0x65,0x63,0x75,0x72,0x65,0x20,0x46,0x69,0x6E,0x61,0x6E,0x63,0x69,0x61,0x6C,0x20,0x54,0x72,0x61,0x6E,0x73,0x61,0x63,0x74,0x69,0x6F,0x6E,0x73,0x22,0x20,0x61,0x73,0x20,0x64,0x65,0x66,0x69,0x6E,0x65,0x64,0x20,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x65,
			0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x50,0x72,0x61,0x63,0x74,0x69,0x63,0x65,0x20,0x53,0x74,0x61,0x74,0x65,0x6D,0x65,0x6E,0x74,0x20,0x61,0x6E,0x64,0x2C,0x20,0x77,0x68,0x65,0x6E,0x20,0x61,0x70,0x70,0x72,0x6F,0x70,0x72,0x69,0x61,0x74,0x65,0x2C,0x20,0x69,0x6E,0x20,0x61,0x20,0x53,0x45,0x54,0x20,0x42,0x72,0x61,0x6E,0x64,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x50,0x72,0x61,0x63,0x74,0x69,0x63,0x65,0x20,0x53,0x74,0x61,0x74,0x65,0x6D,0x65,0x6E,0x74,0x2E,0x20,0x20,
			0x4E,0x6F,0x20,0x50,0x61,0x72,0x74,0x79,0x20,0x6D,0x61,0x79,0x20,0x72,0x65,0x6C,0x79,0x20,0x75,0x70,0x6F,0x6E,0x20,0x74,0x68,0x65,0x20,0x53,0x45,0x54,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x66,0x6F,0x72,0x20,0x61,0x6E,0x79,0x20,0x6F,0x74,0x68,0x65,0x72,0x20,0x70,0x75,0x72,0x70,0x6F,0x73,0x65,0x2E,0x20,0x20,0x41,0x20,0x53,0x45,0x54,0x20,0x42,0x72,0x61,0x6E,0x64,0x20,0x73,0x68,0x61,0x6C,0x6C,0x20,0x62,0x65,0x20,0x61,0x6E,0x79,0x20,0x70,0x61,0x79,
			0x6D,0x65,0x6E,0x74,0x20,0x62,0x72,0x61,0x6E,0x64,0x20,0x77,0x68,0x6F,0x73,0x65,0x20,0x53,0x45,0x54,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x69,0x73,0x20,0x73,0x69,0x67,0x6E,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x20,0x6B,0x65,0x79,0x20,0x63,0x6F,0x72,0x72,0x65,0x73,0x70,0x6F,0x6E,0x64,0x69,0x6E,0x67,0x20,0x74,0x6F,0x20,0x74,0x68,0x65,0x20,0x70,0x75,0x62,0x6C,0x69,0x63,0x20,0x6B,0x65,0x79,0x20,0x63,0x6F,0x6E,0x74,0x61,0x69,
			0x6E,0x65,0x64,0x20,0x69,0x6E,0x20,0x74,0x68,0x69,0x73,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x2E,0x20,0x20,0x41,0x6C,0x6C,0x20,0x6D,0x61,0x74,0x74,0x65,0x72,0x73,0x20,0x72,0x65,0x6C,0x61,0x74,0x69,0x6E,0x67,0x20,0x74,0x6F,0x20,0x75,0x73,0x61,0x67,0x65,0x2C,0x20,0x6C,0x69,0x61,0x62,0x69,0x6C,0x69,0x74,0x79,0x20,0x61,0x6E,0x64,0x20,0x70,0x72,0x6F,0x63,0x65,0x64,0x75,0x72,0x65,0x73,0x20,0x77,0x69,0x74,0x68,0x20,0x53,0x45,0x54,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,
			0x74,0x65,0x73,0x20,0x69,0x73,0x73,0x75,0x65,0x64,0x20,0x62,0x65,0x6E,0x65,0x61,0x74,0x68,0x20,0x61,0x20,0x53,0x45,0x54,0x20,0x42,0x72,0x61,0x6E,0x64,0x20,0x73,0x68,0x61,0x6C,0x6C,0x20,0x62,0x65,0x20,0x64,0x65,0x74,0x65,0x72,0x6D,0x69,0x6E,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,0x61,0x74,0x20,0x53,0x45,0x54,0x20,0x42,0x72,0x61,0x6E,0x64,0x2E,0x30,0x0E,0x06,0x03,0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x2B,0x06,0x03,0x55,0x1D,0x10,0x04,0x24,0x30,0x22,0x80,0x0F,0x31,0x39,
			0x39,0x37,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x81,0x0F,0x31,0x39,0x39,0x38,0x30,0x37,0x31,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x30,0x10,0x06,0x04,0x67,0x2A,0x07,0x01,0x01,0x01,0xFF,0x04,0x05,0x03,0x03,0x07,0x00,0x80,0x30,0x3C,0x06,0x04,0x67,0x2A,0x07,0x00,0x01,0x01,0xFF,0x04,0x31,0x30,0x2F,0x30,0x2D,0x02,0x01,0x00,0x30,0x09,0x06,0x05,0x2B,0x0E,0x03,0x02,0x1A,0x05,0x00,0x30,0x07,0x06,0x05,0x67,0x2A,0x03,0x00,0x00,0x04,0x14,0xC8,0x57,0x44,0x4F,0xD7,0x91,0x56,0x3E,0xC6,0xF3,
			0xE0,0xE6,0x08,0x2E,0x9A,0xAF,0x61,0x11,0x43,0x5D,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x91,0x6D,0x0D,0x97,0xB7,0x8D,0x44,0x23,0xB9,0x49,0xAD,0x23,0xA9,0x8B,0xED,0x93,0x33,0x97,0x4C,0xE1,0x6E,0xB1,0x34,0x96,0x18,0xF3,0x58,0xB3,0x9C,0xBF,0x63,0x0F,0x61,0x46,0xC7,0xD1,0x01,0x41,0x0C,0xC8,0x42,0x55,0x6B,0x54,0x71,0x06,0x3B,0xF7,0xD1,0x77,0x65,0xDF,0x16,0xE7,0x63,0x03,0x7B,0x23,0x26,0x28,0xEC,0x94,0xF8,0x9F,0x94,0x04,0x0F,0xE5,0x45,0x99,
			0x4E,0xB5,0x1B,0xBC,0xB9,0xC4,0xB0,0xE2,0x8A,0x3E,0x05,0xA6,0xE3,0x56,0x7D,0x01,0x77,0xAB,0xC2,0xA6,0x72,0x90,0x23,0xD3,0x15,0x8F,0x0F,0xEA,0x7B,0x31,0xDE,0x89,0x31,0xF0,0x1B,0x81,0x6B,0x5F,0xA8,0x13,0xC6,0x62,0x7D,0xFE,0x74,0x14,0x40,0x2A,0x14,0xC2,0xA1,0x1B,0x9C,0xB2,0xD6,0xEF,0x2A,0x6D,0xA5,0xF7,0xA6,0x38,0x8F,0xD4,0x94,0x74,0x30,0x10,0x9E,0xBA,0xA9,0xAB,0x6B,0x61,0x6B,0xFC,0xB2,0x3F,0x87,0x6B,0x19,0x82,0x83,0x70,0xE7,0xD8,0xEA,0x28,0x7B,0xB4,0x29,0x47,0xF4,0x59,0xB3,0x3E,0x4B,0x6A,0x9D,0x54,
			0x0D,0x4E,0x1C,0xD0,0x29,0xB4,0xD1,0xE1,0x19,0x79,0x41,0x73,0xF6,0x57,0x72,0xBE,0x75,0x03,0x94,0xD7,0x58,0xA8,0xC4,0x08,0x71,0xA2,0xE3,0x16,0x31,0xCD,0xC0,0xEE,0x1C,0x21,0x26,0x52,0x55,0x7B,0x00,0x54,0x6D,0xA6,0x44,0xC2,0x4F,0xEA,0x8F,0x04,0x1C,0x3A,0xA2,0xE3,0x5B,0xD7,0x9D,0xE2,0x57,0x30,0x2C,0xF5,0xAE,0x62,0x3B,0xB5,0x49,0x89,0xCB,0x01,0xD1,0x5A,0x38,0xDE,0x97,0x57,0x85,0x91,0x68,0x6B,0xFD,0xEC,0xD3,0x80,0xF0,0x82,0xBF,0x9A };

		public static byte[] cert_8 = { 0x30,0x82,0x03,0x04,0x30,0x82,0x02,0xC4,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x03,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x30,0x51,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x31,0x0C,0x30,0x0A,0x06,0x03,0x55,0x04,0x0B,0x13,0x03,0x44,0x6F,0x44,0x31,0x1A,0x30,0x18,0x06,0x03,0x55,0x04,0x03,0x13,0x11,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,
			0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x30,0x1E,0x17,0x0D,0x30,0x30,0x31,0x30,0x32,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x30,0x33,0x30,0x31,0x30,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x30,0x51,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x31,0x0C,0x30,0x0A,0x06,0x03,0x55,0x04,0x0B,0x13,0x03,0x44,0x6F,0x44,0x31,0x1A,0x30,0x18,
			0x06,0x03,0x55,0x04,0x03,0x13,0x11,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x30,0x82,0x01,0xB6,0x30,0x82,0x01,0x2B,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x01,0x30,0x82,0x01,0x1E,0x02,0x81,0x81,0x00,0x90,0x89,0x3E,0x18,0x1B,0xFE,0xA3,0x1D,0x16,0x89,0x00,0xB4,0xD5,0x40,0x82,0x4C,0x2E,0xEC,0x3D,0x66,0x0D,0x0D,0xB9,0x17,0x40,0x6E,0x3A,0x5C,0x03,0x7B,0x1B,0x93,0x28,0x0C,0xEF,0xB9,0x97,0xE3,0xA1,0xEB,0xE2,0xA3,0x7C,0x61,0xDD,0x6F,0xD5,0xAD,0x15,0x69,0x00,
			0x16,0xB2,0xC3,0x08,0x3D,0xC4,0x59,0xC6,0xF2,0x70,0xA5,0xB0,0xF5,0x1F,0x1D,0xF4,0xB0,0x15,0xDA,0x7E,0x28,0x39,0x24,0x99,0x36,0x5B,0xEC,0x39,0x25,0xFA,0x92,0x49,0x65,0xD2,0x43,0x05,0x6A,0x9E,0xA3,0x7B,0xF0,0xDE,0xA3,0x2F,0xD3,0x6F,0x3A,0xF9,0x35,0xC3,0x29,0xD4,0x45,0x6C,0x56,0x9A,0xDE,0x36,0x6E,0xFE,0x12,0x68,0x96,0x7B,0x45,0x1D,0x2C,0xFF,0xB9,0x2D,0xF5,0x52,0x8C,0xDF,0x3E,0x2F,0x63,0x02,0x15,0x00,0x81,0xA9,0xB5,0xD0,0x04,0xF2,0x9B,0xA7,0xD8,0x55,0x4C,0x3B,0x32,0xA1,0x45,0x32,0x4F,0xF5,0x51,0xDD,
			0x02,0x81,0x80,0x64,0x7A,0x88,0x0B,0xF2,0x3E,0x91,0x81,0x59,0x9C,0xF4,0xEA,0xC6,0x7B,0x0E,0xBE,0xEA,0x05,0xE8,0x77,0xFD,0x20,0x34,0x87,0xA1,0xC4,0x69,0xF6,0xC8,0x8B,0x19,0xDA,0xCD,0xFA,0x21,0x8A,0x57,0xA9,0x7A,0x26,0x0A,0x56,0xD4,0xED,0x4B,0x1B,0x7C,0x70,0xED,0xB4,0xE6,0x7A,0x6A,0xDE,0xD3,0x29,0xE2,0xE9,0x9A,0x33,0xED,0x09,0x8D,0x9E,0xDF,0xDA,0x2E,0x4A,0xC1,0x50,0x92,0xEE,0x2F,0xE5,0x5A,0xF3,0x85,0x62,0x6A,0x48,0xDC,0x1B,0x02,0x98,0xA6,0xB0,0xD1,0x09,0x4B,0x10,0xD1,0xF0,0xFA,0xE0,0xB1,0x1D,0x13,
			0x54,0x4B,0xC0,0xA8,0x40,0xEF,0x71,0xE8,0x56,0x6B,0xA2,0x29,0xCB,0x1E,0x09,0x7D,0x27,0x39,0x91,0x3B,0x20,0x4F,0x98,0x39,0xE8,0x39,0xCA,0x98,0xC5,0xAF,0x54,0x03,0x81,0x84,0x00,0x02,0x81,0x80,0x54,0xA8,0x88,0xB5,0x8F,0x01,0x56,0xCE,0x18,0x8F,0xA6,0xD6,0x7C,0x29,0x29,0x75,0x45,0xE8,0x31,0xA4,0x07,0x17,0xED,0x1E,0x5D,0xB2,0x7B,0xBB,0xCE,0x3C,0x97,0x67,0x1E,0x88,0x0A,0xFE,0x7D,0x00,0x22,0x27,0x1D,0x66,0xEE,0xF6,0x1B,0xB6,0x95,0x7F,0x5A,0xFF,0x06,0x34,0x02,0x43,0xC3,0x83,0xC4,0x66,0x2C,0xA1,0x05,0x0E,
			0x68,0xB3,0xCA,0xDC,0xD3,0xF9,0x0C,0xC0,0x66,0xDF,0x85,0x84,0x4B,0x20,0x5D,0x41,0xAC,0xC0,0xEC,0x37,0x92,0x0E,0x97,0x19,0xBF,0x53,0x35,0x63,0x27,0x18,0x33,0x35,0x42,0x4D,0xF0,0x2D,0x6D,0xA7,0xA4,0x98,0xAA,0x57,0xF3,0xD2,0xB8,0x6E,0x4E,0x8F,0xFF,0xBE,0x6F,0x4E,0x0F,0x0B,0x44,0x24,0xEE,0xDF,0x4C,0x22,0x5B,0x44,0x98,0x94,0xCB,0xB8,0xA3,0x2F,0x30,0x2D,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x9D,0x2D,0x73,0xC3,0xB8,0xE3,0x4D,0x29,0x28,0xC3,0x65,0xBE,0xA9,0x98,0xCB,0xD6,0x8A,0x06,0x68,
			0x9C,0x30,0x0C,0x06,0x03,0x55,0x1D,0x13,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x03,0x2F,0x00,0x30,0x2C,0x02,0x14,0x5A,0x1B,0x2D,0x08,0x0E,0xE6,0x99,0x38,0x8F,0xB5,0x09,0xC9,0x89,0x79,0x7E,0x01,0x30,0xBD,0xCE,0xF0,0x02,0x14,0x71,0x7B,0x08,0x51,0x97,0xCE,0x4D,0x1F,0x6A,0x84,0x47,0x3A,0xC0,0xBD,0x13,0x89,0x81,0xB9,0x01,0x97 };

		public static byte[] cert_9 = { 0x30,0x82,0x09,0xB9,0x30,0x82,0x09,0x22,0xA0,0x03,0x02,0x01,0x02,0x02,0x10,0x20,0x0B,0x35,0x5E,0xCE,0xC4,0xB0,0x63,0xB7,0xDE,0xC6,0x34,0xB9,0x70,0x34,0x44,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x30,0x62,0x31,0x11,0x30,0x0F,0x06,0x03,0x55,0x04,0x07,0x13,0x08,0x49,0x6E,0x74,0x65,0x72,0x6E,0x65,0x74,0x31,0x17,0x30,0x15,0x06,0x03,0x55,0x04,0x0A,0x13,0x0E,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x31,0x34,0x30,0x32,0x06,0x03,0x55,0x04,0x0B,
			0x13,0x2B,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x43,0x6C,0x61,0x73,0x73,0x20,0x31,0x20,0x43,0x41,0x20,0x2D,0x20,0x49,0x6E,0x64,0x69,0x76,0x69,0x64,0x75,0x61,0x6C,0x20,0x53,0x75,0x62,0x73,0x63,0x72,0x69,0x62,0x65,0x72,0x30,0x1E,0x17,0x0D,0x39,0x36,0x30,0x38,0x32,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x39,0x37,0x30,0x38,0x32,0x30,0x32,0x33,0x35,0x39,0x35,0x39,0x5A,0x30,0x82,0x01,0x0A,0x31,0x11,0x30,0x0F,0x06,0x03,0x55,0x04,0x07,0x13,0x08,0x49,0x6E,0x74,0x65,0x72,0x6E,0x65,0x74,
			0x31,0x17,0x30,0x15,0x06,0x03,0x55,0x04,0x0A,0x13,0x0E,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x31,0x34,0x30,0x32,0x06,0x03,0x55,0x04,0x0B,0x13,0x2B,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x43,0x6C,0x61,0x73,0x73,0x20,0x31,0x20,0x43,0x41,0x20,0x2D,0x20,0x49,0x6E,0x64,0x69,0x76,0x69,0x64,0x75,0x61,0x6C,0x20,0x53,0x75,0x62,0x73,0x63,0x72,0x69,0x62,0x65,0x72,0x31,0x46,0x30,0x44,0x06,0x03,0x55,0x04,0x0B,0x13,0x3D,0x77,0x77,0x77,0x2E,0x76,0x65,0x72,0x69,0x73,0x69,
			0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x2F,0x43,0x50,0x53,0x20,0x49,0x6E,0x63,0x6F,0x72,0x70,0x2E,0x20,0x62,0x79,0x20,0x52,0x65,0x66,0x2E,0x2C,0x4C,0x49,0x41,0x42,0x2E,0x4C,0x54,0x44,0x28,0x63,0x29,0x39,0x36,0x31,0x26,0x30,0x24,0x06,0x03,0x55,0x04,0x0B,0x13,0x1D,0x44,0x69,0x67,0x69,0x74,0x61,0x6C,0x20,0x49,0x44,0x20,0x43,0x6C,0x61,0x73,0x73,0x20,0x31,0x20,0x2D,0x20,0x4E,0x65,0x74,0x73,0x63,0x61,0x70,0x65,0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,
			0x13,0x0D,0x44,0x61,0x76,0x69,0x64,0x20,0x54,0x2E,0x20,0x47,0x72,0x61,0x79,0x31,0x1E,0x30,0x1C,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x09,0x01,0x16,0x0F,0x64,0x61,0x76,0x69,0x64,0x40,0x66,0x6F,0x72,0x6D,0x61,0x6C,0x2E,0x69,0x65,0x30,0x5C,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x4B,0x00,0x30,0x48,0x02,0x41,0x00,0xC5,0x81,0x07,0xA2,0xEB,0x0F,0xB8,0xFF,0xF8,0xF8,0x1C,0xEE,0x32,0xFF,0xBF,0x12,0x35,0x6A,0xF9,0x6B,0xC8,0xBE,0x2F,0xFB,0x3E,0xAF,0x04,0x51,
			0x4A,0xAC,0xDD,0x10,0x29,0xA8,0xCD,0x40,0x5B,0x66,0x1E,0x98,0xEF,0xF2,0x4C,0x77,0xFA,0x8F,0x86,0xD1,0x21,0x67,0x92,0x44,0x4A,0xC4,0x89,0xC9,0x83,0xCF,0x88,0x9F,0x6F,0xE2,0x32,0x35,0x02,0x03,0x01,0x00,0x01,0xA3,0x82,0x07,0x08,0x30,0x82,0x07,0x04,0x30,0x09,0x06,0x03,0x55,0x1D,0x13,0x04,0x02,0x30,0x00,0x30,0x82,0x02,0x1F,0x06,0x03,0x55,0x1D,0x03,0x04,0x82,0x02,0x16,0x30,0x82,0x02,0x12,0x30,0x82,0x02,0x0E,0x30,0x82,0x02,0x0A,0x06,0x0B,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x01,0x07,0x01,0x01,0x30,0x82,
			0x01,0xF9,0x16,0x82,0x01,0xA7,0x54,0x68,0x69,0x73,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x69,0x6E,0x63,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x65,0x73,0x20,0x62,0x79,0x20,0x72,0x65,0x66,0x65,0x72,0x65,0x6E,0x63,0x65,0x2C,0x20,0x61,0x6E,0x64,0x20,0x69,0x74,0x73,0x20,0x75,0x73,0x65,0x20,0x69,0x73,0x20,0x73,0x74,0x72,0x69,0x63,0x74,0x6C,0x79,0x20,0x73,0x75,0x62,0x6A,0x65,0x63,0x74,0x20,0x74,0x6F,0x2C,0x20,0x74,0x68,0x65,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x43,
			0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x50,0x72,0x61,0x63,0x74,0x69,0x63,0x65,0x20,0x53,0x74,0x61,0x74,0x65,0x6D,0x65,0x6E,0x74,0x20,0x28,0x43,0x50,0x53,0x29,0x2C,0x20,0x61,0x76,0x61,0x69,0x6C,0x61,0x62,0x6C,0x65,0x20,0x61,0x74,0x3A,0x20,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x2F,0x43,0x50,0x53,0x3B,0x20,0x62,0x79,0x20,0x45,0x2D,0x6D,0x61,0x69,0x6C,0x20,0x61,0x74,0x20,0x43,0x50,0x53,0x2D,
			0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x73,0x40,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x3B,0x20,0x6F,0x72,0x20,0x62,0x79,0x20,0x6D,0x61,0x69,0x6C,0x20,0x61,0x74,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x2C,0x20,0x32,0x35,0x39,0x33,0x20,0x43,0x6F,0x61,0x73,0x74,0x20,0x41,0x76,0x65,0x2E,0x2C,0x20,0x4D,0x6F,0x75,0x6E,0x74,0x61,0x69,0x6E,0x20,0x56,0x69,0x65,0x77,0x2C,0x20,0x43,0x41,0x20,0x39,0x34,0x30,0x34,0x33,0x20,0x55,0x53,0x41,0x20,0x54,0x65,
			0x6C,0x2E,0x20,0x2B,0x31,0x20,0x28,0x34,0x31,0x35,0x29,0x20,0x39,0x36,0x31,0x2D,0x38,0x38,0x33,0x30,0x20,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x31,0x39,0x39,0x36,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x20,0x20,0x41,0x6C,0x6C,0x20,0x52,0x69,0x67,0x68,0x74,0x73,0x20,0x52,0x65,0x73,0x65,0x72,0x76,0x65,0x64,0x2E,0x20,0x43,0x45,0x52,0x54,0x41,0x49,0x4E,0x20,0x57,0x41,0x52,0x52,0x41,0x4E,0x54,0x49,0x45,0x53,0x20,0x44,0x49,0x53,0x43,
			0x4C,0x41,0x49,0x4D,0x45,0x44,0x20,0x61,0x6E,0x64,0x20,0x4C,0x49,0x41,0x42,0x49,0x4C,0x49,0x54,0x59,0x20,0x4C,0x49,0x4D,0x49,0x54,0x45,0x44,0x2E,0xA0,0x0E,0x06,0x0C,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x01,0x07,0x01,0x01,0x01,0xA1,0x0E,0x06,0x0C,0x60,0x86,0x48,0x01,0x86,0xF8,0x45,0x01,0x07,0x01,0x01,0x02,0x30,0x2C,0x30,0x2A,0x16,0x28,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,
			0x72,0x79,0x2F,0x43,0x50,0x53,0x20,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x07,0x80,0x30,0x36,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x08,0x04,0x29,0x16,0x27,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x2F,0x43,0x50,0x53,0x30,0x82,0x04,0x87,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x0D,0x04,0x82,0x04,
			0x78,0x16,0x82,0x04,0x74,0x43,0x41,0x55,0x54,0x49,0x4F,0x4E,0x3A,0x20,0x54,0x68,0x65,0x20,0x43,0x6F,0x6D,0x6D,0x6F,0x6E,0x20,0x4E,0x61,0x6D,0x65,0x20,0x69,0x6E,0x20,0x74,0x68,0x69,0x73,0x20,0x43,0x6C,0x61,0x73,0x73,0x20,0x31,0x20,0x44,0x69,0x67,0x69,0x74,0x61,0x6C,0x20,0x0A,0x49,0x44,0x20,0x69,0x73,0x20,0x6E,0x6F,0x74,0x20,0x61,0x75,0x74,0x68,0x65,0x6E,0x74,0x69,0x63,0x61,0x74,0x65,0x64,0x20,0x62,0x79,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2E,0x20,0x49,0x74,0x20,0x6D,0x61,0x79,0x20,0x62,
			0x65,0x20,0x74,0x68,0x65,0x0A,0x68,0x6F,0x6C,0x64,0x65,0x72,0x27,0x73,0x20,0x72,0x65,0x61,0x6C,0x20,0x6E,0x61,0x6D,0x65,0x20,0x6F,0x72,0x20,0x61,0x6E,0x20,0x61,0x6C,0x69,0x61,0x73,0x2E,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x64,0x6F,0x65,0x73,0x20,0x61,0x75,0x74,0x68,0x2D,0x0A,0x65,0x6E,0x74,0x69,0x63,0x61,0x74,0x65,0x20,0x74,0x68,0x65,0x20,0x65,0x2D,0x6D,0x61,0x69,0x6C,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x6F,0x66,0x20,0x74,0x68,0x65,0x20,0x68,0x6F,0x6C,0x64,0x65,0x72,0x2E,
			0x0A,0x0A,0x54,0x68,0x69,0x73,0x20,0x63,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x20,0x69,0x6E,0x63,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x65,0x73,0x20,0x62,0x79,0x20,0x72,0x65,0x66,0x65,0x72,0x65,0x6E,0x63,0x65,0x2C,0x20,0x61,0x6E,0x64,0x20,0x0A,0x69,0x74,0x73,0x20,0x75,0x73,0x65,0x20,0x69,0x73,0x20,0x73,0x74,0x72,0x69,0x63,0x74,0x6C,0x79,0x20,0x73,0x75,0x62,0x6A,0x65,0x63,0x74,0x20,0x74,0x6F,0x2C,0x20,0x74,0x68,0x65,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x0A,0x43,0x65,0x72,
			0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x69,0x6F,0x6E,0x20,0x50,0x72,0x61,0x63,0x74,0x69,0x63,0x65,0x20,0x53,0x74,0x61,0x74,0x65,0x6D,0x65,0x6E,0x74,0x20,0x28,0x43,0x50,0x53,0x29,0x2C,0x20,0x61,0x76,0x61,0x69,0x6C,0x61,0x62,0x6C,0x65,0x0A,0x69,0x6E,0x20,0x74,0x68,0x65,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x20,0x61,0x74,0x3A,0x20,0x0A,0x68,0x74,0x74,0x70,0x73,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,
			0x63,0x6F,0x6D,0x3B,0x20,0x62,0x79,0x20,0x45,0x2D,0x6D,0x61,0x69,0x6C,0x20,0x61,0x74,0x0A,0x43,0x50,0x53,0x2D,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x73,0x40,0x76,0x65,0x72,0x69,0x73,0x69,0x67,0x6E,0x2E,0x63,0x6F,0x6D,0x3B,0x20,0x6F,0x72,0x20,0x62,0x79,0x20,0x6D,0x61,0x69,0x6C,0x20,0x61,0x74,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x0A,0x49,0x6E,0x63,0x2E,0x2C,0x20,0x32,0x35,0x39,0x33,0x20,0x43,0x6F,0x61,0x73,0x74,0x20,0x41,0x76,0x65,0x2E,0x2C,0x20,0x4D,0x6F,0x75,0x6E,0x74,0x61,0x69,0x6E,
			0x20,0x56,0x69,0x65,0x77,0x2C,0x20,0x43,0x41,0x20,0x39,0x34,0x30,0x34,0x33,0x20,0x55,0x53,0x41,0x0A,0x0A,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x31,0x39,0x39,0x36,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x2C,0x20,0x49,0x6E,0x63,0x2E,0x20,0x20,0x41,0x6C,0x6C,0x20,0x52,0x69,0x67,0x68,0x74,0x73,0x20,0x0A,0x52,0x65,0x73,0x65,0x72,0x76,0x65,0x64,0x2E,0x20,0x43,0x45,0x52,0x54,0x41,0x49,0x4E,0x20,0x57,0x41,0x52,0x52,0x41,0x4E,0x54,0x49,0x45,0x53,0x20,0x44,0x49,0x53,0x43,
			0x4C,0x41,0x49,0x4D,0x45,0x44,0x20,0x41,0x4E,0x44,0x20,0x0A,0x4C,0x49,0x41,0x42,0x49,0x4C,0x49,0x54,0x59,0x20,0x4C,0x49,0x4D,0x49,0x54,0x45,0x44,0x2E,0x0A,0x0A,0x57,0x41,0x52,0x4E,0x49,0x4E,0x47,0x3A,0x20,0x54,0x48,0x45,0x20,0x55,0x53,0x45,0x20,0x4F,0x46,0x20,0x54,0x48,0x49,0x53,0x20,0x43,0x45,0x52,0x54,0x49,0x46,0x49,0x43,0x41,0x54,0x45,0x20,0x49,0x53,0x20,0x53,0x54,0x52,0x49,0x43,0x54,0x4C,0x59,0x0A,0x53,0x55,0x42,0x4A,0x45,0x43,0x54,0x20,0x54,0x4F,0x20,0x54,0x48,0x45,0x20,0x56,0x45,0x52,0x49,
			0x53,0x49,0x47,0x4E,0x20,0x43,0x45,0x52,0x54,0x49,0x46,0x49,0x43,0x41,0x54,0x49,0x4F,0x4E,0x20,0x50,0x52,0x41,0x43,0x54,0x49,0x43,0x45,0x0A,0x53,0x54,0x41,0x54,0x45,0x4D,0x45,0x4E,0x54,0x2E,0x20,0x20,0x54,0x48,0x45,0x20,0x49,0x53,0x53,0x55,0x49,0x4E,0x47,0x20,0x41,0x55,0x54,0x48,0x4F,0x52,0x49,0x54,0x59,0x20,0x44,0x49,0x53,0x43,0x4C,0x41,0x49,0x4D,0x53,0x20,0x43,0x45,0x52,0x54,0x41,0x49,0x4E,0x0A,0x49,0x4D,0x50,0x4C,0x49,0x45,0x44,0x20,0x41,0x4E,0x44,0x20,0x45,0x58,0x50,0x52,0x45,0x53,0x53,0x20,
			0x57,0x41,0x52,0x52,0x41,0x4E,0x54,0x49,0x45,0x53,0x2C,0x20,0x49,0x4E,0x43,0x4C,0x55,0x44,0x49,0x4E,0x47,0x20,0x57,0x41,0x52,0x52,0x41,0x4E,0x54,0x49,0x45,0x53,0x0A,0x4F,0x46,0x20,0x4D,0x45,0x52,0x43,0x48,0x41,0x4E,0x54,0x41,0x42,0x49,0x4C,0x49,0x54,0x59,0x20,0x4F,0x52,0x20,0x46,0x49,0x54,0x4E,0x45,0x53,0x53,0x20,0x46,0x4F,0x52,0x20,0x41,0x20,0x50,0x41,0x52,0x54,0x49,0x43,0x55,0x4C,0x41,0x52,0x0A,0x50,0x55,0x52,0x50,0x4F,0x53,0x45,0x2C,0x20,0x41,0x4E,0x44,0x20,0x57,0x49,0x4C,0x4C,0x20,0x4E,0x4F,
			0x54,0x20,0x42,0x45,0x20,0x4C,0x49,0x41,0x42,0x4C,0x45,0x20,0x46,0x4F,0x52,0x20,0x43,0x4F,0x4E,0x53,0x45,0x51,0x55,0x45,0x4E,0x54,0x49,0x41,0x4C,0x2C,0x0A,0x50,0x55,0x4E,0x49,0x54,0x49,0x56,0x45,0x2C,0x20,0x41,0x4E,0x44,0x20,0x43,0x45,0x52,0x54,0x41,0x49,0x4E,0x20,0x4F,0x54,0x48,0x45,0x52,0x20,0x44,0x41,0x4D,0x41,0x47,0x45,0x53,0x2E,0x20,0x53,0x45,0x45,0x20,0x54,0x48,0x45,0x20,0x43,0x50,0x53,0x0A,0x46,0x4F,0x52,0x20,0x44,0x45,0x54,0x41,0x49,0x4C,0x53,0x2E,0x0A,0x0A,0x43,0x6F,0x6E,0x74,0x65,0x6E,
			0x74,0x73,0x20,0x6F,0x66,0x20,0x74,0x68,0x65,0x20,0x56,0x65,0x72,0x69,0x53,0x69,0x67,0x6E,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x65,0x64,0x0A,0x6E,0x6F,0x6E,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x53,0x75,0x62,0x6A,0x65,0x63,0x74,0x41,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x73,0x20,0x65,0x78,0x74,0x65,0x6E,0x73,0x69,0x6F,0x6E,0x20,0x76,0x61,0x6C,0x75,0x65,0x20,0x73,0x68,0x61,0x6C,0x6C,0x20,0x0A,0x6E,0x6F,0x74,0x20,0x62,0x65,0x20,0x63,0x6F,0x6E,0x73,0x69,0x64,0x65,0x72,0x65,0x64,0x20,
			0x61,0x73,0x20,0x61,0x63,0x63,0x75,0x72,0x61,0x74,0x65,0x20,0x69,0x6E,0x66,0x6F,0x72,0x6D,0x61,0x74,0x69,0x6F,0x6E,0x20,0x76,0x61,0x6C,0x69,0x64,0x61,0x74,0x65,0x64,0x20,0x0A,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x49,0x41,0x2E,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x03,0x81,0x81,0x00,0x2B,0x3D,0x44,0xC7,0x32,0x59,0xAE,0xF1,0x5F,0x8F,0x3F,0x87,0xE3,0x3E,0xEB,0x81,0x30,0xF8,0xA9,0x96,0xDB,0x01,0x42,0x0B,0x04,0xEF,0x37,0x02,0x3F,0xD4,0x20,0x61,0x58,0xC4,0x4A,0x3A,
			0x39,0xB3,0xFB,0xD9,0xF8,0xA5,0xC4,0x5E,0x33,0x5A,0x0E,0xFA,0x93,0x56,0x2F,0x6F,0xD6,0x61,0xA2,0xAF,0xA5,0x0C,0x1D,0xE2,0x41,0x65,0xF3,0x40,0x75,0x66,0x83,0xD2,0x5A,0xB4,0xB7,0x56,0x0B,0x8E,0x0D,0xA1,0x33,0x13,0x7D,0x49,0xC3,0xB1,0x00,0x68,0x83,0x7F,0xB5,0x66,0xD4,0x32,0x32,0xFE,0x8B,0x9A,0x5A,0xD6,0x01,0x72,0x31,0x5D,0x85,0x91,0xBC,0x93,0x9B,0x65,0x60,0x25,0xC6,0x1F,0xBC,0xDD,0x69,0x44,0x62,0xC2,0xB2,0x6F,0x46,0xAB,0x2F,0x20,0xA5,0x6F,0xDA,0x48,0x6C,0x9C };

		public static byte[] cert_10 = { 0x30,0x82,0x02,0x1D,0x30,0x82,0x01,0x86,0x02,0x01,0x14,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x30,0x58,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x43,0x41,0x31,0x1F,0x30,0x1D,0x06,0x03,0x55,0x04,0x03,0x13,0x16,0x4B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,0x73,0x20,0x43,0x61,0x6E,0x61,0x64,0x61,0x20,0x49,0x6E,0x63,0x2E,0x31,0x28,0x30,0x26,0x06,0x0A,0x2B,0x06,0x01,0x04,0x01,0x2A,0x02,0x0B,0x02,0x01,0x13,0x18,0x6B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,
			0x73,0x40,0x6B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,0x73,0x2E,0x63,0x61,0x30,0x1E,0x17,0x0D,0x39,0x36,0x30,0x35,0x30,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x39,0x39,0x30,0x35,0x30,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x30,0x58,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x43,0x41,0x31,0x1F,0x30,0x1D,0x06,0x03,0x55,0x04,0x03,0x13,0x16,0x4B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,0x73,0x20,0x43,0x61,0x6E,0x61,0x64,0x61,0x20,0x49,0x6E,0x63,0x2E,0x31,0x28,0x30,0x26,0x06,
			0x0A,0x2B,0x06,0x01,0x04,0x01,0x2A,0x02,0x0B,0x02,0x01,0x13,0x18,0x6B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,0x73,0x40,0x6B,0x65,0x79,0x77,0x69,0x74,0x6E,0x65,0x73,0x73,0x2E,0x63,0x61,0x30,0x81,0x9D,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x81,0x8B,0x00,0x30,0x81,0x87,0x02,0x81,0x81,0x00,0xCD,0x23,0xFA,0x2A,0xE1,0xED,0x98,0xF4,0xE9,0xD0,0x93,0x3E,0xD7,0x7A,0x80,0x02,0x4C,0xCC,0xC1,0x02,0xAF,0x5C,0xB6,0x1F,0x7F,0xFA,0x57,0x42,0x6F,0x30,0xD1,0x20,0xC5,0xB5,
			0x21,0x07,0x40,0x2C,0xA9,0x86,0xC2,0xF3,0x64,0x84,0xAE,0x3D,0x85,0x2E,0xED,0x85,0xBD,0x54,0xB0,0x18,0x28,0xEF,0x6A,0xF8,0x1B,0xE7,0x0B,0x16,0x1F,0x93,0x25,0x4F,0xC7,0xF8,0x8E,0xC3,0xB9,0xCA,0x98,0x84,0x0E,0x55,0xD0,0x2F,0xEF,0x78,0x77,0xC5,0x72,0x28,0x5F,0x60,0xBF,0x19,0x2B,0xD1,0x72,0xA2,0xB7,0xD8,0x3F,0xE0,0x97,0x34,0x5A,0x01,0xBD,0x04,0x9C,0xC8,0x78,0x45,0xCD,0x93,0x8D,0x15,0xF2,0x76,0x10,0x11,0xAB,0xB8,0x5B,0x2E,0x9E,0x52,0xDD,0x81,0x3E,0x9C,0x64,0xC8,0x29,0x93,0x02,0x01,0x03,0x30,0x0D,0x06,
			0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x04,0x05,0x00,0x03,0x81,0x81,0x00,0x32,0x1A,0x35,0xBA,0xBF,0x43,0x27,0xD6,0xB4,0xD4,0xB8,0x76,0xE5,0xE3,0x9B,0x4D,0x6C,0xC0,0x86,0xC9,0x77,0x35,0xBA,0x6B,0x16,0x2D,0x13,0x46,0x4A,0xB0,0x32,0x53,0xA1,0x5B,0x5A,0xE9,0x99,0xE2,0x0C,0x86,0x88,0x17,0x4E,0x0D,0xFE,0x82,0xAC,0x4E,0x47,0xEF,0xFB,0xFF,0x39,0xAC,0xEE,0x35,0xC8,0xFA,0x52,0x37,0x0A,0x49,0xAD,0x59,0xAD,0xE2,0x8A,0xA9,0x1C,0xC6,0x5F,0x1F,0xF8,0x6F,0x73,0x7E,0xCD,0xA0,0x31,0xE8,0x0C,0xBE,0xF5,0x4D,
			0xD9,0xB2,0xAB,0x8A,0x12,0xB6,0x30,0x78,0x68,0x11,0x7C,0x0D,0xF1,0x49,0x4D,0xA3,0xFD,0xB2,0xE9,0xFF,0x1D,0xF0,0x91,0xFA,0x54,0x85,0xFF,0x33,0x90,0xE8,0xC1,0xBF,0xA4,0x9B,0xA4,0x62,0x46,0xBD,0x61,0x12,0x59,0x98,0x41,0x89 };

		public static byte[] cert_12 = { 0x30,0x82,0x05,0x0F,0x30,0x82,0x03,0xF7,0xA0,0x03,0x02,0x01,0x02,0x02,0x0A,0x61,0x07,0x11,0x43,0x00,0x00,0x00,0x00,0x00,0x34,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x81,0xA6,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x08,0x13,0x0A,0x57,0x61,0x73,0x68,0x69,0x6E,0x67,0x74,0x6F,0x6E,0x31,0x10,0x30,0x0E,0x06,0x03,0x55,0x04,0x07,0x13,0x07,0x52,0x65,0x64,0x6D,0x6F,0x6E,0x64,0x31,0x1E,0x30,0x1C,0x06,0x03,
			0x55,0x04,0x0A,0x13,0x15,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x69,0x6F,0x6E,0x31,0x2B,0x30,0x29,0x06,0x03,0x55,0x04,0x0B,0x13,0x22,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x32,0x30,0x30,0x30,0x20,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x2E,0x31,0x23,0x30,0x21,0x06,0x03,0x55,0x04,0x03,0x13,0x1A,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x64,0x65,0x20,0x53,0x69,0x67,
			0x6E,0x69,0x6E,0x67,0x20,0x50,0x43,0x41,0x30,0x1E,0x17,0x0D,0x30,0x32,0x30,0x35,0x32,0x35,0x30,0x30,0x35,0x35,0x34,0x38,0x5A,0x17,0x0D,0x30,0x33,0x31,0x31,0x32,0x35,0x30,0x31,0x30,0x35,0x34,0x38,0x5A,0x30,0x81,0xA1,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x08,0x13,0x0A,0x57,0x61,0x73,0x68,0x69,0x6E,0x67,0x74,0x6F,0x6E,0x31,0x10,0x30,0x0E,0x06,0x03,0x55,0x04,0x07,0x13,0x07,0x52,0x65,0x64,0x6D,0x6F,0x6E,0x64,0x31,0x1E,0x30,0x1C,0x06,
			0x03,0x55,0x04,0x0A,0x13,0x15,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x69,0x6F,0x6E,0x31,0x2B,0x30,0x29,0x06,0x03,0x55,0x04,0x0B,0x13,0x22,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x32,0x30,0x30,0x32,0x20,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x2E,0x31,0x1E,0x30,0x1C,0x06,0x03,0x55,0x04,0x03,0x13,0x15,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x6F,0x72,0x61,
			0x74,0x69,0x6F,0x6E,0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xAA,0x99,0xBD,0x39,0xA8,0x18,0x27,0xF4,0x2B,0x3D,0x0B,0x4C,0x3F,0x7C,0x77,0x2E,0xA7,0xCB,0xB5,0xD1,0x8C,0x0D,0xC2,0x3A,0x74,0xD7,0x93,0xB5,0xE0,0xA0,0x4B,0x3F,0x59,0x5E,0xCE,0x45,0x4F,0x9A,0x79,0x29,0xF1,0x49,0xCC,0x1A,0x47,0xEE,0x55,0xC2,0x08,0x3E,0x12,0x20,0xF8,0x55,0xF2,0xEE,0x5F,0xD3,0xE0,0xCA,0x96,0xBC,0x30,
			0xDE,0xFE,0x58,0xC8,0x27,0x32,0xD0,0x85,0x54,0xE8,0xF0,0x91,0x10,0xBB,0xF3,0x2B,0xBE,0x19,0xE5,0x03,0x9B,0x0B,0x86,0x1D,0xF3,0xB0,0x39,0x8C,0xB8,0xFD,0x0B,0x1D,0x3C,0x73,0x26,0xAC,0x57,0x2B,0xCA,0x29,0xA2,0x15,0x90,0x82,0x15,0xE2,0x77,0xA3,0x40,0x52,0x03,0x8B,0x9D,0xC2,0x70,0xBA,0x1F,0xE9,0x34,0xF6,0xF3,0x35,0x92,0x4E,0x55,0x83,0xF8,0xDA,0x30,0xB6,0x20,0xDE,0x57,0x06,0xB5,0x5A,0x42,0x06,0xDE,0x59,0xCB,0xF2,0xDF,0xA6,0xBD,0x15,0x47,0x71,0x19,0x25,0x23,0xD2,0xCB,0x6F,0x9B,0x19,0x79,0xDF,0x6A,0x5B,
			0xF1,0x76,0x05,0x79,0x29,0xFC,0xC3,0x56,0xCA,0x8F,0x44,0x08,0x85,0x55,0x8A,0xCB,0xC8,0x0F,0x46,0x4B,0x55,0xCB,0x8C,0x96,0x77,0x4A,0x87,0xE8,0xA9,0x41,0x06,0xC7,0xFF,0x0D,0xE9,0x68,0x57,0x63,0x72,0xC3,0x69,0x57,0xB4,0x43,0xCF,0x32,0x3A,0x30,0xDC,0x1B,0xE9,0xD5,0x43,0x26,0x2A,0x79,0xFE,0x95,0xDB,0x22,0x67,0x24,0xC9,0x2F,0xD0,0x34,0xE3,0xE6,0xFB,0x51,0x49,0x86,0xB8,0x3C,0xD0,0x25,0x5F,0xD6,0xEC,0x9E,0x03,0x61,0x87,0xA9,0x68,0x40,0xC7,0xF8,0xE2,0x03,0xE6,0xCF,0x05,0x02,0x03,0x01,0x00,0x01,0xA3,0x82,
			0x01,0x40,0x30,0x82,0x01,0x3C,0x30,0x0E,0x06,0x03,0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x06,0xC0,0x30,0x13,0x06,0x03,0x55,0x1D,0x25,0x04,0x0C,0x30,0x0A,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x03,0x03,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x6B,0xC8,0xC6,0x51,0x20,0xF0,0xB4,0x2F,0xD3,0xA0,0xB6,0xAE,0x7F,0x5E,0x26,0xB2,0xB8,0x87,0x52,0x29,0x30,0x81,0xA9,0x06,0x03,0x55,0x1D,0x23,0x04,0x81,0xA1,0x30,0x81,0x9E,0x80,0x14,0x29,0x5C,0xB9,0x1B,0xB6,0xCD,0x33,0xEE,0xBB,0x9E,
			0x59,0x7D,0xF7,0xE5,0xCA,0x2E,0xC4,0x0D,0x34,0x28,0xA1,0x74,0xA4,0x72,0x30,0x70,0x31,0x2B,0x30,0x29,0x06,0x03,0x55,0x04,0x0B,0x13,0x22,0x43,0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x28,0x63,0x29,0x20,0x31,0x39,0x39,0x37,0x20,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x2E,0x31,0x1E,0x30,0x1C,0x06,0x03,0x55,0x04,0x0B,0x13,0x15,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x43,0x6F,0x72,0x70,0x6F,0x72,0x61,0x74,0x69,0x6F,0x6E,0x31,0x21,0x30,0x1F,0x06,0x03,0x55,
			0x04,0x03,0x13,0x18,0x4D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x20,0x52,0x6F,0x6F,0x74,0x20,0x41,0x75,0x74,0x68,0x6F,0x72,0x69,0x74,0x79,0x82,0x10,0x6A,0x0B,0x99,0x4F,0xC0,0x00,0xDE,0xAA,0x11,0xD4,0xD8,0x40,0x9A,0xA8,0xBE,0xE6,0x30,0x4A,0x06,0x03,0x55,0x1D,0x1F,0x04,0x43,0x30,0x41,0x30,0x3F,0xA0,0x3D,0xA0,0x3B,0x86,0x39,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x63,0x72,0x6C,0x2E,0x6D,0x69,0x63,0x72,0x6F,0x73,0x6F,0x66,0x74,0x2E,0x63,0x6F,0x6D,0x2F,0x70,0x6B,0x69,0x2F,0x63,0x72,0x6C,0x2F,0x70,0x72,
			0x6F,0x64,0x75,0x63,0x74,0x73,0x2F,0x43,0x6F,0x64,0x65,0x53,0x69,0x67,0x6E,0x50,0x43,0x41,0x2E,0x63,0x72,0x6C,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x35,0x23,0xFD,0x13,0x54,0xFC,0xE9,0xDC,0xF0,0xDD,0x0C,0x14,0x7A,0xFA,0xA7,0xB3,0xCE,0xFD,0xA7,0x3A,0xC8,0xBA,0xE5,0xE7,0xF6,0x03,0xFB,0x53,0xDB,0xA7,0x99,0xA9,0xA0,0x9B,0x36,0x9C,0x03,0xEB,0x82,0x47,0x1C,0x21,0xBD,0x14,0xCB,0xE7,0x67,0x40,0x09,0xC7,0x16,0x91,0x02,0x55,0xCE,0x43,0x42,0xB4,
			0xCD,0x1B,0x5D,0xB0,0xF3,0x32,0x04,0x3D,0x12,0xE5,0x1D,0xA7,0x07,0xA7,0x8F,0xA3,0x7E,0x45,0x55,0x76,0x1B,0x96,0x95,0x91,0x69,0xF0,0xDD,0x38,0xF3,0x48,0x89,0xEF,0x70,0x40,0xB7,0xDB,0xB5,0x55,0x80,0xC0,0x03,0xC4,0x2E,0xB6,0x28,0xDC,0x0A,0x82,0x0E,0xC7,0x43,0xE3,0x7A,0x48,0x5D,0xB8,0x06,0x89,0x92,0x40,0x6C,0x6E,0xC5,0xDC,0xF8,0x9A,0xEF,0x0B,0xBE,0x21,0x0A,0x8C,0x2F,0x3A,0xB5,0xED,0xA7,0xCE,0x71,0x87,0x68,0x23,0xE1,0xB3,0xE4,0x18,0x7D,0xB8,0x47,0x01,0xA5,0x2B,0xC4,0x58,0xCB,0xB2,0x89,0x6C,0x5F,0xFD,
			0xD3,0x2C,0xC4,0x6F,0xB8,0x23,0xB2,0x0D,0xFF,0x3C,0xF2,0x11,0x45,0x74,0xF2,0x09,0x06,0x99,0x18,0xDD,0x6F,0xC0,0x86,0x01,0x18,0x12,0x1D,0x2B,0x16,0xAF,0x56,0xEF,0x65,0x33,0xA1,0xEA,0x67,0x4E,0xF4,0x4B,0x82,0xAB,0xE9,0x0F,0xDC,0x01,0xFA,0xDF,0x60,0x7F,0x66,0x47,0x5D,0xCB,0x2C,0x70,0xCC,0x7B,0x4E,0xD9,0x06,0xB8,0x6E,0x8C,0x0C,0xFE,0x62,0x1E,0x42,0xF9,0x93,0x7C,0xA2,0xAB,0x0A,0x9E,0xD0,0x23,0x10,0xAE,0x4D,0x7B,0x27,0x91,0x6F,0x26,0xBE,0x68,0xFA,0xA6,0x3F,0x9F,0x23,0xEB,0xC8,0x9D,0xBB,0x87 };

		public static byte[] cert_13 = { 0x30,0x82,0x02,0x14,0x30,0x82,0x01,0xD3,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x02,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x30,0x3A,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x1A,0x30,0x18,0x06,0x03,0x55,0x04,0x0A,0x13,0x11,0x54,0x65,0x73,0x74,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x73,0x31,0x0F,0x30,0x0D,0x06,0x03,0x55,0x04,0x03,0x13,0x06,0x44,0x53,0x41,0x20,0x43,0x41,0x30,0x1E,0x17,0x0D,0x30,0x31,0x30,0x34,0x31,0x39,0x31,0x34,0x35,0x37,
			0x32,0x30,0x5A,0x17,0x0D,0x31,0x31,0x30,0x34,0x31,0x39,0x31,0x34,0x35,0x37,0x32,0x30,0x5A,0x30,0x4F,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x1A,0x30,0x18,0x06,0x03,0x55,0x04,0x0A,0x13,0x11,0x54,0x65,0x73,0x74,0x20,0x43,0x65,0x72,0x74,0x69,0x66,0x69,0x63,0x61,0x74,0x65,0x73,0x31,0x24,0x30,0x22,0x06,0x03,0x55,0x04,0x03,0x13,0x1B,0x44,0x53,0x41,0x20,0x50,0x61,0x72,0x61,0x6D,0x65,0x74,0x65,0x72,0x73,0x20,0x49,0x6E,0x68,0x65,0x72,0x69,0x74,0x65,0x64,0x20,0x43,0x41,0x30,
			0x81,0x92,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x01,0x03,0x81,0x84,0x00,0x02,0x81,0x80,0x67,0x8C,0x47,0xDA,0x0C,0x36,0x81,0x64,0x39,0xF8,0x1A,0x37,0x0B,0xF0,0xBB,0xD4,0x13,0xFD,0x67,0x3D,0x40,0xC8,0x9C,0x92,0xE1,0x3A,0x89,0x54,0xB0,0xF2,0x97,0xA5,0x70,0xD0,0x64,0x17,0xA4,0xA7,0x7C,0xA9,0xE9,0x27,0x09,0x65,0xDF,0xA0,0xA5,0x1C,0xFC,0x04,0xDA,0x3E,0xDD,0x62,0x6B,0xF0,0x0C,0xED,0x81,0x57,0x4F,0x5D,0x29,0xC8,0x08,0x59,0x19,0x0C,0x5F,0x8D,0x88,0xF0,0xFF,0x8C,0xB6,0xE8,0x75,0x01,0xBE,0x10,
			0x0A,0x64,0xDF,0x57,0x7B,0x8B,0x6C,0x56,0xF0,0x53,0xCE,0x43,0x88,0xB9,0x09,0x99,0x08,0x3C,0x90,0xAF,0x01,0xE8,0xD9,0x32,0x5D,0xED,0x56,0x02,0xCF,0x60,0xD2,0x01,0x3A,0xE3,0x0A,0x2B,0x9E,0x91,0x41,0xF6,0xC7,0x7C,0xDE,0x6C,0x99,0x63,0x00,0x0E,0xA3,0x7C,0x30,0x7A,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x5D,0x24,0xEE,0x8A,0x55,0x1A,0xF2,0xC6,0xC9,0xB2,0xC2,0xBF,0x8A,0xF0,0xB2,0x49,0x4F,0x3A,0xB3,0x1B,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x74,0x15,0xD5,0x24,
			0x1C,0xBD,0x5E,0x65,0x88,0x1F,0xE1,0x8B,0x09,0x7E,0x7F,0xEA,0x19,0x48,0x4E,0x61,0x30,0x17,0x06,0x03,0x55,0x1D,0x20,0x04,0x10,0x30,0x0E,0x30,0x0C,0x06,0x0A,0x60,0x86,0x48,0x01,0x65,0x03,0x02,0x01,0x30,0x01,0x30,0x0E,0x06,0x03,0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0F,0x06,0x03,0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x03,0x30,0x00,0x30,0x2D,0x02,0x15,0x00,0xA8,0x59,0x6F,0x31,0x77,0xB6,0x20,
			0xEC,0x36,0x9B,0xEB,0x4B,0x61,0x0A,0xAF,0x44,0xED,0x72,0xBA,0x29,0x02,0x14,0x6D,0x22,0xE1,0xBD,0x4D,0x27,0xF6,0x2E,0x3B,0x1F,0xD7,0x9D,0xD6,0x59,0x5E,0xCB,0x25,0x86,0x22,0xD8 };

		static public byte[] farscape_pfx = { 0x30, 0x82, 0x06, 0xA3, 0x02, 0x01, 0x03, 0x30, 0x82, 0x06, 0x63, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x06, 0x54, 0x04, 0x82, 0x06, 0x50, 0x30, 0x82, 0x06, 0x4C, 0x30, 0x82, 0x03, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x03, 0x7E, 0x04, 0x82, 0x03, 0x7A, 0x30, 0x82, 0x03, 0x76, 0x30, 0x82, 0x03, 0x72, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xB6, 0x30, 0x82, 0x02, 0xB2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 
			0x0E, 0x04, 0x08, 0x67, 0xFE, 0x3A, 0x52, 0x75, 0xF3, 0x82, 0x1F, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x02, 0x90, 0x31, 0x6B, 0x00, 0xFA, 0x73, 0xE6, 0x8D, 0x3D, 0x62, 0x93, 0x41, 0xA1, 0x44, 0x04, 0x17, 0x8D, 0x66, 0x7A, 0x75, 0x14, 0x89, 0xA8, 0xD1, 0x4D, 0x2A, 0xD7, 0x20, 0x27, 0x71, 0x58, 0x81, 0x16, 0xB5, 0xA6, 0x41, 0x75, 0x92, 0xB2, 0xF4, 0x0C, 0xAA, 0x9B, 0x00, 0x46, 0x85, 0x85, 0x3B, 0x09, 0x2A, 0x62, 0x33, 0x3F, 0x3D, 0x06, 0xC7, 0xE7, 0x16, 0x0C, 0xA7, 0x1D, 0x9C, 0xDA, 0x9D, 0xD3, 0xC9, 0x05, 0x60, 0xA5, 0xBE, 0xF0, 0x07, 0xD5, 0xA9, 0x4F, 0x8A, 0x80, 0xF8, 0x55, 0x7B, 0x7B, 0x3C, 
			0xA0, 0x7C, 0x29, 0x29, 0xAB, 0xB1, 0xE1, 0x5A, 0x25, 0xE3, 0x23, 0x6A, 0x56, 0x98, 0x37, 0x68, 0xAF, 0x9C, 0x87, 0xBB, 0x21, 0x6E, 0x68, 0xBE, 0xAE, 0x65, 0x0C, 0x41, 0x8F, 0x5C, 0x3A, 0xB8, 0xB1, 0x9D, 0x42, 0x37, 0xE4, 0xA0, 0x37, 0xA6, 0xB8, 0xAC, 0x85, 0xD7, 0x85, 0x27, 0x68, 0xD0, 0xB6, 0x3D, 0xC7, 0x39, 0x92, 0x41, 0x46, 0x24, 0xDD, 0x08, 0x57, 0x22, 0x6A, 0xC0, 0xB7, 0xAD, 0x52, 0xC6, 0x7F, 0xE5, 0x74, 0x6A, 0x5E, 0x28, 0xA3, 0x85, 0xBD, 0xE8, 0xAD, 0x5D, 0xA3, 0x55, 0xE6, 0x63, 0x15, 0x56, 0x7B, 0x01, 0x26, 0x68, 0x5F, 0x11, 0xA3, 0x12, 0x37, 0x02, 0xA5, 0xD0, 0xB7, 0x73, 0x0C, 0x7C, 
			0x97, 0xE1, 0xC6, 0x2F, 0x98, 0x82, 0x67, 0x2F, 0x5F, 0x3F, 0xBE, 0x32, 0x16, 0x25, 0x9D, 0x51, 0x48, 0x32, 0xCB, 0x42, 0xD1, 0x31, 0x07, 0xBE, 0x5D, 0xF8, 0xCD, 0x2C, 0x38, 0x0A, 0x33, 0x3B, 0x7B, 0x04, 0x84, 0xAE, 0x9C, 0xA7, 0x6B, 0x36, 0x39, 0x12, 0x87, 0x9D, 0x5B, 0x56, 0x00, 0x44, 0x11, 0xB1, 0xE2, 0x78, 0x14, 0x60, 0xF3, 0xE4, 0x1A, 0x08, 0x14, 0xC0, 0x9E, 0x49, 0x9F, 0xE0, 0x4C, 0xEC, 0x95, 0x15, 0x18, 0x48, 0x0E, 0xB9, 0x0B, 0x3A, 0xFE, 0x45, 0xB0, 0x2D, 0x0D, 0x4F, 0x94, 0x5A, 0x3C, 0x43, 0xB7, 0x40, 0x8E, 0x7B, 0xA2, 0x8E, 0x23, 0x9F, 0x75, 0x97, 0xE7, 0x21, 0x0D, 0xEB, 0xA3, 0x9D, 
			0x6C, 0xC0, 0xDC, 0x73, 0xED, 0x15, 0x98, 0xE3, 0xE8, 0x32, 0x2C, 0x12, 0x92, 0x45, 0x25, 0x45, 0x76, 0x18, 0xF5, 0x97, 0x7F, 0xAC, 0xCE, 0xCF, 0x23, 0xF7, 0xD1, 0xCF, 0x06, 0xAB, 0x82, 0x96, 0x1F, 0xF8, 0x68, 0x4F, 0x5D, 0xE1, 0x09, 0xAA, 0xCB, 0xB3, 0x50, 0x85, 0x46, 0x72, 0x14, 0x6C, 0x49, 0x84, 0x57, 0x55, 0x00, 0x78, 0x3E, 0xD9, 0xAA, 0xBD, 0xCC, 0xE2, 0x7B, 0x18, 0xAA, 0x2E, 0x5D, 0xB9, 0x28, 0xEA, 0x8F, 0x8C, 0xFA, 0xB7, 0x06, 0x27, 0x07, 0x89, 0x41, 0x3F, 0x66, 0x1A, 0x91, 0xCA, 0xE9, 0xEC, 0x09, 0x12, 0x1C, 0x67, 0xB2, 0x2A, 0x8B, 0x4A, 0xF0, 0x97, 0x17, 0xDC, 0x3E, 0xCD, 0x9F, 0x03, 
			0x15, 0xEF, 0x03, 0x84, 0x08, 0x4A, 0x73, 0xAE, 0xE4, 0x07, 0x30, 0x27, 0xF7, 0x25, 0x69, 0x9D, 0x6C, 0x7D, 0x81, 0x88, 0xCC, 0xFA, 0xD4, 0xC7, 0x64, 0x11, 0xC0, 0xC8, 0x2C, 0x23, 0xF6, 0xFF, 0x9B, 0xE3, 0xC8, 0x89, 0x85, 0x0B, 0x3E, 0x81, 0xD8, 0x9C, 0xBD, 0xD0, 0x2D, 0xCD, 0x15, 0xA9, 0x30, 0x84, 0xF7, 0x6D, 0xEF, 0x62, 0x3B, 0xA7, 0x8C, 0xC2, 0x93, 0x90, 0x6F, 0x91, 0xB4, 0x8A, 0x71, 0x4E, 0x41, 0x4E, 0x5C, 0x67, 0xB5, 0x49, 0xF8, 0x56, 0x3A, 0x83, 0x03, 0x4F, 0xB1, 0xF6, 0xB7, 0x31, 0x5B, 0x68, 0x26, 0x70, 0x89, 0xB1, 0x1E, 0x67, 0x4F, 0xBA, 0xE7, 0xD9, 0xDF, 0x91, 0xD8, 0xFB, 0x8A, 0xDD, 
			0xB2, 0xD3, 0x4B, 0xBB, 0x9F, 0x5C, 0xA3, 0x04, 0x2C, 0x87, 0xBC, 0xD5, 0xBE, 0x8C, 0xD7, 0xCF, 0x9B, 0x72, 0x82, 0xA6, 0x99, 0xDA, 0xD7, 0x66, 0x48, 0xE7, 0x8F, 0xE9, 0x48, 0x56, 0x9D, 0xD2, 0xB9, 0x28, 0x84, 0x4F, 0x6A, 0x83, 0xB2, 0xB9, 0x4D, 0x91, 0x10, 0x58, 0x22, 0x4C, 0xE7, 0x9D, 0xC6, 0x0C, 0x74, 0xF4, 0x16, 0x58, 0x30, 0xB7, 0xB7, 0x96, 0x39, 0x6C, 0x5D, 0xFA, 0xB2, 0x03, 0x8C, 0x98, 0xD2, 0xC0, 0x64, 0xB8, 0x05, 0x29, 0x4F, 0xF0, 0x4C, 0x43, 0x48, 0xD3, 0xD8, 0xBD, 0xC7, 0xC1, 0xEA, 0x39, 0x2A, 0xDF, 0xD4, 0xDA, 0x79, 0x7C, 0xB9, 0x06, 0xC7, 0x10, 0x8D, 0x8B, 0xF1, 0xA8, 0x8E, 0x44, 
			0x9E, 0x99, 0xFF, 0x81, 0x84, 0x8F, 0xD0, 0x38, 0xE1, 0xF0, 0x5A, 0x12, 0x5F, 0xC5, 0xA6, 0xED, 0x6D, 0xEE, 0xE7, 0x69, 0xC0, 0xA2, 0xB4, 0x13, 0xCA, 0x7A, 0x5D, 0xDE, 0x88, 0x75, 0xE7, 0xE2, 0x6D, 0x8A, 0xEC, 0x0F, 0x88, 0x3F, 0xE2, 0xCB, 0x60, 0xF0, 0x6A, 0xEC, 0xD0, 0xF4, 0x0D, 0x11, 0xC2, 0x84, 0x19, 0x67, 0x52, 0xAD, 0xC0, 0xC0, 0x20, 0x84, 0x6D, 0x7D, 0xEA, 0xD2, 0xF9, 0x3F, 0xE5, 0x58, 0x00, 0xED, 0x24, 0xD6, 0x50, 0x9B, 0x80, 0x80, 0x0A, 0x31, 0x81, 0xA8, 0x30, 0x0D, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x02, 0x31, 0x00, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x17, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x0A, 0x1E, 0x08, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x6F, 0x30, 0x69, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5C, 0x1E, 0x5A, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x52, 0x00, 0x53, 0x00, 0x41, 0x00, 0x20, 0x00, 0x53, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x6C, 
			0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x30, 0x82, 0x02, 0xB7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x02, 0xA8, 0x30, 0x82, 0x02, 0xA4, 0x02, 0x01, 0x00, 0x30, 0x82, 0x02, 0x9D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 
			0x06, 0x30, 0x0E, 0x04, 0x08, 0xB8, 0x22, 0xEA, 0x3C, 0x70, 0x6A, 0xFC, 0x39, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x02, 0x70, 0x76, 0xBE, 0x5B, 0xD5, 0x3D, 0x05, 0xC1, 0xDB, 0x10, 0xA3, 0x02, 0xBB, 0x7F, 0x0A, 0x8B, 0x54, 0xC1, 0x7D, 0x19, 0xDA, 0x7E, 0x82, 0xDF, 0xAD, 0x6B, 0x42, 0xC2, 0x95, 0x95, 0x00, 0x6E, 0x82, 0x77, 0xD5, 0x42, 0x6E, 0x21, 0xA2, 0x95, 0xB4, 0x98, 0xF5, 0xDD, 0x18, 0x6F, 0xC4, 0xF3, 0xB6, 0x93, 0xA0, 0x6C, 0xF4, 0x34, 0x7A, 0x48, 0x72, 0x08, 0xB1, 0x28, 0x51, 0x54, 0x10, 0x7F, 0x35, 0xB2, 0xE5, 0x89, 0x5C, 0x0A, 0x14, 0x31, 0x1C, 0x9D, 0xA9, 0xE4, 0x94, 0x91, 0x28, 0x65, 
			0xC4, 0xE7, 0x5E, 0xA9, 0x37, 0x08, 0x3D, 0xB1, 0x16, 0x61, 0x9D, 0xA9, 0x44, 0x6F, 0x20, 0x0C, 0x55, 0xD7, 0xCC, 0x48, 0x82, 0x13, 0x5D, 0xE1, 0xBD, 0x9D, 0xCE, 0x64, 0x28, 0x6D, 0x69, 0x4E, 0x08, 0x53, 0x09, 0xE0, 0xCC, 0xA8, 0x79, 0x04, 0xCF, 0xFA, 0x35, 0x1C, 0xA6, 0x70, 0x37, 0x64, 0x70, 0x74, 0xF8, 0xD0, 0xC4, 0x34, 0x0F, 0x71, 0xEF, 0x57, 0xC2, 0x43, 0x7D, 0xFA, 0xE5, 0x1B, 0x8C, 0x15, 0xA5, 0x08, 0x60, 0x78, 0xAF, 0xDA, 0x36, 0xDF, 0x79, 0x2D, 0xD7, 0x54, 0x35, 0xD7, 0x8D, 0x99, 0xD5, 0x81, 0xEC, 0x6D, 0x9F, 0x2D, 0x5E, 0xF8, 0x48, 0x85, 0x50, 0x20, 0x7D, 0xBB, 0x16, 0x4E, 0x39, 0x64, 
			0xB7, 0xBC, 0xED, 0xA9, 0x6A, 0x7A, 0x06, 0x09, 0x6B, 0xBC, 0x2C, 0x5A, 0xE1, 0x4F, 0xD4, 0xA9, 0x82, 0x83, 0x5B, 0xBD, 0xCE, 0x14, 0x31, 0x89, 0x66, 0xB3, 0x9C, 0x31, 0x23, 0x00, 0x4B, 0x02, 0x34, 0x85, 0x30, 0x39, 0x77, 0x80, 0x5D, 0x72, 0x0A, 0xCE, 0x43, 0x2A, 0x1F, 0x02, 0x09, 0xAB, 0x2D, 0x46, 0x3A, 0x1C, 0xD2, 0x7B, 0xF6, 0x02, 0x92, 0xCA, 0xDA, 0x26, 0x0C, 0xF8, 0xE2, 0x67, 0x7E, 0xE2, 0x55, 0xB1, 0x3F, 0x6A, 0x06, 0x65, 0x6D, 0x74, 0x98, 0x59, 0xE2, 0x8A, 0x1E, 0x61, 0x03, 0x4D, 0xFC, 0x68, 0x31, 0x6A, 0xE7, 0xCF, 0x52, 0x88, 0x8E, 0x06, 0x97, 0x77, 0xB3, 0x20, 0x7E, 0x09, 0x5D, 0x3B, 
			0xAF, 0x56, 0xF4, 0xE8, 0x4C, 0x69, 0x09, 0xB9, 0x80, 0x38, 0xDC, 0x66, 0x2E, 0x06, 0xF6, 0xCB, 0x1F, 0x1B, 0xAD, 0x51, 0xFF, 0xFD, 0x38, 0x8D, 0x03, 0x90, 0xCF, 0x31, 0x01, 0x30, 0xEA, 0x48, 0x4C, 0xBB, 0x40, 0x87, 0x1D, 0x97, 0x6A, 0x56, 0x4C, 0xED, 0x07, 0x23, 0x45, 0x50, 0x2F, 0x56, 0xC9, 0x90, 0x79, 0x09, 0xC5, 0x45, 0xB9, 0xAD, 0x58, 0x2B, 0x4C, 0xA3, 0x01, 0xE0, 0x2D, 0xE5, 0x30, 0xBC, 0x54, 0xEC, 0x65, 0xB4, 0x79, 0x22, 0x7D, 0x15, 0xF6, 0x28, 0xCD, 0x84, 0x7E, 0x27, 0x95, 0xA1, 0xC7, 0x82, 0x6D, 0xFB, 0xDF, 0x03, 0xD9, 0x14, 0xFE, 0x0A, 0x06, 0x6F, 0x14, 0xFF, 0x8A, 0x27, 0x80, 0x36, 
			0xDC, 0xBA, 0xAE, 0xDD, 0x44, 0x15, 0xA5, 0x6E, 0x64, 0x73, 0xBD, 0xFB, 0xAE, 0x6D, 0x6F, 0x42, 0x96, 0xDF, 0x90, 0xE5, 0x6A, 0x9B, 0x05, 0xAE, 0xD5, 0x0A, 0x22, 0x88, 0xD6, 0x5D, 0x4C, 0x7B, 0xB1, 0x3A, 0xFC, 0x0C, 0x32, 0x02, 0xB1, 0x18, 0x0D, 0xAF, 0xE0, 0xFE, 0x7E, 0x07, 0x96, 0x85, 0xBB, 0xC8, 0x21, 0x68, 0x12, 0xD4, 0xC8, 0xBF, 0x91, 0x47, 0xE2, 0xF3, 0xA5, 0xA3, 0x86, 0xE6, 0x30, 0x42, 0xF5, 0xA9, 0xB9, 0x48, 0xCB, 0x18, 0xE6, 0x64, 0x3B, 0xE0, 0x8E, 0xC3, 0x03, 0x45, 0xA0, 0xED, 0x1A, 0x09, 0xFF, 0xB3, 0x99, 0x14, 0x5F, 0xDA, 0x90, 0x58, 0x61, 0x8E, 0xF7, 0x0A, 0x00, 0xC7, 0x44, 0xE7, 
			0x73, 0x78, 0xC4, 0x8B, 0x39, 0xCE, 0x70, 0x0E, 0x24, 0x03, 0x95, 0x94, 0x73, 0x76, 0x10, 0x7E, 0x4C, 0xFF, 0xCA, 0x49, 0x93, 0x89, 0xD4, 0x3E, 0x1A, 0x88, 0xCC, 0x48, 0xA7, 0x78, 0x2F, 0x83, 0x4F, 0x6C, 0x33, 0x55, 0xDD, 0x7F, 0x7D, 0x4D, 0xE5, 0xCD, 0x9C, 0x3D, 0x04, 0x1E, 0xC1, 0x9B, 0x6D, 0x7E, 0x7A, 0xAC, 0x93, 0x5E, 0x2B, 0xC3, 0x85, 0x36, 0x07, 0x66, 0xE8, 0xC9, 0xC0, 0xD1, 0x54, 0xF4, 0x4C, 0x6A, 0x02, 0x24, 0x9A, 0x7D, 0x10, 0xD9, 0x79, 0x94, 0x00, 0x64, 0x63, 0x36, 0xDC, 0x35, 0x0C, 0x8F, 0x79, 0xBA, 0xC7, 0x10, 0x76, 0xF8, 0x4A, 0xD3, 0x69, 0x95, 0x23, 0x89, 0x66, 0xC4, 0x5A, 0xE7, 
			0xCE, 0x21, 0xBC, 0xCB, 0xF2, 0x4F, 0x92, 0x33, 0xE7, 0x89, 0xD6, 0x23, 0xF7, 0x67, 0x5B, 0x20, 0xD9, 0xDA, 0x1A, 0xD1, 0xF6, 0x9E, 0x01, 0x83, 0x51, 0xAF, 0x35, 0x43, 0xDD, 0x3A, 0xAB, 0xCA, 0x0E, 0xED, 0x2E, 0x4D, 0x1E, 0x91, 0xCF, 0x2E, 0xA9, 0x4D, 0x08, 0xD9, 0x48, 0x30, 0x37, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0xA2, 0xED, 0x05, 0x50, 0x89, 0x91, 0x1D, 0xEB, 0xF6, 0x57, 0x66, 0xAF, 0x70, 0x15, 0xDD, 0x1A, 0xA1, 0x94, 0xB7, 0xB2, 0x04, 0x14, 0x09, 0xE4, 0x0B, 0xEC, 0x1D, 0x93, 0x3E, 0x32, 0x94, 0x6A, 0x95, 0x36, 0xDD, 0xBA, 0x93, 0x9D, 0x75, 0xB6, 
			0x3E, 0xF5 };

		static public byte[] farscape_nopwd_pfx = { 0x30, 0x82, 0x06, 0xA3, 0x02, 0x01, 0x03, 0x30, 0x82, 0x06, 0x63, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x06, 0x54, 0x04, 0x82, 0x06, 0x50, 0x30, 0x82, 0x06, 0x4C, 0x30, 0x82, 0x03, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x03, 0x7E, 0x04, 0x82, 0x03, 0x7A, 0x30, 0x82, 0x03, 0x76, 0x30, 0x82, 0x03, 0x72, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xB6, 0x30, 0x82, 0x02, 0xB2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 
			0x0E, 0x04, 0x08, 0x31, 0xB9, 0x22, 0x7A, 0x73, 0xB6, 0x67, 0x3E, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x02, 0x90, 0x05, 0x3F, 0x9B, 0x6F, 0x4D, 0xE2, 0x97, 0xC0, 0x71, 0x61, 0xDC, 0x39, 0x33, 0x9B, 0x45, 0x36, 0xD1, 0xC2, 0xC1, 0x2E, 0xE3, 0x22, 0x88, 0xE2, 0x54, 0x18, 0xE8, 0xC9, 0x0E, 0xA7, 0xBB, 0x1B, 0xC6, 0xC8, 0x32, 0xD9, 0x47, 0x64, 0x40, 0xC2, 0x40, 0xDC, 0x34, 0xB5, 0x34, 0x5D, 0x8A, 0x56, 0xD9, 0xF6, 0x0A, 0x03, 0x93, 0x5D, 0xE5, 0x04, 0xDC, 0x5B, 0xBA, 0x49, 0x22, 0x0A, 0x51, 0x33, 0xFF, 0xF0, 0xAF, 0x5D, 0x1F, 0x97, 0x6A, 0x11, 0x1C, 0x6B, 0x1A, 0xCF, 0x2E, 0x41, 0xA1, 0xD0, 0x31, 
			0xC2, 0x2D, 0xDD, 0x83, 0xAA, 0x21, 0x0C, 0x0E, 0x78, 0xEE, 0x9C, 0x25, 0x74, 0xC5, 0x4F, 0xE4, 0x94, 0x84, 0xA8, 0xD9, 0x2F, 0x96, 0xF5, 0x06, 0x05, 0xAE, 0x99, 0xBF, 0x8B, 0xD6, 0x67, 0x5E, 0xCB, 0x61, 0x03, 0xCC, 0x5A, 0x5F, 0xAB, 0x82, 0x55, 0xB1, 0x8D, 0xCD, 0xFE, 0x1C, 0x25, 0x48, 0xA7, 0x1D, 0xFF, 0x2E, 0xC0, 0x23, 0x80, 0xF7, 0xE4, 0x22, 0x68, 0x07, 0xFF, 0x58, 0xA5, 0xAA, 0x71, 0x7A, 0xAB, 0x48, 0x2D, 0xE6, 0xDF, 0xB5, 0x3C, 0x90, 0x15, 0xE3, 0x55, 0x4A, 0xB4, 0x37, 0xFE, 0x7F, 0xE1, 0x5B, 0x0C, 0xF1, 0x01, 0x4C, 0x60, 0x2F, 0x6F, 0x59, 0x09, 0x2B, 0x96, 0xDC, 0xE2, 0x2C, 0xF0, 0xB9, 
			0xF3, 0x3E, 0x46, 0x5B, 0x68, 0xA9, 0xBB, 0x42, 0x8B, 0xAB, 0xA9, 0x68, 0x56, 0xF9, 0xB2, 0x2E, 0x93, 0xDD, 0xE9, 0xBB, 0x70, 0x9E, 0x2E, 0x48, 0xB9, 0xDB, 0x1C, 0x95, 0x0F, 0x67, 0xD4, 0x13, 0x02, 0x62, 0xE0, 0xFA, 0x18, 0x48, 0xAE, 0x31, 0xB6, 0x1F, 0x68, 0x7D, 0xB2, 0x16, 0x61, 0xCD, 0x04, 0x91, 0x50, 0xBF, 0x35, 0xBF, 0x76, 0xA3, 0x5B, 0x76, 0xFE, 0x3F, 0xAB, 0xB2, 0x59, 0x8B, 0xD0, 0xB7, 0xC6, 0x36, 0x0E, 0x2C, 0x31, 0x48, 0xFB, 0x69, 0x6F, 0x90, 0x37, 0x3F, 0xE1, 0x53, 0x36, 0x5A, 0x60, 0x53, 0x93, 0x46, 0xC4, 0x31, 0x92, 0x3B, 0x11, 0x9F, 0x67, 0xC3, 0xD0, 0x2E, 0x9F, 0x7D, 0xA8, 0xBE, 
			0xA3, 0xB2, 0xCF, 0x60, 0xA3, 0xCE, 0x9F, 0x4B, 0x72, 0xCD, 0x44, 0x26, 0x4C, 0x66, 0xF8, 0x75, 0x80, 0xFC, 0x23, 0xBC, 0xA1, 0x3A, 0xCA, 0xC9, 0xE7, 0x50, 0xA3, 0x79, 0x21, 0x2B, 0x2D, 0x09, 0x8C, 0x45, 0x89, 0xB6, 0xAF, 0x66, 0x3E, 0xF7, 0xFD, 0xA5, 0x69, 0x96, 0xB4, 0x65, 0xB5, 0xFE, 0x35, 0x1F, 0x80, 0xA7, 0x41, 0x90, 0xBA, 0x92, 0x8D, 0x3B, 0xC0, 0x37, 0xDE, 0x95, 0xA8, 0x0D, 0xF1, 0x1A, 0x9F, 0xD2, 0x70, 0xED, 0x38, 0x1E, 0xA2, 0xF1, 0x2B, 0x63, 0x62, 0xC5, 0xAE, 0x5D, 0x0F, 0xFC, 0x80, 0xFA, 0x0E, 0xE4, 0xE7, 0x6C, 0x62, 0x3B, 0x19, 0xBB, 0xA8, 0xE5, 0x1D, 0x3E, 0x06, 0x30, 0x0B, 0xE1, 
			0xCF, 0xB6, 0xB4, 0x87, 0x96, 0xA2, 0x5E, 0xF8, 0x0F, 0x13, 0xAE, 0x04, 0xAF, 0xB2, 0x6C, 0x9E, 0xA0, 0x28, 0x1C, 0x46, 0xE5, 0xA8, 0x25, 0x62, 0x51, 0x95, 0xB0, 0x70, 0x60, 0xB6, 0xD9, 0xBB, 0xE3, 0xD1, 0xF0, 0x1D, 0x25, 0xBD, 0x93, 0x5E, 0xB6, 0x47, 0x50, 0xCD, 0x77, 0x7A, 0xFF, 0xC5, 0xFF, 0x4A, 0x7A, 0x9A, 0x27, 0x22, 0xEB, 0x7C, 0x12, 0xE5, 0x59, 0x1F, 0x60, 0xEA, 0xC3, 0x93, 0x4D, 0x28, 0x49, 0x2D, 0xF9, 0xC0, 0x13, 0x12, 0x89, 0x96, 0xED, 0x78, 0xB0, 0x1C, 0x82, 0xDE, 0xEE, 0x40, 0xDE, 0x68, 0x2B, 0x45, 0x16, 0xBE, 0xBF, 0xD5, 0x85, 0x6A, 0xDB, 0xD9, 0x1E, 0xEE, 0xFA, 0x6C, 0x95, 0x19, 
			0xF3, 0x76, 0x61, 0x72, 0x21, 0x69, 0x77, 0x18, 0x2C, 0xFA, 0x99, 0x7A, 0xD7, 0x58, 0xC4, 0xD6, 0x1D, 0x8B, 0xE8, 0x0B, 0xEC, 0x0F, 0x0F, 0xFA, 0xCE, 0xE2, 0x6F, 0xB1, 0xF5, 0x4F, 0xC3, 0xF7, 0x4A, 0xE4, 0x79, 0xB0, 0xFC, 0x62, 0x88, 0xC0, 0x49, 0xEC, 0xDB, 0xC8, 0xCD, 0xBE, 0x25, 0x00, 0x68, 0xB6, 0x5E, 0x89, 0x78, 0xE6, 0x92, 0xA5, 0x5D, 0x55, 0xA7, 0xAD, 0xFF, 0x3D, 0xC7, 0xF9, 0x95, 0x8D, 0xCF, 0x6E, 0x37, 0x1D, 0x79, 0x74, 0xE1, 0xDE, 0x22, 0x07, 0x6B, 0xE6, 0xB7, 0x7D, 0xD1, 0x0F, 0xB6, 0xA4, 0x3F, 0x0F, 0x31, 0x81, 0x09, 0xAD, 0xFD, 0x5F, 0xA4, 0xF4, 0x8F, 0x3C, 0x02, 0xB8, 0xB0, 0x04, 
			0x70, 0x44, 0x2C, 0x73, 0x42, 0xEE, 0xFF, 0xBA, 0x45, 0x50, 0xC0, 0x95, 0xFF, 0x62, 0x14, 0x91, 0x23, 0xF2, 0x8A, 0x65, 0x40, 0x20, 0xEB, 0x4B, 0x7B, 0x66, 0xF2, 0xC2, 0xC8, 0xD7, 0x16, 0x93, 0x0A, 0xBD, 0x5C, 0xCC, 0x11, 0x38, 0xEA, 0x90, 0x9C, 0x37, 0xDA, 0xB2, 0x80, 0xBF, 0x5C, 0x41, 0xC8, 0x3B, 0x16, 0x81, 0x83, 0xF7, 0xE4, 0x16, 0x12, 0x6C, 0x5F, 0x05, 0xBE, 0x2B, 0x04, 0x62, 0x36, 0x13, 0x8F, 0xF1, 0xC2, 0x5A, 0xCB, 0xFB, 0x26, 0x04, 0xE0, 0x31, 0x81, 0xA8, 0x30, 0x0D, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x02, 0x31, 0x00, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x17, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x0A, 0x1E, 0x08, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x6F, 0x30, 0x69, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5C, 0x1E, 0x5A, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x52, 0x00, 0x53, 0x00, 0x41, 0x00, 0x20, 0x00, 0x53, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x6C, 
			0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x30, 0x82, 0x02, 0xB7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x02, 0xA8, 0x30, 0x82, 0x02, 0xA4, 0x02, 0x01, 0x00, 0x30, 0x82, 0x02, 0x9D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 
			0x06, 0x30, 0x0E, 0x04, 0x08, 0x37, 0xAE, 0x94, 0x2A, 0x4C, 0x78, 0xA2, 0x9A, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x02, 0x70, 0x49, 0xB9, 0xA3, 0x6E, 0xC7, 0x96, 0xCF, 0x92, 0x12, 0x43, 0x69, 0x57, 0xAD, 0x4B, 0x88, 0xA8, 0x3F, 0xEA, 0x25, 0xB6, 0xE4, 0x16, 0x74, 0x4E, 0xF5, 0xF8, 0xF2, 0xEC, 0xC0, 0xB7, 0xC2, 0x6A, 0x6E, 0xC0, 0x67, 0x5A, 0x5D, 0xFE, 0x0A, 0x7C, 0xBD, 0x06, 0xFF, 0x2F, 0x34, 0xFD, 0xE4, 0x06, 0x70, 0x23, 0xA3, 0x28, 0x27, 0xCA, 0x91, 0xD0, 0xC7, 0xA1, 0x08, 0x4F, 0x78, 0x0E, 0x89, 0xED, 0x29, 0x8F, 0xD6, 0x8E, 0x1C, 0xE0, 0x30, 0x08, 0x77, 0xA0, 0x3F, 0x18, 0xF1, 0x81, 0xD5, 
			0x73, 0xD7, 0x1A, 0xCA, 0xD4, 0x6D, 0x56, 0x7D, 0xFD, 0x30, 0xB5, 0xA0, 0x5D, 0x59, 0x82, 0xB9, 0xF7, 0x02, 0x19, 0x83, 0x68, 0x19, 0x08, 0x5E, 0x26, 0xCF, 0x06, 0xFA, 0xA0, 0xB4, 0x85, 0x95, 0x10, 0x6F, 0x91, 0x82, 0x89, 0xE8, 0x46, 0xEE, 0x51, 0xEB, 0x2A, 0x45, 0xAC, 0x93, 0x87, 0x48, 0x8C, 0xB6, 0x02, 0xB4, 0x4D, 0xC6, 0xFC, 0x51, 0x4C, 0x75, 0x9D, 0x5A, 0xE7, 0x46, 0x5B, 0x0A, 0x9D, 0x75, 0xA3, 0x0C, 0xB2, 0x54, 0x2A, 0x3E, 0x3A, 0x25, 0xA3, 0x75, 0x66, 0x52, 0x61, 0x7A, 0x78, 0xED, 0xDD, 0x7E, 0xF2, 0x4A, 0xA6, 0xB6, 0x3D, 0xEA, 0x62, 0xE4, 0x68, 0x95, 0x74, 0x3D, 0x45, 0xC1, 0x6E, 0x6B, 
			0xB6, 0x6E, 0x8F, 0x97, 0x39, 0xB5, 0x4F, 0xAA, 0x8E, 0xBB, 0x55, 0x10, 0x19, 0xCB, 0x66, 0xA0, 0xBF, 0xAE, 0x8B, 0xE6, 0xBC, 0x92, 0x8D, 0x2D, 0xC1, 0x83, 0x87, 0x53, 0x81, 0x32, 0x3B, 0x8E, 0x80, 0x76, 0xF9, 0xDE, 0x60, 0x8F, 0x99, 0x02, 0x4F, 0x97, 0x73, 0x3D, 0xE3, 0xC7, 0xBA, 0xBD, 0x4C, 0x3F, 0x8A, 0x9B, 0xE3, 0xFE, 0x24, 0xC3, 0x3E, 0xDE, 0x02, 0x0F, 0x46, 0x84, 0x79, 0xDF, 0x5E, 0xC9, 0xA3, 0x7C, 0x58, 0x62, 0xFC, 0x1D, 0x9F, 0x5E, 0x9A, 0xDB, 0x3C, 0x45, 0x96, 0x91, 0xFD, 0xD9, 0xD0, 0xE7, 0x7F, 0x72, 0xBA, 0x2D, 0xC5, 0x3A, 0x54, 0xBC, 0xA0, 0xAE, 0xAA, 0xFF, 0xE9, 0x18, 0x0C, 0x1B, 
			0x9A, 0xD4, 0xDA, 0x82, 0xBF, 0x51, 0x23, 0xB3, 0x6E, 0xEF, 0xDB, 0x85, 0xE5, 0xBF, 0x02, 0xCC, 0xFB, 0x79, 0xA6, 0x45, 0x86, 0xDC, 0xDF, 0xF0, 0x2C, 0x15, 0x0B, 0xD1, 0xE5, 0x80, 0xBB, 0x3F, 0x65, 0x94, 0xE5, 0xAB, 0x76, 0xE4, 0xA5, 0x92, 0x7D, 0x0E, 0x8C, 0xC0, 0x92, 0x83, 0x40, 0x9D, 0x2F, 0xBD, 0x30, 0xE1, 0x7B, 0xB5, 0x91, 0xB2, 0x5E, 0xD9, 0xC6, 0xB7, 0xA4, 0x30, 0x06, 0x18, 0xED, 0x33, 0x95, 0x7B, 0xA6, 0xE3, 0xE5, 0xC0, 0x4B, 0xF5, 0x0B, 0x6A, 0x3A, 0xF5, 0xAC, 0x77, 0x22, 0xC0, 0x84, 0x3C, 0x5B, 0xE5, 0x55, 0xD5, 0xDC, 0x7E, 0xFE, 0x08, 0x02, 0x37, 0x69, 0x52, 0xB8, 0x44, 0x29, 0x16, 
			0xB5, 0xE8, 0x8A, 0xA4, 0xAC, 0x24, 0x58, 0xC3, 0x53, 0xAC, 0x37, 0xE2, 0xD4, 0x0F, 0x21, 0xC1, 0x54, 0x62, 0x28, 0xCA, 0xA3, 0x8C, 0x01, 0x26, 0x97, 0xFF, 0xAD, 0x0E, 0x5F, 0xB1, 0x86, 0x96, 0xD1, 0xFA, 0xE5, 0x9F, 0x38, 0x42, 0x4D, 0x32, 0xEB, 0xC8, 0x4B, 0x4A, 0x01, 0x91, 0x5C, 0xCE, 0xC8, 0x89, 0x0A, 0x7C, 0x32, 0x6D, 0x08, 0x3E, 0x7D, 0xB0, 0x3D, 0x16, 0x99, 0x52, 0xB0, 0xE0, 0xBE, 0xFF, 0x42, 0x61, 0xC3, 0x56, 0xE1, 0x9A, 0xA3, 0xFB, 0x72, 0xBB, 0x3B, 0x4C, 0xA3, 0xFC, 0x5E, 0xFE, 0xC7, 0xF2, 0xBB, 0x17, 0x96, 0x00, 0xB6, 0x02, 0xD1, 0x58, 0xF0, 0xDA, 0x63, 0xD2, 0x4C, 0x91, 0xDF, 0xFA, 
			0xB5, 0xAF, 0x1E, 0xDA, 0xD7, 0x02, 0x85, 0xFE, 0x80, 0x94, 0x77, 0x92, 0x84, 0x9A, 0x2F, 0x1C, 0xC2, 0x71, 0xA7, 0x3F, 0xFA, 0x00, 0xFC, 0x7E, 0x4B, 0xE2, 0xD2, 0x7B, 0xC8, 0xB9, 0x26, 0xEC, 0xD4, 0x7A, 0x3D, 0x6F, 0x89, 0xB4, 0x22, 0x2F, 0xE9, 0x41, 0xA9, 0x97, 0x8C, 0x76, 0xCE, 0xCD, 0xA6, 0x94, 0xA9, 0x1D, 0x25, 0x7C, 0x4D, 0xCF, 0x2E, 0x51, 0x59, 0xE9, 0xE3, 0xDB, 0x84, 0x28, 0x2E, 0x31, 0x24, 0xF9, 0xA7, 0xC0, 0xA7, 0x77, 0xD0, 0xB5, 0x19, 0x1C, 0xC9, 0x22, 0x28, 0x94, 0x39, 0xF5, 0xC3, 0xAA, 0x78, 0x3A, 0xE6, 0x1D, 0xB3, 0xCA, 0x95, 0x7F, 0x7D, 0xBD, 0xFA, 0x7F, 0xCD, 0x09, 0xA5, 0x77, 
			0x8E, 0xC8, 0xEB, 0x03, 0x26, 0xAF, 0x38, 0x5A, 0x9A, 0xFB, 0xDC, 0x90, 0xBD, 0xD7, 0x46, 0xA7, 0xB4, 0x71, 0x8F, 0xF7, 0x66, 0x4A, 0x07, 0x66, 0xE4, 0xD7, 0x3E, 0xC4, 0xD4, 0x2B, 0x15, 0x1F, 0xC8, 0x9C, 0x3A, 0x47, 0x5E, 0x6F, 0x84, 0xE3, 0x02, 0x62, 0x05, 0x86, 0x63, 0x30, 0x37, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x62, 0x54, 0xAE, 0x53, 0x8C, 0x33, 0xEC, 0x3E, 0x2D, 0x73, 0xE6, 0xEB, 0x9A, 0xDD, 0x31, 0xEE, 0x06, 0x83, 0x4B, 0xBA, 0x04, 0x14, 0x60, 0x9B, 0x73, 0xDD, 0x3F, 0x8F, 0x2E, 0x52, 0x1C, 0x4C, 0xB9, 0x8E, 0x7A, 0xC0, 0xCD, 0x52, 0xB4, 0xBA, 
			0xBD, 0x8C };

		static public byte[] farscape_path_pfx = { 0x30, 0x82, 0x0B, 0x53, 0x02, 0x01, 0x03, 0x30, 0x82, 0x0B, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x0B, 0x04, 0x04, 0x82, 0x0B, 0x00, 0x30, 0x82, 0x0A, 0xFC, 0x30, 0x82, 0x03, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x03, 0x7E, 0x04, 0x82, 0x03, 0x7A, 0x30, 0x82, 0x03, 0x76, 0x30, 0x82, 0x03, 0x72, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xB6, 0x30, 0x82, 0x02, 0xB2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 
			0x0E, 0x04, 0x08, 0x38, 0xE0, 0x5B, 0xD2, 0xF6, 0x07, 0x19, 0xE1, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x02, 0x90, 0x1B, 0xCB, 0x34, 0x7D, 0x3A, 0x5F, 0x9A, 0xA9, 0x87, 0xD7, 0x17, 0xCF, 0x5D, 0xAD, 0x94, 0xB8, 0x36, 0xCD, 0xEC, 0x1B, 0xDF, 0x58, 0xA9, 0x99, 0x18, 0x75, 0xC8, 0x9D, 0x4F, 0x2D, 0xED, 0x82, 0x10, 0x18, 0xFC, 0x9A, 0x89, 0x3D, 0xAC, 0x3C, 0xC3, 0x26, 0x5F, 0x2B, 0x72, 0x48, 0xD5, 0xA3, 0xFA, 0x12, 0x57, 0x7E, 0x60, 0x05, 0xA1, 0x2B, 0x20, 0xAF, 0xB4, 0x3B, 0x1A, 0x38, 0xA4, 0xED, 0x0A, 0x25, 0xA3, 0x4B, 0xBF, 0xAB, 0x64, 0x26, 0xE9, 0xB5, 0x6E, 0xE1, 0x94, 0x44, 0xFA, 0x13, 0x14, 
			0x0B, 0x49, 0x76, 0xCB, 0xB8, 0x68, 0xD0, 0x64, 0xEE, 0xB6, 0xBC, 0xA4, 0xD1, 0x30, 0x8C, 0xEF, 0xC9, 0xA7, 0x07, 0x6F, 0x0E, 0xAA, 0xF7, 0x48, 0xA7, 0xE1, 0x7A, 0x3B, 0x85, 0x75, 0x79, 0x65, 0x51, 0xE9, 0xA7, 0x1A, 0x6C, 0xE3, 0x08, 0x99, 0x48, 0x4B, 0xC5, 0x66, 0xC5, 0x73, 0xB3, 0x5B, 0x99, 0x60, 0xDF, 0x8E, 0x3D, 0xB8, 0x04, 0x09, 0xA2, 0x2D, 0x70, 0xBF, 0x6F, 0x00, 0x9D, 0x1B, 0x3F, 0xE0, 0xE7, 0xDE, 0x05, 0x71, 0x54, 0x3F, 0x2D, 0x29, 0x3A, 0xFD, 0x44, 0xE6, 0x7F, 0x30, 0x9B, 0x71, 0x43, 0x55, 0x78, 0x40, 0x74, 0x6D, 0x11, 0x64, 0xBB, 0x04, 0xB7, 0x36, 0xE0, 0xA4, 0x45, 0x74, 0xBC, 0xC4, 
			0xC2, 0x40, 0xA5, 0xF1, 0x62, 0x9D, 0x59, 0x18, 0xAD, 0x3D, 0xD6, 0xDB, 0x9A, 0xF3, 0x34, 0x36, 0x8B, 0x0C, 0xAF, 0xC8, 0x72, 0x82, 0x9F, 0x34, 0xC2, 0xE0, 0x96, 0xB4, 0x57, 0xB9, 0x02, 0x8E, 0x00, 0x3F, 0xC6, 0x8A, 0x62, 0x02, 0xFE, 0x15, 0xCB, 0xAE, 0x49, 0xD7, 0x06, 0x4F, 0xFC, 0xF3, 0x93, 0xC1, 0x0F, 0x78, 0x8F, 0xD6, 0xEE, 0xD7, 0xB4, 0x6F, 0xA4, 0xD8, 0x62, 0x13, 0x27, 0x81, 0x58, 0xEC, 0x04, 0x44, 0xB6, 0x47, 0xBB, 0xAA, 0xEA, 0x51, 0x44, 0xF1, 0xD3, 0x2D, 0x7E, 0x79, 0xED, 0xF0, 0x3D, 0x05, 0xA0, 0xC5, 0x61, 0x05, 0x2A, 0xE3, 0x08, 0xF1, 0xD9, 0xFC, 0x85, 0x18, 0xF7, 0x49, 0xEE, 0x33, 
			0x01, 0xD8, 0xE1, 0x3C, 0x69, 0xC5, 0x99, 0xE4, 0xA3, 0xCE, 0xBE, 0xA8, 0x19, 0x6A, 0x76, 0x63, 0x09, 0xD3, 0xD3, 0x3B, 0x56, 0x5A, 0xEA, 0x90, 0x6F, 0x2A, 0xA9, 0x24, 0x6C, 0x30, 0x2F, 0x89, 0x8C, 0x77, 0x79, 0xC1, 0x5A, 0x6A, 0xFD, 0xEC, 0x42, 0x5E, 0xAF, 0x75, 0xDE, 0xC9, 0x08, 0x26, 0xCE, 0x2C, 0xF2, 0xBD, 0x86, 0x92, 0x1B, 0xBB, 0x51, 0x84, 0x56, 0xB7, 0x9D, 0x1C, 0x21, 0x31, 0x02, 0xFC, 0xCA, 0x6F, 0xDB, 0x71, 0xC2, 0x5B, 0x13, 0x5C, 0x96, 0x50, 0x14, 0x3B, 0x80, 0x0B, 0x23, 0xB1, 0x21, 0xCE, 0x63, 0x76, 0x7F, 0x0C, 0x00, 0x32, 0xE7, 0x7E, 0x60, 0x6E, 0x76, 0x61, 0xF5, 0xAC, 0xCF, 0xA2, 
			0xDC, 0xE6, 0x65, 0xD3, 0x01, 0xD4, 0x9C, 0x26, 0xDA, 0xF3, 0xAD, 0x00, 0xE2, 0x56, 0x24, 0xF2, 0x3F, 0x75, 0x7B, 0xEE, 0x2D, 0xB2, 0xCC, 0xF2, 0x0A, 0x14, 0x90, 0xC4, 0x2A, 0x79, 0xDE, 0x2A, 0x35, 0x66, 0xBC, 0xC2, 0x55, 0xDC, 0xB9, 0x0F, 0xC8, 0x08, 0x51, 0xCE, 0x40, 0xAD, 0x5E, 0xB8, 0xDD, 0xA0, 0x2C, 0x4C, 0x96, 0x99, 0x3B, 0x8F, 0x0B, 0xCC, 0x00, 0xA1, 0x37, 0xF5, 0xDB, 0xE2, 0xF8, 0x15, 0xA1, 0xC3, 0xCE, 0x6B, 0xDE, 0x3F, 0xE9, 0x52, 0x9D, 0x07, 0x2E, 0xBC, 0x7A, 0x67, 0x94, 0x19, 0x50, 0x32, 0xFC, 0x1E, 0x6E, 0x9A, 0x94, 0xDD, 0xB6, 0x87, 0x3D, 0x44, 0xA1, 0xA4, 0x95, 0x7A, 0x10, 0x3E, 
			0xAD, 0x73, 0x5E, 0xA8, 0xCF, 0x35, 0x0E, 0x6D, 0x48, 0xE7, 0xC5, 0x2D, 0x91, 0xAB, 0x56, 0xF5, 0x6B, 0x4B, 0xBC, 0x65, 0xB9, 0x3A, 0x7D, 0x46, 0x8E, 0xD0, 0xC0, 0x71, 0x0F, 0x12, 0x0D, 0xFD, 0x50, 0x49, 0xFF, 0x23, 0x0A, 0xC2, 0xA0, 0xB1, 0xD9, 0x5D, 0x08, 0xFE, 0xDB, 0x52, 0x91, 0xD0, 0x8D, 0x60, 0x7D, 0xDC, 0x77, 0x0A, 0x99, 0xBF, 0xC5, 0x42, 0xFB, 0x0D, 0x44, 0x38, 0xF4, 0xC4, 0xB1, 0xF2, 0x87, 0x8B, 0x26, 0x3C, 0x2D, 0x1C, 0xE2, 0x67, 0xEE, 0xF6, 0x84, 0xB8, 0x04, 0xE8, 0x2B, 0x8D, 0x7C, 0x59, 0x0F, 0x70, 0xF5, 0x60, 0xEA, 0x44, 0x1F, 0xB8, 0xB8, 0xCB, 0xEB, 0xFC, 0xBE, 0xBE, 0x82, 0xA6, 
			0xBB, 0x1B, 0x77, 0x26, 0x58, 0x45, 0xA6, 0x4B, 0x0A, 0x92, 0x86, 0xC4, 0x52, 0xEA, 0x72, 0xA4, 0xCF, 0x72, 0xB8, 0x98, 0x40, 0x76, 0x2D, 0x2D, 0xB2, 0xCD, 0xC0, 0x0D, 0x0F, 0x96, 0x8A, 0xA0, 0x39, 0xD2, 0xF0, 0x79, 0xD9, 0x19, 0xE3, 0x12, 0x40, 0xAB, 0x49, 0x3F, 0xC9, 0x97, 0x3D, 0x25, 0xFF, 0xCF, 0xEC, 0x01, 0xBF, 0xE3, 0x4E, 0xB4, 0x3B, 0x8F, 0x64, 0xDC, 0x70, 0xDA, 0xA0, 0xE6, 0x1C, 0x09, 0x95, 0x6B, 0xCF, 0x16, 0xBF, 0x44, 0xA5, 0xFA, 0x36, 0x31, 0x81, 0xA8, 0x30, 0x0D, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x02, 0x31, 0x00, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x17, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x0A, 0x1E, 0x08, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x6F, 0x30, 0x69, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5C, 0x1E, 0x5A, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x52, 0x00, 0x53, 0x00, 0x41, 0x00, 0x20, 0x00, 0x53, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x6C, 
			0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x30, 0x82, 0x07, 0x67, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x07, 0x58, 0x30, 0x82, 0x07, 0x54, 0x02, 0x01, 0x00, 0x30, 0x82, 0x07, 0x4D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 
			0x06, 0x30, 0x0E, 0x04, 0x08, 0xB7, 0xF8, 0xA2, 0x70, 0xCF, 0xB6, 0x51, 0x48, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x07, 0x20, 0x5E, 0x23, 0x13, 0x6E, 0x0A, 0x69, 0x00, 0x0C, 0xDA, 0xAD, 0xA8, 0xC8, 0xF8, 0xAC, 0xDC, 0x31, 0x49, 0xB8, 0x96, 0xF3, 0x75, 0x0F, 0x1C, 0xEF, 0x68, 0xA2, 0x9F, 0xB3, 0xE3, 0xB0, 0x39, 0x81, 0x61, 0x95, 0x86, 0x5A, 0x99, 0x6C, 0x6C, 0x84, 0xE6, 0x8D, 0x8D, 0xD9, 0x2E, 0xA8, 0xE9, 0x3B, 0xC6, 0x74, 0xB1, 0xD1, 0xCA, 0xC2, 0x38, 0x8C, 0x0C, 0xB4, 0x06, 0x29, 0x26, 0x52, 0x35, 0x68, 0x28, 0xA6, 0xF4, 0x7B, 0x0A, 0xE0, 0xBC, 0xA9, 0xBD, 0xAC, 0x5F, 0xFF, 0x06, 0x56, 0x70, 
			0xE1, 0xB0, 0x11, 0x2B, 0x17, 0x4B, 0x0A, 0x8C, 0x42, 0x77, 0xD1, 0xF8, 0x08, 0x28, 0x73, 0x60, 0x5A, 0xC1, 0xD9, 0x3F, 0x60, 0x40, 0x21, 0xC6, 0x33, 0x9D, 0x44, 0xF6, 0x98, 0xF4, 0x52, 0xFB, 0x57, 0x6D, 0x1E, 0x9A, 0x52, 0xF6, 0x11, 0xAD, 0xA0, 0xE4, 0xFE, 0x0E, 0xEB, 0x3F, 0xDE, 0x7C, 0xB7, 0x82, 0x04, 0x1C, 0x78, 0xFD, 0xEB, 0x99, 0x4D, 0x8E, 0xEE, 0xCA, 0xB2, 0x4F, 0xD1, 0x47, 0x5B, 0xAA, 0x4A, 0xEB, 0x16, 0xBF, 0x50, 0x93, 0xBF, 0xDF, 0x57, 0x6A, 0x8A, 0xBD, 0x4E, 0xED, 0x72, 0x5D, 0x50, 0x59, 0xC7, 0x4F, 0x4F, 0xB5, 0x7E, 0x4F, 0xA3, 0xC2, 0x51, 0x3B, 0x31, 0x12, 0x14, 0xCC, 0x2E, 0x1C, 
			0xC4, 0xD3, 0xC2, 0x89, 0xD3, 0x6A, 0xC4, 0x16, 0xAA, 0x13, 0x83, 0xD6, 0x30, 0xD6, 0x76, 0xE0, 0x16, 0xCF, 0x28, 0x25, 0xA8, 0xFB, 0x25, 0xBC, 0x82, 0xEF, 0xD4, 0xC4, 0x64, 0x3B, 0xE0, 0xC0, 0x91, 0xC0, 0x21, 0x17, 0x43, 0x8F, 0xCB, 0xCE, 0xD3, 0x2B, 0x7B, 0x11, 0x5E, 0x73, 0x62, 0x17, 0x9E, 0xB4, 0x00, 0xF7, 0xB3, 0x7E, 0x24, 0xC9, 0x21, 0xB8, 0xF7, 0x33, 0x02, 0x04, 0xB9, 0xDE, 0x6C, 0x97, 0xC4, 0x3B, 0xCF, 0xDE, 0xC4, 0xF7, 0x2A, 0x68, 0x8A, 0x82, 0x22, 0xA1, 0x95, 0xBB, 0x9E, 0xF6, 0x6C, 0xBB, 0x0E, 0x69, 0x83, 0x55, 0xE2, 0x5A, 0x5F, 0x60, 0x2E, 0x43, 0x41, 0xD1, 0xB8, 0xAB, 0x17, 0x3A, 
			0x4C, 0xA8, 0xB9, 0x81, 0xFF, 0x40, 0x28, 0x50, 0x67, 0xCF, 0x3A, 0x01, 0x5D, 0xCC, 0x09, 0xD2, 0x2D, 0x2A, 0x7D, 0x4E, 0xDA, 0x88, 0x85, 0x26, 0x03, 0x05, 0x41, 0x2B, 0x7A, 0x4B, 0xEC, 0x1A, 0xBC, 0xDF, 0xD6, 0x98, 0xFA, 0x22, 0x9D, 0xFA, 0xE3, 0x7D, 0x37, 0x5B, 0x5E, 0xFF, 0x54, 0xB3, 0x48, 0x50, 0x0D, 0xDC, 0x93, 0xD4, 0xF8, 0xC7, 0x05, 0x66, 0xC7, 0xAC, 0x9C, 0x87, 0x4A, 0x90, 0xCE, 0x2E, 0xF3, 0x4C, 0x7E, 0x90, 0xC5, 0xE5, 0x20, 0x2C, 0xD9, 0x24, 0xB4, 0x2C, 0x51, 0x57, 0x1F, 0xD9, 0x24, 0x3C, 0xFA, 0x94, 0x0E, 0xAB, 0xAA, 0x6A, 0x42, 0xFE, 0x9D, 0xE7, 0x53, 0xD6, 0xC2, 0x1D, 0x5F, 0x2E, 
			0x79, 0x86, 0x02, 0xDB, 0xD0, 0x8B, 0x0C, 0xD7, 0x43, 0x96, 0x60, 0x2B, 0x4A, 0x8F, 0xEE, 0xE3, 0x19, 0x61, 0x47, 0x82, 0x87, 0x6F, 0x70, 0xB6, 0xE2, 0x3F, 0x17, 0x66, 0x21, 0xE1, 0x53, 0x61, 0xC2, 0xD3, 0xE8, 0x26, 0x02, 0x68, 0x2A, 0x80, 0xC8, 0xFD, 0x8A, 0xA8, 0xCC, 0xD5, 0xAA, 0xCB, 0x14, 0xDD, 0x5A, 0x7D, 0x4A, 0xCA, 0x39, 0xE1, 0x51, 0x8A, 0x26, 0x8A, 0xDA, 0xE2, 0x54, 0x92, 0x28, 0x6E, 0x63, 0x3F, 0x9A, 0x50, 0xC0, 0x5C, 0x76, 0xE2, 0x98, 0x94, 0xFB, 0xBC, 0xAD, 0x93, 0x2C, 0x97, 0xDF, 0x15, 0x20, 0x7D, 0x4F, 0x28, 0xD5, 0xD1, 0x5D, 0x35, 0x8B, 0x5B, 0x96, 0x77, 0x34, 0xDD, 0xA3, 0x07, 
			0x44, 0xFB, 0xCD, 0x72, 0x2B, 0x12, 0xD5, 0x1D, 0x23, 0xA1, 0x51, 0x04, 0xF8, 0x9D, 0xF8, 0xFF, 0x0F, 0x39, 0x0F, 0x05, 0x33, 0x24, 0x0A, 0x1F, 0xD1, 0xB5, 0xA8, 0x75, 0x39, 0x41, 0xE8, 0xD5, 0x99, 0x1D, 0x9B, 0x45, 0xFC, 0x32, 0x20, 0x6E, 0xFA, 0x96, 0x80, 0xDD, 0x88, 0x5D, 0x3B, 0x12, 0x1C, 0xC6, 0x86, 0xFA, 0x27, 0x4A, 0x78, 0x46, 0xE2, 0xC0, 0xCC, 0x66, 0x01, 0xE8, 0x30, 0x32, 0x26, 0x42, 0xDE, 0x8B, 0x71, 0xE8, 0x09, 0x9C, 0xF4, 0x90, 0x71, 0x17, 0x66, 0xFE, 0x0A, 0x0F, 0xD4, 0x84, 0x13, 0xFB, 0x66, 0x99, 0x98, 0xAF, 0xD8, 0x16, 0x13, 0x15, 0xAD, 0x18, 0xBE, 0x49, 0x02, 0xAB, 0x42, 0x50, 
			0x14, 0xB7, 0x3B, 0x33, 0x3C, 0x22, 0xA9, 0xE1, 0xC5, 0x32, 0xCD, 0x8D, 0xB4, 0x31, 0xF9, 0x27, 0x6C, 0x50, 0x0B, 0x40, 0x5E, 0xBE, 0x02, 0xB5, 0x27, 0xC4, 0x0D, 0x2C, 0xD5, 0xAB, 0x8A, 0x58, 0x5E, 0x53, 0xAD, 0x9C, 0x0D, 0x5B, 0x06, 0xE8, 0x77, 0x24, 0x94, 0xAD, 0xC0, 0x2C, 0x17, 0x8F, 0x20, 0x70, 0xC8, 0x29, 0xEB, 0x9B, 0x84, 0x4A, 0x91, 0xA5, 0xEC, 0x85, 0x2C, 0xCF, 0x68, 0xC9, 0x72, 0xEB, 0x3D, 0x63, 0xE9, 0xDB, 0x7D, 0xBB, 0x3D, 0xBE, 0x9A, 0x37, 0x91, 0x07, 0xE5, 0x95, 0x39, 0x63, 0xB0, 0x3F, 0x46, 0xEA, 0xB7, 0x76, 0x82, 0x05, 0xE1, 0xFF, 0x7C, 0x14, 0x41, 0x0F, 0x74, 0x3E, 0x43, 0xCD, 
			0x87, 0x5A, 0xA7, 0x30, 0x61, 0x29, 0xE2, 0xBA, 0x59, 0x7F, 0xF3, 0xBF, 0x78, 0x1C, 0x4A, 0xB8, 0x59, 0xEF, 0x9D, 0xE3, 0xFD, 0xEB, 0xE9, 0x39, 0xA9, 0xDF, 0x3D, 0xC9, 0xD4, 0x42, 0x5F, 0x79, 0xCA, 0xFC, 0xEE, 0xFE, 0xA0, 0x88, 0x30, 0x78, 0x69, 0x37, 0xA0, 0xC2, 0x64, 0xBC, 0x41, 0x65, 0xDB, 0xB8, 0xB0, 0x99, 0xC7, 0xD5, 0xF9, 0x03, 0x05, 0x98, 0x5A, 0xAB, 0x76, 0xB5, 0x0D, 0x7B, 0xDF, 0x9B, 0xFA, 0x92, 0x5D, 0xBD, 0x52, 0x30, 0xB7, 0x0F, 0xE8, 0x60, 0x97, 0xCC, 0xF5, 0x66, 0xA2, 0xD0, 0x77, 0x9E, 0x6B, 0x5C, 0xF2, 0x41, 0x20, 0x21, 0x6D, 0x0C, 0xE1, 0xB6, 0x26, 0xD8, 0xD9, 0x66, 0x94, 0xC0, 
			0x55, 0x4E, 0xCC, 0xBC, 0x2D, 0xDC, 0xC3, 0x23, 0x17, 0x9C, 0x7F, 0xA6, 0x75, 0x38, 0x33, 0xBB, 0x49, 0xBE, 0xF0, 0x77, 0xCB, 0xE7, 0xB2, 0xF5, 0x40, 0xE3, 0xD5, 0xCC, 0x1F, 0x83, 0x50, 0xA5, 0x2E, 0x1B, 0x17, 0xBD, 0x63, 0x8C, 0x9F, 0x99, 0x30, 0x41, 0xC8, 0x0D, 0x8B, 0x05, 0x80, 0x67, 0x03, 0x60, 0xCF, 0x2A, 0xA0, 0x55, 0x14, 0x74, 0xA7, 0xEA, 0x43, 0x3F, 0x5A, 0x03, 0x0B, 0xEF, 0x3F, 0xC8, 0xAA, 0x03, 0xB9, 0x1B, 0xC6, 0xB9, 0x63, 0xD4, 0x9C, 0xA1, 0x42, 0x18, 0x32, 0x12, 0x87, 0xEA, 0x44, 0xB9, 0xA8, 0x72, 0xA8, 0x75, 0xB4, 0x09, 0xEB, 0x90, 0x7F, 0xB5, 0x00, 0x39, 0xDE, 0x2C, 0x07, 0x87, 
			0xB5, 0x35, 0xDD, 0x44, 0x03, 0x09, 0xA9, 0xA0, 0xD6, 0x40, 0x69, 0x88, 0xC9, 0x2A, 0xDB, 0x3E, 0x56, 0xEF, 0x42, 0x23, 0xB7, 0x4D, 0x62, 0xDA, 0x56, 0x1C, 0xC5, 0xC1, 0x4D, 0x07, 0x02, 0x14, 0x7E, 0xE7, 0x6D, 0x38, 0x05, 0x70, 0x19, 0x77, 0xA6, 0x46, 0xE9, 0x18, 0x3E, 0x06, 0xEE, 0x5A, 0xCA, 0x35, 0xE3, 0xCD, 0xAA, 0x4C, 0x89, 0x5D, 0x41, 0x85, 0x17, 0x53, 0x18, 0x86, 0x3D, 0x20, 0x18, 0x53, 0x1D, 0xF8, 0x4C, 0x09, 0x2C, 0x48, 0x75, 0x00, 0xF8, 0xD1, 0xF4, 0xA5, 0xD7, 0x29, 0xB5, 0xFF, 0x42, 0xFA, 0x6B, 0xCB, 0x47, 0x0F, 0x33, 0x00, 0x59, 0x54, 0x07, 0x62, 0x5C, 0xC7, 0x57, 0x63, 0xB4, 0x32, 
			0x5C, 0xF1, 0x8E, 0xBA, 0x6D, 0x0E, 0x85, 0x3B, 0x3D, 0xE7, 0xAA, 0x31, 0x61, 0x77, 0x3F, 0x77, 0xF4, 0x1F, 0xD7, 0x6C, 0x5F, 0x13, 0xCF, 0xB5, 0x9A, 0xAC, 0x6F, 0x2C, 0x49, 0x2D, 0xDD, 0xED, 0x27, 0xA9, 0x77, 0x1F, 0x38, 0x78, 0x16, 0x82, 0x00, 0xB3, 0xD9, 0x8E, 0xFA, 0x43, 0xE2, 0x54, 0xB7, 0x36, 0xED, 0x20, 0x33, 0x1A, 0x7E, 0x0E, 0xF2, 0xEE, 0x20, 0xE7, 0x10, 0xC4, 0xB6, 0x07, 0x0A, 0x42, 0x26, 0xCA, 0xC1, 0x6C, 0x29, 0xA1, 0xBD, 0x05, 0xE0, 0x70, 0xED, 0x17, 0x7C, 0x21, 0xD3, 0x9F, 0x72, 0xE7, 0x47, 0xA3, 0x5F, 0xCA, 0x50, 0x4C, 0x3C, 0x16, 0x9D, 0x20, 0x49, 0x7B, 0x9A, 0x53, 0xCF, 0x7C, 
			0x9B, 0x69, 0x5E, 0xE0, 0x56, 0xB0, 0x60, 0xFB, 0xC6, 0xE8, 0x67, 0x31, 0x18, 0xDB, 0x67, 0xA2, 0x61, 0xE2, 0x8E, 0x35, 0xFA, 0xBD, 0xED, 0x43, 0x32, 0xCA, 0x99, 0xAC, 0xF7, 0xCB, 0xB8, 0x1E, 0x57, 0x2D, 0xC7, 0xB4, 0x2A, 0xEA, 0x53, 0xCE, 0xDB, 0xD7, 0xE6, 0x8F, 0x9A, 0x98, 0x12, 0xE3, 0xB0, 0x7E, 0x85, 0x1B, 0x6B, 0x2F, 0xE3, 0xD0, 0x54, 0x5C, 0x31, 0xC0, 0x96, 0xE8, 0x04, 0xD9, 0x87, 0x8F, 0x8A, 0xC9, 0xC1, 0x95, 0x31, 0x11, 0x66, 0xC3, 0x86, 0x06, 0x93, 0xC4, 0xDC, 0x6F, 0xD7, 0x7C, 0x65, 0xF3, 0xF9, 0xB1, 0x6F, 0x34, 0xD8, 0x25, 0x21, 0x02, 0x1B, 0x12, 0x52, 0x19, 0xD0, 0xED, 0xB8, 0x4A, 
			0x67, 0x1E, 0x49, 0x2C, 0xDD, 0x47, 0xA7, 0x0A, 0x1F, 0x21, 0x67, 0x5A, 0x0F, 0x34, 0xDB, 0x6D, 0x1E, 0xFB, 0x71, 0xBC, 0xB9, 0x8F, 0x84, 0xE4, 0x3A, 0xE4, 0x47, 0x93, 0x48, 0xC2, 0xCA, 0xDA, 0x5B, 0x7B, 0xA0, 0x3F, 0x2F, 0x9C, 0x68, 0xDC, 0x72, 0x15, 0x18, 0x57, 0xBA, 0x32, 0x6B, 0x92, 0x08, 0x08, 0x65, 0xA5, 0x30, 0xA4, 0xED, 0x35, 0x80, 0xC5, 0xD3, 0x93, 0x01, 0x36, 0x53, 0x8E, 0xC9, 0xF6, 0x2D, 0xCA, 0xB9, 0xE6, 0xE9, 0x94, 0x89, 0xE3, 0x05, 0x81, 0x9B, 0x69, 0x0B, 0xD7, 0xD2, 0x55, 0x0A, 0xFE, 0xAF, 0x98, 0x97, 0xB9, 0xCB, 0xB8, 0xCB, 0xB6, 0x48, 0xD1, 0xB4, 0xF1, 0xD2, 0x19, 0x53, 0xB1, 
			0xCE, 0x4E, 0x3D, 0x11, 0xF3, 0xC6, 0x89, 0xFC, 0x68, 0x48, 0x4C, 0xF9, 0x11, 0x1B, 0xDF, 0x10, 0x21, 0x44, 0x2C, 0x43, 0xCC, 0x00, 0x0D, 0xC8, 0x40, 0x6D, 0xDB, 0xCE, 0xC7, 0xBF, 0xA4, 0xCF, 0x6C, 0xAF, 0x71, 0xF4, 0x72, 0xB8, 0xF4, 0x32, 0x19, 0xD2, 0xFC, 0xFE, 0x28, 0xC8, 0x00, 0x44, 0xB9, 0xEC, 0x70, 0x5B, 0xF5, 0x39, 0xDC, 0xBD, 0xF4, 0xEF, 0xC3, 0x8A, 0xF1, 0x06, 0x52, 0x90, 0xAF, 0x18, 0x45, 0xF1, 0xC7, 0x10, 0x0C, 0xD2, 0xB3, 0xBC, 0xE5, 0xF1, 0x32, 0x6A, 0x0C, 0x55, 0x3E, 0x28, 0x62, 0xC9, 0xC1, 0x12, 0x1F, 0x6E, 0x30, 0x6A, 0x4C, 0x9B, 0x6D, 0x32, 0x18, 0x2D, 0xDD, 0xE6, 0x0F, 0xA5, 
			0x0B, 0xBE, 0xBB, 0xF8, 0x8D, 0xF7, 0x40, 0x9F, 0x24, 0xB1, 0x85, 0x17, 0x9F, 0x38, 0x2C, 0xEE, 0x2F, 0x50, 0x99, 0x30, 0x75, 0x95, 0x85, 0xA2, 0xB7, 0xA2, 0x7C, 0x42, 0x58, 0xD9, 0x7D, 0x52, 0xB8, 0x0D, 0xF2, 0x68, 0x57, 0x75, 0xEC, 0x5A, 0xFF, 0xBE, 0xC3, 0xB4, 0x21, 0xE2, 0xA1, 0xCB, 0x60, 0x5F, 0x2A, 0x3A, 0xEE, 0xE0, 0xC3, 0xFB, 0x9A, 0x21, 0x02, 0x86, 0x10, 0xA1, 0xCF, 0x2F, 0x6D, 0x83, 0xBC, 0x09, 0xCE, 0x97, 0x08, 0xDB, 0x6E, 0x17, 0x90, 0xEF, 0x06, 0x2E, 0x19, 0x27, 0xC2, 0x1A, 0x9E, 0xB4, 0xB7, 0x16, 0x1A, 0xF6, 0x92, 0x81, 0x5C, 0xF3, 0x8D, 0x52, 0x87, 0xD1, 0x50, 0x23, 0x78, 0xE5, 
			0x81, 0x16, 0x24, 0x12, 0x21, 0xD8, 0x70, 0x30, 0xB4, 0x38, 0x40, 0x7B, 0xBC, 0x21, 0x51, 0xDB, 0x66, 0x15, 0x4C, 0x21, 0x8E, 0xF5, 0x5B, 0x78, 0x65, 0x29, 0x7C, 0xEF, 0x5D, 0xE0, 0x7E, 0x4D, 0xF9, 0x35, 0xC6, 0x97, 0xEA, 0x4A, 0x56, 0xB5, 0xA2, 0x38, 0xAE, 0xF1, 0x50, 0x1A, 0xBE, 0xE8, 0xB1, 0x68, 0xBA, 0xB6, 0x4D, 0x67, 0x63, 0x52, 0x07, 0xBC, 0x4E, 0x68, 0x7C, 0x30, 0x75, 0x16, 0x97, 0x99, 0xD5, 0x8E, 0x14, 0xD9, 0x35, 0x80, 0x35, 0x48, 0xA3, 0x42, 0x3B, 0x60, 0xC0, 0xF7, 0xC5, 0x4E, 0x40, 0xEF, 0x1D, 0xA4, 0x2A, 0x43, 0xD3, 0xA9, 0xB5, 0x3D, 0x72, 0x4D, 0x51, 0x17, 0xFC, 0x92, 0x2F, 0xAC, 
			0xC8, 0x81, 0xE1, 0x01, 0x25, 0xBE, 0x89, 0xA9, 0x13, 0x9B, 0xE6, 0xBF, 0x60, 0x9E, 0x43, 0x68, 0x65, 0x34, 0x7A, 0x9C, 0x01, 0x9F, 0xA5, 0x32, 0xFC, 0x06, 0x38, 0x93, 0x4F, 0x15, 0x35, 0x42, 0xAB, 0xB0, 0x36, 0x67, 0x06, 0x4F, 0x2C, 0x70, 0x64, 0x41, 0x31, 0x20, 0x90, 0xA6, 0x3B, 0xC9, 0x99, 0xD8, 0x47, 0x42, 0x64, 0xB6, 0x2B, 0x08, 0xD3, 0x0E, 0x41, 0x19, 0x77, 0xF3, 0x5D, 0x56, 0x05, 0xF2, 0xBC, 0xF9, 0x9A, 0x92, 0x43, 0xD9, 0x18, 0x83, 0x90, 0x13, 0xD8, 0xA1, 0x42, 0x2A, 0x18, 0x2D, 0xD8, 0x1D, 0xE8, 0x50, 0xC5, 0xE8, 0x6F, 0x4F, 0x05, 0x45, 0x74, 0x06, 0x2A, 0x8B, 0x24, 0x33, 0xC0, 0xAA, 
			0xAA, 0x84, 0x8A, 0xE2, 0xE8, 0xB0, 0x7E, 0x2D, 0xBD, 0x0C, 0x20, 0xD1, 0x44, 0xAA, 0xCA, 0xC4, 0x83, 0x8C, 0x08, 0xA3, 0x17, 0x36, 0xA1, 0xA1, 0xC2, 0x04, 0xA7, 0x06, 0xCB, 0xB7, 0xF2, 0x64, 0x28, 0x0C, 0xC4, 0x91, 0x0B, 0xDF, 0x93, 0xCB, 0xBE, 0x85, 0x07, 0x11, 0xBB, 0xD8, 0x8A, 0xB1, 0xAB, 0xDC, 0x91, 0x02, 0xDE, 0x4F, 0xE5, 0x6E, 0xC7, 0x96, 0xAB, 0x7E, 0x4A, 0xAA, 0xCF, 0x05, 0x46, 0xE2, 0xB3, 0x52, 0xCD, 0x93, 0x7E, 0xAE, 0xB1, 0x40, 0x61, 0x7E, 0xCB, 0x43, 0x7F, 0xF4, 0x32, 0x8C, 0xA5, 0x0D, 0x52, 0xF7, 0x7A, 0x76, 0xBA, 0x05, 0x14, 0x65, 0xAD, 0x36, 0x85, 0x46, 0x15, 0x00, 0x01, 0xD7, 
			0x04, 0xA3, 0xD3, 0x1A, 0xAE, 0x59, 0xEF, 0x6E, 0xBE, 0x39, 0xDF, 0x0D, 0x78, 0xEF, 0x6F, 0x14, 0x02, 0xEC, 0x04, 0xB9, 0xE7, 0x15, 0x54, 0x51, 0x83, 0x75, 0xE2, 0x06, 0x1F, 0x07, 0xD3, 0x82, 0xCB, 0x01, 0x03, 0xE5, 0x43, 0xAC, 0x62, 0x66, 0xF7, 0xCF, 0x74, 0x1B, 0xCD, 0x30, 0x37, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x84, 0xA8, 0x88, 0x5F, 0xF6, 0x8E, 0xEC, 0x49, 0x94, 0x28, 0xDD, 0xC1, 0xA3, 0xCB, 0xBD, 0x73, 0x4A, 0x76, 0x0E, 0x6B, 0x04, 0x14, 0x7B, 0x11, 0xA6, 0xD2, 0x27, 0x3F, 0x96, 0xC9, 0xA7, 0xEF, 0x06, 0x6D, 0x03, 0xF9, 0xEA, 0x04, 0x2C, 0xC7, 
			0xF7, 0x11 };

		static public byte[] farscape_strong_pfx = { 0x30, 0x82, 0x06, 0xA7, 0x02, 0x01, 0x03, 0x30, 0x82, 0x06, 0x63, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x06, 0x54, 0x04, 0x82, 0x06, 0x50, 0x30, 0x82, 0x06, 0x4C, 0x30, 0x82, 0x03, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x03, 0x7E, 0x04, 0x82, 0x03, 0x7A, 0x30, 0x82, 0x03, 0x76, 0x30, 0x82, 0x03, 0x72, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xB6, 0x30, 0x82, 0x02, 0xB2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 
			0x0E, 0x04, 0x08, 0x21, 0x53, 0x51, 0xD2, 0xB9, 0x79, 0xA4, 0x4F, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x02, 0x90, 0xA2, 0xBA, 0x47, 0x19, 0xE3, 0x35, 0x0B, 0xA1, 0x71, 0x60, 0x65, 0x1A, 0xB0, 0x94, 0xF2, 0xF1, 0xDE, 0x8E, 0xA4, 0x59, 0xF5, 0x07, 0x1B, 0xDF, 0xD2, 0x9C, 0xF4, 0xA2, 0x5C, 0x8C, 0xA7, 0x3F, 0x7E, 0xD3, 0x93, 0x1B, 0x87, 0xA8, 0x1A, 0xA0, 0xDD, 0xF4, 0x0B, 0x76, 0x30, 0xDF, 0xE5, 0x56, 0xAE, 0x26, 0xF7, 0x6C, 0x72, 0x0A, 0x41, 0x0E, 0xD7, 0x42, 0xC3, 0x99, 0x8D, 0x8B, 0xC2, 0x18, 0xBE, 0x30, 0x12, 0xED, 0x20, 0xD3, 0xB3, 0xAF, 0xCD, 0xBE, 0x62, 0xED, 0x6F, 0x55, 0x79, 0x33, 0xCD, 
			0x8F, 0x2C, 0x1E, 0x1C, 0xB8, 0xDC, 0x1C, 0x4D, 0x45, 0xCE, 0xE6, 0x1E, 0x81, 0x46, 0xC1, 0x93, 0x1B, 0x7A, 0x41, 0x19, 0x82, 0xED, 0xBF, 0x8F, 0x0F, 0xB1, 0x39, 0x50, 0x58, 0xA2, 0xD2, 0xFB, 0xE6, 0x9A, 0x86, 0x68, 0x2C, 0x58, 0xF9, 0xB3, 0x7C, 0xAC, 0xCC, 0x02, 0xB0, 0x70, 0xC2, 0x5D, 0x0B, 0x7F, 0xC0, 0xA7, 0x60, 0x66, 0x41, 0xBA, 0x4F, 0xE6, 0x89, 0x16, 0x5C, 0x0D, 0x4B, 0x4F, 0x43, 0xF5, 0xFD, 0x5E, 0x22, 0x93, 0x4B, 0x34, 0xC3, 0xEC, 0xA9, 0xCF, 0x92, 0x6F, 0x0E, 0xD6, 0x01, 0x21, 0x48, 0xF4, 0x35, 0xF2, 0xA0, 0xF9, 0x84, 0xD4, 0x30, 0xE0, 0x69, 0xD2, 0xB2, 0x03, 0x3F, 0x3A, 0x5E, 0xFA, 
			0x06, 0xA2, 0x30, 0x1B, 0x93, 0xAC, 0x0D, 0x5D, 0x9E, 0xFA, 0x49, 0x29, 0x82, 0xE9, 0x91, 0x40, 0x87, 0x52, 0xF1, 0xED, 0xC3, 0x00, 0x1F, 0x00, 0x54, 0x9F, 0xB6, 0xC7, 0xDE, 0xF4, 0xFB, 0xCF, 0xE7, 0x9B, 0x40, 0x8B, 0x51, 0xEF, 0xFD, 0x33, 0x1C, 0xD9, 0x64, 0x19, 0x45, 0x89, 0x6C, 0x46, 0xA1, 0x9B, 0xA9, 0x93, 0xFE, 0xF8, 0x4D, 0x20, 0x63, 0x34, 0xFB, 0x1B, 0xB9, 0xC8, 0xFE, 0xD4, 0x63, 0xD1, 0x03, 0x57, 0x63, 0xC2, 0xEA, 0xC2, 0xA7, 0x9A, 0x03, 0xEB, 0xC0, 0xF1, 0xAF, 0xB8, 0xD7, 0x37, 0x76, 0x0C, 0xD3, 0x98, 0x21, 0xD2, 0x84, 0x11, 0xD6, 0xBF, 0x29, 0xC8, 0x03, 0xA1, 0xAA, 0xCB, 0xA6, 0x51, 
			0xF5, 0xBB, 0xA8, 0xFA, 0x43, 0xFB, 0x59, 0x51, 0x41, 0x1D, 0x2F, 0xF3, 0xFC, 0xF7, 0xA2, 0x4C, 0xEC, 0x47, 0x20, 0x14, 0xF3, 0x46, 0x8B, 0x41, 0x5E, 0x65, 0x2F, 0x18, 0x99, 0x07, 0x23, 0x6B, 0xEA, 0x55, 0x16, 0xE3, 0xA8, 0xB7, 0x31, 0x5C, 0x23, 0xF3, 0xD4, 0x1E, 0xC3, 0xB6, 0xF8, 0x53, 0x26, 0x7D, 0x42, 0x2D, 0x3E, 0xC2, 0xAE, 0x9F, 0x01, 0x83, 0x90, 0x0D, 0xA6, 0xB0, 0x2D, 0xBD, 0x86, 0x31, 0x5A, 0x15, 0x07, 0x6F, 0xA6, 0xFC, 0x35, 0x30, 0x6A, 0xEF, 0xF6, 0xC1, 0xEB, 0x18, 0x01, 0xE9, 0xE7, 0xAA, 0x87, 0x54, 0x4C, 0xAE, 0x98, 0x67, 0xDB, 0xDF, 0xFF, 0x4E, 0xA5, 0xA9, 0xA4, 0x05, 0x11, 0xE9, 
			0xA4, 0x1D, 0xB2, 0xB1, 0xD3, 0xF6, 0x77, 0xB6, 0xB5, 0x01, 0xC3, 0x3B, 0xAF, 0x6A, 0xA1, 0x60, 0xB9, 0x14, 0x62, 0x5E, 0x2D, 0x70, 0x25, 0xDF, 0xD3, 0x21, 0x02, 0x3C, 0xD7, 0xF1, 0xF6, 0x0E, 0xD9, 0x4D, 0x59, 0x1A, 0x41, 0x2E, 0x82, 0x28, 0x5C, 0x12, 0x26, 0x68, 0x77, 0xE0, 0x46, 0xC1, 0x0B, 0x9F, 0x15, 0x75, 0x87, 0xD7, 0x87, 0x3A, 0xF6, 0xB4, 0x57, 0x4B, 0x2C, 0x66, 0xD2, 0xCF, 0x47, 0x28, 0x31, 0x8A, 0xDF, 0x54, 0xC5, 0x16, 0x58, 0x23, 0x4F, 0x9E, 0x8D, 0x31, 0xFC, 0x9C, 0xF5, 0x07, 0x03, 0x0F, 0x63, 0xBD, 0xD7, 0x38, 0x65, 0x85, 0x7B, 0xB1, 0xBC, 0x19, 0x3C, 0xEF, 0x41, 0x55, 0xA6, 0x0D, 
			0x50, 0x61, 0xB6, 0xA5, 0x9F, 0xF8, 0xD6, 0x15, 0xBF, 0x40, 0x44, 0x2E, 0xD5, 0x12, 0xAA, 0x29, 0xFE, 0x8A, 0x27, 0x68, 0xC4, 0x83, 0xD5, 0x75, 0x78, 0xF7, 0x38, 0x8F, 0x0D, 0xD3, 0xC9, 0x25, 0xAC, 0xF5, 0x3E, 0x7B, 0x11, 0xCB, 0x45, 0xE0, 0x4E, 0x6A, 0x99, 0xD9, 0x24, 0xBD, 0x68, 0x59, 0x02, 0xF9, 0x0D, 0x32, 0x99, 0x87, 0xEA, 0xFA, 0x4D, 0x73, 0x72, 0x44, 0x10, 0x1B, 0xEC, 0x38, 0x04, 0xD4, 0xCD, 0x13, 0x98, 0x5F, 0x0A, 0x3F, 0x76, 0x80, 0x1E, 0x30, 0x89, 0xFF, 0x5D, 0x03, 0x38, 0x1C, 0x25, 0x9E, 0x79, 0x0A, 0xA8, 0x08, 0xAE, 0xAE, 0x28, 0x7A, 0x74, 0x68, 0x60, 0x13, 0x97, 0x48, 0x4C, 0xFA, 
			0xB3, 0x63, 0x3A, 0x66, 0xD0, 0xAB, 0x42, 0x35, 0x9B, 0xE6, 0x9D, 0x5D, 0xED, 0x05, 0xC5, 0x29, 0x11, 0xB2, 0x36, 0x21, 0x21, 0x86, 0x16, 0xFD, 0x81, 0xF6, 0x5D, 0x26, 0x75, 0xB2, 0x74, 0xD4, 0xF6, 0x59, 0x62, 0x7B, 0xC2, 0x6D, 0xB9, 0xF0, 0xA6, 0x5A, 0x47, 0xEC, 0x55, 0xEA, 0x35, 0xE0, 0xCE, 0x68, 0x63, 0x88, 0x2D, 0x9A, 0xCC, 0xDC, 0x0E, 0x02, 0xAB, 0x69, 0xFE, 0x22, 0xEC, 0xF5, 0xED, 0x36, 0x7B, 0xE9, 0xC2, 0xA6, 0xBF, 0x0C, 0x1C, 0x19, 0xE7, 0x31, 0x81, 0xA8, 0x30, 0x0D, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x02, 0x31, 0x00, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x17, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x0A, 0x1E, 0x08, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x6F, 0x30, 0x69, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5C, 0x1E, 0x5A, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x52, 0x00, 0x53, 0x00, 0x41, 0x00, 0x20, 0x00, 0x53, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x6C, 
			0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x30, 0x82, 0x02, 0xB7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x02, 0xA8, 0x30, 0x82, 0x02, 0xA4, 0x02, 0x01, 0x00, 0x30, 0x82, 0x02, 0x9D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 
			0x06, 0x30, 0x0E, 0x04, 0x08, 0x02, 0x77, 0x79, 0xCA, 0x9F, 0x4E, 0x06, 0xE3, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x02, 0x70, 0x82, 0xE1, 0x66, 0x48, 0xDB, 0x24, 0x9E, 0x33, 0x70, 0x43, 0xFB, 0x6D, 0xD0, 0x47, 0x90, 0xF6, 0xEF, 0xAD, 0x61, 0x28, 0xBF, 0x71, 0x9F, 0x63, 0x2A, 0x69, 0x6C, 0x04, 0x14, 0x34, 0x8A, 0x92, 0xB6, 0x7E, 0x67, 0x50, 0x82, 0x6D, 0x16, 0x8B, 0xB2, 0x18, 0xA4, 0x74, 0x7C, 0xC4, 0x97, 0x50, 0xCE, 0x0B, 0xDB, 0x76, 0xFF, 0xCB, 0x8F, 0x21, 0x4F, 0x50, 0x52, 0x41, 0x0C, 0xA0, 0x98, 0xFB, 0xA8, 0x7F, 0xC0, 0xB4, 0xE3, 0x81, 0x37, 0x12, 0x55, 0x53, 0x5C, 0x3E, 0x95, 0x53, 0x40, 
			0x39, 0xAB, 0xD6, 0x5A, 0xBA, 0xB5, 0x87, 0xCF, 0x60, 0x2A, 0x07, 0x2E, 0xAC, 0x56, 0xC0, 0xD1, 0x75, 0xE2, 0xFC, 0xE3, 0x24, 0xDA, 0x32, 0xED, 0x11, 0xC9, 0x53, 0xED, 0x54, 0xB4, 0xE4, 0x36, 0x1F, 0x72, 0x8B, 0xA2, 0xB1, 0x8D, 0x4B, 0x4C, 0x3F, 0x75, 0x4C, 0x2F, 0xE9, 0x78, 0x97, 0xFC, 0xBA, 0x77, 0x68, 0xE4, 0x65, 0x22, 0x67, 0xE5, 0x4D, 0xE9, 0x6A, 0x63, 0x0C, 0x89, 0x91, 0x12, 0xD5, 0x3B, 0x0D, 0xF4, 0x16, 0xA7, 0xE8, 0x57, 0xA8, 0x88, 0xF4, 0x48, 0x95, 0x71, 0x91, 0xAC, 0x69, 0x67, 0xEB, 0xF0, 0xF3, 0x8C, 0xFB, 0x35, 0x4F, 0x0F, 0xAD, 0x8B, 0xFE, 0x8A, 0xCE, 0xE2, 0x75, 0xDF, 0x63, 0x38, 
			0xB2, 0xD0, 0xAD, 0x71, 0x5F, 0x97, 0x8B, 0x0C, 0xA7, 0x43, 0xC6, 0x62, 0xC0, 0x60, 0x0F, 0xE6, 0x6A, 0xE9, 0x23, 0x47, 0xD2, 0xC4, 0x1D, 0x90, 0x75, 0x17, 0x14, 0xF3, 0x1B, 0xB9, 0x3A, 0x11, 0xA6, 0x04, 0x52, 0x2B, 0x6B, 0xCB, 0x01, 0xE4, 0x62, 0xB8, 0xD7, 0xE3, 0xB7, 0x1B, 0x6B, 0xF3, 0x20, 0x37, 0x24, 0x87, 0xFB, 0xF0, 0x46, 0x87, 0xC4, 0xAB, 0x88, 0xAC, 0x53, 0x37, 0xD8, 0x87, 0x0E, 0xBB, 0x39, 0x91, 0x1A, 0x8C, 0x90, 0xF8, 0xB4, 0x2A, 0xE2, 0xA9, 0x25, 0xAD, 0xE9, 0x8A, 0x0E, 0xEA, 0x4B, 0x49, 0xC2, 0xE9, 0x5B, 0x5A, 0x3C, 0xAC, 0xE2, 0xE9, 0x3B, 0x27, 0xE6, 0x60, 0x00, 0x49, 0x62, 0xAF, 
			0xED, 0x41, 0x7A, 0x8E, 0x95, 0xD2, 0xC2, 0x27, 0x04, 0x9F, 0xE9, 0xEE, 0x50, 0xB5, 0xDF, 0x17, 0x59, 0x46, 0x83, 0xED, 0xB7, 0xFB, 0xCE, 0xE4, 0x35, 0x6E, 0x85, 0x66, 0xA4, 0xF9, 0x11, 0xB9, 0x33, 0xAE, 0x84, 0x9B, 0x73, 0xCC, 0x5E, 0x1A, 0xBE, 0xC6, 0xF6, 0x71, 0x41, 0x07, 0x3F, 0xAF, 0x24, 0xA7, 0x37, 0x12, 0x65, 0x30, 0x87, 0x23, 0xAB, 0x6D, 0xB1, 0xF1, 0xE4, 0x71, 0xEA, 0x87, 0xF4, 0x9E, 0xC9, 0xCA, 0x4E, 0x34, 0xA4, 0x60, 0x80, 0xE5, 0x5E, 0x4A, 0xDF, 0x2B, 0xA5, 0x12, 0x5E, 0x7A, 0x76, 0x7E, 0x82, 0x8B, 0xF7, 0x55, 0x72, 0x79, 0xDC, 0x2A, 0x4C, 0xC1, 0x2B, 0xCA, 0xA5, 0x9A, 0x2D, 0x98, 
			0x6C, 0x51, 0x00, 0x95, 0x1F, 0x4C, 0x04, 0x6A, 0x44, 0x59, 0x7C, 0x5F, 0xE4, 0xA8, 0xAF, 0x66, 0x32, 0x29, 0x1D, 0x07, 0xD4, 0xAE, 0xC1, 0x9E, 0x45, 0x35, 0x6D, 0xE9, 0x7A, 0x92, 0x22, 0x4B, 0x0D, 0x4A, 0xA6, 0x53, 0x17, 0x31, 0x76, 0x1F, 0x60, 0x32, 0x84, 0x18, 0x6B, 0x90, 0xD3, 0x77, 0x9B, 0xF1, 0xF0, 0x95, 0x4D, 0x23, 0x95, 0x90, 0xF5, 0xDD, 0xFA, 0xC1, 0x3F, 0xB3, 0xDD, 0x5E, 0x54, 0xFC, 0x03, 0xFD, 0xDA, 0xC8, 0xEF, 0x78, 0x2E, 0x5F, 0xFF, 0x1D, 0xDB, 0xB7, 0xF8, 0xBF, 0x1A, 0x2A, 0x98, 0xD0, 0x06, 0x04, 0x9B, 0xE0, 0xFD, 0xFB, 0xA2, 0x2E, 0x83, 0x67, 0x38, 0x77, 0x9E, 0x2D, 0x7C, 0xB4, 
			0x95, 0xF2, 0x5F, 0xF8, 0x3B, 0x62, 0x41, 0x9C, 0xAA, 0xAA, 0xAB, 0xEB, 0x46, 0x78, 0x5D, 0xF6, 0x88, 0x6C, 0xED, 0x0F, 0x76, 0x3B, 0xD6, 0xFD, 0x13, 0xCE, 0x68, 0xDE, 0x0A, 0x33, 0xA6, 0x68, 0xB5, 0xCA, 0x64, 0x90, 0x16, 0x00, 0xCE, 0x97, 0xC5, 0xED, 0x57, 0xE1, 0x1D, 0xF2, 0xD3, 0xDC, 0xA7, 0x1B, 0xC3, 0xEE, 0x07, 0xBE, 0xE8, 0xC3, 0xE5, 0x77, 0x10, 0x00, 0x48, 0x7D, 0x4F, 0xEC, 0x3B, 0xEC, 0xEF, 0x0F, 0x86, 0xD6, 0x5E, 0xF0, 0x32, 0xE4, 0x3D, 0x4E, 0xB5, 0x48, 0xA7, 0x0E, 0x2C, 0xCA, 0x1C, 0x9E, 0xDA, 0x6F, 0xDD, 0x53, 0x12, 0x0A, 0xBF, 0x65, 0x61, 0xDD, 0xB3, 0xAE, 0x3E, 0xAA, 0x59, 0x8F, 
			0xFC, 0xCD, 0x0E, 0xD0, 0x7D, 0xB0, 0x49, 0x5C, 0x85, 0xF4, 0xEF, 0x77, 0xDA, 0x39, 0x9E, 0x21, 0xCE, 0x9B, 0x26, 0x81, 0x6C, 0x13, 0x09, 0x54, 0xBF, 0x2D, 0x20, 0xF6, 0x57, 0x74, 0x94, 0xE0, 0x99, 0x81, 0x08, 0x9E, 0x72, 0xDB, 0x95, 0xAC, 0xB3, 0x4E, 0x08, 0x66, 0x7C, 0x30, 0x3B, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0x08, 0x95, 0xCA, 0x53, 0x3F, 0xBA, 0xFC, 0x96, 0xB1, 0x48, 0x21, 0x06, 0xA4, 0x9E, 0x5A, 0xD6, 0x23, 0x60, 0x4F, 0x3C, 0x04, 0x14, 0x24, 0x98, 0x3B, 0xFC, 0x6E, 0x4B, 0x07, 0xB7, 0xFA, 0xC1, 0xFE, 0xD3, 0x15, 0xBB, 0x7B, 0x70, 0xA7, 0x97, 
			0xBC, 0x0A, 0x02, 0x02, 0x07, 0xD0 };

		static public byte[] farscape_strong_path_pfx = { 0x30, 0x82, 0x0B, 0x57, 0x02, 0x01, 0x03, 0x30, 0x82, 0x0B, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x0B, 0x04, 0x04, 0x82, 0x0B, 0x00, 0x30, 0x82, 0x0A, 0xFC, 0x30, 0x82, 0x03, 0x8D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x03, 0x7E, 0x04, 0x82, 0x03, 0x7A, 0x30, 0x82, 0x03, 0x76, 0x30, 0x82, 0x03, 0x72, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xB6, 0x30, 0x82, 0x02, 0xB2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 
			0x0E, 0x04, 0x08, 0x32, 0xC5, 0xBA, 0x13, 0xE8, 0x8D, 0xE0, 0x25, 0x02, 0x02, 0x07, 0xD0, 0x04, 0x82, 0x02, 0x90, 0x3C, 0xD2, 0x8F, 0x0F, 0x52, 0x6A, 0x97, 0xA2, 0x5D, 0xDC, 0xFC, 0x82, 0x3D, 0x95, 0xE1, 0x19, 0x02, 0x8E, 0x64, 0xC5, 0x7C, 0x64, 0xFF, 0xA3, 0x4E, 0x00, 0x5B, 0xC0, 0x3C, 0x7C, 0x53, 0xEA, 0xEA, 0xF9, 0xC8, 0xF6, 0xD5, 0xDF, 0x62, 0x94, 0x39, 0xA8, 0xF9, 0xAF, 0x46, 0xAE, 0x40, 0xF8, 0xBE, 0x5E, 0xF5, 0xAB, 0x7A, 0xB2, 0x5B, 0x9F, 0x2D, 0x6E, 0xBA, 0xF9, 0xBE, 0x99, 0x32, 0x4C, 0xBF, 0xC0, 0x2C, 0xFB, 0xC6, 0xBD, 0x24, 0x6E, 0x1B, 0x69, 0xF8, 0xB8, 0xA2, 0x3F, 0x0F, 0x7F, 0x03, 
			0x60, 0xC6, 0xA8, 0x10, 0x80, 0x7A, 0xEA, 0x16, 0xE2, 0x2E, 0xBA, 0x60, 0x0A, 0x76, 0x9A, 0x60, 0x5A, 0x50, 0x59, 0x06, 0xD6, 0x76, 0x2C, 0x73, 0x7B, 0x50, 0x6F, 0x55, 0x6E, 0x86, 0xED, 0xC5, 0x35, 0x2C, 0xEF, 0x9F, 0xC8, 0x81, 0xE5, 0xFF, 0xBE, 0xDD, 0x48, 0x20, 0x35, 0x1B, 0x9B, 0xCF, 0x77, 0x13, 0x21, 0x9D, 0xD6, 0x19, 0xFC, 0x08, 0x94, 0xB6, 0xB3, 0xF5, 0x03, 0xAE, 0x8F, 0x10, 0x14, 0x9C, 0x7E, 0x86, 0x43, 0x1D, 0x3D, 0x9D, 0xEA, 0x3A, 0xDD, 0x62, 0x53, 0xFE, 0x92, 0x1F, 0xD1, 0x9B, 0x0D, 0x18, 0x0E, 0xCD, 0x5F, 0xF7, 0xE9, 0x92, 0x5F, 0xFE, 0xF2, 0x14, 0x20, 0x46, 0x9C, 0xED, 0x93, 0x0B, 
			0x65, 0xE3, 0xDE, 0x41, 0x53, 0x55, 0x83, 0xEE, 0x83, 0x59, 0x61, 0x74, 0x96, 0x67, 0xDB, 0x26, 0x22, 0x0B, 0x19, 0x01, 0x53, 0xF6, 0xDC, 0x13, 0xD9, 0xF5, 0xCD, 0xB3, 0x98, 0xA0, 0x52, 0x65, 0x69, 0x7B, 0xED, 0x76, 0xED, 0xFA, 0xE0, 0xAD, 0x2F, 0xDC, 0xCA, 0x0D, 0xBA, 0x25, 0xBD, 0x13, 0x5D, 0xCA, 0xFC, 0x4A, 0x22, 0xD9, 0x1D, 0xAC, 0x7F, 0x25, 0x35, 0x0D, 0xF7, 0xB0, 0xD9, 0x36, 0x9F, 0x4F, 0x0D, 0x7C, 0x92, 0x93, 0xD0, 0xA5, 0x3F, 0x64, 0xC1, 0x26, 0x41, 0x73, 0xDC, 0x3E, 0x01, 0xCA, 0xB0, 0xD8, 0xF6, 0x6D, 0x83, 0x08, 0xA3, 0x3D, 0xCE, 0xEF, 0x29, 0x6B, 0x25, 0x3D, 0x65, 0xD9, 0xB0, 0xA3, 
			0xA4, 0xDC, 0xC8, 0x21, 0xDF, 0x5E, 0xE8, 0x5B, 0x5D, 0xCF, 0x41, 0x81, 0x28, 0xEE, 0x80, 0xDF, 0x87, 0x0B, 0x06, 0x09, 0x46, 0x61, 0xDC, 0x99, 0xF8, 0xC6, 0xD7, 0xA8, 0x4C, 0x59, 0x37, 0xB3, 0x54, 0x82, 0xE7, 0x4F, 0x36, 0x5D, 0x58, 0x8B, 0x26, 0xE8, 0xF7, 0x76, 0x87, 0x3A, 0x43, 0x61, 0x8B, 0x93, 0xAD, 0xDE, 0x35, 0xED, 0xC5, 0x5B, 0xEC, 0x49, 0x9B, 0xA3, 0x5A, 0xC7, 0x94, 0x50, 0x0E, 0x06, 0x2F, 0xC2, 0xF2, 0x28, 0x71, 0x52, 0xE1, 0x4B, 0x24, 0x97, 0x62, 0x2A, 0x28, 0x25, 0xC5, 0x43, 0x35, 0xF1, 0x9C, 0xDF, 0xFD, 0xAD, 0x7C, 0x7D, 0xED, 0x6F, 0xCC, 0x96, 0xBF, 0x93, 0x97, 0xBA, 0x2C, 0x44, 
			0xB7, 0xCD, 0x9C, 0x6E, 0x0D, 0x29, 0x7C, 0x19, 0xC9, 0xA0, 0x40, 0x94, 0x35, 0x66, 0xB6, 0x4C, 0xFB, 0xA8, 0x91, 0xC1, 0x89, 0x31, 0x6E, 0x76, 0x03, 0x94, 0x65, 0xF1, 0xA3, 0x2A, 0x1A, 0xD6, 0x99, 0xB9, 0xFF, 0x2E, 0xCF, 0xC3, 0xE7, 0x80, 0x28, 0x7B, 0xD5, 0x18, 0xA6, 0xD1, 0xEC, 0x1F, 0x28, 0x65, 0xB5, 0xB7, 0x32, 0xC9, 0x3A, 0x22, 0x56, 0x87, 0x61, 0x5C, 0xB0, 0xEC, 0x87, 0xA6, 0xA5, 0x23, 0x14, 0xBA, 0x0E, 0xD1, 0xE7, 0xA2, 0x74, 0x94, 0xC9, 0x74, 0x65, 0x9C, 0x5D, 0xAF, 0x5B, 0xDD, 0x3A, 0x8B, 0x2E, 0x44, 0xDF, 0x8C, 0x7F, 0x10, 0x83, 0x3C, 0xFC, 0x2C, 0x48, 0x4D, 0xF0, 0x20, 0xB8, 0xF8, 
			0x63, 0x37, 0x83, 0xB1, 0xDB, 0xA3, 0x51, 0x75, 0xF3, 0xA6, 0x77, 0xAD, 0x4A, 0xAF, 0xF6, 0x0F, 0x57, 0xAB, 0x18, 0x68, 0xD8, 0x42, 0xB1, 0xC3, 0x4D, 0xE9, 0xAA, 0x1A, 0xD5, 0xB9, 0xBD, 0xEB, 0xDB, 0x5B, 0x04, 0x95, 0xC2, 0x4E, 0xE2, 0x74, 0x99, 0x6E, 0x42, 0xF0, 0xCA, 0xC5, 0xA1, 0x71, 0x90, 0xFF, 0xF7, 0x08, 0x1E, 0xDA, 0xD7, 0x53, 0x33, 0x12, 0x0A, 0xC9, 0x10, 0x04, 0x60, 0xDA, 0xC2, 0xC8, 0x73, 0x9C, 0x10, 0x03, 0x20, 0x5A, 0xC2, 0xC5, 0x2E, 0x83, 0x88, 0x72, 0x25, 0xA3, 0x98, 0xC0, 0x35, 0x56, 0x16, 0x7B, 0x8F, 0x17, 0x92, 0x72, 0xF8, 0x8A, 0x4C, 0x65, 0x79, 0x7A, 0xA5, 0xAF, 0xCB, 0x03, 
			0x0A, 0xAA, 0xBC, 0xBB, 0xF8, 0x30, 0x16, 0xBA, 0x1D, 0x42, 0x6F, 0xF8, 0xAA, 0xC4, 0x3A, 0x89, 0x29, 0x22, 0x7F, 0x22, 0x1F, 0x87, 0xFE, 0x34, 0x06, 0x6C, 0x0E, 0x13, 0xD0, 0x43, 0x43, 0x59, 0x4F, 0x59, 0xAA, 0x2B, 0x1E, 0xDA, 0x96, 0x06, 0x38, 0x3E, 0x18, 0x97, 0xCF, 0x1D, 0xFE, 0x43, 0xA7, 0x8C, 0xB1, 0x0D, 0x40, 0x9B, 0xC6, 0xDD, 0x79, 0x97, 0xD0, 0x0B, 0x67, 0x0E, 0x2C, 0x2D, 0xBE, 0x4F, 0x9F, 0xBC, 0x6D, 0xD1, 0xAC, 0xA3, 0xB6, 0x38, 0x53, 0x31, 0x81, 0xA8, 0x30, 0x0D, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x02, 0x31, 0x00, 0x30, 0x13, 0x06, 0x09, 0x2A, 0x86, 0x48, 
			0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x06, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00, 0x30, 0x17, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x14, 0x31, 0x0A, 0x1E, 0x08, 0x00, 0x4D, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x6F, 0x30, 0x69, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x04, 0x01, 0x82, 0x37, 0x11, 0x01, 0x31, 0x5C, 0x1E, 0x5A, 0x00, 0x4D, 0x00, 0x69, 0x00, 0x63, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x73, 0x00, 0x6F, 0x00, 0x66, 0x00, 0x74, 0x00, 0x20, 0x00, 0x52, 0x00, 0x53, 0x00, 0x41, 0x00, 0x20, 0x00, 0x53, 0x00, 0x43, 0x00, 0x68, 0x00, 0x61, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x65, 0x00, 0x6C, 
			0x00, 0x20, 0x00, 0x43, 0x00, 0x72, 0x00, 0x79, 0x00, 0x70, 0x00, 0x74, 0x00, 0x6F, 0x00, 0x67, 0x00, 0x72, 0x00, 0x61, 0x00, 0x70, 0x00, 0x68, 0x00, 0x69, 0x00, 0x63, 0x00, 0x20, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6F, 0x00, 0x76, 0x00, 0x69, 0x00, 0x64, 0x00, 0x65, 0x00, 0x72, 0x30, 0x82, 0x07, 0x67, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x07, 0x58, 0x30, 0x82, 0x07, 0x54, 0x02, 0x01, 0x00, 0x30, 0x82, 0x07, 0x4D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 
			0x06, 0x30, 0x0E, 0x04, 0x08, 0x4E, 0xEC, 0x16, 0x2C, 0x55, 0x4B, 0x1B, 0x3E, 0x02, 0x02, 0x07, 0xD0, 0x80, 0x82, 0x07, 0x20, 0x8A, 0xE2, 0x16, 0x78, 0xEB, 0x9F, 0xF6, 0x25, 0x67, 0x15, 0x21, 0x01, 0x86, 0xC3, 0x2E, 0x27, 0x02, 0xF4, 0x0B, 0x98, 0xD8, 0xF2, 0x44, 0xBB, 0x1A, 0xD4, 0xF2, 0xA6, 0xB8, 0x6B, 0x7B, 0x05, 0xD4, 0x57, 0x3C, 0x77, 0xD5, 0x0C, 0xDC, 0x6B, 0x1A, 0xC4, 0xEA, 0x32, 0xFC, 0x28, 0x48, 0x67, 0xA2, 0xC2, 0x20, 0xCA, 0x58, 0x95, 0x45, 0xAA, 0xE1, 0x69, 0x4B, 0x7D, 0xFD, 0x33, 0x43, 0xF3, 0xD2, 0xDF, 0xEA, 0xF3, 0xAD, 0x7D, 0x8F, 0x05, 0x5A, 0xAB, 0x7B, 0x6E, 0x6C, 0x6F, 0xD7, 
			0x49, 0xFC, 0x16, 0x1F, 0x30, 0x5D, 0x68, 0xB9, 0x78, 0x65, 0x12, 0x7C, 0x16, 0x14, 0x95, 0x3C, 0xA3, 0xE9, 0xEF, 0x56, 0x72, 0x07, 0x9B, 0x39, 0xA7, 0xA9, 0x52, 0x68, 0x47, 0x18, 0xED, 0x83, 0xC5, 0xFC, 0x4F, 0xC8, 0xFF, 0x86, 0xA5, 0x85, 0xBF, 0xBF, 0x38, 0xBA, 0x88, 0xA5, 0x91, 0x85, 0xE8, 0x68, 0x04, 0x71, 0x89, 0x8A, 0x0E, 0x33, 0x5A, 0x57, 0x65, 0xCC, 0x3A, 0x1D, 0xE8, 0x29, 0x1F, 0xF3, 0x5E, 0xAE, 0xBE, 0x94, 0x60, 0x79, 0x54, 0x40, 0xF6, 0x15, 0x32, 0xD6, 0x6C, 0xEC, 0x8D, 0x1A, 0x63, 0x98, 0x69, 0x6F, 0x93, 0xB2, 0x6C, 0x3E, 0xF3, 0x35, 0x42, 0x08, 0x2E, 0x7E, 0x44, 0x73, 0xC6, 0xE8, 
			0x74, 0x07, 0xBF, 0xD3, 0x75, 0xDE, 0x87, 0x93, 0x8D, 0x4C, 0x3B, 0xB8, 0x23, 0x91, 0x2C, 0x62, 0x99, 0xA8, 0xD6, 0xA6, 0x05, 0xB9, 0xE9, 0x8F, 0x9F, 0x86, 0xD0, 0xE0, 0xF5, 0xE6, 0x1C, 0x92, 0x8D, 0xC9, 0x7A, 0xBA, 0xF8, 0x05, 0x7C, 0x6F, 0xFB, 0x7F, 0x62, 0x4B, 0x8C, 0x9B, 0xC5, 0xDB, 0x24, 0xD0, 0x7D, 0xC6, 0xDF, 0xBB, 0x43, 0xB8, 0x31, 0x3C, 0x52, 0x69, 0xC3, 0xA9, 0x4B, 0x6C, 0xA5, 0x5D, 0xF0, 0x25, 0x90, 0x9B, 0xD8, 0xE4, 0xC2, 0x4C, 0x71, 0x68, 0x17, 0x79, 0x21, 0xB7, 0x14, 0x56, 0xC2, 0x31, 0xB5, 0xEF, 0x4D, 0x86, 0x83, 0x24, 0x78, 0x01, 0x6D, 0x41, 0x19, 0x5B, 0xD3, 0x78, 0xC0, 0xE7, 
			0xF4, 0xEE, 0x86, 0xEC, 0x4D, 0x19, 0xB4, 0x2E, 0x65, 0x4C, 0x47, 0xFC, 0x7D, 0xDF, 0x56, 0xE1, 0xC3, 0x65, 0xF2, 0x30, 0xB5, 0x13, 0x93, 0xAD, 0x31, 0x56, 0xF3, 0x77, 0x4D, 0x9B, 0x6A, 0xA6, 0xCC, 0xF0, 0x20, 0x34, 0x11, 0xE7, 0xBD, 0xB1, 0xAD, 0xB9, 0xCB, 0xF3, 0x48, 0x6B, 0xB9, 0xF6, 0xB1, 0x7F, 0x9B, 0x61, 0x4C, 0x09, 0x05, 0xC1, 0x8D, 0xA7, 0x2B, 0xF0, 0xE5, 0x6C, 0x7D, 0xEB, 0xE3, 0x83, 0x6B, 0xA0, 0x77, 0x98, 0x6C, 0x5D, 0x59, 0x5B, 0xE2, 0x69, 0xC6, 0x97, 0x15, 0x60, 0x7A, 0x69, 0x7F, 0xC2, 0xF6, 0xF6, 0xAD, 0x33, 0xAE, 0x7D, 0x06, 0xA1, 0xF4, 0x5B, 0xA4, 0x17, 0xC3, 0xA5, 0xB5, 0xFA, 
			0x60, 0xD1, 0x58, 0x30, 0x1F, 0x81, 0x15, 0x49, 0x05, 0x6D, 0x54, 0xD8, 0xE8, 0x9E, 0xBF, 0x61, 0xD2, 0xD0, 0x8A, 0x95, 0xBD, 0x1C, 0x05, 0x6B, 0x15, 0xDC, 0x29, 0x80, 0xB1, 0x91, 0x66, 0xCE, 0x57, 0xCE, 0xFD, 0x5A, 0x3F, 0x18, 0xB9, 0x87, 0x32, 0x92, 0x6E, 0xA3, 0x42, 0x20, 0xC4, 0x36, 0xBD, 0x7E, 0xE2, 0x38, 0xF3, 0xDD, 0x50, 0x00, 0x28, 0x8C, 0x78, 0x2C, 0x94, 0xEC, 0x0F, 0xFE, 0xC2, 0x6F, 0x4D, 0x09, 0xC6, 0xE0, 0xCD, 0x50, 0xC6, 0x3B, 0x1D, 0x81, 0x2C, 0xE5, 0xEA, 0xF8, 0x31, 0x17, 0xCC, 0x37, 0x09, 0xBC, 0x7F, 0x19, 0x46, 0x4D, 0x83, 0x4A, 0xB6, 0x6E, 0x02, 0x10, 0x03, 0xAF, 0xEF, 0xE4, 
			0x02, 0x4A, 0x11, 0xC6, 0x11, 0xA6, 0xFC, 0xC3, 0x0E, 0x62, 0xAB, 0x98, 0x71, 0x32, 0x86, 0xA6, 0x22, 0x1B, 0x5F, 0x2C, 0x18, 0x78, 0x0E, 0x21, 0xA5, 0x5C, 0xC4, 0x3D, 0x06, 0x9A, 0x1E, 0x03, 0xAA, 0x7A, 0x49, 0x04, 0x0D, 0x82, 0xAF, 0xDD, 0x02, 0x70, 0x2E, 0x33, 0x10, 0x6F, 0x6A, 0xBF, 0xE4, 0x2F, 0xAA, 0x54, 0x8A, 0x0F, 0xCC, 0x85, 0xE9, 0xD9, 0x7E, 0x43, 0xCF, 0xDC, 0x32, 0x35, 0xA8, 0xEC, 0x87, 0x3D, 0x08, 0xB1, 0x63, 0xE3, 0x48, 0xDC, 0xB9, 0xDB, 0x2C, 0xA6, 0x9F, 0xB9, 0x7D, 0x90, 0xCA, 0xD1, 0x03, 0x76, 0xE6, 0x6D, 0xAD, 0x51, 0x10, 0xED, 0xA1, 0x7E, 0x06, 0x72, 0xC2, 0x12, 0x93, 0x7E, 
			0x7A, 0xF0, 0x84, 0xFE, 0x1C, 0x2A, 0xB0, 0xF1, 0x13, 0x2F, 0x68, 0x2B, 0x66, 0xB8, 0xAD, 0x14, 0x28, 0x65, 0x85, 0xC4, 0x92, 0x0F, 0x10, 0x3F, 0x1A, 0xCD, 0x6D, 0x74, 0x39, 0x5E, 0x9D, 0x6F, 0x11, 0xD3, 0xB4, 0xDA, 0xB6, 0x1A, 0x1D, 0x73, 0x29, 0xF3, 0x4A, 0x4F, 0x77, 0x19, 0x53, 0x59, 0x38, 0xF5, 0x58, 0x77, 0xE5, 0x45, 0xBA, 0x03, 0xD4, 0x9C, 0x1B, 0x11, 0x9C, 0xA2, 0x91, 0x80, 0xC7, 0x2C, 0xEB, 0x0C, 0x8D, 0x7E, 0xA1, 0x94, 0x1B, 0x7B, 0x74, 0x0F, 0x21, 0xB5, 0xE5, 0xBA, 0xEA, 0x14, 0x65, 0xAA, 0xFB, 0x5F, 0x91, 0x7A, 0x73, 0xBB, 0x04, 0x4E, 0x74, 0xFE, 0x24, 0xDF, 0x63, 0x18, 0xDF, 0xC2, 
			0x74, 0x5F, 0x4C, 0x9C, 0x9D, 0x0C, 0x94, 0x58, 0x89, 0x3F, 0x77, 0x63, 0x03, 0x77, 0x9C, 0x6E, 0xDE, 0x01, 0x13, 0x62, 0xEF, 0xCF, 0x57, 0xAB, 0x15, 0x22, 0xB6, 0x40, 0xFF, 0x0A, 0xFC, 0x91, 0xB8, 0x52, 0xFA, 0xCC, 0x7C, 0xEE, 0xB8, 0xA3, 0x7C, 0x8B, 0x3C, 0x04, 0x2E, 0xAB, 0x00, 0x78, 0x95, 0xD5, 0x0B, 0xC0, 0xF1, 0x5D, 0x52, 0x25, 0x92, 0x6B, 0x99, 0x71, 0x2E, 0x2B, 0x3A, 0x15, 0x2A, 0x15, 0xE8, 0xAC, 0x79, 0x71, 0xAE, 0xC7, 0xDA, 0x7C, 0x9D, 0x7E, 0xD5, 0x75, 0x34, 0xA6, 0x76, 0x46, 0xB1, 0x87, 0x94, 0xAD, 0x1F, 0x75, 0x74, 0x69, 0xE7, 0x26, 0xD6, 0xB1, 0x32, 0xFE, 0x0A, 0xCA, 0x3C, 0x54, 
			0x7D, 0x24, 0x95, 0xE1, 0xFD, 0x37, 0xE6, 0x34, 0xA5, 0x8B, 0x42, 0x88, 0x71, 0x22, 0xFE, 0x94, 0x42, 0xD5, 0xF8, 0xEE, 0x1E, 0x57, 0x2A, 0xD4, 0xB7, 0xC8, 0x90, 0xA2, 0x4A, 0xE0, 0xB7, 0xB5, 0x37, 0x72, 0x59, 0xF5, 0xA4, 0x8D, 0x3C, 0xFE, 0x3B, 0xD2, 0x8F, 0xEA, 0xBB, 0x83, 0x77, 0x78, 0xDA, 0x6E, 0xF3, 0x35, 0x03, 0x2E, 0xF1, 0x95, 0x6E, 0x91, 0x25, 0x9B, 0x11, 0x35, 0xBE, 0x08, 0xBB, 0xCB, 0x5C, 0x34, 0x1F, 0x22, 0x02, 0xE3, 0x0E, 0x5E, 0xC4, 0xF8, 0xD1, 0x6C, 0xF9, 0x87, 0x67, 0x0B, 0x33, 0xBD, 0xD3, 0xF0, 0x25, 0x5C, 0x68, 0xD5, 0xD0, 0xA7, 0x4E, 0x2E, 0x8B, 0xB6, 0x45, 0xD9, 0x8A, 0x33, 
			0x80, 0x08, 0xBD, 0x8D, 0x17, 0xFD, 0x4C, 0x4C, 0xFD, 0x06, 0x85, 0x5A, 0x4A, 0xDF, 0x4C, 0xD7, 0x16, 0x78, 0xB0, 0x0F, 0xA9, 0x35, 0x4A, 0x71, 0x9F, 0x10, 0xE1, 0x26, 0x09, 0x03, 0x29, 0xE3, 0x11, 0x2A, 0xF4, 0x4F, 0x02, 0xBD, 0x29, 0x54, 0xA8, 0x8F, 0xFE, 0xC4, 0x98, 0xD4, 0x28, 0x86, 0x00, 0x37, 0xC9, 0x2C, 0xCF, 0xB6, 0xA6, 0x0B, 0x98, 0x22, 0xE6, 0xAA, 0x8A, 0x51, 0x45, 0xAF, 0xBB, 0x63, 0x25, 0x42, 0x7F, 0x3E, 0x8C, 0x34, 0x30, 0x86, 0x39, 0x9D, 0x58, 0xC1, 0xC0, 0x1F, 0xA8, 0xEE, 0x2A, 0x42, 0x4C, 0x0C, 0xCA, 0x62, 0xCA, 0xD1, 0xA6, 0x26, 0xA1, 0xB9, 0x3D, 0x6C, 0xDE, 0x72, 0x71, 0xC5, 
			0xAB, 0xE2, 0xD6, 0x67, 0x36, 0xDD, 0xD9, 0xFE, 0x32, 0x43, 0x3A, 0x33, 0x0E, 0x4C, 0x25, 0x5A, 0x25, 0x77, 0xFD, 0x0C, 0x7E, 0xE3, 0x8F, 0x9A, 0x12, 0x7F, 0x09, 0x15, 0x92, 0x5D, 0x21, 0xB8, 0x6F, 0x6C, 0xBC, 0xCC, 0x37, 0xEF, 0x32, 0x7D, 0xAF, 0x90, 0x47, 0xAF, 0x54, 0xD9, 0xD6, 0x9E, 0x50, 0xB6, 0x7D, 0x1E, 0x1C, 0xD8, 0x8D, 0x72, 0x64, 0x86, 0x93, 0xDB, 0x2E, 0xCE, 0x1E, 0x95, 0xA8, 0xBF, 0x6B, 0x22, 0x9B, 0x16, 0x72, 0x2A, 0xA2, 0x53, 0x37, 0x8F, 0x81, 0xCE, 0x0B, 0x8E, 0x27, 0x23, 0x73, 0x7C, 0xE7, 0x15, 0x32, 0x20, 0xA1, 0xD4, 0xE9, 0xCD, 0x10, 0xC2, 0xC0, 0xB9, 0x92, 0x8E, 0x8E, 0x0B, 
			0x50, 0x79, 0x15, 0xFE, 0x64, 0x90, 0x85, 0xB7, 0x65, 0xAD, 0x6A, 0x80, 0xF3, 0x43, 0x3D, 0x1C, 0xCC, 0xFB, 0xC6, 0x8C, 0x83, 0x23, 0xE3, 0xA7, 0x4C, 0xCE, 0x88, 0x8C, 0x99, 0xED, 0xCE, 0xC8, 0x29, 0xA7, 0x45, 0xA7, 0x3A, 0xC2, 0x24, 0x6C, 0xD7, 0x47, 0x37, 0x06, 0xEE, 0xAE, 0xD7, 0xC7, 0xE6, 0x09, 0x2D, 0xAC, 0x13, 0x5A, 0xE1, 0x83, 0x72, 0x65, 0x60, 0x21, 0x97, 0x1A, 0x56, 0x6B, 0xFA, 0xE4, 0x4B, 0x71, 0x6E, 0x99, 0x1F, 0x09, 0xBF, 0x97, 0x23, 0xC2, 0x1A, 0xEE, 0xEA, 0x82, 0x07, 0x9C, 0x8F, 0x7C, 0x80, 0xBA, 0xC3, 0x68, 0xFC, 0x42, 0xE4, 0x50, 0x80, 0x71, 0x48, 0x74, 0x6A, 0x10, 0x23, 0x7E, 
			0x44, 0xD6, 0xA2, 0xB9, 0x3E, 0x95, 0xA0, 0x0E, 0x0B, 0xA6, 0xA8, 0x45, 0xD8, 0xE5, 0x18, 0x17, 0x63, 0xB9, 0xE2, 0x66, 0x88, 0xA4, 0xEC, 0x4A, 0x88, 0x3F, 0x54, 0x2B, 0x7D, 0x89, 0xC3, 0x73, 0x84, 0x83, 0x76, 0x62, 0x6B, 0xD6, 0xDA, 0x76, 0x43, 0xD7, 0xCA, 0xE3, 0x78, 0x45, 0x5A, 0x46, 0xA7, 0x6D, 0x0E, 0x42, 0x41, 0x80, 0xDB, 0x03, 0xDD, 0x11, 0x5F, 0xD1, 0x0F, 0x3F, 0x9C, 0xD3, 0xBB, 0xEF, 0xCC, 0x8C, 0x10, 0x96, 0x6B, 0xA0, 0x86, 0xB9, 0x32, 0xFD, 0xB4, 0xA8, 0x55, 0x90, 0x57, 0x80, 0x30, 0x9A, 0xB3, 0xC0, 0xE1, 0xDE, 0xEC, 0x56, 0x3A, 0x16, 0x2F, 0x9B, 0x04, 0x00, 0x4C, 0x84, 0xC1, 0x42, 
			0xBE, 0x3D, 0xC8, 0xD4, 0x8B, 0x86, 0x0B, 0x0A, 0x73, 0x32, 0x50, 0x18, 0x73, 0x3E, 0x96, 0x70, 0xB1, 0x58, 0x96, 0x67, 0x60, 0x36, 0xFA, 0x9F, 0xC5, 0x22, 0xBD, 0x29, 0xEB, 0xFB, 0xA9, 0xDA, 0x16, 0xF0, 0x1C, 0xDE, 0xEB, 0x6E, 0xB7, 0x7D, 0x2F, 0x13, 0xBE, 0x13, 0x34, 0xB3, 0x70, 0x49, 0xEF, 0x15, 0x96, 0xEF, 0x55, 0xF4, 0x39, 0x34, 0x2F, 0xB4, 0x3C, 0x26, 0x2B, 0xEC, 0x66, 0x20, 0x29, 0x14, 0xB6, 0x70, 0xCC, 0x40, 0x11, 0xC1, 0xC4, 0x55, 0xDF, 0x44, 0x62, 0xEA, 0x86, 0x26, 0x7F, 0x70, 0x91, 0x37, 0x1E, 0x35, 0x6A, 0x29, 0x29, 0x1D, 0x4A, 0x38, 0x74, 0x4D, 0x19, 0xF2, 0x8B, 0x02, 0x51, 0xF2, 
			0x89, 0xE7, 0xBE, 0xEA, 0xCC, 0x3C, 0x7F, 0x94, 0x14, 0xB1, 0x99, 0x99, 0xCB, 0x19, 0xA8, 0x20, 0x1B, 0x5C, 0xEE, 0xAD, 0x5E, 0x41, 0xA3, 0x13, 0x63, 0xD9, 0x3C, 0x6B, 0x7E, 0x60, 0xBB, 0x26, 0x59, 0x11, 0xD1, 0x85, 0x00, 0x08, 0x68, 0xDC, 0xF3, 0xCD, 0x55, 0xAC, 0x0E, 0xC3, 0x77, 0xDC, 0xED, 0x5A, 0x83, 0x51, 0x4C, 0xCC, 0xAE, 0xBA, 0xF7, 0x60, 0x47, 0x61, 0x01, 0xCC, 0x31, 0x46, 0xF5, 0x2A, 0x06, 0x39, 0x15, 0xCD, 0x1C, 0x2C, 0x32, 0x79, 0x2E, 0x1E, 0x73, 0x80, 0xA6, 0x91, 0x7B, 0xCD, 0xFE, 0x0F, 0x8B, 0x86, 0x91, 0xD3, 0xD2, 0x07, 0xB8, 0x48, 0x1A, 0x63, 0x41, 0xE7, 0x62, 0xDF, 0x1E, 0x59, 
			0x9B, 0xFA, 0xC8, 0x25, 0xC3, 0x70, 0x96, 0x8E, 0xEB, 0xA7, 0x5D, 0x0D, 0x6C, 0xBA, 0xB1, 0xDD, 0x8F, 0xB7, 0xA8, 0xBF, 0xBD, 0xBE, 0xFF, 0x86, 0x8A, 0x31, 0x11, 0xAF, 0x33, 0x6A, 0x1E, 0x11, 0xDF, 0x06, 0x0C, 0x16, 0x98, 0x9E, 0x5B, 0xE3, 0x4C, 0x31, 0xF4, 0x5F, 0x61, 0xC0, 0x22, 0xAC, 0x80, 0xA7, 0x05, 0xAA, 0x48, 0x77, 0xCE, 0x2F, 0x2F, 0x93, 0xA6, 0x19, 0x12, 0x6C, 0x40, 0x24, 0xC0, 0xF1, 0xF9, 0xC1, 0x13, 0x99, 0x2A, 0xE7, 0x12, 0xB2, 0xA4, 0x67, 0xCD, 0xC6, 0xA7, 0xE2, 0x59, 0x20, 0x71, 0xB8, 0x5D, 0x3C, 0xAC, 0x8A, 0x30, 0x00, 0xDE, 0xAB, 0x97, 0x94, 0x7E, 0x72, 0xF0, 0xDA, 0x6D, 0x9D, 
			0xDF, 0x89, 0x53, 0x06, 0x93, 0x6F, 0xA4, 0x90, 0x30, 0xFA, 0xD3, 0x26, 0xE6, 0x24, 0xBF, 0x3E, 0x22, 0xA2, 0x46, 0x55, 0xF6, 0x6A, 0x16, 0x5D, 0x3E, 0x17, 0x7E, 0x13, 0x02, 0x9C, 0x2D, 0x07, 0x79, 0x58, 0x00, 0x32, 0xD2, 0x10, 0x93, 0x85, 0x98, 0x2D, 0xF8, 0x5D, 0x5B, 0x74, 0xB0, 0x7E, 0x4B, 0x57, 0x64, 0xEA, 0x66, 0xDF, 0xE1, 0x04, 0xCC, 0x35, 0x9F, 0x0E, 0x46, 0x8A, 0xFB, 0x1C, 0x0D, 0x37, 0x8D, 0xC0, 0x13, 0x67, 0xAE, 0xC0, 0xD2, 0x2E, 0x9B, 0xB4, 0x16, 0x1B, 0xA4, 0x9A, 0x23, 0x18, 0xD2, 0x58, 0x9E, 0x3F, 0x4B, 0x83, 0x0D, 0x4A, 0xE4, 0xF3, 0xB3, 0xFC, 0x0A, 0xF9, 0xA5, 0x01, 0x9C, 0x44, 
			0x89, 0x53, 0xBD, 0x10, 0xAA, 0x1E, 0xC6, 0x41, 0x7C, 0x71, 0xCA, 0x47, 0x79, 0x60, 0x95, 0x2E, 0xAB, 0xF6, 0x17, 0xBE, 0x1D, 0xF1, 0x05, 0xAD, 0x76, 0xD8, 0xBB, 0xF2, 0xBB, 0x36, 0xEE, 0xCD, 0xAA, 0xBC, 0xBA, 0xBE, 0x94, 0x42, 0x9A, 0xA8, 0xEE, 0xE5, 0x93, 0x5C, 0x3C, 0x23, 0xE2, 0x75, 0xD3, 0x59, 0xB4, 0xB3, 0xC4, 0x01, 0xBB, 0xC9, 0x05, 0xFE, 0xFA, 0x1B, 0x31, 0x7A, 0x15, 0x29, 0x91, 0xE6, 0xB9, 0xB2, 0x1E, 0xF9, 0x36, 0xC5, 0x17, 0xB9, 0x9D, 0x32, 0x0D, 0x0D, 0x80, 0x4A, 0x0D, 0x14, 0xB4, 0xDF, 0x89, 0x3A, 0x4B, 0xCA, 0x4B, 0xDE, 0xF8, 0xC0, 0x1B, 0xA6, 0x6D, 0xD9, 0x19, 0xFB, 0x0E, 0x02, 
			0x22, 0x82, 0x8E, 0x25, 0x8E, 0x9F, 0xD5, 0x7B, 0xB6, 0x14, 0x15, 0x08, 0x61, 0xCD, 0xA6, 0xB3, 0x0F, 0xC8, 0xE8, 0xF9, 0xEE, 0xDB, 0xAF, 0x25, 0x40, 0x01, 0x85, 0x0E, 0x89, 0x0D, 0x0D, 0x85, 0xA6, 0xA3, 0xC9, 0x65, 0x64, 0x8A, 0xD1, 0xF7, 0x55, 0xF9, 0x31, 0x24, 0x41, 0x30, 0x3B, 0x30, 0x1F, 0x30, 0x07, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x04, 0x14, 0xD4, 0x77, 0x3F, 0x92, 0xB6, 0xA6, 0x1B, 0xD5, 0x7F, 0xC1, 0x1B, 0x93, 0xB3, 0x6E, 0x87, 0x67, 0x80, 0xE7, 0x4C, 0x7C, 0x04, 0x14, 0x58, 0x4C, 0x92, 0xDD, 0x0B, 0xEF, 0x09, 0x35, 0xE0, 0x06, 0x33, 0x54, 0xB2, 0xA8, 0x8E, 0x0C, 0x60, 0x67, 
			0xB5, 0x0F, 0x02, 0x02, 0x07, 0xD0 };
			
		public static byte[] openssl_emptypwd_pfx = { 0x30, 0x82, 0x06, 0x19, 0x02, 0x01, 0x03, 0x30, 0x82, 0x05, 0xDF, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x05, 0xD0, 0x04, 0x82, 0x05, 0xCC, 0x30, 0x82, 0x05, 0xC8, 0x30, 0x82, 0x02, 0xC7, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x06, 0xA0, 0x82, 0x02, 0xB8, 0x30, 0x82, 0x02, 0xB4, 0x02, 0x01, 0x00, 0x30, 0x82, 0x02, 0xAD, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x06, 0x30, 0x0E, 0x04, 0x08, 0xE4, 0x0A, 0x2F, 0x48, 0xE6, 0x07, 0x62, 
			0x5D, 0x02, 0x02, 0x08, 0x00, 0x80, 0x82, 0x02, 0x80, 0x35, 0x6F, 0x44, 0xFA, 0xA8, 0x0D, 0x41, 0xBA, 0x1A, 0xAE, 0xB1, 0xFB, 0xA4, 0xBB, 0x91, 0x28, 0x75, 0x19, 0xF8, 0x1C, 0x0E, 0xB4, 0xCE, 0x2A, 0x5C, 0x28, 0x2E, 0x34, 0x6F, 0x9B, 0x5F, 0x94, 0x16, 0x33, 0xE0, 0x36, 0x50, 0x5D, 0x47, 0x74, 0x42, 0x4E, 0xCC, 0xA0, 0x7F, 0x8C, 0x32, 0x26, 0x7A, 0x5F, 0x24, 0xB1, 0xEB, 0xD8, 0x2C, 0xE3, 0x6D, 0xC2, 0x3C, 0xBC, 0x3B, 0x0A, 0x78, 0x39, 0x88, 0x24, 0x9E, 0x94, 0x15, 0xC3, 0x43, 0xE0, 0x25, 0x31, 0x3F, 0xB0, 0xDA, 0xF8, 0x4E, 0x37, 0x56, 0xD4, 0xAE, 0x75, 0x28, 0x30, 0x67, 0x5F, 0xBF, 0xF9, 0x7D, 
			0xDC, 0xF6, 0x1A, 0x02, 0xF0, 0x65, 0xBF, 0x0A, 0x4D, 0x39, 0x16, 0xC7, 0x57, 0x9A, 0xA1, 0x7C, 0xF0, 0x4B, 0xDD, 0x0E, 0xAF, 0x4E, 0xA9, 0xC8, 0x85, 0x89, 0xCB, 0xB8, 0xD3, 0x96, 0x5F, 0x0C, 0xCB, 0x85, 0xBD, 0xEB, 0x11, 0x00, 0x3B, 0x34, 0xB6, 0x6B, 0xCE, 0x32, 0x75, 0x09, 0x8C, 0x09, 0x3B, 0x13, 0x9D, 0x9F, 0xC1, 0x72, 0x8F, 0xC5, 0x9E, 0x90, 0x89, 0x7C, 0x3A, 0x64, 0xC2, 0x27, 0xD5, 0xF5, 0x6B, 0x23, 0x2C, 0x32, 0xEF, 0xB4, 0x2C, 0x09, 0x0F, 0x65, 0xF4, 0xE4, 0xDC, 0xC3, 0x1F, 0x00, 0xF4, 0x77, 0xB0, 0x3B, 0x08, 0xA5, 0x59, 0xFA, 0x50, 0xAF, 0x9D, 0x9D, 0x22, 0x80, 0xC6, 0x6E, 0xF8, 0xA7, 
			0xB7, 0x03, 0x2A, 0x64, 0x37, 0x9C, 0xFB, 0x0D, 0x9D, 0xEF, 0xEC, 0x81, 0xDD, 0xEE, 0x17, 0xA9, 0x8D, 0xA1, 0x9D, 0x06, 0x0F, 0x51, 0x1E, 0x21, 0xF6, 0xEB, 0x10, 0x20, 0x99, 0xE6, 0x8D, 0x23, 0xDC, 0x27, 0xD5, 0xF5, 0xAF, 0x02, 0x07, 0xBE, 0x85, 0x7E, 0x11, 0x5D, 0x87, 0xEB, 0x49, 0xCA, 0xA1, 0xDB, 0x10, 0xB6, 0x18, 0x7C, 0x52, 0x07, 0x08, 0x99, 0xAF, 0x37, 0x15, 0x0E, 0x72, 0xB4, 0x0A, 0x5B, 0x88, 0x70, 0xCF, 0x24, 0xF4, 0xB3, 0x38, 0x99, 0x21, 0x2E, 0xB2, 0x98, 0x79, 0x28, 0x2E, 0x23, 0x1F, 0x9A, 0x20, 0xA7, 0x62, 0xC4, 0x31, 0x82, 0x35, 0x59, 0xFD, 0xAB, 0x7F, 0xE6, 0x6C, 0x9A, 0xE6, 0x4D, 
			0x3E, 0xE3, 0xA7, 0x3E, 0xAE, 0x6F, 0xCA, 0xD2, 0x3A, 0x9B, 0x31, 0x1B, 0x96, 0xA9, 0x25, 0xB5, 0x25, 0x47, 0x57, 0xCF, 0x7C, 0x5F, 0x1E, 0x5C, 0x38, 0xB9, 0x24, 0xB2, 0xA5, 0x50, 0xB1, 0x3F, 0xAC, 0x3C, 0x77, 0x53, 0xC7, 0xC8, 0x3B, 0x95, 0xD4, 0x37, 0x30, 0x6E, 0xE6, 0x39, 0x2E, 0x53, 0x09, 0x30, 0x9B, 0x35, 0x1C, 0x74, 0x31, 0x46, 0x67, 0xC5, 0x6E, 0x4D, 0x35, 0x8F, 0x61, 0xC5, 0xA4, 0xD4, 0xBA, 0xE1, 0x47, 0xC7, 0x1D, 0x94, 0x75, 0x6B, 0xFA, 0xAE, 0x2E, 0xDC, 0xB4, 0xA7, 0x64, 0xFA, 0x14, 0x68, 0x14, 0xA0, 0x81, 0x96, 0xD9, 0xC0, 0x2A, 0xFD, 0xEE, 0x78, 0xFE, 0xB6, 0x38, 0xC9, 0x1B, 0xF7, 
			0x05, 0xC1, 0x4C, 0xF1, 0x21, 0x53, 0x62, 0x17, 0xED, 0x1D, 0xF7, 0x34, 0x92, 0xD4, 0xDD, 0xD7, 0xF0, 0xA7, 0x90, 0x34, 0xBE, 0x26, 0x86, 0x26, 0x67, 0x3B, 0x40, 0xC6, 0x4C, 0x6A, 0x26, 0xD9, 0x2A, 0x4E, 0x58, 0xEF, 0x86, 0x80, 0x8B, 0x6D, 0x40, 0xCD, 0x40, 0xFD, 0x7B, 0xD9, 0x1C, 0xC4, 0x24, 0x94, 0x4A, 0xFB, 0xFC, 0xB9, 0xF8, 0xE6, 0x95, 0x82, 0x0D, 0x02, 0xE3, 0x53, 0xC9, 0x28, 0xBD, 0x60, 0x65, 0x76, 0x0F, 0xF0, 0xFE, 0x23, 0xF6, 0x8A, 0xB6, 0xB3, 0xD4, 0x51, 0xC2, 0xE5, 0xB4, 0x3A, 0x10, 0x0D, 0x25, 0x7C, 0xC9, 0xCC, 0x11, 0x45, 0x7C, 0xC0, 0x1F, 0x82, 0x52, 0xCA, 0xE8, 0x25, 0x53, 0xCE, 
			0x92, 0x67, 0xEC, 0xA2, 0x04, 0xE1, 0x58, 0x7B, 0xE6, 0xF2, 0xA2, 0x5D, 0x74, 0x46, 0xD5, 0x9A, 0x6F, 0x70, 0x60, 0xC4, 0x99, 0xB2, 0x29, 0xF9, 0x60, 0x19, 0x89, 0x37, 0xB3, 0xE5, 0x97, 0xCD, 0x9E, 0xD4, 0x53, 0x0B, 0xD6, 0xB5, 0xC6, 0xFA, 0x8D, 0x0F, 0x96, 0x65, 0x78, 0xE9, 0xC0, 0x84, 0x38, 0x26, 0xD9, 0xA5, 0x27, 0x62, 0xFC, 0x2A, 0x79, 0xCF, 0x7F, 0xC9, 0xFC, 0xBC, 0x41, 0x29, 0x9C, 0xD8, 0x3B, 0x37, 0x54, 0xA0, 0x39, 0x78, 0x21, 0x3A, 0x9C, 0x51, 0xE0, 0x30, 0x18, 0xA4, 0x56, 0x61, 0x13, 0x9C, 0x1C, 0x01, 0x35, 0x96, 0x19, 0x4B, 0xAF, 0xD0, 0xFE, 0x95, 0xF1, 0xC1, 0xBB, 0x6A, 0xBC, 0x2C, 
			0x39, 0x21, 0x38, 0xB4, 0xB9, 0x10, 0x27, 0xD6, 0x04, 0xC5, 0xE4, 0xC3, 0x2C, 0xB8, 0x0B, 0xEC, 0xB3, 0x28, 0x32, 0x50, 0x02, 0x4E, 0xE4, 0xE9, 0x11, 0x4C, 0x38, 0x87, 0x3D, 0x7F, 0x54, 0xA2, 0x1D, 0xFF, 0x4B, 0x07, 0x0A, 0xE7, 0x42, 0x08, 0x48, 0x54, 0x3C, 0x7B, 0xE4, 0xF4, 0x2D, 0x98, 0x16, 0x30, 0x82, 0x02, 0xF9, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x02, 0xEA, 0x04, 0x82, 0x02, 0xE6, 0x30, 0x82, 0x02, 0xE2, 0x30, 0x82, 0x02, 0xDE, 0x06, 0x0B, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x0A, 0x01, 0x02, 0xA0, 0x82, 0x02, 0xA6, 0x30, 0x82, 0x02, 
			0xA2, 0x30, 0x1C, 0x06, 0x0A, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x0C, 0x01, 0x03, 0x30, 0x0E, 0x04, 0x08, 0x8C, 0xA8, 0xAE, 0x70, 0xEB, 0x90, 0xF9, 0xB7, 0x02, 0x02, 0x08, 0x00, 0x04, 0x82, 0x02, 0x80, 0xA7, 0x49, 0x1D, 0x10, 0xDD, 0x5C, 0xE8, 0xD5, 0x2F, 0x55, 0xAB, 0x62, 0x21, 0x13, 0x64, 0x32, 0xA8, 0xED, 0xFF, 0x8A, 0xE2, 0x5F, 0xCE, 0x74, 0x89, 0x1C, 0x9F, 0x73, 0x02, 0x99, 0x85, 0xE4, 0xF8, 0x21, 0xE1, 0xAA, 0x64, 0x72, 0x95, 0xEC, 0xA0, 0x2E, 0xA9, 0x90, 0x35, 0x51, 0x82, 0x9B, 0x28, 0xDC, 0x0C, 0x47, 0xCD, 0x5C, 0x08, 0x0C, 0x49, 0x8D, 0x06, 0x70, 0x97, 0xF5, 0x4C, 0x48, 0x43, 
			0xDC, 0x84, 0xC4, 0x6C, 0x4F, 0x55, 0xD9, 0x86, 0x16, 0x39, 0x31, 0x22, 0x0C, 0x12, 0x55, 0x76, 0x0E, 0xBC, 0x57, 0x66, 0x0D, 0xB3, 0xC0, 0xAB, 0x87, 0x6B, 0x85, 0x20, 0x4D, 0x69, 0x57, 0xAF, 0x44, 0xAB, 0x76, 0x15, 0xA7, 0xAA, 0x07, 0xA9, 0xD8, 0x82, 0x4C, 0x79, 0xA5, 0x62, 0x6D, 0x2E, 0x6C, 0x99, 0xE6, 0xE8, 0x6E, 0xD0, 0x12, 0x85, 0x98, 0x63, 0xEA, 0xC7, 0x07, 0x8C, 0x4B, 0xEB, 0x46, 0x2A, 0xE0, 0x94, 0xAA, 0x0C, 0x19, 0xFA, 0xD6, 0x93, 0x80, 0x7B, 0x20, 0x74, 0x1D, 0xB8, 0xB9, 0x76, 0xEB, 0x93, 0x9A, 0x32, 0x76, 0xA4, 0x93, 0x13, 0x54, 0x71, 0x23, 0xBC, 0x93, 0x26, 0x32, 0x11, 0x4F, 0xFB, 
			0x61, 0xD1, 0xD7, 0x15, 0x2F, 0x6F, 0x8C, 0xF9, 0x42, 0x0F, 0xE4, 0x24, 0x20, 0xA8, 0x22, 0x0C, 0x04, 0xFB, 0x1A, 0xB6, 0xF8, 0x89, 0xF7, 0x89, 0xF5, 0xD7, 0x46, 0xB6, 0x7C, 0xE0, 0x72, 0x22, 0x53, 0xD3, 0x23, 0x27, 0x98, 0xCC, 0x8E, 0xF8, 0xA8, 0x58, 0xC7, 0x36, 0x69, 0x0D, 0xF2, 0x20, 0x84, 0x83, 0x2D, 0x7A, 0xA9, 0xA5, 0x8D, 0x41, 0x62, 0xA6, 0x99, 0xAE, 0xBC, 0x92, 0xB0, 0x7B, 0xF6, 0x9A, 0x84, 0x37, 0x2B, 0x16, 0x9A, 0xD7, 0x46, 0x97, 0xB8, 0x72, 0x1B, 0xCC, 0x9F, 0xE7, 0xDD, 0x54, 0x83, 0x33, 0x42, 0xE5, 0x55, 0xEA, 0xC1, 0xC0, 0x00, 0xDE, 0xE8, 0x13, 0xB4, 0x7B, 0x9F, 0x0D, 0xAD, 0xF4, 
			0xB9, 0xA8, 0xEA, 0x54, 0xDF, 0x44, 0xF1, 0x67, 0xB7, 0x32, 0x0F, 0x84, 0x39, 0xEF, 0x75, 0xE2, 0xBC, 0x21, 0xA3, 0x71, 0x2E, 0xC3, 0x36, 0xE9, 0x9F, 0x2C, 0x6F, 0x35, 0x94, 0x2B, 0x51, 0x9A, 0xB3, 0xA7, 0xDD, 0xA1, 0x02, 0xF9, 0x14, 0x74, 0x58, 0x36, 0x7C, 0x86, 0x5E, 0xD1, 0xAE, 0x77, 0xA7, 0x3E, 0x38, 0x93, 0xB4, 0x50, 0x5F, 0x1E, 0x35, 0xC7, 0x77, 0xA9, 0x24, 0x28, 0xD2, 0xED, 0x9F, 0x8A, 0x67, 0xB6, 0x94, 0x8C, 0xF5, 0x69, 0x19, 0x1B, 0x3C, 0xAA, 0x39, 0x5D, 0x40, 0x6A, 0x33, 0x5A, 0xDA, 0x69, 0x24, 0x59, 0x99, 0x04, 0x90, 0x3E, 0xB3, 0xDE, 0xDC, 0xCB, 0x59, 0x35, 0xEF, 0x1B, 0xC1, 0x68, 
			0xCD, 0x20, 0x0E, 0x22, 0x94, 0xB7, 0xFC, 0x5B, 0xC0, 0x17, 0x38, 0x3E, 0xB5, 0x9C, 0xBA, 0x78, 0x94, 0xB2, 0x10, 0x05, 0x21, 0x30, 0x4B, 0x2F, 0x8B, 0xF1, 0x8D, 0xFC, 0x2A, 0xBF, 0x89, 0x4E, 0xE1, 0xF9, 0xBF, 0x3C, 0xCF, 0xAA, 0xB1, 0xEC, 0x39, 0x59, 0x9A, 0xE9, 0x07, 0xE1, 0xA0, 0xAA, 0x91, 0x7C, 0x09, 0xF1, 0xD5, 0xD9, 0xA3, 0xF1, 0x0E, 0xD2, 0xBD, 0xE8, 0x65, 0x83, 0xDB, 0xE4, 0x03, 0xFA, 0x19, 0x56, 0x00, 0x3F, 0x3E, 0x94, 0x03, 0xAD, 0x4D, 0x00, 0x7C, 0x47, 0x2C, 0x88, 0x88, 0x53, 0x7C, 0xF2, 0x7B, 0x2A, 0x5A, 0xCB, 0x44, 0x93, 0x4F, 0xDA, 0xE3, 0x2E, 0xC3, 0x1F, 0x4E, 0x14, 0x52, 0x1B, 
			0x33, 0x5F, 0xB7, 0xCD, 0x1D, 0xB1, 0xDE, 0xFE, 0xE8, 0xCF, 0xC2, 0xEE, 0xEB, 0xA6, 0x79, 0xF5, 0x0C, 0x21, 0x71, 0x95, 0xE1, 0x52, 0xBF, 0x76, 0xD5, 0x35, 0x43, 0x0E, 0xB6, 0x9B, 0x36, 0x34, 0x4E, 0x07, 0xF9, 0x29, 0x34, 0x44, 0x52, 0x15, 0xCC, 0x71, 0x5C, 0x5F, 0x89, 0x32, 0x32, 0x5B, 0x76, 0x8E, 0x08, 0x55, 0x46, 0xD5, 0x4A, 0x78, 0xEB, 0xB2, 0x9A, 0x39, 0xF9, 0xE6, 0xD7, 0x54, 0xE8, 0x59, 0x85, 0x09, 0x2B, 0xE8, 0x2D, 0x5E, 0x7F, 0x09, 0x8F, 0xA2, 0x65, 0x82, 0x54, 0x93, 0x17, 0x56, 0x51, 0x4F, 0x93, 0x2F, 0x92, 0x47, 0x3C, 0x7A, 0x2D, 0x45, 0x45, 0x67, 0x03, 0x02, 0x0C, 0x0B, 0xA4, 0x2A, 
			0x25, 0x22, 0x2F, 0x8E, 0x87, 0x04, 0x78, 0x12, 0x5C, 0x80, 0x1E, 0xF9, 0x0D, 0xC1, 0x5B, 0x06, 0x4D, 0x43, 0x1D, 0x13, 0x6C, 0xDB, 0x3D, 0xD2, 0x1C, 0x94, 0xA3, 0xBB, 0x62, 0xEB, 0x4F, 0x78, 0xC9, 0x43, 0x5E, 0x5F, 0x84, 0xCB, 0xE8, 0x31, 0x5F, 0xE9, 0xB7, 0xA9, 0xEA, 0x4A, 0xF2, 0xAB, 0x1E, 0x37, 0x7C, 0xAF, 0xE4, 0xF0, 0x4E, 0x3F, 0x6A, 0xA9, 0x04, 0xAB, 0x20, 0x44, 0xFD, 0x81, 0x47, 0x9F, 0x86, 0xF3, 0x59, 0xA5, 0x2A, 0x3D, 0x60, 0xB1, 0xF7, 0x31, 0x25, 0x30, 0x23, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x15, 0x31, 0x16, 0x04, 0x14, 0x30, 0x29, 0x69, 0x4B, 0x22, 0xB2, 
			0xEE, 0x6A, 0xEC, 0x9B, 0x78, 0x44, 0x9E, 0x51, 0x0F, 0x7C, 0x34, 0x8D, 0xBA, 0x33, 0x30, 0x31, 0x30, 0x21, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x05, 0x00, 0x04, 0x14, 0xC7, 0xDD, 0xD6, 0xA5, 0xC4, 0x14, 0xB6, 0x24, 0xF9, 0x03, 0xB9, 0xB6, 0xA3, 0x5A, 0x4A, 0x09, 0x51, 0x18, 0x5A, 0x19, 0x04, 0x08, 0x35, 0xB5, 0x1D, 0xC3, 0x17, 0x45, 0x8B, 0x92, 0x02, 0x02, 0x08, 0x00 };

		public const string base64_cert = @"-----BEGIN CERTIFICATE-----
MIIBxTCCATKgAwIBAgIQx3WuSFObHp5EgBXKeBVHaTAJBgUrDgMCHQUAMCUxIzAh
BgNVBAMeGgBDAEEAUwBUAE8AUgBcAHAAbwB1AHAAbwB1MB4XDTA1MDYwODEzMzg0
N1oXDTA2MDYwODE5Mzg0N1owJTEjMCEGA1UEAx4aAEMAQQBTAFQATwBSAFwAcABv
AHUAcABvAHUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANrqOTj2OvSL+eLH
1Sz5GtV1zxess0a9fz+XOC4QQbLE2RQV2Ob5ETiAdePXH8CGpz4CEQTpV7XYV2Un
e4+6ue+gjxWc7C+FY05Sa6bjM8qGIrr5Bujsy6elqOI+xyF0TsnpBV+ueBJRL/pq
j3ywZCr7t7JAkSDnMlM/WMqAokHFAgMBAAEwCQYFKw4DAh0FAAOBgQCdV7All4Ei
PMRhncnb2MfB7fsc3TWY10BYpEOGVPloloW1kby3grJ+e1i9gM40fiKHYjG1Axag
IBed512qEvWS35Tmac32/IKb3NMwQLFxT0pky9wUyMF/byPO3RkiTyQeJxhmiHqa
mgk3bWUV6ChegutbguiKrI/DbO7wPiDLxw==
-----END CERTIFICATE-----";

		public const string t61string_cert = @"-----BEGIN CERTIFICATE-----
MIIEwjCCA6qgAwIBAgIEP4ZvDjANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJE
SzEMMAoGA1UEChMDS01EMQwwCgYDVQQLEwNLTUQxOjA4BgNVBAMTMUtNRCBJbnRl
cm4gVGVzdCAtIEtVTiBUSUwgVEVTVC9OTyBMSUFCSUxJVFkgR0lWRU4wHhcNMDMx
MDEwMDgzNDIyWhcNMDgwOTAyMDgzNDIyWjCBtTELMAkGA1UEBhMCREsxLTArBgNV
BAoUJEhlZGVieSdzIE34YmVsaGFuZGVsIC8vIENWUjoxMzQ3MTk2NzEvMC0GA1UE
AxQmSGVkZWJ5J3MgTfhiZWxoYW5kZWwgLSBTYWxnc2FmZGVsaW5nZW4xHjAcBgkq
hkiG9w0BCQEWD3ZobUB1c2UudGVzdC5kazEmMCQGA1UEBRMdQ1ZSOjEzNDcxOTY3
LVVJRDoxMjEyMTIxMjEyMTIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAOcD
yp6eb479ByaWx/+XpVkcvIs9CytI5cKw9W/ShT/ov++IKC7P9a83Pah1gpyx4eGf
947KvqR9FdHNV5uJOuOiP22jElXTKOAQIo9pl8jd2Dw5DMVSLq3QSwlWriTY9QP8
t3qF9Aqqm5/HpHWw8bBnBXp0+It0M7mtEpG2SlxzAgMBAAGjggGrMIIBpzAOBgNV
HQ8BAf8EBAMCA7gwggFIBgNVHSAEggE/MIIBOzCCATcGCSkBAQEBAQEBAzCCASgw
LwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2VydGlmaWthdC5kay9yZXBvc2l0b3J5
MIH0BggrBgEFBQcCAjCB5xqB5ERldHRlIGRpZ2l0YWxlIGNlcnRpZmlrYXQgZXIg
dWRlbHVra2VuZGUgdGlsIHRlc3RicnVnIG9nIGthbiBpa2tlIGFudmVuZGVzIHRp
bCBmb3JwbGlndGVkZSBhZnRhbGVyIGVsbGVyIGxpZ25lbmRlLiBEZXQgc2thbCBz
YW10aWRpZyBub3RlcmVzIGF0IGRlciBpa2tlIGxpZ2dlciBlbiB1ZHN0ZWRlbHNl
c3BvbGl0aWsgdGlsIGdydW5kIGZvciB1ZHN0ZWRlbHNlbiBhZiBkZXR0ZSBjZXJ0
aWZpa2F0LjAJBgNVHRMEAjAAMB0GA1UdDgQWBBRGbd1b8ueAq3hLPYi+hoaHPnGu
cDAfBgNVHSMEGDAWgBTY+uxQeo2M0NeJ+PxY1Nzr2ZiZUDANBgkqhkiG9w0BAQUF
AAOCAQEAxCFwpBW5tewIVgp844mFt9G8+rygfs+184G/n85IwZ+Ryu6tMsxddVbq
44VdW1DsT202k2bh8fgeEDKtGGn1orKglezuc0xisUWgmV44KHBHgM08hajmPS2E
vKzGMlc4FI+iSmKmpqm3Qod9J9mBmoL9krduOKm2Cc7RdiM2k1t+j/lXJ0uNRapC
WK3bQo3um7iujoczHQyuYDgROIra4OKmn3RJUp60XPTtY1nH/xTKqJlxKCq17tsG
WYpnKQqsKIzlSqv9wwXs7B1iA7ZdvHk3TAnSnLP1o2H7ME05UnZPKCvraONdezon
/yvWCu++B/xSVQ/i8F3U/NL3tLLZyw==
-----END CERTIFICATE-----";

		static public byte[] farscape_pkcs7 = { 0x30, 0x82, 0x02, 0x59, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x02, 0xA0, 0x82, 0x02, 0x4A, 0x30, 0x82, 0x02, 0x46, 0x02, 0x01, 0x01, 0x31, 0x00, 0x30, 0x0B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x07, 0x01, 0xA0, 0x82, 0x02, 0x2E, 0x30, 0x82, 0x02, 0x2A, 0x30, 0x82, 0x01, 0x97, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x91, 0xC4, 0x4B, 0x0D, 0xB7, 0xD8, 0x10, 0x84, 0x42, 0x26, 0x71, 0xB3, 0x97, 0xB5, 0x00, 0x97, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x30, 0x28, 0x31, 0x26, 0x30, 0x24, 0x06, 0x03, 
			0x55, 0x04, 0x03, 0x13, 0x1D, 0x4D, 0x6F, 0x74, 0x75, 0x73, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6E, 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 0x73, 0x20, 0x69, 0x6E, 0x63, 0x2E, 0x28, 0x74, 0x65, 0x73, 0x74, 0x29, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x33, 0x30, 0x38, 0x31, 0x33, 0x30, 0x30, 0x34, 0x33, 0x34, 0x37, 0x5A, 0x17, 0x0D, 0x33, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x13, 0x31, 0x11, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x08, 0x46, 0x41, 0x52, 0x53, 0x43, 0x41, 0x50, 0x45, 0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 
			0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8D, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xD2, 0xCB, 0x47, 0x21, 0xF5, 0x62, 0xDD, 0x35, 0xBF, 0x1D, 0xEC, 0x9A, 0x4C, 0x07, 0x2C, 0x01, 0xF0, 0x28, 0xC2, 0x82, 0x17, 0x8E, 0x58, 0x32, 0xD5, 0x4C, 0xAC, 0x86, 0xB4, 0xC9, 0xEB, 0x21, 0x26, 0xF3, 0x22, 0x30, 0xC5, 0x7A, 0xA3, 0x5A, 0xDD, 0x53, 0xAB, 0x1C, 0x06, 0x3E, 0xB2, 0x13, 0xC4, 0x05, 0x1D, 0x95, 0x8B, 0x0A, 0x71, 0x71, 0x11, 0xA7, 0x47, 0x26, 0x61, 0xF1, 0x76, 0xBE, 0x35, 0x72, 0x32, 0xC5, 0xCB, 0x47, 0xA4, 0x22, 0x41, 0x1E, 0xAD, 0x29, 0x11, 0x0D, 0x39, 0x22, 0x0C, 0x79, 0x90, 0xC6, 
			0x52, 0xA1, 0x10, 0xF6, 0x55, 0x09, 0x4E, 0x51, 0x26, 0x47, 0x0E, 0x94, 0xE6, 0x81, 0xF5, 0x18, 0x6B, 0x99, 0xF0, 0x76, 0xF3, 0xB2, 0x4C, 0x91, 0xE9, 0xBA, 0x3B, 0x3F, 0x6E, 0x63, 0xDA, 0x12, 0xD1, 0x0B, 0x73, 0x0E, 0x12, 0xC7, 0x70, 0x77, 0x22, 0x03, 0x9D, 0x5D, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x72, 0x30, 0x70, 0x30, 0x13, 0x06, 0x03, 0x55, 0x1D, 0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x01, 0x30, 0x59, 0x06, 0x03, 0x55, 0x1D, 0x01, 0x04, 0x52, 0x30, 0x50, 0x80, 0x10, 0xAE, 0xD7, 0x80, 0x88, 0xA6, 0x3D, 0xBA, 0x50, 0xA1, 0x7E, 0x57, 0xE5, 0x40, 
			0xC9, 0x6F, 0xC5, 0xA1, 0x2A, 0x30, 0x28, 0x31, 0x26, 0x30, 0x24, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x1D, 0x4D, 0x6F, 0x74, 0x75, 0x73, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6E, 0x6F, 0x6C, 0x6F, 0x67, 0x69, 0x65, 0x73, 0x20, 0x69, 0x6E, 0x63, 0x2E, 0x28, 0x74, 0x65, 0x73, 0x74, 0x29, 0x82, 0x10, 0x9D, 0xAE, 0xA3, 0x39, 0x47, 0x0E, 0xD4, 0xA2, 0x49, 0x78, 0xEA, 0x6C, 0xBA, 0x0D, 0xDE, 0x9C, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x32, 0x8A, 0x7E, 0xAD, 0xE7, 0x67, 0x9E, 0x5C, 0x4C, 0xD8, 0x33, 0x59, 0x68, 0xCF, 0x94, 0xC0, 0x36, 0x47, 0x7A, 0xA7, 
			0x85, 0xC2, 0xDD, 0xD8, 0xDA, 0x11, 0x3C, 0x66, 0xC1, 0x83, 0xE3, 0xAB, 0x33, 0x06, 0x7C, 0xE3, 0x6A, 0x15, 0x72, 0xB8, 0x83, 0x3D, 0x0B, 0xAB, 0x3C, 0xEE, 0x75, 0x13, 0xBD, 0x5C, 0x96, 0x25, 0x56, 0x36, 0x05, 0xFA, 0xAE, 0xD4, 0xF4, 0xCF, 0x52, 0xEC, 0x11, 0xB5, 0xEA, 0x9F, 0x20, 0xA3, 0xC8, 0x34, 0x72, 0x59, 0x09, 0x51, 0xE7, 0x36, 0x87, 0x86, 0x86, 0x98, 0xB5, 0x30, 0x7B, 0xFB, 0x3D, 0xCC, 0x5E, 0xE8, 0xC9, 0x49, 0xE0, 0xC6, 0xEA, 0x02, 0x76, 0x01, 0xE0, 0xBB, 0x8A, 0x70, 0xEB, 0x07, 0x86, 0xE8, 0x04, 0xE7, 0x48, 0xE4, 0x6C, 0x90, 0xE6, 0x16, 0x42, 0xB4, 0xBB, 0xC0, 0xC4, 0x82, 0x5F, 0xF8, 
			0xFB, 0x7E, 0xB2, 0x9E, 0xC2, 0x78, 0x26, 0x86, 0x31, 0x00 };

		[Test]
		public void Ctor_ByteArray ()
		{
			X509Certificate2 cert = new X509Certificate2 (cert_1);
			Assert.IsNotNull (cert.RawData, "#1");
			Assert.AreEqual (cert_1.Length, cert.RawData.Length, "#2");
			Assert.AreEqual (cert_1, cert.RawData, "#3");
			Assert.IsNotNull (cert.GetRawCertData (), "#4");
			Assert.AreEqual (cert_1.Length, cert.GetRawCertData ().Length, "#5");
			Assert.AreEqual (cert_1, cert.GetRawCertData (), "#6");
		}

		[Test]
		public void X509Certificate2_WhenNullProvidedAsByteArray_DoesNotThrow ()
		{
			Assert.DoesNotThrow (() => new X509Certificate2 ((byte[]) null));
		}

		[Test]
		public void X509Certificate2_WhenEmptyByteArrayProvided_DoesNotThrow ()
		{
			Assert.DoesNotThrow (() => new X509Certificate2 (new byte [0]));
		}

		[Test]
		public void Ctor_FileName ()
		{
			string tempFile = Path.GetTempFileName ();
			try {
				using (FileStream fs = File.OpenWrite (tempFile)) {
					fs.Write (cert_1, 0, cert_1.Length);
					fs.Close ();
				}

				X509Certificate2 cert = new X509Certificate2 (tempFile);
				Assert.IsNotNull (cert.RawData, "#C1");
				Assert.AreEqual (cert_1.Length, cert.RawData.Length, "#C2");
				Assert.AreEqual (cert_1, cert.RawData, "#C3");
				Assert.IsNotNull (cert.GetRawCertData (), "#C4");
				Assert.AreEqual (cert_1.Length, cert.GetRawCertData ().Length, "#C5");
				Assert.AreEqual (cert_1, cert.GetRawCertData (), "#C6");
				Assert.IsFalse (cert.HasPrivateKey, "#C7");
				Assert.IsNull (cert.PrivateKey, "#C8");
			}
			finally {
				File.Delete (tempFile);
			}
		}

		[Test] // bug #79028
		public void Ctor_ByteArray_Password ()
		{
			// password isn't required but supplied
			X509Certificate2 cert = new X509Certificate2 (cert_1, "mono");
			Assert.IsNotNull (cert.RawData, "#1");
			Assert.AreEqual (cert_1.Length, cert.RawData.Length, "#2");
			Assert.AreEqual (cert_1, cert.RawData, "#3");
			Assert.IsNotNull (cert.GetRawCertData (), "#4");
			Assert.AreEqual (cert_1.Length, cert.GetRawCertData ().Length, "#5");
			Assert.AreEqual (cert_1, cert.GetRawCertData (), "#6");
		}

		[Test] // bug #79028
		public void Ctor_FileName_Password ()
		{
			string tempFile = Path.GetTempFileName ();
			try {
				using (FileStream fs = File.OpenWrite (tempFile)) {
					fs.Write (cert_1, 0, cert_1.Length);
					fs.Close ();
				}

				// password isn't required but supplied
				X509Certificate2 cert = new X509Certificate2 (tempFile, "mono");
				Assert.IsNotNull (cert.RawData, "#1");
				Assert.AreEqual (cert_1.Length, cert.RawData.Length, "#2");
				Assert.AreEqual (cert_1, cert.RawData, "#3");
				Assert.IsNotNull (cert.GetRawCertData (), "#4");
				Assert.AreEqual (cert_1.Length, cert.GetRawCertData ().Length, "#5");
				Assert.AreEqual (cert_1, cert.GetRawCertData (), "#6");
			}
			finally {
				File.Delete (tempFile);
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_GetRawCertData ()
		{
			new X509Certificate2 ().GetRawCertData ();
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_GetRawCertDataString ()
		{
			new X509Certificate2 ().GetRawCertDataString ();
		}

		[Test]
		public void X509Certificate2_WhenEmptyCertificateProvided_DoesNotThrow ()
		{
			Assert.DoesNotThrow (() => new X509Certificate2 (new X509Certificate2 ()));
		}

		[Test]
		public void Certificate_1_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (629937887260000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629622527270000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_1);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (0, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>LVjpv/AxzXkGUFrVng4s5sL3+dLOVWSFsZCakrM2wbzqyCO3qzqnZGN3X4QijuW2Rd1GrgrdAMIfutmtwHVi+JWCooCxgmn64a9/vH3ifHbVvCqA+w==</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_1, x.RawData, "RawData");
			Assert.AreEqual ("02720006E8", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.2", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("OU=Server Certification Authority, O=CommerceNet, S=California, C=US", x.Subject, "Subject");
			Assert.AreEqual ("OU=Server Certification Authority, O=CommerceNet, S=California, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("D62F48D013EE7FB58B79074512670D9C5B3A5DA9", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (1, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Secure Server Certification Authority", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Server Certification Authority", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");
		}

		[Test]
		public void Certificate_2_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (631152758320000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629575958320000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_2);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (0, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("OU=Directory Services, O=AT&T, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("OU=Directory Services, O=AT&T, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>h2RyiQsgj4cnrMYi/gBAaUivxobNIzPjEcUxGh9+npITtqKs47AfKgdsttTeS/rxoqB9zku+viZICYyFEd7LIufC7kRR/mfVW1rgFjdUBLg7MhKUg56xTYBspKl2rLikl/erC2ylQ7puT8VOADAWPD+ZFNqiIAiLuu12rJcA1W0=</Modulus><Exponent>Dw==</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_2, x.RawData, "RawData");
			Assert.AreEqual ("00", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.4", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("OU=Directory Services, O=AT&T, C=US", x.Subject, "Subject");
			Assert.AreEqual ("OU=Directory Services, O=AT&T, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("9E87803EC5689AEFE77F92F91ABFA7467C76ED02", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (1, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Directory Services", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Directory Services", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");
		}

		[Test]
		public void Certificate_3_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (629771327990000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629749728000000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_3);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (7, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=Brand Name:Product Type, O=CCA - Unique ID, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=Brand Name:Product Type, O=CCA - Unique ID, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>rMQOBSW86u8MIn/EDEppMQD5P+nhbFSXd04YxkqV4NRYKVwXXR0eVrxJPeD5n7sB+Ya2ppXd4QQyAVJOj4Yw9w==</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_3, x.RawData, "RawData");
			Assert.AreEqual ("0353D78BDB3E16158055C4054002734D0C20F80D88005F657AACBA86BD1CD7E4", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.5", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=\"0+WKJx+wYEZabSSPVX9kLsnx92s=\", OU=Issuing Financial Institution, O=BrandID, C=US", x.Subject, "Subject");
			Assert.AreEqual ("CN=\"0+WKJx+wYEZabSSPVX9kLsnx92s=\", OU=Issuing Financial Institution, O=BrandID, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("395FBBFC148933277689B7593A7D1CFFF156F162", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("Brand Name:Product Type", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Brand Name:Product Type", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("0+WKJx+wYEZabSSPVX9kLsnx92s=", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("0+WKJx+wYEZabSSPVX9kLsnx92s=", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.35", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("30-53-81-4B-84-49-31-0B-30-09-06-03-55-04-06-13-02-55-53-31-18-30-16-06-03-55-04-0A-13-0F-43-43-41-20-2D-20-55-6E-69-71-75-65-20-49-44-31-20-30-1E-06-03-55-04-03-13-17-42-72-61-6E-64-20-4E-61-6D-65-3A-50-72-6F-64-75-63-74-20-54-79-70-65-82-04-32-06-AC-10", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsFalse (ext.Critical, "Critical-0");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.15", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("03-02-07-80", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsTrue (ext.Critical, "Critical-1");
			X509KeyUsageExtension kue = (X509KeyUsageExtension) ext;
			Assert.AreEqual (X509KeyUsageFlags.DigitalSignature, kue.KeyUsages, "KeyUsages");
			ext = x.Extensions[2];
			Assert.AreEqual ("2.5.29.16", ext.Oid.Value, "Oid-2");
			Assert.AreEqual ("30-22-80-0F-31-39-39-36-30-38-30-37-30-37-34-39-30-30-5A-81-0F-31-39-39-36-30-39-30-37-30-37-34-39-30-30-5A", BitConverter.ToString (ext.RawData), "RawData-2");
			Assert.IsTrue (ext.Critical, "Critical-2");
			ext = x.Extensions[3];
			Assert.AreEqual ("2.5.29.32", ext.Oid.Value, "Oid-3");
			Assert.AreEqual ("30-0F-30-0D-06-0B-60-86-48-01-86-F8-45-01-07-01-01", BitConverter.ToString (ext.RawData), "RawData-3");
			Assert.IsFalse (ext.Critical, "Critical-3");
			ext = x.Extensions[4];
			Assert.AreEqual ("2.5.29.19", ext.Oid.Value, "Oid-4");
			Assert.AreEqual ("30-00", BitConverter.ToString (ext.RawData), "RawData-4");
			Assert.IsTrue (ext.Critical, "Critical-4");
			X509BasicConstraintsExtension bce = (X509BasicConstraintsExtension) ext;
			Assert.IsFalse (bce.CertificateAuthority, "CertificateAuthority");
			Assert.IsFalse (bce.HasPathLengthConstraint, "HasPathLengthConstraint");
			Assert.AreEqual (0, bce.PathLengthConstraint, "PathLengthConstraint");
			ext = x.Extensions[5];
			Assert.AreEqual ("2.16.840.1.113733.2.3", ext.Oid.Value, "Oid-5");
			Assert.AreEqual ("03-02-07-80", BitConverter.ToString (ext.RawData), "RawData-5");
			Assert.IsTrue (ext.Critical, "Critical-5");
			ext = x.Extensions[6];
			Assert.AreEqual ("2.16.840.1.113733.2.7", ext.Oid.Value, "Oid");
			Assert.AreEqual ("30-50-04-14-33-39-38-32-33-39-38-37-32-33-37-38-39-31-33-34-39-37-38-32-30-09-06-05-2B-0D-03-02-1A-05-00-16-0F-74-65-72-73-65-20-73-74-61-74-65-6D-65-6E-74-1D-00-16-1A-67-65-74-73-65-74-2D-63-65-6E-74-65-72-40-76-65-72-69-73-69-67-6E-2E-63-6F-6D", BitConverter.ToString (ext.RawData), "RawData-6");
			Assert.IsTrue (ext.Critical, "Critical");
		}

		[Test]
		public void Certificate_4_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (630822812570000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629200220570000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_4);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (0, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>ks56wa6DPlqqiYNXrCUBdgytro4sN87rNXhkVAPlhEBRyb+PCOKKggjSFoY3VemxIQKtdmiBmgWiS8lLJWYiVmyIB4/3gVlthAdlcBNxdj6bd0zjUIlWmEi5HacpGhMuShFZnB4V1UlULHM6aYKxlzmcbXBnSOXdLdbIHns=</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_4, x.RawData, "RawData");
			Assert.AreEqual ("0241000001", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.2", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.Subject, "Subject");
			Assert.AreEqual ("OU=Secure Server Certification Authority, O=\"RSA Data Security, Inc.\", C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("0D974461703713CB74932D2A75ACBC714B281266", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (1, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Secure Server Certification Authority", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Secure Server Certification Authority", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");
		}

		[Test]
		public void Certificate_5_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (632254464000000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (630045216000000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_5);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (6, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("O=SET Root, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("O=SET Root, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>1Nw+uuGU977N7SF3z9qIWFEOj/TaABQeDaettpZaxtPsJe3YQwtufz+eHnSgHpd2MMpvCmPAozFAJYC4vSjrfXULTkE0xCAAwsv0miAAWNn0QBMYdwy1BN63tkOLpMw2dnnFCxfLfoihM7DTNCe/O2HaxSDr+ZSai3myqI7LwdmUSplmUFWygyh9Ij3s3KPoOduDVMmJqd9ZUp9673wRYlLs5me6PeqrR9vk9B9zwz3sfoR9Lyn+bBc/dW1WbsBOtb8qIIrkV67ALmjJCc+FdwrvOjfLYExFc3+QPoYd+sP8UIqyxYo08PJD7jxWuiTp4KWHHnwwM3f9XeBXDWwZOQ==</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_5, x.RawData, "RawData");
			Assert.AreEqual ("6A", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.5", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("O=SET Root, C=US", x.Subject, "Subject");
			Assert.AreEqual ("O=SET Root, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("63DB7A42673975392AC6A4FAE3D78446B467C326", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("SET Root", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("SET Root", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.19", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("30-06-01-01-FF-02-01-03", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsTrue (ext.Critical, "Critical-0");
			X509BasicConstraintsExtension bce = (X509BasicConstraintsExtension) ext;
			Assert.IsTrue (bce.CertificateAuthority, "CertificateAuthority");
			Assert.IsTrue (bce.HasPathLengthConstraint, "HasPathLengthConstraint");
			Assert.AreEqual (3, bce.PathLengthConstraint, "PathLengthConstraint");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.32", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-82-02-B9-30-82-02-B5-06-04-67-2A-05-00-30-82-02-AB-30-82-02-A7-06-04-67-2A-07-06-30-82-02-9D-30-82-02-99-1A-82-02-95-54-68-69-73-20-53-45-54-20-52-6F-6F-74-20-43-65-72-74-69-66-69-63-61-74-65-20-61-6E-64-20-61-6E-79-20-63-65-72-74-69-66-69-63-61-74-65-20-61-75-74-68-65-6E-74-69-63-61-74-65-64-20-64-69-72-65-63-74-6C-79-20-6F-72-20-69-6E-64-69-72-65-63-74-6C-79-20-62-79-20-74-68-69-73-20-63-65-72-74-69-66-69-63-61-74-65-2C-20-6D-61-79-20-6F-6E-6C-79-20-62-65-20-75-73-65-64-20-74-6F-20-65-6E-61-62-6C-65-20-22-53-65-63-75-72-65-20-46-69-6E-61-6E-63-69-61-6C-20-54-72-61-6E-73-61-63-74-69-6F-6E-73-22-20-61-73-20-64-65-66-69-6E-65-64-20-69-6E-20-74-68-65-20-53-45-54-20-52-6F-6F-74-20-43-65-72-74-69-66-69-63-61-74-65-20-50-72-61-63-74-69-63-65-20-53-74-61-74-65-6D-65-6E-74-20-61-6E-64-2C-20-77-68-65-6E-20-61-70-70-72-6F-70-72-69-61-74-65-2C-20-69-6E-20-61-20-53-45-54-20-42-72-61-6E-64-20-43-65-72-74-69-66-69-63-61-74-65-20-50-72-61-63-74-69-63-65-20-53-74-61-74-65-6D-65-6E-74-2E-20-20-4E-6F-20-50-61-72-74-79-20-6D-61-79-20-72-65-6C-79-20-75-70-6F-6E-20-74-68-65-20-53-45-54-20-52-6F-6F-74-20-43-65-72-74-69-66-69-63-61-74-65-20-66-6F-72-20-61-6E-79-20-6F-74-68-65-72-20-70-75-72-70-6F-73-65-2E-20-20-41-20-53-45-54-20-42-72-61-6E-64-20-73-68-61-6C-6C-20-62-65-20-61-6E-79-20-70-61-79-6D-65-6E-74-20-62-72-61-6E-64-20-77-68-6F-73-65-20-53-45-54-20-63-65-72-74-69-66-69-63-61-74-65-20-69-73-20-73-69-67-6E-65-64-20-62-79-20-74-68-65-20-70-72-69-76-61-74-65-20-6B-65-79-20-63-6F-72-72-65-73-70-6F-6E-64-69-6E-67-20-74-6F-20-74-68-65-20-70-75-62-6C-69-63-20-6B-65-79-20-63-6F-6E-74-61-69-6E-65-64-20-69-6E-20-74-68-69-73-20-63-65-72-74-69-66-69-63-61-74-65-2E-20-20-41-6C-6C-20-6D-61-74-74-65-72-73-20-72-65-6C-61-74-69-6E-67-20-74-6F-20-75-73-61-67-65-2C-20-6C-69-61-62-69-6C-69-74-79-20-61-6E-64-20-70-72-6F-63-65-64-75-72-65-73-20-77-69-74-68-20-53-45-54-20-63-65-72-74-69-66-69-63-61-74-65-73-20-69-73-73-75-65-64-20-62-65-6E-65-61-74-68-20-61-20-53-45-54-20-42-72-61-6E-64-20-73-68-61-6C-6C-20-62-65-20-64-65-74-65-72-6D-69-6E-65-64-20-62-79-20-74-68-61-74-20-53-45-54-20-42-72-61-6E-64-2E", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsTrue (ext.Critical, "Critical-1");
			ext = x.Extensions[2];
			Assert.AreEqual ("2.5.29.15", ext.Oid.Value, "Oid-2");
			Assert.AreEqual ("03-02-01-06", BitConverter.ToString (ext.RawData), "RawData-2");
			Assert.IsTrue (ext.Critical, "Critical-2");
			X509KeyUsageExtension kue = (X509KeyUsageExtension) ext;
			Assert.AreEqual (X509KeyUsageFlags.CrlSign | X509KeyUsageFlags.KeyCertSign, kue.KeyUsages, "KeyUsages");
			ext = x.Extensions[3];
			Assert.AreEqual ("2.5.29.16", ext.Oid.Value, "Oid-3");
			Assert.AreEqual ("30-22-80-0F-31-39-39-37-30-37-31-35-30-30-30-30-30-30-5A-81-0F-31-39-39-38-30-37-31-35-30-30-30-30-30-30-5A", BitConverter.ToString (ext.RawData), "RawData-3");
			Assert.IsFalse (ext.Critical, "Critical-3");
			ext = x.Extensions[4];
			Assert.AreEqual ("2.23.42.7.1", ext.Oid.Value, "Oid-4");
			Assert.AreEqual ("03-03-07-00-80", BitConverter.ToString (ext.RawData), "RawData-4");
			Assert.IsTrue (ext.Critical, "Critical-4");
			ext = x.Extensions[5];
			Assert.AreEqual ("2.23.42.7.0", ext.Oid.Value, "Oid-5");
			Assert.AreEqual ("30-2F-30-2D-02-01-00-30-09-06-05-2B-0E-03-02-1A-05-00-30-07-06-05-67-2A-03-00-00-04-14-C8-57-44-4F-D7-91-56-3E-C6-F3-E0-E6-08-2E-9A-AF-61-11-43-5D", BitConverter.ToString (ext.RawData), "RawData-5");
			Assert.IsTrue (ext.Critical, "Critical-5");
		}

		[Test]
		public void Certificate_8_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (631769760000000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (631080288000000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_8);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (2, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<DSAKeyValue><P>kIk+GBv+ox0WiQC01UCCTC7sPWYNDbkXQG46XAN7G5MoDO+5l+Oh6+KjfGHdb9WtFWkAFrLDCD3EWcbycKWw9R8d9LAV2n4oOSSZNlvsOSX6kkll0kMFap6je/Deoy/Tbzr5NcMp1EVsVpreNm7+EmiWe0UdLP+5LfVSjN8+L2M=</P><Q>gam10ATym6fYVUw7MqFFMk/1Ud0=</Q><G>ZHqIC/I+kYFZnPTqxnsOvuoF6Hf9IDSHocRp9siLGdrN+iGKV6l6JgpW1O1LG3xw7bTmemre0yni6Zoz7QmNnt/aLkrBUJLuL+Va84ViakjcGwKYprDRCUsQ0fD64LEdE1RLwKhA73HoVmuiKcseCX0nOZE7IE+YOeg5ypjFr1Q=</G><Y>VKiItY8BVs4Yj6bWfCkpdUXoMaQHF+0eXbJ7u848l2ceiAr+fQAiJx1m7vYbtpV/Wv8GNAJDw4PEZiyhBQ5os8rc0/kMwGbfhYRLIF1BrMDsN5IOlxm/UzVjJxgzNUJN8C1tp6SYqlfz0rhuTo//vm9ODwtEJO7fTCJbRJiUy7g=</Y></DSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_8, x.RawData, "RawData");
			Assert.AreEqual ("03", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.10040.4.3", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x.Subject, "Subject");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("A30A06B1B0D4F871678A60C54EE4D8663606CCE6", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("Armed Forces Root", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Armed Forces Root", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("Armed Forces Root", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Armed Forces Root", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.14", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("04-14-9D-2D-73-C3-B8-E3-4D-29-28-C3-65-BE-A9-98-CB-D6-8A-06-68-9C", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsFalse (ext.Critical, "Critical-0");
			X509SubjectKeyIdentifierExtension ski = (X509SubjectKeyIdentifierExtension) ext;
			Assert.AreEqual ("9D2D73C3B8E34D2928C365BEA998CBD68A06689C", ski.SubjectKeyIdentifier, "SubjectKeyIdentifier");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.19", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-03-01-01-FF", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsFalse (ext.Critical, "Critical-1");
			X509BasicConstraintsExtension bce = (X509BasicConstraintsExtension) ext;
			Assert.IsTrue (bce.CertificateAuthority, "CertificateAuthority");
			Assert.IsFalse (bce.HasPathLengthConstraint, "HasPathLengthConstraint");
			Assert.AreEqual (0, bce.PathLengthConstraint, "PathLengthConstraint");
		}

		[Test]
		public void Certificate_9_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (630077183990000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629761824000000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_9);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (5, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("OU=VeriSign Class 1 CA - Individual Subscriber, O=\"VeriSign, Inc.\", L=Internet", x.Issuer, "Issuer");
			Assert.AreEqual ("OU=VeriSign Class 1 CA - Individual Subscriber, O=\"VeriSign, Inc.\", L=Internet", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>xYEHousPuP/4+BzuMv+/EjVq+WvIvi/7Pq8EUUqs3RApqM1AW2YemO/yTHf6j4bRIWeSRErEicmDz4ifb+IyNQ==</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_9, x.RawData, "RawData");
			Assert.AreEqual ("200B355ECEC4B063B7DEC634B9703444", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.4", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("E=david@formal.ie, CN=David T. Gray, OU=Digital ID Class 1 - Netscape, OU=\"www.verisign.com/repository/CPS Incorp. by Ref.,LIAB.LTD(c)96\", OU=VeriSign Class 1 CA - Individual Subscriber, O=\"VeriSign, Inc.\", L=Internet", x.Subject, "Subject");
			Assert.AreEqual ("E=david@formal.ie, CN=David T. Gray, OU=Digital ID Class 1 - Netscape, OU=\"www.verisign.com/repository/CPS Incorp. by Ref.,LIAB.LTD(c)96\", OU=VeriSign Class 1 CA - Individual Subscriber, O=\"VeriSign, Inc.\", L=Internet", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("52D1848F6A161BA5C6C19007F8164668F5A3B2CF", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("VeriSign Class 1 CA - Individual Subscriber", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("David T. Gray", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual ("david@formal.ie", x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("David T. Gray", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.19", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("30-00", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsFalse (ext.Critical, "Critical-0");
			X509BasicConstraintsExtension bce = (X509BasicConstraintsExtension) ext;
			Assert.IsFalse (bce.CertificateAuthority, "CertificateAuthority");
			Assert.IsFalse (bce.HasPathLengthConstraint, "HasPathLengthConstraint");
			Assert.AreEqual (0, bce.PathLengthConstraint, "PathLengthConstraint");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.3", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-82-02-12-30-82-02-0E-30-82-02-0A-06-0B-60-86-48-01-86-F8-45-01-07-01-01-30-82-01-F9-16-82-01-A7-54-68-69-73-20-63-65-72-74-69-66-69-63-61-74-65-20-69-6E-63-6F-72-70-6F-72-61-74-65-73-20-62-79-20-72-65-66-65-72-65-6E-63-65-2C-20-61-6E-64-20-69-74-73-20-75-73-65-20-69-73-20-73-74-72-69-63-74-6C-79-20-73-75-62-6A-65-63-74-20-74-6F-2C-20-74-68-65-20-56-65-72-69-53-69-67-6E-20-43-65-72-74-69-66-69-63-61-74-69-6F-6E-20-50-72-61-63-74-69-63-65-20-53-74-61-74-65-6D-65-6E-74-20-28-43-50-53-29-2C-20-61-76-61-69-6C-61-62-6C-65-20-61-74-3A-20-68-74-74-70-73-3A-2F-2F-77-77-77-2E-76-65-72-69-73-69-67-6E-2E-63-6F-6D-2F-43-50-53-3B-20-62-79-20-45-2D-6D-61-69-6C-20-61-74-20-43-50-53-2D-72-65-71-75-65-73-74-73-40-76-65-72-69-73-69-67-6E-2E-63-6F-6D-3B-20-6F-72-20-62-79-20-6D-61-69-6C-20-61-74-20-56-65-72-69-53-69-67-6E-2C-20-49-6E-63-2E-2C-20-32-35-39-33-20-43-6F-61-73-74-20-41-76-65-2E-2C-20-4D-6F-75-6E-74-61-69-6E-20-56-69-65-77-2C-20-43-41-20-39-34-30-34-33-20-55-53-41-20-54-65-6C-2E-20-2B-31-20-28-34-31-35-29-20-39-36-31-2D-38-38-33-30-20-43-6F-70-79-72-69-67-68-74-20-28-63-29-20-31-39-39-36-20-56-65-72-69-53-69-67-6E-2C-20-49-6E-63-2E-20-20-41-6C-6C-20-52-69-67-68-74-73-20-52-65-73-65-72-76-65-64-2E-20-43-45-52-54-41-49-4E-20-57-41-52-52-41-4E-54-49-45-53-20-44-49-53-43-4C-41-49-4D-45-44-20-61-6E-64-20-4C-49-41-42-49-4C-49-54-59-20-4C-49-4D-49-54-45-44-2E-A0-0E-06-0C-60-86-48-01-86-F8-45-01-07-01-01-01-A1-0E-06-0C-60-86-48-01-86-F8-45-01-07-01-01-02-30-2C-30-2A-16-28-68-74-74-70-73-3A-2F-2F-77-77-77-2E-76-65-72-69-73-69-67-6E-2E-63-6F-6D-2F-72-65-70-6F-73-69-74-6F-72-79-2F-43-50-53-20", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsFalse (ext.Critical, "Critical-1");
			ext = x.Extensions[2];
			Assert.AreEqual ("2.16.840.1.113730.1.1", ext.Oid.Value, "Oid-2");
			Assert.AreEqual ("03-02-07-80", BitConverter.ToString (ext.RawData), "RawData-2");
			Assert.IsFalse (ext.Critical, "Critical-2");
			ext = x.Extensions[3];
			Assert.AreEqual ("2.16.840.1.113730.1.8", ext.Oid.Value, "Oid-3");
			Assert.AreEqual ("16-27-68-74-74-70-73-3A-2F-2F-77-77-77-2E-76-65-72-69-73-69-67-6E-2E-63-6F-6D-2F-72-65-70-6F-73-69-74-6F-72-79-2F-43-50-53", BitConverter.ToString (ext.RawData), "RawData-3");
			Assert.IsFalse (ext.Critical, "Critical-3");
			ext = x.Extensions[4];
			Assert.AreEqual ("2.16.840.1.113730.1.13", ext.Oid.Value, "Oid-4");
			Assert.AreEqual ("16-82-04-74-43-41-55-54-49-4F-4E-3A-20-54-68-65-20-43-6F-6D-6D-6F-6E-20-4E-61-6D-65-20-69-6E-20-74-68-69-73-20-43-6C-61-73-73-20-31-20-44-69-67-69-74-61-6C-20-0A-49-44-20-69-73-20-6E-6F-74-20-61-75-74-68-65-6E-74-69-63-61-74-65-64-20-62-79-20-56-65-72-69-53-69-67-6E-2E-20-49-74-20-6D-61-79-20-62-65-20-74-68-65-0A-68-6F-6C-64-65-72-27-73-20-72-65-61-6C-20-6E-61-6D-65-20-6F-72-20-61-6E-20-61-6C-69-61-73-2E-20-56-65-72-69-53-69-67-6E-20-64-6F-65-73-20-61-75-74-68-2D-0A-65-6E-74-69-63-61-74-65-20-74-68-65-20-65-2D-6D-61-69-6C-20-61-64-64-72-65-73-73-20-6F-66-20-74-68-65-20-68-6F-6C-64-65-72-2E-0A-0A-54-68-69-73-20-63-65-72-74-69-66-69-63-61-74-65-20-69-6E-63-6F-72-70-6F-72-61-74-65-73-20-62-79-20-72-65-66-65-72-65-6E-63-65-2C-20-61-6E-64-20-0A-69-74-73-20-75-73-65-20-69-73-20-73-74-72-69-63-74-6C-79-20-73-75-62-6A-65-63-74-20-74-6F-2C-20-74-68-65-20-56-65-72-69-53-69-67-6E-20-0A-43-65-72-74-69-66-69-63-61-74-69-6F-6E-20-50-72-61-63-74-69-63-65-20-53-74-61-74-65-6D-65-6E-74-20-28-43-50-53-29-2C-20-61-76-61-69-6C-61-62-6C-65-0A-69-6E-20-74-68-65-20-56-65-72-69-53-69-67-6E-20-72-65-70-6F-73-69-74-6F-72-79-20-61-74-3A-20-0A-68-74-74-70-73-3A-2F-2F-77-77-77-2E-76-65-72-69-73-69-67-6E-2E-63-6F-6D-3B-20-62-79-20-45-2D-6D-61-69-6C-20-61-74-0A-43-50-53-2D-72-65-71-75-65-73-74-73-40-76-65-72-69-73-69-67-6E-2E-63-6F-6D-3B-20-6F-72-20-62-79-20-6D-61-69-6C-20-61-74-20-56-65-72-69-53-69-67-6E-2C-0A-49-6E-63-2E-2C-20-32-35-39-33-20-43-6F-61-73-74-20-41-76-65-2E-2C-20-4D-6F-75-6E-74-61-69-6E-20-56-69-65-77-2C-20-43-41-20-39-34-30-34-33-20-55-53-41-0A-0A-43-6F-70-79-72-69-67-68-74-20-28-63-29-31-39-39-36-20-56-65-72-69-53-69-67-6E-2C-20-49-6E-63-2E-20-20-41-6C-6C-20-52-69-67-68-74-73-20-0A-52-65-73-65-72-76-65-64-2E-20-43-45-52-54-41-49-4E-20-57-41-52-52-41-4E-54-49-45-53-20-44-49-53-43-4C-41-49-4D-45-44-20-41-4E-44-20-0A-4C-49-41-42-49-4C-49-54-59-20-4C-49-4D-49-54-45-44-2E-0A-0A-57-41-52-4E-49-4E-47-3A-20-54-48-45-20-55-53-45-20-4F-46-20-54-48-49-53-20-43-45-52-54-49-46-49-43-41-54-45-20-49-53-20-53-54-52-49-43-54-4C-59-0A-53-55-42-4A-45-43-54-20-54-4F-20-54-48-45-20-56-45-52-49-53-49-47-4E-20-43-45-52-54-49-46-49-43-41-54-49-4F-4E-20-50-52-41-43-54-49-43-45-0A-53-54-41-54-45-4D-45-4E-54-2E-20-20-54-48-45-20-49-53-53-55-49-4E-47-20-41-55-54-48-4F-52-49-54-59-20-44-49-53-43-4C-41-49-4D-53-20-43-45-52-54-41-49-4E-0A-49-4D-50-4C-49-45-44-20-41-4E-44-20-45-58-50-52-45-53-53-20-57-41-52-52-41-4E-54-49-45-53-2C-20-49-4E-43-4C-55-44-49-4E-47-20-57-41-52-52-41-4E-54-49-45-53-0A-4F-46-20-4D-45-52-43-48-41-4E-54-41-42-49-4C-49-54-59-20-4F-52-20-46-49-54-4E-45-53-53-20-46-4F-52-20-41-20-50-41-52-54-49-43-55-4C-41-52-0A-50-55-52-50-4F-53-45-2C-20-41-4E-44-20-57-49-4C-4C-20-4E-4F-54-20-42-45-20-4C-49-41-42-4C-45-20-46-4F-52-20-43-4F-4E-53-45-51-55-45-4E-54-49-41-4C-2C-0A-50-55-4E-49-54-49-56-45-2C-20-41-4E-44-20-43-45-52-54-41-49-4E-20-4F-54-48-45-52-20-44-41-4D-41-47-45-53-2E-20-53-45-45-20-54-48-45-20-43-50-53-0A-46-4F-52-20-44-45-54-41-49-4C-53-2E-0A-0A-43-6F-6E-74-65-6E-74-73-20-6F-66-20-74-68-65-20-56-65-72-69-53-69-67-6E-20-72-65-67-69-73-74-65-72-65-64-0A-6E-6F-6E-76-65-72-69-66-69-65-64-53-75-62-6A-65-63-74-41-74-74-72-69-62-75-74-65-73-20-65-78-74-65-6E-73-69-6F-6E-20-76-61-6C-75-65-20-73-68-61-6C-6C-20-0A-6E-6F-74-20-62-65-20-63-6F-6E-73-69-64-65-72-65-64-20-61-73-20-61-63-63-75-72-61-74-65-20-69-6E-66-6F-72-6D-61-74-69-6F-6E-20-76-61-6C-69-64-61-74-65-64-20-0A-62-79-20-74-68-65-20-49-41-2E", BitConverter.ToString (ext.RawData), "RawData-4");
			Assert.IsFalse (ext.Critical, "Critical-4");
		}

		[Test]
		public void Certificate_10_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (630616320000000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (629670240000000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_10);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (0, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("OID.1.3.6.1.4.1.42.2.11.2.1=keywitness@keywitness.ca, CN=Keywitness Canada Inc., C=CA", x.Issuer, "Issuer");
			Assert.AreEqual ("OID.1.3.6.1.4.1.42.2.11.2.1=keywitness@keywitness.ca, CN=Keywitness Canada Inc., C=CA", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>zSP6KuHtmPTp0JM+13qAAkzMwQKvXLYff/pXQm8w0SDFtSEHQCyphsLzZISuPYUu7YW9VLAYKO9q+BvnCxYfkyVPx/iOw7nKmIQOVdAv73h3xXIoX2C/GSvRcqK32D/glzRaAb0EnMh4Rc2TjRXydhARq7hbLp5S3YE+nGTIKZM=</Modulus><Exponent>Aw==</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_10, x.RawData, "RawData");
			Assert.AreEqual ("14", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.4", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("OID.1.3.6.1.4.1.42.2.11.2.1=keywitness@keywitness.ca, CN=Keywitness Canada Inc., C=CA", x.Subject, "Subject");
			Assert.AreEqual ("OID.1.3.6.1.4.1.42.2.11.2.1=keywitness@keywitness.ca, CN=Keywitness Canada Inc., C=CA", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("E0A00ABEB2CCA84540C21A75E0B3A406F9A624AC", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (1, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("Keywitness Canada Inc.", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Keywitness Canada Inc.", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("Keywitness Canada Inc.", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Keywitness Canada Inc.", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");
		}

		[Test]
		public void Certificate_12_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (632053191480000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (631578849480000000,
				DateTimeKind.Utc);

			X509Certificate2 x = new X509Certificate2 (cert_12);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (5, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=Microsoft Code Signing PCA, OU=Copyright (c) 2000 Microsoft Corp., O=Microsoft Corporation, L=Redmond, S=Washington, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=Microsoft Code Signing PCA, OU=Copyright (c) 2000 Microsoft Corp., O=Microsoft Corporation, L=Redmond, S=Washington, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>qpm9OagYJ/QrPQtMP3x3LqfLtdGMDcI6dNeTteCgSz9ZXs5FT5p5KfFJzBpH7lXCCD4SIPhV8u5f0+DKlrww3v5YyCcy0IVU6PCRELvzK74Z5QObC4Yd87A5jLj9Cx08cyasVyvKKaIVkIIV4nejQFIDi53CcLof6TT28zWSTlWD+NowtiDeVwa1WkIG3lnL8t+mvRVHcRklI9LLb5sZed9qW/F2BXkp/MNWyo9ECIVVisvID0ZLVcuMlndKh+ipQQbH/w3paFdjcsNpV7RDzzI6MNwb6dVDJip5/pXbImckyS/QNOPm+1FJhrg80CVf1uyeA2GHqWhAx/jiA+bPBQ==</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_12, x.RawData, "RawData");
			Assert.AreEqual ("61071143000000000034", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.113549.1.1.5", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=Microsoft Corporation, OU=Copyright (c) 2002 Microsoft Corp., O=Microsoft Corporation, L=Redmond, S=Washington, C=US", x.Subject, "Subject");
			Assert.AreEqual ("CN=Microsoft Corporation, OU=Copyright (c) 2002 Microsoft Corp., O=Microsoft Corporation, L=Redmond, S=Washington, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("282D9806C3DF7345929F64F5895EF2EA4AC29302", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("Microsoft Code Signing PCA", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Microsoft Code Signing PCA", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("Microsoft Corporation", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("Microsoft Corporation", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.15", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("03-02-06-C0", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsTrue (ext.Critical, "Critical-0");
			X509KeyUsageExtension kue = (X509KeyUsageExtension) ext;
			Assert.AreEqual (X509KeyUsageFlags.DigitalSignature | X509KeyUsageFlags.NonRepudiation, kue.KeyUsages, "KeyUsages");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.37", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-0A-06-08-2B-06-01-05-05-07-03-03", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsFalse (ext.Critical, "Critical-1");
			X509EnhancedKeyUsageExtension eku = (X509EnhancedKeyUsageExtension) ext;
			Assert.AreEqual (1, eku.EnhancedKeyUsages.Count, "EnhancedKeyUsages.Count");
			Assert.AreEqual ("1.3.6.1.5.5.7.3.3", eku.EnhancedKeyUsages[0].Value, "EnhancedKeyUsages[0]");
			ext = x.Extensions[2];
			Assert.AreEqual ("2.5.29.14", ext.Oid.Value, "Oid-2");
			Assert.AreEqual ("04-14-6B-C8-C6-51-20-F0-B4-2F-D3-A0-B6-AE-7F-5E-26-B2-B8-87-52-29", BitConverter.ToString (ext.RawData), "RawData-2");
			Assert.IsFalse (ext.Critical, "Critical-2");
			X509SubjectKeyIdentifierExtension ski = (X509SubjectKeyIdentifierExtension) ext;
			Assert.AreEqual ("6BC8C65120F0B42FD3A0B6AE7F5E26B2B8875229", ski.SubjectKeyIdentifier, "SubjectKeyIdentifier");
			ext = x.Extensions[3];
			Assert.AreEqual ("2.5.29.35", ext.Oid.Value, "Oid-3");
			Assert.AreEqual ("30-81-9E-80-14-29-5C-B9-1B-B6-CD-33-EE-BB-9E-59-7D-F7-E5-CA-2E-C4-0D-34-28-A1-74-A4-72-30-70-31-2B-30-29-06-03-55-04-0B-13-22-43-6F-70-79-72-69-67-68-74-20-28-63-29-20-31-39-39-37-20-4D-69-63-72-6F-73-6F-66-74-20-43-6F-72-70-2E-31-1E-30-1C-06-03-55-04-0B-13-15-4D-69-63-72-6F-73-6F-66-74-20-43-6F-72-70-6F-72-61-74-69-6F-6E-31-21-30-1F-06-03-55-04-03-13-18-4D-69-63-72-6F-73-6F-66-74-20-52-6F-6F-74-20-41-75-74-68-6F-72-69-74-79-82-10-6A-0B-99-4F-C0-00-DE-AA-11-D4-D8-40-9A-A8-BE-E6", BitConverter.ToString (ext.RawData), "RawData-3");
			Assert.IsFalse (ext.Critical, "Critical-3");
			ext = x.Extensions[4];
			Assert.AreEqual ("2.5.29.31", ext.Oid.Value, "Oid-4");
			Assert.AreEqual ("30-41-30-3F-A0-3D-A0-3B-86-39-68-74-74-70-3A-2F-2F-63-72-6C-2E-6D-69-63-72-6F-73-6F-66-74-2E-63-6F-6D-2F-70-6B-69-2F-63-72-6C-2F-70-72-6F-64-75-63-74-73-2F-43-6F-64-65-53-69-67-6E-50-43-41-2E-63-72-6C", BitConverter.ToString (ext.RawData), "RawData-4");
			Assert.IsFalse (ext.Critical, "Critical-4");
		}

		[Test]
		public void Certificate_13_Properties ()
		{
			DateTime expectedNotAfter = new DateTime (634388218400000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (631232890400000000,
				DateTimeKind.Utc);

			// DSA without parameters
			X509Certificate2 x = new X509Certificate2 (cert_13);
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (5, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=DSA CA, O=Test Certificates, C=US", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=DSA CA, O=Test Certificates, C=US", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			// note: this test will work if PKITS data is installed
			// Assert.AreEqual ("<DSAKeyValue><P>3+URPtrptm4Q1uqd4p06sEe9RADHVsjMbtAzhFZHNT32VMjjwq27unXzLzMMpvkx7Gfj5Zlt/CluqleIcjTijgCQ4KOsZI7A9jwdj7TISkgwXn+qnHYmC9sTczODl8DFs+Y39T7/FQ3UoS66Mfirh9gLzHeYQm6sk5jCvS57NAs=</P><Q>zwYE2P+L6wDp9lwHlnP9lmU6Lwc=</Q><G>zOF8sM6SX2PsOLtEut2SNLZevmV72HF3BJ3sZnw7BM6281L+D5JVAu9OEqtdmi4vblbzcOxq7ZsiuKgTywycFurBCo4hJkSlDPmg7GLgcDHMaPULhaRKG2559MH5Nlo4b07vhFPfZ/3M91lij5yczRCPXKQPnLcH7GDzvq9+OZg=</G><Y>Z4xH2gw2gWQ5+Bo3C/C71BP9Zz1AyJyS4TqJVLDyl6Vw0GQXpKd8qeknCWXfoKUc/ATaPt1ia/AM7YFXT10pyAhZGQxfjYjw/4y26HUBvhAKZN9Xe4tsVvBTzkOIuQmZCDyQrwHo2TJd7VYCz2DSATrjCiuekUH2x3zebJljAA4=</Y></DSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (cert_13, x.RawData, "RawData");
			Assert.AreEqual ("02", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.2.840.10040.4.3", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=DSA Parameters Inherited CA, O=Test Certificates, C=US", x.Subject, "Subject");
			Assert.AreEqual ("CN=DSA Parameters Inherited CA, O=Test Certificates, C=US", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("0E29CDDCA5E732A20DCED87B3D002446853EBBD1", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("DSA CA", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("DSA CA", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("DSA Parameters Inherited CA", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("DSA Parameters Inherited CA", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.14", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("04-14-5D-24-EE-8A-55-1A-F2-C6-C9-B2-C2-BF-8A-F0-B2-49-4F-3A-B3-1B", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsFalse (ext.Critical, "Critical-0");
			X509SubjectKeyIdentifierExtension ski = (X509SubjectKeyIdentifierExtension) ext;
			Assert.AreEqual ("5D24EE8A551AF2C6C9B2C2BF8AF0B2494F3AB31B", ski.SubjectKeyIdentifier, "SubjectKeyIdentifier");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.35", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-16-80-14-74-15-D5-24-1C-BD-5E-65-88-1F-E1-8B-09-7E-7F-EA-19-48-4E-61", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsFalse (ext.Critical, "Critical-1");
			ext = x.Extensions[2];
			Assert.AreEqual ("2.5.29.32", ext.Oid.Value, "Oid-2");
			Assert.AreEqual ("30-0E-30-0C-06-0A-60-86-48-01-65-03-02-01-30-01", BitConverter.ToString (ext.RawData), "RawData-2");
			Assert.IsFalse (ext.Critical, "Critical-2");
			ext = x.Extensions[3];
			Assert.AreEqual ("2.5.29.15", ext.Oid.Value, "Oid-3");
			Assert.AreEqual ("03-02-01-06", BitConverter.ToString (ext.RawData), "RawData-3");
			Assert.IsTrue (ext.Critical, "Critical-3");
			X509KeyUsageExtension kue = (X509KeyUsageExtension) ext;
			Assert.AreEqual (X509KeyUsageFlags.CrlSign | X509KeyUsageFlags.KeyCertSign, kue.KeyUsages, "KeyUsages");
			ext = x.Extensions[4];
			Assert.AreEqual ("2.5.29.19", ext.Oid.Value, "Oid-4");
			Assert.AreEqual ("30-03-01-01-FF", BitConverter.ToString (ext.RawData), "RawData-4");
			Assert.IsTrue (ext.Critical, "Critical-4");
			X509BasicConstraintsExtension bce = (X509BasicConstraintsExtension) ext;
			Assert.IsTrue (bce.CertificateAuthority, "CertificateAuthority");
			Assert.IsFalse (bce.HasPathLengthConstraint, "HasPathLengthConstraint");
			Assert.AreEqual (0, bce.PathLengthConstraint, "PathLengthConstraint");
		}

#if false
		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Certificate_13_PublicKey ()
		{
			X509Certificate2 x = new X509Certificate2 (cert_13);
			// note: this test will work if PKITS data is installed
			Assert.IsNotNull (x.PublicKey);
		}
#endif

		private void CheckPkcs12 (X509Certificate2 x)
		{
			byte[] raw = new byte[] { 0x30, 0x82, 0x02, 0x1E, 0x30, 0x82, 0x01, 0x8B, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0x74, 0x8B, 0xCD, 0xD9, 0x86, 0x99, 0x9A, 0x91, 0x4A, 0x0C, 0xC3, 0xF4, 0xE1, 0x2F, 0xF5, 0x95, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x30, 0x23, 0x31, 0x21, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x18, 0x4D, 0x6F, 0x6E, 0x6F, 0x20, 0x53, 0x53, 0x4C, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6D, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x20, 
				0x43, 0x41, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x33, 0x31, 0x31, 0x32, 0x37, 0x30, 0x32, 0x35, 0x37, 0x34, 0x32, 0x5A, 0x17, 0x0D, 0x33, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5A, 0x30, 0x13, 0x31, 0x11, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x08, 0x46, 0x41, 0x52, 0x53, 0x43, 0x41, 0x50, 0x45, 0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8D, 0x00, 0x30, 0x81, 0x89, 
				0x02, 0x81, 0x81, 0x00, 0xC4, 0x26, 0x3B, 0xE9, 0x49, 0x07, 0x39, 0x8C, 0x51, 0x34, 0x3B, 0x84, 0x4C, 0x27, 0x98, 0x70, 0x15, 0x79, 0xF1, 0xF4, 0x2A, 0x32, 0x82, 0xC3, 0xFA, 0xCF, 0x6E, 0x72, 0x37, 0xCE, 0x37, 0x55, 0x1F, 0xFA, 0x8F, 0x78, 0x4A, 0xA0, 0x0C, 0x9D, 0x44, 0x29, 0xF2, 0x81, 0xD9, 0x87, 0xD5, 0x94, 0x1A, 0xFC, 0x8D, 0xF8, 0x9D, 0xE0, 0xC5, 0xD2, 0x4A, 0x4F, 0x68, 0xD3, 0xAD, 0x65, 0x23, 0xB2, 0x4F, 0x48, 0x35, 0xB9, 0xFE, 0xE1, 0xDB, 0x6B, 0xE7, 0x41, 0x76, 0xEC, 
				0x0C, 0x5B, 0x3A, 0xE3, 0x07, 0xC9, 0x3D, 0x94, 0x48, 0xF2, 0xCF, 0x71, 0xAC, 0x2F, 0x71, 0x60, 0x15, 0x0E, 0xD5, 0x9A, 0xF8, 0x6C, 0x7F, 0xE9, 0xC0, 0x19, 0x18, 0x72, 0x09, 0xA1, 0xD6, 0xB8, 0xA9, 0x60, 0xD1, 0xC3, 0x18, 0x91, 0x98, 0xCE, 0x9A, 0x44, 0x3D, 0xCF, 0x63, 0x79, 0x41, 0x27, 0x18, 0xB3, 0x8E, 0x05, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x6B, 0x30, 0x69, 0x30, 0x13, 0x06, 0x03, 0x55, 0x1D, 0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 
				0x03, 0x01, 0x30, 0x52, 0x06, 0x03, 0x55, 0x1D, 0x01, 0x04, 0x4B, 0x30, 0x49, 0x80, 0x10, 0x7C, 0x13, 0x05, 0xC9, 0xB9, 0x5A, 0xA3, 0x19, 0x3E, 0x7C, 0x0D, 0x7C, 0xE3, 0xF2, 0xD3, 0x36, 0xA1, 0x23, 0x30, 0x21, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x16, 0x4D, 0x6F, 0x6E, 0x6F, 0x20, 0x55, 0x6E, 0x69, 0x74, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x20, 0x43, 0x41, 0x82, 0x10, 0x1B, 0xFC, 0x61, 0x41, 0xD0, 0xCF, 0x41, 0xB9, 0x47, 0xEF, 
				0x21, 0x7D, 0x6A, 0x53, 0x32, 0x76, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x94, 0xF8, 0xDA, 0xEF, 0x93, 0x6A, 0x23, 0x04, 0x6B, 0x2D, 0xC3, 0x1E, 0x57, 0xC9, 0x7E, 0xE1, 0xF6, 0x6C, 0x55, 0xB6, 0xAC, 0xAB, 0xA8, 0x67, 0x19, 0xCD, 0x1D, 0x32, 0x1C, 0xD7, 0x63, 0x13, 0x4F, 0x41, 0x85, 0xB0, 0x62, 0xB8, 0x04, 0x38, 0xD0, 0xD8, 0x18, 0x36, 0x80, 0xE2, 0x70, 0xE7, 0x11, 0x05, 0x7A, 0x2D, 0x5D, 0xC8, 0xAD, 0x29, 0x2E, 0x05, 0x54, 
				0x66, 0xE2, 0x8E, 0xCC, 0xDA, 0xEE, 0x19, 0x10, 0xB9, 0x37, 0x30, 0x83, 0x62, 0x9A, 0x10, 0xDB, 0x19, 0x41, 0x57, 0x37, 0x1A, 0x39, 0x54, 0x59, 0xE6, 0x6D, 0xDF, 0x1B, 0xCE, 0x6E, 0x78, 0x6A, 0x5F, 0x06, 0x26, 0x8D, 0xE0, 0x94, 0x52, 0xF4, 0x86, 0x9C, 0x42, 0x58, 0xF0, 0xEB, 0x71, 0xEB, 0xB8, 0x8E, 0xC9, 0x20, 0x84, 0xD5, 0x11, 0x58, 0x40, 0x4A, 0xE9, 0xD1, 0x8E, 0x2F, 0x9D, 0xD9, 0x8B, 0xD0, 0x55, 0xB8, 0x96 };
			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (2, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsTrue (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=Mono SSL Intermediate CA", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=Mono SSL Intermediate CA", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (643445855990000000, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter");
			Assert.AreEqual (632054986620000000, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore");
			//Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>xCY76UkHOYxRNDuETCeYcBV58fQqMoLD+s9ucjfON1Uf+o94SqAMnUQp8oHZh9WUGvyN+J3gxdJKT2jTrWUjsk9INbn+4dtr50F27AxbOuMHyT2USPLPcawvcWAVDtWa+Gx/6cAZGHIJoda4qWDRwxiRmM6aRD3PY3lBJxizjgU=</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (raw, x.RawData, "RawData");
			Assert.AreEqual ("748BCDD986999A914A0CC3F4E12FF595", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.3.14.3.2.29", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=FARSCAPE", x.Subject, "Subject");
			Assert.AreEqual ("CN=FARSCAPE", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("3029694B22B2EE6AEC9B78449E510F7C348DBA33", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("Mono SSL Intermediate CA", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("Mono SSL Intermediate CA", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("FARSCAPE", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("FARSCAPE", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");

			// extensions
			X509Extension ext = x.Extensions[0];
			Assert.AreEqual ("2.5.29.37", ext.Oid.Value, "Oid-0");
			Assert.AreEqual ("30-0A-06-08-2B-06-01-05-05-07-03-01", BitConverter.ToString (ext.RawData), "RawData-0");
			Assert.IsFalse (ext.Critical, "Critical-0");
			X509EnhancedKeyUsageExtension eku = (X509EnhancedKeyUsageExtension) ext;
			Assert.AreEqual (1, eku.EnhancedKeyUsages.Count, "EnhancedKeyUsages.Count");
			Assert.AreEqual ("1.3.6.1.5.5.7.3.1", eku.EnhancedKeyUsages[0].Value, "EnhancedKeyUsages[0]");
			ext = x.Extensions[1];
			Assert.AreEqual ("2.5.29.1", ext.Oid.Value, "Oid-1");
			Assert.AreEqual ("30-49-80-10-7C-13-05-C9-B9-5A-A3-19-3E-7C-0D-7C-E3-F2-D3-36-A1-23-30-21-31-1F-30-1D-06-03-55-04-03-13-16-4D-6F-6E-6F-20-55-6E-69-74-20-54-65-73-74-20-52-6F-6F-74-20-43-41-82-10-1B-FC-61-41-D0-CF-41-B9-47-EF-21-7D-6A-53-32-76", BitConverter.ToString (ext.RawData), "RawData-1");
			Assert.IsFalse (ext.Critical, "Critical-1");
		}

		[Test]
		public void Pkcs12_1_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (farscape_pfx, "farscape"));
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Pkcs12_1_WithoutPassword ()
		{
			new X509Certificate2 (farscape_pfx);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Pkcs12_1_BadPassword ()
		{
			new X509Certificate2 (farscape_pfx, "b4d p4zzw0rd");
		}

		[Test]
		public void Pkcs12_2_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (farscape_nopwd_pfx));
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Pkcs12_2_WithUnrequiredPassword ()
		{
			new X509Certificate2 (farscape_nopwd_pfx, "n0t n33d3d");
		}

		[Test]
		public void Pkcs12_3_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (farscape_path_pfx, "farscape"));
		}

		[Test]
		public void Pkcs12_4_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (farscape_strong_pfx, "farscape"));
		}

		[Test]
		public void Pkcs12_5_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (farscape_strong_path_pfx, "farscape"));
		}

		[Test]
		public void Pkcs12_6_Properties ()
		{
			CheckPkcs12 (new X509Certificate2 (openssl_emptypwd_pfx));
		}

		private void CheckBase64 (X509Certificate2 x)
		{
			// note: the raw data is still the DER encoded ASN.1 (not the base64 string)
			byte[] raw = { 0x30, 0x82, 0x01, 0xC5, 0x30, 0x82, 0x01, 0x32, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x10, 0xC7, 0x75, 0xAE, 0x48, 0x53, 0x9B, 0x1E, 0x9E, 0x44, 0x80, 0x15, 0xCA, 0x78, 0x15, 0x47, 0x69, 0x30, 0x09, 
				0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x30, 0x25, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x1E, 0x1A, 0x00, 0x43, 0x00, 0x41, 0x00, 0x53, 0x00, 0x54, 0x00, 0x4F, 0x00, 0x52, 
				0x00, 0x5C, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x75, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x75, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x35, 0x30, 0x36, 0x30, 0x38, 0x31, 0x33, 0x33, 0x38, 0x34, 0x37, 0x5A, 0x17, 0x0D, 0x30, 
				0x36, 0x30, 0x36, 0x30, 0x38, 0x31, 0x39, 0x33, 0x38, 0x34, 0x37, 0x5A, 0x30, 0x25, 0x31, 0x23, 0x30, 0x21, 0x06, 0x03, 0x55, 0x04, 0x03, 0x1E, 0x1A, 0x00, 0x43, 0x00, 0x41, 0x00, 0x53, 0x00, 0x54, 0x00, 
				0x4F, 0x00, 0x52, 0x00, 0x5C, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x75, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x75, 0x30, 0x81, 0x9F, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 
				0x00, 0x03, 0x81, 0x8D, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xDA, 0xEA, 0x39, 0x38, 0xF6, 0x3A, 0xF4, 0x8B, 0xF9, 0xE2, 0xC7, 0xD5, 0x2C, 0xF9, 0x1A, 0xD5, 0x75, 0xCF, 0x17, 0xAC, 0xB3, 0x46, 
				0xBD, 0x7F, 0x3F, 0x97, 0x38, 0x2E, 0x10, 0x41, 0xB2, 0xC4, 0xD9, 0x14, 0x15, 0xD8, 0xE6, 0xF9, 0x11, 0x38, 0x80, 0x75, 0xE3, 0xD7, 0x1F, 0xC0, 0x86, 0xA7, 0x3E, 0x02, 0x11, 0x04, 0xE9, 0x57, 0xB5, 0xD8, 
				0x57, 0x65, 0x27, 0x7B, 0x8F, 0xBA, 0xB9, 0xEF, 0xA0, 0x8F, 0x15, 0x9C, 0xEC, 0x2F, 0x85, 0x63, 0x4E, 0x52, 0x6B, 0xA6, 0xE3, 0x33, 0xCA, 0x86, 0x22, 0xBA, 0xF9, 0x06, 0xE8, 0xEC, 0xCB, 0xA7, 0xA5, 0xA8, 
				0xE2, 0x3E, 0xC7, 0x21, 0x74, 0x4E, 0xC9, 0xE9, 0x05, 0x5F, 0xAE, 0x78, 0x12, 0x51, 0x2F, 0xFA, 0x6A, 0x8F, 0x7C, 0xB0, 0x64, 0x2A, 0xFB, 0xB7, 0xB2, 0x40, 0x91, 0x20, 0xE7, 0x32, 0x53, 0x3F, 0x58, 0xCA, 
				0x80, 0xA2, 0x41, 0xC5, 0x02, 0x03, 0x01, 0x00, 0x01, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1D, 0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x9D, 0x57, 0xB0, 0x25, 0x97, 0x81, 0x22, 0x3C, 0xC4, 0x61, 
				0x9D, 0xC9, 0xDB, 0xD8, 0xC7, 0xC1, 0xED, 0xFB, 0x1C, 0xDD, 0x35, 0x98, 0xD7, 0x40, 0x58, 0xA4, 0x43, 0x86, 0x54, 0xF9, 0x68, 0x96, 0x85, 0xB5, 0x91, 0xBC, 0xB7, 0x82, 0xB2, 0x7E, 0x7B, 0x58, 0xBD, 0x80, 
				0xCE, 0x34, 0x7E, 0x22, 0x87, 0x62, 0x31, 0xB5, 0x03, 0x16, 0xA0, 0x20, 0x17, 0x9D, 0xE7, 0x5D, 0xAA, 0x12, 0xF5, 0x92, 0xDF, 0x94, 0xE6, 0x69, 0xCD, 0xF6, 0xFC, 0x82, 0x9B, 0xDC, 0xD3, 0x30, 0x40, 0xB1, 
				0x71, 0x4F, 0x4A, 0x64, 0xCB, 0xDC, 0x14, 0xC8, 0xC1, 0x7F, 0x6F, 0x23, 0xCE, 0xDD, 0x19, 0x22, 0x4F, 0x24, 0x1E, 0x27, 0x18, 0x66, 0x88, 0x7A, 0x9A, 0x9A, 0x09, 0x37, 0x6D, 0x65, 0x15, 0xE8, 0x28, 0x5E, 
				0x82, 0xEB, 0x5B, 0x82, 0xE8, 0x8A, 0xAC, 0x8F, 0xC3, 0x6C, 0xEE, 0xF0, 0x3E, 0x20, 0xCB, 0xC7 };

			DateTime expectedNotAfter = new DateTime (632853923270000000,
				DateTimeKind.Utc);
			DateTime expectedNotBefore = new DateTime (632538347270000000,
				DateTimeKind.Utc);

			Assert.IsFalse (x.Archived, "Archived");
			Assert.AreEqual (0, x.Extensions.Count, "Extensions");
			Assert.AreEqual (0, x.FriendlyName.Length, "FriendlyName");
			Assert.IsFalse (x.HasPrivateKey, "HasPrivateKey");
			Assert.AreEqual ("CN=CASTOR\\poupou", x.Issuer, "Issuer");
			Assert.AreEqual ("CN=CASTOR\\poupou", x.IssuerName.Name, "IssuerName");
			Assert.AreEqual (expectedNotAfter.Ticks, x.NotAfter.ToUniversalTime ().Ticks, "NotAfter#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotAfter.Kind, "NotAfter#2");
			Assert.AreEqual (expectedNotAfter.ToLocalTime (), x.NotAfter, "NotAfter#3");
			Assert.AreEqual (expectedNotBefore.Ticks, x.NotBefore.ToUniversalTime ().Ticks, "NotBefore#1");
			Assert.AreEqual (DateTimeKind.Local, x.NotBefore.Kind, "NotBefore#2");
			Assert.AreEqual (expectedNotBefore.ToLocalTime (), x.NotBefore, "NotBefore#3");
			Assert.IsNull (x.PrivateKey, "PrivateKey");
			Assert.AreEqual ("<RSAKeyValue><Modulus>2uo5OPY69Iv54sfVLPka1XXPF6yzRr1/P5c4LhBBssTZFBXY5vkROIB149cfwIanPgIRBOlXtdhXZSd7j7q576CPFZzsL4VjTlJrpuMzyoYiuvkG6OzLp6Wo4j7HIXROyekFX654ElEv+mqPfLBkKvu3skCRIOcyUz9YyoCiQcU=</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>", x.PublicKey.Key.ToXmlString (false), "PublicKey");
			Assert.AreEqual (raw, x.RawData, "RawData");
			Assert.AreEqual ("C775AE48539B1E9E448015CA78154769", x.SerialNumber, "SerialNumber");
			Assert.AreEqual ("1.3.14.3.2.29", x.SignatureAlgorithm.Value, "SignatureAlgorithm");
			Assert.AreEqual ("CN=CASTOR\\poupou", x.Subject, "Subject");
			Assert.AreEqual ("CN=CASTOR\\poupou", x.SubjectName.Name, "SubjectName");
			Assert.AreEqual ("1D53CC89D09F114A487F7F529ECBD186A3D58529", x.Thumbprint, "Thumbprint");
			Assert.AreEqual (3, x.Version, "Version");

			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, true), "DnsFromAlternativeName,true");
			Assert.AreEqual ("CASTOR\\poupou", x.GetNameInfo (X509NameType.DnsName, true), "DnsName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, true), "EmailName,true");
			Assert.AreEqual ("CASTOR\\poupou", x.GetNameInfo (X509NameType.SimpleName, true), "SimpleName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, true), "UpnName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, true), "UrlName,true");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.DnsFromAlternativeName, false), "DnsFromAlternativeName,false");
			Assert.AreEqual ("CASTOR\\poupou", x.GetNameInfo (X509NameType.DnsName, false), "DnsName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.EmailName, false), "EmailName,false");
			Assert.AreEqual ("CASTOR\\poupou", x.GetNameInfo (X509NameType.SimpleName, false), "SimpleName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UpnName, false), "UpnName,false");
			Assert.AreEqual (String.Empty, x.GetNameInfo (X509NameType.UrlName, false), "UrlName,false");
		}

		[Test]
		public void Base64_AsByteArray_Properties ()
		{
			// note: the X509Certificate(string) ctor is used for a filename
			byte[] raw = Encoding.ASCII.GetBytes (base64_cert);
			CheckBase64 (new X509Certificate2 (raw));
		}

		[Test]
		public void Base64_AsFile_Properties ()
		{
			string temp = Path.GetTempFileName ();
			try {
				using (StreamWriter sw = new StreamWriter (temp)) {
					sw.Write (base64_cert);
				}
				CheckBase64 (new X509Certificate2 (temp));
			}
			finally {
				if (File.Exists (temp))
					File.Delete (temp);
			}
		}

		private bool RunningOnWindows ()
		{
			int i = (int) Environment.OSVersion.Platform;
			return ((i != 4) && (i != 128));
		}

		[Test]
		public void Base64_AsStringData ()
		{
			try {
				new X509Certificate2 (base64_cert);
				Assert.Fail ("Expected ArgumentException(Windows) or PathTooLongException(Linux)");
			}
			catch (ArgumentException) {
				// path is invalid on Windows
				if (!RunningOnWindows ())
					throw;
			}
			catch (PathTooLongException) {
				// path is too long on Linux
				if (RunningOnWindows ())
					throw;
			}
			catch (DirectoryNotFoundException) {
			}
			catch (Exception e) {
				Assert.Fail (e.ToString ());
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Pkcs7_Ctor ()
		{
			new X509Certificate2 (farscape_pkcs7);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Pkcs7_Import ()
		{
			X509Certificate2 x = new X509Certificate2 ();
			x.Import (farscape_pkcs7);
		}

		[Test]
		[ExpectedException (typeof (ArgumentException))]
		public void GetCertContentType_byte_Null ()
		{
			X509Certificate2.GetCertContentType ((byte[]) null);
		}

		[Test]
		[ExpectedException (typeof (ArgumentException))]
		public void GetCertContentType_byte_Empty ()
		{
			X509Certificate2.GetCertContentType (new byte[0]);
		}

		[Test]
		public void GetCertContentType_byte ()
		{
			// empty ASN.1 sequence
			Assert.AreEqual (X509ContentType.Unknown, X509Certificate2.GetCertContentType (new byte[2] { 0x30, 0x00 }), "30-00");

			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_1), "1-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_2), "2-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_3), "3-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_4), "4-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_5), "5-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_8), "8-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_9), "9-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_10), "10-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_12), "12-Cert");
			Assert.AreEqual (X509ContentType.Cert, X509Certificate2.GetCertContentType (cert_13), "13-Cert");

			Assert.AreEqual (X509ContentType.Pkcs12, X509Certificate2.GetCertContentType (farscape_pfx), "1-Pkcs12");
			Assert.AreEqual (X509ContentType.Pkcs12, X509Certificate2.GetCertContentType (farscape_nopwd_pfx), "2-Pkcs12");
			Assert.AreEqual (X509ContentType.Pkcs12, X509Certificate2.GetCertContentType (farscape_path_pfx), "3-Pkcs12");
			Assert.AreEqual (X509ContentType.Pkcs12, X509Certificate2.GetCertContentType (farscape_strong_pfx), "4-Pkcs12");
			Assert.AreEqual (X509ContentType.Pkcs12, X509Certificate2.GetCertContentType (farscape_strong_path_pfx), "5-Pkcs12");

			Assert.AreEqual (X509ContentType.Pkcs7, X509Certificate2.GetCertContentType (farscape_pkcs7), "1-Pkcs7");
		}

		[Test]
		[ExpectedException (typeof (ArgumentNullException))]
		public void GetCertContentType_String_Null ()
		{
			X509Certificate2.GetCertContentType ((string) null);
		}

		[Test]
		[ExpectedException (typeof (ArgumentException))]
		public void GetCertContentType_String_Empty ()
		{
			X509Certificate2.GetCertContentType (String.Empty);
		}

		[Test]
		public void GetNameInfo_Invalid_True ()
		{
			try {
				// MS throws ArgumentException, Mono's new implementation throws
				// CryptographicException, which is consistent with other "certificate
				// instance is empty" situations.
				new X509Certificate2 ().GetNameInfo ((X509NameType) Int32.MinValue, true);
				Assert.Fail ("Expected exception.");
			} catch (ArgumentException) {
			} catch (CryptographicException) {
			} catch (Exception ex) {
				Assert.Fail ("Expected 'ArgumentException' or 'CryptographicException', got '{0}'", ex.GetType ());
			}
		}

		[Test]
		public void GetNameInfo_Invalid_False ()
		{
			try {
				// MS throws ArgumentException, Mono's new implementation throws
				// CryptographicException, which is consistent with other "certificate
				// instance is empty" situations.
				new X509Certificate2 ().GetNameInfo ((X509NameType) Int32.MinValue, false);
				Assert.Fail ("Expected exception.");
			} catch (ArgumentException) {
			} catch (CryptographicException) {
			} catch (Exception ex) {
				Assert.Fail ("Expected 'ArgumentException' or 'CryptographicException', got '{0}'", ex.GetType ());
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_GetNameInfo_SimpleName ()
		{
			new X509Certificate2 ().GetNameInfo (X509NameType.SimpleName, true);
		}

		[Test]
		public void Empty_GetNameInfo_DnsName ()
		{
			try {
				// MS throws NullReferenceException, Mono's new implementation throws
				// CryptographicException, which is consistent with other "certificate
				// instance is empty" situations.
				new X509Certificate2 ().GetNameInfo (X509NameType.DnsName, true);
				Assert.Fail ("Expected exception.");
			} catch (NullReferenceException) {
			} catch (CryptographicException) {
			} catch (Exception ex) {
				Assert.Fail ("Expected 'NullReferenceException' or 'CryptographicException', got '{0}'", ex.GetType ());
			}
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Verify ()
		{
			new X509Certificate2 ().Verify ();
		}

		[Test]
		public void Empty_ToString ()
		{
			string expected = "System.Security.Cryptography.X509Certificates.X509Certificate2";
			X509Certificate2 x = new X509Certificate2 ();
			Assert.AreEqual (expected, x.ToString (), "ToString()");
			Assert.AreEqual (expected, x.ToString (true), "ToString(true)");
			Assert.AreEqual (expected, x.ToString (false), "ToString(false)");
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Archived_Get ()
		{
			Assert.IsFalse (new X509Certificate2 ().Archived);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Archived_Set ()
		{
			new X509Certificate2 ().Archived = false;
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Extensions ()
		{
			Assert.IsNull (new X509Certificate2 ().Extensions);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_FriendlyName_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().FriendlyName);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_FriendlyName_Set ()
		{
			new X509Certificate2 ().FriendlyName = null;
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_HasPrivateKey ()
		{
			Assert.IsFalse (new X509Certificate2 ().HasPrivateKey);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_IssuerName ()
		{
			Assert.IsNull (new X509Certificate2 ().IssuerName);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_NotAfter ()
		{
			Assert.AreEqual (DateTime.MinValue, new X509Certificate2 ().NotAfter);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_NotBefore ()
		{
			Assert.AreEqual (DateTime.MinValue, new X509Certificate2 ().NotBefore);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_PrivateKey_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().PrivateKey);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_PrivateKey_Set ()
		{
			new X509Certificate2 ().PrivateKey = null;
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_PublicKey_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().PublicKey);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_RawData_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().RawData);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_SerialNumber_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().SerialNumber);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_SignatureAlgorithm_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().SignatureAlgorithm);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_SubjectName_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().SubjectName);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Thumbprint_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().Thumbprint);
		}

		[Test]
		[ExpectedException (typeof (CryptographicException))]
		public void Empty_Version_Get ()
		{
			Assert.IsNull (new X509Certificate2 ().Version);
		}

		[Test]
		public void T61String ()
		{
			// http://bugzilla.ximian.com/show_bug.cgi?id=77295
			byte[] raw = Encoding.ASCII.GetBytes (t61string_cert);
			X509Certificate2 cert = new X509Certificate2 (raw);
			string subject = "SERIALNUMBER=CVR:13471967-UID:121212121212, E=vhm@use.test.dk, CN=Hedeby's Møbelhandel - Salgsafdelingen, O=Hedeby's Møbelhandel // CVR:13471967, C=DK";
			Assert.AreEqual (subject, cert.Subject, "Subject");
			Assert.AreEqual (subject, cert.SubjectName.Name, "SubjectName");
			string issuer = "CN=KMD Intern Test - KUN TIL TEST/NO LIABILITY GIVEN, OU=KMD, O=KMD, C=DK";
			Assert.AreEqual (issuer, cert.Issuer, "Subject");
			Assert.AreEqual (issuer, cert.IssuerName.Name, "SubjectName");
		}

		// Certificate: basic\ArmedForcesDSARoot.cer
		// - X.509v3 self-signed certificate
		// - DSA 1024 bits
		[Test]
		[SetCulture ("")]
		// Copied from the corlib test.
		public void Corlib_Test_Certificate8 ()
		{
			// certificate can be loaded by constructor
			byte[] cert = { 0x30,0x82,0x03,0x04,0x30,0x82,0x02,0xC4,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x03,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x30,0x51,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x31,0x0C,0x30,0x0A,0x06,0x03,0x55,0x04,0x0B,0x13,0x03,0x44,0x6F,0x44,0x31,0x1A,0x30,0x18,0x06,0x03,0x55,0x04,0x03,0x13,0x11,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,
		0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x30,0x1E,0x17,0x0D,0x30,0x30,0x31,0x30,0x32,0x35,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x30,0x33,0x30,0x31,0x30,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x5A,0x30,0x51,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x55,0x53,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x0A,0x13,0x0F,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x31,0x0C,0x30,0x0A,0x06,0x03,0x55,0x04,0x0B,0x13,0x03,0x44,0x6F,0x44,0x31,0x1A,0x30,0x18,
		0x06,0x03,0x55,0x04,0x03,0x13,0x11,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x30,0x82,0x01,0xB6,0x30,0x82,0x01,0x2B,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x01,0x30,0x82,0x01,0x1E,0x02,0x81,0x81,0x00,0x90,0x89,0x3E,0x18,0x1B,0xFE,0xA3,0x1D,0x16,0x89,0x00,0xB4,0xD5,0x40,0x82,0x4C,0x2E,0xEC,0x3D,0x66,0x0D,0x0D,0xB9,0x17,0x40,0x6E,0x3A,0x5C,0x03,0x7B,0x1B,0x93,0x28,0x0C,0xEF,0xB9,0x97,0xE3,0xA1,0xEB,0xE2,0xA3,0x7C,0x61,0xDD,0x6F,0xD5,0xAD,0x15,0x69,0x00,
		0x16,0xB2,0xC3,0x08,0x3D,0xC4,0x59,0xC6,0xF2,0x70,0xA5,0xB0,0xF5,0x1F,0x1D,0xF4,0xB0,0x15,0xDA,0x7E,0x28,0x39,0x24,0x99,0x36,0x5B,0xEC,0x39,0x25,0xFA,0x92,0x49,0x65,0xD2,0x43,0x05,0x6A,0x9E,0xA3,0x7B,0xF0,0xDE,0xA3,0x2F,0xD3,0x6F,0x3A,0xF9,0x35,0xC3,0x29,0xD4,0x45,0x6C,0x56,0x9A,0xDE,0x36,0x6E,0xFE,0x12,0x68,0x96,0x7B,0x45,0x1D,0x2C,0xFF,0xB9,0x2D,0xF5,0x52,0x8C,0xDF,0x3E,0x2F,0x63,0x02,0x15,0x00,0x81,0xA9,0xB5,0xD0,0x04,0xF2,0x9B,0xA7,0xD8,0x55,0x4C,0x3B,0x32,0xA1,0x45,0x32,0x4F,0xF5,0x51,0xDD,
		0x02,0x81,0x80,0x64,0x7A,0x88,0x0B,0xF2,0x3E,0x91,0x81,0x59,0x9C,0xF4,0xEA,0xC6,0x7B,0x0E,0xBE,0xEA,0x05,0xE8,0x77,0xFD,0x20,0x34,0x87,0xA1,0xC4,0x69,0xF6,0xC8,0x8B,0x19,0xDA,0xCD,0xFA,0x21,0x8A,0x57,0xA9,0x7A,0x26,0x0A,0x56,0xD4,0xED,0x4B,0x1B,0x7C,0x70,0xED,0xB4,0xE6,0x7A,0x6A,0xDE,0xD3,0x29,0xE2,0xE9,0x9A,0x33,0xED,0x09,0x8D,0x9E,0xDF,0xDA,0x2E,0x4A,0xC1,0x50,0x92,0xEE,0x2F,0xE5,0x5A,0xF3,0x85,0x62,0x6A,0x48,0xDC,0x1B,0x02,0x98,0xA6,0xB0,0xD1,0x09,0x4B,0x10,0xD1,0xF0,0xFA,0xE0,0xB1,0x1D,0x13,
		0x54,0x4B,0xC0,0xA8,0x40,0xEF,0x71,0xE8,0x56,0x6B,0xA2,0x29,0xCB,0x1E,0x09,0x7D,0x27,0x39,0x91,0x3B,0x20,0x4F,0x98,0x39,0xE8,0x39,0xCA,0x98,0xC5,0xAF,0x54,0x03,0x81,0x84,0x00,0x02,0x81,0x80,0x54,0xA8,0x88,0xB5,0x8F,0x01,0x56,0xCE,0x18,0x8F,0xA6,0xD6,0x7C,0x29,0x29,0x75,0x45,0xE8,0x31,0xA4,0x07,0x17,0xED,0x1E,0x5D,0xB2,0x7B,0xBB,0xCE,0x3C,0x97,0x67,0x1E,0x88,0x0A,0xFE,0x7D,0x00,0x22,0x27,0x1D,0x66,0xEE,0xF6,0x1B,0xB6,0x95,0x7F,0x5A,0xFF,0x06,0x34,0x02,0x43,0xC3,0x83,0xC4,0x66,0x2C,0xA1,0x05,0x0E,
		0x68,0xB3,0xCA,0xDC,0xD3,0xF9,0x0C,0xC0,0x66,0xDF,0x85,0x84,0x4B,0x20,0x5D,0x41,0xAC,0xC0,0xEC,0x37,0x92,0x0E,0x97,0x19,0xBF,0x53,0x35,0x63,0x27,0x18,0x33,0x35,0x42,0x4D,0xF0,0x2D,0x6D,0xA7,0xA4,0x98,0xAA,0x57,0xF3,0xD2,0xB8,0x6E,0x4E,0x8F,0xFF,0xBE,0x6F,0x4E,0x0F,0x0B,0x44,0x24,0xEE,0xDF,0x4C,0x22,0x5B,0x44,0x98,0x94,0xCB,0xB8,0xA3,0x2F,0x30,0x2D,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x9D,0x2D,0x73,0xC3,0xB8,0xE3,0x4D,0x29,0x28,0xC3,0x65,0xBE,0xA9,0x98,0xCB,0xD6,0x8A,0x06,0x68,
		0x9C,0x30,0x0C,0x06,0x03,0x55,0x1D,0x13,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x09,0x06,0x07,0x2A,0x86,0x48,0xCE,0x38,0x04,0x03,0x03,0x2F,0x00,0x30,0x2C,0x02,0x14,0x5A,0x1B,0x2D,0x08,0x0E,0xE6,0x99,0x38,0x8F,0xB5,0x09,0xC9,0x89,0x79,0x7E,0x01,0x30,0xBD,0xCE,0xF0,0x02,0x14,0x71,0x7B,0x08,0x51,0x97,0xCE,0x4D,0x1F,0x6A,0x84,0x47,0x3A,0xC0,0xBD,0x13,0x89,0x81,0xB9,0x01,0x97 };

			X509Certificate x509 = new X509Certificate2 (cert);
			X509Certificate clone = new X509Certificate2 (x509);

			Assert.IsTrue (x509.Equals (clone), "Equals");
			Assert.IsTrue (clone.Equals (x509), "Equals");

			byte[] hash = { 0xA3, 0x0A, 0x06, 0xB1, 0xB0, 0xD4, 0xF8, 0x71, 0x67, 0x8A, 0x60, 0xC5, 0x4E, 0xE4, 0xD8, 0x66, 0x36, 0x06, 0xCC, 0xE6 };
			Assert.AreEqual (hash, x509.GetCertHash (), "GetCertHash");
			Assert.AreEqual ("A30A06B1B0D4F871678A60C54EE4D8663606CCE6", x509.GetCertHashString (), "GetCertHashString");
			DateTime from = DateTime.ParseExact (x509.GetEffectiveDateString (), "MM/dd/yyyy HH:mm:ss", null).ToUniversalTime ();
			Assert.AreEqual ("10/25/2000 00:00:00", from.ToString (), "GetEffectiveDateString");
			DateTime until = DateTime.ParseExact (x509.GetExpirationDateString (), "MM/dd/yyyy HH:mm:ss", null).ToUniversalTime ();
			Assert.AreEqual ("01/01/2003 00:00:00", until.ToString (), "GetExpirationDateString");
			Assert.AreEqual ("X509", x509.GetFormat (), "GetFormat");
			Assert.AreEqual (-1559624015, x509.GetHashCode (), "GetHashCode");
			Assert.AreEqual ("C=US, O=U.S. Government, OU=DoD, CN=Armed Forces Root", x509.GetIssuerName (), "GetIssuerName");
			Assert.AreEqual ("1.2.840.10040.4.1", x509.GetKeyAlgorithm (), "GetKeyAlgorithm");
			byte[] keyparams = { 0x30,0x82,0x01,0x1E,0x02,0x81,0x81,0x00,0x90,0x89,0x3E,0x18,0x1B,0xFE,0xA3,0x1D,0x16,0x89,0x00,0xB4,0xD5,0x40,0x82,0x4C,0x2E,0xEC,0x3D,0x66,0x0D,0x0D,0xB9,0x17,0x40,0x6E,0x3A,0x5C,0x03,0x7B,0x1B,0x93,0x28,0x0C,0xEF,0xB9,0x97,0xE3,0xA1,0xEB,0xE2,0xA3,0x7C,0x61,0xDD,0x6F,0xD5,0xAD,0x15,0x69,0x00,0x16,0xB2,0xC3,0x08,0x3D,0xC4,0x59,0xC6,0xF2,0x70,0xA5,0xB0,0xF5,0x1F,0x1D,0xF4,0xB0,0x15,0xDA,0x7E,0x28,0x39,0x24,0x99,0x36,0x5B,0xEC,0x39,0x25,0xFA,0x92,0x49,0x65,0xD2,0x43,0x05,0x6A,0x9E,0xA3,0x7B,0xF0,0xDE,
		0xA3,0x2F,0xD3,0x6F,0x3A,0xF9,0x35,0xC3,0x29,0xD4,0x45,0x6C,0x56,0x9A,0xDE,0x36,0x6E,0xFE,0x12,0x68,0x96,0x7B,0x45,0x1D,0x2C,0xFF,0xB9,0x2D,0xF5,0x52,0x8C,0xDF,0x3E,0x2F,0x63,0x02,0x15,0x00,0x81,0xA9,0xB5,0xD0,0x04,0xF2,0x9B,0xA7,0xD8,0x55,0x4C,0x3B,0x32,0xA1,0x45,0x32,0x4F,0xF5,0x51,0xDD,0x02,0x81,0x80,0x64,0x7A,0x88,0x0B,0xF2,0x3E,0x91,0x81,0x59,0x9C,0xF4,0xEA,0xC6,0x7B,0x0E,0xBE,0xEA,0x05,0xE8,0x77,0xFD,0x20,0x34,0x87,0xA1,0xC4,0x69,0xF6,0xC8,0x8B,0x19,0xDA,0xCD,0xFA,0x21,0x8A,0x57,0xA9,0x7A,
		0x26,0x0A,0x56,0xD4,0xED,0x4B,0x1B,0x7C,0x70,0xED,0xB4,0xE6,0x7A,0x6A,0xDE,0xD3,0x29,0xE2,0xE9,0x9A,0x33,0xED,0x09,0x8D,0x9E,0xDF,0xDA,0x2E,0x4A,0xC1,0x50,0x92,0xEE,0x2F,0xE5,0x5A,0xF3,0x85,0x62,0x6A,0x48,0xDC,0x1B,0x02,0x98,0xA6,0xB0,0xD1,0x09,0x4B,0x10,0xD1,0xF0,0xFA,0xE0,0xB1,0x1D,0x13,0x54,0x4B,0xC0,0xA8,0x40,0xEF,0x71,0xE8,0x56,0x6B,0xA2,0x29,0xCB,0x1E,0x09,0x7D,0x27,0x39,0x91,0x3B,0x20,0x4F,0x98,0x39,0xE8,0x39,0xCA,0x98,0xC5,0xAF,0x54 };
			Assert.AreEqual (keyparams, x509.GetKeyAlgorithmParameters (), "GetKeyAlgorithmParameters");
			Assert.AreEqual ("3082011E0281810090893E181BFEA31D168900B4D540824C2EEC3D660D0DB917406E3A5C037B1B93280CEFB997E3A1EBE2A37C61DD6FD5AD15690016B2C3083DC459C6F270A5B0F51F1DF4B015DA7E28392499365BEC3925FA924965D243056A9EA37BF0DEA32FD36F3AF935C329D4456C569ADE366EFE1268967B451D2CFFB92DF5528CDF3E2F6302150081A9B5D004F29BA7D8554C3B32A145324FF551DD028180647A880BF23E9181599CF4EAC67B0EBEEA05E877FD203487A1C469F6C88B19DACDFA218A57A97A260A56D4ED4B1B7C70EDB4E67A6ADED329E2E99A33ED098D9EDFDA2E4AC15092EE2FE55AF385626A48DC1B0298A6B0D1094B10D1F0FAE0B11D13544BC0A840EF71E8566BA229CB1E097D2739913B204F9839E839CA98C5AF54", x509.GetKeyAlgorithmParametersString (), "GetKeyAlgorithmParametersString");
			Assert.AreEqual ("C=US, O=U.S. Government, OU=DoD, CN=Armed Forces Root", x509.GetName (), "GetName");
			byte[] pubkey = { 0x02,0x81,0x80,0x54,0xA8,0x88,0xB5,0x8F,0x01,0x56,0xCE,0x18,0x8F,0xA6,0xD6,0x7C,0x29,0x29,0x75,0x45,0xE8,0x31,0xA4,0x07,0x17,0xED,0x1E,0x5D,0xB2,0x7B,0xBB,0xCE,0x3C,0x97,0x67,0x1E,0x88,0x0A,0xFE,0x7D,0x00,0x22,0x27,0x1D,0x66,0xEE,0xF6,0x1B,0xB6,0x95,0x7F,0x5A,0xFF,0x06,0x34,0x02,0x43,0xC3,0x83,0xC4,0x66,0x2C,0xA1,0x05,0x0E,0x68,0xB3,0xCA,0xDC,0xD3,0xF9,0x0C,0xC0,0x66,0xDF,0x85,0x84,0x4B,0x20,0x5D,0x41,0xAC,0xC0,0xEC,0x37,0x92,0x0E,0x97,0x19,0xBF,0x53,0x35,0x63,0x27,0x18,0x33,0x35,0x42,0x4D,0xF0,0x2D,
		0x6D,0xA7,0xA4,0x98,0xAA,0x57,0xF3,0xD2,0xB8,0x6E,0x4E,0x8F,0xFF,0xBE,0x6F,0x4E,0x0F,0x0B,0x44,0x24,0xEE,0xDF,0x4C,0x22,0x5B,0x44,0x98,0x94,0xCB,0xB8 };
			Assert.AreEqual (pubkey, x509.GetPublicKey (), "GetPublicKey");
			Assert.AreEqual ("02818054A888B58F0156CE188FA6D67C29297545E831A40717ED1E5DB27BBBCE3C97671E880AFE7D0022271D66EEF61BB6957F5AFF06340243C383C4662CA1050E68B3CADCD3F90CC066DF85844B205D41ACC0EC37920E9719BF53356327183335424DF02D6DA7A498AA57F3D2B86E4E8FFFBE6F4E0F0B4424EEDF4C225B449894CBB8", x509.GetPublicKeyString (), "GetPublicKeyString");
			Assert.AreEqual (cert, x509.GetRawCertData (), "GetRawCertData");
			Assert.AreEqual (ToString (cert), x509.GetRawCertDataString (), "GetRawCertDataString");
			byte[] serial = { 0x03 };
			Assert.AreEqual (serial, x509.GetSerialNumber (), "GetSerialNumber");
			Assert.AreEqual ("03", x509.GetSerialNumberString (), "GetSerialNumberString");
			byte[] ToStringArray = { 0x43,0x45,0x52,0x54,0x49,0x46,0x49,0x43,0x41,0x54,0x45,0x3A,0x0D,0x0A,0x09,0x46,0x6F,0x72,0x6D,0x61,0x74,0x3A,0x20,0x20,0x58,0x35,0x30,0x39,0x0D,0x0A,0x09,0x4E,0x61,0x6D,0x65,0x3A,0x20,0x20,0x43,0x3D,0x55,0x53,0x2C,0x20,0x4F,0x3D,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x2C,0x20,0x4F,0x55,0x3D,0x44,0x6F,0x44,0x2C,0x20,0x43,0x4E,0x3D,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x0D,0x0A,0x09,0x49,0x73,0x73,0x75,0x69,0x6E,0x67,
		0x20,0x43,0x41,0x3A,0x20,0x20,0x43,0x3D,0x55,0x53,0x2C,0x20,0x4F,0x3D,0x55,0x2E,0x53,0x2E,0x20,0x47,0x6F,0x76,0x65,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x2C,0x20,0x4F,0x55,0x3D,0x44,0x6F,0x44,0x2C,0x20,0x43,0x4E,0x3D,0x41,0x72,0x6D,0x65,0x64,0x20,0x46,0x6F,0x72,0x63,0x65,0x73,0x20,0x52,0x6F,0x6F,0x74,0x0D,0x0A,0x09,0x4B,0x65,0x79,0x20,0x41,0x6C,0x67,0x6F,0x72,0x69,0x74,0x68,0x6D,0x3A,0x20,0x20,0x31,0x2E,0x32,0x2E,0x38,0x34,0x30,0x2E,0x31,0x30,0x30,0x34,0x30,0x2E,0x34,0x2E,0x31,0x0D,0x0A,0x09,0x53,0x65,
		0x72,0x69,0x61,0x6C,0x20,0x4E,0x75,0x6D,0x62,0x65,0x72,0x3A,0x20,0x20,0x30,0x33,0x0D,0x0A,0x09,0x4B,0x65,0x79,0x20,0x41,0x6C,0x6F,0x67,0x72,0x69,0x74,0x68,0x6D,0x20,0x50,0x61,0x72,0x61,0x6D,0x65,0x74,0x65,0x72,0x73,0x3A,0x20,0x20,0x33,0x30,0x38,0x32,0x30,0x31,0x31,0x45,0x30,0x32,0x38,0x31,0x38,0x31,0x30,0x30,0x39,0x30,0x38,0x39,0x33,0x45,0x31,0x38,0x31,0x42,0x46,0x45,0x41,0x33,0x31,0x44,0x31,0x36,0x38,0x39,0x30,0x30,0x42,0x34,0x44,0x35,0x34,0x30,0x38,0x32,0x34,0x43,0x32,0x45,0x45,0x43,0x33,0x44,
		0x36,0x36,0x30,0x44,0x30,0x44,0x42,0x39,0x31,0x37,0x34,0x30,0x36,0x45,0x33,0x41,0x35,0x43,0x30,0x33,0x37,0x42,0x31,0x42,0x39,0x33,0x32,0x38,0x30,0x43,0x45,0x46,0x42,0x39,0x39,0x37,0x45,0x33,0x41,0x31,0x45,0x42,0x45,0x32,0x41,0x33,0x37,0x43,0x36,0x31,0x44,0x44,0x36,0x46,0x44,0x35,0x41,0x44,0x31,0x35,0x36,0x39,0x30,0x30,0x31,0x36,0x42,0x32,0x43,0x33,0x30,0x38,0x33,0x44,0x43,0x34,0x35,0x39,0x43,0x36,0x46,0x32,0x37,0x30,0x41,0x35,0x42,0x30,0x46,0x35,0x31,0x46,0x31,0x44,0x46,0x34,0x42,0x30,0x31,0x35,
		0x44,0x41,0x37,0x45,0x32,0x38,0x33,0x39,0x32,0x34,0x39,0x39,0x33,0x36,0x35,0x42,0x45,0x43,0x33,0x39,0x32,0x35,0x46,0x41,0x39,0x32,0x34,0x39,0x36,0x35,0x44,0x32,0x34,0x33,0x30,0x35,0x36,0x41,0x39,0x45,0x41,0x33,0x37,0x42,0x46,0x30,0x44,0x45,0x41,0x33,0x32,0x46,0x44,0x33,0x36,0x46,0x33,0x41,0x46,0x39,0x33,0x35,0x43,0x33,0x32,0x39,0x44,0x34,0x34,0x35,0x36,0x43,0x35,0x36,0x39,0x41,0x44,0x45,0x33,0x36,0x36,0x45,0x46,0x45,0x31,0x32,0x36,0x38,0x39,0x36,0x37,0x42,0x34,0x35,0x31,0x44,0x32,0x43,0x46,0x46,
		0x42,0x39,0x32,0x44,0x46,0x35,0x35,0x32,0x38,0x43,0x44,0x46,0x33,0x45,0x32,0x46,0x36,0x33,0x30,0x32,0x31,0x35,0x30,0x30,0x38,0x31,0x41,0x39,0x42,0x35,0x44,0x30,0x30,0x34,0x46,0x32,0x39,0x42,0x41,0x37,0x44,0x38,0x35,0x35,0x34,0x43,0x33,0x42,0x33,0x32,0x41,0x31,0x34,0x35,0x33,0x32,0x34,0x46,0x46,0x35,0x35,0x31,0x44,0x44,0x30,0x32,0x38,0x31,0x38,0x30,0x36,0x34,0x37,0x41,0x38,0x38,0x30,0x42,0x46,0x32,0x33,0x45,0x39,0x31,0x38,0x31,0x35,0x39,0x39,0x43,0x46,0x34,0x45,0x41,0x43,0x36,0x37,0x42,0x30,0x45,
		0x42,0x45,0x45,0x41,0x30,0x35,0x45,0x38,0x37,0x37,0x46,0x44,0x32,0x30,0x33,0x34,0x38,0x37,0x41,0x31,0x43,0x34,0x36,0x39,0x46,0x36,0x43,0x38,0x38,0x42,0x31,0x39,0x44,0x41,0x43,0x44,0x46,0x41,0x32,0x31,0x38,0x41,0x35,0x37,0x41,0x39,0x37,0x41,0x32,0x36,0x30,0x41,0x35,0x36,0x44,0x34,0x45,0x44,0x34,0x42,0x31,0x42,0x37,0x43,0x37,0x30,0x45,0x44,0x42,0x34,0x45,0x36,0x37,0x41,0x36,0x41,0x44,0x45,0x44,0x33,0x32,0x39,0x45,0x32,0x45,0x39,0x39,0x41,0x33,0x33,0x45,0x44,0x30,0x39,0x38,0x44,0x39,0x45,0x44,0x46,
		0x44,0x41,0x32,0x45,0x34,0x41,0x43,0x31,0x35,0x30,0x39,0x32,0x45,0x45,0x32,0x46,0x45,0x35,0x35,0x41,0x46,0x33,0x38,0x35,0x36,0x32,0x36,0x41,0x34,0x38,0x44,0x43,0x31,0x42,0x30,0x32,0x39,0x38,0x41,0x36,0x42,0x30,0x44,0x31,0x30,0x39,0x34,0x42,0x31,0x30,0x44,0x31,0x46,0x30,0x46,0x41,0x45,0x30,0x42,0x31,0x31,0x44,0x31,0x33,0x35,0x34,0x34,0x42,0x43,0x30,0x41,0x38,0x34,0x30,0x45,0x46,0x37,0x31,0x45,0x38,0x35,0x36,0x36,0x42,0x41,0x32,0x32,0x39,0x43,0x42,0x31,0x45,0x30,0x39,0x37,0x44,0x32,0x37,0x33,0x39,
		0x39,0x31,0x33,0x42,0x32,0x30,0x34,0x46,0x39,0x38,0x33,0x39,0x45,0x38,0x33,0x39,0x43,0x41,0x39,0x38,0x43,0x35,0x41,0x46,0x35,0x34,0x0D,0x0A,0x09,0x50,0x75,0x62,0x6C,0x69,0x63,0x20,0x4B,0x65,0x79,0x3A,0x20,0x20,0x30,0x32,0x38,0x31,0x38,0x30,0x35,0x34,0x41,0x38,0x38,0x38,0x42,0x35,0x38,0x46,0x30,0x31,0x35,0x36,0x43,0x45,0x31,0x38,0x38,0x46,0x41,0x36,0x44,0x36,0x37,0x43,0x32,0x39,0x32,0x39,0x37,0x35,0x34,0x35,0x45,0x38,0x33,0x31,0x41,0x34,0x30,0x37,0x31,0x37,0x45,0x44,0x31,0x45,0x35,0x44,0x42,0x32,
		0x37,0x42,0x42,0x42,0x43,0x45,0x33,0x43,0x39,0x37,0x36,0x37,0x31,0x45,0x38,0x38,0x30,0x41,0x46,0x45,0x37,0x44,0x30,0x30,0x32,0x32,0x32,0x37,0x31,0x44,0x36,0x36,0x45,0x45,0x46,0x36,0x31,0x42,0x42,0x36,0x39,0x35,0x37,0x46,0x35,0x41,0x46,0x46,0x30,0x36,0x33,0x34,0x30,0x32,0x34,0x33,0x43,0x33,0x38,0x33,0x43,0x34,0x36,0x36,0x32,0x43,0x41,0x31,0x30,0x35,0x30,0x45,0x36,0x38,0x42,0x33,0x43,0x41,0x44,0x43,0x44,0x33,0x46,0x39,0x30,0x43,0x43,0x30,0x36,0x36,0x44,0x46,0x38,0x35,0x38,0x34,0x34,0x42,0x32,0x30,
		0x35,0x44,0x34,0x31,0x41,0x43,0x43,0x30,0x45,0x43,0x33,0x37,0x39,0x32,0x30,0x45,0x39,0x37,0x31,0x39,0x42,0x46,0x35,0x33,0x33,0x35,0x36,0x33,0x32,0x37,0x31,0x38,0x33,0x33,0x33,0x35,0x34,0x32,0x34,0x44,0x46,0x30,0x32,0x44,0x36,0x44,0x41,0x37,0x41,0x34,0x39,0x38,0x41,0x41,0x35,0x37,0x46,0x33,0x44,0x32,0x42,0x38,0x36,0x45,0x34,0x45,0x38,0x46,0x46,0x46,0x42,0x45,0x36,0x46,0x34,0x45,0x30,0x46,0x30,0x42,0x34,0x34,0x32,0x34,0x45,0x45,0x44,0x46,0x34,0x43,0x32,0x32,0x35,0x42,0x34,0x34,0x39,0x38,0x39,0x34,
		0x43,0x42,0x42,0x38,0x0D,0x0A,0x0D,0x0A };
			string tsa = Encoding.Default.GetString (ToStringArray).Replace ("\r\n", Environment.NewLine);
			//Assert.AreEqual (tsa, x509.ToString (true), "ToString(true)");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x509.Issuer, "Issuer");
			Assert.AreEqual ("CN=Armed Forces Root, OU=DoD, O=U.S. Government, C=US", x509.Subject, "Subject");
		}

		string ToString (byte[] data)
		{
			StringBuilder sb = new StringBuilder ();
			for (int i = 0; i < data.Length; i++)
				sb.Append (data[i].ToString ("X2"));
			return sb.ToString ();
		}
	}
}

