/***************************** LICENSE START ***********************************

 Copyright 2018 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQECSTYLEHELP_H
#define MVQECSTYLEHELP_H

#include "MvQRequestPanelHelp.h"
#include "Parameter.h"

#include <QPen>
#include <QWidget>
#include <QAbstractItemModel>

class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QSlider;
class QSpinBox;
class QTabWidget;
class QToolButton;
class QTreeView;
class QSortFilterProxyModel;

class MvQStyleDbItem;
class RequestPanel;
class MvQStyleTreeWidget;

//Model to dislay/select the suites
class MvQEcStyleModel : public QAbstractItemModel
{
public:
    enum CustomItemRole {SortRole=Qt::UserRole+1};

    explicit MvQEcStyleModel(QObject *parent=0);
    ~MvQEcStyleModel();

    int columnCount (const QModelIndex& parent = QModelIndex() ) const;
    int rowCount (const QModelIndex& parent = QModelIndex() ) const;

    QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
    QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;

    QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
    QModelIndex parent (const QModelIndex & ) const;

    void setIndexFilter(QList<int>);
    void clearFilter();

protected:
    bool isFiltered(int) const;

    QList<int> indexFilter_;
};

class MvQEcStyleSelectionWidget : public QWidget
{
    Q_OBJECT
public:
    MvQEcStyleSelectionWidget(QWidget* parent=0);
    void setCurrent(const std::string&,const std::string& layerName);

protected slots:

    void slotItemSelected(const QModelIndex&);
    void slotClearFilter();

signals:
    void itemSelected(int);

protected:
    void checkButtonState();

    MvQStyleTreeWidget *browser_;
    MvQEcStyleModel* model_;
    QSortFilterProxyModel *sortModel_;
    std::string layerName_;
};

class MvQEcStyleHelp : public MvQRequestPanelHelp
{
Q_OBJECT

public:
    MvQEcStyleHelp(RequestPanel& owner,const Parameter& param);
    ~MvQEcStyleHelp() {}

    void start() {}
    bool dialog() {return false;}
    QWidget* widget() {return selector_;}

public slots:
    void slotSelected(int);

protected:
    virtual void refresh(const vector<string>&);

private:
    MvQEcStyleSelectionWidget* selector_;
    QString oriName_;
};

#endif // MVQECSTYLEHELP_H


