/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef IMPORTIPSECPROFILEDIALOG_H
#define IMPORTIPSECPROFILEDIALOG_H

#include <kdialog.h>

#include "ui_importopenvpnprofiledialogbase4.h"
#include "kvpncconfig.h"
#include "vpnaccountdata.h"

class ImportIpsecProfileDialog : public KDialog, public Ui_ImportOpenvpnProfileDialogBase
{
    Q_OBJECT

public:
    ImportIpsecProfileDialog(KVpncConfig *config, QWidget *parent, const QString& caption, QString file);
    ~ImportIpsecProfileDialog();

    void canAccept();

private:
    struct IpsecImportSection {
        QString SectionName;
        QStringList SectionData;
    };

public slots:
    void accept();
    void reject();

public:
    QString filename;
    bool importOk;
    VpnAccountData *acc;

private:
    KVpncConfig* config;
    QString Pkcs12CertFile;
    QString CertPath;
};

#endif
