(ert-deftest elpy-modules-run-should-call-all-modules ()
  (elpy-testcase ()
    (let* ((called-1 nil)
           (called-2 nil)
           (elpy-modules (list (lambda (option &rest args)
                                 (setq called-1 option))
                               (lambda (option &rest args)
                                 (setq called-2 (cons option args))))))
      (elpy-modules-run 'test 1 2 3)
      (should (equal called-1 'test))
      (should (equal called-2 '(test 1 2 3))))))
