#include <stdio.h>
#include <stdarg.h>
#include <sys/wait.h>

#include "util.h"
#include <string.h>

#define CFG_KEY_ROOT_DEV     "ROOT_DEV"
#define CFG_KEY_ROOT_TYPE     "ROOT_TYPE"
FILE *g_log_FP = NULL;

extern tui_cfg g_cfg;

int tui_strcat(char *dest,char *src,unsigned int dest_max_len) {
    int dest_len,src_len;
    if (!dest || !src)
        return TERROR;
    
    dest_len = strlen(dest);
    src_len = strlen(src);
    if ((dest_len+src_len+1)>dest_max_len)
        return TERROR;
    
    strcat(dest,src);
    return TOK;
}

int excute_shell_command(const char *cmd,char *buf,unsigned int buf_len) {
    FILE *stream;
	char res[MAX_LINE_LEN];
    int ret;

    if (!cmd || !buf)
        return TERROR;

    memset(buf,0,buf_len);
	
	stream = popen(cmd, "r");
	if(!stream){
		return TERROR;
	}
	while (fgets(res, MAX_LINE_LEN,stream) != NULL)
    {
        tui_strcat(buf,res,buf_len);
    }
    ret = pclose(stream);
    return WEXITSTATUS(ret);
}

void tui_log_msg(const char *fmt,...)
{
    if (g_log_FP != 0) {
	    va_list ap;
	    va_start(ap, fmt);
	    vfprintf(g_log_FP, fmt, ap);
	    va_end(ap);
	    //fflush(g_log_FP);
    }
}

int init_log(const char *filename) {
    if (!filename)
        return TERROR;
    
    if (g_log_FP) {
        fclose(g_log_FP);
        g_log_FP = NULL;
    }

    g_log_FP = fopen(filename,"w+");
    return TOK;
}

void close_log() {
    if (g_log_FP)
        fclose(g_log_FP);
    g_log_FP = NULL;
}

char* trim_space(char *buf) {
    char *pos = buf;
    int len = strlen(buf);
    if (len == 0)
        return pos;

    --len;
    while (len && (buf[len]==' ' || buf[len]=='\t')) {
        buf[len]='\0';
        --len;
    }
    while (*pos==' ' || *pos=='\t') ++pos;
    return pos;
}

int cfg_split_key_value(char *line,char **key,char **val) {
    char *pos,*pos2;

    pos = trim_space(line);
    if (pos == NULL)
        return TERROR;
    
    pos2 = strchr(pos,'=');
    if (pos2) {        
        ++pos2;
        while(*pos2!='\0'&&(*pos2==' '||*pos2=='\t'))
            ++pos2;
    }
    if (pos2==NULL || *pos2=='\0')
        return TERROR;
    *key = pos;
    *val = pos2;
    return TOK;
}

void read_config() {
    FILE *fp = NULL;
    char line[MAX_LINE_LEN] = {0};
    int len;
    char *key,*value;

    fp = fopen(CONFIG_FILE,"r");
    if (fp == NULL)
        return;
    
    while (fgets(line,MAX_LINE_LEN,fp)!=NULL) {
        TUI_LOG(("cfg read line:%s",line));
        len = strlen(line);
        if (line[len-1]=='\n')
            line[len-1]='\0';
        if (cfg_split_key_value(line,&key,&value)!=TOK)
            continue;
        if (!g_cfg.root_dev && strncmp(key,CFG_KEY_ROOT_DEV,strlen(CFG_KEY_ROOT_DEV))==0) {
            g_cfg.root_dev = strdup(value);
        }
        if (!g_cfg.root_type && strncmp(key,CFG_KEY_ROOT_TYPE,strlen(CFG_KEY_ROOT_TYPE))==0) {
            g_cfg.root_type = strdup(value);
        }
    }
    fclose(fp);
    return;
}