#!/bin/bash
set -ex
sudo mkdir -p /var/lib/deepin-initramfs-enhance
sudo touch /var/lib/deepin-initramfs-enhance/debug

# install debugfs
sudo apt-get install -y e2fsprogs

build_fs_break() {
	sudo apt-get install -y golang-go

	# download source from aptly repo
	url='http://aptly.uniontech.com/pkg/eagle-1054/release-candidate/ZGVlcGluLWluaXRyYW1mcy1lbmhhbmNl5rWL6K-VMjAyMi0xMi0xMyAxNToyMDo0Ng/pool/main/d/deepin-initramfs-enhance'
	tar_file=$(wget -O - $url | awk '/a href=.*tar.*/ { match($0, /href="(deepin-initramfs-enhance_.*\.tar.*)"/, arr); print arr[1] }')
	if [ -z "$tar_file" ]; then
		echo WARN: not found tar file >2
		exit 1
	fi
	source_url="$url/$tar_file"

	tar_file=/tmp/deepin-initramfs-enhance.tar.xz
	wget -O $tar_file "$source_url"

	pkg_unzip_dir=$(mktemp -d)
	pushd $pkg_unzip_dir
	tar axf $tar_file
	cd deepin-initramfs-enhance-*/fs-break
	# build fs-break
	export GOPROXY=https://goproxy.cn,direct
	go build -v
	sudo cp fs-break /sbin/fs-break
	popd
	rm -rf $pkg_unzip_dir
	rm $tar_file
}

# patch initramfs-tool files
patch_initramfs_tool() {

	patch_file=$(mktemp /tmp/XXXXX.patch)
	cat <<'EOF' >$patch_file
From 03706f802eefe12932f590830a82d338ebb63f8d Mon Sep 17 00:00:00 2001
From: electricface <songwentai@uniontech.com>
Date: Fri, 23 Dec 2022 14:05:06 +0800
Subject: [PATCH]

---
 init          |  4 ++++
 scripts/local | 11 +++++++++++
 2 files changed, 15 insertions(+)

diff --git a/init b/init
index faec712..32ca0da 100755
--- a/init
+++ b/init
@@ -76,6 +76,7 @@ export NETWORK_SKIP_ENSLAVED=
 export LIVE_BOOT_CMDLINE=
 export origin_root=
 export origin_rootmnt=
+export fsbreak=
 
 # mdadm needs hostname to be set. This has to be done before the udev rules are called!
 if [ -f "/etc/hostname" ]; then
@@ -237,6 +238,9 @@ for x in $(cat /proc/cmdline); do
 	fsck.repair=no)
 		fsckfix=n
 		;;
+	fsbreak=*)
+		fsbreak=${x#fsbreak=}
+		;;
 	esac
 done
 
diff --git a/scripts/local b/scripts/local
index 4c907db..06245f4 100644
--- a/scripts/local
+++ b/scripts/local
@@ -202,6 +202,17 @@ local_mount_root()
 		roflag=-w
 	fi
 
+	# shellcheck disable=SC2154
+	if [ -n "${fsbreak}" ]; then
+		fs-break -m "${fsbreak}" "${ROOT}"
+		retval=$?
+		if [ "$retval" -eq 2 ]; then
+			sync
+			sleep 3
+			reboot -f
+		fi
+	fi
+
 	checkfs "${ROOT}" root "${FSTYPE}"
 
 	# Mount root
-- 
2.20.1
EOF

	work_dir=$(mktemp -d)
	cp /usr/share/initramfs-tools/init $work_dir
	mkdir -p $work_dir/scripts
	cp /usr/share/initramfs-tools/scripts/local $work_dir/scripts
	pushd $work_dir
	patch -f -p1 <$patch_file || echo patch failed
	popd
	# after apply patch
	sudo cp $work_dir/init /usr/share/initramfs-tools/init
	sudo cp $work_dir/scripts/local /usr/share/initramfs-tools/scripts/local
	rm -rf $work_dir
	rm $patch_file
}

if [ "$1" = '-no-build-fs-break' ]; then
	echo skip build fs-break
	sudo cp /tmp/fs-break /sbin/fs-break
else
	build_fs_break
fi

if ! grep -q 'fsbreak=' /usr/share/initramfs-tools/init; then
	patch_initramfs_tool
fi

sudo update-initramfs -u -k all
