# 檔案管理器|dde-file-manager|

## 概述

檔案管理器是一款功能強大、簡單易用的文件管理工具。它沿用了傳統檔案管理器的經典功能和布局，並在此基礎上簡化了使用者操作，增加了很多特色功能。一目了然的導航欄、智慧識別的搜尋框、多樣化的檢視及排序讓您管理起來得心應手，經典和超越，只為給您更好的體驗！

![1|overview](fig/p_overview.png)

## 使用入門

透過以下方式執行或關閉檔案管理器，或者建立檔案管理器的捷徑。

### 執行檔案管理器

1. 單擊桌面底部的 ![deepin_launcher ](../common/deepin_launcher.svg)，進入啟動器介面。
2. 上下滾動滑鼠滾輪瀏覽或透過搜尋找到檔案管理器![deepin_file_manager](../common/deepin_file_manager.svg)，單擊執行。
3. 右鍵單擊 ![deepin_file_manager](../common/deepin_file_manager.svg)，您可以：
 - 單擊 **建立桌面捷徑**，在桌面建立捷徑。
 - 單擊 **釘選到Dock**，將應用程式固定到Dock。
 - 單擊 **開機啟動**，將應用程式添加到開機啟動項，在電腦開機時自動執行該應用。

>![tips](../common/tips.svg) 竅門：您可以使用組合鍵 **Super + E** 啟動檔案管理器。

### 關閉檔案管理器

- 在檔案管理器介面，單擊  ![close_icon](../common/close_icon.svg)，關閉檔案管理器。
- 在任務欄右鍵單擊 ![deepin_file_manager](../common/deepin_file_manager.svg)，選擇 **全部關閉** 來關閉檔案管理器。
- 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)，選擇 **退出** 來關閉檔案管理器。

### 查看快捷鍵

在檔案管理器介面上，按下**Ctrl + Shift + /**  組合鍵來查看快捷鍵，熟練的使用快捷鍵，將大大提升您的操作效率。

![1|hotkey](fig/hotkey.png)

## 主介面

檔案管理器的主介面簡單易用、功能全面，熟練地使用介面功能將使文件管理更加簡單高效。

![1|main-interface](fig/p_maininterface.png)


| 標號 | 名稱          | 描述                                                         |
| ---- | ------------- | ------------------------------------------------------------ |
| 1    | 導航欄        | 單擊導航圖示，快速存取本機文件、磁碟、網路鄰居、書籤、標記等。 |
| 2    | 地址欄        | 透過地址欄，您可以快速切換訪問歷史、在上下級目錄間切換、搜尋、輸入地址訪問。 |
| 3    | 圖示/列表檢視 | 單擊 ![icon_view](../common/icon_view.svg) , ![list_view](../common/list_view.svg)圖示，以圖示或列表形式查看文件（夾）。 |
| 4    | 訊息欄        | 單擊 ![fileinfo](../common/fileinfo.svg)， 查看文件（夾）的基本訊息和標記。 |
| 5    | 選單欄        | 透過主選單，您可以建立視窗、切換視窗主題、設定共享密碼、設定檔案管理器、查看說明文件和關於訊息、關閉檔案管理器。 |
| 6    | 狀態欄        | 顯示文件數量或者已選中文件的數量。                           |


> ![tips](../common/tips.svg) 竅門：可拖動左側導航欄右邊的分隔線來改變其寬度。

## 基本功能

檔案管理器具備基本的文件管理功能，對文件(夾)進行新增、複製、重新命名、刪除等操作都非常簡單。

### 新增文件

#### 新增文件

1. 在檔案管理器介面上，單擊滑鼠右鍵。
2. 單擊 **新增文件**。
3. 選擇新增文件的類型。
4. 輸入新增文件的名稱。

![0|newdo](fig/newdo.png)

#### 新增資料夾

1. 在檔案管理器介面上，單擊滑鼠右鍵。
2. 單擊 **新增資料夾**。
3. 輸入資料夾的名稱。

### 重新命名文件

1. 在檔案管理器介面上，右鍵單擊文件。
2. 選擇 **重新命名**。
3. 輸入文件名稱，按 **Enter** 鍵或者滑鼠單擊介面空白區域。



> ![tips](../common/tips.svg) 竅門：在 **設定** 中勾選「重新命名時隱藏文件副檔名」，能更方便地修改文件名稱。

### 批次重新命名

1. 在檔案管理器介面上，選中多個文件。
2. 右擊文件，並選擇 **重新命名**。
   - **取代文件**尋找需要取代的文字，並輸入取代後的文字，文件名中的關鍵字將被統一取代。
   - **加入文件** 輸入需要加入的文字，並選擇目錄是檔名之前還是之後，文件名將統一加入被添加的文字。
   - **自訂文件** 輸入文件名，並輸入序列的遞進數字，文件名將統一改成新文件名+遞進數字。
4. 單擊 **重新命名** 來完成操作。

![1|rename](fig/p_batchrename.png)

### 查看文件

單擊介面上的 ![icon_view](../common/icon_view.svg) 、![list_view](../common/list_view.svg) 圖示來切換圖示檢視和列表檢視。

- 圖示檢視：平鋪顯示文件的名稱、圖示或縮圖。

![1|icon-view](fig/p_iconview.png)

- 列表檢視：列表顯示文件圖示或縮圖、名稱、修改時間、大小、類型等訊息。

![1|list-view](fig/p_listview.png)

> ![tips](../common/tips.svg) 竅門：使用  **Ctrl + 1**  和  **Ctrl + 2**   快捷鍵，切換圖示檢視和列表檢視。

### 排序文件

1. 在檔案管理器介面上，單擊滑鼠右鍵。
2. 選擇 **排序順序**。
3. 在子選單中選擇以文件名稱、修改時間、大小或類型來排序文件。

您可以在 **主選單** > **設定 > 基礎設定** 中，勾選 **文件和資料夾混合排序**，將文件和資料夾按照所選的類型進行混合排序。

> ![tips](../common/tips.svg) 竅門：在列表檢視中，單擊表頭欄的列標籤來切換升序、降序。

### 打開文件

1. 在檔案管理器介面上，右鍵單擊文件。
2. 選擇 **用其他程式打開** > **選擇預設打開程式**。
3. 在程式列表中選擇應用程式。

> ![notes](../common/notes.svg) 說明：直接雙擊文件會使用預設程式打開。您可以選擇相同類型的多個文件，右鍵選擇「用其他程式打開」選項，一次打開多個文件。

![0|open](fig/p_open.png)

### 隱藏文件

1. 在檔案管理器介面上，右鍵單擊文件。
2. 選擇 **屬性**，勾選 **隱藏此文件**。

### 複製文件

1. 在檔案管理器介面上，右鍵單擊文件。
2. 單擊 **複製**。
3. 選擇一個目標儲存位置。
4. 單擊滑鼠右鍵，然後選擇 **貼上**。

### 壓縮文件

1. 在檔案管理器介面，右鍵單擊文件（夾）。
2. 選擇 **壓縮**。
3. 彈出歸檔管理器壓縮介面，可以設定壓縮包格式、名稱、儲存路徑等，單擊 **壓縮**。

> ![tips](../common/tips.svg) 竅門：您也可以直接在右鍵選單中選擇 **添加到xxx.7z** 或 **添加到xxx.zip**，快速將文件（夾）壓縮成7z或zip格式。


### 刪除文件

1. 在檔案管理器介面上，右鍵單擊文件。
2. 選擇 **刪除** 。
   - 被刪除的文件可以在回收桶中找到，右鍵單擊回收站中的文件可以進行 **還原** 或 **刪除** 操作。在外接裝置刪除文件會將文件徹底刪除，無法從回收站找回。
   - 被刪除的文件的捷徑將會失效。

> ![notes](../common/notes.svg) 說明：您可以在 **主選單 > 設定 > 進階設定** 中勾選 **打開普通刪除提示**，每次刪除文件時會彈出確認刪除的提示框。

### 復原操作

在檔案管理器中，可以用 **Ctrl + Z** 來復原上一步操作，包括：

- 刪除建立的文件。
- 復原重新命名（包括重新命名文件後綴）之前的名字。
- 從回收站還原剛刪除的文件。
- 復原文件到移動（剪下移動、滑鼠移動）前的原始路徑。
- 刪除複製貼上的文件。

>![attention](../common/attention.svg) 注意：復原動作最多只能返回兩步；如果操作中有覆蓋某個同名文件和徹底刪除文件，則復原只能返回到這一步。

### 文件屬性

文件屬性會顯示文件的基本資訊，打開方式和權限設定。資料夾内容會顯示資料夾的基本資訊，共享訊息和權限設定。

1. 在檔案管理器介面上，右鍵單擊文件。
2. 選擇 **屬性**，查看文件屬性。

![2|info](fig/info.png)

> ![notes](../common/notes.svg) 說明：查看多個文件屬性會顯示文件總大小和數量；查看捷徑的屬性將會額外顯示來源文件地址。您還可以使用 **Ctrl + I** 組合鍵查看文件屬性。

### 病毒查殺

1. 在檔案管理器界面上，右鍵單擊文件（夾）。
2. 選擇 **病毒查殺**，彈出安全中心病毒查殺界面，您可以對該文件（夾）進行安全掃描，具體操作請參閱安全中心的 [病毒查殺](dman:///deepin-defender#病毒查殺)。

   > ![notes](../common/notes.svg) 說明：
   > - 如果當前安全中心有查殺任務，則在彈出的對話框中單擊 **查看** 進入安全中心病毒查殺界面進行查看。
   > - 安全中心默認打開 **加入「病毒查殺」到文件右鍵選單** 的功能，您也可以進入安全中心設置界面，取消勾選該功能。取消勾選後檔案管理器右鍵菜單中不會顯示病毒查殺的選項。

## 常用操作

檔案管理器具備很多特色功能，這些功能都讓文件管理更加簡單、高效。

### 切換地址欄

地址欄由歷史導航、麵包屑和輸入框共同組成。通常情況下地址欄顯示麵包屑。

![0|addressbar](fig/addressbar1.png)

- 單擊歷史導航按鈕，您可以快速在歷史瀏覽記錄間切換，查看前一個地址或者後一個地址。
- 文件所在位置的每一個層級都會形成一個麵包屑，透過來回單擊麵包屑可以快速在不同文件層級間切換。

當您單擊搜尋圖示，或者在文件路徑上右鍵選擇 **編輯位址**，地址欄會切換為輸入框狀態。在輸入框外單擊時，位址欄會自動復原到麵包屑狀態。

![0|addressbar](fig/addressbar2.png)

- 輸入框帶有智慧識別功能，您可以輸入關鍵字或者訪問地址Enter，系統會自動識別並進行搜尋或訪問。

### 搜尋文件

檔案管理器支援多種檢索方式，既支援透過文件名稱、文件內容進行普通搜尋，也支援透過文件類型、建立時間等進行進階搜尋，提高工作效率，便於文件管理。
  - 需要指定目錄搜尋時，請先進入該目錄，然後再進行搜尋。

> ![notes](../common/notes.svg) 說明：
> 在檔案管理器的 **設定**中，預設勾選了 **自動索引內部硬碟**，您可以選擇勾選 **外部裝置連上電腦時索引**，加快在外部裝置的搜尋速度。

#### 全文搜尋

您可以透過文件內容關鍵字來搜尋文件。

1. 在檔案管理器中，單擊 ![icon_menu](../common/icon_menu.svg) > **設定**。
2. 在進階設定項勾選 **全文搜尋** 來打開此功能。
3. 使用組合鍵  **Ctrl + F** 或在地址欄中單擊搜尋按鈕進入搜尋狀態，輸入關鍵字後按下鍵盤上的 **Enter** 鍵，搜尋相關文件。

#### 進階搜尋

當文件較多，搜尋較慢時，啟用進階搜尋縮小搜尋範圍，提高搜尋效率。

1. 在搜尋狀態下，輸入關鍵字後按 **Enter** 鍵，當搜尋到結果時，搜尋框右側顯示 ![filter](../common/filter.svg) 圖示，單擊該圖示可進行進階搜尋的操作。

2. 選擇搜尋範圍、文件大小、文件類型、修改時間、訪問時間和建立時間，進行更精準的搜尋。

![0|filter](fig/p_filter.png)

### 最近使用

在左方面板上預設有 **最近** 入口，單擊可以查看最近使用的文件項目。文件預設按照訪問時間倒序排列。


> ![notes](../common/notes.svg) 說明：若想隱藏「最近」，可在設定 > 基本設定 > 隱藏文件，取消勾選「在左方面板顯示最近文件項目」。若要隱藏某一個文件的訪問記錄，右擊該文件選擇 **移除**，該操作不會刪除文件。

### 多分頁

檔案管理器支援多分頁顯示。

1. 在檔案管理器介面上，右鍵單擊資料夾。
2. 選擇 **在新分頁中打開**。
3. 當視窗有多個分頁時，可以：
 - 單擊標籤欄右側的 + 繼續添加分頁。
 - 將滑鼠指標置於分頁上，單擊關閉按鈕 × 或單擊滑鼠中鍵，關閉分頁。

   ![1|tab](fig/p_tab.png)

> ![tips](../common/tips.svg) 竅門：檔案管理器視窗只有一個分頁時，分頁欄是隱藏的，您還可以使用快捷鍵  **Ctrl** + **T** 來建立分頁。

### 書籤管理

為常用資料夾添加書籤，以便從左側導航欄快速訪問。

- 添加書籤：右鍵單擊資料夾，選擇 **加到書籤** 就可以在導航欄建立書籤。
- 移動書籤：在導航欄上下拖動書籤調整書籤排序。
- 刪除書籤：右鍵單擊書籤，選擇 **移除** 來刪除書籤；或右鍵單擊已添加書籤的資料夾，選擇 **移除書籤** 來刪除書籤。

### 標記内容

透過給資料（夾）添加標記，可以更好地分類管理您的文件。

> ![notes](../common/notes.svg) 說明：目前僅x86平台支援 **標記内容** 功能。

#### 添加標記

您可以一次為多個文件（資料夾）添加標記，一個文件（資料夾）也可以添加多個標記；添加成功的標記會出現在左側導航欄內。

##### 透過編輯框添加標記

1. 右鍵單擊文件（資料夾），選擇 **標記内容**。
2. 輸入標記名稱。若要添加多個標記，用逗號分隔。
3. 編輯完成後單擊空白處儲存設定。

>![notes](../common/notes.svg) 說明：標記顏色從8種預設顏色中隨機分配。





##### 透過顏色按鈕添加標記

右鍵單擊文件（資料夾），選擇「顏色按鈕」，直接生成這個顏色的標記。



##### 透過右側訊息欄添加標記
選擇文件（資料夾）後，單擊 ![fileinfo](../common/fileinfo.svg)，在右側訊息欄中也可以添加標記。





>![notes](../common/notes.svg) 說明：複製或剪下有標記的文件，所產生的文件仍然具有同樣的標記。


#### 重新命名標記

在側邊導航欄中，右鍵單擊某個標記，選擇 **重新命名**，修改目前標記的名稱。

![1|rename tag](fig/renametag.png)

#### 修改標記顏色

在左側導航欄中，右鍵單擊某個標記，選擇「顏色按鈕」，即可修改目前標記的顏色。

#### 排序標記

上下拖動標記即可調整標記排序。

#### 刪除標記

右鍵單擊某個標記，選擇 **移除**，刪除目前標記。



### 文件預覽

檔案管理器支援空白鍵預覽功能，選中文件並按下鍵盤上的空白鍵就可以快速預覽文件。預覽視窗可以查看圖片解析度、文件大小、文字內容等，還支援gif、音訊、影片播放。

#### 預覽影片

1. 選擇您要預覽的影片文件，按下空白鍵，即可開始預覽。
2. 單擊影片任意地方可暫停播放。
3. 播放過程中，可以拖動進度條來快進快退。
4. 單擊底部 **打開** 按扭，在預設程式中打開該影片文件。

![1|video preview](fig/videopreview.png)

> ![notes](../common/notes.svg) 說明：您也可以同時選擇多個文件，按下空白鍵進行預覽。


### 權限管理
選擇對應文件/資料夾，單擊右鍵，選擇屬性，單擊 **存取權限**， 為擁有者，群組，和其他使用者設定文件權限。

![2|permission](fig/permission.png)

### 我的共享

當您設定了共享資料夾時，「我的共享」將會出現在導航欄上。

#### 共享本機文件

共享本機文件，方便區域網路中的其他使用者查看、編輯或下載文件，提升辦公效率。

共享文件需要啟動smb服務，首次使用文件共享功能時，系統會彈出「啟動smb服務認證」視窗，輸入登入密碼完成認證即可打開smb服務。

1. 在檔案管理器介面，右鍵單擊資料夾，選擇 **共享資料夾**。
2. 在資料夾的屬性視窗，勾選 **共享資料夾**。
3. 設定文件共享名、權限和是否允許匿名訪問。
4. 單擊 **設定密碼**。
5. 彈出「輸入共享密碼」視窗，輸入密碼，單擊 **確定**。

當設定了共享密碼後，介面會顯示「修改密碼」，您可以在此修改共享密碼，或者在檔案管理器主選單中單擊 **設定共享密碼** ，修改共享密碼。


> ![tips](../common/tips.svg) 竅門：單擊網路路徑和使用者名稱右側的複製按鈕 ![icon](../common/copy.svg)， 將訪問路徑和使用者名稱複製到剪貼簿，便於您將訊息分享給訪問者。



#### 訪問共享文件

區域網路中的使用者可以透過共享者提供的網路路徑訪問共享文件。

1. 透過以下方法之一訪問共享文件。
   - 直接在地址欄中輸入伺服器地址（例如：smb://10.0.2.15），按下鍵盤上的 **Enter** 鍵。
   - 單擊 ![icon_menu](../common/icon_menu.svg) > **連線到伺服器**，輸入伺服器地址，單擊 **連接**。
   
2. 選擇需要訪問的共享資料夾，彈出「要分享10.0.2.15上的XX需要密碼」的視窗。
   - 如果該資料夾設定為不允許匿名訪問，則在「註冊使用者」頁簽中輸入共享者的系統使用者名稱和共享密碼。
   - 如果該資料夾設定為允許匿名訪問，在「註冊使用者」頁簽中輸入共享者的系統使用者名稱和共享密碼；在「匿名」頁簽中則不需要輸入使用者名稱和密碼。
3. 選擇是否記住密碼，單擊 **連線**。

![1|visitshareshare](fig/visitshare.png)



#### 取消共享文件

當取消了所有共享文件後，左側導航欄上「我的共享」則會移除，您可以透過以下方法之一取消本機共享文件。

- 右鍵單擊已共享的資料夾，選擇 **取消共享**。
- 右鍵單擊已共享的資料夾，選擇 **屬性**，在屬性視窗共享管理區域中取消勾選 **共享此資料夾**。



### 以管理員身份開新視窗

前提條件：「控制中心」>「一般設定」中開發者模式已打開。

1. 在檔案管理器介面空白處單擊滑鼠右鍵。
2. 選擇 **以管理員身份開新視窗**，在彈出的視窗中輸入使用者密碼，單擊 **確定**。
3. 該資料夾會以新視窗打開，在此視窗中可以進行進階權限的操作，關閉視窗後，終止管理員權限。

### 開啟終端機

1. 在檔案管理器介面空白處單擊滑鼠右鍵。
2. 選擇 **開啟終端機**，會啟動終端應用程式，終端的路徑為目前目錄。

![0|open-terminal](fig/openinterminal.png)

### 燒錄光碟
您可以透過燒錄功能將音樂、影片、圖片或鏡像文件複製到光碟中。請準備一張CD或DVD光碟和一台具備燒錄功能的裝置，才能執行如下操作。

<table class=block1>
<tr>
   <th align=left>類型</th>
   <th align=left>光碟格式</th>
   <th align=left>ISO9660</th>
   <th align=left>UDF</th>
</tr>
<tr>
   <td rowspan="2">空盤</td>
   <td>DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支援</td>
   <td>支援</td>
</tr>
<tr>
   <td>非DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支援</td>
   <td>不支援</td>
</tr>
<tr>
   <td rowspan="2">非空盤</td>
   <td>DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支援追加文件</td>
   <td>僅支援Windows原生工具燒錄的格式</td>
</tr>
<tr>
   <td>非DVD-R、DVD+R、CD-R、CD-RW</td>
   <td>支援追加文件</td>
   <td>不支援追加文件</td>
</tr>   
</table>


#### 燒錄本機文件

1. 在檔案管理器介面，單擊導航欄中的光碟圖示，進入光碟燒錄介面。

![cd](fig/cd_interface.png)

2. 將需要燒錄的文件（夾）拖曳至光碟燒錄介面，或右鍵單擊 文件（夾），選擇 **添加至光碟燒錄**。
3. 單擊介面右上角 **燒錄** 按鈕。
4. 彈出「光碟名稱」視窗，輸入光碟名稱。您也可以單擊 **進階設定** 進入進階設定介面，設定檔案系統、寫入速度，或勾選「允許追加資料」、「核驗資料」等，單擊 **燒錄**。

![cd](fig/cd_rename.png)

5. 彈出「燒錄完成」提示框，單擊 **確定** 完成燒錄。

#### 擦除光碟

1. 在檔案管理器介面，右鍵單擊導航欄中的光碟圖示。
2. 選擇 **移除**，再次右鍵單擊該光碟圖示並選擇 **清除**。
3. 彈出「確定擦除光碟內容」提示框，單擊 **清除**。

#### 存為鏡像文件

1. 在檔案管理器界面，單擊導航欄中的光碟圖示，進入光碟燒錄界面。

![cd](fig/cd_save_as_iso.png)

2. 單擊界面右上角 **存為鏡像文件** 按鈕，彈出“存為鏡像文件”窗口。

![cd](fig/cd_create_iso.png)

3. 您可以選擇指定路徑後單擊 **創建鏡像**，完成光碟鏡像文件的保存。

### 建立捷徑

1. 在檔案管理器介面上，右鍵單擊文件或資料夾。
2. 選擇 **建立連結**。
3. 在跳出視窗中選擇建立位置、連結名稱。
4. 單擊 **儲存**，在目標位置會生成該文件(夾)的捷徑。

> ![tips](../common/tips.svg) 竅門：選擇 **傳送到桌面** 可以直接在桌面上生成該文件(夾)的捷徑。

### 傳送文件到外接磁碟

當有外接磁碟接入時，您可以將文件或資料夾發送到外接磁碟。

1. 在檔案管理器介面上，右鍵單擊文件或資料夾。
2. 選擇 **傳送到** > 外接磁碟。
3. 文件或資料夾將會被傳送到移動外接磁碟。

### 傳送文件到藍牙
若您的電腦配備了藍牙模組，便可透過藍牙進行短距離文件傳輸的操作。

前提條件：傳送端與接收端藍牙設備已配對並成功連接。具體連接方法可參考 [連接藍牙設備](dman:///dde#連接藍牙設備)。

1. 在檔案管理器界面，右鍵單擊需要傳送的文件或文件壓縮包。
2. 選擇 **傳送到** > **傳送到藍牙**。
3. 在彈出的藍牙文件傳輸視窗中勾選接收設備，單擊 **下一步**。
4. 此時接收端會收到文件接收的請求，待接收端同意請求後，傳送端開始傳輸文件。

## 統信UOS助手

統信UOS助手是一款實現手機與電腦間跨端協作、高效傳輸以及即時同步的工具，將手機與電腦連接，或者使用無線投送功能，即可輕鬆傳輸圖片、影片、文件等。

>![icon](../common/notes.svg) 說明：僅安卓手機支援安裝統信UOS助手。

### 準備工作

#### 安裝統信UOS助手

1. 單擊左側導航欄 **我的手機** 或系統工具列中的圖示 ![icon](../common/found.svg)。
2. 在我的手機介面，單擊 **安裝統信UOS助手**，彈出二維碼視窗。
   - 透過手機微信或瀏覽器掃描二維碼，下載並安裝統信UOS助手。
   - 單擊 **下載APK安裝包**，將安裝包下載到電腦端，下載完成後再匯入至手機端進行安裝。

   ![phone](fig/myphone.png)

#### 登入統信UOS助手

統信UOS助手支援三種登入方式：手機快捷登入、微信登入、帳號密碼登入，請選擇一種方式進行登入。如果您尚未註冊帳號，請在登入介面單擊 **註冊帳號** 進行註冊。

#### 設定發現方式

通過「發現設定」功能，設定手機和電腦被發現的方式。在統信UOS助手介面，單擊右上角的 **發現設定**；在電腦系統工具列上，右鍵單擊圖示 ![icon](../common/found.svg)，選擇 **發現設定**，您可以選擇：

- **允許被所有人發現**：在區域網路內，允許所有處於同一網路且在同一網段的裝置發現本手機或電腦。
- **僅限同一UOS ID帳號發現**：在區域網路內，允許登入同一個UOS ID的裝置發現本手機或電腦。
- **不被發現**：所有裝置都不能發現本手機或電腦。
- **允許被登入同一UOS ID的遠端裝置發現**（電腦端）：允許登入同一個UOS ID的遠端裝置發現本電腦。



### 連接手機端與電腦端

登入統信UOS助手後，您可以透過掃碼連接或搜尋電腦的方式將手機與電腦連接起來。

#### 掃碼連接

前提條件：手機與電腦連接同一無線網路且在同一個網段內。

1. 在電腦端，單擊檔案管理器左側導航欄 **我的手機** 或系統工具列中的圖示 ![icon](../common/found.svg)，彈出「使用統信UOS助手掃碼連接」的視窗。
2. 在手機端，進入統信UOS助手介面，單擊 **掃碼連接**，掃描步驟1視窗中的二維碼，完成連接。

#### 搜尋電腦

前提條件：手機與電腦處於同一無線網路且在同一網段中（僅支援互發文件，不支援查看和編輯文件）或登入同一個UOS ID帳號；且手機與電腦允許被發現。

1. 在統信UOS助手介面，單擊 **搜尋電腦**。
2. 在搜尋列表中選擇需要連接的電腦，完成連接。

如果需要斷開連接，您可以：

- 在統信UOS助手介面上單擊按鈕 ![icon](../common/exit.svg) 斷開連接。
- 在電腦上右鍵單擊系統工具列中的圖示 ![icon](../common/found.svg)，選擇您的手機，在跳出視窗中單擊 **斷開連接**。

### 管理文件

手機與電腦連線成功後，您可以發送文件、查看文件和管理文件。

#### 傳輸文件

- **透過統信UOS助手介面進行文件傳輸**

   發送手機文件至電腦：在統信UOS助手介面，單擊 **傳輸助手**，在傳輸視窗中發送文件至電腦端。

- **透過檔案管理器介面進行文件傳輸**

   發送電腦文件至手機：在 **檔案管理器 > 我的手機** 介面，右側傳輸視窗中，您可以選擇電腦文件至該視窗中進行發送；或者右鍵單擊電腦中某個文件，選擇 **發送到我的手機**。

- **透過無線投送功能進行文件傳輸**

   當裝置處於同一無線網路且在同一網段中或已登入同一UOS ID帳號，且裝置允許被發現，您可以透過無線投送功能，將文件從一台裝置投送到另一台裝置中。
   1. 在電腦上，右鍵單擊需要投送的文件，選擇 **無線投送**。
   2. 在跳出視窗中選擇需要投送的手機或電腦，完成投送。

   >![icon](../common/notes.svg) 說明：
   >- 手機端需要安裝統信UOS助手並登入帳號後，才能接收電腦端投送的文件。
   >- 登入同一UOS ID後，可以進行遠端投送的操作。

#### 查看/編輯文件

- 在手機上查看電腦文件：在統信UOS助手介面，單擊 **我的電腦**，您可以打開、下載或分享電腦文件。
- 在電腦上查看/編輯手機文件：在 **檔案管理器 > 我的手機** 介面，分類展示手機相冊、影片、文件等資料夾，您可以打開、編輯資料夾中的文件，文件經過編輯並儲存後將同步至手機端。


## 文件角標

您可以透過命令列，將圖示文件指定給一個文件或資料夾作為角標顯示出來。
   >![icon](../common/notes.svg) 說明：
   >- 角標文件支援svg、jpg、png、bmp、gif格式，且大小不超過100KB。
   >- 隨身碟及光碟下的文件，不支援添加角標。

### 添加單個角標

1. 在終端輸入指令 **gio set xxx(文件路徑)  -t stringv metadata::emblems "xxx(圖示路徑)"** ，該指令預設在文件（夾）右下角添加角標。

   >![icon](../common/attention.svg) 注意：系統已定義的特殊角標，不支援被取代。

2. 您也可以在上述指令中加入位置參數，將角標添加在文件（夾）的左上角（lu）、左下角（ld）、右上角（ru）或右下角（rd）。

例如：在文件（夾）左上角添加角標

**gio set xxx(文件路徑)  -t stringv metadata::emblems "xxx(圖示路徑);lu"**

![mark](fig/single.png)

### 添加多個角標

在命令列中加入**|**符號將角標文件路徑連結起來，為文件（夾）添加2~4個角標。文件（夾）同一個位置不支援疊加角標，僅支援取代。

例如：在文件（夾）四個角都添加角標

**gio set xxx(文件路徑)  -t stringv metadata::emblems "xxx(圖示路徑);lu|xxx(圖示路徑);ld|xxx(圖示路徑);ru|xxx(圖示路徑);rd"**

![mark](fig/multi.png)

### 復原角標

在終端中輸入指令 **gio set xxx(文件路徑) -t stringv metadata::emblems ""** 復原文件（夾）上所有的角標。

## 文件保險箱

文件保險箱旨在為您打造專屬的安全空間，為您的隱私保駕護航。先進的加密技術，便捷的操作流程，使用起來得心應手。

### 加密保險箱

保險箱現提供兩種加密方式，分別為 **金鑰加密** 和 **透明加密**，新增的 **透明加密** 提供了無需輸入保險箱密碼，即可訪問保險箱的便捷加密方式，該加密方式同樣確保了保險箱內文件的安全。

#### 透明加密

1. 單擊導航欄中的保險箱圖示 ![file_vault](../common/file_vault.svg)，或者在計算機界面雙擊 “我的保險箱”，在彈出的對話框中單擊 **開啟**。 
2. 在“加密方式”下，選擇 **透明加密** 後單擊 **下一步**，直接加密保險箱。

![encrypt](fig/transparent_encryption.png)

#### 金鑰加密

1. 單擊導航欄中的保險箱圖示 ![file_vault](../common/file_vault.svg)，或者在計算機界面雙擊 “我的保險箱”，在彈出的對話框中單擊 **開啟**。 
2. 加密方式預設為 **金鑰加密**，可設置保險箱密碼和密碼提示訊息，單擊 **下一步**。

![encrypt](fig/key_encryption.png)

> ![notes](../common/notes.svg) 說明: 密碼必須同時包含大寫字母、小寫字母、數字和符號，且字元不小於8位，否則無法進入下一步。

3. 在儲存金鑰文件視窗中，設定金鑰文件的儲存位置，如果您忘記了保險箱密碼，可使用金鑰文件找回密碼。單擊 **下一步**。

![encrypt](fig/save.png)

4. 單擊 **加密保險箱**，彈出認證視窗，輸入使用者登入密碼後單擊 **確定**。

5. 在加密完成對話框中單擊 **確定**， 完成保險箱密碼設定。

![encrypt](fig/finish.png)

### 鎖定保險箱

將文件放入保險箱後，右鍵單擊導航欄 ![file_vault](../common/file_vault.svg) 圖示或者在電腦介面右鍵單擊「我的保險箱」。
- 選擇 **立即上鎖**，立即將文件保險箱鎖上。
- 選擇 **自動上鎖**，在其下拉選單進行設定：
  + 選擇「永不」，電腦在鎖定螢幕或關機前一直保持未上鎖狀態。
  + 選擇「5分鐘」、「10分鐘」或者「20分鐘」後自動上鎖保險箱。

![0|right](fig/right.png)


### 解鎖保險箱

1. 單擊 ![file_vault](../common/file_vault.svg) 或者在電腦介面雙擊 **我的保險箱**。
2. 在解鎖保險箱的視窗中，輸入保險箱密碼，單擊 **解鎖**。
3. 如果忘記了保險箱密碼，單擊 **忘記密碼**，選擇金鑰文件的儲存位置後，單擊 **驗證金鑰** 找回密碼。

![encrypt](fig/unlock.png)


>![0|tips](../common/tips.svg)竅門：您也可以右鍵單擊 ![file_vault](../common/file_vault.svg) 或者 **我的保險箱**，選擇 **解鎖**，解鎖保險箱。


### 刪除保險箱

刪除保險箱需要提前解鎖保險箱。
1. 右鍵單擊導航欄 ![file_vault](../common/file_vault.svg) 圖示或者在電腦介面右鍵單擊 「我的保險箱」，選擇 **刪除保險箱**。
2. 在彈出的刪除保險箱視窗中輸入保險箱密碼，單擊 **刪除**。
3. 在彈出的認證視窗中輸入使用者登入密碼，單擊 **確定** 完成刪除操作。
> ![attention](../common/attention.svg) 注意：刪除保險箱會將裡面的文件永久刪除。在進行刪除操作前，請將保險箱中的文件備份。

## 磁碟管理

檔案管理器可以管理本機和外接磁碟。

### 查看磁碟

您的本機磁碟會顯示在檔案管理器的左側導航欄上。當您掛載外接磁碟或者插入其他移動儲存裝置時，也會在導航欄上看到相應的磁碟圖示。

<table class="block1">
    <caption></caption>
    <tbody>
        <tr>
            <td>本機磁碟</td>
            <td>本機硬碟分區的所有磁碟</td>
        </tr>
        <tr>
            <td>外接磁碟</td>
            <td>包括行動硬碟、隨身碟、光碟</td>
        </tr>
    	<tr>
            <td>移動裝置</td>
            <td>手機記憶體、記憶卡、SD卡等</td>
        </tr>
    </tbody>
</table>

> ![notes](../common/notes.svg) 說明：如果磁碟或磁碟中的資料夾被加密了，請輸入密碼後查看文件。

### 本機磁碟

#### 隱藏本機磁碟

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg) > **設定**。
2. 在進階設定選項中勾選 **隱藏系統硬碟**。

#### 重新命名本機磁碟
1. 在左側導航欄或電腦介面，右鍵單擊需要重新命名的本機磁碟。
2. 選擇 **重新命名**。
3. 輸入新名稱後按下鍵盤上的 **Enter** 鍵或單擊空白處儲存修改。

> ![tips](../common/tips.svg) 竅門：在電腦介面，慢速雙擊本機磁碟，呈現編輯框後便可進行重新命名操作。

![0|disk](fig/p_rename_disk.png)

### 外接磁碟

#### 彈出外接磁碟

1. 在左側導航欄或電腦介面，右鍵單擊需要移除的磁碟。
2. 選擇 **安全移除**。
3. 磁碟將從磁碟列表中刪除，一併彈出該磁碟的所有分區。

![0|disk](fig/disk1.png)

> ![tips](../common/tips.svg) 竅門：如果要彈出光碟，請選擇 **彈出** 來移除光碟。單擊導航欄中磁碟右邊的 ![unmount](../common/unmount_normal.svg) 同樣可以彈出磁碟或光碟。

#### 重新命名外接磁碟
1. 在左側導航欄或電腦介面，右鍵單擊需要重新命名的磁碟。
2. 選擇 **移除** 後，再次單擊右鍵選擇 **重新命名**。
3. 輸入新的卷標名稱，按下鍵盤上的 **Enter** 鍵或單擊空白處儲存修改。

#### 格式化外接磁碟

1. 在左側導航欄或電腦介面，右鍵單擊需要格式化的磁碟。
2. 選擇 **卸载**，再次單擊右鍵選擇 **檔案格式**。
3. 在格式化跳出視窗中設定格式化之後的文件類型和卷標。
4. 單擊 **格式化**。

![0|disk](fig/disk2.png)

> ![notes](../common/notes.svg) 說明：快速格式化速度快，但是資料仍然可能透過工具被復原，如果想要格式化後的資料無法被復原，可以取消勾選「快速格式化」，然後執行格式化操作。

## 主選單

在主選單中，您可以新增視窗、切換視窗主題、連線到伺服器、設定共享密碼（見[共享本機文件](#共享本機文件)）、設定檔案管理器、查看說明手冊和版本介紹。

### 新增視窗

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **新增視窗**，打開一個新的檔案管理器視窗。

### 連線到伺服器

透過連接伺服器[訪問共享文件](#訪問共享文件)。

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)> **連線到伺服器**。
2. 彈出「連線到伺服器」視窗，在協議下拉框中，選擇一種連接協議；在地址欄輸入伺服器IP位址。
   
   >![0|tips](../common/tips.svg) 竅門：您可以單擊 ![icon](../common/collect.svg) ，將常用伺服器地址添加到「我收藏的伺服器」列表中。
   
3. 單擊 **連線**。



### 設定

在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)> **設定**，可進行基本設定和進階設定。

#### 基本
**打開方式**

設定是否 **永遠在新視窗打開**、**滑鼠連按兩下 **或 **滑鼠按一下** 打開文件。

**新視窗與新分頁**

設定 **視窗預設打開**、**建立分頁時打開** 某個目錄。

**檢視**

設定文件圖示 **預設大小** 、**預設顯示**、是否將 **文件和資料夾混合排序**。

**隱藏文件**

- 勾選 **顯示隱藏文件**，檔案管理器中被隱藏的文件會顯示出來；
- 勾選 **顯示文件副檔名**，重新命名時不會顯示副檔名；
- 勾選 **在左方面板顯示最近文件項目**，在左側導航欄顯示最近使用的文件。



#### 進階

**索引**

- 勾選 **自動索引內部硬碟**，搜尋文件時會搜尋內部硬碟中的文件。
- 勾選 **外部裝置連上電腦時索引**，搜尋文件時也會搜尋外部裝置中的文件。
- 勾選 **全文搜尋**，透過文件中的內容來索引。

**預覽**

設定預覽文件類型。

**掛載**

- 勾選 **自動掛載**，接入外接磁碟時自動掛載。
- 勾選 **自動掛載後打開**，接入外接磁碟時自動掛載並打開該磁碟。
- 勾選 **MTP掛載路徑下顯示文件統計詳情**，MTP裝置掛載後，顯示其路徑底部的狀態欄訊息。
- 勾選 **Samba共享端常駐顯示掛載入口**，遠端掛載連結常駐顯示在導航欄中。

**對話框**

- 勾選 **使用檔案管理器的選擇文件對話框**，選擇文件時打開檔案管理器視窗；
- 勾選 **打開普通刪除提示**，刪除文件時彈出提示對話框。

**其他**

- 勾選 **隱藏系統硬碟**，導航欄和電腦介面將不顯示本機系統硬碟。
- 勾選 **隱藏迴環分區**，導航欄和電腦介面將不顯示loop裝置。
- 勾選 **在磁碟圖示上顯示文件系統標籤**。



### 主題

視窗主題包含亮色主題、暗色主題和系統主題。

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **主題**，選擇一個主題。

### 說明

查看說明手冊，進一步了解和使用檔案管理器。

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **說明**。
3. 查看檔案管理器的說明手冊。


### 關於

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **關於**。
3. 查看檔案管理器的版本和介紹。


### 退出

1. 在檔案管理器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **退出**。
